# frozen_string_literal: true

require_relative 'lib/process_executer/version'

Gem::Specification.new do |spec|
  spec.name = 'process_executer'
  spec.version = ProcessExecuter::VERSION
  spec.authors = ['James Couball']
  spec.email = ['jcouball@yahoo.com']

  spec.summary = <<~SUMMARY
    Enhanced subprocess execution with timeouts, output capture, and flexible redirection
  SUMMARY

  spec.description = <<~DESCRIPTION
    ProcessExecuter provides a simple API for running commands in a subprocess,
    with options for capturing output, handling timeouts, logging, and more.
    It also provides the MonitoredPipe class which expands the output
    redirection capabilities of Ruby's Process.spawn.
  DESCRIPTION

  spec.license = 'MIT'
  spec.required_ruby_version = '>= 3.1.0'

  spec.metadata['allowed_push_host'] = 'https://rubygems.org'

  # Project links
  spec.homepage = "https://github.com/main-branch/#{spec.name}"
  spec.metadata['homepage_uri'] = spec.homepage
  spec.metadata['source_code_uri'] = spec.homepage
  spec.metadata['documentation_uri'] = "https://rubydoc.info/gems/#{spec.name}/#{spec.version}"
  spec.metadata['changelog_uri'] = "https://rubydoc.info/gems/#{spec.name}/#{spec.version}/file/CHANGELOG.md"

  # Specify which files should be added to the gem when it is released.
  # The `find -print0` loads the files in the RubyGem that have been added into git.
  spec.files = Dir.chdir(__dir__) do
    `find -print0`.split("\x0").reject do |f|
      (f == __FILE__) || f.match(%r{\A(?:(?:bin|test|spec|features)/|\.(?:git|travis|circleci)|appveyor)})
    end
  end
  spec.bindir = 'exe'
  spec.executables = spec.files.grep(%r{\Aexe/}) { |f| File.basename(f) }
  spec.require_paths = ['lib']
  spec.requirements = [
    'Platform: Mac, Linux, or Windows',
    'Ruby: MRI 3.1 or later, TruffleRuby 24 or later, or JRuby 9.4 or later'
  ]

  spec.add_dependency 'track_open_instances', '>= 0.1'

  spec.add_development_dependency 'bundler-audit', '>= 0.9'
  spec.add_development_dependency 'create_github_release', '>= 2.1'
  spec.add_development_dependency 'main_branch_shared_rubocop_config', '>= 0.1'
  spec.add_development_dependency 'rake', '>= 13.2'
  spec.add_development_dependency 'rspec', '>= 3.13'
  spec.add_development_dependency 'rubocop', '>= 1.66'
  spec.add_development_dependency 'semverify', '>= 0.3'
  spec.add_development_dependency 'simplecov', '>= 0.22'
  spec.add_development_dependency 'simplecov-lcov', '>= 0.8'
  spec.add_development_dependency 'simplecov-rspec', '>= 0.3'

  unless RUBY_PLATFORM == 'java'
    spec.add_development_dependency 'redcarpet', '>= 3.6'
    spec.add_development_dependency 'yard', '>= 0.9', '>= 0.9.28'
    spec.add_development_dependency 'yardstick', '>= 0.9'
  end

  # For more information and examples about making a new gem, check out our
  # guide at: https://bundler.io/guides/creating_gem.html
  spec.metadata['rubygems_mfa_required'] = 'true'
end
