"""
    1Password Connect

    REST API interface for 1Password Connect.  # noqa: E501

    The version of the OpenAPI document: 1.3.0
    Contact: support@1password.com
    Generated by: https://openapi-generator.tech
"""


from inspect import getfullargspec
import pprint

class GeneratorRecipe:
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'length': 'int',
        'character_sets': 'list[str]',
        'exclude_characters': 'str'
    }

    attribute_map = {
        'length': 'length',
        'character_sets': 'characterSets',
        'exclude_characters': 'excludeCharacters'
    }

    def __init__(self, length=32, character_sets=None, exclude_characters=None, local_vars_configuration=None):  # noqa: E501
        """GeneratorRecipe - a model defined in OpenAPI"""  # noqa: E501

        self._length = None
        self._character_sets = None
        self._exclude_characters = None
        self.discriminator = None

        if length is not None:
            self.length = length
        if character_sets is not None:
            self.character_sets = character_sets
        if exclude_characters is not None:
            self.exclude_characters = exclude_characters

    @property
    def length(self):
        """Gets the length of this GeneratorRecipe.  # noqa: E501

        Length of the generated value  # noqa: E501

        :return: The length of this GeneratorRecipe.  # noqa: E501
        :rtype: int
        """
        return self._length

    @length.setter
    def length(self, length):
        """Sets the length of this GeneratorRecipe.

        Length of the generated value  # noqa: E501

        :param length: The length of this GeneratorRecipe.  # noqa: E501
        :type length: int
        """
        if (length is not None and length > 64):  # noqa: E501
            raise ValueError("Invalid value for `length`, must be a value less than or equal to `64`")  # noqa: E501
        if (length is not None and length < 1):  # noqa: E501
            raise ValueError("Invalid value for `length`, must be a value greater than or equal to `1`")  # noqa: E501

        self._length = length

    @property
    def character_sets(self):
        """Gets the character_sets of this GeneratorRecipe.  # noqa: E501


        :return: The character_sets of this GeneratorRecipe.  # noqa: E501
        :rtype: list[str]
        """
        return self._character_sets

    @character_sets.setter
    def character_sets(self, character_sets):
        """Sets the character_sets of this GeneratorRecipe.


        :param character_sets: The character_sets of this GeneratorRecipe.  # noqa: E501
        :type character_sets: list[str]
        """
        allowed_values = ["LETTERS", "DIGITS", "SYMBOLS"]  # noqa: E501
        if (not set(character_sets).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `character_sets` [{}], must be a subset of [{}]"  # noqa: E501
                .format(", ".join(map(str, set(character_sets) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._character_sets = character_sets

    @property
    def exclude_characters(self):
        """Gets the exclude_characters of this GeneratorRecipe.


        :return: The exclude_characters of this GeneratorRecipe.
        :rtype: str
        """
        return self._exclude_characters
    
    @exclude_characters.setter
    def exclude_characters(self, exclude_characters):
        """Sets the exclude_characters of this GeneratorRecipe.


        :param exclude_characters: The exclude_characters of this GeneratorRecipe.
        :type character_sets: str
        """
        duplicates = self.find_duplicates(exclude_characters)
        if duplicates:
            raise ValueError(
                "Invalid values for `exclude_characters` {0}, must not contain duplicate characters"
                .format(", ".join(map(str, duplicates)))
            )

        self._exclude_characters = exclude_characters

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr in self.openapi_types:
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GeneratorRecipe):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, GeneratorRecipe):
            return True

        return self.to_dict() != other.to_dict()

    def find_duplicates(self, s):
        char_count = {}  # Dictionary to store count of each character
        duplicates = set()  # Set to store duplicate characters

        for char in s:
            char_count[char] = char_count.get(char, 0) + 1  # Increment count of char

        for char, count in char_count.items():
            if count > 1:
                duplicates.add(char)  # If count is more than 1, it's a duplicate

        return duplicates