# -*- coding: utf-8 -*-
# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from __future__ import annotations

from typing import MutableMapping, MutableSequence

from google.protobuf import any_pb2  # type: ignore
import proto  # type: ignore

__protobuf__ = proto.module(
    package="google.cloud.compute.v1",
    manifest={
        "AWSV4Signature",
        "AbandonInstancesInstanceGroupManagerRequest",
        "AbandonInstancesRegionInstanceGroupManagerRequest",
        "AcceleratorConfig",
        "AcceleratorType",
        "AcceleratorTypeAggregatedList",
        "AcceleratorTypeList",
        "AcceleratorTypesScopedList",
        "Accelerators",
        "AccessConfig",
        "AddAccessConfigInstanceRequest",
        "AddAssociationFirewallPolicyRequest",
        "AddAssociationNetworkFirewallPolicyRequest",
        "AddAssociationRegionNetworkFirewallPolicyRequest",
        "AddHealthCheckTargetPoolRequest",
        "AddInstanceTargetPoolRequest",
        "AddInstancesInstanceGroupRequest",
        "AddNodesNodeGroupRequest",
        "AddPacketMirroringRuleNetworkFirewallPolicyRequest",
        "AddPeeringNetworkRequest",
        "AddResourcePoliciesDiskRequest",
        "AddResourcePoliciesInstanceRequest",
        "AddResourcePoliciesRegionDiskRequest",
        "AddRuleFirewallPolicyRequest",
        "AddRuleNetworkFirewallPolicyRequest",
        "AddRuleRegionNetworkFirewallPolicyRequest",
        "AddRuleRegionSecurityPolicyRequest",
        "AddRuleSecurityPolicyRequest",
        "AddSignedUrlKeyBackendBucketRequest",
        "AddSignedUrlKeyBackendServiceRequest",
        "Address",
        "AddressAggregatedList",
        "AddressList",
        "AddressesScopedList",
        "AdvancedMachineFeatures",
        "AggregatedListAcceleratorTypesRequest",
        "AggregatedListAddressesRequest",
        "AggregatedListAutoscalersRequest",
        "AggregatedListBackendServicesRequest",
        "AggregatedListDiskTypesRequest",
        "AggregatedListDisksRequest",
        "AggregatedListForwardingRulesRequest",
        "AggregatedListGlobalOperationsRequest",
        "AggregatedListHealthChecksRequest",
        "AggregatedListInstanceGroupManagersRequest",
        "AggregatedListInstanceGroupsRequest",
        "AggregatedListInstanceTemplatesRequest",
        "AggregatedListInstancesRequest",
        "AggregatedListInstantSnapshotsRequest",
        "AggregatedListInterconnectAttachmentsRequest",
        "AggregatedListMachineTypesRequest",
        "AggregatedListNetworkAttachmentsRequest",
        "AggregatedListNetworkEdgeSecurityServicesRequest",
        "AggregatedListNetworkEndpointGroupsRequest",
        "AggregatedListNetworkFirewallPoliciesRequest",
        "AggregatedListNodeGroupsRequest",
        "AggregatedListNodeTemplatesRequest",
        "AggregatedListNodeTypesRequest",
        "AggregatedListPacketMirroringsRequest",
        "AggregatedListPublicDelegatedPrefixesRequest",
        "AggregatedListRegionCommitmentsRequest",
        "AggregatedListReservationsRequest",
        "AggregatedListResourcePoliciesRequest",
        "AggregatedListRoutersRequest",
        "AggregatedListSecurityPoliciesRequest",
        "AggregatedListServiceAttachmentsRequest",
        "AggregatedListSslCertificatesRequest",
        "AggregatedListSslPoliciesRequest",
        "AggregatedListStoragePoolTypesRequest",
        "AggregatedListStoragePoolsRequest",
        "AggregatedListSubnetworksRequest",
        "AggregatedListTargetHttpProxiesRequest",
        "AggregatedListTargetHttpsProxiesRequest",
        "AggregatedListTargetInstancesRequest",
        "AggregatedListTargetPoolsRequest",
        "AggregatedListTargetTcpProxiesRequest",
        "AggregatedListTargetVpnGatewaysRequest",
        "AggregatedListUrlMapsRequest",
        "AggregatedListVpnGatewaysRequest",
        "AggregatedListVpnTunnelsRequest",
        "AliasIpRange",
        "AllocationAggregateReservation",
        "AllocationAggregateReservationReservedResourceInfo",
        "AllocationAggregateReservationReservedResourceInfoAccelerator",
        "AllocationReservationSharingPolicy",
        "AllocationResourceStatus",
        "AllocationResourceStatusSpecificSKUAllocation",
        "AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
        "AllocationSpecificSKUAllocationReservedInstanceProperties",
        "AllocationSpecificSKUReservation",
        "Allowed",
        "AnnouncePublicAdvertisedPrefixeRequest",
        "AnnouncePublicDelegatedPrefixeRequest",
        "ApplyUpdatesToInstancesInstanceGroupManagerRequest",
        "ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest",
        "AttachDiskInstanceRequest",
        "AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
        "AttachNetworkEndpointsNetworkEndpointGroupRequest",
        "AttachNetworkEndpointsRegionNetworkEndpointGroupRequest",
        "AttachedDisk",
        "AttachedDiskInitializeParams",
        "AuditConfig",
        "AuditLogConfig",
        "Autoscaler",
        "AutoscalerAggregatedList",
        "AutoscalerList",
        "AutoscalerStatusDetails",
        "AutoscalersScopedList",
        "AutoscalingPolicy",
        "AutoscalingPolicyCpuUtilization",
        "AutoscalingPolicyCustomMetricUtilization",
        "AutoscalingPolicyLoadBalancingUtilization",
        "AutoscalingPolicyScaleInControl",
        "AutoscalingPolicyScalingSchedule",
        "Backend",
        "BackendBucket",
        "BackendBucketCdnPolicy",
        "BackendBucketCdnPolicyBypassCacheOnRequestHeader",
        "BackendBucketCdnPolicyCacheKeyPolicy",
        "BackendBucketCdnPolicyNegativeCachingPolicy",
        "BackendBucketList",
        "BackendBucketUsedBy",
        "BackendCustomMetric",
        "BackendService",
        "BackendServiceAggregatedList",
        "BackendServiceCdnPolicy",
        "BackendServiceCdnPolicyBypassCacheOnRequestHeader",
        "BackendServiceCdnPolicyNegativeCachingPolicy",
        "BackendServiceConnectionTrackingPolicy",
        "BackendServiceCustomMetric",
        "BackendServiceFailoverPolicy",
        "BackendServiceGroupHealth",
        "BackendServiceHAPolicy",
        "BackendServiceHttpCookie",
        "BackendServiceIAP",
        "BackendServiceList",
        "BackendServiceListUsable",
        "BackendServiceLocalityLoadBalancingPolicyConfig",
        "BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy",
        "BackendServiceLocalityLoadBalancingPolicyConfigPolicy",
        "BackendServiceLogConfig",
        "BackendServiceReference",
        "BackendServiceUsedBy",
        "BackendServicesScopedList",
        "BfdPacket",
        "BfdStatus",
        "BfdStatusPacketCounts",
        "BgpRoute",
        "BgpRouteAsPath",
        "BgpRouteNetworkLayerReachabilityInformation",
        "Binding",
        "BulkInsertDiskRequest",
        "BulkInsertDiskResource",
        "BulkInsertInstanceRequest",
        "BulkInsertInstanceResource",
        "BulkInsertInstanceResourcePerInstanceProperties",
        "BulkInsertOperationStatus",
        "BulkInsertRegionDiskRequest",
        "BulkInsertRegionInstanceRequest",
        "CacheInvalidationRule",
        "CacheKeyPolicy",
        "CancelInstanceGroupManagerResizeRequestRequest",
        "CircuitBreakers",
        "CloneRulesFirewallPolicyRequest",
        "CloneRulesNetworkFirewallPolicyRequest",
        "CloneRulesRegionNetworkFirewallPolicyRequest",
        "Commitment",
        "CommitmentAggregatedList",
        "CommitmentList",
        "CommitmentResourceStatus",
        "CommitmentsScopedList",
        "ConfidentialInstanceConfig",
        "ConnectionDraining",
        "ConsistentHashLoadBalancerSettings",
        "ConsistentHashLoadBalancerSettingsHttpCookie",
        "CorsPolicy",
        "CreateInstancesInstanceGroupManagerRequest",
        "CreateInstancesRegionInstanceGroupManagerRequest",
        "CreateSnapshotDiskRequest",
        "CreateSnapshotRegionDiskRequest",
        "CustomErrorResponsePolicy",
        "CustomErrorResponsePolicyCustomErrorResponseRule",
        "CustomerEncryptionKey",
        "CustomerEncryptionKeyProtectedDisk",
        "Data",
        "DeleteAccessConfigInstanceRequest",
        "DeleteAddressRequest",
        "DeleteAutoscalerRequest",
        "DeleteBackendBucketRequest",
        "DeleteBackendServiceRequest",
        "DeleteDiskRequest",
        "DeleteExternalVpnGatewayRequest",
        "DeleteFirewallPolicyRequest",
        "DeleteFirewallRequest",
        "DeleteForwardingRuleRequest",
        "DeleteGlobalAddressRequest",
        "DeleteGlobalForwardingRuleRequest",
        "DeleteGlobalNetworkEndpointGroupRequest",
        "DeleteGlobalOperationRequest",
        "DeleteGlobalOperationResponse",
        "DeleteGlobalOrganizationOperationRequest",
        "DeleteGlobalOrganizationOperationResponse",
        "DeleteGlobalPublicDelegatedPrefixeRequest",
        "DeleteHealthCheckRequest",
        "DeleteImageRequest",
        "DeleteInstanceGroupManagerRequest",
        "DeleteInstanceGroupManagerResizeRequestRequest",
        "DeleteInstanceGroupRequest",
        "DeleteInstanceRequest",
        "DeleteInstanceTemplateRequest",
        "DeleteInstancesInstanceGroupManagerRequest",
        "DeleteInstancesRegionInstanceGroupManagerRequest",
        "DeleteInstantSnapshotRequest",
        "DeleteInterconnectAttachmentRequest",
        "DeleteInterconnectRequest",
        "DeleteLicenseRequest",
        "DeleteMachineImageRequest",
        "DeleteNetworkAttachmentRequest",
        "DeleteNetworkEdgeSecurityServiceRequest",
        "DeleteNetworkEndpointGroupRequest",
        "DeleteNetworkFirewallPolicyRequest",
        "DeleteNetworkRequest",
        "DeleteNodeGroupRequest",
        "DeleteNodeTemplateRequest",
        "DeleteNodesNodeGroupRequest",
        "DeletePacketMirroringRequest",
        "DeletePerInstanceConfigsInstanceGroupManagerRequest",
        "DeletePerInstanceConfigsRegionInstanceGroupManagerRequest",
        "DeletePublicAdvertisedPrefixeRequest",
        "DeletePublicDelegatedPrefixeRequest",
        "DeleteRegionAutoscalerRequest",
        "DeleteRegionBackendServiceRequest",
        "DeleteRegionDiskRequest",
        "DeleteRegionHealthCheckRequest",
        "DeleteRegionHealthCheckServiceRequest",
        "DeleteRegionInstanceGroupManagerRequest",
        "DeleteRegionInstanceTemplateRequest",
        "DeleteRegionInstantSnapshotRequest",
        "DeleteRegionNetworkEndpointGroupRequest",
        "DeleteRegionNetworkFirewallPolicyRequest",
        "DeleteRegionNotificationEndpointRequest",
        "DeleteRegionOperationRequest",
        "DeleteRegionOperationResponse",
        "DeleteRegionSecurityPolicyRequest",
        "DeleteRegionSslCertificateRequest",
        "DeleteRegionSslPolicyRequest",
        "DeleteRegionTargetHttpProxyRequest",
        "DeleteRegionTargetHttpsProxyRequest",
        "DeleteRegionTargetTcpProxyRequest",
        "DeleteRegionUrlMapRequest",
        "DeleteReservationRequest",
        "DeleteResourcePolicyRequest",
        "DeleteRoutePolicyRouterRequest",
        "DeleteRouteRequest",
        "DeleteRouterRequest",
        "DeleteSecurityPolicyRequest",
        "DeleteServiceAttachmentRequest",
        "DeleteSignedUrlKeyBackendBucketRequest",
        "DeleteSignedUrlKeyBackendServiceRequest",
        "DeleteSnapshotRequest",
        "DeleteSslCertificateRequest",
        "DeleteSslPolicyRequest",
        "DeleteStoragePoolRequest",
        "DeleteSubnetworkRequest",
        "DeleteTargetGrpcProxyRequest",
        "DeleteTargetHttpProxyRequest",
        "DeleteTargetHttpsProxyRequest",
        "DeleteTargetInstanceRequest",
        "DeleteTargetPoolRequest",
        "DeleteTargetSslProxyRequest",
        "DeleteTargetTcpProxyRequest",
        "DeleteTargetVpnGatewayRequest",
        "DeleteUrlMapRequest",
        "DeleteVpnGatewayRequest",
        "DeleteVpnTunnelRequest",
        "DeleteZoneOperationRequest",
        "DeleteZoneOperationResponse",
        "Denied",
        "DeprecateImageRequest",
        "DeprecationStatus",
        "DetachDiskInstanceRequest",
        "DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
        "DetachNetworkEndpointsNetworkEndpointGroupRequest",
        "DetachNetworkEndpointsRegionNetworkEndpointGroupRequest",
        "DisableXpnHostProjectRequest",
        "DisableXpnResourceProjectRequest",
        "Disk",
        "DiskAggregatedList",
        "DiskAsyncReplication",
        "DiskAsyncReplicationList",
        "DiskInstantiationConfig",
        "DiskList",
        "DiskMoveRequest",
        "DiskParams",
        "DiskResourceStatus",
        "DiskResourceStatusAsyncReplicationStatus",
        "DiskType",
        "DiskTypeAggregatedList",
        "DiskTypeList",
        "DiskTypesScopedList",
        "DisksAddResourcePoliciesRequest",
        "DisksRemoveResourcePoliciesRequest",
        "DisksResizeRequest",
        "DisksScopedList",
        "DisksStartAsyncReplicationRequest",
        "DisksStopGroupAsyncReplicationResource",
        "DisplayDevice",
        "DistributionPolicy",
        "DistributionPolicyZoneConfiguration",
        "Duration",
        "EnableXpnHostProjectRequest",
        "EnableXpnResourceProjectRequest",
        "Error",
        "ErrorDetails",
        "ErrorInfo",
        "Errors",
        "ExchangedPeeringRoute",
        "ExchangedPeeringRoutesList",
        "ExpandIpCidrRangeSubnetworkRequest",
        "Expr",
        "ExternalVpnGateway",
        "ExternalVpnGatewayInterface",
        "ExternalVpnGatewayList",
        "FileContentBuffer",
        "Firewall",
        "FirewallList",
        "FirewallLogConfig",
        "FirewallPoliciesListAssociationsResponse",
        "FirewallPoliciesScopedList",
        "FirewallPolicy",
        "FirewallPolicyAssociation",
        "FirewallPolicyList",
        "FirewallPolicyRule",
        "FirewallPolicyRuleMatcher",
        "FirewallPolicyRuleMatcherLayer4Config",
        "FirewallPolicyRuleSecureTag",
        "FixedOrPercent",
        "ForwardingRule",
        "ForwardingRuleAggregatedList",
        "ForwardingRuleList",
        "ForwardingRuleReference",
        "ForwardingRuleServiceDirectoryRegistration",
        "ForwardingRulesScopedList",
        "GRPCHealthCheck",
        "GetAcceleratorTypeRequest",
        "GetAddressRequest",
        "GetAssociationFirewallPolicyRequest",
        "GetAssociationNetworkFirewallPolicyRequest",
        "GetAssociationRegionNetworkFirewallPolicyRequest",
        "GetAutoscalerRequest",
        "GetBackendBucketRequest",
        "GetBackendServiceRequest",
        "GetDiagnosticsInterconnectRequest",
        "GetDiskRequest",
        "GetDiskTypeRequest",
        "GetEffectiveFirewallsInstanceRequest",
        "GetEffectiveFirewallsNetworkRequest",
        "GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest",
        "GetExternalVpnGatewayRequest",
        "GetFirewallPolicyRequest",
        "GetFirewallRequest",
        "GetForwardingRuleRequest",
        "GetFromFamilyImageRequest",
        "GetGlobalAddressRequest",
        "GetGlobalForwardingRuleRequest",
        "GetGlobalNetworkEndpointGroupRequest",
        "GetGlobalOperationRequest",
        "GetGlobalOrganizationOperationRequest",
        "GetGlobalPublicDelegatedPrefixeRequest",
        "GetGuestAttributesInstanceRequest",
        "GetHealthBackendServiceRequest",
        "GetHealthCheckRequest",
        "GetHealthRegionBackendServiceRequest",
        "GetHealthTargetPoolRequest",
        "GetIamPolicyBackendBucketRequest",
        "GetIamPolicyBackendServiceRequest",
        "GetIamPolicyDiskRequest",
        "GetIamPolicyFirewallPolicyRequest",
        "GetIamPolicyImageRequest",
        "GetIamPolicyInstanceRequest",
        "GetIamPolicyInstanceTemplateRequest",
        "GetIamPolicyInstantSnapshotRequest",
        "GetIamPolicyLicenseRequest",
        "GetIamPolicyMachineImageRequest",
        "GetIamPolicyNetworkAttachmentRequest",
        "GetIamPolicyNetworkFirewallPolicyRequest",
        "GetIamPolicyNodeGroupRequest",
        "GetIamPolicyNodeTemplateRequest",
        "GetIamPolicyRegionBackendServiceRequest",
        "GetIamPolicyRegionDiskRequest",
        "GetIamPolicyRegionInstantSnapshotRequest",
        "GetIamPolicyRegionNetworkFirewallPolicyRequest",
        "GetIamPolicyReservationRequest",
        "GetIamPolicyResourcePolicyRequest",
        "GetIamPolicyServiceAttachmentRequest",
        "GetIamPolicySnapshotRequest",
        "GetIamPolicyStoragePoolRequest",
        "GetIamPolicySubnetworkRequest",
        "GetImageFamilyViewRequest",
        "GetImageRequest",
        "GetInstanceGroupManagerRequest",
        "GetInstanceGroupManagerResizeRequestRequest",
        "GetInstanceGroupRequest",
        "GetInstanceRequest",
        "GetInstanceSettingRequest",
        "GetInstanceTemplateRequest",
        "GetInstantSnapshotRequest",
        "GetInterconnectAttachmentRequest",
        "GetInterconnectLocationRequest",
        "GetInterconnectRemoteLocationRequest",
        "GetInterconnectRequest",
        "GetLicenseCodeRequest",
        "GetLicenseRequest",
        "GetMachineImageRequest",
        "GetMachineTypeRequest",
        "GetMacsecConfigInterconnectRequest",
        "GetNatIpInfoRouterRequest",
        "GetNatMappingInfoRoutersRequest",
        "GetNetworkAttachmentRequest",
        "GetNetworkEdgeSecurityServiceRequest",
        "GetNetworkEndpointGroupRequest",
        "GetNetworkFirewallPolicyRequest",
        "GetNetworkProfileRequest",
        "GetNetworkRequest",
        "GetNodeGroupRequest",
        "GetNodeTemplateRequest",
        "GetNodeTypeRequest",
        "GetPacketMirroringRequest",
        "GetPacketMirroringRuleNetworkFirewallPolicyRequest",
        "GetProjectRequest",
        "GetPublicAdvertisedPrefixeRequest",
        "GetPublicDelegatedPrefixeRequest",
        "GetRegionAutoscalerRequest",
        "GetRegionBackendServiceRequest",
        "GetRegionCommitmentRequest",
        "GetRegionDiskRequest",
        "GetRegionDiskTypeRequest",
        "GetRegionHealthCheckRequest",
        "GetRegionHealthCheckServiceRequest",
        "GetRegionInstanceGroupManagerRequest",
        "GetRegionInstanceGroupRequest",
        "GetRegionInstanceTemplateRequest",
        "GetRegionInstantSnapshotRequest",
        "GetRegionNetworkEndpointGroupRequest",
        "GetRegionNetworkFirewallPolicyRequest",
        "GetRegionNotificationEndpointRequest",
        "GetRegionOperationRequest",
        "GetRegionRequest",
        "GetRegionSecurityPolicyRequest",
        "GetRegionSslCertificateRequest",
        "GetRegionSslPolicyRequest",
        "GetRegionTargetHttpProxyRequest",
        "GetRegionTargetHttpsProxyRequest",
        "GetRegionTargetTcpProxyRequest",
        "GetRegionUrlMapRequest",
        "GetReservationBlockRequest",
        "GetReservationRequest",
        "GetResourcePolicyRequest",
        "GetRoutePolicyRouterRequest",
        "GetRouteRequest",
        "GetRouterRequest",
        "GetRouterStatusRouterRequest",
        "GetRuleFirewallPolicyRequest",
        "GetRuleNetworkFirewallPolicyRequest",
        "GetRuleRegionNetworkFirewallPolicyRequest",
        "GetRuleRegionSecurityPolicyRequest",
        "GetRuleSecurityPolicyRequest",
        "GetScreenshotInstanceRequest",
        "GetSecurityPolicyRequest",
        "GetSerialPortOutputInstanceRequest",
        "GetServiceAttachmentRequest",
        "GetShieldedInstanceIdentityInstanceRequest",
        "GetSnapshotRequest",
        "GetSnapshotSettingRequest",
        "GetSslCertificateRequest",
        "GetSslPolicyRequest",
        "GetStatusVpnGatewayRequest",
        "GetStoragePoolRequest",
        "GetStoragePoolTypeRequest",
        "GetSubnetworkRequest",
        "GetTargetGrpcProxyRequest",
        "GetTargetHttpProxyRequest",
        "GetTargetHttpsProxyRequest",
        "GetTargetInstanceRequest",
        "GetTargetPoolRequest",
        "GetTargetSslProxyRequest",
        "GetTargetTcpProxyRequest",
        "GetTargetVpnGatewayRequest",
        "GetUrlMapRequest",
        "GetVpnGatewayRequest",
        "GetVpnTunnelRequest",
        "GetXpnHostProjectRequest",
        "GetXpnResourcesProjectsRequest",
        "GetZoneOperationRequest",
        "GetZoneRequest",
        "GlobalAddressesMoveRequest",
        "GlobalNetworkEndpointGroupsAttachEndpointsRequest",
        "GlobalNetworkEndpointGroupsDetachEndpointsRequest",
        "GlobalOrganizationSetPolicyRequest",
        "GlobalSetLabelsRequest",
        "GlobalSetPolicyRequest",
        "GroupMaintenanceInfo",
        "GuestAttributes",
        "GuestAttributesEntry",
        "GuestAttributesValue",
        "GuestOsFeature",
        "HTTP2HealthCheck",
        "HTTPHealthCheck",
        "HTTPSHealthCheck",
        "HealthCheck",
        "HealthCheckList",
        "HealthCheckLogConfig",
        "HealthCheckReference",
        "HealthCheckService",
        "HealthCheckServiceReference",
        "HealthCheckServicesList",
        "HealthChecksAggregatedList",
        "HealthChecksScopedList",
        "HealthStatus",
        "HealthStatusForNetworkEndpoint",
        "Help",
        "HelpLink",
        "HostRule",
        "HttpFaultAbort",
        "HttpFaultDelay",
        "HttpFaultInjection",
        "HttpHeaderAction",
        "HttpHeaderMatch",
        "HttpHeaderOption",
        "HttpQueryParameterMatch",
        "HttpRedirectAction",
        "HttpRetryPolicy",
        "HttpRouteAction",
        "HttpRouteRule",
        "HttpRouteRuleMatch",
        "Image",
        "ImageFamilyView",
        "ImageList",
        "InitialStateConfig",
        "InsertAddressRequest",
        "InsertAutoscalerRequest",
        "InsertBackendBucketRequest",
        "InsertBackendServiceRequest",
        "InsertDiskRequest",
        "InsertExternalVpnGatewayRequest",
        "InsertFirewallPolicyRequest",
        "InsertFirewallRequest",
        "InsertForwardingRuleRequest",
        "InsertGlobalAddressRequest",
        "InsertGlobalForwardingRuleRequest",
        "InsertGlobalNetworkEndpointGroupRequest",
        "InsertGlobalPublicDelegatedPrefixeRequest",
        "InsertHealthCheckRequest",
        "InsertImageRequest",
        "InsertInstanceGroupManagerRequest",
        "InsertInstanceGroupManagerResizeRequestRequest",
        "InsertInstanceGroupRequest",
        "InsertInstanceRequest",
        "InsertInstanceTemplateRequest",
        "InsertInstantSnapshotRequest",
        "InsertInterconnectAttachmentRequest",
        "InsertInterconnectRequest",
        "InsertLicenseRequest",
        "InsertMachineImageRequest",
        "InsertNetworkAttachmentRequest",
        "InsertNetworkEdgeSecurityServiceRequest",
        "InsertNetworkEndpointGroupRequest",
        "InsertNetworkFirewallPolicyRequest",
        "InsertNetworkRequest",
        "InsertNodeGroupRequest",
        "InsertNodeTemplateRequest",
        "InsertPacketMirroringRequest",
        "InsertPublicAdvertisedPrefixeRequest",
        "InsertPublicDelegatedPrefixeRequest",
        "InsertRegionAutoscalerRequest",
        "InsertRegionBackendServiceRequest",
        "InsertRegionCommitmentRequest",
        "InsertRegionDiskRequest",
        "InsertRegionHealthCheckRequest",
        "InsertRegionHealthCheckServiceRequest",
        "InsertRegionInstanceGroupManagerRequest",
        "InsertRegionInstanceTemplateRequest",
        "InsertRegionInstantSnapshotRequest",
        "InsertRegionNetworkEndpointGroupRequest",
        "InsertRegionNetworkFirewallPolicyRequest",
        "InsertRegionNotificationEndpointRequest",
        "InsertRegionSecurityPolicyRequest",
        "InsertRegionSslCertificateRequest",
        "InsertRegionSslPolicyRequest",
        "InsertRegionTargetHttpProxyRequest",
        "InsertRegionTargetHttpsProxyRequest",
        "InsertRegionTargetTcpProxyRequest",
        "InsertRegionUrlMapRequest",
        "InsertReservationRequest",
        "InsertResourcePolicyRequest",
        "InsertRouteRequest",
        "InsertRouterRequest",
        "InsertSecurityPolicyRequest",
        "InsertServiceAttachmentRequest",
        "InsertSnapshotRequest",
        "InsertSslCertificateRequest",
        "InsertSslPolicyRequest",
        "InsertStoragePoolRequest",
        "InsertSubnetworkRequest",
        "InsertTargetGrpcProxyRequest",
        "InsertTargetHttpProxyRequest",
        "InsertTargetHttpsProxyRequest",
        "InsertTargetInstanceRequest",
        "InsertTargetPoolRequest",
        "InsertTargetSslProxyRequest",
        "InsertTargetTcpProxyRequest",
        "InsertTargetVpnGatewayRequest",
        "InsertUrlMapRequest",
        "InsertVpnGatewayRequest",
        "InsertVpnTunnelRequest",
        "Instance",
        "InstanceAggregatedList",
        "InstanceConsumptionData",
        "InstanceConsumptionInfo",
        "InstanceGroup",
        "InstanceGroupAggregatedList",
        "InstanceGroupList",
        "InstanceGroupManager",
        "InstanceGroupManagerActionsSummary",
        "InstanceGroupManagerAggregatedList",
        "InstanceGroupManagerAllInstancesConfig",
        "InstanceGroupManagerAutoHealingPolicy",
        "InstanceGroupManagerInstanceFlexibilityPolicy",
        "InstanceGroupManagerInstanceFlexibilityPolicyInstanceSelection",
        "InstanceGroupManagerInstanceLifecyclePolicy",
        "InstanceGroupManagerList",
        "InstanceGroupManagerResizeRequest",
        "InstanceGroupManagerResizeRequestStatus",
        "InstanceGroupManagerResizeRequestStatusLastAttempt",
        "InstanceGroupManagerResizeRequestsListResponse",
        "InstanceGroupManagerResourcePolicies",
        "InstanceGroupManagerStandbyPolicy",
        "InstanceGroupManagerStatus",
        "InstanceGroupManagerStatusAllInstancesConfig",
        "InstanceGroupManagerStatusStateful",
        "InstanceGroupManagerStatusStatefulPerInstanceConfigs",
        "InstanceGroupManagerStatusVersionTarget",
        "InstanceGroupManagerUpdatePolicy",
        "InstanceGroupManagerVersion",
        "InstanceGroupManagersAbandonInstancesRequest",
        "InstanceGroupManagersApplyUpdatesRequest",
        "InstanceGroupManagersCreateInstancesRequest",
        "InstanceGroupManagersDeleteInstancesRequest",
        "InstanceGroupManagersDeletePerInstanceConfigsReq",
        "InstanceGroupManagersListErrorsResponse",
        "InstanceGroupManagersListManagedInstancesResponse",
        "InstanceGroupManagersListPerInstanceConfigsResp",
        "InstanceGroupManagersPatchPerInstanceConfigsReq",
        "InstanceGroupManagersRecreateInstancesRequest",
        "InstanceGroupManagersResumeInstancesRequest",
        "InstanceGroupManagersScopedList",
        "InstanceGroupManagersSetInstanceTemplateRequest",
        "InstanceGroupManagersSetTargetPoolsRequest",
        "InstanceGroupManagersStartInstancesRequest",
        "InstanceGroupManagersStopInstancesRequest",
        "InstanceGroupManagersSuspendInstancesRequest",
        "InstanceGroupManagersUpdatePerInstanceConfigsReq",
        "InstanceGroupsAddInstancesRequest",
        "InstanceGroupsListInstances",
        "InstanceGroupsListInstancesRequest",
        "InstanceGroupsRemoveInstancesRequest",
        "InstanceGroupsScopedList",
        "InstanceGroupsSetNamedPortsRequest",
        "InstanceList",
        "InstanceListReferrers",
        "InstanceManagedByIgmError",
        "InstanceManagedByIgmErrorInstanceActionDetails",
        "InstanceManagedByIgmErrorManagedInstanceError",
        "InstanceMoveRequest",
        "InstanceParams",
        "InstanceProperties",
        "InstancePropertiesPatch",
        "InstanceReference",
        "InstanceSettings",
        "InstanceSettingsMetadata",
        "InstanceTemplate",
        "InstanceTemplateAggregatedList",
        "InstanceTemplateList",
        "InstanceTemplatesScopedList",
        "InstanceWithNamedPorts",
        "InstancesAddResourcePoliciesRequest",
        "InstancesBulkInsertOperationMetadata",
        "InstancesGetEffectiveFirewallsResponse",
        "InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
        "InstancesRemoveResourcePoliciesRequest",
        "InstancesReportHostAsFaultyRequest",
        "InstancesReportHostAsFaultyRequestFaultReason",
        "InstancesScopedList",
        "InstancesSetLabelsRequest",
        "InstancesSetMachineResourcesRequest",
        "InstancesSetMachineTypeRequest",
        "InstancesSetMinCpuPlatformRequest",
        "InstancesSetNameRequest",
        "InstancesSetSecurityPolicyRequest",
        "InstancesSetServiceAccountRequest",
        "InstancesStartWithEncryptionKeyRequest",
        "InstantSnapshot",
        "InstantSnapshotAggregatedList",
        "InstantSnapshotList",
        "InstantSnapshotResourceStatus",
        "InstantSnapshotsScopedList",
        "Int64RangeMatch",
        "Interconnect",
        "InterconnectAttachment",
        "InterconnectAttachmentAggregatedList",
        "InterconnectAttachmentConfigurationConstraints",
        "InterconnectAttachmentConfigurationConstraintsBgpPeerASNRange",
        "InterconnectAttachmentList",
        "InterconnectAttachmentPartnerMetadata",
        "InterconnectAttachmentPrivateInfo",
        "InterconnectAttachmentsScopedList",
        "InterconnectCircuitInfo",
        "InterconnectDiagnostics",
        "InterconnectDiagnosticsARPEntry",
        "InterconnectDiagnosticsLinkLACPStatus",
        "InterconnectDiagnosticsLinkOpticalPower",
        "InterconnectDiagnosticsLinkStatus",
        "InterconnectDiagnosticsMacsecStatus",
        "InterconnectList",
        "InterconnectLocation",
        "InterconnectLocationList",
        "InterconnectLocationRegionInfo",
        "InterconnectMacsec",
        "InterconnectMacsecConfig",
        "InterconnectMacsecConfigPreSharedKey",
        "InterconnectMacsecPreSharedKey",
        "InterconnectOutageNotification",
        "InterconnectRemoteLocation",
        "InterconnectRemoteLocationConstraints",
        "InterconnectRemoteLocationConstraintsSubnetLengthRange",
        "InterconnectRemoteLocationList",
        "InterconnectRemoteLocationPermittedConnections",
        "InterconnectsGetDiagnosticsResponse",
        "InterconnectsGetMacsecConfigResponse",
        "InvalidateCacheUrlMapRequest",
        "Items",
        "License",
        "LicenseCode",
        "LicenseCodeLicenseAlias",
        "LicenseResourceCommitment",
        "LicenseResourceRequirements",
        "LicensesListResponse",
        "ListAcceleratorTypesRequest",
        "ListAddressesRequest",
        "ListAssociationsFirewallPolicyRequest",
        "ListAutoscalersRequest",
        "ListAvailableFeaturesRegionSslPoliciesRequest",
        "ListAvailableFeaturesSslPoliciesRequest",
        "ListBackendBucketsRequest",
        "ListBackendServicesRequest",
        "ListBgpRoutesRoutersRequest",
        "ListDiskTypesRequest",
        "ListDisksRequest",
        "ListDisksStoragePoolsRequest",
        "ListErrorsInstanceGroupManagersRequest",
        "ListErrorsRegionInstanceGroupManagersRequest",
        "ListExternalVpnGatewaysRequest",
        "ListFirewallPoliciesRequest",
        "ListFirewallsRequest",
        "ListForwardingRulesRequest",
        "ListGlobalAddressesRequest",
        "ListGlobalForwardingRulesRequest",
        "ListGlobalNetworkEndpointGroupsRequest",
        "ListGlobalOperationsRequest",
        "ListGlobalOrganizationOperationsRequest",
        "ListGlobalPublicDelegatedPrefixesRequest",
        "ListHealthChecksRequest",
        "ListImagesRequest",
        "ListInstanceGroupManagerResizeRequestsRequest",
        "ListInstanceGroupManagersRequest",
        "ListInstanceGroupsRequest",
        "ListInstanceTemplatesRequest",
        "ListInstancesInstanceGroupsRequest",
        "ListInstancesRegionInstanceGroupsRequest",
        "ListInstancesRequest",
        "ListInstantSnapshotsRequest",
        "ListInterconnectAttachmentsRequest",
        "ListInterconnectLocationsRequest",
        "ListInterconnectRemoteLocationsRequest",
        "ListInterconnectsRequest",
        "ListLicensesRequest",
        "ListMachineImagesRequest",
        "ListMachineTypesRequest",
        "ListManagedInstancesInstanceGroupManagersRequest",
        "ListManagedInstancesRegionInstanceGroupManagersRequest",
        "ListNetworkAttachmentsRequest",
        "ListNetworkEndpointGroupsRequest",
        "ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest",
        "ListNetworkEndpointsNetworkEndpointGroupsRequest",
        "ListNetworkEndpointsRegionNetworkEndpointGroupsRequest",
        "ListNetworkFirewallPoliciesRequest",
        "ListNetworkProfilesRequest",
        "ListNetworksRequest",
        "ListNodeGroupsRequest",
        "ListNodeTemplatesRequest",
        "ListNodeTypesRequest",
        "ListNodesNodeGroupsRequest",
        "ListPacketMirroringsRequest",
        "ListPeeringRoutesNetworksRequest",
        "ListPerInstanceConfigsInstanceGroupManagersRequest",
        "ListPerInstanceConfigsRegionInstanceGroupManagersRequest",
        "ListPreconfiguredExpressionSetsSecurityPoliciesRequest",
        "ListPublicAdvertisedPrefixesRequest",
        "ListPublicDelegatedPrefixesRequest",
        "ListReferrersInstancesRequest",
        "ListRegionAutoscalersRequest",
        "ListRegionBackendServicesRequest",
        "ListRegionCommitmentsRequest",
        "ListRegionDiskTypesRequest",
        "ListRegionDisksRequest",
        "ListRegionHealthCheckServicesRequest",
        "ListRegionHealthChecksRequest",
        "ListRegionInstanceGroupManagersRequest",
        "ListRegionInstanceGroupsRequest",
        "ListRegionInstanceTemplatesRequest",
        "ListRegionInstantSnapshotsRequest",
        "ListRegionNetworkEndpointGroupsRequest",
        "ListRegionNetworkFirewallPoliciesRequest",
        "ListRegionNotificationEndpointsRequest",
        "ListRegionOperationsRequest",
        "ListRegionSecurityPoliciesRequest",
        "ListRegionSslCertificatesRequest",
        "ListRegionSslPoliciesRequest",
        "ListRegionTargetHttpProxiesRequest",
        "ListRegionTargetHttpsProxiesRequest",
        "ListRegionTargetTcpProxiesRequest",
        "ListRegionUrlMapsRequest",
        "ListRegionZonesRequest",
        "ListRegionsRequest",
        "ListReservationBlocksRequest",
        "ListReservationsRequest",
        "ListResourcePoliciesRequest",
        "ListRoutePoliciesRoutersRequest",
        "ListRoutersRequest",
        "ListRoutesRequest",
        "ListSecurityPoliciesRequest",
        "ListServiceAttachmentsRequest",
        "ListSnapshotsRequest",
        "ListSslCertificatesRequest",
        "ListSslPoliciesRequest",
        "ListStoragePoolTypesRequest",
        "ListStoragePoolsRequest",
        "ListSubnetworksRequest",
        "ListTargetGrpcProxiesRequest",
        "ListTargetHttpProxiesRequest",
        "ListTargetHttpsProxiesRequest",
        "ListTargetInstancesRequest",
        "ListTargetPoolsRequest",
        "ListTargetSslProxiesRequest",
        "ListTargetTcpProxiesRequest",
        "ListTargetVpnGatewaysRequest",
        "ListUrlMapsRequest",
        "ListUsableBackendServicesRequest",
        "ListUsableRegionBackendServicesRequest",
        "ListUsableSubnetworksRequest",
        "ListVpnGatewaysRequest",
        "ListVpnTunnelsRequest",
        "ListXpnHostsProjectsRequest",
        "ListZoneOperationsRequest",
        "ListZonesRequest",
        "LocalDisk",
        "LocalizedMessage",
        "LocationPolicy",
        "LocationPolicyLocation",
        "LocationPolicyLocationConstraints",
        "MachineImage",
        "MachineImageList",
        "MachineType",
        "MachineTypeAggregatedList",
        "MachineTypeList",
        "MachineTypesScopedList",
        "ManagedInstance",
        "ManagedInstanceInstanceHealth",
        "ManagedInstanceLastAttempt",
        "ManagedInstanceLastAttemptErrors",
        "ManagedInstancePropertiesFromFlexibilityPolicy",
        "ManagedInstanceVersion",
        "Metadata",
        "MetadataFilter",
        "MetadataFilterLabelMatch",
        "MoveAddressRequest",
        "MoveDiskProjectRequest",
        "MoveFirewallPolicyRequest",
        "MoveGlobalAddressRequest",
        "MoveInstanceProjectRequest",
        "NamedPort",
        "NatIpInfo",
        "NatIpInfoNatIpInfoMapping",
        "NatIpInfoResponse",
        "Network",
        "NetworkAttachment",
        "NetworkAttachmentAggregatedList",
        "NetworkAttachmentConnectedEndpoint",
        "NetworkAttachmentList",
        "NetworkAttachmentsScopedList",
        "NetworkEdgeSecurityService",
        "NetworkEdgeSecurityServiceAggregatedList",
        "NetworkEdgeSecurityServicesScopedList",
        "NetworkEndpoint",
        "NetworkEndpointGroup",
        "NetworkEndpointGroupAggregatedList",
        "NetworkEndpointGroupAppEngine",
        "NetworkEndpointGroupCloudFunction",
        "NetworkEndpointGroupCloudRun",
        "NetworkEndpointGroupList",
        "NetworkEndpointGroupPscData",
        "NetworkEndpointGroupsAttachEndpointsRequest",
        "NetworkEndpointGroupsDetachEndpointsRequest",
        "NetworkEndpointGroupsListEndpointsRequest",
        "NetworkEndpointGroupsListNetworkEndpoints",
        "NetworkEndpointGroupsScopedList",
        "NetworkEndpointWithHealthStatus",
        "NetworkFirewallPolicyAggregatedList",
        "NetworkInterface",
        "NetworkList",
        "NetworkPeering",
        "NetworkPerformanceConfig",
        "NetworkProfile",
        "NetworkProfileLocation",
        "NetworkProfileNetworkFeatures",
        "NetworkProfilesListResponse",
        "NetworkRoutingConfig",
        "NetworksAddPeeringRequest",
        "NetworksGetEffectiveFirewallsResponse",
        "NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
        "NetworksRemovePeeringRequest",
        "NetworksUpdatePeeringRequest",
        "NodeGroup",
        "NodeGroupAggregatedList",
        "NodeGroupAutoscalingPolicy",
        "NodeGroupList",
        "NodeGroupMaintenanceWindow",
        "NodeGroupNode",
        "NodeGroupsAddNodesRequest",
        "NodeGroupsDeleteNodesRequest",
        "NodeGroupsListNodes",
        "NodeGroupsPerformMaintenanceRequest",
        "NodeGroupsScopedList",
        "NodeGroupsSetNodeTemplateRequest",
        "NodeGroupsSimulateMaintenanceEventRequest",
        "NodeTemplate",
        "NodeTemplateAggregatedList",
        "NodeTemplateList",
        "NodeTemplateNodeTypeFlexibility",
        "NodeTemplatesScopedList",
        "NodeType",
        "NodeTypeAggregatedList",
        "NodeTypeList",
        "NodeTypesScopedList",
        "NotificationEndpoint",
        "NotificationEndpointGrpcSettings",
        "NotificationEndpointList",
        "Operation",
        "OperationAggregatedList",
        "OperationList",
        "OperationsScopedList",
        "OutlierDetection",
        "PacketIntervals",
        "PacketMirroring",
        "PacketMirroringAggregatedList",
        "PacketMirroringFilter",
        "PacketMirroringForwardingRuleInfo",
        "PacketMirroringList",
        "PacketMirroringMirroredResourceInfo",
        "PacketMirroringMirroredResourceInfoInstanceInfo",
        "PacketMirroringMirroredResourceInfoSubnetInfo",
        "PacketMirroringNetworkInfo",
        "PacketMirroringsScopedList",
        "PatchAutoscalerRequest",
        "PatchBackendBucketRequest",
        "PatchBackendServiceRequest",
        "PatchFirewallPolicyRequest",
        "PatchFirewallRequest",
        "PatchForwardingRuleRequest",
        "PatchGlobalForwardingRuleRequest",
        "PatchGlobalPublicDelegatedPrefixeRequest",
        "PatchHealthCheckRequest",
        "PatchImageRequest",
        "PatchInstanceGroupManagerRequest",
        "PatchInstanceSettingRequest",
        "PatchInterconnectAttachmentRequest",
        "PatchInterconnectRequest",
        "PatchNetworkAttachmentRequest",
        "PatchNetworkEdgeSecurityServiceRequest",
        "PatchNetworkFirewallPolicyRequest",
        "PatchNetworkRequest",
        "PatchNodeGroupRequest",
        "PatchPacketMirroringRequest",
        "PatchPacketMirroringRuleNetworkFirewallPolicyRequest",
        "PatchPerInstanceConfigsInstanceGroupManagerRequest",
        "PatchPerInstanceConfigsRegionInstanceGroupManagerRequest",
        "PatchPublicAdvertisedPrefixeRequest",
        "PatchPublicDelegatedPrefixeRequest",
        "PatchRegionAutoscalerRequest",
        "PatchRegionBackendServiceRequest",
        "PatchRegionHealthCheckRequest",
        "PatchRegionHealthCheckServiceRequest",
        "PatchRegionInstanceGroupManagerRequest",
        "PatchRegionNetworkFirewallPolicyRequest",
        "PatchRegionSecurityPolicyRequest",
        "PatchRegionSslPolicyRequest",
        "PatchRegionTargetHttpsProxyRequest",
        "PatchRegionUrlMapRequest",
        "PatchResourcePolicyRequest",
        "PatchRoutePolicyRouterRequest",
        "PatchRouterRequest",
        "PatchRuleFirewallPolicyRequest",
        "PatchRuleNetworkFirewallPolicyRequest",
        "PatchRuleRegionNetworkFirewallPolicyRequest",
        "PatchRuleRegionSecurityPolicyRequest",
        "PatchRuleSecurityPolicyRequest",
        "PatchSecurityPolicyRequest",
        "PatchServiceAttachmentRequest",
        "PatchSnapshotSettingRequest",
        "PatchSslPolicyRequest",
        "PatchSubnetworkRequest",
        "PatchTargetGrpcProxyRequest",
        "PatchTargetHttpProxyRequest",
        "PatchTargetHttpsProxyRequest",
        "PatchUrlMapRequest",
        "PathMatcher",
        "PathRule",
        "PerInstanceConfig",
        "PerformMaintenanceInstanceRequest",
        "PerformMaintenanceNodeGroupRequest",
        "PerformMaintenanceReservationBlockRequest",
        "PerformMaintenanceReservationRequest",
        "Policy",
        "PreconfiguredWafSet",
        "PreservedState",
        "PreservedStatePreservedDisk",
        "PreservedStatePreservedNetworkIp",
        "PreservedStatePreservedNetworkIpIpAddress",
        "PreviewRouterRequest",
        "Project",
        "ProjectsDisableXpnResourceRequest",
        "ProjectsEnableXpnResourceRequest",
        "ProjectsGetXpnResources",
        "ProjectsListXpnHostsRequest",
        "ProjectsSetCloudArmorTierRequest",
        "ProjectsSetDefaultNetworkTierRequest",
        "PublicAdvertisedPrefix",
        "PublicAdvertisedPrefixList",
        "PublicAdvertisedPrefixPublicDelegatedPrefix",
        "PublicDelegatedPrefix",
        "PublicDelegatedPrefixAggregatedList",
        "PublicDelegatedPrefixList",
        "PublicDelegatedPrefixPublicDelegatedSubPrefix",
        "PublicDelegatedPrefixesScopedList",
        "Quota",
        "QuotaExceededInfo",
        "QuotaStatusWarning",
        "RawDisk",
        "RecreateInstancesInstanceGroupManagerRequest",
        "RecreateInstancesRegionInstanceGroupManagerRequest",
        "Reference",
        "Region",
        "RegionAddressesMoveRequest",
        "RegionAutoscalerList",
        "RegionDiskTypeList",
        "RegionDisksAddResourcePoliciesRequest",
        "RegionDisksRemoveResourcePoliciesRequest",
        "RegionDisksResizeRequest",
        "RegionDisksStartAsyncReplicationRequest",
        "RegionInstanceGroupList",
        "RegionInstanceGroupManagerDeleteInstanceConfigReq",
        "RegionInstanceGroupManagerList",
        "RegionInstanceGroupManagerPatchInstanceConfigReq",
        "RegionInstanceGroupManagerUpdateInstanceConfigReq",
        "RegionInstanceGroupManagersAbandonInstancesRequest",
        "RegionInstanceGroupManagersApplyUpdatesRequest",
        "RegionInstanceGroupManagersCreateInstancesRequest",
        "RegionInstanceGroupManagersDeleteInstancesRequest",
        "RegionInstanceGroupManagersListErrorsResponse",
        "RegionInstanceGroupManagersListInstanceConfigsResp",
        "RegionInstanceGroupManagersListInstancesResponse",
        "RegionInstanceGroupManagersRecreateRequest",
        "RegionInstanceGroupManagersResumeInstancesRequest",
        "RegionInstanceGroupManagersSetTargetPoolsRequest",
        "RegionInstanceGroupManagersSetTemplateRequest",
        "RegionInstanceGroupManagersStartInstancesRequest",
        "RegionInstanceGroupManagersStopInstancesRequest",
        "RegionInstanceGroupManagersSuspendInstancesRequest",
        "RegionInstanceGroupsListInstances",
        "RegionInstanceGroupsListInstancesRequest",
        "RegionInstanceGroupsSetNamedPortsRequest",
        "RegionList",
        "RegionNetworkEndpointGroupsAttachEndpointsRequest",
        "RegionNetworkEndpointGroupsDetachEndpointsRequest",
        "RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse",
        "RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
        "RegionSetLabelsRequest",
        "RegionSetPolicyRequest",
        "RegionTargetHttpsProxiesSetSslCertificatesRequest",
        "RegionUrlMapsValidateRequest",
        "RemoveAssociationFirewallPolicyRequest",
        "RemoveAssociationNetworkFirewallPolicyRequest",
        "RemoveAssociationRegionNetworkFirewallPolicyRequest",
        "RemoveHealthCheckTargetPoolRequest",
        "RemoveInstanceTargetPoolRequest",
        "RemoveInstancesInstanceGroupRequest",
        "RemovePacketMirroringRuleNetworkFirewallPolicyRequest",
        "RemovePeeringNetworkRequest",
        "RemoveResourcePoliciesDiskRequest",
        "RemoveResourcePoliciesInstanceRequest",
        "RemoveResourcePoliciesRegionDiskRequest",
        "RemoveRuleFirewallPolicyRequest",
        "RemoveRuleNetworkFirewallPolicyRequest",
        "RemoveRuleRegionNetworkFirewallPolicyRequest",
        "RemoveRuleRegionSecurityPolicyRequest",
        "RemoveRuleSecurityPolicyRequest",
        "ReportHostAsFaultyInstanceRequest",
        "RequestMirrorPolicy",
        "Reservation",
        "ReservationAffinity",
        "ReservationAggregatedList",
        "ReservationBlock",
        "ReservationBlockPhysicalTopology",
        "ReservationBlocksGetResponse",
        "ReservationBlocksListResponse",
        "ReservationList",
        "ReservationsBlocksPerformMaintenanceRequest",
        "ReservationsPerformMaintenanceRequest",
        "ReservationsResizeRequest",
        "ReservationsScopedList",
        "ResetInstanceRequest",
        "ResizeDiskRequest",
        "ResizeInstanceGroupManagerRequest",
        "ResizeRegionDiskRequest",
        "ResizeRegionInstanceGroupManagerRequest",
        "ResizeReservationRequest",
        "ResourceCommitment",
        "ResourceGroupReference",
        "ResourcePoliciesScopedList",
        "ResourcePolicy",
        "ResourcePolicyAggregatedList",
        "ResourcePolicyDailyCycle",
        "ResourcePolicyDiskConsistencyGroupPolicy",
        "ResourcePolicyGroupPlacementPolicy",
        "ResourcePolicyHourlyCycle",
        "ResourcePolicyInstanceSchedulePolicy",
        "ResourcePolicyInstanceSchedulePolicySchedule",
        "ResourcePolicyList",
        "ResourcePolicyResourceStatus",
        "ResourcePolicyResourceStatusInstanceSchedulePolicyStatus",
        "ResourcePolicySnapshotSchedulePolicy",
        "ResourcePolicySnapshotSchedulePolicyRetentionPolicy",
        "ResourcePolicySnapshotSchedulePolicySchedule",
        "ResourcePolicySnapshotSchedulePolicySnapshotProperties",
        "ResourcePolicyWeeklyCycle",
        "ResourcePolicyWeeklyCycleDayOfWeek",
        "ResourceStatus",
        "ResourceStatusPhysicalHostTopology",
        "ResourceStatusScheduling",
        "ResumeInstanceRequest",
        "ResumeInstancesInstanceGroupManagerRequest",
        "ResumeInstancesRegionInstanceGroupManagerRequest",
        "Route",
        "RouteAsPath",
        "RouteList",
        "RoutePolicy",
        "RoutePolicyPolicyTerm",
        "Router",
        "RouterAdvertisedIpRange",
        "RouterAggregatedList",
        "RouterBgp",
        "RouterBgpPeer",
        "RouterBgpPeerBfd",
        "RouterBgpPeerCustomLearnedIpRange",
        "RouterInterface",
        "RouterList",
        "RouterMd5AuthenticationKey",
        "RouterNat",
        "RouterNatLogConfig",
        "RouterNatRule",
        "RouterNatRuleAction",
        "RouterNatSubnetworkToNat",
        "RouterNatSubnetworkToNat64",
        "RouterStatus",
        "RouterStatusBgpPeerStatus",
        "RouterStatusNatStatus",
        "RouterStatusNatStatusNatRuleStatus",
        "RouterStatusResponse",
        "RoutersGetRoutePolicyResponse",
        "RoutersListBgpRoutes",
        "RoutersListRoutePolicies",
        "RoutersPreviewResponse",
        "RoutersScopedList",
        "SSLHealthCheck",
        "SavedAttachedDisk",
        "SavedDisk",
        "ScalingScheduleStatus",
        "Scheduling",
        "SchedulingNodeAffinity",
        "SchedulingOnInstanceStopAction",
        "ScratchDisks",
        "Screenshot",
        "SecurityPoliciesAggregatedList",
        "SecurityPoliciesListPreconfiguredExpressionSetsResponse",
        "SecurityPoliciesScopedList",
        "SecurityPoliciesWafConfig",
        "SecurityPolicy",
        "SecurityPolicyAdaptiveProtectionConfig",
        "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig",
        "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig",
        "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig",
        "SecurityPolicyAdvancedOptionsConfig",
        "SecurityPolicyAdvancedOptionsConfigJsonCustomConfig",
        "SecurityPolicyDdosProtectionConfig",
        "SecurityPolicyList",
        "SecurityPolicyRecaptchaOptionsConfig",
        "SecurityPolicyReference",
        "SecurityPolicyRule",
        "SecurityPolicyRuleHttpHeaderAction",
        "SecurityPolicyRuleHttpHeaderActionHttpHeaderOption",
        "SecurityPolicyRuleMatcher",
        "SecurityPolicyRuleMatcherConfig",
        "SecurityPolicyRuleMatcherExprOptions",
        "SecurityPolicyRuleMatcherExprOptionsRecaptchaOptions",
        "SecurityPolicyRuleNetworkMatcher",
        "SecurityPolicyRuleNetworkMatcherUserDefinedFieldMatch",
        "SecurityPolicyRulePreconfiguredWafConfig",
        "SecurityPolicyRulePreconfiguredWafConfigExclusion",
        "SecurityPolicyRulePreconfiguredWafConfigExclusionFieldParams",
        "SecurityPolicyRuleRateLimitOptions",
        "SecurityPolicyRuleRateLimitOptionsEnforceOnKeyConfig",
        "SecurityPolicyRuleRateLimitOptionsThreshold",
        "SecurityPolicyRuleRedirectOptions",
        "SecurityPolicyUserDefinedField",
        "SecuritySettings",
        "SendDiagnosticInterruptInstanceRequest",
        "SendDiagnosticInterruptInstanceResponse",
        "SerialPortOutput",
        "ServerBinding",
        "ServiceAccount",
        "ServiceAttachment",
        "ServiceAttachmentAggregatedList",
        "ServiceAttachmentConnectedEndpoint",
        "ServiceAttachmentConsumerProjectLimit",
        "ServiceAttachmentList",
        "ServiceAttachmentsScopedList",
        "SetBackendServiceTargetSslProxyRequest",
        "SetBackendServiceTargetTcpProxyRequest",
        "SetBackupTargetPoolRequest",
        "SetCertificateMapTargetHttpsProxyRequest",
        "SetCertificateMapTargetSslProxyRequest",
        "SetCloudArmorTierProjectRequest",
        "SetCommonInstanceMetadataOperationMetadata",
        "SetCommonInstanceMetadataOperationMetadataPerLocationOperationInfo",
        "SetCommonInstanceMetadataProjectRequest",
        "SetDefaultNetworkTierProjectRequest",
        "SetDeletionProtectionInstanceRequest",
        "SetDiskAutoDeleteInstanceRequest",
        "SetEdgeSecurityPolicyBackendBucketRequest",
        "SetEdgeSecurityPolicyBackendServiceRequest",
        "SetIamPolicyBackendBucketRequest",
        "SetIamPolicyBackendServiceRequest",
        "SetIamPolicyDiskRequest",
        "SetIamPolicyFirewallPolicyRequest",
        "SetIamPolicyImageRequest",
        "SetIamPolicyInstanceRequest",
        "SetIamPolicyInstanceTemplateRequest",
        "SetIamPolicyInstantSnapshotRequest",
        "SetIamPolicyLicenseRequest",
        "SetIamPolicyMachineImageRequest",
        "SetIamPolicyNetworkAttachmentRequest",
        "SetIamPolicyNetworkFirewallPolicyRequest",
        "SetIamPolicyNodeGroupRequest",
        "SetIamPolicyNodeTemplateRequest",
        "SetIamPolicyRegionBackendServiceRequest",
        "SetIamPolicyRegionDiskRequest",
        "SetIamPolicyRegionInstantSnapshotRequest",
        "SetIamPolicyRegionNetworkFirewallPolicyRequest",
        "SetIamPolicyReservationRequest",
        "SetIamPolicyResourcePolicyRequest",
        "SetIamPolicyServiceAttachmentRequest",
        "SetIamPolicySnapshotRequest",
        "SetIamPolicyStoragePoolRequest",
        "SetIamPolicySubnetworkRequest",
        "SetInstanceTemplateInstanceGroupManagerRequest",
        "SetInstanceTemplateRegionInstanceGroupManagerRequest",
        "SetLabelsAddressRequest",
        "SetLabelsDiskRequest",
        "SetLabelsExternalVpnGatewayRequest",
        "SetLabelsForwardingRuleRequest",
        "SetLabelsGlobalAddressRequest",
        "SetLabelsGlobalForwardingRuleRequest",
        "SetLabelsImageRequest",
        "SetLabelsInstanceRequest",
        "SetLabelsInstantSnapshotRequest",
        "SetLabelsInterconnectAttachmentRequest",
        "SetLabelsInterconnectRequest",
        "SetLabelsMachineImageRequest",
        "SetLabelsRegionDiskRequest",
        "SetLabelsRegionInstantSnapshotRequest",
        "SetLabelsRegionSecurityPolicyRequest",
        "SetLabelsSecurityPolicyRequest",
        "SetLabelsSnapshotRequest",
        "SetLabelsTargetVpnGatewayRequest",
        "SetLabelsVpnGatewayRequest",
        "SetLabelsVpnTunnelRequest",
        "SetMachineResourcesInstanceRequest",
        "SetMachineTypeInstanceRequest",
        "SetMetadataInstanceRequest",
        "SetMinCpuPlatformInstanceRequest",
        "SetNameInstanceRequest",
        "SetNamedPortsInstanceGroupRequest",
        "SetNamedPortsRegionInstanceGroupRequest",
        "SetNodeTemplateNodeGroupRequest",
        "SetPrivateIpGoogleAccessSubnetworkRequest",
        "SetProxyHeaderTargetSslProxyRequest",
        "SetProxyHeaderTargetTcpProxyRequest",
        "SetQuicOverrideTargetHttpsProxyRequest",
        "SetSchedulingInstanceRequest",
        "SetSecurityPolicyBackendServiceRequest",
        "SetSecurityPolicyInstanceRequest",
        "SetSecurityPolicyRegionBackendServiceRequest",
        "SetSecurityPolicyTargetInstanceRequest",
        "SetSecurityPolicyTargetPoolRequest",
        "SetServiceAccountInstanceRequest",
        "SetShieldedInstanceIntegrityPolicyInstanceRequest",
        "SetSslCertificatesRegionTargetHttpsProxyRequest",
        "SetSslCertificatesTargetHttpsProxyRequest",
        "SetSslCertificatesTargetSslProxyRequest",
        "SetSslPolicyTargetHttpsProxyRequest",
        "SetSslPolicyTargetSslProxyRequest",
        "SetTagsInstanceRequest",
        "SetTargetForwardingRuleRequest",
        "SetTargetGlobalForwardingRuleRequest",
        "SetTargetPoolsInstanceGroupManagerRequest",
        "SetTargetPoolsRegionInstanceGroupManagerRequest",
        "SetUrlMapRegionTargetHttpProxyRequest",
        "SetUrlMapRegionTargetHttpsProxyRequest",
        "SetUrlMapTargetHttpProxyRequest",
        "SetUrlMapTargetHttpsProxyRequest",
        "SetUsageExportBucketProjectRequest",
        "ShareSettings",
        "ShareSettingsProjectConfig",
        "ShieldedInstanceConfig",
        "ShieldedInstanceIdentity",
        "ShieldedInstanceIdentityEntry",
        "ShieldedInstanceIntegrityPolicy",
        "SignedUrlKey",
        "SimulateMaintenanceEventInstanceRequest",
        "SimulateMaintenanceEventNodeGroupRequest",
        "Snapshot",
        "SnapshotList",
        "SnapshotSettings",
        "SnapshotSettingsStorageLocationSettings",
        "SnapshotSettingsStorageLocationSettingsStorageLocationPreference",
        "SourceDiskEncryptionKey",
        "SourceInstanceParams",
        "SourceInstanceProperties",
        "SslCertificate",
        "SslCertificateAggregatedList",
        "SslCertificateList",
        "SslCertificateManagedSslCertificate",
        "SslCertificateSelfManagedSslCertificate",
        "SslCertificatesScopedList",
        "SslPoliciesAggregatedList",
        "SslPoliciesList",
        "SslPoliciesListAvailableFeaturesResponse",
        "SslPoliciesScopedList",
        "SslPolicy",
        "SslPolicyReference",
        "StartAsyncReplicationDiskRequest",
        "StartAsyncReplicationRegionDiskRequest",
        "StartInstanceRequest",
        "StartInstancesInstanceGroupManagerRequest",
        "StartInstancesRegionInstanceGroupManagerRequest",
        "StartWithEncryptionKeyInstanceRequest",
        "StatefulPolicy",
        "StatefulPolicyPreservedState",
        "StatefulPolicyPreservedStateDiskDevice",
        "StatefulPolicyPreservedStateNetworkIp",
        "Status",
        "StopAsyncReplicationDiskRequest",
        "StopAsyncReplicationRegionDiskRequest",
        "StopGroupAsyncReplicationDiskRequest",
        "StopGroupAsyncReplicationRegionDiskRequest",
        "StopInstanceRequest",
        "StopInstancesInstanceGroupManagerRequest",
        "StopInstancesRegionInstanceGroupManagerRequest",
        "StoragePool",
        "StoragePoolAggregatedList",
        "StoragePoolDisk",
        "StoragePoolList",
        "StoragePoolListDisks",
        "StoragePoolResourceStatus",
        "StoragePoolType",
        "StoragePoolTypeAggregatedList",
        "StoragePoolTypeList",
        "StoragePoolTypesScopedList",
        "StoragePoolsScopedList",
        "Subnetwork",
        "SubnetworkAggregatedList",
        "SubnetworkList",
        "SubnetworkLogConfig",
        "SubnetworkSecondaryRange",
        "SubnetworksExpandIpCidrRangeRequest",
        "SubnetworksScopedList",
        "SubnetworksSetPrivateIpGoogleAccessRequest",
        "Subsetting",
        "SuspendInstanceRequest",
        "SuspendInstancesInstanceGroupManagerRequest",
        "SuspendInstancesRegionInstanceGroupManagerRequest",
        "SwitchToCustomModeNetworkRequest",
        "TCPHealthCheck",
        "Tags",
        "TargetGrpcProxy",
        "TargetGrpcProxyList",
        "TargetHttpProxiesScopedList",
        "TargetHttpProxy",
        "TargetHttpProxyAggregatedList",
        "TargetHttpProxyList",
        "TargetHttpsProxiesScopedList",
        "TargetHttpsProxiesSetCertificateMapRequest",
        "TargetHttpsProxiesSetQuicOverrideRequest",
        "TargetHttpsProxiesSetSslCertificatesRequest",
        "TargetHttpsProxy",
        "TargetHttpsProxyAggregatedList",
        "TargetHttpsProxyList",
        "TargetInstance",
        "TargetInstanceAggregatedList",
        "TargetInstanceList",
        "TargetInstancesScopedList",
        "TargetPool",
        "TargetPoolAggregatedList",
        "TargetPoolInstanceHealth",
        "TargetPoolList",
        "TargetPoolsAddHealthCheckRequest",
        "TargetPoolsAddInstanceRequest",
        "TargetPoolsRemoveHealthCheckRequest",
        "TargetPoolsRemoveInstanceRequest",
        "TargetPoolsScopedList",
        "TargetReference",
        "TargetSslProxiesSetBackendServiceRequest",
        "TargetSslProxiesSetCertificateMapRequest",
        "TargetSslProxiesSetProxyHeaderRequest",
        "TargetSslProxiesSetSslCertificatesRequest",
        "TargetSslProxy",
        "TargetSslProxyList",
        "TargetTcpProxiesScopedList",
        "TargetTcpProxiesSetBackendServiceRequest",
        "TargetTcpProxiesSetProxyHeaderRequest",
        "TargetTcpProxy",
        "TargetTcpProxyAggregatedList",
        "TargetTcpProxyList",
        "TargetVpnGateway",
        "TargetVpnGatewayAggregatedList",
        "TargetVpnGatewayList",
        "TargetVpnGatewaysScopedList",
        "TestFailure",
        "TestIamPermissionsBackendBucketRequest",
        "TestIamPermissionsBackendServiceRequest",
        "TestIamPermissionsDiskRequest",
        "TestIamPermissionsExternalVpnGatewayRequest",
        "TestIamPermissionsFirewallPolicyRequest",
        "TestIamPermissionsImageRequest",
        "TestIamPermissionsInstanceRequest",
        "TestIamPermissionsInstanceTemplateRequest",
        "TestIamPermissionsInstantSnapshotRequest",
        "TestIamPermissionsLicenseCodeRequest",
        "TestIamPermissionsLicenseRequest",
        "TestIamPermissionsMachineImageRequest",
        "TestIamPermissionsNetworkAttachmentRequest",
        "TestIamPermissionsNetworkEndpointGroupRequest",
        "TestIamPermissionsNetworkFirewallPolicyRequest",
        "TestIamPermissionsNodeGroupRequest",
        "TestIamPermissionsNodeTemplateRequest",
        "TestIamPermissionsPacketMirroringRequest",
        "TestIamPermissionsRegionBackendServiceRequest",
        "TestIamPermissionsRegionDiskRequest",
        "TestIamPermissionsRegionInstantSnapshotRequest",
        "TestIamPermissionsRegionNetworkFirewallPolicyRequest",
        "TestIamPermissionsReservationRequest",
        "TestIamPermissionsResourcePolicyRequest",
        "TestIamPermissionsServiceAttachmentRequest",
        "TestIamPermissionsSnapshotRequest",
        "TestIamPermissionsStoragePoolRequest",
        "TestIamPermissionsSubnetworkRequest",
        "TestIamPermissionsVpnGatewayRequest",
        "TestPermissionsRequest",
        "TestPermissionsResponse",
        "Uint128",
        "UpcomingMaintenance",
        "UpdateAccessConfigInstanceRequest",
        "UpdateAutoscalerRequest",
        "UpdateBackendBucketRequest",
        "UpdateBackendServiceRequest",
        "UpdateDiskRequest",
        "UpdateDisplayDeviceInstanceRequest",
        "UpdateFirewallRequest",
        "UpdateHealthCheckRequest",
        "UpdateInstanceRequest",
        "UpdateNetworkInterfaceInstanceRequest",
        "UpdatePeeringNetworkRequest",
        "UpdatePerInstanceConfigsInstanceGroupManagerRequest",
        "UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest",
        "UpdateRegionAutoscalerRequest",
        "UpdateRegionBackendServiceRequest",
        "UpdateRegionCommitmentRequest",
        "UpdateRegionDiskRequest",
        "UpdateRegionHealthCheckRequest",
        "UpdateRegionUrlMapRequest",
        "UpdateReservationRequest",
        "UpdateRoutePolicyRouterRequest",
        "UpdateRouterRequest",
        "UpdateShieldedInstanceConfigInstanceRequest",
        "UpdateStoragePoolRequest",
        "UpdateUrlMapRequest",
        "UrlMap",
        "UrlMapList",
        "UrlMapReference",
        "UrlMapTest",
        "UrlMapTestHeader",
        "UrlMapValidationResult",
        "UrlMapsAggregatedList",
        "UrlMapsScopedList",
        "UrlMapsValidateRequest",
        "UrlMapsValidateResponse",
        "UrlRewrite",
        "UsableSubnetwork",
        "UsableSubnetworkSecondaryRange",
        "UsableSubnetworksAggregatedList",
        "UsageExportLocation",
        "ValidateRegionUrlMapRequest",
        "ValidateUrlMapRequest",
        "VmEndpointNatMappings",
        "VmEndpointNatMappingsInterfaceNatMappings",
        "VmEndpointNatMappingsInterfaceNatMappingsNatRuleMappings",
        "VmEndpointNatMappingsList",
        "VpnGateway",
        "VpnGatewayAggregatedList",
        "VpnGatewayList",
        "VpnGatewayStatus",
        "VpnGatewayStatusHighAvailabilityRequirementState",
        "VpnGatewayStatusTunnel",
        "VpnGatewayStatusVpnConnection",
        "VpnGatewayVpnGatewayInterface",
        "VpnGatewaysGetStatusResponse",
        "VpnGatewaysScopedList",
        "VpnTunnel",
        "VpnTunnelAggregatedList",
        "VpnTunnelList",
        "VpnTunnelsScopedList",
        "WafExpressionSet",
        "WafExpressionSetExpression",
        "WaitGlobalOperationRequest",
        "WaitRegionOperationRequest",
        "WaitZoneOperationRequest",
        "Warning",
        "Warnings",
        "WeightedBackendService",
        "WithdrawPublicAdvertisedPrefixeRequest",
        "WithdrawPublicDelegatedPrefixeRequest",
        "XpnHostList",
        "XpnResourceId",
        "Zone",
        "ZoneList",
        "ZoneSetLabelsRequest",
        "ZoneSetPolicyRequest",
    },
)


class AWSV4Signature(proto.Message):
    r"""Messages

    Contains the configurations necessary to generate a signature
    for access to private storage buckets that support Signature
    Version 4 for authentication. The service name for generating
    the authentication header will always default to 's3'.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        access_key (str):
            The access key used for s3 bucket
            authentication. Required for updating or
            creating a backend that uses AWS v4 signature
            authentication, but will not be returned as part
            of the configuration when queried with a REST
            API GET request. @InputOnly

            This field is a member of `oneof`_ ``_access_key``.
        access_key_id (str):
            The identifier of an access key used for s3
            bucket authentication.

            This field is a member of `oneof`_ ``_access_key_id``.
        access_key_version (str):
            The optional version identifier for the
            access key. You can use this to keep track of
            different iterations of your access key.

            This field is a member of `oneof`_ ``_access_key_version``.
        origin_region (str):
            The name of the cloud region of your origin.
            This is a free-form field with the name of the
            region your cloud uses to host your origin. For
            example, "us-east-1" for AWS or "us-ashburn-1"
            for OCI.

            This field is a member of `oneof`_ ``_origin_region``.
    """

    access_key: str = proto.Field(
        proto.STRING,
        number=468922628,
        optional=True,
    )
    access_key_id: str = proto.Field(
        proto.STRING,
        number=292975158,
        optional=True,
    )
    access_key_version: str = proto.Field(
        proto.STRING,
        number=80261277,
        optional=True,
    )
    origin_region: str = proto.Field(
        proto.STRING,
        number=265305645,
        optional=True,
    )


class AbandonInstancesInstanceGroupManagerRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.AbandonInstances.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group.
        instance_group_managers_abandon_instances_request_resource (google.cloud.compute_v1.types.InstanceGroupManagersAbandonInstancesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the managed
            instance group is located.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    instance_group_managers_abandon_instances_request_resource: "InstanceGroupManagersAbandonInstancesRequest" = proto.Field(
        proto.MESSAGE,
        number=320929016,
        message="InstanceGroupManagersAbandonInstancesRequest",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class AbandonInstancesRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    RegionInstanceGroupManagers.AbandonInstances. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            Name of the managed instance group.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        region_instance_group_managers_abandon_instances_request_resource (google.cloud.compute_v1.types.RegionInstanceGroupManagersAbandonInstancesRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    region_instance_group_managers_abandon_instances_request_resource: "RegionInstanceGroupManagersAbandonInstancesRequest" = proto.Field(
        proto.MESSAGE,
        number=488499491,
        message="RegionInstanceGroupManagersAbandonInstancesRequest",
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AcceleratorConfig(proto.Message):
    r"""A specification of the type and number of accelerator cards
    attached to the instance.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        accelerator_count (int):
            The number of the guest accelerator cards
            exposed to this instance.

            This field is a member of `oneof`_ ``_accelerator_count``.
        accelerator_type (str):
            Full or partial URL of the accelerator type
            resource to attach to this instance. For
            example:
            projects/my-project/zones/us-central1-c/acceleratorTypes/nvidia-tesla-p100
            If you are creating an instance template,
            specify only the accelerator name. See GPUs on
            Compute Engine for a full list of accelerator
            types.

            This field is a member of `oneof`_ ``_accelerator_type``.
    """

    accelerator_count: int = proto.Field(
        proto.INT32,
        number=504879675,
        optional=True,
    )
    accelerator_type: str = proto.Field(
        proto.STRING,
        number=138031246,
        optional=True,
    )


class AcceleratorType(proto.Message):
    r"""Represents an Accelerator Type resource. Google Cloud
    Platform provides graphics processing units (accelerators) that
    you can add to VM instances to improve or accelerate performance
    when working with intensive workloads. For more information,
    read GPUs on Compute Engine.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        deprecated (google.cloud.compute_v1.types.DeprecationStatus):
            [Output Only] The deprecation status associated with this
            accelerator type.

            This field is a member of `oneof`_ ``_deprecated``.
        description (str):
            [Output Only] An optional textual description of the
            resource.

            This field is a member of `oneof`_ ``_description``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output Only] The type of the resource. Always
            compute#acceleratorType for accelerator types.

            This field is a member of `oneof`_ ``_kind``.
        maximum_cards_per_instance (int):
            [Output Only] Maximum number of accelerator cards allowed
            per instance.

            This field is a member of `oneof`_ ``_maximum_cards_per_instance``.
        name (str):
            [Output Only] Name of the resource.

            This field is a member of `oneof`_ ``_name``.
        self_link (str):
            [Output Only] Server-defined, fully qualified URL for this
            resource.

            This field is a member of `oneof`_ ``_self_link``.
        zone (str):
            [Output Only] The name of the zone where the accelerator
            type resides, such as us-central1-a. You must specify this
            field as part of the HTTP request URL. It is not settable as
            a field in the request body.

            This field is a member of `oneof`_ ``_zone``.
    """

    creation_timestamp: str = proto.Field(
        proto.STRING,
        number=30525366,
        optional=True,
    )
    deprecated: "DeprecationStatus" = proto.Field(
        proto.MESSAGE,
        number=515138995,
        optional=True,
        message="DeprecationStatus",
    )
    description: str = proto.Field(
        proto.STRING,
        number=422937596,
        optional=True,
    )
    id: int = proto.Field(
        proto.UINT64,
        number=3355,
        optional=True,
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    maximum_cards_per_instance: int = proto.Field(
        proto.INT32,
        number=263814482,
        optional=True,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
        optional=True,
    )


class AcceleratorTypeAggregatedList(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableMapping[str, google.cloud.compute_v1.types.AcceleratorTypesScopedList]):
            A list of AcceleratorTypesScopedList
            resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#acceleratorTypeAggregatedList for aggregated lists
            of accelerator types.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (MutableSequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableMapping[str, "AcceleratorTypesScopedList"] = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="AcceleratorTypesScopedList",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    unreachables: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=243372063,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class AcceleratorTypeList(proto.Message):
    r"""Contains a list of accelerator types.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableSequence[google.cloud.compute_v1.types.AcceleratorType]):
            A list of AcceleratorType resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#acceleratorTypeList for lists of accelerator types.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableSequence["AcceleratorType"] = proto.RepeatedField(
        proto.MESSAGE,
        number=100526016,
        message="AcceleratorType",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class AcceleratorTypesScopedList(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        accelerator_types (MutableSequence[google.cloud.compute_v1.types.AcceleratorType]):
            [Output Only] A list of accelerator types contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] An informational warning that appears when the
            accelerator types list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    accelerator_types: MutableSequence["AcceleratorType"] = proto.RepeatedField(
        proto.MESSAGE,
        number=520872357,
        message="AcceleratorType",
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class Accelerators(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        guest_accelerator_count (int):
            Number of accelerator cards exposed to the
            guest.

            This field is a member of `oneof`_ ``_guest_accelerator_count``.
        guest_accelerator_type (str):
            The accelerator type resource name, not a
            full URL, e.g. nvidia-tesla-t4.

            This field is a member of `oneof`_ ``_guest_accelerator_type``.
    """

    guest_accelerator_count: int = proto.Field(
        proto.INT32,
        number=479079316,
        optional=True,
    )
    guest_accelerator_type: str = proto.Field(
        proto.STRING,
        number=293064725,
        optional=True,
    )


class AccessConfig(proto.Message):
    r"""An access configuration attached to an instance's network
    interface. Only one access config per instance is supported.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        external_ipv6 (str):
            Applies to ipv6AccessConfigs only. The first
            IPv6 address of the external IPv6 range
            associated with this instance, prefix length is
            stored in externalIpv6PrefixLength in
            ipv6AccessConfig. To use a static external IP
            address, it must be unused and in the same
            region as the instance's zone. If not specified,
            Google Cloud will automatically assign an
            external IPv6 address from the instance's
            subnetwork.

            This field is a member of `oneof`_ ``_external_ipv6``.
        external_ipv6_prefix_length (int):
            Applies to ipv6AccessConfigs only. The prefix
            length of the external IPv6 range.

            This field is a member of `oneof`_ ``_external_ipv6_prefix_length``.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#accessConfig for access configs.

            This field is a member of `oneof`_ ``_kind``.
        name (str):
            The name of this access configuration. In
            accessConfigs (IPv4), the default and
            recommended name is External NAT, but you can
            use any arbitrary string, such as My external IP
            or Network Access. In ipv6AccessConfigs, the
            recommend name is External IPv6.

            This field is a member of `oneof`_ ``_name``.
        nat_i_p (str):
            Applies to accessConfigs (IPv4) only. An
            external IP address associated with this
            instance. Specify an unused static external IP
            address available to the project or leave this
            field undefined to use an IP from a shared
            ephemeral IP address pool. If you specify a
            static external IP address, it must live in the
            same region as the zone of the instance.

            This field is a member of `oneof`_ ``_nat_i_p``.
        network_tier (str):
            This signifies the networking tier used for
            configuring this access configuration and can
            only take the following values: PREMIUM,
            STANDARD. If an AccessConfig is specified
            without a valid external IP address, an
            ephemeral IP will be created with this
            networkTier. If an AccessConfig with a valid
            external IP address is specified, it must match
            that of the networkTier associated with the
            Address resource owning that IP. Check the
            NetworkTier enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_network_tier``.
        public_ptr_domain_name (str):
            The DNS domain name for the public PTR record. You can set
            this field only if the ``setPublicPtr`` field is enabled in
            accessConfig. If this field is unspecified in
            ipv6AccessConfig, a default PTR record will be created for
            first IP in associated external IPv6 range.

            This field is a member of `oneof`_ ``_public_ptr_domain_name``.
        security_policy (str):
            The resource URL for the security policy
            associated with this access config.

            This field is a member of `oneof`_ ``_security_policy``.
        set_public_ptr (bool):
            Specifies whether a public DNS 'PTR' record
            should be created to map the external IP address
            of the instance to a DNS domain name. This field
            is not used in ipv6AccessConfig. A default PTR
            record will be created if the VM has external
            IPv6 range associated.

            This field is a member of `oneof`_ ``_set_public_ptr``.
        type_ (str):
            The type of configuration. In accessConfigs (IPv4), the
            default and only option is ONE_TO_ONE_NAT. In
            ipv6AccessConfigs, the default and only option is
            DIRECT_IPV6. Check the Type enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_type``.
    """

    class NetworkTier(proto.Enum):
        r"""This signifies the networking tier used for configuring this
        access configuration and can only take the following values:
        PREMIUM, STANDARD. If an AccessConfig is specified without a
        valid external IP address, an ephemeral IP will be created with
        this networkTier. If an AccessConfig with a valid external IP
        address is specified, it must match that of the networkTier
        associated with the Address resource owning that IP.

        Values:
            UNDEFINED_NETWORK_TIER (0):
                A value indicating that the enum field is not
                set.
            FIXED_STANDARD (310464328):
                Public internet quality with fixed bandwidth.
            PREMIUM (399530551):
                High quality, Google-grade network tier,
                support for all networking products.
            STANDARD (484642493):
                Public internet quality, only limited support
                for other networking products.
            STANDARD_OVERRIDES_FIXED_STANDARD (465847234):
                (Output only) Temporary tier for FIXED_STANDARD when fixed
                standard tier is expired or not configured.
        """
        UNDEFINED_NETWORK_TIER = 0
        FIXED_STANDARD = 310464328
        PREMIUM = 399530551
        STANDARD = 484642493
        STANDARD_OVERRIDES_FIXED_STANDARD = 465847234

    class Type(proto.Enum):
        r"""The type of configuration. In accessConfigs (IPv4), the default and
        only option is ONE_TO_ONE_NAT. In ipv6AccessConfigs, the default and
        only option is DIRECT_IPV6.

        Values:
            UNDEFINED_TYPE (0):
                A value indicating that the enum field is not
                set.
            DIRECT_IPV6 (4397213):
                No description available.
            ONE_TO_ONE_NAT (84090205):
                No description available.
        """
        UNDEFINED_TYPE = 0
        DIRECT_IPV6 = 4397213
        ONE_TO_ONE_NAT = 84090205

    external_ipv6: str = proto.Field(
        proto.STRING,
        number=532703707,
        optional=True,
    )
    external_ipv6_prefix_length: int = proto.Field(
        proto.INT32,
        number=425672143,
        optional=True,
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )
    nat_i_p: str = proto.Field(
        proto.STRING,
        number=117634556,
        optional=True,
    )
    network_tier: str = proto.Field(
        proto.STRING,
        number=517397843,
        optional=True,
    )
    public_ptr_domain_name: str = proto.Field(
        proto.STRING,
        number=316599167,
        optional=True,
    )
    security_policy: str = proto.Field(
        proto.STRING,
        number=171082513,
        optional=True,
    )
    set_public_ptr: bool = proto.Field(
        proto.BOOL,
        number=523870229,
        optional=True,
    )
    type_: str = proto.Field(
        proto.STRING,
        number=3575610,
        optional=True,
    )


class AddAccessConfigInstanceRequest(proto.Message):
    r"""A request message for Instances.AddAccessConfig. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        access_config_resource (google.cloud.compute_v1.types.AccessConfig):
            The body resource for this request
        instance (str):
            The instance name for this request.
        network_interface (str):
            The name of the network interface to add to
            this instance.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    access_config_resource: "AccessConfig" = proto.Field(
        proto.MESSAGE,
        number=387825552,
        message="AccessConfig",
    )
    instance: str = proto.Field(
        proto.STRING,
        number=18257045,
    )
    network_interface: str = proto.Field(
        proto.STRING,
        number=365387880,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class AddAssociationFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.AddAssociation. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        firewall_policy_association_resource (google.cloud.compute_v1.types.FirewallPolicyAssociation):
            The body resource for this request
        replace_existing_association (bool):
            Indicates whether or not to replace it if an
            association of the attachment already exists.
            This is false by default, in which case an error
            will be returned if an association already
            exists.

            This field is a member of `oneof`_ ``_replace_existing_association``.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    firewall_policy_association_resource: "FirewallPolicyAssociation" = proto.Field(
        proto.MESSAGE,
        number=259546170,
        message="FirewallPolicyAssociation",
    )
    replace_existing_association: bool = proto.Field(
        proto.BOOL,
        number=209541240,
        optional=True,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AddAssociationNetworkFirewallPolicyRequest(proto.Message):
    r"""A request message for NetworkFirewallPolicies.AddAssociation.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        firewall_policy_association_resource (google.cloud.compute_v1.types.FirewallPolicyAssociation):
            The body resource for this request
        project (str):
            Project ID for this request.
        replace_existing_association (bool):
            Indicates whether or not to replace it if an
            association of the attachment already exists.
            This is false by default, in which case an error
            will be returned if an association already
            exists.

            This field is a member of `oneof`_ ``_replace_existing_association``.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    firewall_policy_association_resource: "FirewallPolicyAssociation" = proto.Field(
        proto.MESSAGE,
        number=259546170,
        message="FirewallPolicyAssociation",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    replace_existing_association: bool = proto.Field(
        proto.BOOL,
        number=209541240,
        optional=True,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AddAssociationRegionNetworkFirewallPolicyRequest(proto.Message):
    r"""A request message for
    RegionNetworkFirewallPolicies.AddAssociation. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        firewall_policy_association_resource (google.cloud.compute_v1.types.FirewallPolicyAssociation):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        replace_existing_association (bool):
            Indicates whether or not to replace it if an
            association already exists. This is false by
            default, in which case an error will be returned
            if an association already exists.

            This field is a member of `oneof`_ ``_replace_existing_association``.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    firewall_policy_association_resource: "FirewallPolicyAssociation" = proto.Field(
        proto.MESSAGE,
        number=259546170,
        message="FirewallPolicyAssociation",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    replace_existing_association: bool = proto.Field(
        proto.BOOL,
        number=209541240,
        optional=True,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AddHealthCheckTargetPoolRequest(proto.Message):
    r"""A request message for TargetPools.AddHealthCheck. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_pool (str):
            Name of the target pool to add a health check
            to.
        target_pools_add_health_check_request_resource (google.cloud.compute_v1.types.TargetPoolsAddHealthCheckRequest):
            The body resource for this request
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    target_pool: str = proto.Field(
        proto.STRING,
        number=62796298,
    )
    target_pools_add_health_check_request_resource: "TargetPoolsAddHealthCheckRequest" = proto.Field(
        proto.MESSAGE,
        number=269573412,
        message="TargetPoolsAddHealthCheckRequest",
    )


class AddInstanceTargetPoolRequest(proto.Message):
    r"""A request message for TargetPools.AddInstance. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_pool (str):
            Name of the TargetPool resource to add
            instances to.
        target_pools_add_instance_request_resource (google.cloud.compute_v1.types.TargetPoolsAddInstanceRequest):
            The body resource for this request
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    target_pool: str = proto.Field(
        proto.STRING,
        number=62796298,
    )
    target_pools_add_instance_request_resource: "TargetPoolsAddInstanceRequest" = (
        proto.Field(
            proto.MESSAGE,
            number=428796404,
            message="TargetPoolsAddInstanceRequest",
        )
    )


class AddInstancesInstanceGroupRequest(proto.Message):
    r"""A request message for InstanceGroups.AddInstances. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group (str):
            The name of the instance group where you are
            adding instances.
        instance_groups_add_instances_request_resource (google.cloud.compute_v1.types.InstanceGroupsAddInstancesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the instance group
            is located.
    """

    instance_group: str = proto.Field(
        proto.STRING,
        number=81095253,
    )
    instance_groups_add_instances_request_resource: "InstanceGroupsAddInstancesRequest" = proto.Field(
        proto.MESSAGE,
        number=453713246,
        message="InstanceGroupsAddInstancesRequest",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class AddNodesNodeGroupRequest(proto.Message):
    r"""A request message for NodeGroups.AddNodes. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        node_group (str):
            Name of the NodeGroup resource.
        node_groups_add_nodes_request_resource (google.cloud.compute_v1.types.NodeGroupsAddNodesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    node_group: str = proto.Field(
        proto.STRING,
        number=469958146,
    )
    node_groups_add_nodes_request_resource: "NodeGroupsAddNodesRequest" = proto.Field(
        proto.MESSAGE,
        number=131263288,
        message="NodeGroupsAddNodesRequest",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class AddPacketMirroringRuleNetworkFirewallPolicyRequest(proto.Message):
    r"""A request message for
    NetworkFirewallPolicies.AddPacketMirroringRule. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        firewall_policy_rule_resource (google.cloud.compute_v1.types.FirewallPolicyRule):
            The body resource for this request
        max_priority (int):
            When rule.priority is not specified, auto
            choose a unused priority between minPriority and
            maxPriority>. This field is exclusive with
            rule.priority.

            This field is a member of `oneof`_ ``_max_priority``.
        min_priority (int):
            When rule.priority is not specified, auto
            choose a unused priority between minPriority and
            maxPriority>. This field is exclusive with
            rule.priority.

            This field is a member of `oneof`_ ``_min_priority``.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    firewall_policy_rule_resource: "FirewallPolicyRule" = proto.Field(
        proto.MESSAGE,
        number=250523523,
        message="FirewallPolicyRule",
    )
    max_priority: int = proto.Field(
        proto.INT32,
        number=329635359,
        optional=True,
    )
    min_priority: int = proto.Field(
        proto.INT32,
        number=267190513,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AddPeeringNetworkRequest(proto.Message):
    r"""A request message for Networks.AddPeering. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        network (str):
            Name of the network resource to add peering
            to.
        networks_add_peering_request_resource (google.cloud.compute_v1.types.NetworksAddPeeringRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network: str = proto.Field(
        proto.STRING,
        number=232872494,
    )
    networks_add_peering_request_resource: "NetworksAddPeeringRequest" = proto.Field(
        proto.MESSAGE,
        number=388810421,
        message="NetworksAddPeeringRequest",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AddResourcePoliciesDiskRequest(proto.Message):
    r"""A request message for Disks.AddResourcePolicies. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        disk (str):
            The disk name for this request.
        disks_add_resource_policies_request_resource (google.cloud.compute_v1.types.DisksAddResourcePoliciesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    disk: str = proto.Field(
        proto.STRING,
        number=3083677,
    )
    disks_add_resource_policies_request_resource: "DisksAddResourcePoliciesRequest" = (
        proto.Field(
            proto.MESSAGE,
            number=496483363,
            message="DisksAddResourcePoliciesRequest",
        )
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class AddResourcePoliciesInstanceRequest(proto.Message):
    r"""A request message for Instances.AddResourcePolicies. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance (str):
            The instance name for this request.
        instances_add_resource_policies_request_resource (google.cloud.compute_v1.types.InstancesAddResourcePoliciesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    instance: str = proto.Field(
        proto.STRING,
        number=18257045,
    )
    instances_add_resource_policies_request_resource: "InstancesAddResourcePoliciesRequest" = proto.Field(
        proto.MESSAGE,
        number=489351963,
        message="InstancesAddResourcePoliciesRequest",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class AddResourcePoliciesRegionDiskRequest(proto.Message):
    r"""A request message for RegionDisks.AddResourcePolicies. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        disk (str):
            The disk name for this request.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        region_disks_add_resource_policies_request_resource (google.cloud.compute_v1.types.RegionDisksAddResourcePoliciesRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    disk: str = proto.Field(
        proto.STRING,
        number=3083677,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    region_disks_add_resource_policies_request_resource: "RegionDisksAddResourcePoliciesRequest" = proto.Field(
        proto.MESSAGE,
        number=284196750,
        message="RegionDisksAddResourcePoliciesRequest",
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AddRuleFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.AddRule. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        firewall_policy_rule_resource (google.cloud.compute_v1.types.FirewallPolicyRule):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    firewall_policy_rule_resource: "FirewallPolicyRule" = proto.Field(
        proto.MESSAGE,
        number=250523523,
        message="FirewallPolicyRule",
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AddRuleNetworkFirewallPolicyRequest(proto.Message):
    r"""A request message for NetworkFirewallPolicies.AddRule. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        firewall_policy_rule_resource (google.cloud.compute_v1.types.FirewallPolicyRule):
            The body resource for this request
        max_priority (int):
            When rule.priority is not specified, auto
            choose a unused priority between minPriority and
            maxPriority>. This field is exclusive with
            rule.priority.

            This field is a member of `oneof`_ ``_max_priority``.
        min_priority (int):
            When rule.priority is not specified, auto
            choose a unused priority between minPriority and
            maxPriority>. This field is exclusive with
            rule.priority.

            This field is a member of `oneof`_ ``_min_priority``.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    firewall_policy_rule_resource: "FirewallPolicyRule" = proto.Field(
        proto.MESSAGE,
        number=250523523,
        message="FirewallPolicyRule",
    )
    max_priority: int = proto.Field(
        proto.INT32,
        number=329635359,
        optional=True,
    )
    min_priority: int = proto.Field(
        proto.INT32,
        number=267190513,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AddRuleRegionNetworkFirewallPolicyRequest(proto.Message):
    r"""A request message for RegionNetworkFirewallPolicies.AddRule.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        firewall_policy_rule_resource (google.cloud.compute_v1.types.FirewallPolicyRule):
            The body resource for this request
        max_priority (int):
            When rule.priority is not specified, auto
            choose a unused priority between minPriority and
            maxPriority>. This field is exclusive with
            rule.priority.

            This field is a member of `oneof`_ ``_max_priority``.
        min_priority (int):
            When rule.priority is not specified, auto
            choose a unused priority between minPriority and
            maxPriority>. This field is exclusive with
            rule.priority.

            This field is a member of `oneof`_ ``_min_priority``.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    firewall_policy_rule_resource: "FirewallPolicyRule" = proto.Field(
        proto.MESSAGE,
        number=250523523,
        message="FirewallPolicyRule",
    )
    max_priority: int = proto.Field(
        proto.INT32,
        number=329635359,
        optional=True,
    )
    min_priority: int = proto.Field(
        proto.INT32,
        number=267190513,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AddRuleRegionSecurityPolicyRequest(proto.Message):
    r"""A request message for RegionSecurityPolicies.AddRule. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        security_policy (str):
            Name of the security policy to update.
        security_policy_rule_resource (google.cloud.compute_v1.types.SecurityPolicyRule):
            The body resource for this request
        validate_only (bool):
            If true, the request will not be committed.

            This field is a member of `oneof`_ ``_validate_only``.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    security_policy: str = proto.Field(
        proto.STRING,
        number=171082513,
    )
    security_policy_rule_resource: "SecurityPolicyRule" = proto.Field(
        proto.MESSAGE,
        number=402693443,
        message="SecurityPolicyRule",
    )
    validate_only: bool = proto.Field(
        proto.BOOL,
        number=242744629,
        optional=True,
    )


class AddRuleSecurityPolicyRequest(proto.Message):
    r"""A request message for SecurityPolicies.AddRule. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        security_policy (str):
            Name of the security policy to update.
        security_policy_rule_resource (google.cloud.compute_v1.types.SecurityPolicyRule):
            The body resource for this request
        validate_only (bool):
            If true, the request will not be committed.

            This field is a member of `oneof`_ ``_validate_only``.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    security_policy: str = proto.Field(
        proto.STRING,
        number=171082513,
    )
    security_policy_rule_resource: "SecurityPolicyRule" = proto.Field(
        proto.MESSAGE,
        number=402693443,
        message="SecurityPolicyRule",
    )
    validate_only: bool = proto.Field(
        proto.BOOL,
        number=242744629,
        optional=True,
    )


class AddSignedUrlKeyBackendBucketRequest(proto.Message):
    r"""A request message for BackendBuckets.AddSignedUrlKey. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        backend_bucket (str):
            Name of the BackendBucket resource to which
            the Signed URL Key should be added. The name
            should conform to RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        signed_url_key_resource (google.cloud.compute_v1.types.SignedUrlKey):
            The body resource for this request
    """

    backend_bucket: str = proto.Field(
        proto.STRING,
        number=91714037,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    signed_url_key_resource: "SignedUrlKey" = proto.Field(
        proto.MESSAGE,
        number=457625985,
        message="SignedUrlKey",
    )


class AddSignedUrlKeyBackendServiceRequest(proto.Message):
    r"""A request message for BackendServices.AddSignedUrlKey. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        backend_service (str):
            Name of the BackendService resource to which
            the Signed URL Key should be added. The name
            should conform to RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        signed_url_key_resource (google.cloud.compute_v1.types.SignedUrlKey):
            The body resource for this request
    """

    backend_service: str = proto.Field(
        proto.STRING,
        number=306946058,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    signed_url_key_resource: "SignedUrlKey" = proto.Field(
        proto.MESSAGE,
        number=457625985,
        message="SignedUrlKey",
    )


class Address(proto.Message):
    r"""Represents an IP Address resource. Google Compute Engine has two IP
    Address resources: \* `Global (external and
    internal) <https://cloud.google.com/compute/docs/reference/rest/v1/globalAddresses>`__
    \* `Regional (external and
    internal) <https://cloud.google.com/compute/docs/reference/rest/v1/addresses>`__
    For more information, see Reserving a static external IP address.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        address (str):
            The static IP address represented by this
            resource.

            This field is a member of `oneof`_ ``_address``.
        address_type (str):
            The type of address to reserve, either
            INTERNAL or EXTERNAL. If unspecified, defaults
            to EXTERNAL. Check the AddressType enum for the
            list of possible values.

            This field is a member of `oneof`_ ``_address_type``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this field when you create the resource.

            This field is a member of `oneof`_ ``_description``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        ip_version (str):
            The IP version that will be used by this
            address. Valid options are IPV4 or IPV6. Check
            the IpVersion enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_ip_version``.
        ipv6_endpoint_type (str):
            The endpoint type of this address, which
            should be VM or NETLB. This is used for deciding
            which type of endpoint this address can be used
            after the external IPv6 address reservation.
            Check the Ipv6EndpointType enum for the list of
            possible values.

            This field is a member of `oneof`_ ``_ipv6_endpoint_type``.
        kind (str):
            [Output Only] Type of the resource. Always compute#address
            for addresses.

            This field is a member of `oneof`_ ``_kind``.
        label_fingerprint (str):
            A fingerprint for the labels being applied to
            this Address, which is essentially a hash of the
            labels set used for optimistic locking. The
            fingerprint is initially generated by Compute
            Engine and changes after every request to modify
            or update labels. You must always provide an
            up-to-date fingerprint hash in order to update
            or change labels, otherwise the request will
            fail with error 412 conditionNotMet. To see the
            latest fingerprint, make a get() request to
            retrieve an Address.

            This field is a member of `oneof`_ ``_label_fingerprint``.
        labels (MutableMapping[str, str]):
            Labels for this resource. These can only be
            added or modified by the setLabels method. Each
            label key/value pair must comply with RFC1035.
            Label values may be empty.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?``. The first character must be
            a lowercase letter, and all following characters (except for
            the last character) must be a dash, lowercase letter, or
            digit. The last character must be a lowercase letter or
            digit.

            This field is a member of `oneof`_ ``_name``.
        network (str):
            The URL of the network in which to reserve the address. This
            field can only be used with INTERNAL type with the
            VPC_PEERING purpose.

            This field is a member of `oneof`_ ``_network``.
        network_tier (str):
            This signifies the networking tier used for
            configuring this address and can only take the
            following values: PREMIUM or STANDARD. Internal
            IP addresses are always Premium Tier; global
            external IP addresses are always Premium Tier;
            regional external IP addresses can be either
            Standard or Premium Tier. If this field is not
            specified, it is assumed to be PREMIUM. Check
            the NetworkTier enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_network_tier``.
        prefix_length (int):
            The prefix length if the resource represents
            an IP range.

            This field is a member of `oneof`_ ``_prefix_length``.
        purpose (str):
            The purpose of this resource, which can be one of the
            following values: - GCE_ENDPOINT for addresses that are used
            by VM instances, alias IP ranges, load balancers, and
            similar resources. - DNS_RESOLVER for a DNS resolver address
            in a subnetwork for a Cloud DNS inbound forwarder IP
            addresses (regional internal IP address in a subnet of a VPC
            network) - VPC_PEERING for global internal IP addresses used
            for private services access allocated ranges. - NAT_AUTO for
            the regional external IP addresses used by Cloud NAT when
            allocating addresses using automatic NAT IP address
            allocation. - IPSEC_INTERCONNECT for addresses created from
            a private IP range that are reserved for a VLAN attachment
            in an *HA VPN over Cloud Interconnect* configuration. These
            addresses are regional resources. -
            ``SHARED_LOADBALANCER_VIP`` for an internal IP address that
            is assigned to multiple internal forwarding rules. -
            ``PRIVATE_SERVICE_CONNECT`` for a private network address
            that is used to configure Private Service Connect. Only
            global internal addresses can use this purpose. Check the
            Purpose enum for the list of possible values.

            This field is a member of `oneof`_ ``_purpose``.
        region (str):
            [Output Only] The URL of the region where a regional address
            resides. For regional addresses, you must specify the region
            as a path parameter in the HTTP request URL. *This field is
            not applicable to global addresses.*

            This field is a member of `oneof`_ ``_region``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        status (str):
            [Output Only] The status of the address, which can be one of
            RESERVING, RESERVED, or IN_USE. An address that is RESERVING
            is currently in the process of being reserved. A RESERVED
            address is currently reserved and available to use. An
            IN_USE address is currently being used by another resource
            and is not available. Check the Status enum for the list of
            possible values.

            This field is a member of `oneof`_ ``_status``.
        subnetwork (str):
            The URL of the subnetwork in which to reserve the address.
            If an IP address is specified, it must be within the
            subnetwork's IP range. This field can only be used with
            INTERNAL type with a GCE_ENDPOINT or DNS_RESOLVER purpose.

            This field is a member of `oneof`_ ``_subnetwork``.
        users (MutableSequence[str]):
            [Output Only] The URLs of the resources that are using this
            address.
    """

    class AddressType(proto.Enum):
        r"""The type of address to reserve, either INTERNAL or EXTERNAL.
        If unspecified, defaults to EXTERNAL.

        Values:
            UNDEFINED_ADDRESS_TYPE (0):
                A value indicating that the enum field is not
                set.
            EXTERNAL (35607499):
                A publicly visible external IP address.
            INTERNAL (279295677):
                A private network IP address, for use with an
                Instance or Internal Load Balancer forwarding
                rule.
            UNSPECIFIED_TYPE (53933922):
                No description available.
        """
        UNDEFINED_ADDRESS_TYPE = 0
        EXTERNAL = 35607499
        INTERNAL = 279295677
        UNSPECIFIED_TYPE = 53933922

    class IpVersion(proto.Enum):
        r"""The IP version that will be used by this address. Valid
        options are IPV4 or IPV6.

        Values:
            UNDEFINED_IP_VERSION (0):
                A value indicating that the enum field is not
                set.
            IPV4 (2254341):
                No description available.
            IPV6 (2254343):
                No description available.
            UNSPECIFIED_VERSION (21850000):
                No description available.
        """
        UNDEFINED_IP_VERSION = 0
        IPV4 = 2254341
        IPV6 = 2254343
        UNSPECIFIED_VERSION = 21850000

    class Ipv6EndpointType(proto.Enum):
        r"""The endpoint type of this address, which should be VM or
        NETLB. This is used for deciding which type of endpoint this
        address can be used after the external IPv6 address reservation.

        Values:
            UNDEFINED_IPV6_ENDPOINT_TYPE (0):
                A value indicating that the enum field is not
                set.
            NETLB (74173363):
                Reserved IPv6 address can be used on network
                load balancer.
            VM (2743):
                Reserved IPv6 address can be used on VM.
        """
        UNDEFINED_IPV6_ENDPOINT_TYPE = 0
        NETLB = 74173363
        VM = 2743

    class NetworkTier(proto.Enum):
        r"""This signifies the networking tier used for configuring this
        address and can only take the following values: PREMIUM or
        STANDARD. Internal IP addresses are always Premium Tier; global
        external IP addresses are always Premium Tier; regional external
        IP addresses can be either Standard or Premium Tier. If this
        field is not specified, it is assumed to be PREMIUM.

        Values:
            UNDEFINED_NETWORK_TIER (0):
                A value indicating that the enum field is not
                set.
            FIXED_STANDARD (310464328):
                Public internet quality with fixed bandwidth.
            PREMIUM (399530551):
                High quality, Google-grade network tier,
                support for all networking products.
            STANDARD (484642493):
                Public internet quality, only limited support
                for other networking products.
            STANDARD_OVERRIDES_FIXED_STANDARD (465847234):
                (Output only) Temporary tier for FIXED_STANDARD when fixed
                standard tier is expired or not configured.
        """
        UNDEFINED_NETWORK_TIER = 0
        FIXED_STANDARD = 310464328
        PREMIUM = 399530551
        STANDARD = 484642493
        STANDARD_OVERRIDES_FIXED_STANDARD = 465847234

    class Purpose(proto.Enum):
        r"""The purpose of this resource, which can be one of the following
        values: - GCE_ENDPOINT for addresses that are used by VM instances,
        alias IP ranges, load balancers, and similar resources. -
        DNS_RESOLVER for a DNS resolver address in a subnetwork for a Cloud
        DNS inbound forwarder IP addresses (regional internal IP address in
        a subnet of a VPC network) - VPC_PEERING for global internal IP
        addresses used for private services access allocated ranges. -
        NAT_AUTO for the regional external IP addresses used by Cloud NAT
        when allocating addresses using automatic NAT IP address allocation.
        - IPSEC_INTERCONNECT for addresses created from a private IP range
        that are reserved for a VLAN attachment in an *HA VPN over Cloud
        Interconnect* configuration. These addresses are regional resources.
        - ``SHARED_LOADBALANCER_VIP`` for an internal IP address that is
        assigned to multiple internal forwarding rules. -
        ``PRIVATE_SERVICE_CONNECT`` for a private network address that is
        used to configure Private Service Connect. Only global internal
        addresses can use this purpose.

        Values:
            UNDEFINED_PURPOSE (0):
                A value indicating that the enum field is not
                set.
            DNS_RESOLVER (476114556):
                DNS resolver address in the subnetwork.
            GCE_ENDPOINT (230515243):
                VM internal/alias IP, Internal LB service IP,
                etc.
            IPSEC_INTERCONNECT (340437251):
                A regional internal IP address range reserved
                for the VLAN attachment that is used in HA VPN
                over Cloud Interconnect. This regional internal
                IP address range must not overlap with any IP
                address range of subnet/route in the VPC network
                and its peering networks. After the VLAN
                attachment is created with the reserved IP
                address range, when creating a new VPN gateway,
                its interface IP address is allocated from the
                associated VLAN attachment’s IP address range.
            NAT_AUTO (163666477):
                External IP automatically reserved for Cloud
                NAT.
            PRIVATE_SERVICE_CONNECT (48134724):
                A private network IP address that can be used
                to configure Private Service Connect. This
                purpose can be specified only for GLOBAL
                addresses of Type INTERNAL
            SERVERLESS (270492508):
                A regional internal IP address range reserved
                for Serverless.
            SHARED_LOADBALANCER_VIP (294447572):
                A private network IP address that can be
                shared by multiple Internal Load Balancer
                forwarding rules.
            VPC_PEERING (400800170):
                IP range for peer networks.
        """
        UNDEFINED_PURPOSE = 0
        DNS_RESOLVER = 476114556
        GCE_ENDPOINT = 230515243
        IPSEC_INTERCONNECT = 340437251
        NAT_AUTO = 163666477
        PRIVATE_SERVICE_CONNECT = 48134724
        SERVERLESS = 270492508
        SHARED_LOADBALANCER_VIP = 294447572
        VPC_PEERING = 400800170

    class Status(proto.Enum):
        r"""[Output Only] The status of the address, which can be one of
        RESERVING, RESERVED, or IN_USE. An address that is RESERVING is
        currently in the process of being reserved. A RESERVED address is
        currently reserved and available to use. An IN_USE address is
        currently being used by another resource and is not available.

        Values:
            UNDEFINED_STATUS (0):
                A value indicating that the enum field is not
                set.
            IN_USE (17393485):
                Address is being used by another resource and
                is not available.
            RESERVED (432241448):
                Address is reserved and available to use.
            RESERVING (514587225):
                Address is being reserved.
        """
        UNDEFINED_STATUS = 0
        IN_USE = 17393485
        RESERVED = 432241448
        RESERVING = 514587225

    address: str = proto.Field(
        proto.STRING,
        number=462920692,
        optional=True,
    )
    address_type: str = proto.Field(
        proto.STRING,
        number=264307877,
        optional=True,
    )
    creation_timestamp: str = proto.Field(
        proto.STRING,
        number=30525366,
        optional=True,
    )
    description: str = proto.Field(
        proto.STRING,
        number=422937596,
        optional=True,
    )
    id: int = proto.Field(
        proto.UINT64,
        number=3355,
        optional=True,
    )
    ip_version: str = proto.Field(
        proto.STRING,
        number=294959552,
        optional=True,
    )
    ipv6_endpoint_type: str = proto.Field(
        proto.STRING,
        number=97501004,
        optional=True,
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    label_fingerprint: str = proto.Field(
        proto.STRING,
        number=178124825,
        optional=True,
    )
    labels: MutableMapping[str, str] = proto.MapField(
        proto.STRING,
        proto.STRING,
        number=500195327,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )
    network: str = proto.Field(
        proto.STRING,
        number=232872494,
        optional=True,
    )
    network_tier: str = proto.Field(
        proto.STRING,
        number=517397843,
        optional=True,
    )
    prefix_length: int = proto.Field(
        proto.INT32,
        number=453565747,
        optional=True,
    )
    purpose: str = proto.Field(
        proto.STRING,
        number=316407070,
        optional=True,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    status: str = proto.Field(
        proto.STRING,
        number=181260274,
        optional=True,
    )
    subnetwork: str = proto.Field(
        proto.STRING,
        number=307827694,
        optional=True,
    )
    users: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=111578632,
    )


class AddressAggregatedList(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableMapping[str, google.cloud.compute_v1.types.AddressesScopedList]):
            A list of AddressesScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#addressAggregatedList for aggregated lists of
            addresses.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (MutableSequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableMapping[str, "AddressesScopedList"] = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="AddressesScopedList",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    unreachables: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=243372063,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class AddressList(proto.Message):
    r"""Contains a list of addresses.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableSequence[google.cloud.compute_v1.types.Address]):
            A list of Address resources.
        kind (str):
            [Output Only] Type of resource. Always compute#addressList
            for lists of addresses.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableSequence["Address"] = proto.RepeatedField(
        proto.MESSAGE,
        number=100526016,
        message="Address",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class AddressesScopedList(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        addresses (MutableSequence[google.cloud.compute_v1.types.Address]):
            [Output Only] A list of addresses contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of addresses when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    addresses: MutableSequence["Address"] = proto.RepeatedField(
        proto.MESSAGE,
        number=337673122,
        message="Address",
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class AdvancedMachineFeatures(proto.Message):
    r"""Specifies options for controlling advanced machine features.
    Options that would traditionally be configured in a BIOS belong
    here. Features that require operating system support may have
    corresponding entries in the GuestOsFeatures of an Image (e.g.,
    whether or not the OS in the Image supports nested
    virtualization being enabled or disabled).


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        enable_nested_virtualization (bool):
            Whether to enable nested virtualization or
            not (default is false).

            This field is a member of `oneof`_ ``_enable_nested_virtualization``.
        enable_uefi_networking (bool):
            Whether to enable UEFI networking for
            instance creation.

            This field is a member of `oneof`_ ``_enable_uefi_networking``.
        performance_monitoring_unit (str):
            Type of Performance Monitoring Unit requested
            on instance. Check the PerformanceMonitoringUnit
            enum for the list of possible values.

            This field is a member of `oneof`_ ``_performance_monitoring_unit``.
        threads_per_core (int):
            The number of threads per physical core. To
            disable simultaneous multithreading (SMT) set
            this to 1. If unset, the maximum number of
            threads supported per core by the underlying
            processor is assumed.

            This field is a member of `oneof`_ ``_threads_per_core``.
        turbo_mode (str):
            Turbo frequency mode to use for the instance. Supported
            modes include: \* ALL_CORE_MAX Using empty string or not
            setting this field will use the platform-specific default
            turbo mode.

            This field is a member of `oneof`_ ``_turbo_mode``.
        visible_core_count (int):
            The number of physical cores to expose to an
            instance. Multiply by the number of threads per
            core to compute the total number of virtual CPUs
            to expose to the instance. If unset, the number
            of cores is inferred from the instance's nominal
            CPU count and the underlying platform's SMT
            width.

            This field is a member of `oneof`_ ``_visible_core_count``.
    """

    class PerformanceMonitoringUnit(proto.Enum):
        r"""Type of Performance Monitoring Unit requested on instance.

        Values:
            UNDEFINED_PERFORMANCE_MONITORING_UNIT (0):
                A value indicating that the enum field is not
                set.
            ARCHITECTURAL (155113693):
                Architecturally defined non-LLC events.
            ENHANCED (476873590):
                Most documented core/L2 and LLC events.
            PERFORMANCE_MONITORING_UNIT_UNSPECIFIED (429210692):
                No description available.
            STANDARD (484642493):
                Most documented core/L2 events.
        """
        UNDEFINED_PERFORMANCE_MONITORING_UNIT = 0
        ARCHITECTURAL = 155113693
        ENHANCED = 476873590
        PERFORMANCE_MONITORING_UNIT_UNSPECIFIED = 429210692
        STANDARD = 484642493

    enable_nested_virtualization: bool = proto.Field(
        proto.BOOL,
        number=16639365,
        optional=True,
    )
    enable_uefi_networking: bool = proto.Field(
        proto.BOOL,
        number=334485668,
        optional=True,
    )
    performance_monitoring_unit: str = proto.Field(
        proto.STRING,
        number=533618956,
        optional=True,
    )
    threads_per_core: int = proto.Field(
        proto.INT32,
        number=352611671,
        optional=True,
    )
    turbo_mode: str = proto.Field(
        proto.STRING,
        number=432965412,
        optional=True,
    )
    visible_core_count: int = proto.Field(
        proto.INT32,
        number=193198684,
        optional=True,
    )


class AggregatedListAcceleratorTypesRequest(proto.Message):
    r"""A request message for AcceleratorTypes.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListAddressesRequest(proto.Message):
    r"""A request message for Addresses.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListAutoscalersRequest(proto.Message):
    r"""A request message for Autoscalers.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListBackendServicesRequest(proto.Message):
    r"""A request message for BackendServices.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListDiskTypesRequest(proto.Message):
    r"""A request message for DiskTypes.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListDisksRequest(proto.Message):
    r"""A request message for Disks.AggregatedList. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListForwardingRulesRequest(proto.Message):
    r"""A request message for ForwardingRules.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListGlobalOperationsRequest(proto.Message):
    r"""A request message for GlobalOperations.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListHealthChecksRequest(proto.Message):
    r"""A request message for HealthChecks.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListInstanceGroupManagersRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.AggregatedList.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListInstanceGroupsRequest(proto.Message):
    r"""A request message for InstanceGroups.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListInstanceTemplatesRequest(proto.Message):
    r"""A request message for InstanceTemplates.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListInstancesRequest(proto.Message):
    r"""A request message for Instances.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListInstantSnapshotsRequest(proto.Message):
    r"""A request message for InstantSnapshots.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListInterconnectAttachmentsRequest(proto.Message):
    r"""A request message for InterconnectAttachments.AggregatedList.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListMachineTypesRequest(proto.Message):
    r"""A request message for MachineTypes.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListNetworkAttachmentsRequest(proto.Message):
    r"""A request message for NetworkAttachments.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListNetworkEdgeSecurityServicesRequest(proto.Message):
    r"""A request message for
    NetworkEdgeSecurityServices.AggregatedList. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListNetworkEndpointGroupsRequest(proto.Message):
    r"""A request message for NetworkEndpointGroups.AggregatedList.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListNetworkFirewallPoliciesRequest(proto.Message):
    r"""A request message for NetworkFirewallPolicies.AggregatedList.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListNodeGroupsRequest(proto.Message):
    r"""A request message for NodeGroups.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListNodeTemplatesRequest(proto.Message):
    r"""A request message for NodeTemplates.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListNodeTypesRequest(proto.Message):
    r"""A request message for NodeTypes.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListPacketMirroringsRequest(proto.Message):
    r"""A request message for PacketMirrorings.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListPublicDelegatedPrefixesRequest(proto.Message):
    r"""A request message for PublicDelegatedPrefixes.AggregatedList.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListRegionCommitmentsRequest(proto.Message):
    r"""A request message for RegionCommitments.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListReservationsRequest(proto.Message):
    r"""A request message for Reservations.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListResourcePoliciesRequest(proto.Message):
    r"""A request message for ResourcePolicies.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListRoutersRequest(proto.Message):
    r"""A request message for Routers.AggregatedList. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListSecurityPoliciesRequest(proto.Message):
    r"""A request message for SecurityPolicies.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListServiceAttachmentsRequest(proto.Message):
    r"""A request message for ServiceAttachments.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListSslCertificatesRequest(proto.Message):
    r"""A request message for SslCertificates.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListSslPoliciesRequest(proto.Message):
    r"""A request message for SslPolicies.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListStoragePoolTypesRequest(proto.Message):
    r"""A request message for StoragePoolTypes.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListStoragePoolsRequest(proto.Message):
    r"""A request message for StoragePools.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListSubnetworksRequest(proto.Message):
    r"""A request message for Subnetworks.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListTargetHttpProxiesRequest(proto.Message):
    r"""A request message for TargetHttpProxies.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListTargetHttpsProxiesRequest(proto.Message):
    r"""A request message for TargetHttpsProxies.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListTargetInstancesRequest(proto.Message):
    r"""A request message for TargetInstances.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListTargetPoolsRequest(proto.Message):
    r"""A request message for TargetPools.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListTargetTcpProxiesRequest(proto.Message):
    r"""A request message for TargetTcpProxies.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListTargetVpnGatewaysRequest(proto.Message):
    r"""A request message for TargetVpnGateways.AggregatedList. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListUrlMapsRequest(proto.Message):
    r"""A request message for UrlMaps.AggregatedList. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Name of the project scoping this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListVpnGatewaysRequest(proto.Message):
    r"""A request message for VpnGateways.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AggregatedListVpnTunnelsRequest(proto.Message):
    r"""A request message for VpnTunnels.AggregatedList. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter expression that filters resources listed in the
            response. Most Compute resources support two types of filter
            expressions: expressions that support regular expressions
            and expressions that follow API improvement proposal
            AIP-160. These two types of filter expressions cannot be
            mixed in one request. If you want to use AIP-160, your
            expression must specify the field name, an operator, and the
            value that you want to use for filtering. The value must be
            a string, a number, or a boolean. The operator must be
            either ``=``, ``!=``, ``>``, ``<``, ``<=``, ``>=`` or ``:``.
            For example, if you are filtering Compute Engine instances,
            you can exclude instances named ``example-instance`` by
            specifying ``name != example-instance``. The ``:*``
            comparison can be used to test whether a key has been
            defined. For example, to find all objects with ``owner``
            label use: ``labels.owner:*`` You can also filter nested
            fields. For example, you could specify
            ``scheduling.automaticRestart = false`` to include instances
            only if they are not scheduled for automatic restarts. You
            can use filtering on nested fields to filter based on
            resource labels. To filter on multiple expressions, provide
            each separate expression within parentheses. For example:
            ``(scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")``
            By default, each expression is an ``AND`` expression.
            However, you can include ``AND`` and ``OR`` expressions
            explicitly. For example:
            ``(cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true)``
            If you want to use a regular expression, use the ``eq``
            (equal) or ``ne`` (not equal) operator against a single
            un-parenthesized expression with or without quotes or
            against multiple parenthesized expressions. Examples:
            ``fieldname eq unquoted literal``
            ``fieldname eq 'single quoted literal'``
            ``fieldname eq "double quoted literal"``
            ``(fieldname1 eq literal) (fieldname2 ne "literal")`` The
            literal value is interpreted as a regular expression using
            Google RE2 library syntax. The literal value must match the
            entire field. For example, to filter for instances that do
            not end with name "instance", you would use
            ``name ne .*instance``. You cannot combine constraints on
            multiple fields using regular expressions.

            This field is a member of `oneof`_ ``_filter``.
        include_all_scopes (bool):
            Indicates whether every visible scope for
            each scope type (zone, region, global) should be
            included in the response. For new resource types
            added after this field, the flag has no effect
            as new resource types will always include every
            visible scope for each scope type in response.
            For resource types which predate this field, if
            this flag is omitted or false, only scopes of
            the scope types where the resource type is
            expected to be found will be included.

            This field is a member of `oneof`_ ``_include_all_scopes``.
        max_results (int):
            The maximum number of results per page that should be
            returned. If the number of available results is larger than
            ``maxResults``, Compute Engine returns a ``nextPageToken``
            that can be used to get the next page of results in
            subsequent list requests. Acceptable values are ``0`` to
            ``500``, inclusive. (Default: ``500``)

            This field is a member of `oneof`_ ``_max_results``.
        order_by (str):
            Sorts list results by a certain order. By default, results
            are returned in alphanumerical order based on the resource
            name. You can also sort results in descending order based on
            the creation timestamp using
            ``orderBy="creationTimestamp desc"``. This sorts results
            based on the ``creationTimestamp`` field in reverse
            chronological order (newest result first). Use this to sort
            resources like operations so that the newest operation is
            returned first. Currently, only sorting by ``name`` or
            ``creationTimestamp desc`` is supported.

            This field is a member of `oneof`_ ``_order_by``.
        page_token (str):
            Specifies a page token to use. Set ``pageToken`` to the
            ``nextPageToken`` returned by a previous list request to get
            the next page of results.

            This field is a member of `oneof`_ ``_page_token``.
        project (str):
            Project ID for this request.
        return_partial_success (bool):
            Opt-in for partial success behavior which
            provides partial results in case of failure. The
            default value is false. For example, when
            partial success behavior is enabled,
            aggregatedList for a single zone scope either
            returns all resources in the zone or no
            resources, with an error code.

            This field is a member of `oneof`_ ``_return_partial_success``.
        service_project_number (int):
            The Shared VPC service project id or service
            project number for which aggregated list request
            is invoked for subnetworks list-usable api.

            This field is a member of `oneof`_ ``_service_project_number``.
    """

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    include_all_scopes: bool = proto.Field(
        proto.BOOL,
        number=391327988,
        optional=True,
    )
    max_results: int = proto.Field(
        proto.UINT32,
        number=54715419,
        optional=True,
    )
    order_by: str = proto.Field(
        proto.STRING,
        number=160562920,
        optional=True,
    )
    page_token: str = proto.Field(
        proto.STRING,
        number=19994697,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    return_partial_success: bool = proto.Field(
        proto.BOOL,
        number=517198390,
        optional=True,
    )
    service_project_number: int = proto.Field(
        proto.INT64,
        number=316757497,
        optional=True,
    )


class AliasIpRange(proto.Message):
    r"""An alias IP range attached to an instance's network
    interface.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        ip_cidr_range (str):
            The IP alias ranges to allocate for this
            interface. This IP CIDR range must belong to the
            specified subnetwork and cannot contain IP
            addresses reserved by system or used by other
            network interfaces. This range may be a single
            IP address (such as 10.2.3.4), a netmask (such
            as /24) or a CIDR-formatted string (such as
            10.1.2.0/24).

            This field is a member of `oneof`_ ``_ip_cidr_range``.
        subnetwork_range_name (str):
            The name of a subnetwork secondary IP range
            from which to allocate an IP alias range. If not
            specified, the primary range of the subnetwork
            is used.

            This field is a member of `oneof`_ ``_subnetwork_range_name``.
    """

    ip_cidr_range: str = proto.Field(
        proto.STRING,
        number=98117322,
        optional=True,
    )
    subnetwork_range_name: str = proto.Field(
        proto.STRING,
        number=387995966,
        optional=True,
    )


class AllocationAggregateReservation(proto.Message):
    r"""This reservation type is specified by total resource amounts
    (e.g. total count of CPUs) and can account for multiple instance
    SKUs. In other words, one can create instances of varying shapes
    against this reservation.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        in_use_resources (MutableSequence[google.cloud.compute_v1.types.AllocationAggregateReservationReservedResourceInfo]):
            [Output only] List of resources currently in use.
        reserved_resources (MutableSequence[google.cloud.compute_v1.types.AllocationAggregateReservationReservedResourceInfo]):
            List of reserved resources (CPUs, memory,
            accelerators).
        vm_family (str):
            The VM family that all instances scheduled
            against this reservation must belong to. Check
            the VmFamily enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_vm_family``.
        workload_type (str):
            The workload type of the instances that will
            target this reservation. Check the WorkloadType
            enum for the list of possible values.

            This field is a member of `oneof`_ ``_workload_type``.
    """

    class VmFamily(proto.Enum):
        r"""The VM family that all instances scheduled against this
        reservation must belong to.

        Values:
            UNDEFINED_VM_FAMILY (0):
                A value indicating that the enum field is not
                set.
            VM_FAMILY_CLOUD_TPU_DEVICE_CT3 (42845948):
                No description available.
            VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L (108020067):
                No description available.
            VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP (18705267):
                No description available.
            VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E (398926997):
                No description available.
            VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P (517384376):
                No description available.
            VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P (517384407):
                No description available.
            VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P (517384438):
                No description available.
        """
        UNDEFINED_VM_FAMILY = 0
        VM_FAMILY_CLOUD_TPU_DEVICE_CT3 = 42845948
        VM_FAMILY_CLOUD_TPU_LITE_DEVICE_CT5L = 108020067
        VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT5LP = 18705267
        VM_FAMILY_CLOUD_TPU_LITE_POD_SLICE_CT6E = 398926997
        VM_FAMILY_CLOUD_TPU_POD_SLICE_CT3P = 517384376
        VM_FAMILY_CLOUD_TPU_POD_SLICE_CT4P = 517384407
        VM_FAMILY_CLOUD_TPU_POD_SLICE_CT5P = 517384438

    class WorkloadType(proto.Enum):
        r"""The workload type of the instances that will target this
        reservation.

        Values:
            UNDEFINED_WORKLOAD_TYPE (0):
                A value indicating that the enum field is not
                set.
            BATCH (62971674):
                Reserved resources will be optimized for
                BATCH workloads, such as ML training.
            SERVING (17781740):
                Reserved resources will be optimized for
                SERVING workloads, such as ML inference.
            UNSPECIFIED (526786327):
                No description available.
        """
        UNDEFINED_WORKLOAD_TYPE = 0
        BATCH = 62971674
        SERVING = 17781740
        UNSPECIFIED = 526786327

    in_use_resources: MutableSequence[
        "AllocationAggregateReservationReservedResourceInfo"
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=409009107,
        message="AllocationAggregateReservationReservedResourceInfo",
    )
    reserved_resources: MutableSequence[
        "AllocationAggregateReservationReservedResourceInfo"
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=213217742,
        message="AllocationAggregateReservationReservedResourceInfo",
    )
    vm_family: str = proto.Field(
        proto.STRING,
        number=125017580,
        optional=True,
    )
    workload_type: str = proto.Field(
        proto.STRING,
        number=273432322,
        optional=True,
    )


class AllocationAggregateReservationReservedResourceInfo(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        accelerator (google.cloud.compute_v1.types.AllocationAggregateReservationReservedResourceInfoAccelerator):
            Properties of accelerator resources in this
            reservation.

            This field is a member of `oneof`_ ``_accelerator``.
    """

    accelerator: "AllocationAggregateReservationReservedResourceInfoAccelerator" = (
        proto.Field(
            proto.MESSAGE,
            number=424338027,
            optional=True,
            message="AllocationAggregateReservationReservedResourceInfoAccelerator",
        )
    )


class AllocationAggregateReservationReservedResourceInfoAccelerator(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        accelerator_count (int):
            Number of accelerators of specified type.

            This field is a member of `oneof`_ ``_accelerator_count``.
        accelerator_type (str):
            Full or partial URL to accelerator type. e.g.
            "projects/{PROJECT}/zones/{ZONE}/acceleratorTypes/ct4l".

            This field is a member of `oneof`_ ``_accelerator_type``.
    """

    accelerator_count: int = proto.Field(
        proto.INT32,
        number=504879675,
        optional=True,
    )
    accelerator_type: str = proto.Field(
        proto.STRING,
        number=138031246,
        optional=True,
    )


class AllocationReservationSharingPolicy(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        service_share_type (str):
            Sharing config for all Google Cloud services.
            Check the ServiceShareType enum for the list of
            possible values.

            This field is a member of `oneof`_ ``_service_share_type``.
    """

    class ServiceShareType(proto.Enum):
        r"""Sharing config for all Google Cloud services.

        Values:
            UNDEFINED_SERVICE_SHARE_TYPE (0):
                A value indicating that the enum field is not
                set.
            ALLOW_ALL (475536235):
                Allow all Google Cloud managed services to
                share reservations.
            DISALLOW_ALL (277786301):
                [Default] Disallow sharing with all Google Cloud services.
            SERVICE_SHARE_TYPE_UNSPECIFIED (279057148):
                No description available.
        """
        UNDEFINED_SERVICE_SHARE_TYPE = 0
        ALLOW_ALL = 475536235
        DISALLOW_ALL = 277786301
        SERVICE_SHARE_TYPE_UNSPECIFIED = 279057148

    service_share_type: str = proto.Field(
        proto.STRING,
        number=514508644,
        optional=True,
    )


class AllocationResourceStatus(proto.Message):
    r"""[Output Only] Contains output only fields.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        reservation_block_count (int):
            The number of reservation blocks associated
            with this reservation.

            This field is a member of `oneof`_ ``_reservation_block_count``.
        reservation_maintenance (google.cloud.compute_v1.types.GroupMaintenanceInfo):
            Maintenance information for this reservation

            This field is a member of `oneof`_ ``_reservation_maintenance``.
        specific_sku_allocation (google.cloud.compute_v1.types.AllocationResourceStatusSpecificSKUAllocation):
            Allocation Properties of this reservation.

            This field is a member of `oneof`_ ``_specific_sku_allocation``.
    """

    reservation_block_count: int = proto.Field(
        proto.INT32,
        number=161835754,
        optional=True,
    )
    reservation_maintenance: "GroupMaintenanceInfo" = proto.Field(
        proto.MESSAGE,
        number=340607776,
        optional=True,
        message="GroupMaintenanceInfo",
    )
    specific_sku_allocation: "AllocationResourceStatusSpecificSKUAllocation" = (
        proto.Field(
            proto.MESSAGE,
            number=196231151,
            optional=True,
            message="AllocationResourceStatusSpecificSKUAllocation",
        )
    )


class AllocationResourceStatusSpecificSKUAllocation(proto.Message):
    r"""Contains Properties set for the reservation.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        source_instance_template_id (str):
            ID of the instance template used to populate
            reservation properties.

            This field is a member of `oneof`_ ``_source_instance_template_id``.
        utilizations (MutableMapping[str, int]):
            Per service utilization breakdown. The Key is
            the Google Cloud managed service name.
    """

    source_instance_template_id: str = proto.Field(
        proto.STRING,
        number=111196154,
        optional=True,
    )
    utilizations: MutableMapping[str, int] = proto.MapField(
        proto.STRING,
        proto.INT64,
        number=402495121,
    )


class AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk(
    proto.Message
):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        disk_size_gb (int):
            Specifies the size of the disk in base-2 GB.

            This field is a member of `oneof`_ ``_disk_size_gb``.
        interface (str):
            Specifies the disk interface to use for
            attaching this disk, which is either SCSI or
            NVME. The default is SCSI. For performance
            characteristics of SCSI over NVMe, see Local SSD
            performance. Check the Interface enum for the
            list of possible values.

            This field is a member of `oneof`_ ``_interface``.
    """

    class Interface(proto.Enum):
        r"""Specifies the disk interface to use for attaching this disk,
        which is either SCSI or NVME. The default is SCSI. For
        performance characteristics of SCSI over NVMe, see Local SSD
        performance.

        Values:
            UNDEFINED_INTERFACE (0):
                A value indicating that the enum field is not
                set.
            NVME (2408800):
                No description available.
            SCSI (2539686):
                No description available.
        """
        UNDEFINED_INTERFACE = 0
        NVME = 2408800
        SCSI = 2539686

    disk_size_gb: int = proto.Field(
        proto.INT64,
        number=316263735,
        optional=True,
    )
    interface: str = proto.Field(
        proto.STRING,
        number=502623545,
        optional=True,
    )


class AllocationSpecificSKUAllocationReservedInstanceProperties(proto.Message):
    r"""Properties of the SKU instances being reserved. Next ID: 9

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        guest_accelerators (MutableSequence[google.cloud.compute_v1.types.AcceleratorConfig]):
            Specifies accelerator type and count.
        local_ssds (MutableSequence[google.cloud.compute_v1.types.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk]):
            Specifies amount of local ssd to reserve with
            each instance. The type of disk is local-ssd.
        location_hint (str):
            An opaque location hint used to place the
            allocation close to other resources. This field
            is for use by internal tools that use the public
            API.

            This field is a member of `oneof`_ ``_location_hint``.
        machine_type (str):
            Specifies type of machine (name only) which has fixed number
            of vCPUs and fixed amount of memory. This also includes
            specifying custom machine type following
            custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.

            This field is a member of `oneof`_ ``_machine_type``.
        min_cpu_platform (str):
            Minimum cpu platform the reservation.

            This field is a member of `oneof`_ ``_min_cpu_platform``.
    """

    guest_accelerators: MutableSequence["AcceleratorConfig"] = proto.RepeatedField(
        proto.MESSAGE,
        number=463595119,
        message="AcceleratorConfig",
    )
    local_ssds: MutableSequence[
        "AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk"
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=229951299,
        message="AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
    )
    location_hint: str = proto.Field(
        proto.STRING,
        number=350519505,
        optional=True,
    )
    machine_type: str = proto.Field(
        proto.STRING,
        number=227711026,
        optional=True,
    )
    min_cpu_platform: str = proto.Field(
        proto.STRING,
        number=242912759,
        optional=True,
    )


class AllocationSpecificSKUReservation(proto.Message):
    r"""This reservation type allows to pre allocate specific
    instance configuration.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        assured_count (int):
            [Output Only] Indicates how many instances are actually
            usable currently.

            This field is a member of `oneof`_ ``_assured_count``.
        count (int):
            Specifies the number of resources that are
            allocated.

            This field is a member of `oneof`_ ``_count``.
        in_use_count (int):
            [Output Only] Indicates how many instances are in use.

            This field is a member of `oneof`_ ``_in_use_count``.
        instance_properties (google.cloud.compute_v1.types.AllocationSpecificSKUAllocationReservedInstanceProperties):
            The instance properties for the reservation.

            This field is a member of `oneof`_ ``_instance_properties``.
        source_instance_template (str):
            Specifies the instance template to create the
            reservation. If you use this field, you must
            exclude the instanceProperties field. This field
            is optional, and it can be a full or partial
            URL. For example, the following are all valid
            URLs to an instance template: -
            https://www.googleapis.com/compute/v1/projects/project
            /global/instanceTemplates/instanceTemplate -
            projects/project/global/instanceTemplates/instanceTemplate
            - global/instanceTemplates/instanceTemplate

            This field is a member of `oneof`_ ``_source_instance_template``.
    """

    assured_count: int = proto.Field(
        proto.INT64,
        number=281197645,
        optional=True,
    )
    count: int = proto.Field(
        proto.INT64,
        number=94851343,
        optional=True,
    )
    in_use_count: int = proto.Field(
        proto.INT64,
        number=493458877,
        optional=True,
    )
    instance_properties: "AllocationSpecificSKUAllocationReservedInstanceProperties" = (
        proto.Field(
            proto.MESSAGE,
            number=215355165,
            optional=True,
            message="AllocationSpecificSKUAllocationReservedInstanceProperties",
        )
    )
    source_instance_template: str = proto.Field(
        proto.STRING,
        number=332423616,
        optional=True,
    )


class Allowed(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        I_p_protocol (str):
            The IP protocol to which this rule applies.
            The protocol type is required when creating a
            firewall rule. This value can either be one of
            the following well known protocol strings (tcp,
            udp, icmp, esp, ah, ipip, sctp) or the IP
            protocol number.

            This field is a member of `oneof`_ ``_I_p_protocol``.
        ports (MutableSequence[str]):
            An optional list of ports to which this rule applies. This
            field is only applicable for the UDP or TCP protocol. Each
            entry must be either an integer or a range. If not
            specified, this rule applies to connections through any
            port. Example inputs include: ["22"], ["80","443"], and
            ["12345-12349"].
    """

    I_p_protocol: str = proto.Field(
        proto.STRING,
        number=488094525,
        optional=True,
    )
    ports: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=106854418,
    )


class AnnouncePublicAdvertisedPrefixeRequest(proto.Message):
    r"""A request message for PublicAdvertisedPrefixes.Announce. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        public_advertised_prefix (str):
            The name of the public advertised prefix. It
            should comply with RFC1035.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    public_advertised_prefix: str = proto.Field(
        proto.STRING,
        number=101874590,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AnnouncePublicDelegatedPrefixeRequest(proto.Message):
    r"""A request message for PublicDelegatedPrefixes.Announce. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        public_delegated_prefix (str):
            The name of the public delegated prefix. It
            should comply with RFC1035.
        region (str):
            The name of the region where the public
            delegated prefix is located. It should comply
            with RFC1035.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    public_delegated_prefix: str = proto.Field(
        proto.STRING,
        number=204238440,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class ApplyUpdatesToInstancesInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    InstanceGroupManagers.ApplyUpdatesToInstances. See the method
    description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group,
            should conform to RFC1035.
        instance_group_managers_apply_updates_request_resource (google.cloud.compute_v1.types.InstanceGroupManagersApplyUpdatesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone where the managed
            instance group is located. Should conform to
            RFC1035.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    instance_group_managers_apply_updates_request_resource: "InstanceGroupManagersApplyUpdatesRequest" = proto.Field(
        proto.MESSAGE,
        number=259242835,
        message="InstanceGroupManagersApplyUpdatesRequest",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    RegionInstanceGroupManagers.ApplyUpdatesToInstances. See the
    method description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group,
            should conform to RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request,
            should conform to RFC1035.
        region_instance_group_managers_apply_updates_request_resource (google.cloud.compute_v1.types.RegionInstanceGroupManagersApplyUpdatesRequest):
            The body resource for this request
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    region_instance_group_managers_apply_updates_request_resource: "RegionInstanceGroupManagersApplyUpdatesRequest" = proto.Field(
        proto.MESSAGE,
        number=76248318,
        message="RegionInstanceGroupManagersApplyUpdatesRequest",
    )


class AttachDiskInstanceRequest(proto.Message):
    r"""A request message for Instances.AttachDisk. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        attached_disk_resource (google.cloud.compute_v1.types.AttachedDisk):
            The body resource for this request
        force_attach (bool):
            Whether to force attach the regional disk
            even if it's currently attached to another
            instance. If you try to force attach a zonal
            disk to an instance, you will receive an error.

            This field is a member of `oneof`_ ``_force_attach``.
        instance (str):
            The instance name for this request.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    attached_disk_resource: "AttachedDisk" = proto.Field(
        proto.MESSAGE,
        number=90605845,
        message="AttachedDisk",
    )
    force_attach: bool = proto.Field(
        proto.BOOL,
        number=142758425,
        optional=True,
    )
    instance: str = proto.Field(
        proto.STRING,
        number=18257045,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for
    GlobalNetworkEndpointGroups.AttachNetworkEndpoints. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        global_network_endpoint_groups_attach_endpoints_request_resource (google.cloud.compute_v1.types.GlobalNetworkEndpointGroupsAttachEndpointsRequest):
            The body resource for this request
        network_endpoint_group (str):
            The name of the network endpoint group where
            you are attaching network endpoints to. It
            should comply with RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    global_network_endpoint_groups_attach_endpoints_request_resource: "GlobalNetworkEndpointGroupsAttachEndpointsRequest" = proto.Field(
        proto.MESSAGE,
        number=30691563,
        message="GlobalNetworkEndpointGroupsAttachEndpointsRequest",
    )
    network_endpoint_group: str = proto.Field(
        proto.STRING,
        number=433907078,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AttachNetworkEndpointsNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for
    NetworkEndpointGroups.AttachNetworkEndpoints. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group where
            you are attaching network endpoints to. It
            should comply with RFC1035.
        network_endpoint_groups_attach_endpoints_request_resource (google.cloud.compute_v1.types.NetworkEndpointGroupsAttachEndpointsRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the network
            endpoint group is located. It should comply with
            RFC1035.
    """

    network_endpoint_group: str = proto.Field(
        proto.STRING,
        number=433907078,
    )
    network_endpoint_groups_attach_endpoints_request_resource: "NetworkEndpointGroupsAttachEndpointsRequest" = proto.Field(
        proto.MESSAGE,
        number=531079,
        message="NetworkEndpointGroupsAttachEndpointsRequest",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class AttachNetworkEndpointsRegionNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for
    RegionNetworkEndpointGroups.AttachNetworkEndpoints. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group where
            you are attaching network endpoints to. It
            should comply with RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region where you want to
            create the network endpoint group. It should
            comply with RFC1035.
        region_network_endpoint_groups_attach_endpoints_request_resource (google.cloud.compute_v1.types.RegionNetworkEndpointGroupsAttachEndpointsRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network_endpoint_group: str = proto.Field(
        proto.STRING,
        number=433907078,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    region_network_endpoint_groups_attach_endpoints_request_resource: "RegionNetworkEndpointGroupsAttachEndpointsRequest" = proto.Field(
        proto.MESSAGE,
        number=334986492,
        message="RegionNetworkEndpointGroupsAttachEndpointsRequest",
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class AttachedDisk(proto.Message):
    r"""An instance-attached disk resource.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        architecture (str):
            [Output Only] The architecture of the attached disk. Valid
            values are ARM64 or X86_64. Check the Architecture enum for
            the list of possible values.

            This field is a member of `oneof`_ ``_architecture``.
        auto_delete (bool):
            Specifies whether the disk will be
            auto-deleted when the instance is deleted (but
            not when the disk is detached from the
            instance).

            This field is a member of `oneof`_ ``_auto_delete``.
        boot (bool):
            Indicates that this is a boot disk. The
            virtual machine will use the first partition of
            the disk for its root filesystem.

            This field is a member of `oneof`_ ``_boot``.
        device_name (str):
            Specifies a unique device name of your choice that is
            reflected into the /dev/disk/by-id/google-\* tree of a Linux
            operating system running within the instance. This name can
            be used to reference the device for mounting, resizing, and
            so on, from within the instance. If not specified, the
            server chooses a default device name to apply to this disk,
            in the form persistent-disk-x, where x is a number assigned
            by Google Compute Engine. This field is only applicable for
            persistent disks.

            This field is a member of `oneof`_ ``_device_name``.
        disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Encrypts or decrypts a disk using a
            customer-supplied encryption key. If you are
            creating a new disk, this field encrypts the new
            disk using an encryption key that you provide.
            If you are attaching an existing disk that is
            already encrypted, this field decrypts the disk
            using the customer-supplied encryption key. If
            you encrypt a disk using a customer-supplied
            key, you must provide the same key again when
            you attempt to use this resource at a later
            time. For example, you must provide the key when
            you create a snapshot or an image from the disk
            or when you attach the disk to a virtual machine
            instance. If you do not provide an encryption
            key, then the disk will be encrypted using an
            automatically generated key and you do not need
            to provide a key to use the disk later. Note:
            Instance templates do not store
            customer-supplied encryption keys, so you cannot
            use your own keys to encrypt disks in a managed
            instance group. You cannot create VMs that have
            disks with customer-supplied keys using the bulk
            insert method.

            This field is a member of `oneof`_ ``_disk_encryption_key``.
        disk_size_gb (int):
            The size of the disk in GB.

            This field is a member of `oneof`_ ``_disk_size_gb``.
        force_attach (bool):
            [Input Only] Whether to force attach the regional disk even
            if it's currently attached to another instance. If you try
            to force attach a zonal disk to an instance, you will
            receive an error.

            This field is a member of `oneof`_ ``_force_attach``.
        guest_os_features (MutableSequence[google.cloud.compute_v1.types.GuestOsFeature]):
            A list of features to enable on the guest
            operating system. Applicable only for bootable
            images. Read Enabling guest operating system
            features to see a list of available options.
        index (int):
            [Output Only] A zero-based index to this disk, where 0 is
            reserved for the boot disk. If you have many disks attached
            to an instance, each disk would have a unique index number.

            This field is a member of `oneof`_ ``_index``.
        initialize_params (google.cloud.compute_v1.types.AttachedDiskInitializeParams):
            [Input Only] Specifies the parameters for a new disk that
            will be created alongside the new instance. Use
            initialization parameters to create boot disks or local SSDs
            attached to the new instance. This property is mutually
            exclusive with the source property; you can only define one
            or the other, but not both.

            This field is a member of `oneof`_ ``_initialize_params``.
        interface (str):
            Specifies the disk interface to use for
            attaching this disk, which is either SCSI or
            NVME. For most machine types, the default is
            SCSI. Local SSDs can use either NVME or SCSI. In
            certain configurations, persistent disks can use
            NVMe. For more information, see About persistent
            disks. Check the Interface enum for the list of
            possible values.

            This field is a member of `oneof`_ ``_interface``.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#attachedDisk for attached disks.

            This field is a member of `oneof`_ ``_kind``.
        licenses (MutableSequence[str]):
            [Output Only] Any valid publicly visible licenses.
        mode (str):
            The mode in which to attach this disk, either READ_WRITE or
            READ_ONLY. If not specified, the default is to attach the
            disk in READ_WRITE mode. Check the Mode enum for the list of
            possible values.

            This field is a member of `oneof`_ ``_mode``.
        saved_state (str):
            For LocalSSD disks on VM Instances in STOPPED or SUSPENDED
            state, this field is set to PRESERVED if the LocalSSD data
            has been saved to a persistent location by customer request.
            (see the discard_local_ssd option on Stop/Suspend).
            Read-only in the api. Check the SavedState enum for the list
            of possible values.

            This field is a member of `oneof`_ ``_saved_state``.
        shielded_instance_initial_state (google.cloud.compute_v1.types.InitialStateConfig):
            [Output Only] shielded vm initial state stored on disk

            This field is a member of `oneof`_ ``_shielded_instance_initial_state``.
        source (str):
            Specifies a valid partial or full URL to an
            existing Persistent Disk resource. When creating
            a new instance boot disk, one of
            initializeParams.sourceImage or
            initializeParams.sourceSnapshot or disks.source
            is required. If desired, you can also attach
            existing non-root persistent disks using this
            property. This field is only applicable for
            persistent disks. Note that for
            InstanceTemplate, specify the disk name for
            zonal disk, and the URL for regional disk.

            This field is a member of `oneof`_ ``_source``.
        type_ (str):
            Specifies the type of the disk, either
            SCRATCH or PERSISTENT. If not specified, the
            default is PERSISTENT. Check the Type enum for
            the list of possible values.

            This field is a member of `oneof`_ ``_type``.
    """

    class Architecture(proto.Enum):
        r"""[Output Only] The architecture of the attached disk. Valid values
        are ARM64 or X86_64.

        Values:
            UNDEFINED_ARCHITECTURE (0):
                A value indicating that the enum field is not
                set.
            ARCHITECTURE_UNSPECIFIED (394750507):
                Default value indicating Architecture is not
                set.
            ARM64 (62547450):
                Machines with architecture ARM64
            X86_64 (425300551):
                Machines with architecture X86_64
        """
        UNDEFINED_ARCHITECTURE = 0
        ARCHITECTURE_UNSPECIFIED = 394750507
        ARM64 = 62547450
        X86_64 = 425300551

    class Interface(proto.Enum):
        r"""Specifies the disk interface to use for attaching this disk,
        which is either SCSI or NVME. For most machine types, the
        default is SCSI. Local SSDs can use either NVME or SCSI. In
        certain configurations, persistent disks can use NVMe. For more
        information, see About persistent disks.

        Values:
            UNDEFINED_INTERFACE (0):
                A value indicating that the enum field is not
                set.
            NVME (2408800):
                No description available.
            SCSI (2539686):
                No description available.
        """
        UNDEFINED_INTERFACE = 0
        NVME = 2408800
        SCSI = 2539686

    class Mode(proto.Enum):
        r"""The mode in which to attach this disk, either READ_WRITE or
        READ_ONLY. If not specified, the default is to attach the disk in
        READ_WRITE mode.

        Values:
            UNDEFINED_MODE (0):
                A value indicating that the enum field is not
                set.
            READ_ONLY (91950261):
                Attaches this disk in read-only mode.
                Multiple virtual machines can use a disk in
                read-only mode at a time.
            READ_WRITE (173607894):
                *[Default]* Attaches this disk in read-write mode. Only one
                virtual machine at a time can be attached to a disk in
                read-write mode.
        """
        UNDEFINED_MODE = 0
        READ_ONLY = 91950261
        READ_WRITE = 173607894

    class SavedState(proto.Enum):
        r"""For LocalSSD disks on VM Instances in STOPPED or SUSPENDED state,
        this field is set to PRESERVED if the LocalSSD data has been saved
        to a persistent location by customer request. (see the
        discard_local_ssd option on Stop/Suspend). Read-only in the api.

        Values:
            UNDEFINED_SAVED_STATE (0):
                A value indicating that the enum field is not
                set.
            DISK_SAVED_STATE_UNSPECIFIED (391290831):
                *[Default]* Disk state has not been preserved.
            PRESERVED (254159736):
                Disk state has been preserved.
        """
        UNDEFINED_SAVED_STATE = 0
        DISK_SAVED_STATE_UNSPECIFIED = 391290831
        PRESERVED = 254159736

    class Type(proto.Enum):
        r"""Specifies the type of the disk, either SCRATCH or PERSISTENT.
        If not specified, the default is PERSISTENT.

        Values:
            UNDEFINED_TYPE (0):
                A value indicating that the enum field is not
                set.
            PERSISTENT (460683927):
                No description available.
            SCRATCH (496778970):
                No description available.
        """
        UNDEFINED_TYPE = 0
        PERSISTENT = 460683927
        SCRATCH = 496778970

    architecture: str = proto.Field(
        proto.STRING,
        number=302803283,
        optional=True,
    )
    auto_delete: bool = proto.Field(
        proto.BOOL,
        number=464761403,
        optional=True,
    )
    boot: bool = proto.Field(
        proto.BOOL,
        number=3029746,
        optional=True,
    )
    device_name: str = proto.Field(
        proto.STRING,
        number=67541716,
        optional=True,
    )
    disk_encryption_key: "CustomerEncryptionKey" = proto.Field(
        proto.MESSAGE,
        number=271660677,
        optional=True,
        message="CustomerEncryptionKey",
    )
    disk_size_gb: int = proto.Field(
        proto.INT64,
        number=316263735,
        optional=True,
    )
    force_attach: bool = proto.Field(
        proto.BOOL,
        number=142758425,
        optional=True,
    )
    guest_os_features: MutableSequence["GuestOsFeature"] = proto.RepeatedField(
        proto.MESSAGE,
        number=79294545,
        message="GuestOsFeature",
    )
    index: int = proto.Field(
        proto.INT32,
        number=100346066,
        optional=True,
    )
    initialize_params: "AttachedDiskInitializeParams" = proto.Field(
        proto.MESSAGE,
        number=17697045,
        optional=True,
        message="AttachedDiskInitializeParams",
    )
    interface: str = proto.Field(
        proto.STRING,
        number=502623545,
        optional=True,
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    licenses: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=337642578,
    )
    mode: str = proto.Field(
        proto.STRING,
        number=3357091,
        optional=True,
    )
    saved_state: str = proto.Field(
        proto.STRING,
        number=411587801,
        optional=True,
    )
    shielded_instance_initial_state: "InitialStateConfig" = proto.Field(
        proto.MESSAGE,
        number=192356867,
        optional=True,
        message="InitialStateConfig",
    )
    source: str = proto.Field(
        proto.STRING,
        number=177235995,
        optional=True,
    )
    type_: str = proto.Field(
        proto.STRING,
        number=3575610,
        optional=True,
    )


class AttachedDiskInitializeParams(proto.Message):
    r"""[Input Only] Specifies the parameters for a new disk that will be
    created alongside the new instance. Use initialization parameters to
    create boot disks or local SSDs attached to the new instance. This
    field is persisted and returned for instanceTemplate and not
    returned in the context of instance. This property is mutually
    exclusive with the source property; you can only define one or the
    other, but not both.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        architecture (str):
            The architecture of the attached disk. Valid values are
            arm64 or x86_64. Check the Architecture enum for the list of
            possible values.

            This field is a member of `oneof`_ ``_architecture``.
        description (str):
            An optional description. Provide this
            property when creating the disk.

            This field is a member of `oneof`_ ``_description``.
        disk_name (str):
            Specifies the disk name. If not specified,
            the default is to use the name of the instance.
            If a disk with the same name already exists in
            the given region, the existing disk is attached
            to the new instance and the new disk is not
            created.

            This field is a member of `oneof`_ ``_disk_name``.
        disk_size_gb (int):
            Specifies the size of the disk in base-2 GB.
            The size must be at least 10 GB. If you specify
            a sourceImage, which is required for boot disks,
            the default size is the size of the sourceImage.
            If you do not specify a sourceImage, the default
            disk size is 500 GB.

            This field is a member of `oneof`_ ``_disk_size_gb``.
        disk_type (str):
            Specifies the disk type to use to create the
            instance. If not specified, the default is
            pd-standard, specified using the full URL. For
            example:
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            /diskTypes/pd-standard For a full list of
            acceptable values, see Persistent disk types. If
            you specify this field when creating a VM, you
            can provide either the full or partial URL. For
            example, the following values are valid: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            /diskTypes/diskType -
            projects/project/zones/zone/diskTypes/diskType -
            zones/zone/diskTypes/diskType If you specify
            this field when creating or updating an instance
            template or all-instances configuration, specify
            the type of the disk, not the URL. For example:
            pd-standard.

            This field is a member of `oneof`_ ``_disk_type``.
        enable_confidential_compute (bool):
            Whether this disk is using confidential
            compute mode.

            This field is a member of `oneof`_ ``_enable_confidential_compute``.
        labels (MutableMapping[str, str]):
            Labels to apply to this disk. These can be
            later modified by the disks.setLabels method.
            This field is only applicable for persistent
            disks.
        licenses (MutableSequence[str]):
            A list of publicly visible licenses. Reserved
            for Google's use.
        on_update_action (str):
            Specifies which action to take on instance
            update with this disk. Default is to use the
            existing disk. Check the OnUpdateAction enum for
            the list of possible values.

            This field is a member of `oneof`_ ``_on_update_action``.
        provisioned_iops (int):
            Indicates how many IOPS to provision for the
            disk. This sets the number of I/O operations per
            second that the disk can handle. Values must be
            between 10,000 and 120,000. For more details,
            see the Extreme persistent disk documentation.

            This field is a member of `oneof`_ ``_provisioned_iops``.
        provisioned_throughput (int):
            Indicates how much throughput to provision
            for the disk. This sets the number of throughput
            mb per second that the disk can handle. Values
            must greater than or equal to 1.

            This field is a member of `oneof`_ ``_provisioned_throughput``.
        replica_zones (MutableSequence[str]):
            Required for each regional disk associated
            with the instance. Specify the URLs of the zones
            where the disk should be replicated to. You must
            provide exactly two replica zones, and one zone
            must be the same as the instance zone.
        resource_manager_tags (MutableMapping[str, str]):
            Resource manager tags to be bound to the disk. Tag keys and
            values have the same definition as resource manager tags.
            Keys must be in the format ``tagKeys/{tag_key_id}``, and
            values are in the format ``tagValues/456``. The field is
            ignored (both PUT & PATCH) when empty.
        resource_policies (MutableSequence[str]):
            Resource policies applied to this disk for
            automatic snapshot creations. Specified using
            the full or partial URL. For instance template,
            specify only the resource policy name.
        source_image (str):
            The source image to create this disk. When
            creating a new instance boot disk, one of
            initializeParams.sourceImage or
            initializeParams.sourceSnapshot or disks.source
            is required. To create a disk with one of the
            public operating system images, specify the
            image by its family name. For example, specify
            family/debian-9 to use the latest Debian 9
            image:
            projects/debian-cloud/global/images/family/debian-9
            Alternatively, use a specific version of a
            public operating system image:
            projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
            To create a disk with a custom image that you
            created, specify the image name in the following
            format: global/images/my-custom-image You can
            also specify a custom image by its image family,
            which returns the latest version of the image in
            that family. Replace the image name with
            family/family-name:
            global/images/family/my-image-family If the
            source image is deleted later, this field will
            not be set.

            This field is a member of `oneof`_ ``_source_image``.
        source_image_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source image. Required if the source image is
            protected by a customer-supplied encryption key.
            InstanceTemplate and InstancePropertiesPatch do
            not store customer-supplied encryption keys, so
            you cannot create disks for instances in a
            managed instance group if the source images are
            encrypted with your own keys.

            This field is a member of `oneof`_ ``_source_image_encryption_key``.
        source_snapshot (str):
            The source snapshot to create this disk. When
            creating a new instance boot disk, one of
            initializeParams.sourceSnapshot or
            initializeParams.sourceImage or disks.source is
            required. To create a disk with a snapshot that
            you created, specify the snapshot name in the
            following format: global/snapshots/my-backup If
            the source snapshot is deleted later, this field
            will not be set. Note: You cannot create VMs in
            bulk using a snapshot as the source. Use an
            image instead when you create VMs using the bulk
            insert method.

            This field is a member of `oneof`_ ``_source_snapshot``.
        source_snapshot_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            The customer-supplied encryption key of the
            source snapshot.

            This field is a member of `oneof`_ ``_source_snapshot_encryption_key``.
        storage_pool (str):
            The storage pool in which the new disk is
            created. You can provide this as a partial or
            full URL to the resource. For example, the
            following are valid values: -
            https://www.googleapis.com/compute/v1/projects/project/zones/zone
            /storagePools/storagePool -
            projects/project/zones/zone/storagePools/storagePool
            - zones/zone/storagePools/storagePool

            This field is a member of `oneof`_ ``_storage_pool``.
    """

    class Architecture(proto.Enum):
        r"""The architecture of the attached disk. Valid values are arm64 or
        x86_64.

        Values:
            UNDEFINED_ARCHITECTURE (0):
                A value indicating that the enum field is not
                set.
            ARCHITECTURE_UNSPECIFIED (394750507):
                Default value indicating Architecture is not
                set.
            ARM64 (62547450):
                Machines with architecture ARM64
            X86_64 (425300551):
                Machines with architecture X86_64
        """
        UNDEFINED_ARCHITECTURE = 0
        ARCHITECTURE_UNSPECIFIED = 394750507
        ARM64 = 62547450
        X86_64 = 425300551

    class OnUpdateAction(proto.Enum):
        r"""Specifies which action to take on instance update with this
        disk. Default is to use the existing disk.

        Values:
            UNDEFINED_ON_UPDATE_ACTION (0):
                A value indicating that the enum field is not
                set.
            RECREATE_DISK (494767853):
                Always recreate the disk.
            RECREATE_DISK_IF_SOURCE_CHANGED (398099712):
                Recreate the disk if source (image, snapshot)
                of this disk is different from source of
                existing disk.
            USE_EXISTING_DISK (232682233):
                Use the existing disk, this is the default
                behaviour.
        """
        UNDEFINED_ON_UPDATE_ACTION = 0
        RECREATE_DISK = 494767853
        RECREATE_DISK_IF_SOURCE_CHANGED = 398099712
        USE_EXISTING_DISK = 232682233

    architecture: str = proto.Field(
        proto.STRING,
        number=302803283,
        optional=True,
    )
    description: str = proto.Field(
        proto.STRING,
        number=422937596,
        optional=True,
    )
    disk_name: str = proto.Field(
        proto.STRING,
        number=92807149,
        optional=True,
    )
    disk_size_gb: int = proto.Field(
        proto.INT64,
        number=316263735,
        optional=True,
    )
    disk_type: str = proto.Field(
        proto.STRING,
        number=93009052,
        optional=True,
    )
    enable_confidential_compute: bool = proto.Field(
        proto.BOOL,
        number=102135228,
        optional=True,
    )
    labels: MutableMapping[str, str] = proto.MapField(
        proto.STRING,
        proto.STRING,
        number=500195327,
    )
    licenses: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=337642578,
    )
    on_update_action: str = proto.Field(
        proto.STRING,
        number=202451980,
        optional=True,
    )
    provisioned_iops: int = proto.Field(
        proto.INT64,
        number=186769108,
        optional=True,
    )
    provisioned_throughput: int = proto.Field(
        proto.INT64,
        number=526524181,
        optional=True,
    )
    replica_zones: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=48438272,
    )
    resource_manager_tags: MutableMapping[str, str] = proto.MapField(
        proto.STRING,
        proto.STRING,
        number=377671164,
    )
    resource_policies: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=22220385,
    )
    source_image: str = proto.Field(
        proto.STRING,
        number=50443319,
        optional=True,
    )
    source_image_encryption_key: "CustomerEncryptionKey" = proto.Field(
        proto.MESSAGE,
        number=381503659,
        optional=True,
        message="CustomerEncryptionKey",
    )
    source_snapshot: str = proto.Field(
        proto.STRING,
        number=126061928,
        optional=True,
    )
    source_snapshot_encryption_key: "CustomerEncryptionKey" = proto.Field(
        proto.MESSAGE,
        number=303679322,
        optional=True,
        message="CustomerEncryptionKey",
    )
    storage_pool: str = proto.Field(
        proto.STRING,
        number=360473440,
        optional=True,
    )


class AuditConfig(proto.Message):
    r"""Specifies the audit configuration for a service. The configuration
    determines which permission types are logged, and what identities,
    if any, are exempted from logging. An AuditConfig must have one or
    more AuditLogConfigs. If there are AuditConfigs for both
    ``allServices`` and a specific service, the union of the two
    AuditConfigs is used for that service: the log_types specified in
    each AuditConfig are enabled, and the exempted_members in each
    AuditLogConfig are exempted. Example Policy with multiple
    AuditConfigs: { "audit_configs": [ { "service": "allServices",
    "audit_log_configs": [ { "log_type": "DATA_READ",
    "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
    "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service":
    "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
    "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
    "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy
    enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also
    exempts ``jose@example.com`` from DATA_READ logging, and
    ``aliya@example.com`` from DATA_WRITE logging.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        audit_log_configs (MutableSequence[google.cloud.compute_v1.types.AuditLogConfig]):
            The configuration for logging of each type of
            permission.
        exempted_members (MutableSequence[str]):

        service (str):
            Specifies a service that will be enabled for audit logging.
            For example, ``storage.googleapis.com``,
            ``cloudsql.googleapis.com``. ``allServices`` is a special
            value that covers all services.

            This field is a member of `oneof`_ ``_service``.
    """

    audit_log_configs: MutableSequence["AuditLogConfig"] = proto.RepeatedField(
        proto.MESSAGE,
        number=488420626,
        message="AuditLogConfig",
    )
    exempted_members: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=232615576,
    )
    service: str = proto.Field(
        proto.STRING,
        number=373540533,
        optional=True,
    )


class AuditLogConfig(proto.Message):
    r"""Provides the configuration for logging a type of permissions.
    Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
    "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
    "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE'
    logging, while exempting jose@example.com from DATA_READ logging.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        exempted_members (MutableSequence[str]):
            Specifies the identities that do not cause
            logging for this type of permission. Follows the
            same format of Binding.members.
        ignore_child_exemptions (bool):

            This field is a member of `oneof`_ ``_ignore_child_exemptions``.
        log_type (str):
            The log type that this config enables.
            Check the LogType enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_log_type``.
    """

    class LogType(proto.Enum):
        r"""The log type that this config enables.

        Values:
            UNDEFINED_LOG_TYPE (0):
                A value indicating that the enum field is not
                set.
            ADMIN_READ (128951462):
                Admin reads. Example: CloudIAM getIamPolicy
            DATA_READ (305224971):
                Data reads. Example: CloudSQL Users list
            DATA_WRITE (340181738):
                Data writes. Example: CloudSQL Users create
            LOG_TYPE_UNSPECIFIED (154527053):
                Default case. Should never be this.
        """
        UNDEFINED_LOG_TYPE = 0
        ADMIN_READ = 128951462
        DATA_READ = 305224971
        DATA_WRITE = 340181738
        LOG_TYPE_UNSPECIFIED = 154527053

    exempted_members: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=232615576,
    )
    ignore_child_exemptions: bool = proto.Field(
        proto.BOOL,
        number=70141850,
        optional=True,
    )
    log_type: str = proto.Field(
        proto.STRING,
        number=403115861,
        optional=True,
    )


class Autoscaler(proto.Message):
    r"""Represents an Autoscaler resource. Google Compute Engine has two
    Autoscaler resources: \*
    `Zonal </compute/docs/reference/rest/v1/autoscalers>`__ \*
    `Regional </compute/docs/reference/rest/v1/regionAutoscalers>`__ Use
    autoscalers to automatically add or delete instances from a managed
    instance group according to your defined autoscaling policy. For
    more information, read Autoscaling Groups of Instances. For zonal
    managed instance groups resource, use the autoscaler resource. For
    regional managed instance groups, use the regionAutoscalers
    resource.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        autoscaling_policy (google.cloud.compute_v1.types.AutoscalingPolicy):
            The configuration parameters for the
            autoscaling algorithm. You can define one or
            more signals for an autoscaler: cpuUtilization,
            customMetricUtilizations, and
            loadBalancingUtilization. If none of these are
            specified, the default will be to autoscale
            based on cpuUtilization to 0.6 or 60%.

            This field is a member of `oneof`_ ``_autoscaling_policy``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#autoscaler for autoscalers.

            This field is a member of `oneof`_ ``_kind``.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        recommended_size (int):
            [Output Only] Target recommended MIG size (number of
            instances) computed by autoscaler. Autoscaler calculates the
            recommended MIG size even when the autoscaling policy mode
            is different from ON. This field is empty when autoscaler is
            not connected to an existing managed instance group or
            autoscaler did not generate its prediction.

            This field is a member of `oneof`_ ``_recommended_size``.
        region (str):
            [Output Only] URL of the region where the instance group
            resides (for autoscalers living in regional scope).

            This field is a member of `oneof`_ ``_region``.
        scaling_schedule_status (MutableMapping[str, google.cloud.compute_v1.types.ScalingScheduleStatus]):
            [Output Only] Status information of existing scaling
            schedules.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        status (str):
            [Output Only] The status of the autoscaler configuration.
            Current set of possible values: - PENDING: Autoscaler
            backend hasn't read new/updated configuration. - DELETING:
            Configuration is being deleted. - ACTIVE: Configuration is
            acknowledged to be effective. Some warnings might be present
            in the statusDetails field. - ERROR: Configuration has
            errors. Actionable for users. Details are present in the
            statusDetails field. New values might be added in the
            future. Check the Status enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_status``.
        status_details (MutableSequence[google.cloud.compute_v1.types.AutoscalerStatusDetails]):
            [Output Only] Human-readable details about the current state
            of the autoscaler. Read the documentation for Commonly
            returned status messages for examples of status messages you
            might encounter.
        target (str):
            URL of the managed instance group that this
            autoscaler will scale. This field is required
            when creating an autoscaler.

            This field is a member of `oneof`_ ``_target``.
        zone (str):
            [Output Only] URL of the zone where the instance group
            resides (for autoscalers living in zonal scope).

            This field is a member of `oneof`_ ``_zone``.
    """

    class Status(proto.Enum):
        r"""[Output Only] The status of the autoscaler configuration. Current
        set of possible values: - PENDING: Autoscaler backend hasn't read
        new/updated configuration. - DELETING: Configuration is being
        deleted. - ACTIVE: Configuration is acknowledged to be effective.
        Some warnings might be present in the statusDetails field. - ERROR:
        Configuration has errors. Actionable for users. Details are present
        in the statusDetails field. New values might be added in the future.

        Values:
            UNDEFINED_STATUS (0):
                A value indicating that the enum field is not
                set.
            ACTIVE (314733318):
                Configuration is acknowledged to be effective
            DELETING (528602024):
                Configuration is being deleted
            ERROR (66247144):
                Configuration has errors. Actionable for
                users.
            PENDING (35394935):
                Autoscaler backend hasn't read new/updated
                configuration
        """
        UNDEFINED_STATUS = 0
        ACTIVE = 314733318
        DELETING = 528602024
        ERROR = 66247144
        PENDING = 35394935

    autoscaling_policy: "AutoscalingPolicy" = proto.Field(
        proto.MESSAGE,
        number=221950041,
        optional=True,
        message="AutoscalingPolicy",
    )
    creation_timestamp: str = proto.Field(
        proto.STRING,
        number=30525366,
        optional=True,
    )
    description: str = proto.Field(
        proto.STRING,
        number=422937596,
        optional=True,
    )
    id: int = proto.Field(
        proto.UINT64,
        number=3355,
        optional=True,
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )
    recommended_size: int = proto.Field(
        proto.INT32,
        number=257915749,
        optional=True,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
        optional=True,
    )
    scaling_schedule_status: MutableMapping[
        str, "ScalingScheduleStatus"
    ] = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=465950178,
        message="ScalingScheduleStatus",
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    status: str = proto.Field(
        proto.STRING,
        number=181260274,
        optional=True,
    )
    status_details: MutableSequence["AutoscalerStatusDetails"] = proto.RepeatedField(
        proto.MESSAGE,
        number=363353845,
        message="AutoscalerStatusDetails",
    )
    target: str = proto.Field(
        proto.STRING,
        number=192835985,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
        optional=True,
    )


class AutoscalerAggregatedList(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableMapping[str, google.cloud.compute_v1.types.AutoscalersScopedList]):
            A list of AutoscalersScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#autoscalerAggregatedList for aggregated lists of
            autoscalers.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (MutableSequence[str]):
            [Output Only] Unreachable resources. end_interface:
            MixerListResponseWithEtagBuilder
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableMapping[str, "AutoscalersScopedList"] = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="AutoscalersScopedList",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    unreachables: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=243372063,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class AutoscalerList(proto.Message):
    r"""Contains a list of Autoscaler resources.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableSequence[google.cloud.compute_v1.types.Autoscaler]):
            A list of Autoscaler resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#autoscalerList for lists of autoscalers.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableSequence["Autoscaler"] = proto.RepeatedField(
        proto.MESSAGE,
        number=100526016,
        message="Autoscaler",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class AutoscalerStatusDetails(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        message (str):
            The status message.

            This field is a member of `oneof`_ ``_message``.
        type_ (str):
            The type of error, warning, or notice returned. Current set
            of possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All
            instances in the instance group are unhealthy (not in
            RUNNING state). - BACKEND_SERVICE_DOES_NOT_EXIST (ERROR):
            There is no backend service attached to the instance group.
            - CAPPED_AT_MAX_NUM_REPLICAS (WARNING): Autoscaler
            recommends a size greater than maxNumReplicas. -
            CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom
            metric samples are not exported often enough to be a
            credible base for autoscaling. - CUSTOM_METRIC_INVALID
            (ERROR): The custom metric that was specified does not exist
            or does not have the necessary labels. - MIN_EQUALS_MAX
            (WARNING): The minNumReplicas is equal to maxNumReplicas.
            This means the autoscaler cannot add or remove instances
            from the instance group. - MISSING_CUSTOM_METRIC_DATA_POINTS
            (WARNING): The autoscaler did not receive any data from the
            custom metric configured for autoscaling. -
            MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler
            is configured to scale based on a load balancing signal but
            the instance group has not received any requests from the
            load balancer. - MODE_OFF (WARNING): Autoscaling is turned
            off. The number of instances in the group won't change
            automatically. The autoscaling configuration is preserved. -
            MODE_ONLY_UP (WARNING): Autoscaling is in the "Autoscale
            only out" mode. The autoscaler can add instances but not
            remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The
            instance group cannot be autoscaled because it has more than
            one backend service attached to it. -
            NOT_ENOUGH_QUOTA_AVAILABLE (ERROR): There is insufficient
            quota for the necessary resources, such as CPU or number of
            instances. - REGION_RESOURCE_STOCKOUT (ERROR): Shown only
            for regional autoscalers: there is a resource stockout in
            the chosen region. - SCALING_TARGET_DOES_NOT_EXIST (ERROR):
            The target to be scaled does not exist. -
            UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR):
            Autoscaling does not work with an HTTP/S load balancer that
            has been configured for maxRate. - ZONE_RESOURCE_STOCKOUT
            (ERROR): For zonal autoscalers: there is a resource stockout
            in the chosen zone. For regional autoscalers: in at least
            one of the zones you're using there is a resource stockout.
            New values might be added in the future. Some of the values
            might not be available in all API versions. Check the Type
            enum for the list of possible values.

            This field is a member of `oneof`_ ``_type``.
    """

    class Type(proto.Enum):
        r"""The type of error, warning, or notice returned. Current set of
        possible values: - ALL_INSTANCES_UNHEALTHY (WARNING): All instances
        in the instance group are unhealthy (not in RUNNING state). -
        BACKEND_SERVICE_DOES_NOT_EXIST (ERROR): There is no backend service
        attached to the instance group. - CAPPED_AT_MAX_NUM_REPLICAS
        (WARNING): Autoscaler recommends a size greater than maxNumReplicas.
        - CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (WARNING): The custom metric
        samples are not exported often enough to be a credible base for
        autoscaling. - CUSTOM_METRIC_INVALID (ERROR): The custom metric that
        was specified does not exist or does not have the necessary labels.
        - MIN_EQUALS_MAX (WARNING): The minNumReplicas is equal to
        maxNumReplicas. This means the autoscaler cannot add or remove
        instances from the instance group. -
        MISSING_CUSTOM_METRIC_DATA_POINTS (WARNING): The autoscaler did not
        receive any data from the custom metric configured for autoscaling.
        - MISSING_LOAD_BALANCING_DATA_POINTS (WARNING): The autoscaler is
        configured to scale based on a load balancing signal but the
        instance group has not received any requests from the load balancer.
        - MODE_OFF (WARNING): Autoscaling is turned off. The number of
        instances in the group won't change automatically. The autoscaling
        configuration is preserved. - MODE_ONLY_UP (WARNING): Autoscaling is
        in the "Autoscale only out" mode. The autoscaler can add instances
        but not remove any. - MORE_THAN_ONE_BACKEND_SERVICE (ERROR): The
        instance group cannot be autoscaled because it has more than one
        backend service attached to it. - NOT_ENOUGH_QUOTA_AVAILABLE
        (ERROR): There is insufficient quota for the necessary resources,
        such as CPU or number of instances. - REGION_RESOURCE_STOCKOUT
        (ERROR): Shown only for regional autoscalers: there is a resource
        stockout in the chosen region. - SCALING_TARGET_DOES_NOT_EXIST
        (ERROR): The target to be scaled does not exist. -
        UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (ERROR):
        Autoscaling does not work with an HTTP/S load balancer that has been
        configured for maxRate. - ZONE_RESOURCE_STOCKOUT (ERROR): For zonal
        autoscalers: there is a resource stockout in the chosen zone. For
        regional autoscalers: in at least one of the zones you're using
        there is a resource stockout. New values might be added in the
        future. Some of the values might not be available in all API
        versions.

        Values:
            UNDEFINED_TYPE (0):
                A value indicating that the enum field is not
                set.
            ALL_INSTANCES_UNHEALTHY (404965477):
                All instances in the instance group are
                unhealthy (not in RUNNING state).
            BACKEND_SERVICE_DOES_NOT_EXIST (191417626):
                There is no backend service attached to the
                instance group.
            CAPPED_AT_MAX_NUM_REPLICAS (518617):
                Autoscaler recommends a size greater than
                maxNumReplicas.
            CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE (328964659):
                The custom metric samples are not exported
                often enough to be a credible base for
                autoscaling.
            CUSTOM_METRIC_INVALID (204430550):
                The custom metric that was specified does not
                exist or does not have the necessary labels.
            MIN_EQUALS_MAX (2821361):
                The minNumReplicas is equal to
                maxNumReplicas. This means the autoscaler cannot
                add or remove instances from the instance group.
            MISSING_CUSTOM_METRIC_DATA_POINTS (94885086):
                The autoscaler did not receive any data from
                the custom metric configured for autoscaling.
            MISSING_LOAD_BALANCING_DATA_POINTS (509858898):
                The autoscaler is configured to scale based
                on a load balancing signal but the instance
                group has not received any requests from the
                load balancer.
            MODE_OFF (164169907):
                Autoscaling is turned off. The number of
                instances in the group won't change
                automatically. The autoscaling configuration is
                preserved.
            MODE_ONLY_SCALE_OUT (3840994):
                Autoscaling is in the "Autoscale only scale
                out" mode. Instances in the group will be only
                added.
            MODE_ONLY_UP (100969842):
                Autoscaling is in the "Autoscale only out"
                mode. Instances in the group will be only added.
            MORE_THAN_ONE_BACKEND_SERVICE (151922141):
                The instance group cannot be autoscaled
                because it has more than one backend service
                attached to it.
            NOT_ENOUGH_QUOTA_AVAILABLE (403101631):
                There is insufficient quota for the necessary
                resources, such as CPU or number of instances.
            REGION_RESOURCE_STOCKOUT (528622846):
                Showed only for regional autoscalers: there
                is a resource stockout in the chosen region.
            SCALING_TARGET_DOES_NOT_EXIST (122636699):
                The target to be scaled does not exist.
            SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX (29275586):
                For some scaling schedules
                minRequiredReplicas is greater than
                maxNumReplicas. Autoscaler always recommends at
                most maxNumReplicas instances.
            SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN (398287669):
                For some scaling schedules
                minRequiredReplicas is less than minNumReplicas.
                Autoscaler always recommends at least
                minNumReplicas instances.
            UNKNOWN (433141802):
                No description available.
            UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION (330845009):
                Autoscaling does not work with an HTTP/S load
                balancer that has been configured for maxRate.
            ZONE_RESOURCE_STOCKOUT (210200502):
                For zonal autoscalers: there is a resource
                stockout in the chosen zone. For regional
                autoscalers: in at least one of the zones you're
                using there is a resource stockout.
        """
        UNDEFINED_TYPE = 0
        ALL_INSTANCES_UNHEALTHY = 404965477
        BACKEND_SERVICE_DOES_NOT_EXIST = 191417626
        CAPPED_AT_MAX_NUM_REPLICAS = 518617
        CUSTOM_METRIC_DATA_POINTS_TOO_SPARSE = 328964659
        CUSTOM_METRIC_INVALID = 204430550
        MIN_EQUALS_MAX = 2821361
        MISSING_CUSTOM_METRIC_DATA_POINTS = 94885086
        MISSING_LOAD_BALANCING_DATA_POINTS = 509858898
        MODE_OFF = 164169907
        MODE_ONLY_SCALE_OUT = 3840994
        MODE_ONLY_UP = 100969842
        MORE_THAN_ONE_BACKEND_SERVICE = 151922141
        NOT_ENOUGH_QUOTA_AVAILABLE = 403101631
        REGION_RESOURCE_STOCKOUT = 528622846
        SCALING_TARGET_DOES_NOT_EXIST = 122636699
        SCHEDULED_INSTANCES_GREATER_THAN_AUTOSCALER_MAX = 29275586
        SCHEDULED_INSTANCES_LESS_THAN_AUTOSCALER_MIN = 398287669
        UNKNOWN = 433141802
        UNSUPPORTED_MAX_RATE_LOAD_BALANCING_CONFIGURATION = 330845009
        ZONE_RESOURCE_STOCKOUT = 210200502

    message: str = proto.Field(
        proto.STRING,
        number=418054151,
        optional=True,
    )
    type_: str = proto.Field(
        proto.STRING,
        number=3575610,
        optional=True,
    )


class AutoscalersScopedList(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        autoscalers (MutableSequence[google.cloud.compute_v1.types.Autoscaler]):
            [Output Only] A list of autoscalers contained in this scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of autoscalers when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    autoscalers: MutableSequence["Autoscaler"] = proto.RepeatedField(
        proto.MESSAGE,
        number=465771644,
        message="Autoscaler",
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class AutoscalingPolicy(proto.Message):
    r"""Cloud Autoscaler policy.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        cool_down_period_sec (int):
            The number of seconds that your application takes to
            initialize on a VM instance. This is referred to as the
            `initialization
            period </compute/docs/autoscaler#cool_down_period>`__.
            Specifying an accurate initialization period improves
            autoscaler decisions. For example, when scaling out, the
            autoscaler ignores data from VMs that are still initializing
            because those VMs might not yet represent normal usage of
            your application. The default initialization period is 60
            seconds. Initialization periods might vary because of
            numerous factors. We recommend that you test how long your
            application takes to initialize. To do this, create a VM and
            time your application's startup process.

            This field is a member of `oneof`_ ``_cool_down_period_sec``.
        cpu_utilization (google.cloud.compute_v1.types.AutoscalingPolicyCpuUtilization):
            Defines the CPU utilization policy that
            allows the autoscaler to scale based on the
            average CPU utilization of a managed instance
            group.

            This field is a member of `oneof`_ ``_cpu_utilization``.
        custom_metric_utilizations (MutableSequence[google.cloud.compute_v1.types.AutoscalingPolicyCustomMetricUtilization]):
            Configuration parameters of autoscaling based
            on a custom metric.
        load_balancing_utilization (google.cloud.compute_v1.types.AutoscalingPolicyLoadBalancingUtilization):
            Configuration parameters of autoscaling based
            on load balancer.

            This field is a member of `oneof`_ ``_load_balancing_utilization``.
        max_num_replicas (int):
            The maximum number of instances that the
            autoscaler can scale out to. This is required
            when creating or updating an autoscaler. The
            maximum number of replicas must not be lower
            than minimal number of replicas.

            This field is a member of `oneof`_ ``_max_num_replicas``.
        min_num_replicas (int):
            The minimum number of replicas that the
            autoscaler can scale in to. This cannot be less
            than 0. If not provided, autoscaler chooses a
            default value depending on maximum number of
            instances allowed.

            This field is a member of `oneof`_ ``_min_num_replicas``.
        mode (str):
            Defines the operating mode for this policy. The following
            modes are available: - OFF: Disables the autoscaler but
            maintains its configuration. - ONLY_SCALE_OUT: Restricts the
            autoscaler to add VM instances only. - ON: Enables all
            autoscaler activities according to its policy. For more
            information, see "Turning off or restricting an autoscaler"
            Check the Mode enum for the list of possible values.

            This field is a member of `oneof`_ ``_mode``.
        scale_in_control (google.cloud.compute_v1.types.AutoscalingPolicyScaleInControl):

            This field is a member of `oneof`_ ``_scale_in_control``.
        scaling_schedules (MutableMapping[str, google.cloud.compute_v1.types.AutoscalingPolicyScalingSchedule]):
            Scaling schedules defined for an autoscaler. Multiple
            schedules can be set on an autoscaler, and they can overlap.
            During overlapping periods the greatest
            min_required_replicas of all scaling schedules is applied.
            Up to 128 scaling schedules are allowed.
    """

    class Mode(proto.Enum):
        r"""Defines the operating mode for this policy. The following modes are
        available: - OFF: Disables the autoscaler but maintains its
        configuration. - ONLY_SCALE_OUT: Restricts the autoscaler to add VM
        instances only. - ON: Enables all autoscaler activities according to
        its policy. For more information, see "Turning off or restricting an
        autoscaler"

        Values:
            UNDEFINED_MODE (0):
                A value indicating that the enum field is not
                set.
            OFF (78159):
                Do not automatically scale the MIG in or out. The
                recommended_size field contains the size of MIG that would
                be set if the actuation mode was enabled.
            ON (2527):
                Automatically scale the MIG in and out
                according to the policy.
            ONLY_SCALE_OUT (152713670):
                Automatically create VMs according to the
                policy, but do not scale the MIG in.
            ONLY_UP (478095374):
                Automatically create VMs according to the
                policy, but do not scale the MIG in.
        """
        UNDEFINED_MODE = 0
        OFF = 78159
        ON = 2527
        ONLY_SCALE_OUT = 152713670
        ONLY_UP = 478095374

    cool_down_period_sec: int = proto.Field(
        proto.INT32,
        number=107692954,
        optional=True,
    )
    cpu_utilization: "AutoscalingPolicyCpuUtilization" = proto.Field(
        proto.MESSAGE,
        number=381211147,
        optional=True,
        message="AutoscalingPolicyCpuUtilization",
    )
    custom_metric_utilizations: MutableSequence[
        "AutoscalingPolicyCustomMetricUtilization"
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=131972850,
        message="AutoscalingPolicyCustomMetricUtilization",
    )
    load_balancing_utilization: "AutoscalingPolicyLoadBalancingUtilization" = (
        proto.Field(
            proto.MESSAGE,
            number=429746403,
            optional=True,
            message="AutoscalingPolicyLoadBalancingUtilization",
        )
    )
    max_num_replicas: int = proto.Field(
        proto.INT32,
        number=62327375,
        optional=True,
    )
    min_num_replicas: int = proto.Field(
        proto.INT32,
        number=535329825,
        optional=True,
    )
    mode: str = proto.Field(
        proto.STRING,
        number=3357091,
        optional=True,
    )
    scale_in_control: "AutoscalingPolicyScaleInControl" = proto.Field(
        proto.MESSAGE,
        number=527670872,
        optional=True,
        message="AutoscalingPolicyScaleInControl",
    )
    scaling_schedules: MutableMapping[
        str, "AutoscalingPolicyScalingSchedule"
    ] = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=355416580,
        message="AutoscalingPolicyScalingSchedule",
    )


class AutoscalingPolicyCpuUtilization(proto.Message):
    r"""CPU utilization policy.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        predictive_method (str):
            Indicates whether predictive autoscaling based on CPU metric
            is enabled. Valid values are: \* NONE (default). No
            predictive method is used. The autoscaler scales the group
            to meet current demand based on real-time metrics. \*
            OPTIMIZE_AVAILABILITY. Predictive autoscaling improves
            availability by monitoring daily and weekly load patterns
            and scaling out ahead of anticipated demand. Check the
            PredictiveMethod enum for the list of possible values.

            This field is a member of `oneof`_ ``_predictive_method``.
        utilization_target (float):
            The target CPU utilization that the autoscaler maintains.
            Must be a float value in the range (0, 1]. If not specified,
            the default is 0.6. If the CPU level is below the target
            utilization, the autoscaler scales in the number of
            instances until it reaches the minimum number of instances
            you specified or until the average CPU of your instances
            reaches the target utilization. If the average CPU is above
            the target utilization, the autoscaler scales out until it
            reaches the maximum number of instances you specified or
            until the average utilization reaches the target
            utilization.

            This field is a member of `oneof`_ ``_utilization_target``.
    """

    class PredictiveMethod(proto.Enum):
        r"""Indicates whether predictive autoscaling based on CPU metric is
        enabled. Valid values are: \* NONE (default). No predictive method
        is used. The autoscaler scales the group to meet current demand
        based on real-time metrics. \* OPTIMIZE_AVAILABILITY. Predictive
        autoscaling improves availability by monitoring daily and weekly
        load patterns and scaling out ahead of anticipated demand.

        Values:
            UNDEFINED_PREDICTIVE_METHOD (0):
                A value indicating that the enum field is not
                set.
            NONE (2402104):
                No predictive method is used. The autoscaler
                scales the group to meet current demand based on
                real-time metrics
            OPTIMIZE_AVAILABILITY (11629437):
                Predictive autoscaling improves availability
                by monitoring daily and weekly load patterns and
                scaling out ahead of anticipated demand.
        """
        UNDEFINED_PREDICTIVE_METHOD = 0
        NONE = 2402104
        OPTIMIZE_AVAILABILITY = 11629437

    predictive_method: str = proto.Field(
        proto.STRING,
        number=390220737,
        optional=True,
    )
    utilization_target: float = proto.Field(
        proto.DOUBLE,
        number=215905870,
        optional=True,
    )


class AutoscalingPolicyCustomMetricUtilization(proto.Message):
    r"""Custom utilization metric policy.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        filter (str):
            A filter string, compatible with a Stackdriver Monitoring
            filter string for TimeSeries.list API call. This filter is
            used to select a specific TimeSeries for the purpose of
            autoscaling and to determine whether the metric is exporting
            per-instance or per-group data. For the filter to be valid
            for autoscaling purposes, the following rules apply: - You
            can only use the AND operator for joining selectors. - You
            can only use direct equality comparison operator (=) without
            any functions for each selector. - You can specify the
            metric in both the filter string and in the metric field.
            However, if specified in both places, the metric must be
            identical. - The monitored resource type determines what
            kind of values are expected for the metric. If it is a
            gce_instance, the autoscaler expects the metric to include a
            separate TimeSeries for each instance in a group. In such a
            case, you cannot filter on resource labels. If the resource
            type is any other value, the autoscaler expects this metric
            to contain values that apply to the entire autoscaled
            instance group and resource label filtering can be performed
            to point autoscaler at the correct TimeSeries to scale upon.
            This is called a *per-group metric* for the purpose of
            autoscaling. If not specified, the type defaults to
            gce_instance. Try to provide a filter that is selective
            enough to pick just one TimeSeries for the autoscaled group
            or for each of the instances (if you are using gce_instance
            resource type). If multiple TimeSeries are returned upon the
            query execution, the autoscaler will sum their respective
            values to obtain its scaling value.

            This field is a member of `oneof`_ ``_filter``.
        metric (str):
            The identifier (type) of the Stackdriver
            Monitoring metric. The metric cannot have
            negative values. The metric must have a value
            type of INT64 or DOUBLE.

            This field is a member of `oneof`_ ``_metric``.
        single_instance_assignment (float):
            If scaling is based on a per-group metric value that
            represents the total amount of work to be done or resource
            usage, set this value to an amount assigned for a single
            instance of the scaled group. Autoscaler keeps the number of
            instances proportional to the value of this metric. The
            metric itself does not change value due to group resizing. A
            good metric to use with the target is for example
            pubsub.googleapis.com/subscription/num_undelivered_messages
            or a custom metric exporting the total number of requests
            coming to your instances. A bad example would be a metric
            exporting an average or median latency, since this value
            can't include a chunk assignable to a single instance, it
            could be better used with utilization_target instead.

            This field is a member of `oneof`_ ``_single_instance_assignment``.
        utilization_target (float):
            The target value of the metric that autoscaler maintains.
            This must be a positive value. A utilization metric scales
            number of virtual machines handling requests to increase or
            decrease proportionally to the metric. For example, a good
            metric to use as a utilization_target is
            https://www.googleapis.com/compute/v1/instance/network/received_bytes_count.
            The autoscaler works to keep this value constant for each of
            the instances.

            This field is a member of `oneof`_ ``_utilization_target``.
        utilization_target_type (str):
            Defines how target utilization value is expressed for a
            Stackdriver Monitoring metric. Either GAUGE,
            DELTA_PER_SECOND, or DELTA_PER_MINUTE. Check the
            UtilizationTargetType enum for the list of possible values.

            This field is a member of `oneof`_ ``_utilization_target_type``.
    """

    class UtilizationTargetType(proto.Enum):
        r"""Defines how target utilization value is expressed for a Stackdriver
        Monitoring metric. Either GAUGE, DELTA_PER_SECOND, or
        DELTA_PER_MINUTE.

        Values:
            UNDEFINED_UTILIZATION_TARGET_TYPE (0):
                A value indicating that the enum field is not
                set.
            DELTA_PER_MINUTE (87432861):
                Sets the utilization target value for a
                cumulative or delta metric, expressed as the
                rate of growth per minute.
            DELTA_PER_SECOND (255180029):
                Sets the utilization target value for a
                cumulative or delta metric, expressed as the
                rate of growth per second.
            GAUGE (67590361):
                Sets the utilization target value for a gauge
                metric. The autoscaler will collect the average
                utilization of the virtual machines from the
                last couple of minutes, and compare the value to
                the utilization target value to perform
                autoscaling.
        """
        UNDEFINED_UTILIZATION_TARGET_TYPE = 0
        DELTA_PER_MINUTE = 87432861
        DELTA_PER_SECOND = 255180029
        GAUGE = 67590361

    filter: str = proto.Field(
        proto.STRING,
        number=336120696,
        optional=True,
    )
    metric: str = proto.Field(
        proto.STRING,
        number=533067184,
        optional=True,
    )
    single_instance_assignment: float = proto.Field(
        proto.DOUBLE,
        number=504768064,
        optional=True,
    )
    utilization_target: float = proto.Field(
        proto.DOUBLE,
        number=215905870,
        optional=True,
    )
    utilization_target_type: str = proto.Field(
        proto.STRING,
        number=340169355,
        optional=True,
    )


class AutoscalingPolicyLoadBalancingUtilization(proto.Message):
    r"""Configuration parameters of autoscaling based on load
    balancing.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        utilization_target (float):
            Fraction of backend capacity utilization (set
            in HTTP(S) load balancing configuration) that
            the autoscaler maintains. Must be a positive
            float value. If not defined, the default is 0.8.

            This field is a member of `oneof`_ ``_utilization_target``.
    """

    utilization_target: float = proto.Field(
        proto.DOUBLE,
        number=215905870,
        optional=True,
    )


class AutoscalingPolicyScaleInControl(proto.Message):
    r"""Configuration that allows for slower scale in so that even if
    Autoscaler recommends an abrupt scale in of a MIG, it will be
    throttled as specified by the parameters below.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        max_scaled_in_replicas (google.cloud.compute_v1.types.FixedOrPercent):
            Maximum allowed number (or %) of VMs that can
            be deducted from the peak recommendation during
            the window autoscaler looks at when computing
            recommendations. Possibly all these VMs can be
            deleted at once so user service needs to be
            prepared to lose that many VMs in one step.

            This field is a member of `oneof`_ ``_max_scaled_in_replicas``.
        time_window_sec (int):
            How far back autoscaling looks when computing
            recommendations to include directives regarding
            slower scale in, as described above.

            This field is a member of `oneof`_ ``_time_window_sec``.
    """

    max_scaled_in_replicas: "FixedOrPercent" = proto.Field(
        proto.MESSAGE,
        number=180710123,
        optional=True,
        message="FixedOrPercent",
    )
    time_window_sec: int = proto.Field(
        proto.INT32,
        number=36405300,
        optional=True,
    )


class AutoscalingPolicyScalingSchedule(proto.Message):
    r"""Scaling based on user-defined schedule. The message describes
    a single scaling schedule. A scaling schedule changes the
    minimum number of VM instances an autoscaler can recommend,
    which can trigger scaling out.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        description (str):
            A description of a scaling schedule.

            This field is a member of `oneof`_ ``_description``.
        disabled (bool):
            A boolean value that specifies whether a
            scaling schedule can influence autoscaler
            recommendations. If set to true, then a scaling
            schedule has no effect. This field is optional,
            and its value is false by default.

            This field is a member of `oneof`_ ``_disabled``.
        duration_sec (int):
            The duration of time intervals, in seconds,
            for which this scaling schedule is to run. The
            minimum allowed value is 300. This field is
            required.

            This field is a member of `oneof`_ ``_duration_sec``.
        min_required_replicas (int):
            The minimum number of VM instances that the
            autoscaler will recommend in time intervals
            starting according to schedule. This field is
            required.

            This field is a member of `oneof`_ ``_min_required_replicas``.
        schedule (str):
            The start timestamps of time intervals when this scaling
            schedule is to provide a scaling signal. This field uses the
            extended cron format (with an optional year field). The
            expression can describe a single timestamp if the optional
            year is set, in which case the scaling schedule runs once.
            The schedule is interpreted with respect to time_zone. This
            field is required. Note: These timestamps only describe when
            autoscaler starts providing the scaling signal. The VMs need
            additional time to become serving.

            This field is a member of `oneof`_ ``_schedule``.
        time_zone (str):
            The time zone to use when interpreting the schedule. The
            value of this field must be a time zone name from the tz
            database: https://en.wikipedia.org/wiki/Tz_database. This
            field is assigned a default value of "UTC" if left empty.

            This field is a member of `oneof`_ ``_time_zone``.
    """

    description: str = proto.Field(
        proto.STRING,
        number=422937596,
        optional=True,
    )
    disabled: bool = proto.Field(
        proto.BOOL,
        number=270940796,
        optional=True,
    )
    duration_sec: int = proto.Field(
        proto.INT32,
        number=212356902,
        optional=True,
    )
    min_required_replicas: int = proto.Field(
        proto.INT32,
        number=365514414,
        optional=True,
    )
    schedule: str = proto.Field(
        proto.STRING,
        number=375820951,
        optional=True,
    )
    time_zone: str = proto.Field(
        proto.STRING,
        number=36848094,
        optional=True,
    )


class Backend(proto.Message):
    r"""Message containing information of one individual backend.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        balancing_mode (str):
            Specifies how to determine whether the
            backend of a load balancer can handle additional
            traffic or is fully loaded. For usage
            guidelines, see Connection balancing mode.
            Backends must use compatible balancing modes.
            For more information, see Supported balancing
            modes and target capacity settings and
            Restrictions and guidance for instance groups.
            Note: Currently, if you use the API to configure
            incompatible balancing modes, the configuration
            might be accepted even though it has no impact
            and is ignored. Specifically,
            Backend.maxUtilization is ignored when
            Backend.balancingMode is RATE. In the future,
            this incompatible combination will be rejected.
            Check the BalancingMode enum for the list of
            possible values.

            This field is a member of `oneof`_ ``_balancing_mode``.
        capacity_scaler (float):
            A multiplier applied to the backend's target capacity of its
            balancing mode. The default value is 1, which means the
            group serves up to 100% of its configured capacity
            (depending on balancingMode). A setting of 0 means the group
            is completely drained, offering 0% of its available
            capacity. The valid ranges are 0.0 and [0.1,1.0]. You cannot
            configure a setting larger than 0 and smaller than 0.1. You
            cannot configure a setting of 0 when there is only one
            backend attached to the backend service. Not available with
            backends that don't support using a balancingMode. This
            includes backends such as global internet NEGs, regional
            serverless NEGs, and PSC NEGs.

            This field is a member of `oneof`_ ``_capacity_scaler``.
        custom_metrics (MutableSequence[google.cloud.compute_v1.types.BackendCustomMetric]):
            List of custom metrics that are used for CUSTOM_METRICS
            BalancingMode.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        failover (bool):
            This field designates whether this is a
            failover backend. More than one failover backend
            can be configured for a given BackendService.

            This field is a member of `oneof`_ ``_failover``.
        group (str):
            The fully-qualified URL of an instance group or network
            endpoint group (NEG) resource. To determine what types of
            backends a load balancer supports, see the `Backend services
            overview <https://cloud.google.com/load-balancing/docs/backend-service#backends>`__.
            You must use the *fully-qualified* URL (starting with
            https://www.googleapis.com/) to specify the instance group
            or NEG. Partial URLs are not supported. If haPolicy is
            specified, backends must refer to NEG resources of type
            GCE_VM_IP.

            This field is a member of `oneof`_ ``_group``.
        max_connections (int):
            Defines a target maximum number of
            simultaneous connections. For usage guidelines,
            see Connection balancing mode and Utilization
            balancing mode. Not available if the backend's
            balancingMode is RATE.

            This field is a member of `oneof`_ ``_max_connections``.
        max_connections_per_endpoint (int):
            Defines a target maximum number of
            simultaneous connections. For usage guidelines,
            see Connection balancing mode and Utilization
            balancing mode. Not available if the backend's
            balancingMode is RATE.

            This field is a member of `oneof`_ ``_max_connections_per_endpoint``.
        max_connections_per_instance (int):
            Defines a target maximum number of
            simultaneous connections. For usage guidelines,
            see Connection balancing mode and Utilization
            balancing mode. Not available if the backend's
            balancingMode is RATE.

            This field is a member of `oneof`_ ``_max_connections_per_instance``.
        max_rate (int):
            Defines a maximum number of HTTP requests per
            second (RPS). For usage guidelines, see Rate
            balancing mode and Utilization balancing mode.
            Not available if the backend's balancingMode is
            CONNECTION.

            This field is a member of `oneof`_ ``_max_rate``.
        max_rate_per_endpoint (float):
            Defines a maximum target for requests per
            second (RPS). For usage guidelines, see Rate
            balancing mode and Utilization balancing mode.
            Not available if the backend's balancingMode is
            CONNECTION.

            This field is a member of `oneof`_ ``_max_rate_per_endpoint``.
        max_rate_per_instance (float):
            Defines a maximum target for requests per
            second (RPS). For usage guidelines, see Rate
            balancing mode and Utilization balancing mode.
            Not available if the backend's balancingMode is
            CONNECTION.

            This field is a member of `oneof`_ ``_max_rate_per_instance``.
        max_utilization (float):
            Optional parameter to define a target capacity for the
            UTILIZATION balancing mode. The valid range is [0.0, 1.0].
            For usage guidelines, see Utilization balancing mode.

            This field is a member of `oneof`_ ``_max_utilization``.
        preference (str):
            This field indicates whether this backend
            should be fully utilized before sending traffic
            to backends with default preference. The
            possible values are: - PREFERRED: Backends with
            this preference level will be filled up to their
            capacity limits first, based on RTT. - DEFAULT:
            If preferred backends don't have enough
            capacity, backends in this layer would be used
            and traffic would be assigned based on the load
            balancing algorithm you use. This is the default
            Check the Preference enum for the list of
            possible values.

            This field is a member of `oneof`_ ``_preference``.
    """

    class BalancingMode(proto.Enum):
        r"""Specifies how to determine whether the backend of a load
        balancer can handle additional traffic or is fully loaded. For
        usage guidelines, see Connection balancing mode. Backends must
        use compatible balancing modes. For more information, see
        Supported balancing modes and target capacity settings and
        Restrictions and guidance for instance groups. Note: Currently,
        if you use the API to configure incompatible balancing modes,
        the configuration might be accepted even though it has no impact
        and is ignored. Specifically, Backend.maxUtilization is ignored
        when Backend.balancingMode is RATE. In the future, this
        incompatible combination will be rejected.

        Values:
            UNDEFINED_BALANCING_MODE (0):
                A value indicating that the enum field is not
                set.
            CONNECTION (246311646):
                Balance based on the number of simultaneous
                connections.
            CUSTOM_METRICS (331575765):
                Based on custom defined and reported metrics.
            RATE (2508000):
                Balance based on requests per second (RPS).
            UTILIZATION (157008386):
                Balance based on the backend utilization.
        """
        UNDEFINED_BALANCING_MODE = 0
        CONNECTION = 246311646
        CUSTOM_METRICS = 331575765
        RATE = 2508000
        UTILIZATION = 157008386

    class Preference(proto.Enum):
        r"""This field indicates whether this backend should be fully
        utilized before sending traffic to backends with default
        preference. The possible values are: - PREFERRED: Backends with
        this preference level will be filled up to their capacity limits
        first, based on RTT. - DEFAULT: If preferred backends don't have
        enough capacity, backends in this layer would be used and
        traffic would be assigned based on the load balancing algorithm
        you use. This is the default

        Values:
            UNDEFINED_PREFERENCE (0):
                A value indicating that the enum field is not
                set.
            DEFAULT (115302945):
                No preference.
            PREFERENCE_UNSPECIFIED (496219571):
                If preference is unspecified, we set it to
                the DEFAULT value
            PREFERRED (418847841):
                Traffic will be sent to this backend first.
        """
        UNDEFINED_PREFERENCE = 0
        DEFAULT = 115302945
        PREFERENCE_UNSPECIFIED = 496219571
        PREFERRED = 418847841

    balancing_mode: str = proto.Field(
        proto.STRING,
        number=430286217,
        optional=True,
    )
    capacity_scaler: float = proto.Field(
        proto.FLOAT,
        number=315958157,
        optional=True,
    )
    custom_metrics: MutableSequence["BackendCustomMetric"] = proto.RepeatedField(
        proto.MESSAGE,
        number=429453813,
        message="BackendCustomMetric",
    )
    description: str = proto.Field(
        proto.STRING,
        number=422937596,
        optional=True,
    )
    failover: bool = proto.Field(
        proto.BOOL,
        number=138892530,
        optional=True,
    )
    group: str = proto.Field(
        proto.STRING,
        number=98629247,
        optional=True,
    )
    max_connections: int = proto.Field(
        proto.INT32,
        number=110652154,
        optional=True,
    )
    max_connections_per_endpoint: int = proto.Field(
        proto.INT32,
        number=216904604,
        optional=True,
    )
    max_connections_per_instance: int = proto.Field(
        proto.INT32,
        number=104671900,
        optional=True,
    )
    max_rate: int = proto.Field(
        proto.INT32,
        number=408035035,
        optional=True,
    )
    max_rate_per_endpoint: float = proto.Field(
        proto.FLOAT,
        number=129832283,
        optional=True,
    )
    max_rate_per_instance: float = proto.Field(
        proto.FLOAT,
        number=17599579,
        optional=True,
    )
    max_utilization: float = proto.Field(
        proto.FLOAT,
        number=148192199,
        optional=True,
    )
    preference: str = proto.Field(
        proto.STRING,
        number=150781147,
        optional=True,
    )


class BackendBucket(proto.Message):
    r"""Represents a Cloud Storage Bucket resource. This Cloud
    Storage bucket resource is referenced by a URL map of a load
    balancer. For more information, read Backend Buckets.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        bucket_name (str):
            Cloud Storage bucket name.

            This field is a member of `oneof`_ ``_bucket_name``.
        cdn_policy (google.cloud.compute_v1.types.BackendBucketCdnPolicy):
            Cloud CDN configuration for this
            BackendBucket.

            This field is a member of `oneof`_ ``_cdn_policy``.
        compression_mode (str):
            Compress text responses using Brotli or gzip
            compression, based on the client's
            Accept-Encoding header. Check the
            CompressionMode enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_compression_mode``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        custom_response_headers (MutableSequence[str]):
            Headers that the Application Load Balancer
            should add to proxied responses.
        description (str):
            An optional textual description of the
            resource; provided by the client when the
            resource is created.

            This field is a member of `oneof`_ ``_description``.
        edge_security_policy (str):
            [Output Only] The resource URL for the edge security policy
            associated with this backend bucket.

            This field is a member of `oneof`_ ``_edge_security_policy``.
        enable_cdn (bool):
            If true, enable Cloud CDN for this
            BackendBucket.

            This field is a member of `oneof`_ ``_enable_cdn``.
        id (int):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            Type of the resource.

            This field is a member of `oneof`_ ``_kind``.
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        used_by (MutableSequence[google.cloud.compute_v1.types.BackendBucketUsedBy]):
            [Output Only] List of resources referencing that backend
            bucket.
    """

    class CompressionMode(proto.Enum):
        r"""Compress text responses using Brotli or gzip compression,
        based on the client's Accept-Encoding header.

        Values:
            UNDEFINED_COMPRESSION_MODE (0):
                A value indicating that the enum field is not
                set.
            AUTOMATIC (165298699):
                Automatically uses the best compression based
                on the Accept-Encoding header sent by the
                client.
            DISABLED (516696700):
                Disables compression. Existing compressed
                responses cached by Cloud CDN will not be served
                to clients.
        """
        UNDEFINED_COMPRESSION_MODE = 0
        AUTOMATIC = 165298699
        DISABLED = 516696700

    bucket_name: str = proto.Field(
        proto.STRING,
        number=283610048,
        optional=True,
    )
    cdn_policy: "BackendBucketCdnPolicy" = proto.Field(
        proto.MESSAGE,
        number=213976452,
        optional=True,
        message="BackendBucketCdnPolicy",
    )
    compression_mode: str = proto.Field(
        proto.STRING,
        number=95520988,
        optional=True,
    )
    creation_timestamp: str = proto.Field(
        proto.STRING,
        number=30525366,
        optional=True,
    )
    custom_response_headers: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=387539094,
    )
    description: str = proto.Field(
        proto.STRING,
        number=422937596,
        optional=True,
    )
    edge_security_policy: str = proto.Field(
        proto.STRING,
        number=41036943,
        optional=True,
    )
    enable_cdn: bool = proto.Field(
        proto.BOOL,
        number=282942321,
        optional=True,
    )
    id: int = proto.Field(
        proto.UINT64,
        number=3355,
        optional=True,
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    used_by: MutableSequence["BackendBucketUsedBy"] = proto.RepeatedField(
        proto.MESSAGE,
        number=389320729,
        message="BackendBucketUsedBy",
    )


class BackendBucketCdnPolicy(proto.Message):
    r"""Message containing Cloud CDN configuration for a backend
    bucket.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        bypass_cache_on_request_headers (MutableSequence[google.cloud.compute_v1.types.BackendBucketCdnPolicyBypassCacheOnRequestHeader]):
            Bypass the cache when the specified request
            headers are matched - e.g. Pragma or
            Authorization headers. Up to 5 headers can be
            specified. The cache is bypassed for all
            cdnPolicy.cacheMode settings.
        cache_key_policy (google.cloud.compute_v1.types.BackendBucketCdnPolicyCacheKeyPolicy):
            The CacheKeyPolicy for this CdnPolicy.

            This field is a member of `oneof`_ ``_cache_key_policy``.
        cache_mode (str):
            Specifies the cache setting for all responses from this
            backend. The possible values are: USE_ORIGIN_HEADERS
            Requires the origin to set valid caching headers to cache
            content. Responses without these headers will not be cached
            at Google's edge, and will require a full trip to the origin
            on every request, potentially impacting performance and
            increasing load on the origin server. FORCE_CACHE_ALL Cache
            all content, ignoring any "private", "no-store" or
            "no-cache" directives in Cache-Control response headers.
            Warning: this may result in Cloud CDN caching private,
            per-user (user identifiable) content. CACHE_ALL_STATIC
            Automatically cache static content, including common image
            formats, media (video and audio), and web assets (JavaScript
            and CSS). Requests and responses that are marked as
            uncacheable, as well as dynamic content (including HTML),
            will not be cached. If no value is provided for
            cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC. Check
            the CacheMode enum for the list of possible values.

            This field is a member of `oneof`_ ``_cache_mode``.
        client_ttl (int):
            Specifies a separate client (e.g. browser client) maximum
            TTL. This is used to clamp the max-age (or Expires) value
            sent to the client. With FORCE_CACHE_ALL, the lesser of
            client_ttl and default_ttl is used for the response max-age
            directive, along with a "public" directive. For cacheable
            content in CACHE_ALL_STATIC mode, client_ttl clamps the
            max-age from the origin (if specified), or else sets the
            response max-age directive to the lesser of the client_ttl
            and default_ttl, and also ensures a "public" cache-control
            directive is present. If a client TTL is not specified, a
            default value (1 hour) will be used. The maximum allowed
            value is 31,622,400s (1 year).

            This field is a member of `oneof`_ ``_client_ttl``.
        default_ttl (int):
            Specifies the default TTL for cached content served by this
            origin for responses that do not have an existing valid TTL
            (max-age or s-maxage). Setting a TTL of "0" means "always
            revalidate". The value of defaultTTL cannot be set to a
            value greater than that of maxTTL, but can be equal. When
            the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will
            overwrite the TTL set in all responses. The maximum allowed
            value is 31,622,400s (1 year), noting that infrequently
            accessed objects may be evicted from the cache before the
            defined TTL.

            This field is a member of `oneof`_ ``_default_ttl``.
        max_ttl (int):
            Specifies the maximum allowed TTL for cached
            content served by this origin. Cache directives
            that attempt to set a max-age or s-maxage higher
            than this, or an Expires header more than maxTTL
            seconds in the future will be capped at the
            value of maxTTL, as if it were the value of an
            s-maxage Cache-Control directive. Headers sent
            to the client will not be modified. Setting a
            TTL of "0" means "always revalidate". The
            maximum allowed value is 31,622,400s (1 year),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.

            This field is a member of `oneof`_ ``_max_ttl``.
        negative_caching (bool):
            Negative caching allows per-status code TTLs to be set, in
            order to apply fine-grained caching for common errors or
            redirects. This can reduce the load on your origin and
            improve end-user experience by reducing response latency.
            When the cache mode is set to CACHE_ALL_STATIC or
            USE_ORIGIN_HEADERS, negative caching applies to responses
            with the specified response code that lack any
            Cache-Control, Expires, or Pragma: no-cache directives. When
            the cache mode is set to FORCE_CACHE_ALL, negative caching
            applies to all responses with the specified response code,
            and override any caching headers. By default, Cloud CDN will
            apply the following default TTLs to these status codes: HTTP
            300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
            HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal
            Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected
            Request), 501 (Not Implemented): 60s. These defaults can be
            overridden in negative_caching_policy.

            This field is a member of `oneof`_ ``_negative_caching``.
        negative_caching_policy (MutableSequence[google.cloud.compute_v1.types.BackendBucketCdnPolicyNegativeCachingPolicy]):
            Sets a cache TTL for the specified HTTP status code.
            negative_caching must be enabled to configure
            negative_caching_policy. Omitting the policy and leaving
            negative_caching enabled will use Cloud CDN's default cache
            TTLs. Note that when specifying an explicit
            negative_caching_policy, you should take care to specify a
            cache TTL for all response codes that you wish to cache.
            Cloud CDN will not apply any default negative caching when a
            policy exists.
        request_coalescing (bool):
            If true then Cloud CDN will combine multiple
            concurrent cache fill requests into a small
            number of requests to the origin.

            This field is a member of `oneof`_ ``_request_coalescing``.
        serve_while_stale (int):
            Serve existing content from the cache (if
            available) when revalidating content with the
            origin, or when an error is encountered when
            refreshing the cache. This setting defines the
            default "max-stale" duration for any cached
            responses that do not specify a max-stale
            directive. Stale responses that exceed the TTL
            configured here will not be served. The default
            limit (max-stale) is 86400s (1 day), which will
            allow stale content to be served up to this
            limit beyond the max-age (or s-maxage) of a
            cached response. The maximum allowed value is
            604800 (1 week). Set this to zero (0) to disable
            serve-while-stale.

            This field is a member of `oneof`_ ``_serve_while_stale``.
        signed_url_cache_max_age_sec (int):
            Maximum number of seconds the response to a signed URL
            request will be considered fresh. After this time period,
            the response will be revalidated before being served.
            Defaults to 1hr (3600s). When serving responses to signed
            URL requests, Cloud CDN will internally behave as though all
            responses from this backend had a "Cache-Control: public,
            max-age=[TTL]" header, regardless of any existing
            Cache-Control header. The actual headers served in responses
            will not be altered.

            This field is a member of `oneof`_ ``_signed_url_cache_max_age_sec``.
        signed_url_key_names (MutableSequence[str]):
            [Output Only] Names of the keys for signing request URLs.
    """

    class CacheMode(proto.Enum):
        r"""Specifies the cache setting for all responses from this backend. The
        possible values are: USE_ORIGIN_HEADERS Requires the origin to set
        valid caching headers to cache content. Responses without these
        headers will not be cached at Google's edge, and will require a full
        trip to the origin on every request, potentially impacting
        performance and increasing load on the origin server.
        FORCE_CACHE_ALL Cache all content, ignoring any "private",
        "no-store" or "no-cache" directives in Cache-Control response
        headers. Warning: this may result in Cloud CDN caching private,
        per-user (user identifiable) content. CACHE_ALL_STATIC Automatically
        cache static content, including common image formats, media (video
        and audio), and web assets (JavaScript and CSS). Requests and
        responses that are marked as uncacheable, as well as dynamic content
        (including HTML), will not be cached. If no value is provided for
        cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC.

        Values:
            UNDEFINED_CACHE_MODE (0):
                A value indicating that the enum field is not
                set.
            CACHE_ALL_STATIC (355027945):
                Automatically cache static content, including
                common image formats, media (video and audio),
                and web assets (JavaScript and CSS). Requests
                and responses that are marked as uncacheable, as
                well as dynamic content (including HTML), will
                not be cached.
            FORCE_CACHE_ALL (486026928):
                Cache all content, ignoring any "private",
                "no-store" or "no-cache" directives in
                Cache-Control response headers. Warning: this
                may result in Cloud CDN caching private,
                per-user (user identifiable) content.
            INVALID_CACHE_MODE (381295560):
                No description available.
            USE_ORIGIN_HEADERS (55380261):
                Requires the origin to set valid caching
                headers to cache content. Responses without
                these headers will not be cached at Google's
                edge, and will require a full trip to the origin
                on every request, potentially impacting
                performance and increasing load on the origin
                server.
        """
        UNDEFINED_CACHE_MODE = 0
        CACHE_ALL_STATIC = 355027945
        FORCE_CACHE_ALL = 486026928
        INVALID_CACHE_MODE = 381295560
        USE_ORIGIN_HEADERS = 55380261

    bypass_cache_on_request_headers: MutableSequence[
        "BackendBucketCdnPolicyBypassCacheOnRequestHeader"
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=486203082,
        message="BackendBucketCdnPolicyBypassCacheOnRequestHeader",
    )
    cache_key_policy: "BackendBucketCdnPolicyCacheKeyPolicy" = proto.Field(
        proto.MESSAGE,
        number=159263727,
        optional=True,
        message="BackendBucketCdnPolicyCacheKeyPolicy",
    )
    cache_mode: str = proto.Field(
        proto.STRING,
        number=28877888,
        optional=True,
    )
    client_ttl: int = proto.Field(
        proto.INT32,
        number=29034360,
        optional=True,
    )
    default_ttl: int = proto.Field(
        proto.INT32,
        number=100253422,
        optional=True,
    )
    max_ttl: int = proto.Field(
        proto.INT32,
        number=307578001,
        optional=True,
    )
    negative_caching: bool = proto.Field(
        proto.BOOL,
        number=336110005,
        optional=True,
    )
    negative_caching_policy: MutableSequence[
        "BackendBucketCdnPolicyNegativeCachingPolicy"
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=155359996,
        message="BackendBucketCdnPolicyNegativeCachingPolicy",
    )
    request_coalescing: bool = proto.Field(
        proto.BOOL,
        number=532808276,
        optional=True,
    )
    serve_while_stale: int = proto.Field(
        proto.INT32,
        number=236682203,
        optional=True,
    )
    signed_url_cache_max_age_sec: int = proto.Field(
        proto.INT64,
        number=269374534,
        optional=True,
    )
    signed_url_key_names: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=371848885,
    )


class BackendBucketCdnPolicyBypassCacheOnRequestHeader(proto.Message):
    r"""Bypass the cache when the specified request headers are present,
    e.g. Pragma or Authorization headers. Values are case insensitive.
    The presence of such a header overrides the cache_mode setting.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        header_name (str):
            The header field name to match on when
            bypassing cache. Values are case-insensitive.

            This field is a member of `oneof`_ ``_header_name``.
    """

    header_name: str = proto.Field(
        proto.STRING,
        number=110223613,
        optional=True,
    )


class BackendBucketCdnPolicyCacheKeyPolicy(proto.Message):
    r"""Message containing what to include in the cache key for a
    request for Cloud CDN.

    Attributes:
        include_http_headers (MutableSequence[str]):
            Allows HTTP request headers (by name) to be
            used in the cache key.
        query_string_whitelist (MutableSequence[str]):
            Names of query string parameters to include
            in cache keys. Default parameters are always
            included. '&' and '=' will be percent encoded
            and not treated as delimiters.
    """

    include_http_headers: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=2489606,
    )
    query_string_whitelist: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=52456496,
    )


class BackendBucketCdnPolicyNegativeCachingPolicy(proto.Message):
    r"""Specify CDN TTLs for response error codes.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        code (int):
            The HTTP status code to define a TTL against.
            Only HTTP status codes 300, 301, 302, 307, 308,
            404, 405, 410, 421, 451 and 501 are can be
            specified as values, and you cannot specify a
            status code more than once.

            This field is a member of `oneof`_ ``_code``.
        ttl (int):
            The TTL (in seconds) for which to cache
            responses with the corresponding status code.
            The maximum allowed value is 1800s (30 minutes),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.

            This field is a member of `oneof`_ ``_ttl``.
    """

    code: int = proto.Field(
        proto.INT32,
        number=3059181,
        optional=True,
    )
    ttl: int = proto.Field(
        proto.INT32,
        number=115180,
        optional=True,
    )


class BackendBucketList(proto.Message):
    r"""Contains a list of BackendBucket resources.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableSequence[google.cloud.compute_v1.types.BackendBucket]):
            A list of BackendBucket resources.
        kind (str):
            Type of resource.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableSequence["BackendBucket"] = proto.RepeatedField(
        proto.MESSAGE,
        number=100526016,
        message="BackendBucket",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class BackendBucketUsedBy(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        reference (str):
            [Output Only] Server-defined URL for UrlMaps referencing
            that BackendBucket.

            This field is a member of `oneof`_ ``_reference``.
    """

    reference: str = proto.Field(
        proto.STRING,
        number=148586315,
        optional=True,
    )


class BackendCustomMetric(proto.Message):
    r"""Custom Metrics are used for CUSTOM_METRICS balancing_mode.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        dry_run (bool):
            If true, the metric data is collected and
            reported to Cloud Monitoring, but is not used
            for load balancing.

            This field is a member of `oneof`_ ``_dry_run``.
        max_utilization (float):
            Optional parameter to define a target utilization for the
            Custom Metrics balancing mode. The valid range is [0.0,
            1.0].

            This field is a member of `oneof`_ ``_max_utilization``.
        name (str):
            Name of a custom utilization signal. The name must be 1-64
            characters long and match the regular expression
            `a-z <[-_.a-z0-9]*[a-z0-9]>`__? which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, period, underscore, lowercase
            letter, or digit, except the last character, which cannot be
            a dash, period, or underscore. For usage guidelines, see
            Custom Metrics balancing mode. This field can only be used
            for a global or regional backend service with the
            loadBalancingScheme set to EXTERNAL_MANAGED,
            INTERNAL_MANAGED INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_name``.
    """

    dry_run: bool = proto.Field(
        proto.BOOL,
        number=323854839,
        optional=True,
    )
    max_utilization: float = proto.Field(
        proto.FLOAT,
        number=148192199,
        optional=True,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )


class BackendService(proto.Message):
    r"""Represents a Backend Service resource. A backend service defines how
    Google Cloud load balancers distribute traffic. The backend service
    configuration contains a set of values, such as the protocol used to
    connect to backends, various distribution and session settings,
    health checks, and timeouts. These settings provide fine-grained
    control over how your load balancer behaves. Most of the settings
    have default values that allow for easy configuration if you need to
    get started quickly. Backend services in Google Compute Engine can
    be either regionally or globally scoped. \*
    `Global <https://cloud.google.com/compute/docs/reference/rest/v1/backendServices>`__
    \*
    `Regional <https://cloud.google.com/compute/docs/reference/rest/v1/regionBackendServices>`__
    For more information, see Backend Services.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        affinity_cookie_ttl_sec (int):
            Lifetime of cookies in seconds. This setting is applicable
            to Application Load Balancers and Traffic Director and
            requires GENERATED_COOKIE or HTTP_COOKIE session affinity.
            If set to 0, the cookie is non-persistent and lasts only
            until the end of the browser session (or equivalent). The
            maximum allowed value is two weeks (1,209,600). Not
            supported when the backend service is referenced by a URL
            map that is bound to target gRPC proxy that has
            validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_affinity_cookie_ttl_sec``.
        backends (MutableSequence[google.cloud.compute_v1.types.Backend]):
            The list of backends that serve this
            BackendService.
        cdn_policy (google.cloud.compute_v1.types.BackendServiceCdnPolicy):
            Cloud CDN configuration for this
            BackendService. Only available for specified
            load balancer types.

            This field is a member of `oneof`_ ``_cdn_policy``.
        circuit_breakers (google.cloud.compute_v1.types.CircuitBreakers):

            This field is a member of `oneof`_ ``_circuit_breakers``.
        compression_mode (str):
            Compress text responses using Brotli or gzip
            compression, based on the client's
            Accept-Encoding header. Check the
            CompressionMode enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_compression_mode``.
        connection_draining (google.cloud.compute_v1.types.ConnectionDraining):
            connectionDraining cannot be specified with
            haPolicy.

            This field is a member of `oneof`_ ``_connection_draining``.
        connection_tracking_policy (google.cloud.compute_v1.types.BackendServiceConnectionTrackingPolicy):
            Connection Tracking configuration for this
            BackendService. Connection tracking policy
            settings are only available for external
            passthrough Network Load Balancers and internal
            passthrough Network Load Balancers.
            connectionTrackingPolicy cannot be specified
            with haPolicy.

            This field is a member of `oneof`_ ``_connection_tracking_policy``.
        consistent_hash (google.cloud.compute_v1.types.ConsistentHashLoadBalancerSettings):
            Consistent Hash-based load balancing can be used to provide
            soft session affinity based on HTTP headers, cookies or
            other properties. This load balancing policy is applicable
            only for HTTP connections. The affinity to a particular
            destination host will be lost when one or more hosts are
            added/removed from the destination service. This field
            specifies parameters that control consistent hashing. This
            field is only applicable when localityLbPolicy is set to
            MAGLEV or RING_HASH. This field is applicable to either: - A
            regional backend service with the service_protocol set to
            HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to
            INTERNAL_MANAGED. - A global backend service with the
            load_balancing_scheme set to INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_consistent_hash``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        custom_metrics (MutableSequence[google.cloud.compute_v1.types.BackendServiceCustomMetric]):
            List of custom metrics that are used for the
            WEIGHTED_ROUND_ROBIN locality_lb_policy.
        custom_request_headers (MutableSequence[str]):
            Headers that the load balancer adds to proxied requests. See
            `Creating custom
            headers <https://cloud.google.com/load-balancing/docs/custom-headers>`__.
        custom_response_headers (MutableSequence[str]):
            Headers that the load balancer adds to proxied responses.
            See `Creating custom
            headers <https://cloud.google.com/load-balancing/docs/custom-headers>`__.
        description (str):
            An optional description of this resource.
            Provide this property when you create the
            resource.

            This field is a member of `oneof`_ ``_description``.
        edge_security_policy (str):
            [Output Only] The resource URL for the edge security policy
            associated with this backend service.

            This field is a member of `oneof`_ ``_edge_security_policy``.
        enable_c_d_n (bool):
            If true, enables Cloud CDN for the backend
            service of a global external Application Load
            Balancer.

            This field is a member of `oneof`_ ``_enable_c_d_n``.
        external_managed_migration_state (str):
            Specifies the canary migration state. Possible values are
            PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin
            the migration from EXTERNAL to EXTERNAL_MANAGED, the state
            must be changed to PREPARE. The state must be changed to
            TEST_ALL_TRAFFIC before the loadBalancingScheme can be
            changed to EXTERNAL_MANAGED. Optionally, the
            TEST_BY_PERCENTAGE state can be used to migrate traffic by
            percentage using externalManagedMigrationTestingPercentage.
            Rolling back a migration requires the states to be set in
            reverse order. So changing the scheme from EXTERNAL_MANAGED
            to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC
            at the same time. Optionally, the TEST_BY_PERCENTAGE state
            can be used to migrate some traffic back to EXTERNAL or
            PREPARE can be used to migrate all traffic back to EXTERNAL.
            Check the ExternalManagedMigrationState enum for the list of
            possible values.

            This field is a member of `oneof`_ ``_external_managed_migration_state``.
        external_managed_migration_testing_percentage (float):
            Determines the fraction of requests that should be processed
            by the Global external Application Load Balancer. The value
            of this field must be in the range [0, 100]. Session
            affinity options will slightly affect this routing behavior,
            for more details, see: Session Affinity. This value can only
            be set if the loadBalancingScheme in the BackendService is
            set to EXTERNAL (when using the classic Application Load
            Balancer) and the migration state is TEST_BY_PERCENTAGE.

            This field is a member of `oneof`_ ``_external_managed_migration_testing_percentage``.
        failover_policy (google.cloud.compute_v1.types.BackendServiceFailoverPolicy):
            Requires at least one backend instance group to be defined
            as a backup (failover) backend. For load balancers that have
            configurable failover: `Internal passthrough Network Load
            Balancers <https://cloud.google.com/load-balancing/docs/internal/failover-overview>`__
            and `external passthrough Network Load
            Balancers <https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview>`__.
            failoverPolicy cannot be specified with haPolicy.

            This field is a member of `oneof`_ ``_failover_policy``.
        fingerprint (str):
            Fingerprint of this resource. A hash of the
            contents stored in this object. This field is
            used in optimistic locking. This field will be
            ignored when inserting a BackendService. An
            up-to-date fingerprint must be provided in order
            to update the BackendService, otherwise the
            request will fail with error 412
            conditionNotMet. To see the latest fingerprint,
            make a get() request to retrieve a
            BackendService.

            This field is a member of `oneof`_ ``_fingerprint``.
        ha_policy (google.cloud.compute_v1.types.BackendServiceHAPolicy):
            Configures self-managed High Availability (HA) for External
            and Internal Protocol Forwarding. The backends of this
            regional backend service must only specify zonal network
            endpoint groups (NEGs) of type GCE_VM_IP. When haPolicy is
            set for an Internal Passthrough Network Load Balancer, the
            regional backend service must set the network field. All
            zonal NEGs must belong to the same network. However,
            individual NEGs can belong to different subnetworks of that
            network. When haPolicy is specified, the set of attached
            network endpoints across all backends comprise an High
            Availability domain from which one endpoint is selected as
            the active endpoint (the leader) that receives all traffic.
            haPolicy can be added only at backend service creation time.
            Once set up, it cannot be deleted. Note that haPolicy is not
            for load balancing, and therefore cannot be specified with
            sessionAffinity, connectionTrackingPolicy, and
            failoverPolicy. haPolicy requires customers to be
            responsible for tracking backend endpoint health and
            electing a leader among the healthy endpoints. Therefore,
            haPolicy cannot be specified with healthChecks. haPolicy can
            only be specified for External Passthrough Network Load
            Balancers and Internal Passthrough Network Load Balancers.

            This field is a member of `oneof`_ ``_ha_policy``.
        health_checks (MutableSequence[str]):
            The list of URLs to the healthChecks, httpHealthChecks
            (legacy), or httpsHealthChecks (legacy) resource for health
            checking this backend service. Not all backend services
            support legacy health checks. See Load balancer guide.
            Currently, at most one health check can be specified for
            each backend service. Backend services with instance group
            or zonal NEG backends must have a health check unless
            haPolicy is specified. Backend services with internet or
            serverless NEG backends must not have a health check.
            healthChecks[] cannot be specified with haPolicy.
        iap (google.cloud.compute_v1.types.BackendServiceIAP):
            The configurations for Identity-Aware Proxy
            on this resource. Not available for internal
            passthrough Network Load Balancers and external
            passthrough Network Load Balancers.

            This field is a member of `oneof`_ ``_iap``.
        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        ip_address_selection_policy (str):
            Specifies a preference for traffic sent from the proxy to
            the backend (or from the client to the backend for proxyless
            gRPC). The possible values are: - IPV4_ONLY: Only send IPv4
            traffic to the backends of the backend service (Instance
            Group, Managed Instance Group, Network Endpoint Group),
            regardless of traffic from the client to the proxy. Only
            IPv4 health checks are used to check the health of the
            backends. This is the default setting. - PREFER_IPV6:
            Prioritize the connection to the endpoint's IPv6 address
            over its IPv4 address (provided there is a healthy IPv6
            address). - IPV6_ONLY: Only send IPv6 traffic to the
            backends of the backend service (Instance Group, Managed
            Instance Group, Network Endpoint Group), regardless of
            traffic from the client to the proxy. Only IPv6 health
            checks are used to check the health of the backends. This
            field is applicable to either: - Advanced global external
            Application Load Balancer (load balancing scheme
            EXTERNAL_MANAGED), - Regional external Application Load
            Balancer, - Internal proxy Network Load Balancer (load
            balancing scheme INTERNAL_MANAGED), - Regional internal
            Application Load Balancer (load balancing scheme
            INTERNAL_MANAGED), - Traffic Director with Envoy proxies and
            proxyless gRPC (load balancing scheme
            INTERNAL_SELF_MANAGED). Check the IpAddressSelectionPolicy
            enum for the list of possible values.

            This field is a member of `oneof`_ ``_ip_address_selection_policy``.
        kind (str):
            [Output Only] Type of resource. Always
            compute#backendService for backend services.

            This field is a member of `oneof`_ ``_kind``.
        load_balancing_scheme (str):
            Specifies the load balancer type. A backend
            service created for one type of load balancer
            cannot be used with another. For more
            information, refer to Choosing a load balancer.
            Check the LoadBalancingScheme enum for the list
            of possible values.

            This field is a member of `oneof`_ ``_load_balancing_scheme``.
        locality_lb_policies (MutableSequence[google.cloud.compute_v1.types.BackendServiceLocalityLoadBalancingPolicyConfig]):
            A list of locality load-balancing policies to be used in
            order of preference. When you use localityLbPolicies, you
            must set at least one value for either the
            localityLbPolicies[].policy or the
            localityLbPolicies[].customPolicy field. localityLbPolicies
            overrides any value set in the localityLbPolicy field. For
            an example of how to use this field, see Define a list of
            preferred policies. Caution: This field and its children are
            intended for use in a service mesh that includes gRPC
            clients only. Envoy proxies can't use backend services that
            have this configuration.
        locality_lb_policy (str):
            The load balancing algorithm used within the scope of the
            locality. The possible values are: - ROUND_ROBIN: This is a
            simple policy in which each healthy backend is selected in
            round robin order. This is the default. - LEAST_REQUEST: An
            O(1) algorithm which selects two random healthy hosts and
            picks the host which has fewer active requests. - RING_HASH:
            The ring/modulo hash load balancer implements consistent
            hashing to backends. The algorithm has the property that the
            addition/removal of a host from a set of N hosts only
            affects 1/N of the requests. - RANDOM: The load balancer
            selects a random healthy host. - ORIGINAL_DESTINATION:
            Backend host is selected based on the client connection
            metadata, i.e., connections are opened to the same address
            as the destination address of the incoming connection before
            the connection was redirected to the load balancer. -
            MAGLEV: used as a drop in replacement for the ring hash load
            balancer. Maglev is not as stable as ring hash but has
            faster table lookup build times and host selection times.
            For more information about Maglev, see
            https://ai.google/research/pubs/pub44824 This field is
            applicable to either: - A regional backend service with the
            service_protocol set to HTTP, HTTPS, or HTTP2, and
            load_balancing_scheme set to INTERNAL_MANAGED. - A global
            backend service with the load_balancing_scheme set to
            INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or
            EXTERNAL_MANAGED. If sessionAffinity is not configured—that
            is, if session affinity remains at the default value of
            NONE—then the default value for localityLbPolicy is
            ROUND_ROBIN. If session affinity is set to a value other
            than NONE, then the default value for localityLbPolicy is
            MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when
            the backend service is referenced by a URL map that is bound
            to target gRPC proxy that has validateForProxyless field set
            to true. localityLbPolicy cannot be specified with haPolicy.
            Check the LocalityLbPolicy enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_locality_lb_policy``.
        log_config (google.cloud.compute_v1.types.BackendServiceLogConfig):
            This field denotes the logging options for
            the load balancer traffic served by this backend
            service. If logging is enabled, logs will be
            exported to Stackdriver.

            This field is a member of `oneof`_ ``_log_config``.
        max_stream_duration (google.cloud.compute_v1.types.Duration):
            Specifies the default maximum duration (timeout) for streams
            to this service. Duration is computed from the beginning of
            the stream until the response has been completely processed,
            including all retries. A stream that does not complete in
            this duration is closed. If not specified, there will be no
            timeout limit, i.e. the maximum duration is infinite. This
            value can be overridden in the PathMatcher configuration of
            the UrlMap that references this backend service. This field
            is only allowed when the loadBalancingScheme of the backend
            service is INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_max_stream_duration``.
        metadatas (MutableMapping[str, str]):
            Deployment metadata associated with the
            resource to be set by a GKE hub controller and
            read by the backend RCTH
        name (str):
            Name of the resource. Provided by the client when the
            resource is created. The name must be 1-63 characters long,
            and comply with RFC1035. Specifically, the name must be 1-63
            characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        network (str):
            The URL of the network to which this backend
            service belongs. This field must be set for
            Internal Passthrough Network Load Balancers when
            the haPolicy is enabled, and for External
            Passthrough Network Load Balancers when the
            haPolicy fastIpMove is enabled. This field can
            only be specified when the load balancing scheme
            is set to INTERNAL.

            This field is a member of `oneof`_ ``_network``.
        outlier_detection (google.cloud.compute_v1.types.OutlierDetection):
            Settings controlling the ejection of unhealthy backend
            endpoints from the load balancing pool of each individual
            proxy instance that processes the traffic for the given
            backend service. If not set, this feature is considered
            disabled. Results of the outlier detection algorithm
            (ejection of endpoints from the load balancing pool and
            returning them back to the pool) are executed independently
            by each proxy instance of the load balancer. In most cases,
            more than one proxy instance handles the traffic received by
            a backend service. Thus, it is possible that an unhealthy
            endpoint is detected and ejected by only some of the
            proxies, and while this happens, other proxies may continue
            to send requests to the same unhealthy endpoint until they
            detect and eject the unhealthy endpoint. Applicable backend
            endpoints can be: - VM instances in an Instance Group -
            Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) -
            Endpoints in a Hybrid Connectivity NEG
            (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to
            Cloud Run, App Engine, or Cloud Functions Services - Private
            Service Connect NEGs, that resolve to Google-managed
            regional API endpoints or managed services published using
            Private Service Connect Applicable backend service types can
            be: - A global backend service with the loadBalancingScheme
            set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A
            regional backend service with the serviceProtocol set to
            HTTP, HTTPS, or HTTP2, and loadBalancingScheme set to
            INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for
            Serverless NEGs. Not supported when the backend service is
            referenced by a URL map that is bound to target gRPC proxy
            that has validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_outlier_detection``.
        port (int):
            Deprecated in favor of portName. The TCP port
            to connect on the backend. The default value is
            80. For internal passthrough Network Load
            Balancers and external passthrough Network Load
            Balancers, omit port.

            This field is a member of `oneof`_ ``_port``.
        port_name (str):
            A named port on a backend instance group representing the
            port for communication to the backend VMs in that group. The
            named port must be `defined on each backend instance
            group <https://cloud.google.com/load-balancing/docs/backend-service#named_ports>`__.
            This parameter has no meaning if the backends are NEGs. For
            internal passthrough Network Load Balancers and external
            passthrough Network Load Balancers, omit port_name.

            This field is a member of `oneof`_ ``_port_name``.
        protocol (str):
            The protocol this BackendService uses to
            communicate with backends. Possible values are
            HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC.
            depending on the chosen load balancer or Traffic
            Director configuration. Refer to the
            documentation for the load balancers or for
            Traffic Director for more information. Must be
            set to GRPC when the backend service is
            referenced by a URL map that is bound to target
            gRPC proxy. Check the Protocol enum for the list
            of possible values.

            This field is a member of `oneof`_ ``_protocol``.
        region (str):
            [Output Only] URL of the region where the regional backend
            service resides. This field is not applicable to global
            backend services. You must specify this field as part of the
            HTTP request URL. It is not settable as a field in the
            request body.

            This field is a member of `oneof`_ ``_region``.
        security_policy (str):
            [Output Only] The resource URL for the security policy
            associated with this backend service.

            This field is a member of `oneof`_ ``_security_policy``.
        security_settings (google.cloud.compute_v1.types.SecuritySettings):
            This field specifies the security settings that apply to
            this backend service. This field is applicable to a global
            backend service with the load_balancing_scheme set to
            INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_security_settings``.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        service_bindings (MutableSequence[str]):
            URLs of networkservices.ServiceBinding resources. Can only
            be set if load balancing scheme is INTERNAL_SELF_MANAGED. If
            set, lists of backends and health checks must be both empty.
        service_lb_policy (str):
            URL to networkservices.ServiceLbPolicy resource. Can only be
            set if load balancing scheme is EXTERNAL, EXTERNAL_MANAGED,
            INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is
            global.

            This field is a member of `oneof`_ ``_service_lb_policy``.
        session_affinity (str):
            Type of session affinity to use. The default is NONE. Only
            NONE and HEADER_FIELD are supported when the backend service
            is referenced by a URL map that is bound to target gRPC
            proxy that has validateForProxyless field set to true. For
            more details, see: `Session
            Affinity <https://cloud.google.com/load-balancing/docs/backend-service#session_affinity>`__.
            sessionAffinity cannot be specified with haPolicy. Check the
            SessionAffinity enum for the list of possible values.

            This field is a member of `oneof`_ ``_session_affinity``.
        strong_session_affinity_cookie (google.cloud.compute_v1.types.BackendServiceHttpCookie):
            Describes the HTTP cookie used for stateful session
            affinity. This field is applicable and required if the
            sessionAffinity is set to STRONG_COOKIE_AFFINITY.

            This field is a member of `oneof`_ ``_strong_session_affinity_cookie``.
        subsetting (google.cloud.compute_v1.types.Subsetting):
            subsetting cannot be specified with haPolicy.

            This field is a member of `oneof`_ ``_subsetting``.
        timeout_sec (int):
            The backend service timeout has a different
            meaning depending on the type of load balancer.
            For more information see, Backend service
            settings. The default is 30 seconds. The full
            range of timeout values allowed goes from 1
            through 2,147,483,647 seconds. This value can be
            overridden in the PathMatcher configuration of
            the UrlMap that references this backend service.
            Not supported when the backend service is
            referenced by a URL map that is bound to target
            gRPC proxy that has validateForProxyless field
            set to true. Instead, use maxStreamDuration.

            This field is a member of `oneof`_ ``_timeout_sec``.
        used_by (MutableSequence[google.cloud.compute_v1.types.BackendServiceUsedBy]):
            [Output Only] List of resources referencing given backend
            service.
    """

    class CompressionMode(proto.Enum):
        r"""Compress text responses using Brotli or gzip compression,
        based on the client's Accept-Encoding header.

        Values:
            UNDEFINED_COMPRESSION_MODE (0):
                A value indicating that the enum field is not
                set.
            AUTOMATIC (165298699):
                Automatically uses the best compression based
                on the Accept-Encoding header sent by the
                client.
            DISABLED (516696700):
                Disables compression. Existing compressed
                responses cached by Cloud CDN will not be served
                to clients.
        """
        UNDEFINED_COMPRESSION_MODE = 0
        AUTOMATIC = 165298699
        DISABLED = 516696700

    class ExternalManagedMigrationState(proto.Enum):
        r"""Specifies the canary migration state. Possible values are PREPARE,
        TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration
        from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to
        PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the
        loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally,
        the TEST_BY_PERCENTAGE state can be used to migrate traffic by
        percentage using externalManagedMigrationTestingPercentage. Rolling
        back a migration requires the states to be set in reverse order. So
        changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the
        state to be set to TEST_ALL_TRAFFIC at the same time. Optionally,
        the TEST_BY_PERCENTAGE state can be used to migrate some traffic
        back to EXTERNAL or PREPARE can be used to migrate all traffic back
        to EXTERNAL.

        Values:
            UNDEFINED_EXTERNAL_MANAGED_MIGRATION_STATE (0):
                A value indicating that the enum field is not
                set.
            PREPARE (399612135):
                No description available.
            TEST_ALL_TRAFFIC (79728882):
                No description available.
            TEST_BY_PERCENTAGE (513738389):
                No description available.
        """
        UNDEFINED_EXTERNAL_MANAGED_MIGRATION_STATE = 0
        PREPARE = 399612135
        TEST_ALL_TRAFFIC = 79728882
        TEST_BY_PERCENTAGE = 513738389

    class IpAddressSelectionPolicy(proto.Enum):
        r"""Specifies a preference for traffic sent from the proxy to the
        backend (or from the client to the backend for proxyless gRPC). The
        possible values are: - IPV4_ONLY: Only send IPv4 traffic to the
        backends of the backend service (Instance Group, Managed Instance
        Group, Network Endpoint Group), regardless of traffic from the
        client to the proxy. Only IPv4 health checks are used to check the
        health of the backends. This is the default setting. - PREFER_IPV6:
        Prioritize the connection to the endpoint's IPv6 address over its
        IPv4 address (provided there is a healthy IPv6 address). -
        IPV6_ONLY: Only send IPv6 traffic to the backends of the backend
        service (Instance Group, Managed Instance Group, Network Endpoint
        Group), regardless of traffic from the client to the proxy. Only
        IPv6 health checks are used to check the health of the backends.
        This field is applicable to either: - Advanced global external
        Application Load Balancer (load balancing scheme EXTERNAL_MANAGED),
        - Regional external Application Load Balancer, - Internal proxy
        Network Load Balancer (load balancing scheme INTERNAL_MANAGED), -
        Regional internal Application Load Balancer (load balancing scheme
        INTERNAL_MANAGED), - Traffic Director with Envoy proxies and
        proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).

        Values:
            UNDEFINED_IP_ADDRESS_SELECTION_POLICY (0):
                A value indicating that the enum field is not
                set.
            IPV4_ONLY (22373798):
                Only send IPv4 traffic to the backends of the
                Backend Service (Instance Group, Managed
                Instance Group, Network Endpoint Group)
                regardless of traffic from the client to the
                proxy. Only IPv4 health-checks are used to check
                the health of the backends. This is the default
                setting.
            IPV6_ONLY (79632100):
                Only send IPv6 traffic to the backends of the
                Backend Service (Instance Group, Managed
                Instance Group, Network Endpoint Group)
                regardless of traffic from the client to the
                proxy. Only IPv6 health-checks are used to check
                the health of the backends.
            IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED (36210144):
                Unspecified IP address selection policy.
            PREFER_IPV6 (408601302):
                Prioritize the connection to the endpoints
                IPv6 address over its IPv4 address (provided
                there is a healthy IPv6 address).
        """
        UNDEFINED_IP_ADDRESS_SELECTION_POLICY = 0
        IPV4_ONLY = 22373798
        IPV6_ONLY = 79632100
        IP_ADDRESS_SELECTION_POLICY_UNSPECIFIED = 36210144
        PREFER_IPV6 = 408601302

    class LoadBalancingScheme(proto.Enum):
        r"""Specifies the load balancer type. A backend service created
        for one type of load balancer cannot be used with another. For
        more information, refer to Choosing a load balancer.

        Values:
            UNDEFINED_LOAD_BALANCING_SCHEME (0):
                A value indicating that the enum field is not
                set.
            EXTERNAL (35607499):
                Signifies that this will be used for classic
                Application Load Balancers, global external
                proxy Network Load Balancers, or external
                passthrough Network Load Balancers.
            EXTERNAL_MANAGED (512006923):
                Signifies that this will be used for global
                external Application Load Balancers, regional
                external Application Load Balancers, or regional
                external proxy Network Load Balancers.
            INTERNAL (279295677):
                Signifies that this will be used for internal
                passthrough Network Load Balancers.
            INTERNAL_MANAGED (37350397):
                Signifies that this will be used for internal
                Application Load Balancers.
            INTERNAL_SELF_MANAGED (236211150):
                Signifies that this will be used by Traffic
                Director.
            INVALID_LOAD_BALANCING_SCHEME (275352060):
                No description available.
        """
        UNDEFINED_LOAD_BALANCING_SCHEME = 0
        EXTERNAL = 35607499
        EXTERNAL_MANAGED = 512006923
        INTERNAL = 279295677
        INTERNAL_MANAGED = 37350397
        INTERNAL_SELF_MANAGED = 236211150
        INVALID_LOAD_BALANCING_SCHEME = 275352060

    class LocalityLbPolicy(proto.Enum):
        r"""The load balancing algorithm used within the scope of the locality.
        The possible values are: - ROUND_ROBIN: This is a simple policy in
        which each healthy backend is selected in round robin order. This is
        the default. - LEAST_REQUEST: An O(1) algorithm which selects two
        random healthy hosts and picks the host which has fewer active
        requests. - RING_HASH: The ring/modulo hash load balancer implements
        consistent hashing to backends. The algorithm has the property that
        the addition/removal of a host from a set of N hosts only affects
        1/N of the requests. - RANDOM: The load balancer selects a random
        healthy host. - ORIGINAL_DESTINATION: Backend host is selected based
        on the client connection metadata, i.e., connections are opened to
        the same address as the destination address of the incoming
        connection before the connection was redirected to the load
        balancer. - MAGLEV: used as a drop in replacement for the ring hash
        load balancer. Maglev is not as stable as ring hash but has faster
        table lookup build times and host selection times. For more
        information about Maglev, see
        https://ai.google/research/pubs/pub44824 This field is applicable to
        either: - A regional backend service with the service_protocol set
        to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to
        INTERNAL_MANAGED. - A global backend service with the
        load_balancing_scheme set to INTERNAL_SELF_MANAGED,
        INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not
        configured—that is, if session affinity remains at the default value
        of NONE—then the default value for localityLbPolicy is ROUND_ROBIN.
        If session affinity is set to a value other than NONE, then the
        default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and
        RING_HASH are supported when the backend service is referenced by a
        URL map that is bound to target gRPC proxy that has
        validateForProxyless field set to true. localityLbPolicy cannot be
        specified with haPolicy.

        Values:
            UNDEFINED_LOCALITY_LB_POLICY (0):
                A value indicating that the enum field is not
                set.
            INVALID_LB_POLICY (323318707):
                No description available.
            LEAST_REQUEST (46604921):
                An O(1) algorithm which selects two random
                healthy hosts and picks the host which has fewer
                active requests.
            MAGLEV (119180266):
                This algorithm implements consistent hashing
                to backends. Maglev can be used as a drop in
                replacement for the ring hash load balancer.
                Maglev is not as stable as ring hash but has
                faster table lookup build times and host
                selection times. For more information about
                Maglev, see
                https://ai.google/research/pubs/pub44824
            ORIGINAL_DESTINATION (166297216):
                Backend host is selected based on the client
                connection metadata, i.e., connections are
                opened to the same address as the destination
                address of the incoming connection before the
                connection was redirected to the load balancer.
            RANDOM (262527171):
                The load balancer selects a random healthy
                host.
            RING_HASH (432795069):
                The ring/modulo hash load balancer implements
                consistent hashing to backends. The algorithm
                has the property that the addition/removal of a
                host from a set of N hosts only affects 1/N of
                the requests.
            ROUND_ROBIN (153895801):
                This is a simple policy in which each healthy
                backend is selected in round robin order. This
                is the default.
            WEIGHTED_MAGLEV (254930962):
                Per-instance weighted Load Balancing via health check
                reported weights. If set, the Backend Service must configure
                a non legacy HTTP-based Health Check, and health check
                replies are expected to contain non-standard HTTP response
                header field X-Load-Balancing-Endpoint-Weight to specify the
                per-instance weights. If set, Load Balancing is weighted
                based on the per-instance weights reported in the last
                processed health check replies, as long as every instance
                either reported a valid weight or had UNAVAILABLE_WEIGHT.
                Otherwise, Load Balancing remains equal-weight. This option
                is only supported in Network Load Balancing.
            WEIGHTED_ROUND_ROBIN (5584977):
                Per-endpoint weighted round-robin Load Balancing using
                weights computed from Backend reported Custom Metrics. If
                set, the Backend Service responses are expected to contain
                non-standard HTTP response header field
                X-Endpoint-Load-Metrics. The reported metrics to use for
                computing the weights are specified via the
                backends[].customMetrics fields.
        """
        UNDEFINED_LOCALITY_LB_POLICY = 0
        INVALID_LB_POLICY = 323318707
        LEAST_REQUEST = 46604921
        MAGLEV = 119180266
        ORIGINAL_DESTINATION = 166297216
        RANDOM = 262527171
        RING_HASH = 432795069
        ROUND_ROBIN = 153895801
        WEIGHTED_MAGLEV = 254930962
        WEIGHTED_ROUND_ROBIN = 5584977

    class Protocol(proto.Enum):
        r"""The protocol this BackendService uses to communicate with
        backends. Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP
        or GRPC. depending on the chosen load balancer or Traffic
        Director configuration. Refer to the documentation for the load
        balancers or for Traffic Director for more information. Must be
        set to GRPC when the backend service is referenced by a URL map
        that is bound to target gRPC proxy.

        Values:
            UNDEFINED_PROTOCOL (0):
                A value indicating that the enum field is not
                set.
            GRPC (2196510):
                gRPC (available for Traffic Director).
            HTTP (2228360):
                No description available.
            HTTP2 (69079210):
                HTTP/2 with SSL.
            HTTPS (69079243):
                No description available.
            SSL (82412):
                TCP proxying with SSL.
            TCP (82881):
                TCP proxying or TCP pass-through.
            UDP (83873):
                UDP.
            UNSPECIFIED (526786327):
                If a Backend Service has UNSPECIFIED as its
                protocol, it can be used with any L3/L4
                Forwarding Rules.
        """
        UNDEFINED_PROTOCOL = 0
        GRPC = 2196510
        HTTP = 2228360
        HTTP2 = 69079210
        HTTPS = 69079243
        SSL = 82412
        TCP = 82881
        UDP = 83873
        UNSPECIFIED = 526786327

    class SessionAffinity(proto.Enum):
        r"""Type of session affinity to use. The default is NONE. Only NONE and
        HEADER_FIELD are supported when the backend service is referenced by
        a URL map that is bound to target gRPC proxy that has
        validateForProxyless field set to true. For more details, see:
        `Session
        Affinity <https://cloud.google.com/load-balancing/docs/backend-service#session_affinity>`__.
        sessionAffinity cannot be specified with haPolicy.

        Values:
            UNDEFINED_SESSION_AFFINITY (0):
                A value indicating that the enum field is not
                set.
            CLIENT_IP (345665051):
                2-tuple hash on packet's source and
                destination IP addresses. Connections from the
                same source IP address to the same destination
                IP address will be served by the same backend VM
                while that VM remains healthy.
            CLIENT_IP_NO_DESTINATION (106122516):
                1-tuple hash only on packet's source IP
                address. Connections from the same source IP
                address will be served by the same backend VM
                while that VM remains healthy. This option can
                only be used for Internal TCP/UDP Load
                Balancing.
            CLIENT_IP_PORT_PROTO (221722926):
                5-tuple hash on packet's source and
                destination IP addresses, IP protocol, and
                source and destination ports. Connections for
                the same IP protocol from the same source IP
                address and port to the same destination IP
                address and port will be served by the same
                backend VM while that VM remains healthy. This
                option cannot be used for HTTP(S) load
                balancing.
            CLIENT_IP_PROTO (25322148):
                3-tuple hash on packet's source and
                destination IP addresses, and IP protocol.
                Connections for the same IP protocol from the
                same source IP address to the same destination
                IP address will be served by the same backend VM
                while that VM remains healthy. This option
                cannot be used for HTTP(S) load balancing.
            GENERATED_COOKIE (370321204):
                Hash based on a cookie generated by the L7
                loadbalancer. Only valid for HTTP(S) load
                balancing.
            HEADER_FIELD (200737960):
                The hash is based on a user specified header
                field.
            HTTP_COOKIE (494981627):
                The hash is based on a user provided cookie.
            NONE (2402104):
                No session affinity. Connections from the
                same client IP may go to any instance in the
                pool.
            STRONG_COOKIE_AFFINITY (438628091):
                Strong cookie-based affinity. Connections
                bearing the same cookie will be served by the
                same backend VM while that VM remains healthy,
                as long as the cookie has not expired.
        """
        UNDEFINED_SESSION_AFFINITY = 0
        CLIENT_IP = 345665051
        CLIENT_IP_NO_DESTINATION = 106122516
        CLIENT_IP_PORT_PROTO = 221722926
        CLIENT_IP_PROTO = 25322148
        GENERATED_COOKIE = 370321204
        HEADER_FIELD = 200737960
        HTTP_COOKIE = 494981627
        NONE = 2402104
        STRONG_COOKIE_AFFINITY = 438628091

    affinity_cookie_ttl_sec: int = proto.Field(
        proto.INT32,
        number=369996954,
        optional=True,
    )
    backends: MutableSequence["Backend"] = proto.RepeatedField(
        proto.MESSAGE,
        number=510839903,
        message="Backend",
    )
    cdn_policy: "BackendServiceCdnPolicy" = proto.Field(
        proto.MESSAGE,
        number=213976452,
        optional=True,
        message="BackendServiceCdnPolicy",
    )
    circuit_breakers: "CircuitBreakers" = proto.Field(
        proto.MESSAGE,
        number=421340061,
        optional=True,
        message="CircuitBreakers",
    )
    compression_mode: str = proto.Field(
        proto.STRING,
        number=95520988,
        optional=True,
    )
    connection_draining: "ConnectionDraining" = proto.Field(
        proto.MESSAGE,
        number=461096747,
        optional=True,
        message="ConnectionDraining",
    )
    connection_tracking_policy: "BackendServiceConnectionTrackingPolicy" = proto.Field(
        proto.MESSAGE,
        number=143994969,
        optional=True,
        message="BackendServiceConnectionTrackingPolicy",
    )
    consistent_hash: "ConsistentHashLoadBalancerSettings" = proto.Field(
        proto.MESSAGE,
        number=905883,
        optional=True,
        message="ConsistentHashLoadBalancerSettings",
    )
    creation_timestamp: str = proto.Field(
        proto.STRING,
        number=30525366,
        optional=True,
    )
    custom_metrics: MutableSequence["BackendServiceCustomMetric"] = proto.RepeatedField(
        proto.MESSAGE,
        number=429453813,
        message="BackendServiceCustomMetric",
    )
    custom_request_headers: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=27977992,
    )
    custom_response_headers: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=387539094,
    )
    description: str = proto.Field(
        proto.STRING,
        number=422937596,
        optional=True,
    )
    edge_security_policy: str = proto.Field(
        proto.STRING,
        number=41036943,
        optional=True,
    )
    enable_c_d_n: bool = proto.Field(
        proto.BOOL,
        number=250733499,
        optional=True,
    )
    external_managed_migration_state: str = proto.Field(
        proto.STRING,
        number=66947020,
        optional=True,
    )
    external_managed_migration_testing_percentage: float = proto.Field(
        proto.FLOAT,
        number=507232462,
        optional=True,
    )
    failover_policy: "BackendServiceFailoverPolicy" = proto.Field(
        proto.MESSAGE,
        number=105658655,
        optional=True,
        message="BackendServiceFailoverPolicy",
    )
    fingerprint: str = proto.Field(
        proto.STRING,
        number=234678500,
        optional=True,
    )
    ha_policy: "BackendServiceHAPolicy" = proto.Field(
        proto.MESSAGE,
        number=519879480,
        optional=True,
        message="BackendServiceHAPolicy",
    )
    health_checks: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=448370606,
    )
    iap: "BackendServiceIAP" = proto.Field(
        proto.MESSAGE,
        number=104024,
        optional=True,
        message="BackendServiceIAP",
    )
    id: int = proto.Field(
        proto.UINT64,
        number=3355,
        optional=True,
    )
    ip_address_selection_policy: str = proto.Field(
        proto.STRING,
        number=77600840,
        optional=True,
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    load_balancing_scheme: str = proto.Field(
        proto.STRING,
        number=363890244,
        optional=True,
    )
    locality_lb_policies: MutableSequence[
        "BackendServiceLocalityLoadBalancingPolicyConfig"
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=140982557,
        message="BackendServiceLocalityLoadBalancingPolicyConfig",
    )
    locality_lb_policy: str = proto.Field(
        proto.STRING,
        number=131431487,
        optional=True,
    )
    log_config: "BackendServiceLogConfig" = proto.Field(
        proto.MESSAGE,
        number=351299741,
        optional=True,
        message="BackendServiceLogConfig",
    )
    max_stream_duration: "Duration" = proto.Field(
        proto.MESSAGE,
        number=61428376,
        optional=True,
        message="Duration",
    )
    metadatas: MutableMapping[str, str] = proto.MapField(
        proto.STRING,
        proto.STRING,
        number=8514340,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )
    network: str = proto.Field(
        proto.STRING,
        number=232872494,
        optional=True,
    )
    outlier_detection: "OutlierDetection" = proto.Field(
        proto.MESSAGE,
        number=354625086,
        optional=True,
        message="OutlierDetection",
    )
    port: int = proto.Field(
        proto.INT32,
        number=3446913,
        optional=True,
    )
    port_name: str = proto.Field(
        proto.STRING,
        number=41534345,
        optional=True,
    )
    protocol: str = proto.Field(
        proto.STRING,
        number=84577944,
        optional=True,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
        optional=True,
    )
    security_policy: str = proto.Field(
        proto.STRING,
        number=171082513,
        optional=True,
    )
    security_settings: "SecuritySettings" = proto.Field(
        proto.MESSAGE,
        number=478649922,
        optional=True,
        message="SecuritySettings",
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    service_bindings: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=133581016,
    )
    service_lb_policy: str = proto.Field(
        proto.STRING,
        number=94848785,
        optional=True,
    )
    session_affinity: str = proto.Field(
        proto.STRING,
        number=463888561,
        optional=True,
    )
    strong_session_affinity_cookie: "BackendServiceHttpCookie" = proto.Field(
        proto.MESSAGE,
        number=238195722,
        optional=True,
        message="BackendServiceHttpCookie",
    )
    subsetting: "Subsetting" = proto.Field(
        proto.MESSAGE,
        number=450283536,
        optional=True,
        message="Subsetting",
    )
    timeout_sec: int = proto.Field(
        proto.INT32,
        number=79994995,
        optional=True,
    )
    used_by: MutableSequence["BackendServiceUsedBy"] = proto.RepeatedField(
        proto.MESSAGE,
        number=389320729,
        message="BackendServiceUsedBy",
    )


class BackendServiceAggregatedList(proto.Message):
    r"""Contains a list of BackendServicesScopedList.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableMapping[str, google.cloud.compute_v1.types.BackendServicesScopedList]):
            A list of BackendServicesScopedList
            resources.
        kind (str):
            Type of resource.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (MutableSequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableMapping[str, "BackendServicesScopedList"] = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="BackendServicesScopedList",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    unreachables: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=243372063,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class BackendServiceCdnPolicy(proto.Message):
    r"""Message containing Cloud CDN configuration for a backend
    service.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        bypass_cache_on_request_headers (MutableSequence[google.cloud.compute_v1.types.BackendServiceCdnPolicyBypassCacheOnRequestHeader]):
            Bypass the cache when the specified request
            headers are matched - e.g. Pragma or
            Authorization headers. Up to 5 headers can be
            specified. The cache is bypassed for all
            cdnPolicy.cacheMode settings.
        cache_key_policy (google.cloud.compute_v1.types.CacheKeyPolicy):
            The CacheKeyPolicy for this CdnPolicy.

            This field is a member of `oneof`_ ``_cache_key_policy``.
        cache_mode (str):
            Specifies the cache setting for all responses from this
            backend. The possible values are: USE_ORIGIN_HEADERS
            Requires the origin to set valid caching headers to cache
            content. Responses without these headers will not be cached
            at Google's edge, and will require a full trip to the origin
            on every request, potentially impacting performance and
            increasing load on the origin server. FORCE_CACHE_ALL Cache
            all content, ignoring any "private", "no-store" or
            "no-cache" directives in Cache-Control response headers.
            Warning: this may result in Cloud CDN caching private,
            per-user (user identifiable) content. CACHE_ALL_STATIC
            Automatically cache static content, including common image
            formats, media (video and audio), and web assets (JavaScript
            and CSS). Requests and responses that are marked as
            uncacheable, as well as dynamic content (including HTML),
            will not be cached. If no value is provided for
            cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC. Check
            the CacheMode enum for the list of possible values.

            This field is a member of `oneof`_ ``_cache_mode``.
        client_ttl (int):
            Specifies a separate client (e.g. browser client) maximum
            TTL. This is used to clamp the max-age (or Expires) value
            sent to the client. With FORCE_CACHE_ALL, the lesser of
            client_ttl and default_ttl is used for the response max-age
            directive, along with a "public" directive. For cacheable
            content in CACHE_ALL_STATIC mode, client_ttl clamps the
            max-age from the origin (if specified), or else sets the
            response max-age directive to the lesser of the client_ttl
            and default_ttl, and also ensures a "public" cache-control
            directive is present. If a client TTL is not specified, a
            default value (1 hour) will be used. The maximum allowed
            value is 31,622,400s (1 year).

            This field is a member of `oneof`_ ``_client_ttl``.
        default_ttl (int):
            Specifies the default TTL for cached content served by this
            origin for responses that do not have an existing valid TTL
            (max-age or s-maxage). Setting a TTL of "0" means "always
            revalidate". The value of defaultTTL cannot be set to a
            value greater than that of maxTTL, but can be equal. When
            the cacheMode is set to FORCE_CACHE_ALL, the defaultTTL will
            overwrite the TTL set in all responses. The maximum allowed
            value is 31,622,400s (1 year), noting that infrequently
            accessed objects may be evicted from the cache before the
            defined TTL.

            This field is a member of `oneof`_ ``_default_ttl``.
        max_ttl (int):
            Specifies the maximum allowed TTL for cached
            content served by this origin. Cache directives
            that attempt to set a max-age or s-maxage higher
            than this, or an Expires header more than maxTTL
            seconds in the future will be capped at the
            value of maxTTL, as if it were the value of an
            s-maxage Cache-Control directive. Headers sent
            to the client will not be modified. Setting a
            TTL of "0" means "always revalidate". The
            maximum allowed value is 31,622,400s (1 year),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.

            This field is a member of `oneof`_ ``_max_ttl``.
        negative_caching (bool):
            Negative caching allows per-status code TTLs to be set, in
            order to apply fine-grained caching for common errors or
            redirects. This can reduce the load on your origin and
            improve end-user experience by reducing response latency.
            When the cache mode is set to CACHE_ALL_STATIC or
            USE_ORIGIN_HEADERS, negative caching applies to responses
            with the specified response code that lack any
            Cache-Control, Expires, or Pragma: no-cache directives. When
            the cache mode is set to FORCE_CACHE_ALL, negative caching
            applies to all responses with the specified response code,
            and override any caching headers. By default, Cloud CDN will
            apply the following default TTLs to these status codes: HTTP
            300 (Multiple Choice), 301, 308 (Permanent Redirects): 10m
            HTTP 404 (Not Found), 410 (Gone), 451 (Unavailable For Legal
            Reasons): 120s HTTP 405 (Method Not Found), 421 (Misdirected
            Request), 501 (Not Implemented): 60s. These defaults can be
            overridden in negative_caching_policy.

            This field is a member of `oneof`_ ``_negative_caching``.
        negative_caching_policy (MutableSequence[google.cloud.compute_v1.types.BackendServiceCdnPolicyNegativeCachingPolicy]):
            Sets a cache TTL for the specified HTTP status code.
            negative_caching must be enabled to configure
            negative_caching_policy. Omitting the policy and leaving
            negative_caching enabled will use Cloud CDN's default cache
            TTLs. Note that when specifying an explicit
            negative_caching_policy, you should take care to specify a
            cache TTL for all response codes that you wish to cache.
            Cloud CDN will not apply any default negative caching when a
            policy exists.
        request_coalescing (bool):
            If true then Cloud CDN will combine multiple
            concurrent cache fill requests into a small
            number of requests to the origin.

            This field is a member of `oneof`_ ``_request_coalescing``.
        serve_while_stale (int):
            Serve existing content from the cache (if
            available) when revalidating content with the
            origin, or when an error is encountered when
            refreshing the cache. This setting defines the
            default "max-stale" duration for any cached
            responses that do not specify a max-stale
            directive. Stale responses that exceed the TTL
            configured here will not be served. The default
            limit (max-stale) is 86400s (1 day), which will
            allow stale content to be served up to this
            limit beyond the max-age (or s-maxage) of a
            cached response. The maximum allowed value is
            604800 (1 week). Set this to zero (0) to disable
            serve-while-stale.

            This field is a member of `oneof`_ ``_serve_while_stale``.
        signed_url_cache_max_age_sec (int):
            Maximum number of seconds the response to a signed URL
            request will be considered fresh. After this time period,
            the response will be revalidated before being served.
            Defaults to 1hr (3600s). When serving responses to signed
            URL requests, Cloud CDN will internally behave as though all
            responses from this backend had a "Cache-Control: public,
            max-age=[TTL]" header, regardless of any existing
            Cache-Control header. The actual headers served in responses
            will not be altered.

            This field is a member of `oneof`_ ``_signed_url_cache_max_age_sec``.
        signed_url_key_names (MutableSequence[str]):
            [Output Only] Names of the keys for signing request URLs.
    """

    class CacheMode(proto.Enum):
        r"""Specifies the cache setting for all responses from this backend. The
        possible values are: USE_ORIGIN_HEADERS Requires the origin to set
        valid caching headers to cache content. Responses without these
        headers will not be cached at Google's edge, and will require a full
        trip to the origin on every request, potentially impacting
        performance and increasing load on the origin server.
        FORCE_CACHE_ALL Cache all content, ignoring any "private",
        "no-store" or "no-cache" directives in Cache-Control response
        headers. Warning: this may result in Cloud CDN caching private,
        per-user (user identifiable) content. CACHE_ALL_STATIC Automatically
        cache static content, including common image formats, media (video
        and audio), and web assets (JavaScript and CSS). Requests and
        responses that are marked as uncacheable, as well as dynamic content
        (including HTML), will not be cached. If no value is provided for
        cdnPolicy.cacheMode, it defaults to CACHE_ALL_STATIC.

        Values:
            UNDEFINED_CACHE_MODE (0):
                A value indicating that the enum field is not
                set.
            CACHE_ALL_STATIC (355027945):
                Automatically cache static content, including
                common image formats, media (video and audio),
                and web assets (JavaScript and CSS). Requests
                and responses that are marked as uncacheable, as
                well as dynamic content (including HTML), will
                not be cached.
            FORCE_CACHE_ALL (486026928):
                Cache all content, ignoring any "private",
                "no-store" or "no-cache" directives in
                Cache-Control response headers. Warning: this
                may result in Cloud CDN caching private,
                per-user (user identifiable) content.
            INVALID_CACHE_MODE (381295560):
                No description available.
            USE_ORIGIN_HEADERS (55380261):
                Requires the origin to set valid caching
                headers to cache content. Responses without
                these headers will not be cached at Google's
                edge, and will require a full trip to the origin
                on every request, potentially impacting
                performance and increasing load on the origin
                server.
        """
        UNDEFINED_CACHE_MODE = 0
        CACHE_ALL_STATIC = 355027945
        FORCE_CACHE_ALL = 486026928
        INVALID_CACHE_MODE = 381295560
        USE_ORIGIN_HEADERS = 55380261

    bypass_cache_on_request_headers: MutableSequence[
        "BackendServiceCdnPolicyBypassCacheOnRequestHeader"
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=486203082,
        message="BackendServiceCdnPolicyBypassCacheOnRequestHeader",
    )
    cache_key_policy: "CacheKeyPolicy" = proto.Field(
        proto.MESSAGE,
        number=159263727,
        optional=True,
        message="CacheKeyPolicy",
    )
    cache_mode: str = proto.Field(
        proto.STRING,
        number=28877888,
        optional=True,
    )
    client_ttl: int = proto.Field(
        proto.INT32,
        number=29034360,
        optional=True,
    )
    default_ttl: int = proto.Field(
        proto.INT32,
        number=100253422,
        optional=True,
    )
    max_ttl: int = proto.Field(
        proto.INT32,
        number=307578001,
        optional=True,
    )
    negative_caching: bool = proto.Field(
        proto.BOOL,
        number=336110005,
        optional=True,
    )
    negative_caching_policy: MutableSequence[
        "BackendServiceCdnPolicyNegativeCachingPolicy"
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=155359996,
        message="BackendServiceCdnPolicyNegativeCachingPolicy",
    )
    request_coalescing: bool = proto.Field(
        proto.BOOL,
        number=532808276,
        optional=True,
    )
    serve_while_stale: int = proto.Field(
        proto.INT32,
        number=236682203,
        optional=True,
    )
    signed_url_cache_max_age_sec: int = proto.Field(
        proto.INT64,
        number=269374534,
        optional=True,
    )
    signed_url_key_names: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=371848885,
    )


class BackendServiceCdnPolicyBypassCacheOnRequestHeader(proto.Message):
    r"""Bypass the cache when the specified request headers are present,
    e.g. Pragma or Authorization headers. Values are case insensitive.
    The presence of such a header overrides the cache_mode setting.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        header_name (str):
            The header field name to match on when
            bypassing cache. Values are case-insensitive.

            This field is a member of `oneof`_ ``_header_name``.
    """

    header_name: str = proto.Field(
        proto.STRING,
        number=110223613,
        optional=True,
    )


class BackendServiceCdnPolicyNegativeCachingPolicy(proto.Message):
    r"""Specify CDN TTLs for response error codes.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        code (int):
            The HTTP status code to define a TTL against.
            Only HTTP status codes 300, 301, 302, 307, 308,
            404, 405, 410, 421, 451 and 501 are can be
            specified as values, and you cannot specify a
            status code more than once.

            This field is a member of `oneof`_ ``_code``.
        ttl (int):
            The TTL (in seconds) for which to cache
            responses with the corresponding status code.
            The maximum allowed value is 1800s (30 minutes),
            noting that infrequently accessed objects may be
            evicted from the cache before the defined TTL.

            This field is a member of `oneof`_ ``_ttl``.
    """

    code: int = proto.Field(
        proto.INT32,
        number=3059181,
        optional=True,
    )
    ttl: int = proto.Field(
        proto.INT32,
        number=115180,
        optional=True,
    )


class BackendServiceConnectionTrackingPolicy(proto.Message):
    r"""Connection Tracking configuration for this BackendService.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        connection_persistence_on_unhealthy_backends (str):
            Specifies connection persistence when backends are
            unhealthy. The default value is DEFAULT_FOR_PROTOCOL. If set
            to DEFAULT_FOR_PROTOCOL, the existing connections persist on
            unhealthy backends only for connection-oriented protocols
            (TCP and SCTP) and only if the Tracking Mode is
            PER_CONNECTION (default tracking mode) or the Session
            Affinity is configured for 5-tuple. They do not persist for
            UDP. If set to NEVER_PERSIST, after a backend becomes
            unhealthy, the existing connections on the unhealthy backend
            are never persisted on the unhealthy backend. They are
            always diverted to newly selected healthy backends (unless
            all backends are unhealthy). If set to ALWAYS_PERSIST,
            existing connections always persist on unhealthy backends
            regardless of protocol and session affinity. It is generally
            not recommended to use this mode overriding the default. For
            more details, see `Connection Persistence for Network Load
            Balancing <https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence>`__
            and `Connection Persistence for Internal TCP/UDP Load
            Balancing <https://cloud.google.com/load-balancing/docs/internal#connection-persistence>`__.
            Check the ConnectionPersistenceOnUnhealthyBackends enum for
            the list of possible values.

            This field is a member of `oneof`_ ``_connection_persistence_on_unhealthy_backends``.
        enable_strong_affinity (bool):
            Enable Strong Session Affinity for external
            passthrough Network Load Balancers. This option
            is not available publicly.

            This field is a member of `oneof`_ ``_enable_strong_affinity``.
        idle_timeout_sec (int):
            Specifies how long to keep a Connection Tracking entry while
            there is no matching traffic (in seconds). For internal
            passthrough Network Load Balancers: - The minimum (default)
            is 10 minutes and the maximum is 16 hours. - It can be set
            only if Connection Tracking is less than 5-tuple (i.e.
            Session Affinity is CLIENT_IP_NO_DESTINATION, CLIENT_IP or
            CLIENT_IP_PROTO, and Tracking Mode is PER_SESSION). For
            external passthrough Network Load Balancers the default is
            60 seconds. This option is not available publicly.

            This field is a member of `oneof`_ ``_idle_timeout_sec``.
        tracking_mode (str):
            Specifies the key used for connection tracking. There are
            two options: - PER_CONNECTION: This is the default mode. The
            Connection Tracking is performed as per the Connection Key
            (default Hash Method) for the specific protocol. -
            PER_SESSION: The Connection Tracking is performed as per the
            configured Session Affinity. It matches the configured
            Session Affinity. For more details, see `Tracking Mode for
            Network Load
            Balancing <https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode>`__
            and `Tracking Mode for Internal TCP/UDP Load
            Balancing <https://cloud.google.com/load-balancing/docs/internal#tracking-mode>`__.
            Check the TrackingMode enum for the list of possible values.

            This field is a member of `oneof`_ ``_tracking_mode``.
    """

    class ConnectionPersistenceOnUnhealthyBackends(proto.Enum):
        r"""Specifies connection persistence when backends are unhealthy. The
        default value is DEFAULT_FOR_PROTOCOL. If set to
        DEFAULT_FOR_PROTOCOL, the existing connections persist on unhealthy
        backends only for connection-oriented protocols (TCP and SCTP) and
        only if the Tracking Mode is PER_CONNECTION (default tracking mode)
        or the Session Affinity is configured for 5-tuple. They do not
        persist for UDP. If set to NEVER_PERSIST, after a backend becomes
        unhealthy, the existing connections on the unhealthy backend are
        never persisted on the unhealthy backend. They are always diverted
        to newly selected healthy backends (unless all backends are
        unhealthy). If set to ALWAYS_PERSIST, existing connections always
        persist on unhealthy backends regardless of protocol and session
        affinity. It is generally not recommended to use this mode
        overriding the default. For more details, see `Connection
        Persistence for Network Load
        Balancing <https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#connection-persistence>`__
        and `Connection Persistence for Internal TCP/UDP Load
        Balancing <https://cloud.google.com/load-balancing/docs/internal#connection-persistence>`__.

        Values:
            UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS (0):
                A value indicating that the enum field is not
                set.
            ALWAYS_PERSIST (38400900):
                No description available.
            DEFAULT_FOR_PROTOCOL (145265356):
                No description available.
            NEVER_PERSIST (138646241):
                No description available.
        """
        UNDEFINED_CONNECTION_PERSISTENCE_ON_UNHEALTHY_BACKENDS = 0
        ALWAYS_PERSIST = 38400900
        DEFAULT_FOR_PROTOCOL = 145265356
        NEVER_PERSIST = 138646241

    class TrackingMode(proto.Enum):
        r"""Specifies the key used for connection tracking. There are two
        options: - PER_CONNECTION: This is the default mode. The Connection
        Tracking is performed as per the Connection Key (default Hash
        Method) for the specific protocol. - PER_SESSION: The Connection
        Tracking is performed as per the configured Session Affinity. It
        matches the configured Session Affinity. For more details, see
        `Tracking Mode for Network Load
        Balancing <https://cloud.google.com/load-balancing/docs/network/networklb-backend-service#tracking-mode>`__
        and `Tracking Mode for Internal TCP/UDP Load
        Balancing <https://cloud.google.com/load-balancing/docs/internal#tracking-mode>`__.

        Values:
            UNDEFINED_TRACKING_MODE (0):
                A value indicating that the enum field is not
                set.
            INVALID_TRACKING_MODE (49234371):
                No description available.
            PER_CONNECTION (85162848):
                No description available.
            PER_SESSION (182099252):
                No description available.
        """
        UNDEFINED_TRACKING_MODE = 0
        INVALID_TRACKING_MODE = 49234371
        PER_CONNECTION = 85162848
        PER_SESSION = 182099252

    connection_persistence_on_unhealthy_backends: str = proto.Field(
        proto.STRING,
        number=152439033,
        optional=True,
    )
    enable_strong_affinity: bool = proto.Field(
        proto.BOOL,
        number=24539924,
        optional=True,
    )
    idle_timeout_sec: int = proto.Field(
        proto.INT32,
        number=24977544,
        optional=True,
    )
    tracking_mode: str = proto.Field(
        proto.STRING,
        number=127757867,
        optional=True,
    )


class BackendServiceCustomMetric(proto.Message):
    r"""Custom Metrics are used for WEIGHTED_ROUND_ROBIN locality_lb_policy.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        dry_run (bool):
            If true, the metric data is not used for load
            balancing.

            This field is a member of `oneof`_ ``_dry_run``.
        name (str):
            Name of a custom utilization signal. The name must be 1-64
            characters long and match the regular expression
            `a-z <[-_.a-z0-9]*[a-z0-9]>`__? which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, period, underscore, lowercase
            letter, or digit, except the last character, which cannot be
            a dash, period, or underscore. For usage guidelines, see
            Custom Metrics balancing mode. This field can only be used
            for a global or regional backend service with the
            loadBalancingScheme set to EXTERNAL_MANAGED,
            INTERNAL_MANAGED INTERNAL_SELF_MANAGED.

            This field is a member of `oneof`_ ``_name``.
    """

    dry_run: bool = proto.Field(
        proto.BOOL,
        number=323854839,
        optional=True,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )


class BackendServiceFailoverPolicy(proto.Message):
    r"""For load balancers that have configurable failover: `Internal
    passthrough Network Load
    Balancers <https://cloud.google.com/load-balancing/docs/internal/failover-overview>`__
    and `external passthrough Network Load
    Balancers <https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview>`__.
    On failover or failback, this field indicates whether connection
    draining will be honored. Google Cloud has a fixed connection
    draining timeout of 10 minutes. A setting of true terminates
    existing TCP connections to the active pool during failover and
    failback, immediately draining traffic. A setting of false allows
    existing TCP connections to persist, even on VMs no longer in the
    active pool, for up to the duration of the connection draining
    timeout (10 minutes).


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        disable_connection_drain_on_failover (bool):
            This can be set to true only if the protocol
            is TCP. The default is false.

            This field is a member of `oneof`_ ``_disable_connection_drain_on_failover``.
        drop_traffic_if_unhealthy (bool):
            If set to true, connections to the load balancer are dropped
            when all primary and all backup backend VMs are unhealthy.If
            set to false, connections are distributed among all primary
            VMs when all primary and all backup backend VMs are
            unhealthy. For load balancers that have configurable
            failover: `Internal passthrough Network Load
            Balancers <https://cloud.google.com/load-balancing/docs/internal/failover-overview>`__
            and `external passthrough Network Load
            Balancers <https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview>`__.
            The default is false.

            This field is a member of `oneof`_ ``_drop_traffic_if_unhealthy``.
        failover_ratio (float):
            The value of the field must be in the range [0, 1]. If the
            value is 0, the load balancer performs a failover when the
            number of healthy primary VMs equals zero. For all other
            values, the load balancer performs a failover when the total
            number of healthy primary VMs is less than this ratio. For
            load balancers that have configurable failover: `Internal
            TCP/UDP Load
            Balancing <https://cloud.google.com/load-balancing/docs/internal/failover-overview>`__
            and `external TCP/UDP Load
            Balancing <https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview>`__.

            This field is a member of `oneof`_ ``_failover_ratio``.
    """

    disable_connection_drain_on_failover: bool = proto.Field(
        proto.BOOL,
        number=182150753,
        optional=True,
    )
    drop_traffic_if_unhealthy: bool = proto.Field(
        proto.BOOL,
        number=112289428,
        optional=True,
    )
    failover_ratio: float = proto.Field(
        proto.FLOAT,
        number=212667006,
        optional=True,
    )


class BackendServiceGroupHealth(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        annotations (MutableMapping[str, str]):
            Metadata defined as annotations on the
            network endpoint group.
        health_status (MutableSequence[google.cloud.compute_v1.types.HealthStatus]):
            Health state of the backend instances or
            endpoints in requested instance or network
            endpoint group, determined based on configured
            health checks.
        kind (str):
            [Output Only] Type of resource. Always
            compute#backendServiceGroupHealth for the health of backend
            services.

            This field is a member of `oneof`_ ``_kind``.
    """

    annotations: MutableMapping[str, str] = proto.MapField(
        proto.STRING,
        proto.STRING,
        number=112032548,
    )
    health_status: MutableSequence["HealthStatus"] = proto.RepeatedField(
        proto.MESSAGE,
        number=380545845,
        message="HealthStatus",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )


class BackendServiceHAPolicy(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        fast_i_p_move (str):
            Specifies whether fast IP move is enabled, and if so, the
            mechanism to achieve it. Supported values are: - DISABLED:
            Fast IP Move is disabled. You can only use the
            haPolicy.leader API to update the leader. - >GARP_RA:
            Provides a method to very quickly define a new network
            endpoint as the leader. This method is faster than updating
            the leader using the haPolicy.leader API. Fast IP move works
            as follows: The VM hosting the network endpoint that should
            become the new leader sends either a Gratuitous ARP (GARP)
            packet (IPv4) or an ICMPv6 Router Advertisement(RA) packet
            (IPv6). Google Cloud immediately but temporarily associates
            the forwarding rule IP address with that VM, and both new
            and in-flight packets are quickly delivered to that VM. Note
            the important properties of the Fast IP Move functionality:
            - The GARP/RA-initiated re-routing stays active for
            approximately 20 minutes. After triggering fast failover,
            you must also appropriately set the haPolicy.leader. - The
            new leader instance should continue to send GARP/RA packets
            periodically every 10 seconds until at least 10 minutes
            after updating the haPolicy.leader (but stop immediately if
            it is no longer the leader). - After triggering a fast
            failover, we recommend that you wait at least 3 seconds
            before sending another GARP/RA packet from a different VM
            instance to avoid race conditions. - Don't send GARP/RA
            packets from different VM instances at the same time. If
            multiple instances continue to send GARP/RA packets, traffic
            might be routed to different destinations in an alternating
            order. This condition ceases when a single instance issues a
            GARP/RA packet. - The GARP/RA request always takes priority
            over the leader API. Using the haPolicy.leader API to change
            the leader to a different instance will have no effect until
            the GARP/RA request becomes inactive. - The GARP/RA packets
            should follow the GARP/RA Packet Specifications.. - When
            multiple forwarding rules refer to a regional backend
            service, you need only send a GARP or RA packet for a single
            forwarding rule virtual IP. The virtual IPs for all
            forwarding rules targeting the same backend service will
            also be moved to the sender of the GARP or RA packet. The
            following are the Fast IP Move limitations (that is, when
            fastIPMove is not DISABLED): - Multiple forwarding rules
            cannot use the same IP address if one of them refers to a
            regional backend service with fastIPMove. - The regional
            backend service must set the network field, and all NEGs
            must belong to that network. However, individual NEGs can
            belong to different subnetworks of that network. - The
            maximum number of network endpoints across all backends of a
            backend service with fastIPMove is 64. - The maximum number
            of backend services with fastIPMove that can have the same
            network endpoint attached to one of its backends is 64. -
            The maximum number of backend services with fastIPMove in a
            VPC in a region is 64. - The network endpoints that are
            attached to a backend of a backend service with fastIPMove
            cannot resolve to Gen3+ machines for IPv6. - Traffic
            directed to the leader by a static route next hop will not
            be redirected to a new leader by fast failover. Such traffic
            will only be redirected once an haPolicy.leader update has
            taken effect. Only traffic to the forwarding rule's virtual
            IP will be redirected to a new leader by fast failover.
            haPolicy.fastIPMove can be set only at backend service
            creation time. Once set, it cannot be updated. By default,
            fastIpMove is set to DISABLED. Check the FastIPMove enum for
            the list of possible values.

            This field is a member of `oneof`_ ``_fast_i_p_move``.
    """

    class FastIPMove(proto.Enum):
        r"""Specifies whether fast IP move is enabled, and if so, the mechanism
        to achieve it. Supported values are: - DISABLED: Fast IP Move is
        disabled. You can only use the haPolicy.leader API to update the
        leader. - >GARP_RA: Provides a method to very quickly define a new
        network endpoint as the leader. This method is faster than updating
        the leader using the haPolicy.leader API. Fast IP move works as
        follows: The VM hosting the network endpoint that should become the
        new leader sends either a Gratuitous ARP (GARP) packet (IPv4) or an
        ICMPv6 Router Advertisement(RA) packet (IPv6). Google Cloud
        immediately but temporarily associates the forwarding rule IP
        address with that VM, and both new and in-flight packets are quickly
        delivered to that VM. Note the important properties of the Fast IP
        Move functionality: - The GARP/RA-initiated re-routing stays active
        for approximately 20 minutes. After triggering fast failover, you
        must also appropriately set the haPolicy.leader. - The new leader
        instance should continue to send GARP/RA packets periodically every
        10 seconds until at least 10 minutes after updating the
        haPolicy.leader (but stop immediately if it is no longer the
        leader). - After triggering a fast failover, we recommend that you
        wait at least 3 seconds before sending another GARP/RA packet from a
        different VM instance to avoid race conditions. - Don't send GARP/RA
        packets from different VM instances at the same time. If multiple
        instances continue to send GARP/RA packets, traffic might be routed
        to different destinations in an alternating order. This condition
        ceases when a single instance issues a GARP/RA packet. - The GARP/RA
        request always takes priority over the leader API. Using the
        haPolicy.leader API to change the leader to a different instance
        will have no effect until the GARP/RA request becomes inactive. -
        The GARP/RA packets should follow the GARP/RA Packet
        Specifications.. - When multiple forwarding rules refer to a
        regional backend service, you need only send a GARP or RA packet for
        a single forwarding rule virtual IP. The virtual IPs for all
        forwarding rules targeting the same backend service will also be
        moved to the sender of the GARP or RA packet. The following are the
        Fast IP Move limitations (that is, when fastIPMove is not DISABLED):
        - Multiple forwarding rules cannot use the same IP address if one of
        them refers to a regional backend service with fastIPMove. - The
        regional backend service must set the network field, and all NEGs
        must belong to that network. However, individual NEGs can belong to
        different subnetworks of that network. - The maximum number of
        network endpoints across all backends of a backend service with
        fastIPMove is 64. - The maximum number of backend services with
        fastIPMove that can have the same network endpoint attached to one
        of its backends is 64. - The maximum number of backend services with
        fastIPMove in a VPC in a region is 64. - The network endpoints that
        are attached to a backend of a backend service with fastIPMove
        cannot resolve to Gen3+ machines for IPv6. - Traffic directed to the
        leader by a static route next hop will not be redirected to a new
        leader by fast failover. Such traffic will only be redirected once
        an haPolicy.leader update has taken effect. Only traffic to the
        forwarding rule's virtual IP will be redirected to a new leader by
        fast failover. haPolicy.fastIPMove can be set only at backend
        service creation time. Once set, it cannot be updated. By default,
        fastIpMove is set to DISABLED.

        Values:
            UNDEFINED_FAST_I_P_MOVE (0):
                A value indicating that the enum field is not
                set.
            DISABLED (516696700):
                No description available.
            GARP_RA (527352630):
                No description available.
        """
        UNDEFINED_FAST_I_P_MOVE = 0
        DISABLED = 516696700
        GARP_RA = 527352630

    fast_i_p_move: str = proto.Field(
        proto.STRING,
        number=222633817,
        optional=True,
    )


class BackendServiceHttpCookie(proto.Message):
    r"""The HTTP cookie used for stateful session affinity.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        name (str):
            Name of the cookie.

            This field is a member of `oneof`_ ``_name``.
        path (str):
            Path to set for the cookie.

            This field is a member of `oneof`_ ``_path``.
        ttl (google.cloud.compute_v1.types.Duration):
            Lifetime of the cookie.

            This field is a member of `oneof`_ ``_ttl``.
    """

    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )
    path: str = proto.Field(
        proto.STRING,
        number=3433509,
        optional=True,
    )
    ttl: "Duration" = proto.Field(
        proto.MESSAGE,
        number=115180,
        optional=True,
        message="Duration",
    )


class BackendServiceIAP(proto.Message):
    r"""Identity-Aware Proxy

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        enabled (bool):
            Whether the serving infrastructure will
            authenticate and authorize all incoming
            requests.

            This field is a member of `oneof`_ ``_enabled``.
        oauth2_client_id (str):
            OAuth2 client ID to use for the
            authentication flow.

            This field is a member of `oneof`_ ``_oauth2_client_id``.
        oauth2_client_secret (str):
            OAuth2 client secret to use for the
            authentication flow. For security reasons, this
            value cannot be retrieved via the API. Instead,
            the SHA-256 hash of the value is returned in the
            oauth2ClientSecretSha256 field. @InputOnly

            This field is a member of `oneof`_ ``_oauth2_client_secret``.
        oauth2_client_secret_sha256 (str):
            [Output Only] SHA256 hash value for the field
            oauth2_client_secret above.

            This field is a member of `oneof`_ ``_oauth2_client_secret_sha256``.
    """

    enabled: bool = proto.Field(
        proto.BOOL,
        number=1018689,
        optional=True,
    )
    oauth2_client_id: str = proto.Field(
        proto.STRING,
        number=314017611,
        optional=True,
    )
    oauth2_client_secret: str = proto.Field(
        proto.STRING,
        number=50999520,
        optional=True,
    )
    oauth2_client_secret_sha256: str = proto.Field(
        proto.STRING,
        number=112903782,
        optional=True,
    )


class BackendServiceList(proto.Message):
    r"""Contains a list of BackendService resources.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableSequence[google.cloud.compute_v1.types.BackendService]):
            A list of BackendService resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#backendServiceList for lists of backend services.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableSequence["BackendService"] = proto.RepeatedField(
        proto.MESSAGE,
        number=100526016,
        message="BackendService",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class BackendServiceListUsable(proto.Message):
    r"""Contains a list of usable BackendService resources.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableSequence[google.cloud.compute_v1.types.BackendService]):
            A list of BackendService resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#usableBackendServiceList for lists of usable backend
            services.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableSequence["BackendService"] = proto.RepeatedField(
        proto.MESSAGE,
        number=100526016,
        message="BackendService",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class BackendServiceLocalityLoadBalancingPolicyConfig(proto.Message):
    r"""Container for either a built-in LB policy supported by gRPC
    or Envoy or a custom one implemented by the end user.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        custom_policy (google.cloud.compute_v1.types.BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy):

            This field is a member of `oneof`_ ``_custom_policy``.
        policy (google.cloud.compute_v1.types.BackendServiceLocalityLoadBalancingPolicyConfigPolicy):

            This field is a member of `oneof`_ ``_policy``.
    """

    custom_policy: "BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy" = (
        proto.Field(
            proto.MESSAGE,
            number=4818368,
            optional=True,
            message="BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy",
        )
    )
    policy: "BackendServiceLocalityLoadBalancingPolicyConfigPolicy" = proto.Field(
        proto.MESSAGE,
        number=91071794,
        optional=True,
        message="BackendServiceLocalityLoadBalancingPolicyConfigPolicy",
    )


class BackendServiceLocalityLoadBalancingPolicyConfigCustomPolicy(proto.Message):
    r"""The configuration for a custom policy implemented by the user
    and deployed with the client.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        data (str):
            An optional, arbitrary JSON object with
            configuration data, understood by a locally
            installed custom policy implementation.

            This field is a member of `oneof`_ ``_data``.
        name (str):
            Identifies the custom policy. The value
            should match the name of a custom implementation
            registered on the gRPC clients. It should follow
            protocol buffer message naming conventions and
            include the full path (for example,
            myorg.CustomLbPolicy). The maximum length is 256
            characters. Do not specify the same custom
            policy more than once for a backend. If you do,
            the configuration is rejected. For an example of
            how to use this field, see Use a custom policy.

            This field is a member of `oneof`_ ``_name``.
    """

    data: str = proto.Field(
        proto.STRING,
        number=3076010,
        optional=True,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )


class BackendServiceLocalityLoadBalancingPolicyConfigPolicy(proto.Message):
    r"""The configuration for a built-in load balancing policy.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        name (str):
            The name of a locality load-balancing policy. Valid values
            include ROUND_ROBIN and, for Java clients, LEAST_REQUEST.
            For information about these values, see the description of
            localityLbPolicy. Do not specify the same policy more than
            once for a backend. If you do, the configuration is
            rejected. Check the Name enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_name``.
    """

    class Name(proto.Enum):
        r"""The name of a locality load-balancing policy. Valid values include
        ROUND_ROBIN and, for Java clients, LEAST_REQUEST. For information
        about these values, see the description of localityLbPolicy. Do not
        specify the same policy more than once for a backend. If you do, the
        configuration is rejected.

        Values:
            UNDEFINED_NAME (0):
                A value indicating that the enum field is not
                set.
            INVALID_LB_POLICY (323318707):
                No description available.
            LEAST_REQUEST (46604921):
                An O(1) algorithm which selects two random
                healthy hosts and picks the host which has fewer
                active requests.
            MAGLEV (119180266):
                This algorithm implements consistent hashing
                to backends. Maglev can be used as a drop in
                replacement for the ring hash load balancer.
                Maglev is not as stable as ring hash but has
                faster table lookup build times and host
                selection times. For more information about
                Maglev, see
                https://ai.google/research/pubs/pub44824
            ORIGINAL_DESTINATION (166297216):
                Backend host is selected based on the client
                connection metadata, i.e., connections are
                opened to the same address as the destination
                address of the incoming connection before the
                connection was redirected to the load balancer.
            RANDOM (262527171):
                The load balancer selects a random healthy
                host.
            RING_HASH (432795069):
                The ring/modulo hash load balancer implements
                consistent hashing to backends. The algorithm
                has the property that the addition/removal of a
                host from a set of N hosts only affects 1/N of
                the requests.
            ROUND_ROBIN (153895801):
                This is a simple policy in which each healthy
                backend is selected in round robin order. This
                is the default.
            WEIGHTED_MAGLEV (254930962):
                Per-instance weighted Load Balancing via health check
                reported weights. If set, the Backend Service must configure
                a non legacy HTTP-based Health Check, and health check
                replies are expected to contain non-standard HTTP response
                header field X-Load-Balancing-Endpoint-Weight to specify the
                per-instance weights. If set, Load Balancing is weighted
                based on the per-instance weights reported in the last
                processed health check replies, as long as every instance
                either reported a valid weight or had UNAVAILABLE_WEIGHT.
                Otherwise, Load Balancing remains equal-weight. This option
                is only supported in Network Load Balancing.
            WEIGHTED_ROUND_ROBIN (5584977):
                Per-endpoint weighted round-robin Load Balancing using
                weights computed from Backend reported Custom Metrics. If
                set, the Backend Service responses are expected to contain
                non-standard HTTP response header field
                X-Endpoint-Load-Metrics. The reported metrics to use for
                computing the weights are specified via the
                backends[].customMetrics fields.
        """
        UNDEFINED_NAME = 0
        INVALID_LB_POLICY = 323318707
        LEAST_REQUEST = 46604921
        MAGLEV = 119180266
        ORIGINAL_DESTINATION = 166297216
        RANDOM = 262527171
        RING_HASH = 432795069
        ROUND_ROBIN = 153895801
        WEIGHTED_MAGLEV = 254930962
        WEIGHTED_ROUND_ROBIN = 5584977

    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )


class BackendServiceLogConfig(proto.Message):
    r"""The available logging options for the load balancer traffic
    served by this backend service.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        enable (bool):
            Denotes whether to enable logging for the
            load balancer traffic served by this backend
            service. The default value is false.

            This field is a member of `oneof`_ ``_enable``.
        optional_fields (MutableSequence[str]):
            This field can only be specified if logging
            is enabled for this backend service and
            "logConfig.optionalMode" was set to CUSTOM.
            Contains a list of optional fields you want to
            include in the logs. For example:
            serverInstance, serverGkeDetails.cluster,
            serverGkeDetails.pod.podNamespace
        optional_mode (str):
            This field can only be specified if logging is enabled for
            this backend service. Configures whether all, none or a
            subset of optional fields should be added to the reported
            logs. One of [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL,
            CUSTOM]. Default is EXCLUDE_ALL_OPTIONAL. Check the
            OptionalMode enum for the list of possible values.

            This field is a member of `oneof`_ ``_optional_mode``.
        sample_rate (float):
            This field can only be specified if logging is enabled for
            this backend service. The value of the field must be in [0,
            1]. This configures the sampling rate of requests to the
            load balancer where 1.0 means all logged requests are
            reported and 0.0 means no logged requests are reported. The
            default value is 1.0.

            This field is a member of `oneof`_ ``_sample_rate``.
    """

    class OptionalMode(proto.Enum):
        r"""This field can only be specified if logging is enabled for this
        backend service. Configures whether all, none or a subset of
        optional fields should be added to the reported logs. One of
        [INCLUDE_ALL_OPTIONAL, EXCLUDE_ALL_OPTIONAL, CUSTOM]. Default is
        EXCLUDE_ALL_OPTIONAL.

        Values:
            UNDEFINED_OPTIONAL_MODE (0):
                A value indicating that the enum field is not
                set.
            CUSTOM (388595569):
                A subset of optional fields.
            EXCLUDE_ALL_OPTIONAL (168636099):
                None optional fields.
            INCLUDE_ALL_OPTIONAL (535606965):
                All optional fields.
        """
        UNDEFINED_OPTIONAL_MODE = 0
        CUSTOM = 388595569
        EXCLUDE_ALL_OPTIONAL = 168636099
        INCLUDE_ALL_OPTIONAL = 535606965

    enable: bool = proto.Field(
        proto.BOOL,
        number=311764355,
        optional=True,
    )
    optional_fields: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=528589944,
    )
    optional_mode: str = proto.Field(
        proto.STRING,
        number=128697122,
        optional=True,
    )
    sample_rate: float = proto.Field(
        proto.FLOAT,
        number=153193045,
        optional=True,
    )


class BackendServiceReference(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        backend_service (str):

            This field is a member of `oneof`_ ``_backend_service``.
    """

    backend_service: str = proto.Field(
        proto.STRING,
        number=306946058,
        optional=True,
    )


class BackendServiceUsedBy(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        reference (str):
            [Output Only] Server-defined URL for resources referencing
            given BackendService like UrlMaps, TargetTcpProxies,
            TargetSslProxies and ForwardingRule.

            This field is a member of `oneof`_ ``_reference``.
    """

    reference: str = proto.Field(
        proto.STRING,
        number=148586315,
        optional=True,
    )


class BackendServicesScopedList(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        backend_services (MutableSequence[google.cloud.compute_v1.types.BackendService]):
            A list of BackendServices contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            Informational warning which replaces the list
            of backend services when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    backend_services: MutableSequence["BackendService"] = proto.RepeatedField(
        proto.MESSAGE,
        number=388522409,
        message="BackendService",
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class BfdPacket(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        authentication_present (bool):
            The Authentication Present bit of the BFD
            packet. This is specified in section 4.1 of
            RFC5880

            This field is a member of `oneof`_ ``_authentication_present``.
        control_plane_independent (bool):
            The Control Plane Independent bit of the BFD
            packet. This is specified in section 4.1 of
            RFC5880

            This field is a member of `oneof`_ ``_control_plane_independent``.
        demand (bool):
            The demand bit of the BFD packet. This is
            specified in section 4.1 of RFC5880

            This field is a member of `oneof`_ ``_demand``.
        diagnostic (str):
            The diagnostic code specifies the local
            system's reason for the last change in session
            state. This allows remote systems to determine
            the reason that the previous session failed, for
            example. These diagnostic codes are specified in
            section 4.1 of RFC5880 Check the Diagnostic enum
            for the list of possible values.

            This field is a member of `oneof`_ ``_diagnostic``.
        final (bool):
            The Final bit of the BFD packet. This is
            specified in section 4.1 of RFC5880

            This field is a member of `oneof`_ ``_final``.
        length (int):
            The length of the BFD Control packet in
            bytes. This is specified in section 4.1 of
            RFC5880

            This field is a member of `oneof`_ ``_length``.
        min_echo_rx_interval_ms (int):
            The Required Min Echo RX Interval value in
            the BFD packet. This is specified in section 4.1
            of RFC5880

            This field is a member of `oneof`_ ``_min_echo_rx_interval_ms``.
        min_rx_interval_ms (int):
            The Required Min RX Interval value in the BFD
            packet. This is specified in section 4.1 of
            RFC5880

            This field is a member of `oneof`_ ``_min_rx_interval_ms``.
        min_tx_interval_ms (int):
            The Desired Min TX Interval value in the BFD
            packet. This is specified in section 4.1 of
            RFC5880

            This field is a member of `oneof`_ ``_min_tx_interval_ms``.
        multiplier (int):
            The detection time multiplier of the BFD
            packet. This is specified in section 4.1 of
            RFC5880

            This field is a member of `oneof`_ ``_multiplier``.
        multipoint (bool):
            The multipoint bit of the BFD packet. This is
            specified in section 4.1 of RFC5880

            This field is a member of `oneof`_ ``_multipoint``.
        my_discriminator (int):
            The My Discriminator value in the BFD packet.
            This is specified in section 4.1 of RFC5880

            This field is a member of `oneof`_ ``_my_discriminator``.
        poll (bool):
            The Poll bit of the BFD packet. This is
            specified in section 4.1 of RFC5880

            This field is a member of `oneof`_ ``_poll``.
        state (str):
            The current BFD session state as seen by the
            transmitting system. These states are specified
            in section 4.1 of RFC5880 Check the State enum
            for the list of possible values.

            This field is a member of `oneof`_ ``_state``.
        version (int):
            The version number of the BFD protocol, as
            specified in section 4.1 of RFC5880.

            This field is a member of `oneof`_ ``_version``.
        your_discriminator (int):
            The Your Discriminator value in the BFD
            packet. This is specified in section 4.1 of
            RFC5880

            This field is a member of `oneof`_ ``_your_discriminator``.
    """

    class Diagnostic(proto.Enum):
        r"""The diagnostic code specifies the local system's reason for
        the last change in session state. This allows remote systems to
        determine the reason that the previous session failed, for
        example. These diagnostic codes are specified in section 4.1 of
        RFC5880

        Values:
            UNDEFINED_DIAGNOSTIC (0):
                A value indicating that the enum field is not
                set.
            ADMINISTRATIVELY_DOWN (121685798):
                No description available.
            CONCATENATED_PATH_DOWN (26186892):
                No description available.
            CONTROL_DETECTION_TIME_EXPIRED (135478383):
                No description available.
            DIAGNOSTIC_UNSPECIFIED (58720895):
                No description available.
            ECHO_FUNCTION_FAILED (220687466):
                No description available.
            FORWARDING_PLANE_RESET (19715882):
                No description available.
            NEIGHBOR_SIGNALED_SESSION_DOWN (374226742):
                No description available.
            NO_DIAGNOSTIC (222503141):
                No description available.
            PATH_DOWN (290605180):
                No description available.
            REVERSE_CONCATENATED_PATH_DOWN (479337129):
                No description available.
        """
        UNDEFINED_DIAGNOSTIC = 0
        ADMINISTRATIVELY_DOWN = 121685798
        CONCATENATED_PATH_DOWN = 26186892
        CONTROL_DETECTION_TIME_EXPIRED = 135478383
        DIAGNOSTIC_UNSPECIFIED = 58720895
        ECHO_FUNCTION_FAILED = 220687466
        FORWARDING_PLANE_RESET = 19715882
        NEIGHBOR_SIGNALED_SESSION_DOWN = 374226742
        NO_DIAGNOSTIC = 222503141
        PATH_DOWN = 290605180
        REVERSE_CONCATENATED_PATH_DOWN = 479337129

    class State(proto.Enum):
        r"""The current BFD session state as seen by the transmitting
        system. These states are specified in section 4.1 of RFC5880

        Values:
            UNDEFINED_STATE (0):
                A value indicating that the enum field is not
                set.
            ADMIN_DOWN (128544690):
                No description available.
            DOWN (2104482):
                No description available.
            INIT (2252048):
                No description available.
            STATE_UNSPECIFIED (470755401):
                No description available.
            UP (2715):
                No description available.
        """
        UNDEFINED_STATE = 0
        ADMIN_DOWN = 128544690
        DOWN = 2104482
        INIT = 2252048
        STATE_UNSPECIFIED = 470755401
        UP = 2715

    authentication_present: bool = proto.Field(
        proto.BOOL,
        number=105974260,
        optional=True,
    )
    control_plane_independent: bool = proto.Field(
        proto.BOOL,
        number=62363573,
        optional=True,
    )
    demand: bool = proto.Field(
        proto.BOOL,
        number=275180107,
        optional=True,
    )
    diagnostic: str = proto.Field(
        proto.STRING,
        number=62708647,
        optional=True,
    )
    final: bool = proto.Field(
        proto.BOOL,
        number=97436022,
        optional=True,
    )
    length: int = proto.Field(
        proto.UINT32,
        number=504249062,
        optional=True,
    )
    min_echo_rx_interval_ms: int = proto.Field(
        proto.UINT32,
        number=97286868,
        optional=True,
    )
    min_rx_interval_ms: int = proto.Field(
        proto.UINT32,
        number=463399028,
        optional=True,
    )
    min_tx_interval_ms: int = proto.Field(
        proto.UINT32,
        number=526023602,
        optional=True,
    )
    multiplier: int = proto.Field(
        proto.UINT32,
        number=191331777,
        optional=True,
    )
    multipoint: bool = proto.Field(
        proto.BOOL,
        number=191421431,
        optional=True,
    )
    my_discriminator: int = proto.Field(
        proto.UINT32,
        number=76663113,
        optional=True,
    )
    poll: bool = proto.Field(
        proto.BOOL,
        number=3446719,
        optional=True,
    )
    state: str = proto.Field(
        proto.STRING,
        number=109757585,
        optional=True,
    )
    version: int = proto.Field(
        proto.UINT32,
        number=351608024,
        optional=True,
    )
    your_discriminator: int = proto.Field(
        proto.UINT32,
        number=515634064,
        optional=True,
    )


class BfdStatus(proto.Message):
    r"""Next free: 15

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        bfd_session_initialization_mode (str):
            The BFD session initialization mode for this
            BGP peer. If set to ACTIVE, the Cloud Router
            will initiate the BFD session for this BGP peer.
            If set to PASSIVE, the Cloud Router will wait
            for the peer router to initiate the BFD session
            for this BGP peer. If set to DISABLED, BFD is
            disabled for this BGP peer. Check the
            BfdSessionInitializationMode enum for the list
            of possible values.

            This field is a member of `oneof`_ ``_bfd_session_initialization_mode``.
        config_update_timestamp_micros (int):
            Unix timestamp of the most recent config
            update.

            This field is a member of `oneof`_ ``_config_update_timestamp_micros``.
        control_packet_counts (google.cloud.compute_v1.types.BfdStatusPacketCounts):
            Control packet counts for the current BFD
            session.

            This field is a member of `oneof`_ ``_control_packet_counts``.
        control_packet_intervals (MutableSequence[google.cloud.compute_v1.types.PacketIntervals]):
            Inter-packet time interval statistics for
            control packets.
        local_diagnostic (str):
            The diagnostic code specifies the local
            system's reason for the last change in session
            state. This allows remote systems to determine
            the reason that the previous session failed, for
            example. These diagnostic codes are specified in
            section 4.1 of RFC5880 Check the LocalDiagnostic
            enum for the list of possible values.

            This field is a member of `oneof`_ ``_local_diagnostic``.
        local_state (str):
            The current BFD session state as seen by the
            transmitting system. These states are specified
            in section 4.1 of RFC5880 Check the LocalState
            enum for the list of possible values.

            This field is a member of `oneof`_ ``_local_state``.
        negotiated_local_control_tx_interval_ms (int):
            Negotiated transmit interval for control
            packets.

            This field is a member of `oneof`_ ``_negotiated_local_control_tx_interval_ms``.
        rx_packet (google.cloud.compute_v1.types.BfdPacket):
            The most recent Rx control packet for this
            BFD session.

            This field is a member of `oneof`_ ``_rx_packet``.
        tx_packet (google.cloud.compute_v1.types.BfdPacket):
            The most recent Tx control packet for this
            BFD session.

            This field is a member of `oneof`_ ``_tx_packet``.
        uptime_ms (int):
            Session uptime in milliseconds. Value will be
            0 if session is not up.

            This field is a member of `oneof`_ ``_uptime_ms``.
    """

    class BfdSessionInitializationMode(proto.Enum):
        r"""The BFD session initialization mode for this BGP peer. If set
        to ACTIVE, the Cloud Router will initiate the BFD session for
        this BGP peer. If set to PASSIVE, the Cloud Router will wait for
        the peer router to initiate the BFD session for this BGP peer.
        If set to DISABLED, BFD is disabled for this BGP peer.

        Values:
            UNDEFINED_BFD_SESSION_INITIALIZATION_MODE (0):
                A value indicating that the enum field is not
                set.
            ACTIVE (314733318):
                No description available.
            DISABLED (516696700):
                No description available.
            PASSIVE (462813959):
                No description available.
        """
        UNDEFINED_BFD_SESSION_INITIALIZATION_MODE = 0
        ACTIVE = 314733318
        DISABLED = 516696700
        PASSIVE = 462813959

    class LocalDiagnostic(proto.Enum):
        r"""The diagnostic code specifies the local system's reason for
        the last change in session state. This allows remote systems to
        determine the reason that the previous session failed, for
        example. These diagnostic codes are specified in section 4.1 of
        RFC5880

        Values:
            UNDEFINED_LOCAL_DIAGNOSTIC (0):
                A value indicating that the enum field is not
                set.
            ADMINISTRATIVELY_DOWN (121685798):
                No description available.
            CONCATENATED_PATH_DOWN (26186892):
                No description available.
            CONTROL_DETECTION_TIME_EXPIRED (135478383):
                No description available.
            DIAGNOSTIC_UNSPECIFIED (58720895):
                No description available.
            ECHO_FUNCTION_FAILED (220687466):
                No description available.
            FORWARDING_PLANE_RESET (19715882):
                No description available.
            NEIGHBOR_SIGNALED_SESSION_DOWN (374226742):
                No description available.
            NO_DIAGNOSTIC (222503141):
                No description available.
            PATH_DOWN (290605180):
                No description available.
            REVERSE_CONCATENATED_PATH_DOWN (479337129):
                No description available.
        """
        UNDEFINED_LOCAL_DIAGNOSTIC = 0
        ADMINISTRATIVELY_DOWN = 121685798
        CONCATENATED_PATH_DOWN = 26186892
        CONTROL_DETECTION_TIME_EXPIRED = 135478383
        DIAGNOSTIC_UNSPECIFIED = 58720895
        ECHO_FUNCTION_FAILED = 220687466
        FORWARDING_PLANE_RESET = 19715882
        NEIGHBOR_SIGNALED_SESSION_DOWN = 374226742
        NO_DIAGNOSTIC = 222503141
        PATH_DOWN = 290605180
        REVERSE_CONCATENATED_PATH_DOWN = 479337129

    class LocalState(proto.Enum):
        r"""The current BFD session state as seen by the transmitting
        system. These states are specified in section 4.1 of RFC5880

        Values:
            UNDEFINED_LOCAL_STATE (0):
                A value indicating that the enum field is not
                set.
            ADMIN_DOWN (128544690):
                No description available.
            DOWN (2104482):
                No description available.
            INIT (2252048):
                No description available.
            STATE_UNSPECIFIED (470755401):
                No description available.
            UP (2715):
                No description available.
        """
        UNDEFINED_LOCAL_STATE = 0
        ADMIN_DOWN = 128544690
        DOWN = 2104482
        INIT = 2252048
        STATE_UNSPECIFIED = 470755401
        UP = 2715

    bfd_session_initialization_mode: str = proto.Field(
        proto.STRING,
        number=218156954,
        optional=True,
    )
    config_update_timestamp_micros: int = proto.Field(
        proto.INT64,
        number=457195569,
        optional=True,
    )
    control_packet_counts: "BfdStatusPacketCounts" = proto.Field(
        proto.MESSAGE,
        number=132573561,
        optional=True,
        message="BfdStatusPacketCounts",
    )
    control_packet_intervals: MutableSequence["PacketIntervals"] = proto.RepeatedField(
        proto.MESSAGE,
        number=500806649,
        message="PacketIntervals",
    )
    local_diagnostic: str = proto.Field(
        proto.STRING,
        number=463737083,
        optional=True,
    )
    local_state: str = proto.Field(
        proto.STRING,
        number=149195453,
        optional=True,
    )
    negotiated_local_control_tx_interval_ms: int = proto.Field(
        proto.UINT32,
        number=21768340,
        optional=True,
    )
    rx_packet: "BfdPacket" = proto.Field(
        proto.MESSAGE,
        number=505069729,
        optional=True,
        message="BfdPacket",
    )
    tx_packet: "BfdPacket" = proto.Field(
        proto.MESSAGE,
        number=111386275,
        optional=True,
        message="BfdPacket",
    )
    uptime_ms: int = proto.Field(
        proto.INT64,
        number=125398365,
        optional=True,
    )


class BfdStatusPacketCounts(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        num_rx (int):
            Number of packets received since the
            beginning of the current BFD session.

            This field is a member of `oneof`_ ``_num_rx``.
        num_rx_rejected (int):
            Number of packets received that were rejected
            because of errors since the beginning of the
            current BFD session.

            This field is a member of `oneof`_ ``_num_rx_rejected``.
        num_rx_successful (int):
            Number of packets received that were
            successfully processed since the beginning of
            the current BFD session.

            This field is a member of `oneof`_ ``_num_rx_successful``.
        num_tx (int):
            Number of packets transmitted since the
            beginning of the current BFD session.

            This field is a member of `oneof`_ ``_num_tx``.
    """

    num_rx: int = proto.Field(
        proto.UINT32,
        number=39375263,
        optional=True,
    )
    num_rx_rejected: int = proto.Field(
        proto.UINT32,
        number=281007902,
        optional=True,
    )
    num_rx_successful: int = proto.Field(
        proto.UINT32,
        number=455361850,
        optional=True,
    )
    num_tx: int = proto.Field(
        proto.UINT32,
        number=39375325,
        optional=True,
    )


class BgpRoute(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        as_paths (MutableSequence[google.cloud.compute_v1.types.BgpRouteAsPath]):
            [Output only] AS-PATH for the route
        communities (MutableSequence[str]):
            [Output only] BGP communities in human-readable A:B format.
        destination (google.cloud.compute_v1.types.BgpRouteNetworkLayerReachabilityInformation):
            [Output only] Destination IP range for the route, in
            human-readable CIDR format

            This field is a member of `oneof`_ ``_destination``.
        med (int):
            [Output only] BGP multi-exit discriminator

            This field is a member of `oneof`_ ``_med``.
        origin (str):
            [Output only] BGP origin (EGP, IGP or INCOMPLETE) Check the
            Origin enum for the list of possible values.

            This field is a member of `oneof`_ ``_origin``.
    """

    class Origin(proto.Enum):
        r"""[Output only] BGP origin (EGP, IGP or INCOMPLETE)

        Values:
            UNDEFINED_ORIGIN (0):
                A value indicating that the enum field is not
                set.
            BGP_ORIGIN_EGP (378906473):
                No description available.
            BGP_ORIGIN_IGP (378910317):
                No description available.
            BGP_ORIGIN_INCOMPLETE (452839811):
                No description available.
        """
        UNDEFINED_ORIGIN = 0
        BGP_ORIGIN_EGP = 378906473
        BGP_ORIGIN_IGP = 378910317
        BGP_ORIGIN_INCOMPLETE = 452839811

    as_paths: MutableSequence["BgpRouteAsPath"] = proto.RepeatedField(
        proto.MESSAGE,
        number=137568929,
        message="BgpRouteAsPath",
    )
    communities: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=188262983,
    )
    destination: "BgpRouteNetworkLayerReachabilityInformation" = proto.Field(
        proto.MESSAGE,
        number=180765710,
        optional=True,
        message="BgpRouteNetworkLayerReachabilityInformation",
    )
    med: int = proto.Field(
        proto.UINT32,
        number=107980,
        optional=True,
    )
    origin: str = proto.Field(
        proto.STRING,
        number=65122086,
        optional=True,
    )


class BgpRouteAsPath(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        asns (MutableSequence[int]):
            [Output only] ASNs in the path segment. When type is
            SEQUENCE, these are ordered.
        type_ (str):
            [Output only] Type of AS-PATH segment (SEQUENCE or SET)
            Check the Type enum for the list of possible values.

            This field is a member of `oneof`_ ``_type``.
    """

    class Type(proto.Enum):
        r"""[Output only] Type of AS-PATH segment (SEQUENCE or SET)

        Values:
            UNDEFINED_TYPE (0):
                A value indicating that the enum field is not
                set.
            AS_PATH_TYPE_SEQUENCE (362887609):
                No description available.
            AS_PATH_TYPE_SET (302584650):
                No description available.
        """
        UNDEFINED_TYPE = 0
        AS_PATH_TYPE_SEQUENCE = 362887609
        AS_PATH_TYPE_SET = 302584650

    asns: MutableSequence[int] = proto.RepeatedField(
        proto.INT32,
        number=3003767,
    )
    type_: str = proto.Field(
        proto.STRING,
        number=3575610,
        optional=True,
    )


class BgpRouteNetworkLayerReachabilityInformation(proto.Message):
    r"""Network Layer Reachability Information (NLRI) for a route.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        path_id (int):
            If the BGP session supports multiple paths
            (RFC 7911), the path identifier for this route.

            This field is a member of `oneof`_ ``_path_id``.
        prefix (str):
            Human readable CIDR notation for a prefix.
            E.g. 10.42.0.0/16.

            This field is a member of `oneof`_ ``_prefix``.
    """

    path_id: int = proto.Field(
        proto.UINT32,
        number=282287989,
        optional=True,
    )
    prefix: str = proto.Field(
        proto.STRING,
        number=93631122,
        optional=True,
    )


class Binding(proto.Message):
    r"""Associates ``members``, or principals, with a ``role``.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        binding_id (str):

            This field is a member of `oneof`_ ``_binding_id``.
        condition (google.cloud.compute_v1.types.Expr):
            The condition that is associated with this binding. If the
            condition evaluates to ``true``, then this binding applies
            to the current request. If the condition evaluates to
            ``false``, then this binding does not apply to the current
            request. However, a different role binding might grant the
            same role to one or more of the principals in this binding.
            To learn which resources support conditions in their IAM
            policies, see the `IAM
            documentation <https://cloud.google.com/iam/help/conditions/resource-policies>`__.

            This field is a member of `oneof`_ ``_condition``.
        members (MutableSequence[str]):
            Specifies the principals requesting access for a Google
            Cloud resource. ``members`` can have the following values:
            \* ``allUsers``: A special identifier that represents anyone
            who is on the internet; with or without a Google account. \*
            ``allAuthenticatedUsers``: A special identifier that
            represents anyone who is authenticated with a Google account
            or a service account. Does not include identities that come
            from external identity providers (IdPs) through identity
            federation. \* ``user:{emailid}``: An email address that
            represents a specific Google account. For example,
            ``alice@example.com`` . \* ``serviceAccount:{emailid}``: An
            email address that represents a Google service account. For
            example, ``my-other-app@appspot.gserviceaccount.com``. \*
            ``serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]``:
            An identifier for a `Kubernetes service
            account <https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts>`__.
            For example,
            ``my-project.svc.id.goog[my-namespace/my-kubernetes-sa]``.
            \* ``group:{emailid}``: An email address that represents a
            Google group. For example, ``admins@example.com``. \*
            ``domain:{domain}``: The G Suite domain (primary) that
            represents all the users of that domain. For example,
            ``google.com`` or ``example.com``. \*
            ``principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attribute_value}``:
            A single identity in a workforce identity pool. \*
            ``principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}``:
            All workforce identities in a group. \*
            ``principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{attribute_value}``:
            All workforce identities with a specific attribute value. \*
            ``principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/*``:
            All identities in a workforce identity pool. \*
            ``principal://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/subject/{subject_attribute_value}``:
            A single identity in a workload identity pool. \*
            ``principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/group/{group_id}``:
            A workload identity pool group. \*
            ``principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}``:
            All identities in a workload identity pool with a certain
            attribute. \*
            ``principalSet://iam.googleapis.com/projects/{project_number}/locations/global/workloadIdentityPools/{pool_id}/*``:
            All identities in a workload identity pool. \*
            ``deleted:user:{emailid}?uid={uniqueid}``: An email address
            (plus unique identifier) representing a user that has been
            recently deleted. For example,
            ``alice@example.com?uid=123456789012345678901``. If the user
            is recovered, this value reverts to ``user:{emailid}`` and
            the recovered user retains the role in the binding. \*
            ``deleted:serviceAccount:{emailid}?uid={uniqueid}``: An
            email address (plus unique identifier) representing a
            service account that has been recently deleted. For example,
            ``my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901``.
            If the service account is undeleted, this value reverts to
            ``serviceAccount:{emailid}`` and the undeleted service
            account retains the role in the binding. \*
            ``deleted:group:{emailid}?uid={uniqueid}``: An email address
            (plus unique identifier) representing a Google group that
            has been recently deleted. For example,
            ``admins@example.com?uid=123456789012345678901``. If the
            group is recovered, this value reverts to
            ``group:{emailid}`` and the recovered group retains the role
            in the binding. \*
            ``deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attribute_value}``:
            Deleted single identity in a workforce identity pool. For
            example,
            ``deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-pool-id/subject/my-subject-attribute-value``.
        role (str):
            Role that is assigned to the list of ``members``, or
            principals. For example, ``roles/viewer``, ``roles/editor``,
            or ``roles/owner``. For an overview of the IAM roles and
            permissions, see the `IAM
            documentation <https://cloud.google.com/iam/docs/roles-overview>`__.
            For a list of the available pre-defined roles, see
            `here <https://cloud.google.com/iam/docs/understanding-roles>`__.

            This field is a member of `oneof`_ ``_role``.
    """

    binding_id: str = proto.Field(
        proto.STRING,
        number=441088277,
        optional=True,
    )
    condition: "Expr" = proto.Field(
        proto.MESSAGE,
        number=212430107,
        optional=True,
        message="Expr",
    )
    members: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=412010777,
    )
    role: str = proto.Field(
        proto.STRING,
        number=3506294,
        optional=True,
    )


class BulkInsertDiskRequest(proto.Message):
    r"""A request message for Disks.BulkInsert. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        bulk_insert_disk_resource_resource (google.cloud.compute_v1.types.BulkInsertDiskResource):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    bulk_insert_disk_resource_resource: "BulkInsertDiskResource" = proto.Field(
        proto.MESSAGE,
        number=289799382,
        message="BulkInsertDiskResource",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class BulkInsertDiskResource(proto.Message):
    r"""A transient resource used in compute.disks.bulkInsert and
    compute.regionDisks.bulkInsert. It is only used to process
    requests and is not persisted.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        source_consistency_group_policy (str):
            The URL of the DiskConsistencyGroupPolicy for
            the group of disks to clone. This may be a full
            or partial URL, such as: -
            https://www.googleapis.com/compute/v1/projects/project/regions/region
            /resourcePolicies/resourcePolicy -
            projects/project/regions/region/resourcePolicies/resourcePolicy
            - regions/region/resourcePolicies/resourcePolicy

            This field is a member of `oneof`_ ``_source_consistency_group_policy``.
    """

    source_consistency_group_policy: str = proto.Field(
        proto.STRING,
        number=19616093,
        optional=True,
    )


class BulkInsertInstanceRequest(proto.Message):
    r"""A request message for Instances.BulkInsert. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        bulk_insert_instance_resource_resource (google.cloud.compute_v1.types.BulkInsertInstanceResource):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    bulk_insert_instance_resource_resource: "BulkInsertInstanceResource" = proto.Field(
        proto.MESSAGE,
        number=41427278,
        message="BulkInsertInstanceResource",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class BulkInsertInstanceResource(proto.Message):
    r"""A transient resource used in compute.instances.bulkInsert and
    compute.regionInstances.bulkInsert . This resource is not
    persisted anywhere, it is used only for processing the requests.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        count (int):
            The maximum number of instances to create.

            This field is a member of `oneof`_ ``_count``.
        instance_properties (google.cloud.compute_v1.types.InstanceProperties):
            The instance properties defining the VM
            instances to be created. Required if
            sourceInstanceTemplate is not provided.

            This field is a member of `oneof`_ ``_instance_properties``.
        location_policy (google.cloud.compute_v1.types.LocationPolicy):
            Policy for choosing target zone. For more
            information, see Create VMs in bulk.

            This field is a member of `oneof`_ ``_location_policy``.
        min_count (int):
            The minimum number of instances to create. If no min_count
            is specified then count is used as the default value. If
            min_count instances cannot be created, then no instances
            will be created and instances already created will be
            deleted.

            This field is a member of `oneof`_ ``_min_count``.
        name_pattern (str):
            The string pattern used for the names of the VMs. Either
            name_pattern or per_instance_properties must be set. The
            pattern must contain one continuous sequence of placeholder
            hash characters (#) with each character corresponding to one
            digit of the generated instance name. Example: a
            name_pattern of inst-#### generates instance names such as
            inst-0001 and inst-0002. If existing instances in the same
            project and zone have names that match the name pattern then
            the generated instance numbers start after the biggest
            existing number. For example, if there exists an instance
            with name inst-0050, then instance names generated using the
            pattern inst-#### begin with inst-0051. The name pattern
            placeholder #...# can contain up to 18 characters.

            This field is a member of `oneof`_ ``_name_pattern``.
        per_instance_properties (MutableMapping[str, google.cloud.compute_v1.types.BulkInsertInstanceResourcePerInstanceProperties]):
            Per-instance properties to be set on individual instances.
            Keys of this map specify requested instance names. Can be
            empty if name_pattern is used.
        source_instance_template (str):
            Specifies the instance template from which to
            create instances. You may combine
            sourceInstanceTemplate with instanceProperties
            to override specific values from an existing
            instance template. Bulk API follows the
            semantics of JSON Merge Patch described by RFC
            7396. It can be a full or partial URL. For
            example, the following are all valid URLs to an
            instance template: -
            https://www.googleapis.com/compute/v1/projects/project
            /global/instanceTemplates/instanceTemplate -
            projects/project/global/instanceTemplates/instanceTemplate
            - global/instanceTemplates/instanceTemplate This
            field is optional.

            This field is a member of `oneof`_ ``_source_instance_template``.
    """

    count: int = proto.Field(
        proto.INT64,
        number=94851343,
        optional=True,
    )
    instance_properties: "InstanceProperties" = proto.Field(
        proto.MESSAGE,
        number=215355165,
        optional=True,
        message="InstanceProperties",
    )
    location_policy: "LocationPolicy" = proto.Field(
        proto.MESSAGE,
        number=465689852,
        optional=True,
        message="LocationPolicy",
    )
    min_count: int = proto.Field(
        proto.INT64,
        number=523228386,
        optional=True,
    )
    name_pattern: str = proto.Field(
        proto.STRING,
        number=413815260,
        optional=True,
    )
    per_instance_properties: MutableMapping[
        str, "BulkInsertInstanceResourcePerInstanceProperties"
    ] = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=108502267,
        message="BulkInsertInstanceResourcePerInstanceProperties",
    )
    source_instance_template: str = proto.Field(
        proto.STRING,
        number=332423616,
        optional=True,
    )


class BulkInsertInstanceResourcePerInstanceProperties(proto.Message):
    r"""Per-instance properties to be set on individual instances. To
    be extended in the future.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        hostname (str):
            Specifies the hostname of the instance. More details in:
            https://cloud.google.com/compute/docs/instances/custom-hostname-vm#naming_convention

            This field is a member of `oneof`_ ``_hostname``.
        name (str):
            This field is only temporary. It will be
            removed. Do not use it.

            This field is a member of `oneof`_ ``_name``.
    """

    hostname: str = proto.Field(
        proto.STRING,
        number=237067315,
        optional=True,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )


class BulkInsertOperationStatus(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        created_vm_count (int):
            [Output Only] Count of VMs successfully created so far.

            This field is a member of `oneof`_ ``_created_vm_count``.
        deleted_vm_count (int):
            [Output Only] Count of VMs that got deleted during rollback.

            This field is a member of `oneof`_ ``_deleted_vm_count``.
        failed_to_create_vm_count (int):
            [Output Only] Count of VMs that started creating but
            encountered an error.

            This field is a member of `oneof`_ ``_failed_to_create_vm_count``.
        status (str):
            [Output Only] Creation status of BulkInsert operation -
            information if the flow is rolling forward or rolling back.
            Check the Status enum for the list of possible values.

            This field is a member of `oneof`_ ``_status``.
        target_vm_count (int):
            [Output Only] Count of VMs originally planned to be created.

            This field is a member of `oneof`_ ``_target_vm_count``.
    """

    class Status(proto.Enum):
        r"""[Output Only] Creation status of BulkInsert operation - information
        if the flow is rolling forward or rolling back.

        Values:
            UNDEFINED_STATUS (0):
                A value indicating that the enum field is not
                set.
            CREATING (455564985):
                Rolling forward - creating VMs.
            DONE (2104194):
                Done
            ROLLING_BACK (259411649):
                Rolling back - cleaning up after an error.
            STATUS_UNSPECIFIED (42133066):
                No description available.
        """
        UNDEFINED_STATUS = 0
        CREATING = 455564985
        DONE = 2104194
        ROLLING_BACK = 259411649
        STATUS_UNSPECIFIED = 42133066

    created_vm_count: int = proto.Field(
        proto.INT32,
        number=396924158,
        optional=True,
    )
    deleted_vm_count: int = proto.Field(
        proto.INT32,
        number=271756013,
        optional=True,
    )
    failed_to_create_vm_count: int = proto.Field(
        proto.INT32,
        number=58384104,
        optional=True,
    )
    status: str = proto.Field(
        proto.STRING,
        number=181260274,
        optional=True,
    )
    target_vm_count: int = proto.Field(
        proto.INT32,
        number=532975733,
        optional=True,
    )


class BulkInsertRegionDiskRequest(proto.Message):
    r"""A request message for RegionDisks.BulkInsert. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        bulk_insert_disk_resource_resource (google.cloud.compute_v1.types.BulkInsertDiskResource):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    bulk_insert_disk_resource_resource: "BulkInsertDiskResource" = proto.Field(
        proto.MESSAGE,
        number=289799382,
        message="BulkInsertDiskResource",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class BulkInsertRegionInstanceRequest(proto.Message):
    r"""A request message for RegionInstances.BulkInsert. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        bulk_insert_instance_resource_resource (google.cloud.compute_v1.types.BulkInsertInstanceResource):
            The body resource for this request
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    bulk_insert_instance_resource_resource: "BulkInsertInstanceResource" = proto.Field(
        proto.MESSAGE,
        number=41427278,
        message="BulkInsertInstanceResource",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class CacheInvalidationRule(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        cache_tags (MutableSequence[str]):
            A list of cache tags used to identify cached objects. -
            Cache tags are specified when the response is first cached,
            by setting the ``Cache-Tag`` response header at the origin.
            - Multiple cache tags in the same invalidation request are
            treated as Boolean ``OR`` - for example,
            ``tag1 OR tag2 OR tag3``. - If other fields are also
            specified, these are treated as Boolean ``AND`` with any
            tags. Up to 10 tags can be specified in a single
            invalidation request.
        host (str):
            If set, this invalidation rule will only
            apply to requests with a Host header matching
            host.

            This field is a member of `oneof`_ ``_host``.
        path (str):

            This field is a member of `oneof`_ ``_path``.
    """

    cache_tags: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=29073078,
    )
    host: str = proto.Field(
        proto.STRING,
        number=3208616,
        optional=True,
    )
    path: str = proto.Field(
        proto.STRING,
        number=3433509,
        optional=True,
    )


class CacheKeyPolicy(proto.Message):
    r"""Message containing what to include in the cache key for a
    request for Cloud CDN.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        include_host (bool):
            If true, requests to different hosts will be
            cached separately.

            This field is a member of `oneof`_ ``_include_host``.
        include_http_headers (MutableSequence[str]):
            Allows HTTP request headers (by name) to be
            used in the cache key.
        include_named_cookies (MutableSequence[str]):
            Allows HTTP cookies (by name) to be used in
            the cache key. The name=value pair will be used
            in the cache key Cloud CDN generates.
        include_protocol (bool):
            If true, http and https requests will be
            cached separately.

            This field is a member of `oneof`_ ``_include_protocol``.
        include_query_string (bool):
            If true, include query string parameters in the cache key
            according to query_string_whitelist and
            query_string_blacklist. If neither is set, the entire query
            string will be included. If false, the query string will be
            excluded from the cache key entirely.

            This field is a member of `oneof`_ ``_include_query_string``.
        query_string_blacklist (MutableSequence[str]):
            Names of query string parameters to exclude in cache keys.
            All other parameters will be included. Either specify
            query_string_whitelist or query_string_blacklist, not both.
            '&' and '=' will be percent encoded and not treated as
            delimiters.
        query_string_whitelist (MutableSequence[str]):
            Names of query string parameters to include in cache keys.
            All other parameters will be excluded. Either specify
            query_string_whitelist or query_string_blacklist, not both.
            '&' and '=' will be percent encoded and not treated as
            delimiters.
    """

    include_host: bool = proto.Field(
        proto.BOOL,
        number=486867679,
        optional=True,
    )
    include_http_headers: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=2489606,
    )
    include_named_cookies: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=87316530,
    )
    include_protocol: bool = proto.Field(
        proto.BOOL,
        number=303507535,
        optional=True,
    )
    include_query_string: bool = proto.Field(
        proto.BOOL,
        number=474036639,
        optional=True,
    )
    query_string_blacklist: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=354964742,
    )
    query_string_whitelist: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=52456496,
    )


class CancelInstanceGroupManagerResizeRequestRequest(proto.Message):
    r"""A request message for
    InstanceGroupManagerResizeRequests.Cancel. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group. The
            name should conform to RFC1035 or be a resource
            ID.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        resize_request (str):
            The name of the resize request to cancel. The
            name should conform to RFC1035 or be a resource
            ID.
        zone (str):
            The name of the zone where the managed
            instance group is located. The name should
            conform to RFC1035.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    resize_request: str = proto.Field(
        proto.STRING,
        number=216941060,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class CircuitBreakers(proto.Message):
    r"""Settings controlling the volume of requests, connections and
    retries to this backend service.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        max_connections (int):
            The maximum number of connections to the
            backend service. If not specified, there is no
            limit. Not supported when the backend service is
            referenced by a URL map that is bound to target
            gRPC proxy that has validateForProxyless field
            set to true.

            This field is a member of `oneof`_ ``_max_connections``.
        max_pending_requests (int):
            The maximum number of pending requests
            allowed to the backend service. If not
            specified, there is no limit. Not supported when
            the backend service is referenced by a URL map
            that is bound to target gRPC proxy that has
            validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_max_pending_requests``.
        max_requests (int):
            The maximum number of parallel requests that
            allowed to the backend service. If not
            specified, there is no limit.

            This field is a member of `oneof`_ ``_max_requests``.
        max_requests_per_connection (int):
            Maximum requests for a single connection to
            the backend service. This parameter is respected
            by both the HTTP/1.1 and HTTP/2 implementations.
            If not specified, there is no limit. Setting
            this parameter to 1 will effectively disable
            keep alive. Not supported when the backend
            service is referenced by a URL map that is bound
            to target gRPC proxy that has
            validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_max_requests_per_connection``.
        max_retries (int):
            The maximum number of parallel retries
            allowed to the backend cluster. If not
            specified, the default is 1. Not supported when
            the backend service is referenced by a URL map
            that is bound to target gRPC proxy that has
            validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_max_retries``.
    """

    max_connections: int = proto.Field(
        proto.INT32,
        number=110652154,
        optional=True,
    )
    max_pending_requests: int = proto.Field(
        proto.INT32,
        number=375558887,
        optional=True,
    )
    max_requests: int = proto.Field(
        proto.INT32,
        number=28097599,
        optional=True,
    )
    max_requests_per_connection: int = proto.Field(
        proto.INT32,
        number=361630528,
        optional=True,
    )
    max_retries: int = proto.Field(
        proto.INT32,
        number=55546219,
        optional=True,
    )


class CloneRulesFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.CloneRules. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        source_firewall_policy (str):
            The firewall policy from which to copy rules.

            This field is a member of `oneof`_ ``_source_firewall_policy``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    source_firewall_policy: str = proto.Field(
        proto.STRING,
        number=25013549,
        optional=True,
    )


class CloneRulesNetworkFirewallPolicyRequest(proto.Message):
    r"""A request message for NetworkFirewallPolicies.CloneRules. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        source_firewall_policy (str):
            The firewall policy from which to copy rules.

            This field is a member of `oneof`_ ``_source_firewall_policy``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    source_firewall_policy: str = proto.Field(
        proto.STRING,
        number=25013549,
        optional=True,
    )


class CloneRulesRegionNetworkFirewallPolicyRequest(proto.Message):
    r"""A request message for
    RegionNetworkFirewallPolicies.CloneRules. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to update.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        source_firewall_policy (str):
            The firewall policy from which to copy rules.

            This field is a member of `oneof`_ ``_source_firewall_policy``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    source_firewall_policy: str = proto.Field(
        proto.STRING,
        number=25013549,
        optional=True,
    )


class Commitment(proto.Message):
    r"""Represents a regional resource-based commitment resource.
    Creating this commitment resource means that you are purchasing
    a resource-based committed use contract, with an explicit start
    and end time. You can purchase resource-based commitments for
    both hardware and software resources. For more information, read
    Resource-based committed use discounts


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        auto_renew (bool):
            Specifies whether to automatically renew the
            commitment at the end of its current term. The
            default value is false. If you set the field to
            true, each time your commitment reaches the end
            of its term, Compute Engine automatically renews
            it for another term. You can update this field
            anytime before the commitment expires. For
            example, if the commitment is set to expire at
            12 AM UTC-8 on January 3, 2027, you can update
            this field until 11:59 PM UTC-8 on January 2,
            2027.

            This field is a member of `oneof`_ ``_auto_renew``.
        category (str):
            The category of the commitment; specifies
            whether the commitment is for hardware or
            software resources. Category MACHINE specifies
            that you are committing to hardware machine
            resources such as VCPU or MEMORY, listed in
            resources. Category LICENSE specifies that you
            are committing to software licenses, listed in
            licenseResources. Note that if you specify
            MACHINE commitments, then you must also specify
            a type to indicate the machine series of the
            hardware resource that you are committing to.
            Check the Category enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_category``.
        creation_timestamp (str):
            [Output Only] Creation timestamp in RFC3339 text format.

            This field is a member of `oneof`_ ``_creation_timestamp``.
        custom_end_timestamp (str):
            [Input Only] Optional, specifies the requested commitment
            end time in RFC3339 text format. Use this option when the
            desired commitment's end date is later than the start date +
            term duration.

            This field is a member of `oneof`_ ``_custom_end_timestamp``.
        description (str):
            An optional description of the commitment.
            You can provide this property when you create
            the resource.

            This field is a member of `oneof`_ ``_description``.
        end_timestamp (str):
            [Output Only] Commitment end time in RFC3339 text format.

            This field is a member of `oneof`_ ``_end_timestamp``.
        existing_reservations (MutableSequence[str]):

        id (int):
            [Output Only] The unique identifier for the resource. This
            identifier is defined by the server.

            This field is a member of `oneof`_ ``_id``.
        kind (str):
            [Output Only] Type of the resource. Always
            compute#commitment for commitments.

            This field is a member of `oneof`_ ``_kind``.
        license_resource (google.cloud.compute_v1.types.LicenseResourceCommitment):
            The license specification required as part of
            a license commitment.

            This field is a member of `oneof`_ ``_license_resource``.
        merge_source_commitments (MutableSequence[str]):
            The list of source commitments that you are
            merging to create the new merged commitment. For
            more information, see Merging commitments.
        name (str):
            Name of the commitment. You must specify a name when you
            purchase the commitment. The name must be 1-63 characters
            long, and comply with RFC1035. Specifically, the name must
            be 1-63 characters long and match the regular expression
            ``[a-z]([-a-z0-9]*[a-z0-9])?`` which means the first
            character must be a lowercase letter, and all following
            characters must be a dash, lowercase letter, or digit,
            except the last character, which cannot be a dash.

            This field is a member of `oneof`_ ``_name``.
        plan (str):
            The minimum time duration that you commit to purchasing
            resources. The plan that you choose determines the preset
            term length of the commitment (which is 1 year or 3 years)
            and affects the discount rate that you receive for your
            resources. Committing to a longer time duration typically
            gives you a higher discount rate. The supported values for
            this field are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH
            (3 years). Check the Plan enum for the list of possible
            values.

            This field is a member of `oneof`_ ``_plan``.
        region (str):
            [Output Only] URL of the region where the commitment and
            committed resources are located.

            This field is a member of `oneof`_ ``_region``.
        reservations (MutableSequence[google.cloud.compute_v1.types.Reservation]):
            The list of new reservations that you want to
            create and attach to this commitment. You must
            attach reservations to your commitment if your
            commitment specifies any GPUs or Local SSD
            disks. For more information, see Attach
            reservations to resource-based commitments.
            Specify this property only if you want to create
            new reservations to attach. To attach existing
            reservations, specify the existingReservations
            property instead.
        resource_status (google.cloud.compute_v1.types.CommitmentResourceStatus):
            [Output Only] Status information for Commitment resource.

            This field is a member of `oneof`_ ``_resource_status``.
        resources (MutableSequence[google.cloud.compute_v1.types.ResourceCommitment]):
            The list of all the hardware resources, with
            their types and amounts, that you want to commit
            to. Specify as a separate entry in the list for
            each individual resource type.
        self_link (str):
            [Output Only] Server-defined URL for the resource.

            This field is a member of `oneof`_ ``_self_link``.
        split_source_commitment (str):
            The source commitment from which you are
            transferring resources to create the new split
            commitment. For more information, see Split
            commitments.

            This field is a member of `oneof`_ ``_split_source_commitment``.
        start_timestamp (str):
            [Output Only] Commitment start time in RFC3339 text format.

            This field is a member of `oneof`_ ``_start_timestamp``.
        status (str):
            [Output Only] Status of the commitment with regards to
            eventual expiration (each commitment has an end date
            defined). Status can be one of the following values:
            NOT_YET_ACTIVE, ACTIVE, or EXPIRED. Check the Status enum
            for the list of possible values.

            This field is a member of `oneof`_ ``_status``.
        status_message (str):
            [Output Only] An optional, human-readable explanation of the
            status.

            This field is a member of `oneof`_ ``_status_message``.
        type_ (str):
            The type of commitment; specifies the machine series for
            which you want to commit to purchasing resources. The choice
            of machine series affects the discount rate and the eligible
            resource types. The type must be one of the following:
            ACCELERATOR_OPTIMIZED, ACCELERATOR_OPTIMIZED_A3,
            ACCELERATOR_OPTIMIZED_A3_MEGA, COMPUTE_OPTIMIZED,
            COMPUTE_OPTIMIZED_C2D, COMPUTE_OPTIMIZED_C3,
            COMPUTE_OPTIMIZED_C3D, COMPUTE_OPTIMIZED_H3,
            GENERAL_PURPOSE, GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2,
            GENERAL_PURPOSE_N2, GENERAL_PURPOSE_N2D, GENERAL_PURPOSE_N4,
            GENERAL_PURPOSE_T2D, GRAPHICS_OPTIMIZED, MEMORY_OPTIMIZED,
            MEMORY_OPTIMIZED_M3, MEMORY_OPTIMIZED_X4,
            STORAGE_OPTIMIZED_Z3. For example, type MEMORY_OPTIMIZED
            specifies a commitment that applies only to eligible
            resources of memory optimized M1 and M2 machine series. Type
            GENERAL_PURPOSE specifies a commitment that applies only to
            eligible resources of general purpose N1 machine series.
            Check the Type enum for the list of possible values.

            This field is a member of `oneof`_ ``_type``.
    """

    class Category(proto.Enum):
        r"""The category of the commitment; specifies whether the
        commitment is for hardware or software resources. Category
        MACHINE specifies that you are committing to hardware machine
        resources such as VCPU or MEMORY, listed in resources. Category
        LICENSE specifies that you are committing to software licenses,
        listed in licenseResources. Note that if you specify MACHINE
        commitments, then you must also specify a type to indicate the
        machine series of the hardware resource that you are committing
        to.

        Values:
            UNDEFINED_CATEGORY (0):
                A value indicating that the enum field is not
                set.
            CATEGORY_UNSPECIFIED (509189462):
                No description available.
            LICENSE (347869217):
                No description available.
            MACHINE (469553191):
                No description available.
        """
        UNDEFINED_CATEGORY = 0
        CATEGORY_UNSPECIFIED = 509189462
        LICENSE = 347869217
        MACHINE = 469553191

    class Plan(proto.Enum):
        r"""The minimum time duration that you commit to purchasing resources.
        The plan that you choose determines the preset term length of the
        commitment (which is 1 year or 3 years) and affects the discount
        rate that you receive for your resources. Committing to a longer
        time duration typically gives you a higher discount rate. The
        supported values for this field are TWELVE_MONTH (1 year), and
        THIRTY_SIX_MONTH (3 years).

        Values:
            UNDEFINED_PLAN (0):
                A value indicating that the enum field is not
                set.
            INVALID (530283991):
                No description available.
            THIRTY_SIX_MONTH (266295942):
                No description available.
            TWELVE_MONTH (173083962):
                No description available.
        """
        UNDEFINED_PLAN = 0
        INVALID = 530283991
        THIRTY_SIX_MONTH = 266295942
        TWELVE_MONTH = 173083962

    class Status(proto.Enum):
        r"""[Output Only] Status of the commitment with regards to eventual
        expiration (each commitment has an end date defined). Status can be
        one of the following values: NOT_YET_ACTIVE, ACTIVE, or EXPIRED.

        Values:
            UNDEFINED_STATUS (0):
                A value indicating that the enum field is not
                set.
            ACTIVE (314733318):
                No description available.
            CANCELLED (41957681):
                Deprecate CANCELED status. Will use separate
                status to differentiate cancel by mergeCud or
                manual cancellation.
            CREATING (455564985):
                No description available.
            EXPIRED (482489093):
                No description available.
            NOT_YET_ACTIVE (20607337):
                No description available.
        """
        UNDEFINED_STATUS = 0
        ACTIVE = 314733318
        CANCELLED = 41957681
        CREATING = 455564985
        EXPIRED = 482489093
        NOT_YET_ACTIVE = 20607337

    class Type(proto.Enum):
        r"""The type of commitment; specifies the machine series for which you
        want to commit to purchasing resources. The choice of machine series
        affects the discount rate and the eligible resource types. The type
        must be one of the following: ACCELERATOR_OPTIMIZED,
        ACCELERATOR_OPTIMIZED_A3, ACCELERATOR_OPTIMIZED_A3_MEGA,
        COMPUTE_OPTIMIZED, COMPUTE_OPTIMIZED_C2D, COMPUTE_OPTIMIZED_C3,
        COMPUTE_OPTIMIZED_C3D, COMPUTE_OPTIMIZED_H3, GENERAL_PURPOSE,
        GENERAL_PURPOSE_C4, GENERAL_PURPOSE_E2, GENERAL_PURPOSE_N2,
        GENERAL_PURPOSE_N2D, GENERAL_PURPOSE_N4, GENERAL_PURPOSE_T2D,
        GRAPHICS_OPTIMIZED, MEMORY_OPTIMIZED, MEMORY_OPTIMIZED_M3,
        MEMORY_OPTIMIZED_X4, STORAGE_OPTIMIZED_Z3. For example, type
        MEMORY_OPTIMIZED specifies a commitment that applies only to
        eligible resources of memory optimized M1 and M2 machine series.
        Type GENERAL_PURPOSE specifies a commitment that applies only to
        eligible resources of general purpose N1 machine series.

        Values:
            UNDEFINED_TYPE (0):
                A value indicating that the enum field is not
                set.
            ACCELERATOR_OPTIMIZED (280848403):
                No description available.
            ACCELERATOR_OPTIMIZED_A3 (158574526):
                No description available.
            ACCELERATOR_OPTIMIZED_A3_MEGA (156517459):
                No description available.
            ACCELERATOR_OPTIMIZED_A3_ULTRA (27812811):
                No description available.
            ACCELERATOR_OPTIMIZED_A4 (158574527):
                No description available.
            COMPUTE_OPTIMIZED (158349023):
                No description available.
            COMPUTE_OPTIMIZED_C2D (383246453):
                No description available.
            COMPUTE_OPTIMIZED_C3 (428004784):
                No description available.
            COMPUTE_OPTIMIZED_C3D (383246484):
                No description available.
            COMPUTE_OPTIMIZED_H3 (428004939):
                No description available.
            GENERAL_PURPOSE (299793543):
                No description available.
            GENERAL_PURPOSE_C4 (301911817):
                No description available.
            GENERAL_PURPOSE_C4A (232460888):
                No description available.
            GENERAL_PURPOSE_E2 (301911877):
                No description available.
            GENERAL_PURPOSE_N2 (301912156):
                No description available.
            GENERAL_PURPOSE_N2D (232471400):
                No description available.
            GENERAL_PURPOSE_N4 (301912158):
                No description available.
            GENERAL_PURPOSE_T2D (232477166):
                No description available.
            GRAPHICS_OPTIMIZED (68500563):
                No description available.
            MEMORY_OPTIMIZED (281753417):
                No description available.
            MEMORY_OPTIMIZED_M3 (276301372):
                No description available.
            MEMORY_OPTIMIZED_M4 (276301373):
                No description available.
            MEMORY_OPTIMIZED_X4_16TB (183089120):
                No description available.
            MEMORY_OPTIMIZED_X4_24TB (183116989):
                No description available.
            MEMORY_OPTIMIZED_X4_32TB (183144858):
                No description available.
            STORAGE_OPTIMIZED_Z3 (316796085):
                No description available.
            TYPE_UNSPECIFIED (437714322):
                Note for internal users: When adding a new enum Type for v1,
                make sure to also add it in the comment for the
                ``optional Type type`` definition. This ensures that the
                public documentation displays the new enum Type.
        """
        UNDEFINED_TYPE = 0
        ACCELERATOR_OPTIMIZED = 280848403
        ACCELERATOR_OPTIMIZED_A3 = 158574526
        ACCELERATOR_OPTIMIZED_A3_MEGA = 156517459
        ACCELERATOR_OPTIMIZED_A3_ULTRA = 27812811
        ACCELERATOR_OPTIMIZED_A4 = 158574527
        COMPUTE_OPTIMIZED = 158349023
        COMPUTE_OPTIMIZED_C2D = 383246453
        COMPUTE_OPTIMIZED_C3 = 428004784
        COMPUTE_OPTIMIZED_C3D = 383246484
        COMPUTE_OPTIMIZED_H3 = 428004939
        GENERAL_PURPOSE = 299793543
        GENERAL_PURPOSE_C4 = 301911817
        GENERAL_PURPOSE_C4A = 232460888
        GENERAL_PURPOSE_E2 = 301911877
        GENERAL_PURPOSE_N2 = 301912156
        GENERAL_PURPOSE_N2D = 232471400
        GENERAL_PURPOSE_N4 = 301912158
        GENERAL_PURPOSE_T2D = 232477166
        GRAPHICS_OPTIMIZED = 68500563
        MEMORY_OPTIMIZED = 281753417
        MEMORY_OPTIMIZED_M3 = 276301372
        MEMORY_OPTIMIZED_M4 = 276301373
        MEMORY_OPTIMIZED_X4_16TB = 183089120
        MEMORY_OPTIMIZED_X4_24TB = 183116989
        MEMORY_OPTIMIZED_X4_32TB = 183144858
        STORAGE_OPTIMIZED_Z3 = 316796085
        TYPE_UNSPECIFIED = 437714322

    auto_renew: bool = proto.Field(
        proto.BOOL,
        number=495520765,
        optional=True,
    )
    category: str = proto.Field(
        proto.STRING,
        number=50511102,
        optional=True,
    )
    creation_timestamp: str = proto.Field(
        proto.STRING,
        number=30525366,
        optional=True,
    )
    custom_end_timestamp: str = proto.Field(
        proto.STRING,
        number=181770852,
        optional=True,
    )
    description: str = proto.Field(
        proto.STRING,
        number=422937596,
        optional=True,
    )
    end_timestamp: str = proto.Field(
        proto.STRING,
        number=468096690,
        optional=True,
    )
    existing_reservations: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=493028443,
    )
    id: int = proto.Field(
        proto.UINT64,
        number=3355,
        optional=True,
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    license_resource: "LicenseResourceCommitment" = proto.Field(
        proto.MESSAGE,
        number=437955148,
        optional=True,
        message="LicenseResourceCommitment",
    )
    merge_source_commitments: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=188093761,
    )
    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )
    plan: str = proto.Field(
        proto.STRING,
        number=3443497,
        optional=True,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
        optional=True,
    )
    reservations: MutableSequence["Reservation"] = proto.RepeatedField(
        proto.MESSAGE,
        number=399717927,
        message="Reservation",
    )
    resource_status: "CommitmentResourceStatus" = proto.Field(
        proto.MESSAGE,
        number=249429315,
        optional=True,
        message="CommitmentResourceStatus",
    )
    resources: MutableSequence["ResourceCommitment"] = proto.RepeatedField(
        proto.MESSAGE,
        number=164412965,
        message="ResourceCommitment",
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    split_source_commitment: str = proto.Field(
        proto.STRING,
        number=402611156,
        optional=True,
    )
    start_timestamp: str = proto.Field(
        proto.STRING,
        number=83645817,
        optional=True,
    )
    status: str = proto.Field(
        proto.STRING,
        number=181260274,
        optional=True,
    )
    status_message: str = proto.Field(
        proto.STRING,
        number=297428154,
        optional=True,
    )
    type_: str = proto.Field(
        proto.STRING,
        number=3575610,
        optional=True,
    )


class CommitmentAggregatedList(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableMapping[str, google.cloud.compute_v1.types.CommitmentsScopedList]):
            A list of CommitmentsScopedList resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#commitmentAggregatedList for aggregated lists of
            commitments.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        unreachables (MutableSequence[str]):
            [Output Only] Unreachable resources.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableMapping[str, "CommitmentsScopedList"] = proto.MapField(
        proto.STRING,
        proto.MESSAGE,
        number=100526016,
        message="CommitmentsScopedList",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    unreachables: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=243372063,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class CommitmentList(proto.Message):
    r"""Contains a list of Commitment resources.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        id (str):
            [Output Only] Unique identifier for the resource; defined by
            the server.

            This field is a member of `oneof`_ ``_id``.
        items (MutableSequence[google.cloud.compute_v1.types.Commitment]):
            A list of Commitment resources.
        kind (str):
            [Output Only] Type of resource. Always
            compute#commitmentList for lists of commitments.

            This field is a member of `oneof`_ ``_kind``.
        next_page_token (str):
            [Output Only] This token allows you to get the next page of
            results for list requests. If the number of results is
            larger than maxResults, use the nextPageToken as a value for
            the query parameter pageToken in the next list request.
            Subsequent list requests will have their own nextPageToken
            to continue paging through the results.

            This field is a member of `oneof`_ ``_next_page_token``.
        self_link (str):
            [Output Only] Server-defined URL for this resource.

            This field is a member of `oneof`_ ``_self_link``.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning message.

            This field is a member of `oneof`_ ``_warning``.
    """

    @property
    def raw_page(self):
        return self

    id: str = proto.Field(
        proto.STRING,
        number=3355,
        optional=True,
    )
    items: MutableSequence["Commitment"] = proto.RepeatedField(
        proto.MESSAGE,
        number=100526016,
        message="Commitment",
    )
    kind: str = proto.Field(
        proto.STRING,
        number=3292052,
        optional=True,
    )
    next_page_token: str = proto.Field(
        proto.STRING,
        number=79797525,
        optional=True,
    )
    self_link: str = proto.Field(
        proto.STRING,
        number=456214797,
        optional=True,
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class CommitmentResourceStatus(proto.Message):
    r"""[Output Only] Contains output only fields.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        custom_term_eligibility_end_timestamp (str):
            [Output Only] Indicates the end time of customer's
            eligibility to send custom term requests in RFC3339 text
            format. Term extension requests that (not the end time in
            the request) after this time will be rejected.

            This field is a member of `oneof`_ ``_custom_term_eligibility_end_timestamp``.
    """

    custom_term_eligibility_end_timestamp: str = proto.Field(
        proto.STRING,
        number=363976187,
        optional=True,
    )


class CommitmentsScopedList(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        commitments (MutableSequence[google.cloud.compute_v1.types.Commitment]):
            [Output Only] The list of commitments contained in this
            scope.
        warning (google.cloud.compute_v1.types.Warning):
            [Output Only] Informational warning which replaces the list
            of commitments when the list is empty.

            This field is a member of `oneof`_ ``_warning``.
    """

    commitments: MutableSequence["Commitment"] = proto.RepeatedField(
        proto.MESSAGE,
        number=450664446,
        message="Commitment",
    )
    warning: "Warning" = proto.Field(
        proto.MESSAGE,
        number=50704284,
        optional=True,
        message="Warning",
    )


class ConfidentialInstanceConfig(proto.Message):
    r"""A set of Confidential Instance options.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        confidential_instance_type (str):
            Defines the type of technology used by the
            confidential instance. Check the
            ConfidentialInstanceType enum for the list of
            possible values.

            This field is a member of `oneof`_ ``_confidential_instance_type``.
        enable_confidential_compute (bool):
            Defines whether the instance should have
            confidential compute enabled.

            This field is a member of `oneof`_ ``_enable_confidential_compute``.
    """

    class ConfidentialInstanceType(proto.Enum):
        r"""Defines the type of technology used by the confidential
        instance.

        Values:
            UNDEFINED_CONFIDENTIAL_INSTANCE_TYPE (0):
                A value indicating that the enum field is not
                set.
            CONFIDENTIAL_INSTANCE_TYPE_UNSPECIFIED (115021829):
                No type specified. Do not use this value.
            SEV (81988):
                AMD Secure Encrypted Virtualization.
            SEV_SNP (21753562):
                AMD Secure Encrypted Virtualization - Secure
                Nested Paging.
            TDX (82920):
                Intel Trust Domain eXtension.
        """
        UNDEFINED_CONFIDENTIAL_INSTANCE_TYPE = 0
        CONFIDENTIAL_INSTANCE_TYPE_UNSPECIFIED = 115021829
        SEV = 81988
        SEV_SNP = 21753562
        TDX = 82920

    confidential_instance_type: str = proto.Field(
        proto.STRING,
        number=43484717,
        optional=True,
    )
    enable_confidential_compute: bool = proto.Field(
        proto.BOOL,
        number=102135228,
        optional=True,
    )


class ConnectionDraining(proto.Message):
    r"""Message containing connection draining configuration.

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        draining_timeout_sec (int):
            Configures a duration timeout for existing
            requests on a removed backend instance. For
            supported load balancers and protocols, as
            described in Enabling connection draining.

            This field is a member of `oneof`_ ``_draining_timeout_sec``.
    """

    draining_timeout_sec: int = proto.Field(
        proto.INT32,
        number=225127070,
        optional=True,
    )


class ConsistentHashLoadBalancerSettings(proto.Message):
    r"""This message defines settings for a consistent hash style
    load balancer.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        http_cookie (google.cloud.compute_v1.types.ConsistentHashLoadBalancerSettingsHttpCookie):
            Hash is based on HTTP Cookie. This field describes a HTTP
            cookie that will be used as the hash key for the consistent
            hash load balancer. If the cookie is not present, it will be
            generated. This field is applicable if the sessionAffinity
            is set to HTTP_COOKIE. Not supported when the backend
            service is referenced by a URL map that is bound to target
            gRPC proxy that has validateForProxyless field set to true.

            This field is a member of `oneof`_ ``_http_cookie``.
        http_header_name (str):
            The hash based on the value of the specified header field.
            This field is applicable if the sessionAffinity is set to
            HEADER_FIELD.

            This field is a member of `oneof`_ ``_http_header_name``.
        minimum_ring_size (int):
            The minimum number of virtual nodes to use
            for the hash ring. Defaults to 1024. Larger ring
            sizes result in more granular load
            distributions. If the number of hosts in the
            load balancing pool is larger than the ring
            size, each host will be assigned a single
            virtual node.

            This field is a member of `oneof`_ ``_minimum_ring_size``.
    """

    http_cookie: "ConsistentHashLoadBalancerSettingsHttpCookie" = proto.Field(
        proto.MESSAGE,
        number=6673915,
        optional=True,
        message="ConsistentHashLoadBalancerSettingsHttpCookie",
    )
    http_header_name: str = proto.Field(
        proto.STRING,
        number=234798022,
        optional=True,
    )
    minimum_ring_size: int = proto.Field(
        proto.INT64,
        number=234380735,
        optional=True,
    )


class ConsistentHashLoadBalancerSettingsHttpCookie(proto.Message):
    r"""The information about the HTTP Cookie on which the hash
    function is based for load balancing policies that use a
    consistent hash.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        name (str):
            Name of the cookie.

            This field is a member of `oneof`_ ``_name``.
        path (str):
            Path to set for the cookie.

            This field is a member of `oneof`_ ``_path``.
        ttl (google.cloud.compute_v1.types.Duration):
            Lifetime of the cookie.

            This field is a member of `oneof`_ ``_ttl``.
    """

    name: str = proto.Field(
        proto.STRING,
        number=3373707,
        optional=True,
    )
    path: str = proto.Field(
        proto.STRING,
        number=3433509,
        optional=True,
    )
    ttl: "Duration" = proto.Field(
        proto.MESSAGE,
        number=115180,
        optional=True,
        message="Duration",
    )


class CorsPolicy(proto.Message):
    r"""The specification for allowing client-side cross-origin
    requests. For more information about the W3C recommendation for
    cross-origin resource sharing (CORS), see Fetch API Living
    Standard.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        allow_credentials (bool):
            In response to a preflight request, setting
            this to true indicates that the actual request
            can include user credentials. This field
            translates to the
            Access-Control-Allow-Credentials header. Default
            is false.

            This field is a member of `oneof`_ ``_allow_credentials``.
        allow_headers (MutableSequence[str]):
            Specifies the content for the
            Access-Control-Allow-Headers header.
        allow_methods (MutableSequence[str]):
            Specifies the content for the
            Access-Control-Allow-Methods header.
        allow_origin_regexes (MutableSequence[str]):
            Specifies a regular expression that matches allowed origins.
            For more information, see regular expression syntax . An
            origin is allowed if it matches either an item in
            allowOrigins or an item in allowOriginRegexes. Regular
            expressions can only be used when the loadBalancingScheme is
            set to INTERNAL_SELF_MANAGED.
        allow_origins (MutableSequence[str]):
            Specifies the list of origins that is allowed
            to do CORS requests. An origin is allowed if it
            matches either an item in allowOrigins or an
            item in allowOriginRegexes.
        disabled (bool):
            If true, disables the CORS policy. The
            default value is false, which indicates that the
            CORS policy is in effect.

            This field is a member of `oneof`_ ``_disabled``.
        expose_headers (MutableSequence[str]):
            Specifies the content for the
            Access-Control-Expose-Headers header.
        max_age (int):
            Specifies how long results of a preflight
            request can be cached in seconds. This field
            translates to the Access-Control-Max-Age header.

            This field is a member of `oneof`_ ``_max_age``.
    """

    allow_credentials: bool = proto.Field(
        proto.BOOL,
        number=481263366,
        optional=True,
    )
    allow_headers: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=45179024,
    )
    allow_methods: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=205405372,
    )
    allow_origin_regexes: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=215385810,
    )
    allow_origins: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=194914071,
    )
    disabled: bool = proto.Field(
        proto.BOOL,
        number=270940796,
        optional=True,
    )
    expose_headers: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=247604747,
    )
    max_age: int = proto.Field(
        proto.INT32,
        number=307559332,
        optional=True,
    )


class CreateInstancesInstanceGroupManagerRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.CreateInstances.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group. It
            should conform to RFC1035.
        instance_group_managers_create_instances_request_resource (google.cloud.compute_v1.types.InstanceGroupManagersCreateInstancesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. The request ID must be a valid UUID
            with the exception that zero UUID is not
            supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the managed
            instance group is located. It should conform to
            RFC1035.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    instance_group_managers_create_instances_request_resource: "InstanceGroupManagersCreateInstancesRequest" = proto.Field(
        proto.MESSAGE,
        number=24558867,
        message="InstanceGroupManagersCreateInstancesRequest",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class CreateInstancesRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    RegionInstanceGroupManagers.CreateInstances. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group. It
            should conform to RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region where the managed
            instance group is located. It should conform to
            RFC1035.
        region_instance_group_managers_create_instances_request_resource (google.cloud.compute_v1.types.RegionInstanceGroupManagersCreateInstancesRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. The request ID must be a valid UUID
            with the exception that zero UUID is not
            supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    region_instance_group_managers_create_instances_request_resource: "RegionInstanceGroupManagersCreateInstancesRequest" = proto.Field(
        proto.MESSAGE,
        number=359014280,
        message="RegionInstanceGroupManagersCreateInstancesRequest",
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class CreateSnapshotDiskRequest(proto.Message):
    r"""A request message for Disks.CreateSnapshot. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        disk (str):
            Name of the persistent disk to snapshot.
        guest_flush (bool):
            [Input Only] Whether to attempt an application consistent
            snapshot by informing the OS to prepare for the snapshot
            process.

            This field is a member of `oneof`_ ``_guest_flush``.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        snapshot_resource (google.cloud.compute_v1.types.Snapshot):
            The body resource for this request
        zone (str):
            The name of the zone for this request.
    """

    disk: str = proto.Field(
        proto.STRING,
        number=3083677,
    )
    guest_flush: bool = proto.Field(
        proto.BOOL,
        number=385550813,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    snapshot_resource: "Snapshot" = proto.Field(
        proto.MESSAGE,
        number=481319977,
        message="Snapshot",
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class CreateSnapshotRegionDiskRequest(proto.Message):
    r"""A request message for RegionDisks.CreateSnapshot. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        disk (str):
            Name of the regional persistent disk to
            snapshot.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        snapshot_resource (google.cloud.compute_v1.types.Snapshot):
            The body resource for this request
    """

    disk: str = proto.Field(
        proto.STRING,
        number=3083677,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    snapshot_resource: "Snapshot" = proto.Field(
        proto.MESSAGE,
        number=481319977,
        message="Snapshot",
    )


class CustomErrorResponsePolicy(proto.Message):
    r"""Specifies the custom error response policy that must be
    applied when the backend service or backend bucket responds with
    an error.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        error_response_rules (MutableSequence[google.cloud.compute_v1.types.CustomErrorResponsePolicyCustomErrorResponseRule]):
            Specifies rules for returning error
            responses. In a given policy, if you specify
            rules for both a range of error codes as well as
            rules for specific error codes then rules with
            specific error codes have a higher priority. For
            example, assume that you configure a rule for
            401 (Un-authorized) code, and another for all 4
            series error codes (4XX). If the backend service
            returns a 401, then the rule for 401 will be
            applied. However if the backend service returns
            a 403, the rule for 4xx takes effect.
        error_service (str):
            The full or partial URL to the BackendBucket resource that
            contains the custom error content. Examples are: -
            https://www.googleapis.com/compute/v1/projects/project/global/backendBuckets/myBackendBucket
            -
            compute/v1/projects/project/global/backendBuckets/myBackendBucket
            - global/backendBuckets/myBackendBucket If errorService is
            not specified at lower levels like pathMatcher, pathRule and
            routeRule, an errorService specified at a higher level in
            the UrlMap will be used. If
            UrlMap.defaultCustomErrorResponsePolicy contains one or more
            errorResponseRules[], it must specify errorService. If load
            balancer cannot reach the backendBucket, a simple Not Found
            Error will be returned, with the original response code (or
            overrideResponseCode if configured). errorService is not
            supported for internal or regional HTTP/HTTPS load
            balancers.

            This field is a member of `oneof`_ ``_error_service``.
    """

    error_response_rules: MutableSequence[
        "CustomErrorResponsePolicyCustomErrorResponseRule"
    ] = proto.RepeatedField(
        proto.MESSAGE,
        number=14620304,
        message="CustomErrorResponsePolicyCustomErrorResponseRule",
    )
    error_service: str = proto.Field(
        proto.STRING,
        number=164214654,
        optional=True,
    )


class CustomErrorResponsePolicyCustomErrorResponseRule(proto.Message):
    r"""Specifies the mapping between the response code that will be
    returned along with the custom error content and the response
    code returned by the backend service.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        match_response_codes (MutableSequence[str]):
            Valid values include: - A number between 400
            and 599: For example 401 or 503, in which case
            the load balancer applies the policy if the
            error code exactly matches this value. - 5xx:
            Load Balancer will apply the policy if the
            backend service responds with any response code
            in the range of 500 to 599. - 4xx: Load Balancer
            will apply the policy if the backend service
            responds with any response code in the range of
            400 to 499. Values must be unique within
            matchResponseCodes and across all
            errorResponseRules of CustomErrorResponsePolicy.
        override_response_code (int):
            The HTTP status code returned with the
            response containing the custom error content. If
            overrideResponseCode is not supplied, the same
            response code returned by the original backend
            bucket or backend service is returned to the
            client.

            This field is a member of `oneof`_ ``_override_response_code``.
        path (str):
            The full path to a file within backendBucket
            . For example: /errors/defaultError.html path
            must start with a leading slash. path cannot
            have trailing slashes. If the file is not
            available in backendBucket or the load balancer
            cannot reach the BackendBucket, a simple Not
            Found Error is returned to the client. The value
            must be from 1 to 1024 characters

            This field is a member of `oneof`_ ``_path``.
    """

    match_response_codes: MutableSequence[str] = proto.RepeatedField(
        proto.STRING,
        number=104973410,
    )
    override_response_code: int = proto.Field(
        proto.INT32,
        number=530328568,
        optional=True,
    )
    path: str = proto.Field(
        proto.STRING,
        number=3433509,
        optional=True,
    )


class CustomerEncryptionKey(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        kms_key_name (str):
            The name of the encryption key that is stored in Google
            Cloud KMS. For example: "kmsKeyName":
            "projects/kms_project_id/locations/region/keyRings/
            key_region/cryptoKeys/key The fully-qualifed key name may be
            returned for resource GET requests. For example:
            "kmsKeyName":
            "projects/kms_project_id/locations/region/keyRings/
            key_region/cryptoKeys/key /cryptoKeyVersions/1

            This field is a member of `oneof`_ ``_kms_key_name``.
        kms_key_service_account (str):
            The service account being used for the encryption request
            for the given KMS key. If absent, the Compute Engine default
            service account is used. For example:
            "kmsKeyServiceAccount":
            "name@project_id.iam.gserviceaccount.com/

            This field is a member of `oneof`_ ``_kms_key_service_account``.
        raw_key (str):
            Specifies a 256-bit customer-supplied
            encryption key, encoded in RFC 4648 base64 to
            either encrypt or decrypt this resource. You can
            provide either the rawKey or the
            rsaEncryptedKey. For example: "rawKey":
            "SGVsbG8gZnJvbSBHb29nbGUgQ2xvdWQgUGxhdGZvcm0=".

            This field is a member of `oneof`_ ``_raw_key``.
        rsa_encrypted_key (str):
            Specifies an RFC 4648 base64 encoded,
            RSA-wrapped 2048-bit customer-supplied
            encryption key to either encrypt or decrypt this
            resource. You can provide either the rawKey or
            the rsaEncryptedKey. For example:
            "rsaEncryptedKey":
            "ieCx/NcW06PcT7Ep1X6LUTc/hLvUDYyzSZPPVCVPTVEohpeHASqC8uw5TzyO9U+Fka9JFH
            z0mBibXUInrC/jEk014kCK/NPjYgEMOyssZ4ZINPKxlUh2zn1bV+MCaTICrdmuSBTWlUUiFoD
            D6PYznLwh8ZNdaheCeZ8ewEXgFQ8V+sDroLaN3Xs3MDTXQEMMoNUXMCZEIpg9Vtp9x2oe=="
            The key must meet the following requirements
            before you can provide it to Compute Engine: 1.
            The key is wrapped using a RSA public key
            certificate provided by Google. 2. After being
            wrapped, the key must be encoded in RFC 4648
            base64 encoding. Gets the RSA public key
            certificate provided by Google at:
            https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem

            This field is a member of `oneof`_ ``_rsa_encrypted_key``.
        sha256 (str):
            [Output only] The RFC 4648 base64 encoded SHA-256 hash of
            the customer-supplied encryption key that protects this
            resource.

            This field is a member of `oneof`_ ``_sha256``.
    """

    kms_key_name: str = proto.Field(
        proto.STRING,
        number=484373913,
        optional=True,
    )
    kms_key_service_account: str = proto.Field(
        proto.STRING,
        number=209986261,
        optional=True,
    )
    raw_key: str = proto.Field(
        proto.STRING,
        number=449196488,
        optional=True,
    )
    rsa_encrypted_key: str = proto.Field(
        proto.STRING,
        number=335487397,
        optional=True,
    )
    sha256: str = proto.Field(
        proto.STRING,
        number=170112551,
        optional=True,
    )


class CustomerEncryptionKeyProtectedDisk(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        disk_encryption_key (google.cloud.compute_v1.types.CustomerEncryptionKey):
            Decrypts data associated with the disk with a
            customer-supplied encryption key.

            This field is a member of `oneof`_ ``_disk_encryption_key``.
        source (str):
            Specifies a valid partial or full URL to an existing
            Persistent Disk resource. This field is only applicable for
            persistent disks. For example: "source":
            "/compute/v1/projects/project_id/zones/zone/disks/ disk_name

            This field is a member of `oneof`_ ``_source``.
    """

    disk_encryption_key: "CustomerEncryptionKey" = proto.Field(
        proto.MESSAGE,
        number=271660677,
        optional=True,
        message="CustomerEncryptionKey",
    )
    source: str = proto.Field(
        proto.STRING,
        number=177235995,
        optional=True,
    )


class Data(proto.Message):
    r"""

    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        key (str):
            [Output Only] A key that provides more detail on the warning
            being returned. For example, for warnings where there are no
            results in a list request for a particular zone, this key
            might be scope and the key value might be the zone name.
            Other examples might be a key indicating a deprecated
            resource and a suggested replacement, or a warning about
            invalid network settings (for example, if an instance
            attempts to perform IP forwarding but is not enabled for IP
            forwarding).

            This field is a member of `oneof`_ ``_key``.
        value (str):
            [Output Only] A warning data value corresponding to the key.

            This field is a member of `oneof`_ ``_value``.
    """

    key: str = proto.Field(
        proto.STRING,
        number=106079,
        optional=True,
    )
    value: str = proto.Field(
        proto.STRING,
        number=111972721,
        optional=True,
    )


class DeleteAccessConfigInstanceRequest(proto.Message):
    r"""A request message for Instances.DeleteAccessConfig. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        access_config (str):
            The name of the access config to delete.
        instance (str):
            The instance name for this request.
        network_interface (str):
            The name of the network interface.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    access_config: str = proto.Field(
        proto.STRING,
        number=72856189,
    )
    instance: str = proto.Field(
        proto.STRING,
        number=18257045,
    )
    network_interface: str = proto.Field(
        proto.STRING,
        number=365387880,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteAddressRequest(proto.Message):
    r"""A request message for Addresses.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        address (str):
            Name of the address resource to delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    address: str = proto.Field(
        proto.STRING,
        number=462920692,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteAutoscalerRequest(proto.Message):
    r"""A request message for Autoscalers.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        autoscaler (str):
            Name of the autoscaler to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            Name of the zone for this request.
    """

    autoscaler: str = proto.Field(
        proto.STRING,
        number=517258967,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteBackendBucketRequest(proto.Message):
    r"""A request message for BackendBuckets.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        backend_bucket (str):
            Name of the BackendBucket resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_bucket: str = proto.Field(
        proto.STRING,
        number=91714037,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteBackendServiceRequest(proto.Message):
    r"""A request message for BackendServices.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        backend_service (str):
            Name of the BackendService resource to
            delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_service: str = proto.Field(
        proto.STRING,
        number=306946058,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteDiskRequest(proto.Message):
    r"""A request message for Disks.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        disk (str):
            Name of the persistent disk to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    disk: str = proto.Field(
        proto.STRING,
        number=3083677,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteExternalVpnGatewayRequest(proto.Message):
    r"""A request message for ExternalVpnGateways.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        external_vpn_gateway (str):
            Name of the externalVpnGateways to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    external_vpn_gateway: str = proto.Field(
        proto.STRING,
        number=109898629,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteFirewallPolicyRequest(proto.Message):
    r"""A request message for FirewallPolicies.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to delete.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteFirewallRequest(proto.Message):
    r"""A request message for Firewalls.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall (str):
            Name of the firewall rule to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall: str = proto.Field(
        proto.STRING,
        number=511016192,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteForwardingRuleRequest(proto.Message):
    r"""A request message for ForwardingRules.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        forwarding_rule (str):
            Name of the ForwardingRule resource to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    forwarding_rule: str = proto.Field(
        proto.STRING,
        number=269964030,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteGlobalAddressRequest(proto.Message):
    r"""A request message for GlobalAddresses.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        address (str):
            Name of the address resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    address: str = proto.Field(
        proto.STRING,
        number=462920692,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteGlobalForwardingRuleRequest(proto.Message):
    r"""A request message for GlobalForwardingRules.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        forwarding_rule (str):
            Name of the ForwardingRule resource to
            delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    forwarding_rule: str = proto.Field(
        proto.STRING,
        number=269964030,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteGlobalNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for GlobalNetworkEndpointGroups.Delete. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group to
            delete. It should comply with RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network_endpoint_group: str = proto.Field(
        proto.STRING,
        number=433907078,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteGlobalOperationRequest(proto.Message):
    r"""A request message for GlobalOperations.Delete. See the method
    description for details.

    Attributes:
        operation (str):
            Name of the Operations resource to delete, or
            its unique numeric identifier.
        project (str):
            Project ID for this request.
    """

    operation: str = proto.Field(
        proto.STRING,
        number=52090215,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )


class DeleteGlobalOperationResponse(proto.Message):
    r"""A response message for GlobalOperations.Delete. See the
    method description for details.

    """


class DeleteGlobalOrganizationOperationRequest(proto.Message):
    r"""A request message for GlobalOrganizationOperations.Delete.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        operation (str):
            Name of the Operations resource to delete, or
            its unique numeric identifier.
        parent_id (str):
            Parent ID for this request.

            This field is a member of `oneof`_ ``_parent_id``.
    """

    operation: str = proto.Field(
        proto.STRING,
        number=52090215,
    )
    parent_id: str = proto.Field(
        proto.STRING,
        number=459714768,
        optional=True,
    )


class DeleteGlobalOrganizationOperationResponse(proto.Message):
    r"""A response message for GlobalOrganizationOperations.Delete.
    See the method description for details.

    """


class DeleteGlobalPublicDelegatedPrefixeRequest(proto.Message):
    r"""A request message for GlobalPublicDelegatedPrefixes.Delete.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        public_delegated_prefix (str):
            Name of the PublicDelegatedPrefix resource to
            delete.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    public_delegated_prefix: str = proto.Field(
        proto.STRING,
        number=204238440,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteHealthCheckRequest(proto.Message):
    r"""A request message for HealthChecks.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        health_check (str):
            Name of the HealthCheck resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    health_check: str = proto.Field(
        proto.STRING,
        number=308876645,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteImageRequest(proto.Message):
    r"""A request message for Images.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        image (str):
            Name of the image resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    image: str = proto.Field(
        proto.STRING,
        number=100313435,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteInstanceGroupManagerRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group to
            delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the managed
            instance group is located.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteInstanceGroupManagerResizeRequestRequest(proto.Message):
    r"""A request message for
    InstanceGroupManagerResizeRequests.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group. The
            name should conform to RFC1035 or be a resource
            ID.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        resize_request (str):
            The name of the resize request to delete. The
            name should conform to RFC1035 or be a resource
            ID.
        zone (str):
            The name of the zone where the managed
            instance group is located. The name should
            conform to RFC1035.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    resize_request: str = proto.Field(
        proto.STRING,
        number=216941060,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteInstanceGroupRequest(proto.Message):
    r"""A request message for InstanceGroups.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group (str):
            The name of the instance group to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the instance group
            is located.
    """

    instance_group: str = proto.Field(
        proto.STRING,
        number=81095253,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteInstanceRequest(proto.Message):
    r"""A request message for Instances.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance (str):
            Name of the instance resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    instance: str = proto.Field(
        proto.STRING,
        number=18257045,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteInstanceTemplateRequest(proto.Message):
    r"""A request message for InstanceTemplates.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_template (str):
            The name of the instance template to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_template: str = proto.Field(
        proto.STRING,
        number=309248228,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteInstancesInstanceGroupManagerRequest(proto.Message):
    r"""A request message for InstanceGroupManagers.DeleteInstances.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group.
        instance_group_managers_delete_instances_request_resource (google.cloud.compute_v1.types.InstanceGroupManagersDeleteInstancesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the managed
            instance group is located.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    instance_group_managers_delete_instances_request_resource: "InstanceGroupManagersDeleteInstancesRequest" = proto.Field(
        proto.MESSAGE,
        number=166421252,
        message="InstanceGroupManagersDeleteInstancesRequest",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteInstancesRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    RegionInstanceGroupManagers.DeleteInstances. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            Name of the managed instance group.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        region_instance_group_managers_delete_instances_request_resource (google.cloud.compute_v1.types.RegionInstanceGroupManagersDeleteInstancesRequest):
            The body resource for this request
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    region_instance_group_managers_delete_instances_request_resource: "RegionInstanceGroupManagersDeleteInstancesRequest" = proto.Field(
        proto.MESSAGE,
        number=500876665,
        message="RegionInstanceGroupManagersDeleteInstancesRequest",
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteInstantSnapshotRequest(proto.Message):
    r"""A request message for InstantSnapshots.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instant_snapshot (str):
            Name of the InstantSnapshot resource to
            delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    instant_snapshot: str = proto.Field(
        proto.STRING,
        number=391638626,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteInterconnectAttachmentRequest(proto.Message):
    r"""A request message for InterconnectAttachments.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        interconnect_attachment (str):
            Name of the interconnect attachment to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    interconnect_attachment: str = proto.Field(
        proto.STRING,
        number=308135284,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteInterconnectRequest(proto.Message):
    r"""A request message for Interconnects.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        interconnect (str):
            Name of the interconnect to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    interconnect: str = proto.Field(
        proto.STRING,
        number=224601230,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteLicenseRequest(proto.Message):
    r"""A request message for Licenses.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        license_ (str):
            Name of the license resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    license_: str = proto.Field(
        proto.STRING,
        number=166757441,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteMachineImageRequest(proto.Message):
    r"""A request message for MachineImages.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        machine_image (str):
            The name of the machine image to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    machine_image: str = proto.Field(
        proto.STRING,
        number=69189475,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteNetworkAttachmentRequest(proto.Message):
    r"""A request message for NetworkAttachments.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        network_attachment (str):
            Name of the NetworkAttachment resource to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region of this request.
        request_id (str):
            An optional request ID to identify requests. Specify a
            unique request ID so that if you must retry your request,
            the server will know to ignore the request if it has already
            been completed. For example, consider a situation where you
            make an initial request and the request times out. If you
            make the request again with the same request ID, the server
            can check if original operation with the same request ID was
            received, and if so, will ignore the second request. This
            prevents clients from accidentally creating duplicate
            commitments. The request ID must be a valid UUID with the
            exception that zero UUID is not supported (
            00000000-0000-0000-0000-000000000000). end_interface:
            MixerMutationRequestBuilder

            This field is a member of `oneof`_ ``_request_id``.
    """

    network_attachment: str = proto.Field(
        proto.STRING,
        number=224644052,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteNetworkEdgeSecurityServiceRequest(proto.Message):
    r"""A request message for NetworkEdgeSecurityServices.Delete. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        network_edge_security_service (str):
            Name of the network edge security service to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network_edge_security_service: str = proto.Field(
        proto.STRING,
        number=157011879,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for NetworkEndpointGroups.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group to
            delete. It should comply with RFC1035.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone where the network
            endpoint group is located. It should comply with
            RFC1035.
    """

    network_endpoint_group: str = proto.Field(
        proto.STRING,
        number=433907078,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteNetworkFirewallPolicyRequest(proto.Message):
    r"""A request message for NetworkFirewallPolicies.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteNetworkRequest(proto.Message):
    r"""A request message for Networks.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        network (str):
            Name of the network to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network: str = proto.Field(
        proto.STRING,
        number=232872494,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteNodeGroupRequest(proto.Message):
    r"""A request message for NodeGroups.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        node_group (str):
            Name of the NodeGroup resource to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    node_group: str = proto.Field(
        proto.STRING,
        number=469958146,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteNodeTemplateRequest(proto.Message):
    r"""A request message for NodeTemplates.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        node_template (str):
            Name of the NodeTemplate resource to delete.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    node_template: str = proto.Field(
        proto.STRING,
        number=323154455,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteNodesNodeGroupRequest(proto.Message):
    r"""A request message for NodeGroups.DeleteNodes. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        node_group (str):
            Name of the NodeGroup resource whose nodes
            will be deleted.
        node_groups_delete_nodes_request_resource (google.cloud.compute_v1.types.NodeGroupsDeleteNodesRequest):
            The body resource for this request
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        zone (str):
            The name of the zone for this request.
    """

    node_group: str = proto.Field(
        proto.STRING,
        number=469958146,
    )
    node_groups_delete_nodes_request_resource: "NodeGroupsDeleteNodesRequest" = (
        proto.Field(
            proto.MESSAGE,
            number=183298962,
            message="NodeGroupsDeleteNodesRequest",
        )
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeletePacketMirroringRequest(proto.Message):
    r"""A request message for PacketMirrorings.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        packet_mirroring (str):
            Name of the PacketMirroring resource to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    packet_mirroring: str = proto.Field(
        proto.STRING,
        number=22305996,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeletePerInstanceConfigsInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    InstanceGroupManagers.DeletePerInstanceConfigs. See the method
    description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group. It
            should conform to RFC1035.
        instance_group_managers_delete_per_instance_configs_req_resource (google.cloud.compute_v1.types.InstanceGroupManagersDeletePerInstanceConfigsReq):
            The body resource for this request
        project (str):
            Project ID for this request.
        zone (str):
            The name of the zone where the managed
            instance group is located. It should conform to
            RFC1035.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    instance_group_managers_delete_per_instance_configs_req_resource: "InstanceGroupManagersDeletePerInstanceConfigsReq" = proto.Field(
        proto.MESSAGE,
        number=362427680,
        message="InstanceGroupManagersDeletePerInstanceConfigsReq",
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeletePerInstanceConfigsRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for
    RegionInstanceGroupManagers.DeletePerInstanceConfigs. See the
    method description for details.

    Attributes:
        instance_group_manager (str):
            The name of the managed instance group. It
            should conform to RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request,
            should conform to RFC1035.
        region_instance_group_manager_delete_instance_config_req_resource (google.cloud.compute_v1.types.RegionInstanceGroupManagerDeleteInstanceConfigReq):
            The body resource for this request
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    region_instance_group_manager_delete_instance_config_req_resource: "RegionInstanceGroupManagerDeleteInstanceConfigReq" = proto.Field(
        proto.MESSAGE,
        number=740741,
        message="RegionInstanceGroupManagerDeleteInstanceConfigReq",
    )


class DeletePublicAdvertisedPrefixeRequest(proto.Message):
    r"""A request message for PublicAdvertisedPrefixes.Delete. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        public_advertised_prefix (str):
            Name of the PublicAdvertisedPrefix resource
            to delete.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    public_advertised_prefix: str = proto.Field(
        proto.STRING,
        number=101874590,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeletePublicDelegatedPrefixeRequest(proto.Message):
    r"""A request message for PublicDelegatedPrefixes.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        public_delegated_prefix (str):
            Name of the PublicDelegatedPrefix resource to
            delete.
        region (str):
            Name of the region of this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    public_delegated_prefix: str = proto.Field(
        proto.STRING,
        number=204238440,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionAutoscalerRequest(proto.Message):
    r"""A request message for RegionAutoscalers.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        autoscaler (str):
            Name of the autoscaler to delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    autoscaler: str = proto.Field(
        proto.STRING,
        number=517258967,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionBackendServiceRequest(proto.Message):
    r"""A request message for RegionBackendServices.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        backend_service (str):
            Name of the BackendService resource to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_service: str = proto.Field(
        proto.STRING,
        number=306946058,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionDiskRequest(proto.Message):
    r"""A request message for RegionDisks.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        disk (str):
            Name of the regional persistent disk to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    disk: str = proto.Field(
        proto.STRING,
        number=3083677,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionHealthCheckRequest(proto.Message):
    r"""A request message for RegionHealthChecks.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        health_check (str):
            Name of the HealthCheck resource to delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    health_check: str = proto.Field(
        proto.STRING,
        number=308876645,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionHealthCheckServiceRequest(proto.Message):
    r"""A request message for RegionHealthCheckServices.Delete. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        health_check_service (str):
            Name of the HealthCheckService to delete. The
            name must be 1-63 characters long, and comply
            with RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    health_check_service: str = proto.Field(
        proto.STRING,
        number=408374747,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionInstanceGroupManagerRequest(proto.Message):
    r"""A request message for RegionInstanceGroupManagers.Delete. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_group_manager (str):
            Name of the managed instance group to delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_group_manager: str = proto.Field(
        proto.STRING,
        number=249363395,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionInstanceTemplateRequest(proto.Message):
    r"""A request message for RegionInstanceTemplates.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instance_template (str):
            The name of the instance template to delete.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instance_template: str = proto.Field(
        proto.STRING,
        number=309248228,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionInstantSnapshotRequest(proto.Message):
    r"""A request message for RegionInstantSnapshots.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        instant_snapshot (str):
            Name of the InstantSnapshot resource to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    instant_snapshot: str = proto.Field(
        proto.STRING,
        number=391638626,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionNetworkEndpointGroupRequest(proto.Message):
    r"""A request message for RegionNetworkEndpointGroups.Delete. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        network_endpoint_group (str):
            The name of the network endpoint group to
            delete. It should comply with RFC1035.
        project (str):
            Project ID for this request.
        region (str):
            The name of the region where the network
            endpoint group is located. It should comply with
            RFC1035.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    network_endpoint_group: str = proto.Field(
        proto.STRING,
        number=433907078,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionNetworkFirewallPolicyRequest(proto.Message):
    r"""A request message for RegionNetworkFirewallPolicies.Delete.
    See the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        firewall_policy (str):
            Name of the firewall policy to delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    firewall_policy: str = proto.Field(
        proto.STRING,
        number=498173265,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionNotificationEndpointRequest(proto.Message):
    r"""A request message for RegionNotificationEndpoints.Delete. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        notification_endpoint (str):
            Name of the NotificationEndpoint resource to
            delete.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    notification_endpoint: str = proto.Field(
        proto.STRING,
        number=376807017,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteRegionOperationRequest(proto.Message):
    r"""A request message for RegionOperations.Delete. See the method
    description for details.

    Attributes:
        operation (str):
            Name of the Operations resource to delete, or
            its unique numeric identifier.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
    """

    operation: str = proto.Field(
        proto.STRING,
        number=52090215,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )


class DeleteRegionOperationResponse(proto.Message):
    r"""A response message for RegionOperations.Delete. See the
    method description for details.

    """


class DeleteRegionSecurityPolicyRequest(proto.Message):
    r"""A request message for RegionSecurityPolicies.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        security_policy (str):
            Name of the security policy to delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    security_policy: str = proto.Field(
        proto.STRING,
        number=171082513,
    )


class DeleteRegionSslCertificateRequest(proto.Message):
    r"""A request message for RegionSslCertificates.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        ssl_certificate (str):
            Name of the SslCertificate resource to
            delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    ssl_certificate: str = proto.Field(
        proto.STRING,
        number=46443492,
    )


class DeleteRegionSslPolicyRequest(proto.Message):
    r"""A request message for RegionSslPolicies.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        ssl_policy (str):
            Name of the SSL policy to delete. The name
            must be 1-63 characters long, and comply with
            RFC1035.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    ssl_policy: str = proto.Field(
        proto.STRING,
        number=295190213,
    )


class DeleteRegionTargetHttpProxyRequest(proto.Message):
    r"""A request message for RegionTargetHttpProxies.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_http_proxy (str):
            Name of the TargetHttpProxy resource to
            delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    target_http_proxy: str = proto.Field(
        proto.STRING,
        number=206872421,
    )


class DeleteRegionTargetHttpsProxyRequest(proto.Message):
    r"""A request message for RegionTargetHttpsProxies.Delete. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_https_proxy (str):
            Name of the TargetHttpsProxy resource to
            delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    target_https_proxy: str = proto.Field(
        proto.STRING,
        number=52336748,
    )


class DeleteRegionTargetTcpProxyRequest(proto.Message):
    r"""A request message for RegionTargetTcpProxies.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_tcp_proxy (str):
            Name of the TargetTcpProxy resource to
            delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    target_tcp_proxy: str = proto.Field(
        proto.STRING,
        number=503065442,
    )


class DeleteRegionUrlMapRequest(proto.Message):
    r"""A request message for RegionUrlMaps.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            begin_interface: MixerMutationRequestBuilder Request ID to
            support idempotency.

            This field is a member of `oneof`_ ``_request_id``.
        url_map (str):
            Name of the UrlMap resource to delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    url_map: str = proto.Field(
        proto.STRING,
        number=367020684,
    )


class DeleteReservationRequest(proto.Message):
    r"""A request message for Reservations.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        reservation (str):
            Name of the reservation to delete.
        zone (str):
            Name of the zone for this request.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    reservation: str = proto.Field(
        proto.STRING,
        number=47530956,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteResourcePolicyRequest(proto.Message):
    r"""A request message for ResourcePolicies.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        resource_policy (str):
            Name of the resource policy to delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    resource_policy: str = proto.Field(
        proto.STRING,
        number=159240835,
    )


class DeleteRoutePolicyRouterRequest(proto.Message):
    r"""A request message for Routers.DeleteRoutePolicy. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        policy (str):
            The Policy name for this request. Name must
            conform to RFC1035

            This field is a member of `oneof`_ ``_policy``.
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        router (str):
            Name of the Router resource where Route
            Policy is defined.
    """

    policy: str = proto.Field(
        proto.STRING,
        number=91071794,
        optional=True,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    router: str = proto.Field(
        proto.STRING,
        number=148608841,
    )


class DeleteRouteRequest(proto.Message):
    r"""A request message for Routes.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        route (str):
            Name of the Route resource to delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    route: str = proto.Field(
        proto.STRING,
        number=108704329,
    )


class DeleteRouterRequest(proto.Message):
    r"""A request message for Routers.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        router (str):
            Name of the Router resource to delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    router: str = proto.Field(
        proto.STRING,
        number=148608841,
    )


class DeleteSecurityPolicyRequest(proto.Message):
    r"""A request message for SecurityPolicies.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        security_policy (str):
            Name of the security policy to delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    security_policy: str = proto.Field(
        proto.STRING,
        number=171082513,
    )


class DeleteServiceAttachmentRequest(proto.Message):
    r"""A request message for ServiceAttachments.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region of this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        service_attachment (str):
            Name of the ServiceAttachment resource to
            delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    service_attachment: str = proto.Field(
        proto.STRING,
        number=338957549,
    )


class DeleteSignedUrlKeyBackendBucketRequest(proto.Message):
    r"""A request message for BackendBuckets.DeleteSignedUrlKey. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        backend_bucket (str):
            Name of the BackendBucket resource to which
            the Signed URL Key should be added. The name
            should conform to RFC1035.
        key_name (str):
            The name of the Signed URL Key to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_bucket: str = proto.Field(
        proto.STRING,
        number=91714037,
    )
    key_name: str = proto.Field(
        proto.STRING,
        number=500938859,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteSignedUrlKeyBackendServiceRequest(proto.Message):
    r"""A request message for BackendServices.DeleteSignedUrlKey. See
    the method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        backend_service (str):
            Name of the BackendService resource to which
            the Signed URL Key should be added. The name
            should conform to RFC1035.
        key_name (str):
            The name of the Signed URL Key to delete.
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
    """

    backend_service: str = proto.Field(
        proto.STRING,
        number=306946058,
    )
    key_name: str = proto.Field(
        proto.STRING,
        number=500938859,
    )
    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )


class DeleteSnapshotRequest(proto.Message):
    r"""A request message for Snapshots.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        snapshot (str):
            Name of the Snapshot resource to delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    snapshot: str = proto.Field(
        proto.STRING,
        number=284874180,
    )


class DeleteSslCertificateRequest(proto.Message):
    r"""A request message for SslCertificates.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        ssl_certificate (str):
            Name of the SslCertificate resource to
            delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    ssl_certificate: str = proto.Field(
        proto.STRING,
        number=46443492,
    )


class DeleteSslPolicyRequest(proto.Message):
    r"""A request message for SslPolicies.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        ssl_policy (str):
            Name of the SSL policy to delete. The name
            must be 1-63 characters long, and comply with
            RFC1035.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    ssl_policy: str = proto.Field(
        proto.STRING,
        number=295190213,
    )


class DeleteStoragePoolRequest(proto.Message):
    r"""A request message for StoragePools.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        storage_pool (str):
            Name of the storage pool to delete.
        zone (str):
            The name of the zone for this request.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    storage_pool: str = proto.Field(
        proto.STRING,
        number=360473440,
    )
    zone: str = proto.Field(
        proto.STRING,
        number=3744684,
    )


class DeleteSubnetworkRequest(proto.Message):
    r"""A request message for Subnetworks.Delete. See the method
    description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        region (str):
            Name of the region scoping this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        subnetwork (str):
            Name of the Subnetwork resource to delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    region: str = proto.Field(
        proto.STRING,
        number=138946292,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    subnetwork: str = proto.Field(
        proto.STRING,
        number=307827694,
    )


class DeleteTargetGrpcProxyRequest(proto.Message):
    r"""A request message for TargetGrpcProxies.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
            00000000-0000-0000-0000-000000000000).

            This field is a member of `oneof`_ ``_request_id``.
        target_grpc_proxy (str):
            Name of the TargetGrpcProxy resource to
            delete.
    """

    project: str = proto.Field(
        proto.STRING,
        number=227560217,
    )
    request_id: str = proto.Field(
        proto.STRING,
        number=37109963,
        optional=True,
    )
    target_grpc_proxy: str = proto.Field(
        proto.STRING,
        number=5020283,
    )


class DeleteTargetHttpProxyRequest(proto.Message):
    r"""A request message for TargetHttpProxies.Delete. See the
    method description for details.


    .. _oneof: https://proto-plus-python.readthedocs.io/en/stable/fields.html#oneofs-mutually-exclusive-fields

    Attributes:
        project (str):
            Project ID for this request.
        request_id (str):
            An optional request ID to identify requests.
            Specify a unique request ID so that if you must
            retry your request, the server will know to
            ignore the request if it has already been
            completed. For example, consider a situation
            where you make an initial request and the
            request times out. If you make the request again
            with the same request ID, the server can check
            if original operation with the same request ID
            was received, and if so, will ignore the second
            request. This prevents clients from accidentally
            creating duplicate commitments. The request ID
            must be a valid UUID with the exception that
            zero UUID is not supported (
