/*
    Copyright 2025 Roman Lefler

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
import { GettextKey } from "./units.js";
export var Condition;
(function (Condition) {
    Condition["CLEAR"] = "clear";
    Condition["CLOUDY"] = "cloudy";
    Condition["RAINY"] = "rainy";
    Condition["SNOWY"] = "snowy";
    Condition["STORMY"] = "stormy";
    Condition["WINDY"] = "windy";
})(Condition || (Condition = {}));
// Fake gettext to trick xgettext
export function _g(s) {
    return s;
}
// This is done like this so that xgettext understands it
export function gettextCondit(condit, isNight) {
    switch (condit) {
        case Condition.CLEAR:
            return new GettextKey(isNight ? _g("Clear") : _g("Sunny"));
        case Condition.CLOUDY:
            return new GettextKey(_g("Cloudy"));
        case Condition.RAINY:
            return new GettextKey(_g("Rainy"));
        case Condition.SNOWY:
            return new GettextKey(_g("Snowy"));
        case Condition.STORMY:
            return new GettextKey(_g("Stormy"));
        case Condition.WINDY:
            return new GettextKey(_g("Windy"));
        default:
            throw new Error(`Unknown condition: ${condit}`);
    }
}
