/*
    Copyright 2025 Roman Lefler

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
import { OpenMeteo } from "./openmeteo.js";
export function createProvider(soup, config) {
    const id = config.getWeatherProvider();
    switch (id) {
        case 1:
            return new OpenMeteo(soup, config);
        default:
            throw new Error("Invalid weather provider ID.");
    }
}
export const WeatherProviderNames = Object.freeze([
    "Open-Meteo"
]);
