<?php
/** Adminer - Compact database management
* @link https://www.adminer.org/
* @author Jakub Vrana, https://www.vrana.cz/
* @copyright 2007 Jakub Vrana
* @license https://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
* @license https://www.gnu.org/licenses/gpl-2.0.html GNU General Public License, version 2 (one or other)
* @version 5.4.0
*/namespace
Adminer;const
VERSION="5.4.0";error_reporting(24575);set_error_handler(function($Ec,$Gc){return!!preg_match('~^Undefined (array key|offset|index)~',$Gc);},E_WARNING|E_NOTICE);$cd=!preg_match('~^(unsafe_raw)?$~',ini_get("filter.default"));if($cd||ini_get("filter.default_flags")){foreach(array('_GET','_POST','_COOKIE','_SERVER')as$X){$xj=filter_input_array(constant("INPUT$X"),FILTER_UNSAFE_RAW);if($xj)$$X=$xj;}}if(function_exists("mb_internal_encoding"))mb_internal_encoding("8bit");function
connection($h=null){return($h?:Db::$instance);}function
adminer(){return
Adminer::$instance;}function
driver(){return
Driver::$instance;}function
connect(){$Hb=adminer()->credentials();$J=Driver::connect($Hb[0],$Hb[1],$Hb[2]);return(is_object($J)?$J:null);}function
idf_unescape($v){if(!preg_match('~^[`\'"[]~',$v))return$v;$Le=substr($v,-1);return
str_replace($Le.$Le,$Le,substr($v,1,-1));}function
q($Q){return
connection()->quote($Q);}function
escape_string($X){return
substr(q($X),1,-1);}function
idx($xa,$y,$l=null){return($xa&&array_key_exists($y,$xa)?$xa[$y]:$l);}function
number($X){return
preg_replace('~[^0-9]+~','',$X);}function
number_type(){return'((?<!o)int(?!er)|numeric|real|float|double|decimal|money)';}function
remove_slashes(array$eh,$cd=false){if(function_exists("get_magic_quotes_gpc")&&get_magic_quotes_gpc()){while(list($y,$X)=each($eh)){foreach($X
as$Ce=>$W){unset($eh[$y][$Ce]);if(is_array($W)){$eh[$y][stripslashes($Ce)]=$W;$eh[]=&$eh[$y][stripslashes($Ce)];}else$eh[$y][stripslashes($Ce)]=($cd?$W:stripslashes($W));}}}}function
bracket_escape($v,$Ea=false){static$gj=array(':'=>':1',']'=>':2','['=>':3','"'=>':4');return
strtr($v,($Ea?array_flip($gj):$gj));}function
min_version($Nj,$af="",$h=null){$h=connection($h);$Zh=$h->server_info;if($af&&preg_match('~([\d.]+)-MariaDB~',$Zh,$A)){$Zh=$A[1];$Nj=$af;}return$Nj&&version_compare($Zh,$Nj)>=0;}function
charset(Db$g){return(min_version("5.5.3",0,$g)?"utf8mb4":"utf8");}function
ini_bool($me){$X=ini_get($me);return(preg_match('~^(on|true|yes)$~i',$X)||(int)$X);}function
sid(){static$J;if($J===null)$J=(SID&&!($_COOKIE&&ini_bool("session.use_cookies")));return$J;}function
set_password($Mj,$N,$V,$F){$_SESSION["pwds"][$Mj][$N][$V]=($_COOKIE["adminer_key"]&&is_string($F)?array(encrypt_string($F,$_COOKIE["adminer_key"])):$F);}function
get_password(){$J=get_session("pwds");if(is_array($J))$J=($_COOKIE["adminer_key"]?decrypt_string($J[0],$_COOKIE["adminer_key"]):false);return$J;}function
get_val($H,$n=0,$vb=null){$vb=connection($vb);$I=$vb->query($H);if(!is_object($I))return
false;$K=$I->fetch_row();return($K?$K[$n]:false);}function
get_vals($H,$d=0){$J=array();$I=connection()->query($H);if(is_object($I)){while($K=$I->fetch_row())$J[]=$K[$d];}return$J;}function
get_key_vals($H,$h=null,$ci=true){$h=connection($h);$J=array();$I=$h->query($H);if(is_object($I)){while($K=$I->fetch_row()){if($ci)$J[$K[0]]=$K[1];else$J[]=$K[0];}}return$J;}function
get_rows($H,$h=null,$m="<p class='error'>"){$vb=connection($h);$J=array();$I=$vb->query($H);if(is_object($I)){while($K=$I->fetch_assoc())$J[]=$K;}elseif(!$I&&!$h&&$m&&(defined('Adminer\PAGE_HEADER')||$m=="-- "))echo$m.error()."\n";return$J;}function
unique_array($K,array$x){foreach($x
as$w){if(preg_match("~PRIMARY|UNIQUE~",$w["type"])){$J=array();foreach($w["columns"]as$y){if(!isset($K[$y]))continue
2;$J[$y]=$K[$y];}return$J;}}}function
escape_key($y){if(preg_match('(^([\w(]+)('.str_replace("_",".*",preg_quote(idf_escape("_"))).')([ \w)]+)$)',$y,$A))return$A[1].idf_escape(idf_unescape($A[2])).$A[3];return
idf_escape($y);}function
where(array$Z,array$o=array()){$J=array();foreach((array)$Z["where"]as$y=>$X){$y=bracket_escape($y,true);$d=escape_key($y);$n=idx($o,$y,array());$Zc=$n["type"];$J[]=$d.(JUSH=="sql"&&$Zc=="json"?" = CAST(".q($X)." AS JSON)":(JUSH=="pgsql"&&preg_match('~^json~',$Zc)?"::jsonb = ".q($X)."::jsonb":(JUSH=="sql"&&is_numeric($X)&&preg_match('~\.~',$X)?" LIKE ".q($X):(JUSH=="mssql"&&strpos($Zc,"datetime")===false?" LIKE ".q(preg_replace('~[_%[]~','[\0]',$X)):" = ".unconvert_field($n,q($X))))));if(JUSH=="sql"&&preg_match('~char|text~',$Zc)&&preg_match("~[^ -@]~",$X))$J[]="$d = ".q($X)." COLLATE ".charset(connection())."_bin";}foreach((array)$Z["null"]as$y)$J[]=escape_key($y)." IS NULL";return
implode(" AND ",$J);}function
where_check($X,array$o=array()){parse_str($X,$Ya);remove_slashes(array(&$Ya));return
where($Ya,$o);}function
where_link($t,$d,$Y,$bg="="){return"&where%5B$t%5D%5Bcol%5D=".urlencode($d)."&where%5B$t%5D%5Bop%5D=".urlencode(($Y!==null?$bg:"IS NULL"))."&where%5B$t%5D%5Bval%5D=".urlencode($Y);}function
convert_fields(array$e,array$o,array$M=array()){$J="";foreach($e
as$y=>$X){if($M&&!in_array(idf_escape($y),$M))continue;$ya=convert_field($o[$y]);if($ya)$J
.=", $ya AS ".idf_escape($y);}return$J;}function
cookie($B,$Y,$Te=2592000){header("Set-Cookie: $B=".urlencode($Y).($Te?"; expires=".gmdate("D, d M Y H:i:s",time()+$Te)." GMT":"")."; path=".preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]).(HTTPS?"; secure":"")."; HttpOnly; SameSite=lax",false);}function
get_settings($Db){parse_str($_COOKIE[$Db],$di);return$di;}function
get_setting($y,$Db="adminer_settings",$l=null){return
idx(get_settings($Db),$y,$l);}function
save_settings(array$di,$Db="adminer_settings"){$Y=http_build_query($di+get_settings($Db));cookie($Db,$Y);$_COOKIE[$Db]=$Y;}function
restart_session(){if(!ini_bool("session.use_cookies")&&(!function_exists('session_status')||session_status()==1))session_start();}function
stop_session($kd=false){$Ej=ini_bool("session.use_cookies");if(!$Ej||$kd){session_write_close();if($Ej&&@ini_set("session.use_cookies",'0')===false)session_start();}}function&get_session($y){return$_SESSION[$y][DRIVER][SERVER][$_GET["username"]];}function
set_session($y,$X){$_SESSION[$y][DRIVER][SERVER][$_GET["username"]]=$X;}function
auth_url($Mj,$N,$V,$k=null){$Aj=remove_from_uri(implode("|",array_keys(SqlDriver::$drivers))."|username|ext|".($k!==null?"db|":"").($Mj=='mssql'||$Mj=='pgsql'?"":"ns|").session_name());preg_match('~([^?]*)\??(.*)~',$Aj,$A);return"$A[1]?".(sid()?SID."&":"").($Mj!="server"||$N!=""?urlencode($Mj)."=".urlencode($N)."&":"").($_GET["ext"]?"ext=".urlencode($_GET["ext"])."&":"")."username=".urlencode($V).($k!=""?"&db=".urlencode($k):"").($A[2]?"&$A[2]":"");}function
is_ajax(){return($_SERVER["HTTP_X_REQUESTED_WITH"]=="XMLHttpRequest");}function
redirect($We,$pf=null){if($pf!==null){restart_session();$_SESSION["messages"][preg_replace('~^[^?]*~','',($We!==null?$We:$_SERVER["REQUEST_URI"]))][]=$pf;}if($We!==null){if($We=="")$We=".";header("Location: $We");exit;}}function
query_redirect($H,$We,$pf,$nh=true,$Lc=true,$Uc=false,$Ti=""){if($Lc){$si=microtime(true);$Uc=!connection()->query($H);$Ti=format_time($si);}$mi=($H?adminer()->messageQuery($H,$Ti,$Uc):"");if($Uc){adminer()->error
.=error().$mi.script("messagesPrint();")."<br>";return
false;}if($nh)redirect($We,$pf.$mi);return
true;}class
Queries{static$queries=array();static$start=0;}function
queries($H){if(!Queries::$start)Queries::$start=microtime(true);Queries::$queries[]=(preg_match('~;$~',$H)?"DELIMITER ;;\n$H;\nDELIMITER ":$H).";";return
connection()->query($H);}function
apply_queries($H,array$T,$Hc='Adminer\table'){foreach($T
as$R){if(!queries("$H ".$Hc($R)))return
false;}return
true;}function
queries_redirect($We,$pf,$nh){$ih=implode("\n",Queries::$queries);$Ti=format_time(Queries::$start);return
query_redirect($ih,$We,$pf,$nh,false,!$nh,$Ti);}function
format_time($si){return
lang(0,max(0,microtime(true)-$si));}function
relative_uri(){return
str_replace(":","%3a",preg_replace('~^[^?]*/([^?]*)~','\1',$_SERVER["REQUEST_URI"]));}function
remove_from_uri($yg=""){return
substr(preg_replace("~(?<=[?&])($yg".(SID?"":"|".session_name()).")=[^&]*&~",'',relative_uri()."&"),0,-1);}function
get_file($y,$Tb=false,$Zb=""){$bd=$_FILES[$y];if(!$bd)return
null;foreach($bd
as$y=>$X)$bd[$y]=(array)$X;$J='';foreach($bd["error"]as$y=>$m){if($m)return$m;$B=$bd["name"][$y];$bj=$bd["tmp_name"][$y];$_b=file_get_contents($Tb&&preg_match('~\.gz$~',$B)?"compress.zlib://$bj":$bj);if($Tb){$si=substr($_b,0,3);if(function_exists("iconv")&&preg_match("~^\xFE\xFF|^\xFF\xFE~",$si))$_b=iconv("utf-16","utf-8",$_b);elseif($si=="\xEF\xBB\xBF")$_b=substr($_b,3);}$J
.=$_b;if($Zb)$J
.=(preg_match("($Zb\\s*\$)",$_b)?"":$Zb)."\n\n";}return$J;}function
upload_error($m){$kf=($m==UPLOAD_ERR_INI_SIZE?ini_get("upload_max_filesize"):0);return($m?lang(1).($kf?" ".lang(2,$kf):""):lang(3));}function
repeat_pattern($Kg,$Re){return
str_repeat("$Kg{0,65535}",$Re/65535)."$Kg{0,".($Re%65535)."}";}function
is_utf8($X){return(preg_match('~~u',$X)&&!preg_match('~[\0-\x8\xB\xC\xE-\x1F]~',$X));}function
format_number($X){return
strtr(number_format($X,0,".",lang(4)),preg_split('~~u',lang(5),-1,PREG_SPLIT_NO_EMPTY));}function
friendly_url($X){return
preg_replace('~\W~i','-',$X);}function
table_status1($R,$Vc=false){$J=table_status($R,$Vc);return($J?reset($J):array("Name"=>$R));}function
column_foreign_keys($R){$J=array();foreach(adminer()->foreignKeys($R)as$q){foreach($q["source"]as$X)$J[$X][]=$q;}return$J;}function
fields_from_edit(){$J=array();foreach((array)$_POST["field_keys"]as$y=>$X){if($X!=""){$X=bracket_escape($X);$_POST["function"][$X]=$_POST["field_funs"][$y];$_POST["fields"][$X]=$_POST["field_vals"][$y];}}foreach((array)$_POST["fields"]as$y=>$X){$B=bracket_escape($y,true);$J[$B]=array("field"=>$B,"privileges"=>array("insert"=>1,"update"=>1,"where"=>1,"order"=>1),"null"=>1,"auto_increment"=>($y==driver()->primary),);}return$J;}function
dump_headers($Sd,$_f=false){$J=adminer()->dumpHeaders($Sd,$_f);$ug=$_POST["output"];if($ug!="text")header("Content-Disposition: attachment; filename=".adminer()->dumpFilename($Sd).".$J".($ug!="file"&&preg_match('~^[0-9a-z]+$~',$ug)?".$ug":""));session_write_close();if(!ob_get_level())ob_start(null,4096);ob_flush();flush();return$J;}function
dump_csv(array$K){foreach($K
as$y=>$X){if(preg_match('~["\n,;\t]|^0|\.\d*0$~',$X)||$X==="")$K[$y]='"'.str_replace('"','""',$X).'"';}echo
implode(($_POST["format"]=="csv"?",":($_POST["format"]=="tsv"?"\t":";")),$K)."\r\n";}function
apply_sql_function($s,$d){return($s?($s=="unixepoch"?"DATETIME($d, '$s')":($s=="count distinct"?"COUNT(DISTINCT ":strtoupper("$s("))."$d)"):$d);}function
get_temp_dir(){$J=ini_get("upload_tmp_dir");if(!$J){if(function_exists('sys_get_temp_dir'))$J=sys_get_temp_dir();else{$p=@tempnam("","");if(!$p)return'';$J=dirname($p);unlink($p);}}return$J;}function
file_open_lock($p){if(is_link($p))return;$r=@fopen($p,"c+");if(!$r)return;@chmod($p,0660);if(!flock($r,LOCK_EX)){fclose($r);return;}return$r;}function
file_write_unlock($r,$Nb){rewind($r);fwrite($r,$Nb);ftruncate($r,strlen($Nb));file_unlock($r);}function
file_unlock($r){flock($r,LOCK_UN);fclose($r);}function
first(array$xa){return
reset($xa);}function
password_file($i){$p=get_temp_dir()."/adminer.key";if(!$i&&!file_exists($p))return'';$r=file_open_lock($p);if(!$r)return'';$J=stream_get_contents($r);if(!$J){$J=rand_string();file_write_unlock($r,$J);}else
file_unlock($r);return$J;}function
rand_string(){return
md5(uniqid(strval(mt_rand()),true));}function
select_value($X,$_,array$n,$Si){if(is_array($X)){$J="";foreach($X
as$Ce=>$W)$J
.="<tr>".($X!=array_values($X)?"<th>".h($Ce):"")."<td>".select_value($W,$_,$n,$Si);return"<table>$J</table>";}if(!$_)$_=adminer()->selectLink($X,$n);if($_===null){if(is_mail($X))$_="mailto:$X";if(is_url($X))$_=$X;}$J=adminer()->editVal($X,$n);if($J!==null){if(!is_utf8($J))$J="\0";elseif($Si!=""&&is_shortable($n))$J=shorten_utf8($J,max(0,+$Si));else$J=h($J);}return
adminer()->selectVal($J,$_,$n,$X);}function
is_blob(array$n){return
preg_match('~blob|bytea|raw|file~',$n["type"])&&!in_array($n["type"],idx(driver()->structuredTypes(),lang(6),array()));}function
is_mail($vc){$za='[-a-z0-9!#$%&\'*+/=?^_`{|}~]';$ic='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';$Kg="$za+(\\.$za+)*@($ic?\\.)+$ic";return
is_string($vc)&&preg_match("(^$Kg(,\\s*$Kg)*\$)i",$vc);}function
is_url($Q){$ic='[a-z0-9]([-a-z0-9]{0,61}[a-z0-9])';return
preg_match("~^(https?)://($ic?\\.)+$ic(:\\d+)?(/.*)?(\\?.*)?(#.*)?\$~i",$Q);}function
is_shortable(array$n){return
preg_match('~char|text|json|lob|geometry|point|linestring|polygon|string|bytea|hstore~',$n["type"]);}function
host_port($N){return(preg_match('~^(\[(.+)]|([^:]+)):([^:]+)$~',$N,$A)?array($A[2].$A[3],$A[4]):array($N,''));}function
count_rows($R,array$Z,$we,array$yd){$H=" FROM ".table($R).($Z?" WHERE ".implode(" AND ",$Z):"");return($we&&(JUSH=="sql"||count($yd)==1)?"SELECT COUNT(DISTINCT ".implode(", ",$yd).")$H":"SELECT COUNT(*)".($we?" FROM (SELECT 1$H GROUP BY ".implode(", ",$yd).") x":$H));}function
slow_query($H){$k=adminer()->database();$Ui=adminer()->queryTimeout();$hi=driver()->slowQuery($H,$Ui);$h=null;if(!$hi&&support("kill")){$h=connect();if($h&&($k==""||$h->select_db($k))){$Fe=get_val(connection_id(),0,$h);echo
script("const timeout = setTimeout(() => { ajax('".js_escape(ME)."script=kill', function () {}, 'kill=$Fe&token=".get_token()."'); }, 1000 * $Ui);");}}ob_flush();flush();$J=@get_key_vals(($hi?:$H),$h,false);if($h){echo
script("clearTimeout(timeout);");ob_flush();flush();}return$J;}function
get_token(){$lh=rand(1,1e6);return($lh^$_SESSION["token"]).":$lh";}function
verify_token(){list($cj,$lh)=explode(":",$_POST["token"]);return($lh^$_SESSION["token"])==$cj;}function
lzw_decompress($Ka){$ec=256;$La=8;$ib=array();$yh=0;$zh=0;for($t=0;$t<strlen($Ka);$t++){$yh=($yh<<8)+ord($Ka[$t]);$zh+=8;if($zh>=$La){$zh-=$La;$ib[]=$yh>>$zh;$yh&=(1<<$zh)-1;$ec++;if($ec>>$La)$La++;}}$dc=range("\0","\xFF");$J="";$Wj="";foreach($ib
as$t=>$hb){$uc=$dc[$hb];if(!isset($uc))$uc=$Wj.$Wj[0];$J
.=$uc;if($t)$dc[]=$Wj.$uc[0];$Wj=$uc;}return$J;}function
script($ji,$fj="\n"){return"<script".nonce().">$ji</script>$fj";}function
script_src($Bj,$Wb=false){return"<script src='".h($Bj)."'".nonce().($Wb?" defer":"")."></script>\n";}function
nonce(){return' nonce="'.get_nonce().'"';}function
input_hidden($B,$Y=""){return"<input type='hidden' name='".h($B)."' value='".h($Y)."'>\n";}function
input_token(){return
input_hidden("token",get_token());}function
target_blank(){return' target="_blank" rel="noreferrer noopener"';}function
h($Q){return
str_replace("\0","&#0;",htmlspecialchars($Q,ENT_QUOTES,'utf-8'));}function
nl_br($Q){return
str_replace("\n","<br>",$Q);}function
checkbox($B,$Y,$bb,$He="",$ag="",$fb="",$Je=""){$J="<input type='checkbox' name='$B' value='".h($Y)."'".($bb?" checked":"").($Je?" aria-labelledby='$Je'":"").">".($ag?script("qsl('input').onclick = function () { $ag };",""):"");return($He!=""||$fb?"<label".($fb?" class='$fb'":"").">$J".h($He)."</label>":$J);}function
optionlist($fg,$Rh=null,$Fj=false){$J="";foreach($fg
as$Ce=>$W){$gg=array($Ce=>$W);if(is_array($W)){$J
.='<optgroup label="'.h($Ce).'">';$gg=$W;}foreach($gg
as$y=>$X)$J
.='<option'.($Fj||is_string($y)?' value="'.h($y).'"':'').($Rh!==null&&($Fj||is_string($y)?(string)$y:$X)===$Rh?' selected':'').'>'.h($X);if(is_array($W))$J
.='</optgroup>';}return$J;}function
html_select($B,array$fg,$Y="",$Zf="",$Je=""){static$He=0;$Ie="";if(!$Je&&substr($fg[""],0,1)=="("){$He++;$Je="label-$He";$Ie="<option value='' id='$Je'>".h($fg[""]);unset($fg[""]);}return"<select name='".h($B)."'".($Je?" aria-labelledby='$Je'":"").">".$Ie.optionlist($fg,$Y)."</select>".($Zf?script("qsl('select').onchange = function () { $Zf };",""):"");}function
html_radios($B,array$fg,$Y="",$Vh=""){$J="";foreach($fg
as$y=>$X)$J
.="<label><input type='radio' name='".h($B)."' value='".h($y)."'".($y==$Y?" checked":"").">".h($X)."</label>$Vh";return$J;}function
confirm($pf="",$Sh="qsl('input')"){return
script("$Sh.onclick = () => confirm('".($pf?js_escape($pf):lang(7))."');","");}function
print_fieldset($u,$Qe,$Qj=false){echo"<fieldset><legend>","<a href='#fieldset-$u'>$Qe</a>",script("qsl('a').onclick = partial(toggle, 'fieldset-$u');",""),"</legend>","<div id='fieldset-$u'".($Qj?"":" class='hidden'").">\n";}function
bold($Na,$fb=""){return($Na?" class='active $fb'":($fb?" class='$fb'":""));}function
js_escape($Q){return
addcslashes($Q,"\r\n'\\/");}function
pagination($D,$Kb){return" ".($D==$Kb?$D+1:'<a href="'.h(remove_from_uri("page").($D?"&page=$D".($_GET["next"]?"&next=".urlencode($_GET["next"]):""):"")).'">'.($D+1)."</a>");}function
hidden_fields(array$eh,array$Wd=array(),$Wg=''){$J=false;foreach($eh
as$y=>$X){if(!in_array($y,$Wd)){if(is_array($X))hidden_fields($X,array(),$y);else{$J=true;echo
input_hidden(($Wg?$Wg."[$y]":$y),$X);}}}return$J;}function
hidden_fields_get(){echo(sid()?input_hidden(session_name(),session_id()):''),(SERVER!==null?input_hidden(DRIVER,SERVER):""),input_hidden("username",$_GET["username"]);}function
enum_input($U,$_a,array$n,$Y,$yc=""){preg_match_all("~'((?:[^']|'')*)'~",$n["length"],$df);$Wg=($n["type"]=="enum"?"val-":"");$bb=(is_array($Y)?in_array("null",$Y):$Y===null);$J=($n["null"]&&$Wg?"<label><input type='$U'$_a value='null'".($bb?" checked":"")."><i>$yc</i></label>":"");foreach($df[1]as$X){$X=stripcslashes(str_replace("''","'",$X));$bb=(is_array($Y)?in_array($Wg.$X,$Y):$Y===$X);$J
.=" <label><input type='$U'$_a value='".h($Wg.$X)."'".($bb?' checked':'').'>'.h(adminer()->editVal($X,$n)).'</label>';}return$J;}function
input(array$n,$Y,$s,$Da=false){$B=h(bracket_escape($n["field"]));echo"<td class='function'>";if(is_array($Y)&&!$s){$Y=json_encode($Y,128|64|256);$s="json";}$xh=(JUSH=="mssql"&&$n["auto_increment"]);if($xh&&!$_POST["save"])$s=null;$td=(isset($_GET["select"])||$xh?array("orig"=>lang(8)):array())+adminer()->editFunctions($n);$Dc=driver()->enumLength($n);if($Dc){$n["type"]="enum";$n["length"]=$Dc;}$fc=stripos($n["default"],"GENERATED ALWAYS AS ")===0?" disabled=''":"";$_a=" name='fields[$B]".($n["type"]=="enum"||$n["type"]=="set"?"[]":"")."'$fc".($Da?" autofocus":"");echo
driver()->unconvertFunction($n)." ";$R=$_GET["edit"]?:$_GET["select"];if($n["type"]=="enum")echo
h($td[""])."<td>".adminer()->editInput($R,$n,$_a,$Y);else{$Fd=(in_array($s,$td)||isset($td[$s]));echo(count($td)>1?"<select name='function[$B]'$fc>".optionlist($td,$s===null||$Fd?$s:"")."</select>".on_help("event.target.value.replace(/^SQL\$/, '')",1).script("qsl('select').onchange = functionChange;",""):h(reset($td))).'<td>';$oe=adminer()->editInput($R,$n,$_a,$Y);if($oe!="")echo$oe;elseif(preg_match('~bool~',$n["type"]))echo"<input type='hidden'$_a value='0'>"."<input type='checkbox'".(preg_match('~^(1|t|true|y|yes|on)$~i',$Y)?" checked='checked'":"")."$_a value='1'>";elseif($n["type"]=="set")echo
enum_input("checkbox",$_a,$n,(is_string($Y)?explode(",",$Y):$Y));elseif(is_blob($n)&&ini_bool("file_uploads"))echo"<input type='file' name='fields-$B'>";elseif($s=="json"||preg_match('~^jsonb?$~',$n["type"]))echo"<textarea$_a cols='50' rows='12' class='jush-js'>".h($Y).'</textarea>';elseif(($Qi=preg_match('~text|lob|memo~i',$n["type"]))||preg_match("~\n~",$Y)){if($Qi&&JUSH!="sqlite")$_a
.=" cols='50' rows='12'";else{$L=min(12,substr_count($Y,"\n")+1);$_a
.=" cols='30' rows='$L'";}echo"<textarea$_a>".h($Y).'</textarea>';}else{$rj=driver()->types();$mf=(!preg_match('~int~',$n["type"])&&preg_match('~^(\d+)(,(\d+))?$~',$n["length"],$A)?((preg_match("~binary~",$n["type"])?2:1)*$A[1]+($A[3]?1:0)+($A[2]&&!$n["unsigned"]?1:0)):($rj[$n["type"]]?$rj[$n["type"]]+($n["unsigned"]?0:1):0));if(JUSH=='sql'&&min_version(5.6)&&preg_match('~time~',$n["type"]))$mf+=7;echo"<input".((!$Fd||$s==="")&&preg_match('~(?<!o)int(?!er)~',$n["type"])&&!preg_match('~\[\]~',$n["full_type"])?" type='number'":"")." value='".h($Y)."'".($mf?" data-maxlength='$mf'":"").(preg_match('~char|binary~',$n["type"])&&$mf>20?" size='".($mf>99?60:40)."'":"")."$_a>";}echo
adminer()->editHint($R,$n,$Y);$dd=0;foreach($td
as$y=>$X){if($y===""||!$X)break;$dd++;}if($dd&&count($td)>1)echo
script("qsl('td').oninput = partial(skipOriginal, $dd);");}}function
process_input(array$n){if(stripos($n["default"],"GENERATED ALWAYS AS ")===0)return;$v=bracket_escape($n["field"]);$s=idx($_POST["function"],$v);$Y=idx($_POST["fields"],$v);if($n["type"]=="enum"||driver()->enumLength($n)){$Y=$Y[0];if($Y=="orig")return
false;if($Y=="null")return"NULL";$Y=substr($Y,4);}if($n["auto_increment"]&&$Y=="")return
null;if($s=="orig")return(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?idf_escape($n["field"]):false);if($s=="NULL")return"NULL";if($n["type"]=="set")$Y=implode(",",(array)$Y);if($s=="json"){$s="";$Y=json_decode($Y,true);if(!is_array($Y))return
false;return$Y;}if(is_blob($n)&&ini_bool("file_uploads")){$bd=get_file("fields-$v");if(!is_string($bd))return
false;return
driver()->quoteBinary($bd);}return
adminer()->processInput($n,$Y,$s);}function
search_tables(){$_GET["where"][0]["val"]=$_POST["query"];$Uh="<ul>\n";foreach(table_status('',true)as$R=>$S){$B=adminer()->tableName($S);if(isset($S["Engine"])&&$B!=""&&(!$_POST["tables"]||in_array($R,$_POST["tables"]))){$I=connection()->query("SELECT".limit("1 FROM ".table($R)," WHERE ".implode(" AND ",adminer()->selectSearchProcess(fields($R),array())),1));if(!$I||$I->fetch_row()){$ah="<a href='".h(ME."select=".urlencode($R)."&where[0][op]=".urlencode($_GET["where"][0]["op"])."&where[0][val]=".urlencode($_GET["where"][0]["val"]))."'>$B</a>";echo"$Uh<li>".($I?$ah:"<p class='error'>$ah: ".error())."\n";$Uh="";}}}echo($Uh?"<p class='message'>".lang(9):"</ul>")."\n";}function
on_help($ob,$fi=0){return
script("mixin(qsl('select, input'), {onmouseover: function (event) { helpMouseover.call(this, event, $ob, $fi) }, onmouseout: helpMouseout});","");}function
edit_form($R,array$o,$K,$_j,$m=''){$Di=adminer()->tableName(table_status1($R,true));page_header(($_j?lang(10):lang(11)),$m,array("select"=>array($R,$Di)),$Di);adminer()->editRowPrint($R,$o,$K,$_j);if($K===false){echo"<p class='error'>".lang(12)."\n";return;}echo"<form action='' method='post' enctype='multipart/form-data' id='form'>\n";if(!$o)echo"<p class='error'>".lang(13)."\n";else{echo"<table class='layout'>".script("qsl('table').onkeydown = editingKeydown;");$Da=!$_POST;foreach($o
as$B=>$n){echo"<tr><th>".adminer()->fieldName($n);$l=idx($_GET["set"],bracket_escape($B));if($l===null){$l=$n["default"];if($n["type"]=="bit"&&preg_match("~^b'([01]*)'\$~",$l,$uh))$l=$uh[1];if(JUSH=="sql"&&preg_match('~binary~',$n["type"]))$l=bin2hex($l);}$Y=($K!==null?($K[$B]!=""&&JUSH=="sql"&&preg_match("~enum|set~",$n["type"])&&is_array($K[$B])?implode(",",$K[$B]):(is_bool($K[$B])?+$K[$B]:$K[$B])):(!$_j&&$n["auto_increment"]?"":(isset($_GET["select"])?false:$l)));if(!$_POST["save"]&&is_string($Y))$Y=adminer()->editVal($Y,$n);$s=($_POST["save"]?idx($_POST["function"],$B,""):($_j&&preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"now":($Y===false?null:($Y!==null?'':'NULL'))));if(!$_POST&&!$_j&&$Y==$n["default"]&&preg_match('~^[\w.]+\(~',$Y))$s="SQL";if(preg_match("~time~",$n["type"])&&preg_match('~^CURRENT_TIMESTAMP~i',$Y)){$Y="";$s="now";}if($n["type"]=="uuid"&&$Y=="uuid()"){$Y="";$s="uuid";}if($Da!==false)$Da=($n["auto_increment"]||$s=="now"||$s=="uuid"?null:true);input($n,$Y,$s,$Da);if($Da)$Da=false;echo"\n";}if(!support("table")&&!fields($R))echo"<tr>"."<th><input name='field_keys[]'>".script("qsl('input').oninput = fieldChange;")."<td class='function'>".html_select("field_funs[]",adminer()->editFunctions(array("null"=>isset($_GET["select"]))))."<td><input name='field_vals[]'>"."\n";echo"</table>\n";}echo"<p>\n";if($o){echo"<input type='submit' value='".lang(14)."'>\n";if(!isset($_GET["select"]))echo"<input type='submit' name='insert' value='".($_j?lang(15):lang(16))."' title='Ctrl+Shift+Enter'>\n",($_j?script("qsl('input').onclick = function () { return !ajaxForm(this.form, '".lang(17)."…', this); };"):"");}echo($_j?"<input type='submit' name='delete' value='".lang(18)."'>".confirm()."\n":"");if(isset($_GET["select"]))hidden_fields(array("check"=>(array)$_POST["check"],"clone"=>$_POST["clone"],"all"=>$_POST["all"]));echo
input_hidden("referer",(isset($_POST["referer"])?$_POST["referer"]:$_SERVER["HTTP_REFERER"])),input_hidden("save",1),input_token(),"</form>\n";}function
shorten_utf8($Q,$Re=80,$yi=""){if(!preg_match("(^(".repeat_pattern("[\t\r\n -\x{10FFFF}]",$Re).")($)?)u",$Q,$A))preg_match("(^(".repeat_pattern("[\t\r\n -~]",$Re).")($)?)",$Q,$A);return
h($A[1]).$yi.(isset($A[2])?"":"<i>…</i>");}function
icon($Rd,$B,$Qd,$Wi){return"<button type='submit' name='$B' title='".h($Wi)."' class='icon icon-$Rd'><span>$Qd</span></button>";}if(isset($_GET["file"])){if(substr(VERSION,-4)!='-dev'){if($_SERVER["HTTP_IF_MODIFIED_SINCE"]){header("HTTP/1.1 304 Not Modified");exit;}header("Expires: ".gmdate("D, d M Y H:i:s",time()+365*24*60*60)." GMT");header("Last-Modified: ".gmdate("D, d M Y H:i:s")." GMT");header("Cache-Control: immutable");}@ini_set("zlib.output_compression",'1');if($_GET["file"]=="default.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgб\"PimcQCa	2ód<fa:;NBqR;1Lf9u7&)l;3J/CQXr2Mai0)e:LuÝh-923li7mZw4њ<-̴!U,Févt2S,a҇FVXaNq)-ǜh:n59Y;j-_9krٓ;.tTqo0{y\rHnGSZh;i^uxWΒC@k=b/A0+(l\\x:\rb8\00!\0F\nB͎(3\r\\Ȅa'I|(i\n\r4Og@4C@@!QB	°c¯q,\r1Eh&2PZiGH9G\"v4rDR\npJ-A|/.cDu:,=R]U5mVkLLQ@-\\@9%SrMPDIa\r(YY\\@Xp:plLC O,\r2]7?m06pTaҥC;_˗yȴd>bnnܣ3X8\r[ˀ-)i>V[Yy&L3#X|	X\\ù`C#H22.#Z`<sÒ\0uh־M_\niZeO/CӒ_`31>=k3R/;/d\0ڵm7/AXq.sL :\$Fw8߾~Hj\"Գ7gSFLίQ_O'W]c=51X~7;i\r*\nJS1ZctAV86fdy;Y]zIpc3Y]}@\$.+1'>ZcpdGL#k8PzYAuv]s9_Aq:\nKhB;XbAHq,CI`jS[ˌ1Vr;pB)#鐉;4H/*<3L;lf\ns\$K`}Ք7jx`d%j]4YHbYJ`GG.KfI)2MfָXRC̱V,~g\0g6:[j1H:AlIqu3\"q|8<9s'Q]J|\0`pjfObq\$1J>RH(ǔq\n#r@e(yVJ0Q҈6P[C:G伞4^PZ\\(\n)~9R%Sj{70_s	z|8H	\"@#9DVL\$H5WJ@zaJ ^	)2\nQv]j (ABB056b˰][kAwvkgƴ+k[jmzc}MyDZi\$5eʷ	ACY%.Wb*뮼.q/%}BXZV337ʻawW[LQ޲_2`1Ii,曣Mf&(s-Aİ*DwTNɻjX\$x+;F93JkS;qR{>l;B1AIb)(6r\r\rڇZR^SOy/M#9{kv\"KCJrEo\0\\,|fa͚hI/o4k^p1H^phǡVvox@`g&(;~Ǎz68*5EpӘ3ņgrDL)4g{峩L&>脻Z7\0̊@ffRVh֝Iۈrw)=x^,k2ݓjbl0u\"fp1RIz[]wpN6dIzn.7X{;3-I	7pjÝR#,_-[>3\\WqqJ֘uhFbLKyVľѕVf{K}SޝM̀.M\\ixb1+α?<3~H\$\\2\$ e6tÖ\$sxxCnSkV=z6'æNaָhR噣8gw:_ҒIRKÝ.nkVU+dwj%`#,{醳Y(oվ.c0gDXOk7Klhx;؏ ݃L\$09*9 hNrM.>\0rP9\$g	\0\$\\F*d'L:b429@Hnb-E #ĜrPY t \n5.\$oplX\n@`\r	\r  	 	@@\n  	\0j@Q@1\r@ 	\$p	 V\0``\n\0\n \n@'\n\0`\r	\r\0r	\0`	{	,\"^P0\n4\n0.0p\rp\rppqQ0%1Q8\n \0kȼ\0^\0`@>\no1w,Y	h*=P:іVи.q\r\rp1Q	1 `/17\r^\"y`\n #\0	 p\n\n` r Qb13\n##1\$q\$ѱ%0%q%&&q &'1\rR}16	 @b\r``\r	d	j\n``\n`dcсP,1R\$rIO 	Q	Y32b1&01  f\0\0f\0j\nf`	 \n`@\$n=`\0v nI\$P(d'g6--C7R 	4-1&2t\r\"\n 	H*@	`\n  	l2,z\r~ \rFthmz~\0]GF\\I\\}ItC\nT}IEJ\rx>MpIH~fht.bxYEiKoj\nLtr.~dH2U4G\\A4uPt谐L/P	\"G!RMtO-<#APuIR\$cDƊ-GO`Pv^W@tH;QRę\$gKF<\rR*\$4'[IUmh:+5@/lI2^\0OD\rR'\rTЭ[ĪMCMZ4E B\"`euN,䙬]t\r`@h*\r.V%!MBlPF\"&/@v\\C:mMgni8I2\rpvj+Z mTuefv>fИ`DU[ZTVCT\rUvk^Lb/KSev2ubvOVDIm\$%X?ud!W|,\r+cnUeZʖ-~XBGd\$iMv!t#L3oUIOu?ZweRcw.`ȡi\rb%bH\"\"\"h_\$b@z\0f\"rW*B|\$\$Bנ\"@r(\r` C(0&.`Nk9B\n&#(@䂯d^ @`I-{0\nB{4sG{;zb{ {bׯ){BxKŇ5=cڪy&JPrI/ \0V\r׉=N\\ئ=K}XVxإˋxdՊی*H'δ{X==\08\0[ɫJtOeɋ\rDXŇ}z)y''яI([l(5`f\\`e.lY(=zה!Y%hO+`ٙ\"e ėKߚ#SEIY.HJtG`HJ55~ 6ChXDz\nxyshFKczjZY8(%|yIߑ؃eYXu i]cM;ȧ>ǡQT [~W~c݂zz\r:  \0rYx)!ɡK+z!ӀC+ٮï:ݎZg~z4f	:sӪ+x%=GIf3?+Yq@GyoѴp\r~{W[y:\0\\;eۡYI\"zdkZ|[uu+׹9qnR ˮBׁz|\rᤄk^[1%.pA2<=ء\$;5)m!XXYx5vT\\Q%:>ɛ;e|/yWxנ|gC\\<9z\\#.FV;8NX7\"8&d5P4Gj?\0?\"=HER");}elseif($_GET["file"]=="dark.css"){header("Content-Type: text/css; charset=utf-8");echo
lzw_decompress("h:Mhgh0LЁd91S!	F!\"-6NbdGg:;Nr)c7\r(Hb81s9k\rc)m8OVAc1c34Of*-P1r416d2ցo#3Bf#	g9Φ،fc\rIb6EC&,bum7aVs#m!hrv\\3\rL:SAdk5naF3e6fSyr!L-K,3L@J˲*J쵣	bc99@H8\\6>`Ŏ;A<T'p&qqE4\rlh<5#pR #I%fBIܲ>ʫ29<Cj27j8jc(n?(a\0@5*3:δ60-AlLP4@ɰ\$H4n311t0͙9WO!rH9Q96F<7\r-xC\n @:\$iضm4Kid{\n6\rxhˋ#^'4V@a<#h0S-c9+pa2cyhBO\$9wiXɔVY9*rHtm	@b|@/l\$z+%p2l.7;&{mXC<l96x9m7R0\\4P)AoxqO#f[;6~P\raTGT0uޟ\n3\\ \\ʎJudCGPZ>d8ҨC?VdLL.(ti>,֜R+9iޞC\$#\"AChVb\n6T2ew\nf6m	!1'c;*eLRn\rG\$2S\$0a'l6&~Ad\$J\$s ȃB4j.RC̔Qj\"7\nXs!6=BȀ}");}elseif($_GET["file"]=="functions.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("':̢i11	4Q6a&:OAIe:NFD|!Cym2\"r<̱/C#:DbqSeJ˦Cܺ\n\nǱS\rZH\$RAܞS+XKvtdg:6EvXŞjmҩej2MB&ʮLC3Q0L-x\nDyNaPn:s͐(cL/(5{Qy4g-i4ڃf(bUko7&ä*ACb`.\r\nCh<\r)`إ`7CʒZX<Q1X@0dp9EQfF\r!(h)\np'#ČH(i*r&<#7K~# A:N6l,\rJP3!@2>CrhN](a0M326UE2'!<#3R<XCH7#n+a\$!2P0.wdr:YE!]<j@\\pl_\rZғTͩZs3\"~9jP)QYbݕDYc`zcѨ'#tBOh*2<ŒOfg-Z#8a^+r2b\\~0Wnp!#`Z612@ky9\rB3pޅ6<!pG9no6s#F3bA69Z#6%?s\"|؂)bJc\rNsih8ݟ:;HތuI5@1APaH^\$Hv@ÛL~b9'S?P-0C\nRm4ȓ:Ը24h(k\njI6\"EY#Wr\rG8@tXԓBS\nc0kC I\rʰ<u`A!)2C\0= P1ӢK!!pIs,6di1+k<^	\n20Fԉ_\$)f\0C8E^/3W!א)u*&\$2Y\n]EkDV\$JxTse!RY R`=Lޫ\nl_.!V!\r\nHk\$א`{1	|i<jRrPTG|w4b\r4d,E6<h[Nq@Oi>'ѩ\r;]#}0ASIJdA/Q⸵@t\rUG_G<<y-Iz򄤝\"PB\0q`vAa̡JRʮ)JB.TLyCpp\0(7cYYaM1em4crS)opC!ISb0m(dEH߳X/PyX85\$+֖gdyϝJ lEur,dCX}em]2̽(-zZ;I\\) ,\n>)\rVS\njx*w`ⴷSFid,ZJFM}Њ \\ZP`zZE]dɟOcmԁ] %\"w4\n\$zVSQD:6GwMS0B-s)Zc|^RE8kMsdka)h%\"P0nn/#;g\rd8F<3\$,P);<4`<2\n@w-͗A0LrYhXCa>tL2yto;2Qtfrm:AAN\\\"k5oVɃ=t7r1pAv\\+9{^(if=rut]yޅCgivf+Ø|;]~|\re쿓݂'	\0+Wcow6wd Suj3@0!\n .wm[8x<cM\n9'a1>[dux<\"YcB!iw}5Uk]{IךR=f W~](bea'ubm>)\$P-6R*IGu#ƕUKAXt(`_\"p &UI]YG6P]Ar!b *ЙJoӯv*!~_4B_~RBiK`&J\0N\0\$CK SjZ0pvMJbN`Le/`RO.0P82`	d GxbP-(@ɸ@4H%<&Zp%\0pЄ		/\"J\ns_\rg`!kpX	:v6p\$'RUeZd\$\nLB.dntm>vj)	M\r\0.ʊH\"5*!eZJf(dc(xjg\0\\ Z@|`^r)<()@Ykml3Qyс@ѐfPnTNmRqVmvN֍|ШZȆ(Yp\"4Ǩ&%lP`ĀXx bbdr0Fr5<Cz6he!\rdzK;t\n͠HƋQ\$QEnnn\r#T\$ˈ(ȟѩ|c,-#\rJ{dE\n\$BriT+2PEDBe}&%Rf\n^CZZ RVA,;<\0O1c^\r%\r `n\0y1.\rĂK1M3H\r\"0\0NkXPr{3 }	\nSdڗx.ZRTwS;53 .s4sO3F2S~YFpZs'@ّOqR4\n6q6@Dh67vEl\"^;-(&b**.! \r!#x'G\"͆w\" 2!\"R(vX|\"Dv)@,zmAwT@  \nЫhдIDP\$m>\r&`>4A#*#<w\$T{\$4@dӴRem6-#Dd%EDT\\\$)@WC(t\"M#@TF\r,g\rP8~֣JcĹƂ ʎ\"LZ\r+P4=STA)0\"CDhM\n%Fp|fLNlFtDmH5=H\nļ4\$K6\rbZ\r\"pEQ%wJV0M%l\"hPFAA㌮/G6h6]5\$fSCLiRT?RCHUZYbF/.Z\"\"^y6RG n܌\$\\&O(v^ KUѮam(\r\$_%+KTt.ٖ36\nc:@6 jPAQF/Sk\"<4AgAaU\$'fQO\"k~S;.:k9e]`n-7;+V8W2HUYlBv⯎Ԇ	plm\04B)X\0QqFSq4nFx+pESovGW7owKRW\r4`|cqe7,19uucq\"LCth)\rJ\\W@	|D#S\r%5l!%++^k^ʙ`/7(z*񘋀E{S(W-Xė0V0=a	~fB˕2Qru mCtr(\0Q!K;xNW?b<@`X,`0eƂN'&~tu\"| i B 7R lSu8AdF%(?3@A-oQź@|~K^@xb~D@سTNZC	Wix<\0P|\n\0\n`\"&?st|ïw%mduN^8[t9B\$'\">U~98ÔFf u/)9\0Az\"FWAx\$'jG(\" s%THe,	M7b ǅa ˓ƃ&wYφ3 /\rϖ{\"ݜp{%4b`팤~nE3	93XdՏZ9'@lfQbP*Go`8AB|z	@	bZn_h'ѢF\$f`HdDdH%4\rsAjLR'f9g I,R\\>\nH[\"\rӁL,%FLl8gzL<0ko\$k`KPv@d'V:VM%@6<\rTLENԀS#.[x4a̭LL\n@\0۫tٲ\n^F5` R7lLu(d \rBf/uCf4cҞ B_nL\0 \$aYƦ~Ukve˥˲\0ZaZXأ|Cq/<}سú Z*w\nOz`518cIQ2YsK\n\\\" ðc*B.R1<3+*S[4m쭛:RhITdevIH-Zw\\%n56\nWi\$ōow+r&Jq+}Djd?U%BBe/MNm=τUb\$HRfwb|x d2NiSg@q@>Sv|krx\0{R=F#r8	Zv8*ʳ{2S+;SӨ+yL\$\"_B8\"E%\npp''pwUҪ\"8бI\\ @ʾ LnR#MDqLN\n\\̎\$`~@`\0u~^@l-{5,@bruo[}/y. {6qRp\$+13+O!D)\nu<,=Jd+}d#0ɞc3U3EY\rtj5ҥ7ewׄǡ^q߂9<\$}kRI-+'_Ne?SRhd*X4c}\"@vi>;5>Dn \r)bNuP@YG<6i#PB2A-0d0+gK?nddOci<0\0\\gꡖNTi';imj܈uJ+V~'ol`\",F	{CT aNEۃQp p+?\n>'l* tKάp(YC\n-q̔0\"*ɕ,#7\"%+qB=i.@x7:%GcYI0*Ðkۈ\\Q_{#\r{H[p >7chn.S|&JMǾ8mOh	qJ&aݢ'.bOp\$D@CHB	&ݡ|\$Ԭ-6++ pଡAC\rɓ/0MiZnE͢j*>!Ңu%g0@5}r+3%-mG<T;0DVdg9'lMH F@PuntFB%Mt'G2@2<e;`=LX2X}oc.L+xӎ&DaɫF2\ngLE.\\xSLx;lwD=0_QV,a 5+L+|\$ijZ\nDE,Bt\\'H0R~(\\\":n*(o1wQrEteF\$Sђ]\rLyF\\Bihhd&ᚇh;foB-y`0JlPxao\$Xq,(C*	:/HG\"cCQ\nFԄ#8F:У\0OkD])ϚtT8L𒨔n`|HJ  \"6{?=I<HGc ŤF@,C @j\$L(nEʑPjbnΑW \rLqsPHꉝz\\V\$kҏtr5,l<'\0^S020f -5\"ac\"3Up\"ܘ%\0'Zt\"969_ @Z{0IDZE@Nh`\"`\0ɹ(GHCh If`@ZD\$)K;Z\0/CT>r_R@O`1rTҨIb\0*8h\$_pRĕ\$Ni^ʪP/O).ŹT6\\ٔ@Trą`)T=n\02e+9ʢ\\@>PH1	y#r<aeK/cM@_.\09ˈB0ia\ndea%|S2#nD\$/+Ed_2P\$s,ok#<	Ađr{BA-Q4Ҥ\n\ry!b䱎O@ɬk \"r*݇Y/ȑ a0%.gE~& 89#@M_ 7K䃸J`X)B\$(	:gn*|M6PZHtJtqCx[ڼl=\nU3f\\̔JP	,:}TASYH(\nIٲ!t(2U\"\\X^s	a!\nPr`X3fnbJ&zzQSf t!T?9%(QB}6BkP\0>g&~fhUr, p5HipqɚgVVOgWEJ80Gak@N NMUUxȪSx		K@c1yVlϠC2Q^rP6|I^M,j%d`ܫF\\#%|C7싢GTNiHQOCyB\$%T*>z\rMM Kp J7O۷4%\$p4͂EҪ\"T\0O\0@>	rO]x}^I@ źqn0BbȵI(M/;}RN\nC<bPԵu?=PeCL^'S?}4)S-1\r5SOESFAOR+ޙ+v5&C)ِKSDB߳N|E\rcUYʾV?H)実+sFkLPW-,U:&t{VoJl'We74Xn GF'`Cc%Ilju6vUZ\0*Nԟ#(n-;|4]Xy';Z) s9%R+\$	Q(\"_kX\nM#\"!p~:*\$3O6+\nB{1|HK<[`3#F@ǐ! |؊\0>[nrMM+mO_2Ȇ\0e^	7Z&BJ褓h7QO%rfp΁֞mبÇ4El+ViN SZWt2W[;v\"%\$^-(I\$S@R-&Tzk(	%R8uY\0[9-()E8=^G5#)1Vb\r]Ne;&Y`rIPݱֲ\0@P70H؍Rx\0000C|n=`TT\rEhON'&tcK ܕU5P3\\2\"\0y5V]6>U!@hu(\"E%07B6dHNij';@eMzlSfjKY֍-uhHsmL@\"rjj'l7	(uuEea@+K:ӕ%nzV;[_Vz_E8<Sb6g:c7\n%Q K7ܮBwu50֚yncnKT8ʙsW=+=K\n_[pGC5'D\"M<\":|Mq4fsx	qlͰQPaOYE=6nT떒BthC\0p@nD(aP\"'ZN۬\rLNXg<!w[B))~cxvi¦qa@K7sEQdýk?\"3-\"U||21D>߳]­&\\hTƳ5\0`Tzs -N\"fNLU]n(D(&%\"e\\ONInۿ\0ƕ@V|RMYCTbUHp)Ss qi`Z5vt坉*OO\n(F58!ax@{^P?eh}\\j^2L,6.N	K%uip!?l -5wK\"V\\Is2!\$45v\ngrN};W%D(pWa\0v'6Vƿ0WE4EUl8LDE<kOHDU	`vSL!DTMbnWVCd)Ze蟀:2d8Kބ4-Gb;wQW30\rf\0,`Qhl֍0P0h@\\r8T⛜1`&wX>F?|P*MqZѯ}0k`#իc'[ֱˍ|sIJ\r<OaƼ@WuT:E^!ka\$>5u_KcCQr-ъ'\riC@8SPS_Xgl%	n1r.<w_aɺĳGh4\nWZaBn,\\\0DU\nbbZ'72r¢}Y>/w\\Y`^7JjSS.o%Jg\0GD,>7R036%i\0S^LA\riO<a phv[{\0E^xܼgYzWyGa:(>Ce\0])3yts_a7+BCeTfoP2ECv>wlz*pYqQp\nv[|qҨE[Xi=z(	Mn]7F\rCs4|-} Ŀ(NU?,څq	pq~ F%88靦\$ް[ro!3(gץpJ!qZv?cL76\$mq8l!5C;Q,dsF-OfÈ\$6%UCf\"e(j\rMtFRx;nB\$SSx'G陊M	4ͬ'k~#9eY~뭈;f+jK9pM'X/rt\0\\J%QR\rвO3|寚ϱ4xFs5EԐ;ԒWRJXʶJ\$wzO&ǵzkS\n\nNUP.0bdkP	G6+Bz1ΎhQ>sHvQ٠EpM)\n\\ўPz.s g)a~ȥ!(!Ghr[*բ`~\"!O5G3Ş*qkgB,\$**1c.n	8\$dVSneMiZ7žgA5\n`,2aүmMkʻɯ/-6@?#`)Ԁha)Vc]_=Rz\\VR=ط(-ot\$ܥ\ndSmyfөN\rm(t;Dp2ݶZRl)9M̛,/Yixkя).2@S^ud6!>VB x<Kt06@\nGAP(NbDK\n\"cN\ră.p'2Ldꟲ\\LyA=	Dm3%@8qbSP\"ޢƮ/DzC&O\0007fD^1X/,\nvWx%f)' DdQ@I(ҋ7Y|AQDڠe 8ׇ7k)_ @\"\"%}	(11؍\re?-ɵH&\rL'eۮ0T]C!emNz	UzɈSܜaf7M^CD(_#\"dr5981hfȭa_×tZX\0U{2nn];FR!}>sHiy#?\"Ť>{/?7FY?Aj.U!5`H\$r\0'\n\":.dԂٙƪqRխoh>{1+>tk%-D=9}C@8cmHrWn\0Ď<(RR8YV`pp.Ue_`^쵛n^_R|r΅p7/!M5|\n&FVVzOA~ш|ƛ4NȒՔgyh-\nN\"r\"GcsD'Xo٧O{{Y{E=TeZ{\";HXztw*-Uw-\"<A^OT ]D?:<pq[,)&`{xKII``c0Dy8qCY]W7uECWư5ya`7=f9sv[N?uj'׏ߋʜ̲~\nQ`\n]< WhG\0R*-AF- xDz;y\$wUG\0ڄq^{#AȠ͘&Bx)m)cXzSz8Ѧ+KSK?#	ޝm7ujThOZ{Wޮ:Kd[/W7e\$̥K?,b㳐A\r>R\\0\0i5&&1'8.\n\$\"Rvo y\$ذN#M\ro,8Y\"J7FB*bDcS.J׿ٟYFBk\"H˻K9!\nIl2G@8!)Ď7#d,5A1PƉݫONz\r\0m6'4	O?c=ْ@LY3\"iuޭ:KBe;\0w\">FA˫'B@@zoP\0]\0rOjo~ulQ|u7,?h0\0b/!˄/V_&cwp9\"&gߐА\0LyS6H`O\00 O-?'g@/\0_w6%|PN*>Q\"*\"k\0S0wO6cDDGp	3`Ai2>Bi2\0f/6@qȿP3*\$P*O:o@\\\r0dP!hM txI  ?D\nw<P-~Caˀ¸)E4+Eb>d\$<`o>h?8bn/.oIV,Ac3Xa o*xi\"椌\0U:DOY}\n\r\0,OrYb[Jp2ДjBO\$|Ca4`\\*4bAߤ_X\$@6\n\0\$~ˣ`Jb݅ UpXR\"ێlgt' +x̐N51e`Aq\"O- 	C!Қmɵ*f@6ZЛ9ZRǁ	HZL eN29| T n?X\$0\0002	y!e :\$QssAnxKw\n*'Nz!p'Fn6>-\n )\$k\n@QB&4\0u\n`B*e.BB{ȩ@	0uCy\"*0d PszU|61A(ǞA-3e>/\"(mF' ");}elseif($_GET["file"]=="jush.js"){header("Content-Type: text/javascript; charset=utf-8");echo
lzw_decompress("v0F==FS	_6MƳr:ECIo:CXc\r؄J(:=Ea28x?'iSANNxsNBVl0S	Ul(D|҄P>E㩶yHch-3Eb bpEp9.~\n?Kbiw|`d.x8EN!23\rYy6GFmY8o7\n\r0<d4E'\n#\r.C!^t(bqH.s2Nq٤9#{c3nӸ2r:<+9CȨ\n<\r`/b\\!H2SڙF#8ЈI78K*ں!鎑+:+&2|:9:A,Iv4ǢꆌP-\nҸ%>(c(P74c8X`X:\r3 KIAHHs\"N8R0HY5GDW(3Ut  P9MVd?4\rCPbؼ2*b3T`nVMsb0]pG%n\\E]8ߋh7E`@PIjVTz\rC+R8\r\0aRؾ70l_2dYAxPZA@yART o^CK~c⊰{}cZ.~!`@C.ޒ.y\nl9wt\\C\$pըp8/媤eyn_H!fwZ%hc5~[H{\$\n\r!4nn6͊cHJ.6|`ӛ;.ް[pWݪ>\\hWZO7PxApUW)!/pi[~X\nR\$8?BEy!cPC5.\nH]=y*\$st`57a\r\05j-g\0ͤ#oA\"p;\nH<m!dÙK>+d=p)pP	#|<)70-(ek9HE9.N䔒J hL>e<ۿC`KxVA aPA9WIy4WjpWdER2ip#)CD?ruxs|ϸAX+?l<H&T#|РQb -\$}Ah:t0PD9!9SmHi\ro}ƪP_Eaxfu{Ӳv<)/#QC*ܪ\0rNirtGNow>MӼ DJCv``Na@](U S5{=9N8z3^<		Xc\n=@s3&ꚠdAj%\ry\\{<#	UgR`^K4l!t{\0W&|-U/7yUCXR6uHVu|IV\nq<鼇*p)&Nq/Rل\nV	83<;}_ph\r ӊpt9#%<2id3Rs\nkOf9pA\n9  IYCc,U2^\00\$NqsJ+d*@1:ukΆ!4;@zZ&d\n3\$ݠC]QBVwp.K\\άԌ\$9i<2Zp:a`US3|T!&P,c=0=Nd뛭6nZyiTTJweSu'nm틸In\r;ݔ*)Ai1yQ\r_8?՞76l1ǽ{cvr{\\.,ۼevkۛe~L^7\n@.s8t}ɘ8C-ѻ-4IdO{sջ8[˵f;}Qs^ݹQ2[(@\nL\n)(Aa\" 	&P@O\n師0(M&}'! 0{6}kʘ@;px6zg|+D+ϤyJL#}~*/}4|Aw<wOX\0~\rڏޏZ*\nϧ\0v0 */hD?O\rnBPFo0\\`0fkrOHphxpq֐PTbOPį8揢POo.0·\0\r	PEK͙\rP)\roTv \rDܯoMA(XhCL&\"h\r,N^qKkb\"	}qy\"R`\0n+\rnqHHL\0V%F: ؎\$\rf鬶јjBmQmG\\蕱nk%\"Vdk@ !2+6% ~Ğ% r.R[ 2?\"̹#\0Ԁw\$U%#!%)\$	\$LmA-W{@ܷ#_&x]\$S'\0\rg@m0`df`G&L\0':xjx*оDL(q,&lNt*\n	 %f(оkZ	%in\".Ļ氮~\0U@d4'r\rn#`2H g6&v'\rrS^\$@Xf>΃k6r7`\\	5V'W5\rdTb@E2`P( B'0/w␑s&r.SVsє9JJx&8v!`z4\$k\0x7pI өA9;\r~4>~'\nPs0PQA+/7`WOG1Fp暴\n|\0PGGtI\"TiGO@FV~G荔2\$%96,7LLSoLhP5ʼУ\0P\r\$=%nUjXUkϋN\0\r)F*h@kB5\$56Lbs|Mo8+8\":G4ONS5#j\"NncJtT%(DUS]Mj\$TK`5o@rYSNR1ER\rEXrNJ7bgTUxM5*0r:3		2i1QkF0YZstec\n:oHFExu#4S#	 	\$t?E(p(R\"|eBX8	4>\r/<\0E,^D.E{5a܆*\rZg|~\r:moc9Jv*B7rT&nlHPV6mDw)m\rCVw\$uSwS`ADLS6qk)Jkl'LhB9h Jimn<\0  <\0[:\0K(~s\0K̒Y'ʈgaO(]v:&!`PxV^wnĹ7\0&g|B\0(*,ľ²d7⛬tzwz\nE\",\0\"fb\$B(h(4ժ5b?΍wq|@Ƙ+؁޶&Ɋ~NⴎחN6<uFxWQ^^;P.#/|Wȃ8k./7K/wQl8~Qψ\\1\\&\"ئWR/)|A5reE@k\0OwK&f\"'Lml@ۄPZ7\r#ox`]b̄NzZ@0NR,x[Pc8zX\r?Ǎ?92x}LF'LPyzð\\ƙǌT ŤiNǀTx%xaucw#l,\"Pb*g#Zud,5\$D3]؛?h~0\nyN7bz\0a5qkpvQ,D[A\\EyKyP#UZk&)E9q\"7![QMd۔uQJ#\$o]jۥgO\nXD6꣢eXZ:E:OUbz]7sDc0`?\\S{ySihzEiij&׫e'kXy f6V-ZWewŊ;G\${SK7	1n>@izzw9{x;\0\nIyk[7{޻8-~w,[lȌ@ϷVԘ+Ӌؿjcؤ\\qǊY'zYݻ˜?aA:Q٭(} \ny#Sy\0[?/]My{ˣ9=PϫOLs\\sWDػ˱|7jN-E˕+`uƼ\rM}~I~iڴ|lv}YL1l>\r9,oY9}Sgg銼:u)ÈCR%~|~w0]|\\yϙy\\ج7йe,mu7(T],wθfU=TRW6<Kֽg;||1\0Qy\"9vb\$5mwΆo\r\0xbkH|ɚ Z\rhWʜ\\Ա.3U\r˽ؘ\r>?2)᩟/=50@ƅH~<нx_/˾3~I+~l~HY{Y^]^ae^h^r+>CbB,2/LR#mRKIK'픕EW1]Fz_]T%4̔\0V=4;\$T 枍{?לּԞ3n\rz X?cp\n?#adX\n:z-^X!`:\0y,DlJ`A)hU+5+~_+<b]<m5~']')ެܺ/Pr4o{_ngHFpBsH1)bb?톼\"[C<U~<0y:G@}脬z޺w)}[ꖞ<8&X\"`BWw{kU.E;=pQɢR)t\0;Լ*JC^ d,+d-~*xpn@A?Qh{䄳'A5P{dX`H+sSkX/E(3=!004\rjłZa>m4?og3xƕJW\$EQ^&\nQEhjqCNƠ,yHβ\$'@\n;\0\\]ϛв(\n6arǩuP/;P#q1\nPB.6`\nFٰ͒W3dbZU֜=xa@=fZ;Bk謀mJNg^prٲ(Ilcp*AOU7\\D<Tf+THϠ`RZq[`of\\\"πx|EfŰP/S\"_8-CF]\"jhF29!Eb[E*Mx\0`9DU_tюq^(j!tX'E_ػMQd^b|,{4\\MXFf-kN`7,BJG5&*1L4	#-`'\nL?\0)|r	X|e\nJ9@ʬȥ6qX\"qE	Pm¢NҖ7}	<I\nA͌juL+F'CZd&RncIl\$\")|74hCvcs}sG0~#feB.rO!<]/d[A\$)JP\0Y%F`&BvMIIP*7֐2&lXo.\0KZBq&<Jp	ei;\r0PBHMLİ=TXc1&y-I6fN|&yRn0r	%VRKRdH AY\n<JĺL'~V \"l!d'`q>Iit3:Lɲ\\s%ͪE@HC\nf\"@ 11 ln͆/X\\DK ^-n|\"\n8@{)P(P(s f y0M@\0&bQX]3	8<#11<.bf*p'<4)1\0)n~cȁTStI11(\0P,d\"=@6\0w\\fzYLn(O}5	W=2Y͖e@Ol܀7INmX\0N:nB\0k|,p>Nxnxh5Θ	Gd'3MS\$H1iN0݀8Mvĝ\0P\\NH\0|9@\0!dHNɥL\nS؞؀*MQu@&7i8򓖜)1\0#Ljr3\\9HKd?hg:	OzvsO|\0F4>ϾpS|<*LBw)<?9@	3+7ϲes\0@Ђy\$\n(#B'Rӫ5CiР4:C о}4D(i<jPQ\0ADf%>L4T@IOXX (&l')}\$eIfN_% 4i\\UhC=Du'@v8dB-%(T%7㖨f\nX\0m@C0I\rɽw<QhS09@I,t')˦\0J7\r\0!ƷW1\0~_\r2\nf܊@QK9\r\rXi{/~2Z_2'*o	Uس\0{e(\$iM4T44}6)mV}A3Q\0l/=@QZ:kN|Q&4JR*iSP5\nt@_)QIMXoޠk19B7=\0ɷ̆l|[aa.Ԩ\n\049Βv@GPO'ZHX'VZ@Tng7>l3cDXZfjY_mX)ʀzG\"P2|\0NjX{\00dTl \nq;߁:bShfy)Q+jSCQyS0Hq`	`FlpT+yrjZKcWmA:y5\0P&zWZ)D	TvDV3VFȭRj֭pv5)'X&@.C@`pTlSw_	#:!/5rrr;F&M@\\C\0\"\$(TX+\$t+r84XfId#&cIPZḻ(lZ6^3|s\\=Er3w+(, c^|:`h[UahtZԶO;qyv\\A^x!j2VդմEd0رְ4HYHz 0+Rjf_kAJj[,U\\jXX=ZDw5uˤ՟n	%'}&p& )qX\0+_9C)Iۊ)R짇`ĵ@/!+UAf\0R=A%r3{\0`%z0\$>Ѹ=h]/64\0i_2Ue;:JNuV|@	GhU=Qh'(T>,n?#tsf=cVvu`U'X)MQpp7פ!aJl0@ZFE=ClJduAJtȪp0WUwƁFa\niݻXJ*o*6k8N[*/uMCUMaJ޲V!U!+Ŭpxh<@B] ;  u_2RL:߈	4.f1@b%\0!{=Mۿ|`x	\nтo!p)_tȾ#pai\\3D.񶕁Y2xFg넞8'(0BJ@bZn	p\"Ee9J0X3b\r; S1[y=(73	Ñ2*l0!VlrZ@<TKmXiF\nU?fT\$i8GS)L\$8BiD!\\B#<4aT+@-7\\x6p?\rN/黰%L+`ht<W>{~(@R06ǞP+{Esö\$*b	&#[X̯&bnSUl,0G~}cUf'dCs<m\r;<*4~ǉoam4]/02cFxwH;Rqﵾ&	kX?AIƠ\">x?,Pbiū)c<\\++^n3ő|N'!+PGN5TBK!1\":2bP,Fy*NÓ<a[&3t閇7\$\\qߔ 2ecInTy2c_	@\nup x+XUq<A.Kʕʎ!2?8fr˗8\r8(p^!!Y=q>\rv-πٗ	1gf,[,e'ZX:2\\Hy<1)[α;D|#H@LS3>;]2Xvj.GEBi+d%,Qr%Ц¶*I5`t-sb8E۾e\0=2/Yq9-eZ1\\^U`&gWJYhK]8W@;p##Bynqĕ\$uY!\$)(rX@/+L8O^ʔp6,Ѱw<%MSS=Z%W\r\nHy/2+e1Eɣ\\Uw	(p\n-ISEZiI@1	`\$448>\0iMӈ4QjYyp#x`m'Zڂ6zaSi&ʒR>z\n{TiP:jZjTtR@:ޭ5hj{\rfr\"x|cx?rkp.r>tqC	k5ha\nU:yxW8k)3!ҋk^t}-x5^B(q@Qd]ƴCr\"kw[&usW:ꕝN@d=+Z9N@m{-%>HR0*7K/<~,jsnP\09.͵Sj\n74ݱ,\$;E-m\0*Ȼv7c;u&vֲ37ءy(tn;JAG4hfR@5)V{[Ymb61pJ6;[.Ŋ[rb9V0\rw݀CwVT&=,hzH)8EsIt<@e+0ynjTƮw~dJσ@)c+h,ث8pL K:QAog1o?IZ.?=~nkF!n%/Et0'̔P<ƵGqP䴓FxAq⃫vn`,cW{9K߇{|+s<4Z+צ6PPL(L=ծjfh>)A혠qpK̆Ҡ~6d0Y#y}tORCS_燜|bHwsO%UwpN򈍜Y]U\"rMt\0jxoWD[[M yT8@9h!̋r`\\/4u{d8Sǡsb\" i;jiǿkj}vi74߽J9=՗540'?(7qg t	_[zӌ\\w_>s_g\0V|\$p-BsX܇.;3gPCDGy1j\0y=M˞;Fm(oD7ykbo=!:.%C%t߿Xm\$6&PbjTu*Tx\nd5Νt^d(S|-q\0(tXYQ!HFk0t4H|oNoN%\\w\"0Bq\$[玙f|q7~EyXqר>| Ob*\nImcEЮe6ev˟LnɩKxx~aǜf)9˟]F!sIiNh~ӔR.GF8/zdCf6-#g|t;4TV)kV/yC907h@).HqEN}K+Yr\nb3@K1 )lA˧=#HiLʄ5oAB>Y@\n1H!+ȣs0GH~^7ـQrI8\0Ì`\nw=0Ay[Q8HOg m#ʮukHB#oufoݐk^!p{}4Iv?x{CY-ICמȒ>0l\r\0|Q15L/j3;Lﴷ^{Un(}bW١+>'{WsC~qM;PRv̢Ɗ:pQG 7a;_z)|:g\0Y*/kė\n>U0xH@-=\"0H^UE+x+#;1kyTh:G&-!qs3^|xW-l!׸FXt]BXY;QL0cIojAQLGG%\$(wҹEhXKaob5sAt/\rݒ`w7<MP*yYh>Pr=zjW01gdliD/}^V\"b>XRnr.0̙9@ ۮȷ;&^2hYXh(b\0؀/\0l:0܂?t%> CG4@@E< h	O0K\0@r[\")AoX4z NR̃`jkP ]Ol2\n*b5Dn2(\$<)Hac:ϋ/8i:n6:0;<1LP\$ أY\$:0jIP\nrL!wN\0>~/`4+\0<^RXU6:\0bN莌*.Npxp_ 8\0XoKb蘖|l\0Ɩ)\0P:<pl\n@ASPPƚ\\ A03\0006 (.pv}9z@N\$ņ?5ㅟi+Av8`y \n;  Vp߀\"jE=x0d\$PV	xXg\\?\0ePaAJ/`pSLЙ	(PYBqОA!.bVs\$	|Pf%gzTAk0l%.l5I+8I+BH*pQ\nG^B	rLPUBqhBnB,b4Y`	|#`.B.B\$6!*s\$#<B%Q*e	NrL\0N1!i+\0Ѥ\"60bCgaN\rPUCq/P\$BNIB,%#-\r+eh&pº/d+PC-BD;DC}<BB:0Ï\rPCPBi1r	'c[\r?P*?³+pA,1Q\0L@qDh.YP`0@6Qb\n\rޕ0\r\$1@=ĺB֔ -tXBC1,+BI%	ֳ(KT\0F@/7X\nD``[ΕpDLDQ\0\0N`3^\n@%	9\0[ 	LMA믤Q2Q8)HWGDb%\np	S(#tDHQq[f]\\'(B@^(CCvV[Ř`(^EZc!7ÑE*Y1mEuY_E\\`Ec,[1e]`E\"䆬86 zq]hŀx@OE\$O6}Qq=!\nŐ<b:QcO'b\nT(|QqFR`&E*1R!L^f``ņc\0^H!yg|F\rbFl<ƐcqeFipFhϖ\0]Qhqbƨ4O #\$=\$gFkFp.<\0k`nƦO(J [qFj1F4\\(3\\TgD-TCA+ \r7Mx	\0Z	R\0005p\r1E\nVI(;R~[>`36rp	%-Ж\0	dCñ(9Ax@2!*`\0002ǲ~8S	PAڏ/ #揩-81nt*\0#O0=0	'\0d	( xG  \$\0H(2\n3fn 7\ñ`7GF@>H.5 >?B><z\$`>0RtY+ FQ΃ l@>\0̅10\$VƴK&\0@0 H>4o\0006q81P=9\n17\0D*<#H\"1|#!K3=~=nmH,#,{I#t~) ֓\r b6I!1gE/r\$)\06̎'0v3g@\\@\0! 3!4HdLf_9r,[xebf HHhpf1~D%,a)0֥%<Nc>& K!K0-;H0&܏ଛ.|#.@3!K\0002\0!07ʿeJ9h\\=dT\\\0QDId\r(II 8DrZ~(;bJ8CU!RH\r 3Iė_AN#321@{@J+#=R}2-~H.!`:T^!K)Jл(\\-\"#L0	tʃ)d/!r]8ы.SKҐ\0H\\wG:)Gʘ5+N	N\rJt0&(\na!Is!!d10D	2:53)WJ%:0˂#Z*H-k״\rR<-|Z2L\0dxKAty2vLA8\0K3+\\{e뼠!ֲ\$gI.O#򝂵)>\$g!P؀6KF#q\nWP2NzS{)|/'(kfQ*JdJ>!02\00Rbr4yJ\r <^H@SdWlT\\TTF;q!MCx!\$9_Ay?z2|I|.2)*cBR+2ԭ`K2\\R˛+B0˙L43d)(G,\"̈Ғ3xS?L3<SAM.t2. !+%8!JH@K%4A3N*d,M4/ſZcO1\r\0\0(M</Q5̭38J75S_=5ܩA-0:)~HRQt͑\0\rsdGsdL.[6@562M̒-/	\0cLΦMe7xq\0003b44`1.j@H46\$W6\0\ri\ny\08h;>Q_<40?RH10G(LfQ5/xXsbL`<8{rSɭ9@B8x6'N\nRQf`8|\n'ԟ6T(2^A*/'0Et*xɇ#dgHRH(BU#`\n\$c\0(#92\r>\n`CrKHP eP7\$8҆6Y6|ThRЄ,4sǊ* K)DsJVԟ5\nMH?/|\0006@.Lh˨>KvL\"!K(\nIOv)I v6Ü3>d!Of/KLv0	T\nؑ,,ܹ6M|Od!'U=C/Jd*ǭF<Ӹ!H;ڂ;љA~^<aSe2֘=O1 9L{9,:9,7-\0`\0` u:1| e1VL#A	Ap\r`7)@,dġ{+5\0b`LhU\nЦe\nSΖ}\0JA!2\0A,u\0006PKQ|3O	PS68\0%@0ɦ\nL5.ə \0',<)@?(P5JgI\rd9\0T̒)BLA\$cb)\rXCO(\$NJqHV `\"M8t\r;03|QC7XLu1}3X:bO4]UMaE?T=%0␂C!TLH`*P8K/\\K6{SY+͐KQ6@6V͑<eIP6CSzO\0Pf>80a\"gI,gmFᙔrId|FR\$ ȋH!2FܦP HR		8a5Ih.QL(@;\rZ3%\0=)@B*H?T\0#I\rJpLJU%eR_I&@:R%&ԪRq+*RY?R\"J*R3JiԬ\",F5&j6.'KE+ԣ&u)TRML)TLD~ԹRESK	ԤK1!L7DcK-34DA/x%T@SVIS^= `\r\n5#0	R2Q8TI#%Swނ|R7Ӝ/E\0~0A/\$ӿ@82L!dtYO|7<a(ʮ64d@\rO;tA?QiIᏐ|&,<w-C\$0ۀ+B1P\"*#\0HEJO5\0\r]O첈^\rxz:^	_(6M'%[-i]F#ғN\0ĕLN4f#i:SX@4%[ʙ =&#eHc\08f  p4\0ag/eD,Aڀ@bE	\$PJj2\0*: .24ࣨ-P@u=)\n=x )\0򔂀=\n`+H()\0#x&=:ki&)H+>UՇChi\0OZ~@+x	\".F?B	BmAC[DmQuFjR/4TuK%TMDcW!B\0EГ`ɏ=&L=cϏB(\n̨[0U\n Oό1EUTu]\rU\\D[\rG`1'XdUT?CHsV3WEcuu!Xu\$,B}e5~UP1.'A:>p èi\nSSE\n1\"T@@#lN1[(ñ:PQUl4D[%lЄ%[XuD5b	kHbDpqW]p@9\0[R8Ŋ(-RN..UpTW%\\*U̦)\\Ⴡ@CtU͟j\"\0<WRc}uuu]v3Qs!]}WX]w.mu<I\\ 5׹rdh^usM+ 9Eu\njWy^UW[_E{҄H>WA~U_:k]xٵ\0b(\\B\$89\\dX4UمaH8W#es^A?+=u\0`ĵ|\0z)upQu)`]xOu@6ew`q9? W@hv#	@m\$X+ <~(f\"jDe1X_=rA=W9\\ 5c=E@l1X̐: ^\0\$=bMsخFVb\$Y	b8WCTs6%Y @(-)Tb/DؑdH؜L`@d	VG=eUvX\neZWF{MMY9eMѲu2GN(-(+b	K_fX#f9dcvnRb%4'-\"\n9\$(JW%fՙ6j@7gvr4d/1g׀[e}Ӈc%cNJ\$aa٬N	Y2dSbQ`\0ŠW\rr,H\rhrQ\"i\nFKK;iP+Viupc3]֚Z`8j\0-Ei+d]\"ىh	VLϼŕf}1j67dM\"XYjW@١A\re%\0jbtY:Zev(ծ6dAZk\riEK6l*<J]hu 6[#lb;bճvdtt7JtAو8A\nlxҖZ&!~Ҙ[OmHմ~<\0mZm,[Gdui-DqZL66[nE ۇej1[l6ޗJ}s/[me#mJvF7n?Jt[R\\6YoLc`5ovmX-6acZsl%C@[Wa [W[Mog\\/\0o \"sbM9dģ58<v#4m,}نV|MlS\\im;ᆞ+YQrEȷ%rj7ۯa}ZMrW\"ܝs3؊(B4q76qCo*+qhsv<oՔW-r7?ܧt\r صt->tH)rJ7\"@w]Ŭ7IYpmҷ7XYt\nG]\rp\rQ\n8\n2ѰTezP\0=vNE#ܽu̗Eiu-Ns^.}Cܕd˂2]1f.gr04x>WvE7.]jU\\k4q!twIF]pwq5w)\0qp\0\"\0_az]^7v][-ܗ<vޖL7c]a7?\$-7;^w5v]=vagv	k\$w;Z!Vql@;V0l\\[v-`X xW_\"n <^uw^ew=ӷ]rup*urZ[]G>é5C̻(0*ɒV0W	(\nՂ[z`)^Zkɱ'#\n\n^()BiW \n\nݦ 7<'@	^:3\0*@\nЏJ&h\n| z\0)_\n=젠_D=h\n5_Z`*\03.(\n'!h'(`«>< -\0{zi /L8`/:IUv@Z]<_{0~=`m{,7E{=+c~l}5W_X&\$Jk1m7O{%8hx`\"'{}7^袍Ѐt@\$z\nVi߱{i&JW|\n	UZw_NW(:_RR3}`&\niAh0\0	|ES_%_2֠7߶8|{8%_Y}pc\0}k_k_s}_~Ώ?`	׻{Lpf8;\0^8\0_E`\"b<wߍ~@	_-Jߣ̀_-:fW_~Mia1~~w=&_?ZouU7|XJaUrbdpZ	ը<wЙ0f#U{~@&_	*Ԁ{zw_3`#\$(0gUPX?Rk`>+\$.8gÆxlIa8[{X8aI\n\rc~aͅWx?\r8&L>!^|ڏt=a`=؍߫ %d	M}x\nW+|- Ux	iaCWa-s߯'f(Z'}צ\"^'b\nxkb=5hdCݏz=6\$C؀&+~%8\0W`'`v&Y\n&0<cͨ<	 !M\0,8bɊ\$ď?EXc\nU&Aha108VF2عeNIbq3>\0V..؀Wɗb#a=BϨ[P*=	*踂`7q+H 	`\$U5k^=Z	b=}Xc.(d_3)_3Cb\nF1O,Qyc.#c	.A`>5LF9:<+uߋ\"V[(=>X%Ҍ=H\nS9axIvE a[ &2dh=PZVU]U#d^\n7FG\"&T&F?\0&Hy)bK9)w;P\n\$d#bˉ&JgvK#=nLX㍓H*ا^ۀ *'Kቍn,`::\0V	)&!|PزVO-ԧ}{b	PEe#OcgP+Zrt(O{rByLN22(&U	\0X぀kMf5]VXUU\\<paH#\0=ZXvW	,R`)f6Ucᄝ0,bըf'`%ᛔe݀^8\0^.\nX__P\0).B@dva9)'NO+~++XA-	j3	MaX]\"f)ـ>y:L\nŅ4VX_p0=-@§zUYb\0ȸx\n&jX&*ɋ_r{R7Ki+q3kw8f9{6]aVlb>jyfy<)(\nkfjԫ@X \0Q~@F8CL0@*\0`^~rxgD6tT|x# >u	e)YϪǝuJky2&eU{M;iUL=u#gX*t+0׾ȁ	 'UY^)5VՓ*X-Ua\"ǆ8`}aוU{gdn-8\0t9<Ldh ,=I0h8\":8	ԣc3h1\0iz86cd81hiֆ'X9|̏_aK)߯Xn9Z05\0ƈx\0<\nX.UWic::	Q&\nZ\r<Yփ9VgR踶bZb*IGkc.rmP\03Y\0\"'2UjIiI9]W`+L>-c<|\0Z煥\0e{󀉎NH=h+&@1dS^hy=fWUa3~XN;B+FOva\"Mwg턆cȀG'Gib)@XCf<\0``ڴ:c<p6<ƊcaX^Yc=-axCRKZ<ƛcf%?n,نg種>h/xH筑VyeYWVZ}l\0-jO8_[0\nY\\Q~#nZ>wy৪Y_[X\r궚ޫ|egUj:Սsˢa\nZ&ȭ\r`.I`{.n冭\nqƖWd.)a`>gX}8򸋀(\n.͛v{T7,3dg~0ؔ	<{<}3\$ϔ)8@R34:䵥]~6U!<@jZ ֺS^ӈB~ 5ɳ,S,(M9p 3X/Zu':Fp\\)|ƣX\r<Y8Xt脕!`6 4.6+ZP۰n<0&bw0>Sr<@6d\nzlOFRlO;H5ڝ*L^x0>g6s/qYe\0@<z=\$Cئ\n`+'S9X8_/ij	h75Y\0&cwa֡EɟXyfub{5ͳvGjgnXd\n{lǫ͙~V	?3W}R	Ch0>R= 79x>S\"ӂ4zҴ0f\"`1:愸x:x;Zd֔eK;@gTML7N3RkN(iF;)Orn:Ӷ\">^#e;n!Q\0/ԆfU\0\"@Rp6Bm0	!Yr/Tt1VeOQzBr9,@9m!t11;\"cmMu,S<ŮW\"yvK)VmV,bk\"1hxF&9t?܄Iq\0g5MK!,?!PSQGe@a:bHd@(: DdFJ1Ḣ 8w&@⍅'iVmL E/[RR˻ZnfՏٴ_GhlbŇl.3%I[c6 3k,IDX%JSoxvKBq[iDanO@۱m/|iK2RjfVrZEJng\0_H;PHDn-iQa))PgL6%lk:sk1SmNFo(SJIe:ԺJ=lF)ﲋ\$xͣ>Æ9Xo<'mHf!D;\0fSAr/;Vl<eػ2JA\$kUY 	d\0׻|pP!fZ\r@O'_x6;\\4%Z6[6tKŰ#u1|2XOo&6~DqO<<:Ӷ|p%%ֳR&\r*oʡx\0C[ʸ#:lpw\$KL;sh`aRnz;ϔ;|8L=OEǥH* )-T/⛲_H._%H7THSD5>S_cr~yE\0*^,͎FS=\0#>@cEMA7o\rRq{Sմ1''m{p0f2/<m:-HƸ%N'[Pwdf\n5<t	<n5F3+b*qedƫ0@S;鞒d:;=>؁=#NR2`Fd\"wQݵUNRutvӡ\r'K#O\0ɰ씑r'rH.|;OK.8L܄HT|sr̃IMr/4<䏦<rƖ05nln,l?Nࢃafܠ!fo~|@2/<%|1~iL	_1 5'}r!16Eo2s. \rr7<2<sn;r5*OlLDF@l[͜;]ͦHaGw75Y̚5H\$A\\<t|ARQD!D\\Iqv@}_lh(SKi)|iwTμO>,a>T4|sd`#y\nu,\rη@As8=tdYw&		NBhR2t %q,TwM[!O=xNHJ@C6F~a\n.Gq\"'(q\r8CvhJ`9\0/|t&w@&+\0]<bt?DqO:</aX!8YEUEl7G=aLt@1^><ЇQX܀	\0}?CwԜ]=EW\rNR+N#]?1oG}.wG}%6Q#@.h;N <P䐠18t⡼uπIM!]tU֨D7q&0ܛTz\0qH؇tI|`6lIeRM^.5ue^M_\"7_'o+0sQ?FH݋uXR+J̢O\\\r7`N|EtHwY_ݻOa#b@GkN0 SUh7=\$_0cx7e2qtDp0umbر*]^蝍%7N?l/PZwO=gnVŝ veթwn1a^]]<p\\ޜ&AzX4#ݯ7د_=k`Ћ}!E^Kطt2_Cط\\IX3طѝ:%՝w/PQ.ęGݬA?[ݓ'wd\n9p)Ƀr7vj[@!w^R1ڤ7[e;qm[wkش/5٢r, ?b']r[\r/5ݰׯr.%UZv-l6~BCGhS ougMp,O?Ddmw?]u! R4V_!xIw^H9_=>}0ނ)=HO_=dء펝 d 3]_6:xDx7BӼ\0]/=vIJ<AX΁,Me;G\0002x|&\ntSc4u}pv]\"9x_Ob'SK(KaDXSmǍ煇3_<;TMM\rHo*_-ޘR'NU:׬Hڪ%\05g-t\rik5\n`Hsͯis~qOo\r^m>\rO/f&?w	r3*}t󵉏<wO\\eV&d%}!.{Jfם&Fx8+R:,x\r^2uV]qOs]x=#CI}e1bҚotJIwP\$v<Fp<yN\\\0=+5Pl\nSȳӾ\\6탿vi9q4g#|ԤvzK޽t//5j_Io%!7ItQk\nMwLMpu!0K\n/W]ڐ[﮴jz)}\\X)O>}S8@\01G{?yUaG//K~K-O_7}*Oa{z%/,Ե\0#S=`7aZL{H^>p7EO\"/{=TN뽏]G.ԠW?]O߿vLVFʝ{JTmio@xO?z/0OY|.Pb|+ۏ\nJaW/+!?\\V_W|=Oʆ\\FhaboC@Oq|\nzO2j=EQIv074͈ͮ7=z2M=)M7[!jJ	}^wmhzx9{ݶMA|>o)0\"Bx}40K(\rmݹykߧ1|OnPt謔{Cqۏ\\d1ҟa.u]t7cnYDEVd5(}	g׽u\r<T\\\$cԫ*T֜;[q{]U}ն	_t5udkmq_޾7K>+y{&a?>N,5Q^}ѡ.}aEr>+̧@n?ce|X}'oce_vo{}-x~S_=wn\0;=|'8']{CÏn?[uIֱ4)~=uM=1]>F\$sRO\rMw{/I]?5N6uRyJ tZ\"ptV_ȩfsۇozfɹ7̫fVAY\$|z[nP;[\0[/eCҝO)wUBVW\\pT]_	G#_v}5^M/\nDdK\0B\$Qzj MD)5đ4!V\"XU\$\\!W:2Oʦp!V\r9bʰ	U1J\$.萧 p@.|\0TY)%؈V\0Jfs\0R%fp4\n\0GVj1Aq\neȢAtm4O)Ay?\r[^tTD@^GyHה@i%\rY8+ʸ_(٠E,dW<@WArH_\$;|	Q2KX-B˵wPCYD2%WT]2soZT@)jurKo-\\L`'Z/\0nwsazznk hlpUaKW6	\r\ni orV9``:z(.h#-<Nl[PtK5EZxdp\n+%\0	@UtixXpj7aOщZh`NUŁ)4ҲÈQk(M Yb-D\"8%@	G.db.\nzpW9g&˰C\nв^gi7-XїV\0\n{ӆ,m5j1Uk\n_`-,5e4y_\nق2й3ɓ@\$lFaߠ2 f\",Ba-0'Fȍ.h-iW~U DҊ`ќ!V84̒\r+I5&L/X3_%{EZ%s(6MQ9qYtfغ&\\M:86\rั_A~X\n\nXM!5̑1p<v-eg5Uk3\0%?<-</d<y@M0-& Vh	\0|c?h6c`+s\r&!0gj_=3P ÃٔCE3P{جB\\&l(7@Q\r'0B'beXlA'N2{m=xc*>	lZg4Gg\r)\0	\0APA%j\0\"Gg	F/:dyyH6kf2dfKr`B=ź{=F~̗baUt}!B	&<̗D2^f[%?F	/c Y/B	\0(AmB?\rt*plȡY\0+4Y!VIB#w'EI\\^&?(M\"ÄzZZ0\0Mj\r-HW!4BC_	 Y;8I%i1a'z];7L	e*霢+la73/_pXAcna}r(:AمU1&&́a'F3nK/`SX9Acu\n1_p1c?\nUa(\0hBcu\n3&2lLG\\4xXa!dj4Vg)Ն	-6з!+	\nk7#Xޯ6LݍZFm2(V\"EuX2\0cUų5&;,X\0Kl`=32VB`gjz4 	x׶*\n~yZh_t5{/`\$*^	Q\"X4dh֤!L<fV@ve[b5!GX^0)<&H/D0 A.7lFT!9K򧑾~L҂\0My\\=*[0.wZቚZke3WfU+8Ud2_W-SPYPF*mH	,+6fRY3a'#<a\nUWB	L=0ɼ\$'Rȭ|TVHIAOzv}L4ن?v4gN%V.\0D;lz`<	؈DKgQR\"s9WQY4lzνthuz&c&\$cD!04^4M!35%WhlbZ]?bZ{'1\">'٣iΕt#\$h@IWZR.ҤYA&ҳ_\nɝEeL.YćH,3NtkZ|'i\"f 90H'z0Z)'ԮLk͏ҲBFa1O\0+ V&	/*\0XfW0][x?M)2F!fiI\nܤ,Ԡۙ<0,X]Λ\$tB#tխSHh~\\\\*J)nDNDѼnTbA	R!{u)^mzE!ntf[{6q֤yFƀ/\n\rB:<I\"\\*MhC[o>f #pn	CK	q<:`6ߎEK4\$,ة@wUQ4T\0mԈ\\ZD1ٸ3%>`J1oq{/|krckj|qoX&aFY%4~+\$>;^|[1w8vzC @7o:	H!Ŕ4`\rJaD|\"MXPpܻ؋NYhXOR25;8){(>0إ*A\n)L-ba/w0JG8.C\"s1m@*T\$w>L!M}6WU,l=1!Qh/-i\n<_6GFFp:b6-܉*7[VqH:G΁FFqJ\nJR-['Ip\$)%ÌdIvd 鉣q@LSɇ/ Ep1ɀHSNydM#F=Yړ&i_Q\$߱ZAddrƼld\"~!;ne{ЎQޠj	qFΌsFrwRͶRqQq**pJnL7 Y'Fn؆,^GF\\({Vs;LۉhRӂKJ5җ#C;>Sv5[#O~TXe@)4ݬV.8LTUFLفcdF|8lciT~6kUqn4|n7jREo2!n)\0!g4@c6',o=6B8^=m20KxF!TȦqXQu!Ndh)?jtB2*(.RAH,Z'QB&\0֛9݆v4çxmʞ:=xnޫA&:[gbUtQtN:Zn1Q^[CvpS(禮I8X(*TQ#ݎg/8\"_iq;G?ҋwn\$c>PmU㽀dqۤxIGy̟i	PQ9Ysd\0]<Ǳ)LcAX/[p%D@Ju|ziA;,u\\|~CB>8`K#ƅSPۉzOQ\0W*M~E\ncǸ#>t1cG	I}Rx5ST*XM\"n;J\\L+\$X¨̭{1kIJ\$\"Z@u8_{uk.tݏ>2	dPS QNgv0sjdx_ov\\mĒ,FQ|v^SY	 c\$|v}m2ǻmZ9&-B.2H\0=<ؐDd3bn&lJm>q# H\\j	4@xCCzSlqI?\r	'6GtG!J\\^Dkŧ@bTu'(ȉ>ܪjR?HQ2˴ڟU']Rl/+1/O֞F%}:iG&Z\0n	`)`a\"fQԋw6~*#18'nx/dc`WQ>Ї#KN\$N!O(@GyE\$)F[{!T #J|AX%o޼w|Q4n`ᑨQceus2#\\gIjGjj+TvׯDcI*x02\$}j?[tq_\"h% ;W\n#Dj&LDtS#F@'NKpEm\$cIQۍ/MR,za4bOR{)Ly`s0E#܊)2?tK|gO`:E&f=h\0RR;uvr۶#o\$9Ig#RKd{]yك^Y.IM;\0'P^<#6*|nGYISXtKN{2HbUD(ޱ3ii!oMID|Rzޑ'wmG 5)O?ZqP+\nF%?W[\"PhW\$I'?TJ,nJGG\$؟@*T`Rs	QG8eF˔T\$y/]^\0R3oi#))F@ne)/Y=#RR+`c7ȆT`?iBFv %'Q8@/*^4ؤz	=\$}\0M<ZO'\$mB0NA\r>\$gJod+Mdr2ۏ(aZS1q9?좉BNMRtʨ@_U8\$BXb?̫aͯ\0>uBU	Wn\0%K >RHN4:I8}\"x!uGI=)	cwÝUe(D}@J4cL1lv?W|T^eBiώPٓ)O.SX-'0ДN .Xkb\r_z|aאּb#v@NXt#%ƃTz[Bpz2VdB!VhuTIJU|xH\0BFBπ@\\\n9FfI X!\\c,Z!-Cte	薸Ԕ	՟(UPҴYjRї+LD\\H\0jզ\\V,ZȢFB2VxxQ7PQC|%-q`Hˋ'r VZ]Kv)_\\)q,6o. uv垊Ww	\\݋%Q˓0,vrm;e.y\\v't^?-9aIit#q2;>{[4+e@^-N^0y`^≯)i28HE-B`c\0N%6{ȘX90il1&p|%	pC61[\"uC\\eVXwl4&2\0XI/2e3\015WAa\0aT6V0a0`YLf0U\\i0rLZXB3`y0z6k ѱИ.NY:0sX3ЈA4 ,eY3(RρL\$,HlkgsR\"I`o\"0]#Cƃ1S4:hp	6eb41eU؍Z3h\"4GZWW(V1V6!YT5A}k+&9D.U};-*i&\$U~q'bPD(ZF1*	=Prq,Y5gzcQ]CdZ&Rv0æV#\rj5eP]CX˰+6	YHH<ajK\"TPX?aA\n\$ę1&i;)7H.2'+iT.\"l\nڡȤVcO36mhD/3n4|>XHR}&soEi\rRׁ+l%!p\$7N0^pM۠OE-zg%1!kGUǧs\0lz9B.K/^=M7fLߵrF|	lї)OZR#7r#L0)'\"^aԕS*S/JMbuq!W	sҔ&FёƝ83(9|fQk*p5	t*ͩ=3w\nZOS\\Q5Nh#B-M+Kӕ+K\$=v69!K[NH'ZXVOD;&MBFnTfoҝK0NU2-D귎Qn\$e%@-\0,\0Չ%-ZYt)f*+>B8f*EwKQ8N<B\\Kv\\;7tM2oLGNe2G@V(@@\0001\0n0\04\0g8@\0pZ8P@\rN\$\0l\0Yǳ+8yǦ\04\0ǳ@NP\0qS'@ml@N6F\0qiӌ@7\0l\0q|Ā@\0007Z9ps=Nr99/799S.Zo8sg?N.\0s9q4\0S'GP:.t|Y'N.\0m8Zo8N:8s@\r6MA:ud3g*NkI9ד'GNg\0`\0gΠ8t03RN8\0d\0rΠ'aN*:ryS'4\0000\0k;:sssg_Nh;vqyӜ,N:Ns`\rрc6\0st#3(Ŝ:jwNǜ9sͳ'8Ρ\0uͳH~i;rYӾN\r:riNa\n\0y\\Yǧ7O	-;wiـ\rgb\0jsTٓg#̞9t\0@N:JryS	ĀN.+8ڀI۝;r@\rN˝:bst	ᓓ'SW9sޓ֧fNC;sڳ0JM=jrsO{6=rI\099z8 'DNܞ9tSOW;|i瓛pE;yl \r'N\0e>sy'Sτk<zxyɳ'Ov<}џg:F|i܀gNa>Jr<iIOO<{IœiN:m<js'n-t9V|Ti䧴N#9g	>qy'9Bw4S3;{Dݳ'T[9y\03'Zc9V~)-NI%>:uiNm<D!O\\:siٳ'6-:v3ߧq%h\0}9'P@<{H\nP4A:y\0˳@dk=t	3gO?NuZ	SQ=yFN?r9sYι>&s9Q}:xڄ%4c};u3t=vMYʳHD\0:JrS/Pi:^߳ͭλ;~z-Ӵ0:q(\$N4U<J93/Oơq=j~	yɳ'LU;<ڄӝrO:*ͳ᧘()>XУ=uZ4&:t\0hSOB\"y˴5'φ9:{\n\0p@sTSg8N-?Vv<ZSΡY@rY3'P|>6\r蓽'oϪWCRzhO\0M9s|ySP\0m?:)ʴ2j@}zN➛9v\n@N?D،	-gP7!@q])̔='P;~e\0s'U؟Brvy'N9by4\n֧n9BZq*Sg7S9-\0I'/Η;9{DS&OWD|Tj\"3רP*a;4'7d83gѓ=2r93hQ%Frs\0tDώaBx	N08-	_K4Y>ޅZ,k(UяD\r0hQE:S\n3X=	(9O;#;rZ\0gЫ'D۔_OhYGj͓,NnO=bx]9TUPQ@6q\$z~I@^	i(Dʀ})4d)PTT4^\r<)>NFΉ-!:4NP.>{(wCI3'&R!cFS}O>*Y\rhΗXq\rZSgN;IE=!3t:PHDUt=V#Mr\rYTK\0ԡo8ySgNWGmTC`P#E~}	ZM>KzCr}\$9sO%9khJQӤgQ/@P#Hʍ\nDPK5F5\0%'Q٠EsOS>Vm;Th^B	-4<Qs)> IͳPB};&NLgDmyt\\K\"vSIiL2@BsE	U:tUT(MCS)k=sE)Y۔bvR:*|3)=ˢ:2|\$'PU=:yi9QL\"\nt((|҂;\"uUsR\0z</mbʱPze1XG/fb7)TYZ'~}^,O:b8JiY	bى5iYL\"V\"5cR@Jl4<)SiMn;nCf:S bl 5/)LB`	U~y@S1%\\8Jla	Z4Z֩1_&:6-=#P^SJ:n\r)^_	y7~Wt]*tf\"mINm4i`lw<]pk4~]PZi4%L2FrD	0&KL,p3V-X->6SV<85Zi312eۃTGQKbJP3ntµQb4DܱWkf+YSaU͋yvp\0¯&;P16.\rjbb;\0\0Iٕ4`ǡT=&Lf͚6\0\0EmDJр)'\$83;,B[`38iS`nٻ\0V\"\0sk1@״Os_Uf/afWG~}5m#يӧJ&\"Hڍ\0aj\rTMPҤjw#ؙ6cC!וּޯ}#M>\n:!SV_RfR]ße3U&Tby`U8OC˖\rLBx3i3f&J2'\nj;i<}\0C'8˧@+J,nC0DW\$ǥ>wVXVS|hM V\"I'ĩ:Vh6֎,/f\n3Val^kMOY-/Z)b\rM<	0&aڣ\0M_?Q'pKCqTŋp ߴvV{TZi5OؗFf!U~CeURCH	\n%ShUU*.EM)ǵCRX5P\$&\r\n0QUK7UJ*/jb',(u?_UWkQj4i<g\nfU8^0XI[]M5SxSJZɰ<UfǪhCRU9ЪDfpMj#46jd`=Y6abV[dUpU7U\\DVUbqMUW1ąsV֭T*ߩTҝK15e2Y&́[PQ&\0CV~SrcQ&%dL.vQd	eX^p!3U\"nBTa}cT\r`ڒx@ZcuTƎ*BWV4/uQL]bZhSIՃUF\nUB|UfXUU{깕WZլfՋ=Vcy*ƌjSoY\n-\nl+d<5a}ewM}Z:ua'bVb07Yefj5ej\"(EW/U* /VY­=ek0ց[VZa}կC0'rc26q ڷYC!f\riգZ·IWug\nlMjͬZZAjUt_WbU3թ6a:v+UU&0kd0\rg\nZYg\nڗV\0&V6\rRj5k쫠{Oxw+aT\n\rB2m<*A1TRÕ؎SFT\rbzxK+xAU:p\nTV3\rocӬ{Zڷ5q:VDEMjqZ\nVQfuY\"U~\\fSudVbeV\";䕠7;0gJ0٫;Fa³YQY%tu\n3euh7U֑hƥif~+֚\rZq|K\"i,	ռVu5kQC\\\\uݪVeFqzʕ+֓]ik,+3[5t:U*C]⶜\n,*SBk[nm5W3yCkqCh6̙|%`}@@\$׺-X:sOv\0pwWFV9\r30JW&]|\rDPH\0V*0昬0*֌`WN܊\r~Wӕ̪R9:5̱Xa~;p-&_8SɈO{Ne{?V\0N\rp\nmaWgO݀\0Lɜ\rg`vx,YY`)5ZΡ~}yY/\0l1fmC38'}_&:913, .N	4@inO@y`XU=XlGaP<<\nhTCOśv̖kBu{} ݬXOfl;Yaګ9=u*X&[ɢ|,@Y+b\">I쪳ay\\)Uu9\nzj&`uLQ,	aUS\nv#lH;b6ՊZXbOձ儦1l\\8~&5Sz޺P042;)~\\Xg~Umu-kX۰caYvPplqXb°V-:Jg%T<tVUf&LO5``H_cSWϨFM؈bcӺv}vs	xrȓ3ڋ5Il\$*Bn@1p'Oa9'lhPm2{64(mOfCVle,zUVuYT?J^+:0\"0'cU(WTh7X>eW}I5eX1jYYzN\r{#vZkA\0\rT5=MɣUŮ^L	%:;Zf\$&HL\n*9Uh9_Սk[a|A[aUhvU\r\"6*TDeRr3s\r@RLJ}5V7Y=eu\n;,ٻ` 7o)Qy\nN2~Fj=}-T^gJ\"@JOZ\nj@i;2+Aܲ*{;ꬳC: L\"k\0+D=[Lճd\rd̉2oe`=wjԬ`2q5BE\nbsR=T:PlEĸ~NKfYYYʦi`{-fblvoc|=t gְALrV+ٿjM;XAY;[H\rpͫ-gYm1Ʊ_Tz9Xaw@+2c^\". \nf`{]cجs`O\03n^ӦJ2mfڂ&ξ[D-Aj-X֎tU5Cjg%Sbcډ1\n;bYV~a1jݝPv08`L햒dw*|i˵EkVY(Ȣ06 @!Mkͬ-\"G\0(PSQW3s@0ŭU~9\$#A:;*Yh*ٛ-n[lsȠ !5 1ɀ.#3ֿE<J\\'0l\"4P̕0?\0001d\0^\nĴg<\0\\TV@Y&4%;\"]m\nlr¼/\0kl	e!K[8Ml)x{g-\08l٨P6[@\0bཇacQ6AT	)Ԑ[XmX7m-Tomnʹe6-hmKnQm[SmKoa{m-Ֆm[DmhYmmA{)\$@mڐIېI!e[k-ۚnJImomIѭۗn\rj-RnV0V-۟nf-IVm]m-\$-[·Qo&܌+u-RnISoV[ڷonލ{7ۄm-qVmmv-K}ȷo]|Э巧oڽ[zopMk{\05|g[pZvE\0[a7oܵev\r'm6 sD˅\0In\\2Yn;y	\0De4Lop59\nr4pf⽿ˁ(Amq*S&[D1p4ۆ7\n%Oo	7-\\O<2n2]q;t2nz\0C&vmɸq8[6hdE mBE{v.L\\?rb]K#n+\\qrrv=W\$g\\r!r(m\\nț-nܫkr:k6.e[_s6-ۘW3nbYo>ܭۏ73nK-Ycm>e{o3q\\ qJ}{78i⹫sE{w8nֹrMzHw8n{qU뜗=vsϫw=\"#\09t0C8vLkS.~,pnitҌۥ(+w<.p:7Lg8\\>*;7HN.ssۧ7A	t.kL.N:t]ӹDuԋ.Not櫫T.odt{V.N?u*{<M9b+Z.VuL⻮w\\.NUi8=k3zu]w`.Nhv1݊Y:Jd.ݒ?vR|˳wf\r(/bdkg\\el˰\$i\0@ivqK&@]&\0ݝkW8]ĜvE͕j\nn]wB5k ]ƻ{s+wpe_>=Y3ٻwnt{ӌn]仏Gj{s7Y.P@vݹw~nҲ_t]Ğx{v(u2Lk^x6l×g\0 Ht{]tVHsGOOx\ru\$:gl^uzX  u\rWnnx뮗]yJT+-ۻyJ,[c/OxFr;wf]yVk.0wի.T< ˷n.Q;x\0=pz&\0v\$;7xV]CczV}Wn\nޚzzTkӗC#w[woG5w}ީ̷'}z e6 psk_]pK]k6Ζ}t9lx[\rl:WWC\0Ou\rsXe0~OA_]2sWCT\rHuX\0Kk']Z\0ض]V{XBu}{f\$xy_JtLjL(Y%[2t7VWgFI!PY]%\nv	*TBZ.Wš):Zf%YUVZ7:VAfh*ClU\\ʅU|ogׄ)\\;{ڵ|okXMĚ7a`\nh\$)or1k_\n{!>{4@\nрDV^K5ReVƥwcp2^05K7a4Wwf-p\na\\ƫWd-!E*_}.-d۪XGɂ8rʲ^0ZJ]7Xp!Tf\rh`͗X|겫+VY\ryk}mmJ1%W>s鷶a1~K۷:Vv+{rdFJ5_0!?*ڬy9ZDo\nPN8[!U筑Yve&`Fo207g,u-KXꇈ!1616Ρj,_CQE{\rچTzL[3k{fBRk ĳr¨d!YnóES'h<fթV\nt`)mlz%Qƣj\$=zii/4[	ŊJj2Z.o<s6E+_wHZ}Ύ0;0-`mޟe#`r<jp٭g6 HP&&\0005q<\\#~	ͥ-3#\$2_`(S\0'8 .Q`pK̇j&0N~a\$*\"Rl0qpP7Ւz\0`3^`}%ۺy`x:\$PUS6x<F`+~=AV\0=6߃{Υu_\"r\0¤lN@(D\rp1+@UF7/Mb.\${C0`L6\$.K;]m@gka`P	w MT6sۻPp6[^p\0/8-N\nl&AE⚺!\$G\n\$#ATL#}v酌Ei0;,,pF,Y@?^[H3ø.JH9_\n*T}HFZpfbajQ 0ڟ t~tXxd;h06EӆlgA-C\r5Oad`'6k\\	x8-FVpabe@ɪoQ0Ef\"B;*nAm*p,;u@a6RqdSL.l=cf,Qf!-g2dͣ&Sw;`iN`v\0\"R va!6eHQOO0>!ݾ4Xb+`{;uwbRȚT;ߎCPV#4)]\r7lcdb|B>ąKHxbď\r@ėlB%,8bYI%Kҍ3Ġ	a/q!q\rh2^&bt\0Q[+8Êpȍ|YN'\0A6aa,x%\$8hAyqnRAM@RqC\"\n}&bwtptvib@Ő|<WBf`?%'tW/dmLObq`H5#]F\r.+*oB8EŨݣ>W~1O+<#\003غ`X\r@00]ypDë`apR[+uP @;:-γ\0f8eclUv0e6\0bܵ=bӇ4х(\$0yG0<d@+#AKo#.H1jPg/QGS5%VҎbt\0NׂTLJܱƉ8JppEmr5`9MC\0_'\$#E!\\a)sې1\0rnqe7\nNt#Yf`@FqLz4Լo%[ZĎ\"gqMIV靿f)<]o!'ʗ@VϦ\0");}elseif($_GET["file"]=="logo.png"){header("Content-Type: image/png");echo"PNG\r\n\n\0\0\0\rIHDR\0\0\09\0\0\09\0\0\0~6\0\0\0000PLTE\0\0\0+NvYtssuIJ/.C\0\0\0tRNS\0@f\0\0\0	pHYs\0\0\0\0\0\0\0IDAT8ՔN@El϶p6G.\$=>	w5r}z7>P#\$Kj7ݶ?4mt&~3!00^Af0\",*4oEX(*Y	6	PcOW܊mr0~/L\rXj#mjC]Gm\0}ߑuA9X\n8VY+D#iqnKQ8J1Q6Y0`PbQ\\h~>:pSɀGEQ=I{*327\neLB~/R(\$) HQni6J	<-.wɪjVmm?SHvƩ\0^q)]U92,;Ǎ'p!X˃LD.tæ/wR	wdr2Ƥ4[=E5S+c\0\0\0\0IENDB`";}exit;}if($_GET["script"]=="version"){$p=get_temp_dir()."/adminer.version";@unlink($p);$r=file_open_lock($p);if($r)file_write_unlock($r,serialize(array("signature"=>$_POST["signature"],"version"=>$_POST["version"])));exit;}if(!$_SERVER["REQUEST_URI"])$_SERVER["REQUEST_URI"]=$_SERVER["ORIG_PATH_INFO"];if(!strpos($_SERVER["REQUEST_URI"],'?')&&$_SERVER["QUERY_STRING"]!="")$_SERVER["REQUEST_URI"].="?$_SERVER[QUERY_STRING]";if($_SERVER["HTTP_X_FORWARDED_PREFIX"])$_SERVER["REQUEST_URI"]=$_SERVER["HTTP_X_FORWARDED_PREFIX"].$_SERVER["REQUEST_URI"];define('Adminer\HTTPS',($_SERVER["HTTPS"]&&strcasecmp($_SERVER["HTTPS"],"off"))||ini_bool("session.cookie_secure"));@ini_set("session.use_trans_sid",'0');if(!defined("SID")){session_cache_limiter("");session_name("adminer_sid");session_set_cookie_params(0,preg_replace('~\?.*~','',$_SERVER["REQUEST_URI"]),"",HTTPS,true);session_start();}remove_slashes(array(&$_GET,&$_POST,&$_COOKIE),$cd);if(function_exists("get_magic_quotes_runtime")&&get_magic_quotes_runtime())set_magic_quotes_runtime(false);@set_time_limit(0);@ini_set("precision",'15');function
lang($v,$Nf=null){if(is_string($v)){$Rg=array_search($v,get_translations("en"));if($Rg!==false)$v=$Rg;}$wa=func_get_args();$wa[0]=Lang::$translations[$v]?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}function
lang_format($hj,$Nf=null){if(is_array($hj)){$Rg=($Nf==1?0:(LANG=='cs'||LANG=='sk'?($Nf&&$Nf<5?1:2):(LANG=='fr'?(!$Nf?0:1):(LANG=='pl'?($Nf%10>1&&$Nf%10<5&&$Nf/10%10!=1?1:2):(LANG=='sl'?($Nf%100==1?0:($Nf%100==2?1:($Nf%100==3||$Nf%100==4?2:3))):(LANG=='lt'?($Nf%10==1&&$Nf%100!=11?0:($Nf%10>1&&$Nf/10%10!=1?1:2)):(LANG=='lv'?($Nf%10==1&&$Nf%100!=11?0:($Nf?1:2)):(in_array(LANG,array('bs','ru','sr','uk'))?($Nf%10==1&&$Nf%100!=11?0:($Nf%10>1&&$Nf%10<5&&$Nf/10%10!=1?1:2)):1))))))));$hj=$hj[$Rg];}$hj=str_replace("'",'’',$hj);$wa=func_get_args();array_shift($wa);$od=str_replace("%d","%s",$hj);if($od!=$hj)$wa[0]=format_number($Nf);return
vsprintf($od,$wa);}function
langs(){return
array('en'=>'English','ar'=>'العربية','bg'=>'Български','bn'=>'বাংলা','bs'=>'Bosanski','ca'=>'Català','cs'=>'Čeština','da'=>'Dansk','de'=>'Deutsch','el'=>'Ελληνικά','es'=>'Español','et'=>'Eesti','fa'=>'فارسی','fi'=>'Suomi','fr'=>'Français','gl'=>'Galego','he'=>'עברית','hi'=>'हिन्दी','hu'=>'Magyar','id'=>'Bahasa Indonesia','it'=>'Italiano','ja'=>'日本語','ka'=>'ქართული','ko'=>'한국어','lt'=>'Lietuvių','lv'=>'Latviešu','ms'=>'Bahasa Melayu','nl'=>'Nederlands','no'=>'Norsk','pl'=>'Polski','pt'=>'Português','pt-br'=>'Português (Brazil)','ro'=>'Limba Română','ru'=>'Русский','sk'=>'Slovenčina','sl'=>'Slovenski','sr'=>'Српски','sv'=>'Svenska','ta'=>'த‌மிழ்','th'=>'ภาษาไทย','tr'=>'Türkçe','uk'=>'Українська','uz'=>'Oʻzbekcha','vi'=>'Tiếng Việt','zh'=>'简体中文','zh-tw'=>'繁體中文',);}function
switch_lang(){echo"<form action='' method='post'>\n<div id='lang'>","<label>".lang(19).": ".html_select("lang",langs(),LANG,"this.form.submit();")."</label>"," <input type='submit' value='".lang(20)."' class='hidden'>\n",input_token(),"</div>\n</form>\n";}if(isset($_POST["lang"])&&verify_token()){cookie("adminer_lang",$_POST["lang"]);$_SESSION["lang"]=$_POST["lang"];redirect(remove_from_uri());}$ba="en";if(idx(langs(),$_COOKIE["adminer_lang"])){cookie("adminer_lang",$_COOKIE["adminer_lang"]);$ba=$_COOKIE["adminer_lang"];}elseif(idx(langs(),$_SESSION["lang"]))$ba=$_SESSION["lang"];else{$ja=array();preg_match_all('~([-a-z]+)(;q=([0-9.]+))?~',str_replace("_","-",strtolower($_SERVER["HTTP_ACCEPT_LANGUAGE"])),$df,PREG_SET_ORDER);foreach($df
as$A)$ja[$A[1]]=(isset($A[3])?$A[3]:1);arsort($ja);foreach($ja
as$y=>$hh){if(idx(langs(),$y)){$ba=$y;break;}$y=preg_replace('~-.*~','',$y);if(!isset($ja[$y])&&idx(langs(),$y)){$ba=$y;break;}}}define('Adminer\LANG',$ba);class
Lang{static$translations;}Lang::$translations=(array)$_SESSION["translations"];if($_SESSION["translations_version"]!=LANG.
1793034228){Lang::$translations=array();$_SESSION["translations_version"]=LANG.
1793034228;}if(!Lang::$translations){Lang::$translations=get_translations(LANG);$_SESSION["translations"]=Lang::$translations;}function
get_translations($Ke){switch($Ke){case"en":$f="%(n0Q :\r	@a0p(a<MSl\\;bѨ\\zNb)̅#FCyfn7Y	h5\r1rNQ<ΰC|~\n7&sL \n'CΐY:E2NIrD#y\n,؄	@-Giў}\rL0hCnXOeistXo7-Xd\"DꭦpQ΂qaUus]\0n(9	0Մ̽s-4#w#_ul!j<3&ip(j(É ī:!P)SKh9+:>(6qR<(ԪpHDX\ntJ289Cz7G@6ƞ\n8=L.1i4,J0o{04+0z\r8a^(\\ʍ|2j\rJb7L6^0+2j63`C#RΫZ(2^F@P\n΁6`Ag3(7\$*+ME6ō:1\n[l=RèTk3_>1\0S<B`PȟL-k\$MIhϫa|]cE]Ԋ\"`@d7r@ӫU\ns\\e8tj8xDd05ѤZ`ɲ6ʨ(2-sb#lϢhНtShj{FN\r.+\"<U\";;R8֜H|&ko(M(-*o<IV3\rQ#MP7X<e0#5'r֕r4Ow~0L^6M(yHl@~6vn3ͫ'\rZgN r\rzbea;P*\rBuTP.Q87xB@C2q_\$887F%aHI	P.o2PD?\$jt)U.aRrNmE*K\rd\$la;.~\nsƌ;i#l5a!=Hϐc/4/4C\\b.zOY*@\$c3Rc^xl4dusLj,fRn\$ܼf4Ê 4\$`92r||SIa\r赧զg{*?_L\0ES\nAE`٭2<>G \$D&%hpL\"a%PMS[WD+<H2X<&Ń@L]'3BJJV?`13g	2-2&xS\nàJ'g} ѩ|oo0\r^!\"dU2*niAP`'lјMG6'\nh\0Q\$A\$P*P_\0D0\"V(Ѩ	yH+G\0VDm)'\\S2c*D%mI5h=&3%[n3\nЛ<HlP\n\n~b\\\n&h16g uM>a5HMz%'%k׸2Z%yCpAHߤR+&7)J}Y4bU&Y_VWrdIq[4ۊS,A0߈WJDzQCa6ːCVDwE+B\"L2ܾ\\P';Wa%_\nx4֙q9/t*@@ E˻#g9-\n-#։(GQC\"<%MaH0Ү4c@JimaI{n6&`</P-\0tWҀD-(F+Z%}T(Z-| E2[Ȯ%囫yF2-ĕf I}V&;\\0lfϹ8TZr	F⶯2L%1&r%FF,zf<mA,v\rWOqo[S^NĽ匣[{Dx\$ed1qa^\0!~=6Qg#?E˦!uzxpZ3huZ{C9ۋ9w6;~;,mÞ/Im\nm;.3H׏>6>\rkZ|~rUZ^5uȕ}_'e^MNaΫU2#c~<{?\n|̯_>7~K\\B]3uP'rdCi)h/!Da\"x(T,(F[:+DE^N>X11<,,:FHKVI4\"lBplr+\0NBpzR5TFB	Xc\$'j5l6OT0B#f/\0:ŭ_FDIȆL V~̾Bc\$ʀ+ZDgFFpeMpң\rkj\\t[I1gP\0[`IQPveHbqMDoq\r\$3uc=Dn\n-\n1vb;BL	aā#~E\n\\J~ދm\nLPH\rhӅ2X\"qZG,!-qҙNM4cץ\ro td2\rVȏ#3zǀ/D%頰\0Z<59jH\$L!-.h( 4\\/J/2A)Tz/\"B)~bS2x\n`e6n2c^8z:)T(ŌMZ+VD.)!zV%g-r^K-FhW/rNR:fdJ70L:kHVƋ\0q0T9~@na\"S:3P0ˤ-D\$2&G-6J~=LphS#8?v~D+L*.iPn\0(BlD*E";break;case"ar":$f="%)l*C(Xl\"qd+aN.6d^\"(<elV&,lS\nA#RNd|X\nFC1l7`jR[-sa_Nvf~C(BKrT򧈪J4G\"#3T2ΊTr<Pߣ)cSIdu'c(oFe3Nbp2Nӡӻ:L[y&\\d\\ZuJ-t6YG'˨k(4k)\nbƢ*[^;\09Cx0mh7Mp: C(9pȟ	bL.A\n\$Nl(41ޞE\n\nVb̟h\\b>.Xs)isC,	Vϴ%2PloᲜ-B2E+qqɱzE3\0*Bʈ\"(2dб!3	BЕI\n\$.t.tR2\0 k2Ã=1C35\$1Bh4<801J9`@Y@2D49Ax^;܁pV|3(CIx\rsZp\r#x|Yl\n'+XSօJT?tǣ/[OLuF&l,j\$WB9\r\n0!HHB&8de5EH8\"[6C6+T:*\$QV(:ZE)+%E{\rKLdƺoOʋqk:lVг\"667SncJ\nb,ejB<y]bT=\$9Mk)nl>qm>n[ȧTuҜD4:_PK<䒑|]!\\l~l<+;>!I9th^\\:VhPK3A<FH s\r`0ePrF Ppr`A̐T\0rcPho6*Z=ey_<\0CW\09kH:(C8a}?N(`'/X8\rhEi \n>@V*܂֐ca2+jV[kuoƹW<A`uޅ@t`+P'rގ	)yM`FY1)ecʜT|(pB^kAV'ZkVL\\s.]˶e+I\rۆ *%CZD(.)v&\"%挘.,JRAZS69\0kCٜ4Z^QqEV97XٞᥭCX\"%DЌ@GU\0('BFRbɨ!TsH nUHl7uڴW4t7zO[}ezQȁ3GTTh^>qWnf%Ca7u(35UR~) _-SJ\\J+s%-DGM\n+uG\$\"aO0?^⍨H\"hMS0>RPr\0@ɧV2Q\r+U?N1ZŮ\0@hmXYgfjG\\U(sa	#\\E3m\n푢-H#m5WՇ`[,6La'YDMG\\C9@\$Kz	7}s	޵j0T\n!E\$}z(bRS.bP*P\0D0\"W0]hIo@(2VJ8po6'ϜH(QK锆Ů줜\"Jޛ\"hR|>Υ9^^Űe#pٳLW(FSuIvv;YꑯJ)T^\\I|e`6Z5SY]cPpD<zw`ʊ%Wm_nFd>[zØ\"HzkRy)ѐ&`o\\ص^AC94!ք@4)ELچP1'eȄEtH{vuWn}h[qԕDJ)e3@:,Yk\\Z>ӫa3i5ތ0!dr@Ic%NGЄՂ	N&zoN\nP 0/\r(f ^:+qD0&\"ƪq-74#h/\0*6M3p!`z\0sbi|[z6(aLрz̊jMĄ놌(=}9Qzo|rL܏D@̲A \$bT(k\rTX*V-.,((o-2#g%M,DR1F.\"(%bB&bXƆB\\y.HVcIxGƂdJǂ,GDNv4PE@DjB'!ޘD߰԰Ab\$y\0h1e0m61pvFGN0	l%>яF*~2\"snBjdx&Dhn2G8?b.bdK15c7*&ꎠ@\rAŐ\r\0kچ\$c`P\np-vj\r{ޖ!zQ.%Bgխqv}w\nug[*)Puan=\r'joqw\nªD^13-)F2ի{ȐHgLQ:q\r%Һ!Q!{'[\$dRg; *B <v!PPC9fpZB*rJ~MojdҚe2S*E^\rc!lgֻ[*3jWRRx/*?SN.# dpdm%c(b]3|ٯ=3r4<RX=gW&w&63gsV=K.s97\r}8Gm	+lq<'H:H3F%i\n3 z>i\"D;K8O#z<CG2kx=3y>>1=#\r53;3\$ѹ;`P<=g{o;Rk>tB#BcA9s75?s@h#Rh=#@\"?ERB@dF/gFTh5CvܮikH4pBAPtfC {<2\"GHu4xS);tEOL& ֣DRKS91O/DPtOf/&hSzGt?3\$C?Ͷ-,ư2ms(jsm\"wU.쎀1/02VedO&%Nڌl\0\r4hEkF8\rȪY@̚(>\nZNQ>Q-G\"1Xqhjg!϶loUc\"	\r5eՇc6\01<ow\0@ST`DulAJ2@,_%XCEZ/b(MBoCf1ZDvPL:ccOSdPTNE8ccv5CYF\rE\\d\\VҜ3dBcG	uAfA!Gpp!lF}P-qNo.Sn\rϴ@W@1l2@\$gt&T;OږD6S4Q͔R2#>\rkʺQf@Jd6&`	\0@	t\n`";break;case"bg":$f="%)h-Z(6Q\rA| P\rAtX4P)	EVLh.du\r4eܞ/-O!AH#8:ʥ4lcZ2͠.(\nY(\$\$1`(`1ƃQp9\$+JlYhmrF @#e2;*}BWoXc)ˆ9^PS'iVՎ=ruZt7F/KZ[;J#<aoJb%2KԶ,A%\r\r!/v=͡lq*o\$BNM\$ Ĭ&H4\$ﱭ\0\np7\r7I00c(@2\r(E:a!;\"K?!(o9\\KL;F(\r{26\n,\r`nD-+\"؅3ˁ+<: ģޤίF:r．QC\$h)[\$1&I\np'1s&#o*R)khϵ5ލH/&\$hii\rD50 h7E{2#1Ý31iG4@:CA\$r\\*90z\r8a^h\\0ڶZF8^2}}C ^+aGV\r7^0d#4.*FFBz˸1>T.frQcWՎ⵺[bz5L*((B9\r:\n9,Nٷ%M)뤕8ho#H1 )<Kd6sciRY-J\"u2uAWYB\"⊦;R X(#Pjo0)-KЃ30eMa|7.IJznP|>!IθOm~ƽ)\"b105;vJLI!Aգ51xҏ9mm:T(μ¡>8|(ZVLj,&lف@Syq6AƌbHs[gO\\2]tF!⠕diȒ [A3z	US\nk5,\0CB_@\n+l0\\	k`!C<o&@r2\r!uQ,\r6G#C(xas2ީn,xOG0/JyIOQ#N!@30tѾ;ǀh\nln|x!д+Ms.p	jG=CT%,LS31B#-:Օ4&Airj,=6\rۗeFoxw̌AΖ0ȉ<d*'@4.p@IP16\nKa݇Dc\0I0\"!\nO8GӴINY4	,:Bi1/ĔTӡ0ÞI%@RX#a)0!HXbfLɰ'j!B.!\$1PTszvK{;qR}MU(e95ǨT^K!1w\n(QTt,6@pEh6VC4a:5\r3ȅ޼AGR2\0)@n6Is(\$HNGAͿ-`S.\0/f@\n\n),b0E}\r`1xCzA;rHE\0޽n*)Vˆ1r(\"G;9&fZQi%rHtWxpp^%\$;p@ia3HqPa4\\hQMD4֦y[&#DG*Hs 7RUDG?\$1|R<:v\nrk&1Ho4w,PiM7\"HY+eyæ&zVL\$`}3Tŋz?Ml%%J=N3Ύ,	c:46ud\"OYTXtÑ8\\\\\$2-pb\0o4)sr-x_JwF_x*ȫ-z0TσKsAF~8*ˇ(ģox130HXcysIMF[gל먈ʋtQ۵萞ŞyR\\<F]t6Rg*@kɺB'Y-aMD(}gYV}鱮0+k0XۅlY;TŬYMD\$@nbv(n,a_v<f3`b,FTHrVGm}CL\\\$^ї:]1xd=[ \\]tc\r\n},uBAQ8JL!(wt\$=۷؆):@ʓ#fkX\\>\$\nmR\"k&gJɲr&@\ř`\$^\r\"@r\$jOkcF LǰXv{cʴNò\rb\nf\0Ft`	grB!EKP.б@E (n4k@r-ly\np+(5ȔPD/8(CdcR \n`\0G`\\HK[dS͌\"fjIKTQ\0n`^JmnQTMl8BJ?6+Z 1`=-4#\"!aQZE\"-N|):L\r!81&f恑dNQos}_#|ϊQRA6'\"vV?Ǯ.n\"F%(p\0Eڑ2Rs0z\$	r,N(\\p4NY#\$gdr4+6#,G\r';<ڂ'\"8 JjizLf.?{''؄1Fd(4+4R,LCdD-pc|CvB?p+ϼicd\rðya0=Tn[&jS\r22Jcc36Fp*:`EVr`vłtR@8`EMCE/8GzǮBN=Kph|jpy0O9T݆C+%3O0F.(W\rF\rL\rsSj39L4~\n.0S߂q\02( qY2o0S-,OG342Q;q4H)ESEm4Ft	EDC')\\)XHq3܆8C#cTCRv)äis\$?C찍kGFfCN\"cF1DԄZtNs@T9:Jp4gQNDLav5gBVfMvAe/JC䪾\":Ƕ0osK/Rd@rt4O	OR22=5OjCvP~밺)&&DOԀ'{UzճN^t44s.4O<D7\\lx|R/14NE%1\n֋&s;^;^C4]CGUtvUrpub=Ktr0'y)E}Ԡ*%k%LlL+_Ӑho`h\r[yHoR7V35aMGS!bPZ2ud\0uҥjybLHgL]!C^ul5+pkfӌ,EFgeR({p1T}I5@TEqBiu]֝pV7\r9eo\\H#`kHqpxU7w]#pp~S]豶w\\UP3ih֢Nr|0-tҸ0`	0\rjVGcw7w	wGyغLgxyJ-zEr!Bg<뤼׻\n\ng\\g0vWo_6}C+~WsCw1}kmmSQ~X^xȅa%%nGo-phjݘ3}7s6?DJX5CwwaK)'6g<|hAF)1qjsIOhIxbq1YIUs/\"!+71RSY+,츔!΅|{\$IMt.EMbbt>FSq#`U85H.NÁSUR㱤\0\npIhkGqw[BRMuV'ٔ	ؘRxXߕrdQj&''nn	l+H:1\$)Swg<mPgcmch:zzwnp2ST)QS*ȓ92vyFOwZ/8gyt:Vu~8\ri \$7z9ϰ'gtUO8DL3STU(n/)z|[<T*6Y6xVrCn'&Bهe'5\n8yegIPN*TkL.4nSH[Hx:%@\rE@kLR*\$`ؽ~\$8@";break;case"bn":$f="%)Ut<d sNb\nda\n 6#k:jKMŐD)RA%4}O&S+&e<Jаy#Fj4IjhjV\0B`ULcqؽ2`S4C- dOTSTLZ(JyBHWβt|,G8rgu\$)k2:4DZut*#w=vpylkuNkAAU2rǨݯ^ҙ^q*je6:KLWo@M \\\n\"=koں(XСPE1G\"26JB@6e6+eΔdȊOHXĚ6شz|/oOK(#ZɐF\nV)2ܙo1IPE4Ȏ{A\0P	%\$\nqG+l\\JjxI˲+HO\\-+,9H9i0ґ'bٷM9l;A4c#m,#CE4oKPRt-YFYn8K?>'JjGS:#[01*<474Dt%D=P귂tNP)\$ON'RLK]T2KKvP<6#p9S/e7Nޘ<\rP%x}(qf7R\0x0@2D49Ax^;pÛ9\\7C8^2x0cxDȌ)QE5M}x6=Im!'LDZuڏfU[3ΆzҴls\r<׮=\rXQ5EXue,F1E65F>O/B\$ߊo3vvS_VS@?%<3z{L rι|<Q<Q%RJ7e\rw0f	\n~B|'NEF@jL(TM;x(vZ9輵f`(S\n!04+\nK̙?&TVkR%\r\r}nT<&P	BcV'Ί7hPIǣ#L>Œ>͂.)&H.	ӷQƜg*BHReWSZ1^Og±б*NlO^^I䲇r\$F'#쑱 4^`JlO%St\n^. Ei6⟃٥Ri}kfK9&`t̬vf^	L]5v` Z'EgʺB-aOZZep	~^PZdƝ0_X\0|+[5<)L{-fP))\nR7MJĹfGV_p9\"֐M#Tc55fgH-\ryf3PM3W0jPx(b+gm-vo\rpa8gU{#csb5>D˕؄v+5smTksVm;?6kT]f7j}\$H64`gTڰ푳6spɺWV[}:7gv|HĩVZ74a~9[(-Yue8d]5)ɧ왪T5ԭFkJ:im<0*/9'\r͢(UBH\n~OwK	PYK=+lbrUR&y(EYR̼dRr4pT_6HT(tns?y-	-NcХV,^Ng8Ceq,wqI[F{{zr+ZH1NS\nAB躉Xy	VsuZQhtv_6T-\nFZx~ӡ%ktSP?Ǣh& ?<QݥwD\nk>n5%ARWqÍR?9u!*u\0£I&`' 	B\\e&O4og	BCNn_{֑!i` S-{UCqXq]GbL/pTT\$Ő-nc\\VҎ5/]TJ!'l[B>\n&Q̂i㠋&1\"Fp6MbuW{|p}.ނq*ǋΙt\r}ݕSbw{-ߑ)ሦoO_hN9%pBZPwmʹyǙH4d2aL]oj5y_dnfeǑ,On\\Bw\0D.*J'CxdfGZc,tWjWֆ]:Bβ<Hp*^M\"4J fcNVYl|NAbhhb	@OH;4t.7dHRЉ\"@6dS¤g\njvЭj㩖.+#d\"zR\"6L\$wHf>Д+tqx\0007jd</ʜnmPKCʘ0>MC>	shOaNd\n2zpTE<pqMH4Vq	 \rv\r+z0B\n#U&u\\) W&ti~ \n`6Ȼ ب\"* '8|ψkm!:N`{@^FzΧ%	W츕^~b1hI\nȊ=xMpjܢd2X,,HƑZ\n)	%r)+'(% 7\"'GJo)\n6P0:r(M\rʌd-Ҍ̥bs%`A/#+eHĶpt70ҟ1_3+'k[(f\$,RefCc\"Qfp\0W`\\'SZL;6\$h5jԸKϺƆ#'LS9WsxHeDC	:	XkeiBB#q2\"*0fYR\\SSnpE?*Mb{ҾǐQÞ\"/N0},\\BgfF+zH,\rRu9,rC!)Ddar.b¥S3;CZ:/h3'CԀAQ94,TG좗\\xEIITH+f\$*'L8zBU\$exDҌP7:+pbj\r<,eNzKL>):G2`Q@fQ2AwK<3'25CJBø|ʇ/VOL\0MQBBC/Ct{E\0s.At*9EtX{KEQKS}ZWG[Z5Zu@^X5̷?,7p=աG[ҎJRqAdxXHڜ8?-UE>(H.,b]0%bu)PIdK+6- 0v52Rac:IA5TI4-!]Jqr[bRgEgg[4U\\el9v܎UkuJFB+衂z,bC6-!Yd|b2!T0Fś5O|خ:9鮨b:Xin	#P6GeV=]sn\nFdiJwdpNVHm^q\n7u 6S_Aw6*3WiNWyH5hvR̔S3Bᗍg7ns{Hyij)t|towSI{7ڪɃx'Sڍ=l_0z-dD0u>zszGL	4.'>i˃W;6|;OtGvx|P>HENdi]xax!Gp~k0,{T8wtXօ_aJA#S[{AvGXΒXfRA\rva81ӎ	~.	GXa@'TwֳTGYOyuц5ǆwZ99YVJeO4Ie6W9UiXCvtOYd#S_XWsctC0Q-x.kt|w|% \\\r?oeYb1Eה΂֛񧚹b9[Xj{3~'W+_Y!ZVE]4bWф29`YT&'aqf*ʤ2IcFi#fRsɎZ_5\$3gA|1tdeBxX*EvYa]4rOe4#teB=(d7K\0JH\0jBy?;pdɾ\nZ6eZc{<c@iV[#MX|hpkz3aķ z#{(i[L45s֜oL˛e^2tʩl>AzvC& @yA߷\"yzX=qnTY6Nӝq8򩂁\$V<Qt{vԍ@՞K#bb=(,[MWAK-Gmg#gjk<Шc 9:oqSԫYq_D\$73\\1-+pw^ FA\$kg,P65</\$	M1V\r(pڏS BɃ<._YB97ǣB|KX;/p;7*v5!P8߿!WuY0oQ՛qg?d3+Rr;-%_";break;case"bs":$f="%(l0FQt7aNg).&0M磱7JdKia20%9IH)7C@iCf4(o9Nqi :igcH* A\"PCIrVlA0	'l\\MSC9L\$Y7D@n7ag2s:,XS@S0͎Ty7Kgɒ8_q4\$s/n3f+Cm%`&m*z@2C09bӢ(#jCUc2\$j\\4\0-+xJ0\"\n2dJb00:\nɁB&+7Bk2b#{&:HR\"Cj\r\0\$갬ir \n;0IJŒ,(䑧-Z/BƩ#U1mS:P:;-CGBc+\0xC@:tl4q\0\0x\nBÐJ\0|6bp3,j4px!8jۢT2,\\z93#hw7j3\"B%.p7\n\nJ ,OLCdUi!<d|ȫSɍT [?OotU0:;<[\r\0-0ls5z3Cҏ8ɢY!\"v5;#h)̜u5T5(Ch2dTõ0&CҲ/cZH}S#E9wŹOp6ݢ5x/v.TM	Z[Y-v#8~\$oZ==IbV-[zcKpt=\"s\nmL0LD4<ASB3.E͒qk}1-g~#(\rԝ\0LK#@h1\r3BH{OPP7H) 'R2ZC}lAB2P\n)\$TSNQ3j3*Cl#JP(%(c(eNhRUY+ElºP9+fɉiZ Fz9 \n˔Pba*TA2PTkL.zqA%^UV#(rf=IInFGRhD\"Ŝr<:!CR.ĝNts@	ĂFAQ)J@ɢpQpuQAG;SLL fd2_0d:&cqr(\0P	Bz:@\n\n\0)48jBI\r\$1+5ilJ;ȒBLP<h%26La\r%ùt\0Ɔu]4g)kjzR/gaL)f(\n;<8jfu\$\ri9cFkRkH6f\"S%>V\"4Cg<BI&z'7&̇lPf@Hv#+\rNOc#ś%l+&g̳\0¢r5[2A O.nA\\K]}a1 σPn|=ժdB\r&A\rK1{Ro!%;vIߥ{Y4Uhg'@BD!P\"tM%d~AH\n\"Pp&,8!+V݃\"W-R^#M=t[/H86Z<j\$c97p	Sy\njМK¿8''OmLBNzDOfn\\یN?+R\r!Ú,5H	Hdpn%,4TXIL8Ra'4T\nJI\\qb1@X.c\"\r}:Q+nPޘfY=)58ìuY9*tKJ\"7M8[(w\$]JHn%:D&zqN!|9N7w6q\\jֺYX&۶d:ջL̸[Ct7s6yaa='fOQ,@)K\"s=_屾B,}0T!\$\\	88^ZL!Eکx LBv1@A;F\0t\$Fԇ!pԻY/Darp	\n:8΢c%BRە:bv{G3L>\rA 2B1:lEd*{7z=nv^#>kݽgy1}#w bDnתia\".`nO\n9׭\0006q1^km,<.дgtΏ*(9yz		p6	>zӂEFn,&+4ZC\"`3RyXj3Ho!0<\nv0	y6\$DĆ#8Dq̌xHC4-/Pr	#o)Dː<\0B-;̿b`&p\nԦJ@\rۀKvbpݥɘM鈶HLLV@`˯\np;Ͱ\"Yм:^GG'ؐ[1)1/'d-|%Hآ)r1L4QfUb1Bc63dLAPF\rP\"m8pb;&z%c&6!^CDiB9bv-Q^M'1SHH%\"lM 	J1涂(QJݱ%0f! ޅ]rڄOQgl_]%QѬ\$L^ڧjv^p%bvÃ'(r|9Q?3r8p(q\0&(E^B3O!F42G[c=-('2˶gf\"5`R0]8#y0SR0.P3;`0`v/\n43=r_B,wxsZc3dB6hr)(^sn-Z'\0=7F@18C\r9#d0/鲤ӏ:Kl42\"%:Λ.;\$6rY53܉&=72#_N>\nH{(+L>r,NO.-?A+m/q	r/'RB	b(An,NDQb3EJOE]\"pddl&]#j2&8 `Q&iFBH딞@K\0hABrRPN8iq#D\$0nZDLR@RVkNDUΔq1dvD[.x1`&\n-P\"AH4O!\$CD3~lG\00\rLU\"oUd#)jKݤGf.?hLe!|IrkUXGE7UYDPWYn\r-#[\rJY_h,\$ǈKngQ^d'-H#DD\nUJH`Gi\\Gbp@@!g\"b&G,s'.2x@2\n1#31u`MB!p2CP\\L ۃ\nDB\r\n) ";break;case"ca":$f="%(m8g3IeLa9t<NBQ0 6Lsk\r@x4d	s#q2T\0Bc@n7Ʀ3xCf4(i8hTC`uADZs2Χ!(r4&	N\r\"Da8\"Sad`ʬxqx?#U3Bɼ0\0v4|DprX^e&TA^^,\nx<Nwarg	^\r7́ES>zMƺ܍C.0¼(c{x#~Phc2\$66>:*z2\n849*Zz\rI<X4H\r<+/І<i!0k,#4#:05BDB6kp0\0Pː;<B䡢	Zt#p1);*&aY4(C7<c M ̰Xc!#E\r:\";C]P6,9\0xC@:t㽌\"TD/8^YxDj0c2>x!2`U&S@15x3y+wA\$¨1\r}Л:1?T(J283x:\"̴-StJSbDϨ0A\n:JuF,Ќ\n ECEDǁI8\r7`7}hSF7'NaM\$&F,'HwUh\$0#7[&/=x(aORuN+!3hЦSAĘ\rrǀP0rt8&P7Pp\"O],Cv`N`}c4G䜣%T[9?z#\0#r Mr<3x}rQ!𿑣_|ƔIb\$G6%kMy\"3dHI7hH/4yQ&A<4֨(f27#8-!07QXDA0SC#\r@(FWI\$PƟj<J,\"Q'De[tXKcu]#Y<7au@;S'/-Hr@࿮ôAeށʩZHUyP ƅ~VX&8䳖<p:=-{1OE\\*!n!%\$IdqБ`C&Ȗ[PDr`Dy\n\"!46c3I\\2k*|pȁ8&Ɣ6afK22c\r2(P	A=AF%\rqT\$1n`Wlny	6DZoeO\$ZĹ'7E-HMQ|qiBJNsA(0*\niYxabFTA\nA'GA4R.(dD(o^L]q!2`I; <8bmBUMv8σԵ	 o	L*Eɑ\$5G@(W^vق`{YF/}(bX?%Nqd@Q`C5P4܇IRvnr	8PT@.L05Hɒx#L9zg)HLx*\nLVq6Ϥ.m郧b`]_R=憪Jhxds&uړE(RqO H0F`&iuJfU4ĈmL\"IG߆Y*=!=4B\"B2h{Lc:bLUIպ\$	(IX0e\\@#^\0#[B, mV6	QZ3T8ۤNiPI*o0Ar4t5ϓ(ri{PR#qBfO誱4\\s^#S٨ԉy-\nvnz[,C	\0ИyrA24O,1^\0S{21i\\.E3Prq	Cr\0:\$!sq<\0\$>P-w29{kNC7)97[מYI|ܒ򀃻K\"dT2xSC)cjQN(0\"(8p|LRf܌z\$avtB| %U]?+rKJ@u\0FKW@Naީ,~i2~A\\Ӑ7z02~;VlWאZY:]\r\"m|D~ςp[I,keh @C\"(xl@#;,#\0bB\$/\nK`FA6Z(e'C@ \0eFFd(n\">L:/ʧbn\n8vIp̐vp81̓\nJ*o{-M\rtO0e{Jje	\0@w^\rΆu>n7\r\rvI0Mt_T\$xpd/#s\\3\$%\rXC- DJJdFrs##p1j.g\"D>*c0M7Dč]xYg^aHG\nA!ePr!oyE#\$MJ-#Tb\r3@1UBV:g2+#\$q\"\"O(sHPr͈sG_v6̺3bR*2VҴTr\"h(0\0BxxxR!Prx'2g_/2/eR/.R2ʅ	1 o(P2Pu\$pЯQ-S1S2\r6BpS:sF1JB035sZ@'h㰀ʠ]-#3\$s¹\$@r=(8mҙ29SҮP@O:\r3:\nDX\"%Ӂ-</@\r3-\"\$Mwq@%\$涘@A=,F\"t\0dTb!IkLcB\".0s/\$@44cy\"IBKk@ON}!#\$kJv³	̇\npF3K\ryR{)Cyd#I1Id\$n!Bp\"e֭zNwB6iB2>dFD#*߄MFr# ²z0([ePy<D2L%hBSdV\$@&/70?\r#RSiST0I4uN20\n(C6Sn?R>RU\"&MƦ'+z*RSdnK	fE+x]ՔnPy|{'DH/fm.d\npDէ(RcD?4.M&-ScEP]Û^<MϓTf	MŴf\$-	\0t	@\n`";break;case"cs":$f="%(e8̆*dl7qraNCyo9D	m\r5hv7e6MflTLJs!Ht	PeONY0cAn8Ua:Nf@t< ya;Q%jS{[mk<Ȋk\n+D,l.CCq	QѓL:N3k:V\\We]݈Z&-iq|hA61T2وāE3ihǓ^`b穦@1CH܄!HJ@9	9'`厬ԴܡAv7m5\n:MܪQF%@69\n\nb(׏CCJh90oZXbP2l9\r2X<hn9,LnBD&G0Ib49B9*Lη/tI l2H*h#LP@C,K	GA`@9H3:x[\rG)\0c^8HCxDòY%p̐=X|\nˈ!m-\r>ܨ@P7Ck^79\rǎuy6B<h3l.1g2J2T>><☀ŉֈ1B	rf:Q HC,72ⱆ^YCpq[#p%e>j3:e\\ P2Ei2!9?*C\\MBbNk-#:W\\9/!%Pl]=b4En=Z;p,7lxnE#ӱߗ}\0LX@:&64s_8T:.YBo\$.7K<!\0ͤS ֛X2%)	#lˈǖtb7x!t'Qࣄh9E;.R7Ŵ|Ø|'184ZΚ.\\oԆ@Y9d6\"0S*(STDT68Q=5!3HxdP'a2K	|-4p;µ`0z݂m!b9\\at0\r06Hls:=CYb;DZ\"a21AkC|59p-8\"ZN7PElK5䈇ch@DcBPg2&&P꩕BfW+dWRu^%~Axd\rU5(iaסڶ_&&źGU4O)	'\\ CqLЉ洖G%I3YvQ3<*uS(jV*ZpUaHnYK1dѣ#Q1w\"E	2΀tYn|SeP3m\$ %@Z&ba@0Ի5犐! 5zxi\rAcHA\"B\rPeaJqѨ\0\0*ut؂\nPw!!~f!3֦wOoCh.DRdЍ)bCSYQbA!Ġm/吉1z5D'LzSyKH\$)7o904!\$@Ó⋢f#4(Hy\roi&4䩟SQ]פVдO 3e\r%pjErȮ+R\$g\$⼚-OH\r8YA2^ax؜jxS\n\0J re:jhe\r?Ny6ugq\0!M<Smr3Ikg*WIY#q\$'C\r!K_I&1(>\r]܂ܹ_ NN9\n3p久Wi-\\2SH\\I#y/;ŏ\\5~ɧ<zTI[n2'OL垃zzO&CJ-ٹBzv3	*pt\0­h>kG~	Bè!\nUcrN!'<.WE\r3pJ	>][=݆-/;;AC`z\\#3kD/\"Fw+.|s0;裯	i%=K5LKz.td1*\\2ztKꉣWb*zg<l830\nS#ȓ%P*\nu#-I}`[rcgNYX/*VH5A2c1uR.yXx OzC|:6;X'\$Oi۽#G~s+̈_U3Ƃ;IN'#&1U/+=ޛ{?z>~Q؇pp ]-l#o*Em_++(4\0005g~✱&`\$@\"d)p8	.`gP_ O`bz2̈́\0>\\rNMt7dIe93&.9%`Ôld'C~r\0*Bcf|&Æ&pk9M\\]-`^pݐ~60̙np oC~.jp8FtgjRhB.ߣ(\nEr&Q<x\$.lA)!QX\0h&.nT*p|c`fLSNb* ذFcifEQXiDvG(ʰ\rPumUe\nf1KqP1	\nn%b#6F{':IB2/b>fv_#ށTy!E^o\\D1\"B\"OB+#\rY#L:r\"6r'r*&2/!1\nhRZrlaHw2N(s)2)#'bg`w*\"@d|f~%Z'ʈ`n6.\0T*na-ΦB:,Z6kZ grܰH@򤂡	l*a Ќ>\r-.Ddj4R3dcK\n\rŹ _V,G'3Qlx&'77rs^\na8rzN6 2ރP>RAfH	h\nx0_M6Dggo\0Gi&RGv9Rs2c>Q8_32_6wf:u9i\$EN?y@T:\$3_,}-d4wfZ߳yC'C?J4ACq>\rXOWD#AO4E27c`\$Tq*eXcpddrp(==87IӳJD?鴒&%PRO=6L\$c#2LLS[K@s-s鎳MF7p\",ֺtIP.-5	5Q(L\r,>^_H32뢺`<AB*5BwFm-BhT\"#U]TuTbD	b Ǿn*fU3Bc,Z\\\rUu''a%'_Z/Zuv\rV<tllm*BvTL@\"tZ_jFg:bid\"Z\nZ50[cURSa 7lV<!bOY \$!{z3\07FC\n8	u-T.8CA0Kf0y<\nÍhX&BD<'rY{j,drSd0OGJ&0lxvY\0fml{IlnЇ`x'0bvoj&\\72@\0a55p'Srjs`c&*,z\r\nGt\nz3pPEDv\"{p.dg)A'mm\$bIԧX22n6vd\$0SH\"\nA`";break;case"da":$f="%(u7I:\r	f4is4N2l\"ц9Ü,r	Nd(2e7Lo7C\0(`1ƃQp9GS<y8MDYCQi3M`(nN7Kd9K 9bG(m0/Lg4`c`tbI-	6G2A[! 3[^C7{j\rت7,m徬ࢩn73~PD3]qsz58Ä;\"6+\0\rZ(#\n6hI枧\n0վ؜Ӎk~P:&Lr1Q02j5c{\r1p7BoB9.c܃\rO	r	0\rB&6J@?15ψ+:\rx0C X(ЙD43ÀxMȬЅ2p|9p(^'Aڷ!k93	07x#b67#\n*	X:յfYւ;\r#(	Pܡ@P0ɋ΂ @1[(twj\n%`\nz:D\rdL/x3#ˠ+5E4~`7\\r^9\nh8K65贰Pϛ	XhZ9l\\(hK]B{yjYbaJk {0	q#&ͷ\n}+A145crk	\rT-k9%Q0lf\r!E۝I@AmZِ\"#s]}u03ك/VCN|4ʨܭЇ|<2	WpHؘV4L֍0͢)rÜ:Ţ@?3aƹt\\a#8¹wW?A@\n^qBH(T\rdSL|ƭ'\n4(tRaM)<ArT歡`\"иӮgnF2y<>z.,W9Kd0:QRJ!z|A1G)@TSaNxQ\n+yD[Z\\Qa5ۡ>\"'yYcPy\"ƠC2uy89]R5!a͞Vi I4'N\\Vgau!'R}	,l|cDCItCf4pȶ:W.gΈ-%x\0-|\00@\n	)(DHLcCv&N.bJNinᔮ\"~2n.L;26C8yf%VsHCd8@Ch:;\0CppPjT(@iaϗ)(%a{ϙ@C\naH#yAf⁘@x\"HfK٥͑BzHnDA n<@07Y12,McI }%13X+\0¢y/slԠS[0E:ύy mBT&Q0&H\\5	pYՎcYY|HLcK^Sj\0\n r0T\n8c }fI!̀X	%	8PT@-J0Td\$q5'u	S\rz_+BhF\rH`RcSV2bp?gl@aJM؛oNQ^{YkTP>h00Pv%OXqA:9t՞b\nö*4hvCHzJ?ŉzL`D;Sa\\~[\0LdW:ve\rKl-7+.愷3Yi#j㟞@K#,&1J]s2_d3՝d3B&FZtx~3(,6hqD䒥Ի\0R]Ɂ1\$x`4`+VQG]BHwBpPil>@.WP/)ȊbV2d.` 	-EC\$C[ȇly]ӽF~cPZhG؜~ ^-wvowN,4)>4DS-UcZZ%43kD9[eN\r\$Zݎ\\8eR).p:\n	@KՃ9#0B88\r|S\\Y-my+p6~ w;|a)WBЗ\$Fe.eqE	40,^ؼت[:gLk8\n\0;.=/']*\$0m_.	N4l:W`?_<t}!s\$`m/ć/ZhF\$:&\0 \r`ߋ0M#'\"q(Bk~#KR_(&0Vo\0O0Fh9榻nI d >;\n4Qh4JGAL5Kfw>؊P\r9 |8ʆ`\r4(B-\$m(ЭZMk\nF^n\\%[O\0^q\0-b[g\nI#q.D(\r0>.m!`mQq0^\\#	\n̮nL.\"D;po01#\"4QR@NQ\\8yrCvG+Ep*/ѝpBll&pQ,1K q7m\$:>i@1Xbڒ%\"?1qҭ=\"@\r\\#o7\"m>\$R_hA&KѠlRIq5,PE:#+u ؄c\0*r*ƂqJQB~o\$L\$\$2ObJ(PnQiBR\0b^\\	BP2E1pPNF\0`AtH*p;\r8V+\n\n\\J%#m)Br.3b2j6nn\0&,+*ğ1%dDʘ97I`Zh2,\\(a8OtȰE0zq\0䮃#	f!bd,E+~F)?'[1>l?Pj`sd03C4AJ\0\$0A'Lp!@8\r<mg]+,B%?m44.)KG.kq@&01rƅ#J[ġAĩ\"nJbPE\r@";break;case"de":$f="%(o1\r! ;C	i9	MQ4x4L&:Xg904@i9S\nI5eLn4NA\0(`1ƃQp9S]\r3jPpv >9M(rڥ`\\\\m0d:Ib0FEk\r>l5%\$\rpן#(@dduMgCM9cWԻ,SBywŎBVG'G(VnBh:6k9qx||#H !K71CX7>p@##lh䣩*PXAͬ^9Cx䩬,fϡk2{Z;LQBH-0+,l8N(s^:<@P25B87\0002ǰ\r.6Ip,1.@k+P7P>1Zl2\rTPyh:H́#44\$67<KѪz:69#0z\r9Ax^;؁rJT3h^8V2M#C\$4TH(|R:C:pZ̛\"Xބ\r#B;ߥ%K(4#*=B\"7:JC,2 VKpMKȿ ۃ[P\"LJ4B^ B37\$3(Ί,;:LxIi@S3(:\r:&lC3pߤ9?l͊Ӯ1&^S~.4PFN{`?4ssuU\"P6X޲Rx8|,\")MH8PB\"W2ƥ-G͌ Vl9:͌cZ:\r%̒{Ø}[2RQ)H!d*z28-\"ZjM>w`*	AC\$rB\0ިb\$1&CL\"58l\r(uhVtMP<\rfRGc4B|@h%\\a\rØvOj1Dd\"Hrp'I⩕`Űa\\-1aC`	]	XڛuaY8@P[\\UtXK;e(PrY9ƆD>>+pc[)!(ك8s:Ln6f8<Yg(=LzÐ-QH\$:2m[<tWaU*rY*^e~N8h̐6k&CMM%p\"TԊDCd͝-\ndz|*&\\HD!I\"eiZqũ\r\"3JM}ه(s#m\"\n;0YPI\\))z@0ʛ涏WU!ࠢ~PZr5rҗdG4Fz\"'L	ln/k0[~W\"H^&QR\\ک?IaŠor\0x| ,IS\nA@k-43@F[ԅ5sQBk\$\nJD]ꔙIʒId\nBM6!#pKA:/h+蜅`<a7\nZRtDy'Ԏ\n@TZ\$Ny<BIG'\$hV+璁C\0A}Tr8D)ν,'[ T1.\r0ACPxT\n,lyrhi:,ah2A#30ȑhw*_u\n @	E	;G}\niK׸iS*&]	ߞ:&}>n}]U)ăq\\ozcb}r,iYu \$c]*N2('bu\"&fQ\0[YӀ(pCbmbsi,}TNx\nAA5ǐjPe])]Atf8\0ب*9\$89Uޤ{VxSsPMhXp73(/hKplVuNsdZ~تS(aG<s6h3yiELfC/of\n'M\rKɈuA6C1ڇ2;-P&<CLvΡP 0C-	1ckPD_2!ʌPpSɐ6:ʫa=Vi\r17TfiITr!<>Sk_N/=IC޳o_ʩ=ks?OM/^OzWq\"bצru6BH);n3&,&Z<!,El˄OCtͶGʒ,B0B\n^J,	AG2&(\$T쀘'GPRE;\$o4F\0բ|T*EОgsnaqnXyE		'РnІM{lyFHp+{\n9~MlFp-2#iǰ{^\"/H-\"Qc#Ƣ.0Ф(j&\"-^娠#Xm@ZdT2ND&m@\"CpmfCp-cUIAcUMS0P to#%z5#ydYSFE\0L. uUЮOVt\$`aOVb9Lu,\$7BYRPdE\r!Q1r1X\n&1ZI@Hh8r&!\"Ir\"&M-X-ClE8Lm\$\$Q@IGrL-V@\$O̎1nt1`\rz>&nl=,`M\"p`rЦ\$`2,nxgrw-2Epr2̲/20\"f/gu09Ec!	@2M0@\0\nvu\n/\"Iѿ4Qw!4ʡ-{!Ǝ3a\r~\r̐c,hĭ6SQm2?7LS\nG}PBvgjRlH9:]Q::0v6ge<S8]:ptd0r/Ӌ7Sxף,,H䢱Lqe53!q@R>\$Y?D7>ꣷ Ma-fJꎳ;BAӳ#IA/A,A~J6#/0\n,NOrBr	E-C@FNA2\$DA4R\nFE cj+3\r IIMJJFcP*v5s>cH#^%	\rV	hS?c~I!*@}&g\nZ\\*V7B\$4Q\nR's4Мy4#!O|dQ\njOOL!	|U5#H	6Fec,	M(dD\$L\rI\"<QP\0d.4?\nLtBcT#[S\\nFՐ~\0PZq[LS]5-B|D9 %ͮl,\"p{blXM9<#F4ؠR.*v%ddZ7555\"RFC@tk6qU\\\r-7DAd#D0";break;case"el":$f="%)g-Vrg/x\"ZАzgcLK=[QeDXŢJr͜F1z#@Cf+Y.SD,ZO.DS\nlΜ/*	D+9YXfad3\rFqnFWBWPckx2V'\\Is4ATYt	qPe<]bꈂn>Z< Tu'a+^qU)qu+4%Yi?gmL]c\\3ddv9ӣ=_9\"ʡ]\0#-RN \$\r.Z,1\n;K*&-2ߣZA Bh{8뒟HF)ziEs9\nJZC2]r4lr%\0P7\rcp;\09Cx0C2 2a: 8MS9c2,9'@G1zRhj0\"R[Ύ)o҄%p](K棥k\"δizbmRj,ĺϢ庞S*MVq_Ģ;]PFZPӡ/*\$5QŌYt6]:21!Zo2,wu/Q}Ar,g'^abJŗ[(؂2\rH3γ=ϳ#<yPϚNt9N:\rx>!9д8XH90z\r8a^\\0TMC8^2~C ^,5NP5\rp7^0%x_;c\"PXƫ|c\"X6o:Q\$.j[gr_0 OJX0Cvt @1#?<b%Wcq2]\neZe_uxٝuʍ&)|.)&Α3Ȁ(x\"S-I%\0A7E%\$pDȠٕTVII{qR|SQN̤IBNyX!	\0@L ~争jDS>;u9%_La}.A\$:@2n<12\"aeX,0BX\rKx,O8-&#4Ǔ9w] !t@c ϸ8  \r9ƢZt&WypNK302cO,m&ӀlN5&`8gy2ˀe\0}]lȃ	#^tR2+sIU]%!\$D%>ZuV6tQ\ry UN5Ţ+љ/1MrZ/Fa}zE)v炍WBY*@S*Mh8:'vzFbu1P4\\*@PT\r0'g@VxcA22ƢUje־Ccl&zvѿD~\rlq/kk\r]*|I\$<QM*\n!T́\"҆\"q2\"żM.TUU-<mVԚVk\ri5؛%l;獦n)gP|Y;`W\"[DX)*\rEP\\\"\"ǡ3Q'LݢҴ]*B)׵)s~ڒ=%yM_l*HqzMtfcN3^0a*0͙f67D\r:NnT<z.\"Q8h\"m\rŒ>~\"Jg\\iJڱ@@P\0%,.9O\")6!;IjXoiA4`8>8iJm1c6}z'B6dnx3CfndxGiJC7\\Hc\rj5eP22t\rQEyPR)Rd..dzqH0.PcJ3rsR~ϙ^rh#]k2#r(Z*0+qrsGKp1-|*QQWT'XVbQڳyfOҾ8(w:rV!8P	L*nA8(G2֒s<c20A;dmmD\\D|`g1RRT럩ҪH:V>t)T4V%ZE\0NA #Ln鉔NDhoM37\$(lڟq7*c2'D'H\0#/KA:ׯ!&H:,B?~_\">=*'e\"ضhDH/I+z\0w\"wT\$uHs4L2a\n**KB_.X(g'([lp2Cv#o.@Ύn(bx6I\0tg\"M\"V,2*\"JU\n'JJciX\r΄D _N'nDNm4˧[\nwdJ \r@\r@ mh ͮrDR^&@~F1gbDqJGXD`	 ֍(M [-нD\$Ŵ\$pp%XܣP&G<#%âHB7d߄\0椖`@ր\rb\nfM@hh#8(t]/`hm4y8@4,b :%,L*|]N&DwlRRS\0.n2\n 	\0@ LOhjbP\0yEz\$/Cy^\0y(6y(_E`7z6T\",J^R*u)%W('b\\J}*,#++M+boK,C)/ʐ\0.n/B≒*M̬dpA,l\$R*yc.ҳ,pw\"11ceܷn53jd7W`x()/d.!qZ\rh	 n;*\"#Pӆ&L.\r\n^L_\nW\"-Jv02ntS^(SbZ/D\0=jJlS=*Ԫq(lw\"\" 1h.H\"tB&3P@_GCh8JX*wE2en0oGxyHkHGHv2\"aIp*0Ԯ%KGwHԲo:Dncx>\$QI(Զ#*TId,aM<BdJX:d~	4	M1<R1/4P.R\"\$qQHą\")b/:L*l{[@\rMF\rk\r~88ml\\sHMܐ0Xl_%/aIZ#(FNYZD\\ăT6cS1\\%@qN_5S.US`?21Ե?UB55S8#.)չI72ȭ*b=bMv+-2(7+@,rUӇ-g\$-PK_gI*vE.]VS[m'oFGV\"'_M#C]3zR?\\9DZo&2QF:e0[\",5f&kqn,)TÈ-NZ,8z9myC@W6iCh<6EsvsggO }n>9QsOCqV_V!0x`ѝj_Z_g1h5hvw+S_\\beOwxD(p3EwG;hI-7xtaU2B|_Wz׌z*|hTzH9)#zA\0@(:ЀU+0Ț1oP>,<F\"+<4ΗydLWM5~7d{5j7wk7TX|uO Y{L]ڈ#&x	˔yXpm2\$vo\$?^zE\"5Xzsk_vX}eՉ8ِi)X˙XVX ?o?N0yWl97;D`7\0O3#%l\0zg1\rk NLdmQi&qyvO MkQŗJِ&mW,x^W^Xb\"XbgCuÖyQluci'xiBY.*WT1qZWZ`2?UyaSA#ߊ8w7XPّ 3n,EZ1ĭG!\noxPiD	ev?\"qsKb~`n,Fu7fe_@V:)8E_c4u,195rpI/Ir@``\rJ~?rLYH(s?א66C6KR\nZlJ6VT)A){P\$Mc0¾#Js/GtC\n,HUf<ڜ^2:tRUm3dRڛF\$67/xOKo,\"Ӻ\$pd*\"qN5sb&'J&+5\"dG1i,eA!aelE)Xm0?+:UHli\\;bp֣t.AVKTuAXUÜ'\nT,G1Ĝou{%\"Mw_ZlE 28a3ECnR&\\tj or-t\$62h^!G/_LDmVSu\$j9v:nJ7R(ځ;A@Pu;d\"BP']3H9zl~\"bjRz;>(*9CdCCF\$` ";break;case"es":$f="%(oNbi1gBMi;,la6XkA<M\$N;abS\nFE9͎Q 2NgC,@\nFC1l7AECL653MƓ\$:o9FS,i7K_2Χ#xh4FdJx#&̆T\n W2x*]\n*̦Ai)%\"n6OQTa㑓;ˋs'ts!999\nsx'[S0Fy'ۃ˒rfNΈ\rȑBcx11Țj9âcz9@ȑ@@3>+@X+XBccϱ({	(@<H\$bq]\r+L*<:B0BP.\0Pռ+2Vʌ-\"p[	¨s%>K+.ԹLW*P)	0\n&\r9Sc*##7IMjn01hR2:	P2\"2ax43c0z\r8a^]+P\\{BDI|+S)N6\"Cx!F+Hnj-+Ҏ4L8hȲl2)r:̾L+WA+X1*`T؊*`6*I.޸#p08:qB@P2:	^tˈ\$G+S۽y&gE&ʂ{г-C*d\r:70MY	,Tn&f3 =.)\"`6賷zP3}S9p҅8!w_\"2.u58P>MpKWk'`0ӆ{9	#m;\0/KB\"H9rG!*x׶!.VV75MH@K7vGaTf3-?܍\r\n6S&<ӹ5pTa\$a\r%>Cr	)bURSKb]FOD3\0\$0n\rd,3\"b|XRMKJ\nњ+urX!abıB\rR>a>^Bq\"vp'E.=D A>*ְBr9RgÀiR%=EfbW`,%Ò\"e6ւw!2IBŔS!)Қ̃(b~4\0mv!hȅBi%)^	\rNt\n_\"g͟1(fHĆJH['5l)٭B\")(8cS@@@P hMf\n	)'EPDCK)!Pd:9tؼ2B֗ai#G༄5]!!\n!}PH'Q퐣tImfc81!3%@߀C\naH#@y+0\0ΈI>DeC8EّL7-ڗ%yKɋBdUxPYVs=MUI\\i(dࠦYLJ%2dp)_ET\0TB\nLBA&U/@EKQ'%\$?7:ɓ3oָXz\n6hԔY8,#h7.R @\nv5)tPK	ԴA:n0rE+\r!*\\BA\nFb 01;XY s!0E|/46P\0PO\r4gar?/vrj.\$=\\dŢrFQàUU/\"̨Di#9AΧ\n2Hj4&lR X6.]Z@\nZxOT*e0nήvPyWq\\nh2Vۛ\ng7ם~X*pƔT\"b`\nRj(kR\\̔iTdL/fJSa6#Z\\\$gyϴXV0&`\\\\n2H%_\0000T{!˴*ZHeݬʋ%I2>ɻTlAǿIZ5q*ALMqiE3CbHT\n,\$Y9Cr\$@HM،P((obf<1nPW/9#'MDxAH=Gn:K}5p|<r?oާ\r5s0AywEV\\|x̅tɳz-;YW,C'9TZ\$B/\$QgsBtA{ϓRiOFB.8?+	o+,ZO	{hb!4hsc2<#\$̑QKGzQ3ڑ~\n*JLsa}\r`ܯxvBUJfMl0!cfm|Z/xf#\$6P\"iosM.͇&z7|+h\"m \0٤cF8 l43n~;b̸B3bĈ(*	o\nmhrD>ЖA5PyGFBRҎ꣜).(bPr4η\\JnD䦂/JqN7'x0&2\$fBc\0:\nZCj#cbf5EbjC>y\$Er<@cJQV~-NzjIIiDҹI@ܿ:8plnQK-گq#	j	-%؇juE(\$leQ3 *j\$%gn⧂-2mfK,D0#m#&1\$Xv\rS\$I\$gW%rM!B2Ƅl-,%CmqDr'c'cZg0Mr͈u2NҤv.&*%'b*gdN,(2ab)RA&4J`QARL8'.J\\M/Pi+2MM-!.33Nlh442s?\"\"-bG5[36SADe\$)Vuc.b4\$&Pc+S5BŮA:b4s(sv;4Ljl^jkgPBuc{~#dz'#z'hZFo4&Gv'B!4/ƊM3\$i2N㰴R#cB:uo9>xrj\\PQ&lJXJ^Fn&BKeR6\"F%Ꝩ)cIJT41D.SL#}!KG~4;CV):a-\nӫLF{\0F,YNBp^^c(\n5GAlSclbf@ d_F.K2&zO=U2BOt2a\063#BQdLrL,PJ 	\0t	@\n`";break;case"et":$f="%(a4\r\"e9&!i7D|<@vabQ\\\n&Mg92 3B!G3u92	apIdCf4(a&	\r1Lj:e2\rq!?F<b&l&+u\nBQ(ԉDa'8k&m:rɼ 4Nѣq7s;BLx:0Hы^rFsoMЂa!jt1;i֙\\/Mz⍎%mJ n5NrIȕb42\rkJ: 89@9(\$=ax4@23id2l[h\r#N'hĹkCع#(Kr\$0kP,@P#+\$#H#x L\"xBJڮ\rȰB:L\$ĉ`޺	NK2ܶ03#ƈ%@6o(S*`@:@2Ex_ȣːÁ|9p^'aڹ#H̹\r7^08Bsn5ɴ&β!H\$:	¨4 P+	\"(+	[CU+3ƂLL8A;ʾ^\n-ԓ<}d&t:#Al#BWY3N+`P:%S44`ĮQ]4(5NH91cH5X;n:@67#<9l(h# u~.h(8b\rE1꼻}]?4uO8c[6F*'jE\"H)(1Sc)j(\" +	#lB*W} @7\"LM~VIۚU\rYÓ<NC[+7\0 #0Fqr>V\$(x6NR!cf(ΙFxf(B\0\rpcd߃M)/.ÐAlx\n290̒BCn#'\0pIY0D\0rUnVj[Er4,Ep/@UŞ<p)Ŷ35hHA.4V`e\$)C]UV]+|KYE)lkỮH\$-2dj̑4SD:0(xcRv>FZ-p&fC\"Tƺt8-4DBJB0f!yJkE\rY5rChvRNI'Qh2Ψ45F5rnn;粉YrVm(9a\"Zv7ZˠV!aD1;!o¶J0 aL)i,OHjNe'Lhid30KT-VB`3fe\"<\$<K &0PCp6h*tQcpa'\n<)@Za[5Hl|䵋1'.~fh\00@g,}>ƀ;XC8 \nn\0?CA\0F\ns@f0KHRi BP:+Hx	8PTK\n@.Ilϧ.HaQItdsp p;?`N\"q~[aȄ=U9yBIrV	:yHZ.d2<qBt\\7σ+9V/\"μxu+)	likp\"\\2i恡Iُ2h} ABóE^KnH(=(8u!4Xc2`TѮV]xas㆝JZMHe-r6B^Hnkͪ_mE%bؐ@An1RP\08B@PCkfWkV\ri䜔f,90F@* 8E\nOSi\"hƃoVS ar:8-Ec CL2C	\0ԗ3[	&Yg)DAGb/<\r\$4.5\\I!t K<˔tJIppyfYnב\$\"UNHr\nOB\"\$LBf'hXjˮfJ2b* ȍzv<\0\r=\$7Nz)hVB	\\ց:SBwS\$-9[LlU澉Y(\"};o{0,;a<&sjio-ߣ/*\0ʠZN@L.MAg@.d&l^I00f(=\0lNl\$(4/h\"jDR5Ne-T`I0\rln \0f\"̶M^̴pb@FE ή0sȃ\0uPtNwk\0/lt%/O0\r\"m/tP#v1/l,F\n(0,N'CIj!p	pQ:@}9hx%04c(麛E)JE8EL+x!XUx|;o	/b̘H;b5\"Y#5bY[1M1D0\",zq>d\\fJa@S-`4`aq[Jّ!R\\-!!gy\$QCRǐTqY\$/k0K\$) <9PsD{rjGyJ<j#	(C)f9E'n wP%PnGsg%0aQ] ,rC2*&&02,GnT.	:+D/H걝w<w?-\"2rRF^hlf3\n/4)	.3e4Ze-䦤C#i0fރ@,7SxS~'3Mf shߑFBI)\$r-X6o*9;S&3-..:sͲs/=S\"dH2_#\nMZ:ӯ2?835?2n`P	k\0J0Rr0_C \\,hң-DL3 s)D<	o\rU%+D bB:p To:n K`\$XG'&/ Z&*<bN(cΜOF!HϲP2M@ ΁]IC\"'-P:.:LwVe#GcLc	k!ɬP`]mD\\h4WP_@bRZVl\"3RUo-@ޞ.-VLVw4#t5B4sn>~d\".t85|ucC!И`&Xmcj\ruj@ZHK:!GR\$Nj\\FB`up8h\0zvW.\$Po%Iu*&+`\\/\0	\0t	@\n`";break;case"fa":$f="%)l)\n@T6PD&چ,\"0@@c\$}\rl,\nB\\\n	Nd(z	m*[\nl=NCMK(~B%	2ID6MB\0Sm`ێ,k6ѶmkvᶹBhHA9!d+anپ<W-l'0;qVBҧU!K(RV\\eKxlvRUBgͅvGh)I\rȫrZʟ3v%quuMkEpZNPQF)NƓq6XH.++ŰR9D8*X7p@2C9% :#9\07A 8J8Cc	Y@a:ȱdK&Ӛ6eSx	3rjb9j:bݥES=PW=ˋ8Z%o\nS͋F1\" fnRK,T*3k8FSoj!BD.T\"P2P2\r!DIEP@0cB9=oB7H4\rJ0`F`@Y@2D49Ax^;܁pVUФ&3(ր2d\r:И#x}-Ȳ:\$4%!M½nn\"2DBHi4m)Q%=^\n7W(J2=TSAX+ڨMZũǉ7ͯ;icjc8[is酽`̌3\nXܳ4639l{r9Jc+s?kB%QU\0sÏx\n\nbq.GRCQO\"s?Ӹz)#3!x-#t*qN'	?Q-tqI@LՌ藵*Fq(V޴*wYːP!x]ǂkR &A\0C%Zk@պfA0|`! C<<\$@}z\r!:P\rЖ(RC(x^0\$AaP/T9@mYD`ˡ4D,o5D1AȣGDԛzd#EQ\nbL<bM*UEqY)Gca\r#bEXIdv&ԩ;)!퀬\$#.%P4r^VCrZAȫ֠ Zam-żtJb~F>\0PSbYxǌ#c~S2̿s]\"S55fgT!}f03hs\$d|ĬJTXHrYV\\ksʄ Z]k24)WnXdQo2&`x8D,4n#U+ge,O,f&N!q1 X6\0ćC!2a\\j(l\r,U:05+t!҄НT7'1ܙ:;̮\"BQnA@\$)Qx0PLL*&^ȡdB{%T7J1`\r49	=MYB4F]DA5-jpAMDW7EE\rA}%b:ܰಖj-EΡCr!ۚ\0l) hZvy斦Q1\\l}Ft]F)4V9y:ӴJ.ؗgѡH&PI ad]k*\rcC!D	M/U}aA!u,'H6VTbG&b0'\\ǥؔW(aZIqvHFFDR.iVp9h/)\"I\\LD(_iN*XcEcN)trJ=|Ց0k4RL۵ \r`@('@BD!P\"<(L|[rQTFԌ@Z>O|.SHE8\"F;n:~ִ'&<o[E!/j<ldcYDr&gwv^uvÅL'8}ÍtvH=ْ\\Q_:D%8H(f(%ǳI	#i6^dG,J}͏ȁA07{T`u8:a\remtϑe8Z\$iCůk^̆=dw	.xt.eNU;jxCa5Pк6e~oVky\n/gX֨1\0sߊ&-,:	޽ J6n\nP 01B\r([|@L=nCQ3^W\"!@}\rFQi1=~xQjtytnOe3J\\e̝9jpbC5P{Ln2:*>쮞XhBt6S4LJHNNn\0mS@d|'u\0Wh~& DQNm(Ѧ;rLe2'RH3k!ReFeH.|6\n\0=c8bN:PM~:C9p/2:)Pbl.FW\rt;e;e&\$47Z!5q&\$\$n2/hHMvݤF8U@&X\r\rp>Qz`@Xɏ	%6mR\rm[ǔ0B|mxd\r1f40ꇈ*J~p<gf8!|'~lk\"bJ'izM&+ !b\r e(Q-\r2>(+\$R%\"1r\"4=}4.qT?N|N0q#%s%\r*N\n@/6t^Gd%[K,̑,j&-l\0TCrҝ\re,/&#;/&.@uG0JD&pCp. G\r/5Qb	XNT3G&6O\r7%7\nt;ĀI8'\$969	Q6Fz&Ӹh:<5:.<\ridCk@F3Dԭjo?S?o s ت*=,<Q	V*ѿ13Cf(;DCN?doS0++Bc;EuBn3eSs)LLdTTKndfC|fg\n#c&rKCK+m!r'%!\"4Ie#e1/9!и;PgfƮ\rVƋ>plt\$\nZ	,1#1MR<Hz*\rd%m}\"*/38sjsHJxJ@BNp60\$7b*nB b'wLH%8EzD[\$2L'GP%*2HNvjI\\I]]_u^#^];ǲNXmc.G5ZuHjS9.-s447mx7S0ne5Vޣ@\"V\ntN.X(sbto'H4zFe:߄\n=/>~5	 PMg3k!Ț4\0";break;case"fi":$f="%(i2\r3 2Dcy6bHyl;MlegSnGgC@tB\\ 72	aR,#!j6 [\rHyWUy8N|=NF5NSz^e7(u5e\$Ӭa0zK65\$/Fb#|i5NHj:ezg,\"TOoqy۔n͒~?#ʩ+MQ vMXP2\$D^eʇSqt5#D!{ꥰʘ#%*8z8\nZ#Sz:c(&\r+0pRR'(	B\\n0@09HԠ^%+G#zJ:%̈P\r),\r87\$JT['3J2P0@8#cLվ+\0Ȉ##MoOmdHغ&T!`@ǎ~MHE4C(CBh8a^\\Qk\\7C8^R;؃ ^(al\rx!R+#PlBRSաu%@7+X,E *o\0@UP徵\"n0èxk\")CR,ҮI+BW'2	;ط_)[-#>Zq#8X(NKP(&C-Et\0!0,:&Jk~Ȯ<Hal3\r5T(j{!ȣ{^7l6{Q\$c\n5\rVµMXҗN@#մZn+!p]0qgoJ@!hh)OK<SWZ\"3\r#:Z2+RCacBjAme4_z;\r9eo\"3I	EEqAM12N]=҂(p+2jג;%@2js.,xR*\"zjT%' ׊/&'\\Li<!I5 `42'm	4Ь2҄¡&CeCHNQ)#\"H*MCJ\rr49fD\\W-N+dtW\n^+_ÒX7oKH2vhGh)!#%!&R~xq>\n@TToF\0ŢjM'\"b kȡGժW*^u~DX 2YZ!Q	8^-I2%YZ2Y'rU\ni<\nE|2Q/Da#d3Ԙ܉hgW(B螐TSF8Hg	ClHJLh}Hl.yd(]\"K0R~exעʶɑjEMI~t4!@	SP:&dĭI4qrg2űgeKC4Č6'l1PM\0F@\"z\0L+?Rjes\$7 \0ɤb6EeT;a䙿0fZ(<ɗJBQ-͢1H_	>h4bTT6!v\r%0\\O\naPb)靼ޝ»QÄvny91*\\\nV9A.\nm\0VvL0T\n\0-5qjy;u5H!\"#2Tnx1	k'\0U\n @\0D0\"dιi0L=TWeF,\$fog\\h bt\"\$Dy8\$'W:MmԶhp7 4b;EuSZ9vԐ\$<>ݔ+5V)b,{H6\$cZJitfjщh9a9/ 1\0B0.)Gٛ%GcD%W\\b{/\\aPI%o\0̋n\r͆\nC~[pY\$H2w%(!Ƈx\"81`I2~LGQ0;f1O6^],`^H7q̋'u1|jC	\r'ۄdf3> a5\$Eaj2b\0;VfKיpl,f!(Inƅzٯ%߯ؠdTaw:k3ͺA!j~n( wplq3&חX`J*5#ăV(eEߤ<zBG1A\"	\\[vCKLY܏6E6\0ϻ'1N++mࠟwo?uo\0qBCt<	2jch5GrJ θFLL@le('NC0\0DP,lCB@L\$!\\fZB(-lȯJ..\$--pn,Ȁ`MP6Bjm֝c&6 \r\ryC\r:F%\n	̔yM-I\0^OtOy	qkl&pҰP1Gn^,v\r\r\0Dp09	cV,r0Tq*ʜbr\$\"BT8n,HNG\n Pģ*qopC\r4l'AL\"&,P4J2%*\r(HXb\"\$<Bj\$@0FTD~#n`<D6,7Q~EtKrp0^⫱m߰P; Ͳ!l!vt(?\rg@'D5!P28tir,%*/\"9&~\n *d 1T/\n4?B>\04)1M\"ҜLW\"ofnВ\r\0!+e+(ղ+,ZLĶ#%!%G6\rr!\"4\rg8sҫC=.g:C÷!1#%[._R1C0-1BQ%2S&R@Ĵ@^cB%3E44Ph5JFNR`%0@FrN5\"ӎ1w\$\ng/9)\" ;S0 G27\$R:=B#e橃ACgqN!2]K8N=M}+~	FD@<#uA@\\A('pG2T\"=q!H?DEd\rV7pk^#ʓMl\0,\n@pC'HQ4t)\"lҏBj.\"fpC%j#{cgK2.;pG-0j;kq̧512B5#3N\$Nch8}h;%{,]{hmRM>OgS.ӗSO'\n5\$^FɁ N\\]>]@/`k, \ntkb\n[_\nP2\"\"	T*7eSV`7ΡYN/Q%G.(=3Q<ո.58H8|ZNd\$ru,C\$\" ";break;case"fr":$f="%(m8g3IeAt2c4c\"Q0 :M&xcC);fSF %9ȄzA\"Oqo:0,X\nFC1l7AECj :%f0u9hZvMqM0Pe਱L'S\$y6Mtu6JNB@nNSЀaCJy6)ҝajTB)?9=SAa2 ^0Wsg3s>A*7{z^00kL70*Cb̈>)7<N17hcs: 8!(l#k87VP2Zڭ+X;,(3cKƛ(\n)`Ƣp6L\n\"-ȃ4G!	W1(\r2)4(:B;;+rD\nc˲a\$k'oB;Fc(t4Nm9%z2C ڦ<+O\"f#@&ӘCwRJζnaQX8όD48Àxo\r]X;p_fJ\0|8\rv2,T^0 'J\$NL`U,#CbNȡV,2@;AR2AR636h(J2xƌNon*\n!dCV,4+T\$JT:J\nɔC#;3:t%C>3`2ᣖ6S[\rrJ@:ߙ0\07`::20mȦ1񱖰PUaU(\"®7K;X+a'Z\$h1o;\rT<?X2\$A`P]\0003zM;1S+\na#\02*̈~j4ȘAhe\0bzWbaѺy_\0A\0\"0R\rA\nd'd\"dZ*g.bc2sK\$).&{ZYA7&:y0=Pe2&>\$U.ɩm&T\rs\".5&3^.1P7d?\"ɋB/c!599!<n<Ձ9>^h %2M! z!Ѝ-@*Zemվ\$kt.WP\"xJIaSH8&F*:\"uDԂ9唣H\"#LVw4K`:-9.uҺ<<SyuWIPpڞbJ7Dn7dk6	0c8:.xc 'uvvgZhOTq\r`B<)<RM):4:c4'u&V]K\0PP	)FX9CN%\$+lN|BÚc^	RjŤ\$jg t\n Ie!FMM{k\$n)L5Y˅ 7J#RL5\n5@R,7\$M7G\$2PE_f#R 8dP)'gd՚gmL:v\\yj|0e+c>9>Iy2DvK6C䅔\0¡(8ڔwr<ںbm	9{W;>c#XgA4!\ra8&/@޸qnD(sc`*UʶH-ZrizcGBL[%9Ɔu\0li2p \n@\"ra&\\z|ȋ6I\\P<8*U0s%62EJ@ [.HP\n@E߬L&Me\r6w5J`ϩRJ뾲/<F+RǥL#a^PABl9Te2|\$ úh<*jaiN}pA)g(Ũ,{_̤Lhl}P)\"0PJ|D l^M5 \"K/sZUzmd]\n\n&\nC1O\rhtҍ)>wl`haPִeuXėy[0|O!E0\rq=njF\\8A䒒%MC\\o\nj=P[~[KyquQz#ШC	3OkV'-=m@=3T|]+KԉEL[&WJgD@DqޔHdۦ^]}w,4BȏmU(~A|k#?^)|Kw陧:9~ zW|yOAq꿧o^|ȭƢr߆3& \"g5IC\0Q\\m'\r>ɠĠvsɠ@\nC\$\$B4g@^2Bb2&<~5\0j-\$ w\n}BbbYNJTeiւNO-ng\nR(p\n즦d\$\nmj3GN*R;@H0\$#jp\$dʌEڂtqP\"D0`|LGJ\$?P焍\n\"Hi\$<_ \nSNvh\r6FA\r.,ij؍OqԭbiCqx13GGP\$QէyQ\"Oq\$Pe'VPZ#oQ*GK  (d] jCCDꌬ#RQja%l/j%L%q#1/LBv Kɰ'З@򳫄ru%\$\"e%*k6G\0n#N2Rx1\n<\n-Bj`ڪ6mh\$'̨\\iPdbDn~\r1dr-'k|\$%!cRxdnU(QX3%\ng*r=uP~p5)'Pc;53W\n)(pxB4ss6L4n8sU6d\0\\КLd	HCklYR6}'].4#k\$Q;4Fwj%K1'tgCb4#>4Wl?lFH\$9>Gj3AB7;BB161>&2a;A@sC!\0+r<sn2]=҉DxZiTPyrNEHLmHkL&M:NH4H딤`CR<~q}#S[0'2\rMNLF~MtPN.L\"%.G8dzL)3t\rQ/Mυ6\"7B\$@|8U^nP#E{2.4ZZ4l]uc<c2gkRPeV\rU&Ui@plViYd)l\r'6?68CDs*\$mZB۲/Bzk}*L\nZ2I!숪VoZUBU5\0\"\$d>NhȀ3#pMP'C2A|'J@0@N5d#£b!\\2L>hvX|p2ML5TBB΀62\rVxd&ֈg5BGo8(`q<Ijvjqk*V=-E^լv;{2B\nno+7Gu''8Md rzpHګ&.3\$\n\nVU	mDp1@\rdO2,3(i.-4cM8ҳjMp.7PpȞ@\"z.A\0^jNq\"o";break;case"gl":$f="%(o7js4Q9'!@f4SI.iXjZ<dH\$RI44r6N\$z 2U:c@59\0(`1ƃQp9\r0  7Q!y<u9cfx(Ys~\n73Sq2AW312)M9!a'#- մ;bs[70ΗaVrLjPG4J9a\$lhE]^DPӣg_=k0,I@L @*Z;)L9% C: B9HȔ\nJ>0,-э&fѩC*z<2ʸҬh3R6x#J@41/؆0؄k2\0P2 9ek)Z\nirO*B/ң!AȢ47@('m\0001\0ƄP- \r\0Bl'\nL(EpX&CXD49Ax^;tI's3_\rU^)aļpĥ|M(1m)\r#l:L+&t93yޣM7.R7Ī'\"\r+k\$ @1*x[8ƭ+Z9aCY\rS.j\ntD-54\rȄ44SrFM `(H1BGKȴ	D;&L*&\$quq12.9nl.;@(UFM[6ޗBO|t Mݣ:8<133\$Ϩ(7Q)U24|rAHJ/M4(4|oR8S;Iqg\r)X-c9!/@9>͹o%O|aj*\\hk)^\\dHF(\nkim%EjQ24TȃL-ғQEUqnE\n2%))&^HD\r?^Kssʹ7B6ס49\$z\\`\"\rP(*\n-*Kj#O|\r\"+WJ_,\0Xd^QLjڎG~_i(IxDi\"|=.p3\"DDäBL*\r4;rcRP+eWj_DtYO]us1רBhzf\"5]@n0\"!eC3谔BF\n6I2bDbA3sM`y%s|\$Ek		^U/\$*m	D\0 ox\nNJ)\"DP<mI\"a,H԰oSs7t w_\n/\\IH8v&g9O1m2(>֨pU*\rӫ8B9z3&Ejn\nS\nAU!CU	8 \nO\$)sO(NLxQxKܐ,&~m)B.Hڊ)H.d&l\$4'hes]zXfI\"G83f;<)BK`hi-T!9*CZEY%QI@Լ\$P~@)+6b	*7n\$\ne0TߑmnJI45e]4<>\nP,!\0 U!0\$O	*\0BEā /8\"Pq\$ <2]\nlM!Bd'ѬK3ǨCݩ|E~f@LY}Ia\\vF܌E93\$ǡPM4HM.WayN.pg}\" \"eF7ԌLSceG3B\"Q:},U!SvE\n&Q)[LnkOUktcpMcᖡr6b ݉z R`Ls٩-m	h1&gFkf\0\$5L48%_FhЙCKM&\r(aӾHXے_(V:ՌXed\$Jn;bO\0C\$a5WW+\ri٨cus\nHQZbLSLpg)ä2]%7GGQP*bpB\$nS0)~|LF)FS.X ٽl]\0z=\nT^;gJCkIW0~nr~RS*u}7y26Jn5d\\0>[T[ϾĿx7jɴb9\$˗#଩㝋6_7̩M 6)\$m\$CH>HoNʕ7봄\0P2]g 9\"b\n	FCfd\"bJx#_L㨘wP&fDd\rDmo.,pN2RP_cdKEOf)8K\0ʝꪤ\$Fb2\$-#0P\n&6-Ũ 5~H\"L.,B!s<Q\r0 d\rl4-p;/*dbm Og %*\"LqPKC<tq%B%*_uq@yMM\\Zh0 v#L1'lY*mq;n(QP\$1\$I%GK&	npc2#dkJX!,)b5%fDUp|BOpc㤔KVk+AO_%%㭰\rx.rd1#C91\$qZ5NP`9Q\r*wqNqP/iRw&-RjaN^#(P.&~\"<Qb.nÐP&%'8pDҸ\$Ҽe&rR(2p9-Ñ-\"pef\n-Gy\r,2lRD_ccHvΐ	1-22&'(svq/c1 !#J#S3ZE\rd)`	C63fʅc3u6Y7ޅoSu,%'nY+PM&c<M101:iix};N{!V\0泪ҏ<;s\"wR4rt!-3'dN/P	\$`G`vMD	8ӣZp(cb1\"BFB\\d#CRcBe5bNVZ\"N\$\rVcj2CXV3F'tJB9-Ёh\np.٢*Kj6AjB\"0MhS	5tу<H?8H;g(G:+@AH,\0p4\$IKظĨt5mM RF\0yM2(3HpN-CLF8b5LPRK&5=TUL(b]mVU\$[Pm4 Q EhR\rl\rZOb)\r m|Bnޤ)U9\$W-\08`nLA)4ߴM>`2ȖNZnUhhM@.4/; w\rB\r";break;case"he":$f="%)kƺAAvUkb*m(]'mu]2וC!ɘ2\nAB)̅E\"ш6\\׎%b1I|:\nh5\r4-\$L#@'b0T#LIR4TK6~#qNbʨ4*MZ#\r~Űt!MDa̂XVC\nǲ	\nR\"[ŒšgOxl{EF%kE*.tOlD(n5spr9BQt0'3(o2#8S8>cb/\\,ޣ:R-Z)\nhʖ6DPJ:n&0h20rL(k\n2,.1۲0c2Z@,>a\$ȋ#*'%%2ė,2\rH?#s>>{:\rx!9@X90z\r8a^H\\0=C8^2}'JC ^'>\rx7^0R1KSlkAR0JimoR10²0Cu\$&ĨShI2\$֒2͌+LJ<ݤm3:F.%sR_TnJT9TO4!ے\$E%!H%2)2Ĝ۪2^-(K%ƷKi(%U+#ҦԇnĎl-ңȶ o'9BLd&Dz0H |d),ѦB\"~9^/I@6L״:3xCeYgP93\r#?X2<NP\"\r#6>\r_y<dpT| :\rDqYbJBۼ:\n4e:p*NZilG h\\#EK+Ԉrfb&&KΪWMwo801c.L6TTjSl&VY+@^}ވtXB(x\$`JcD\$B\nS*am@HB^KIQ8ųI\rt-yP*%HBf^\rn\"+\"Em%PX5\"L^k~r!GeiHF	i }P4T@ QA6\0}CXa6UC3ل:\0\r3U>*Z\0Ƨ\"A6=*_Hd6 \n (\0POAL~nPa7 Ciy[)\$~I\rBV9l4)3XH	#~l*Ru~s@YGCRHTHc\rު\\}hc.2!z.'V1?8S\$:CI,]\"DF\"J;4,d\n&Ar#507&q=1Abڃ<BurK	S|NY6C	mgÚl\$∈Jy'~匆	xDxS\ndBd\$uf46,\$\r\rj1UgC-G56WN-A+#yjB ')%!ZEJ1C\r1HVҎM\$>/t%,%IW4-\"Ts'qȴ!h\\yh6𐤃[|agd4ݖ%ZiBTxM\r>jp|[	e*&M´j#g\$5߅+	%8ۢpN	911lM>^HQ}KhGBH\n#F喌`oU81c\ns<2V0#6\$3F\$7JYf=!k+gAC[r#%桯\"K нǨuڄ9JYjpZTuӓ-/i{~1\$:Y?()A4/8ֈcBl\"e\$֫m~|b\$HA\nP 0;JDy'8^E@_`fYDvFjEFO<NPv	2%H5e#ɑR\"vTg,ʽx9V!%VpjC<d֢4CǳdQ2E-eBTCHnesj\"ȅl'v0.߿p4!#M9TPɛʋC{%撣)\n+(Գڞ\"3cz^z0int~\\-&RGM\n&^Hab\$ݚ{OHpC9+b(znQw9F8v̼slcBlEm7];C\"w\nW,~6/?Wao6odrk;ۥI|7s}xt(듭t Dm-kcBO3d(\0\"Pp*c\"p#v#!\r&c%N%lhjѦnpfƺdTCjͤFf]6Lh*8(,-ڍ#j߯,0&rɳqBKl!\"ЇM-;Ojqb\" Ak	Z0\"\\\$/oKMd*,˟h2dO0c2oqC\$\$hB,:\"Fd*o2KO9\\;1oQ+ofHP_{Oօh>2\$Q)_iJ\rAGrIHQ W!O!boc0!^BOc,\$DΒ\$A%&Ȧ[=l~*hBDVPd%6<;,)@g!l(sȨ4DIIZiG*B#đDg\0a6(.vPD*(BZCMs*\"OJn\\R1Ы0nBVlHH<*lL3#1b!C 8ëܻ,(leJ΂.!3Lb/6*%svg	kg~`6dL)\$d&-֑gf,8ZW`0EfrӺoe\",An*kȐu\$!R¾=P!A@\$\0ӈ(,2=3bd";break;case"hi":$f="%pRX*\n\nAUpUYAX*\n\"baTBtA4!RO_IQ@q*`j:\n	Nd(O)!\"5)RW	|`Rő*?RTDyKR!\nDJ\"cU|\nԳu%g\$I-=a<fHQHAԴ%[M._bQR\"#IrpGvIW栧Rȹ:utn0cv2mp\"\n!(+=Jסi>玲Tp[&~.OxH<((/kͪ4;l\04dEkLZ4#\rdC EA<>	R9c[ʽ, \"zzRD<6ADQD?)j5E!CщH3Ls(Ms>A\$+HԿ	6%Dlt5F#L	4=D3'>,*8-h*,>Q,0SM'\rȑGU4NU㞲Rx\"\$y8nhQQH۶LW^ԍջ\$\$+Wy^OL@)[I\rQmRS.0h-F[ʍ9ԕB)jcxAmMK5[a eD8.#F`@!\090z\r8a^(\\0h7\\7C8^2x0cxD*bM\$o:.\r-@xӏ\$'^cFa4m|S>Y<f};ͷ=?/_Kog)u.>'[[\$~;2y=2tKQ#p۟qjUy.<n^!NJRrhj7JO[]puTaDĪ֚c[)M4a\04\\- )\nW4}Yt@m@PS\n!1B#\$	d0i;lP:jba50X!:	 tQg1MCm6&C\r\$}LpN\\?F(q?\\\npHHVR( to~1.U6|-QHADhfۥ*kh19ͺ_DR9	 ¤a.AYkW*PKIkI#DjqMz{1U/*ʥdФ33N\"t<A:\"x~H3,.ҖAS\\˕2\n:FR 2sԲ7B!<˒-0K)tPlzS^D+\n_m\rv%9)DS꺞m	\n470Hӄ3ޣFXkMq63hmM7xd\r0@\\F>\\8TAHݧB<9GDjBPړ6S	oaɓ7	A,ta	cS7Zԓ^_hqI>eTfXQuZalm;vkon-ͺPsտWlcu1qgU6SJQz3O;\n&t5N,r a\n2I,g\$J-ʣ22JJ<bppE8jOQʕЙ*Htsfڅ\\-\n (NH=hST	\nW!/!(k\roA?|JlZS24ԾFR\$sil0O(3=W4z/mn*4CLAEFQĕ%<O	b049QYȳR)v&eD-@ԾO?-њ.Z,#iB̈Rɝ4爢)c3i+ѝJVC1ҍ;NE#Z!0F&}@4!Jsf)j(DQ@'0FSSz|z3B 3Y(>V\\hRbުB\n\"a.&T\0F\nݖhJ*Phd\$Փ.Nhԋ}ʗ|3|ЛcޒPWeB}>Q\n'k~\rM>G]eO>7՘=OfO\\yd7DT'?/PhE10ܜffǂMm?Nkz6(#d7#ZP	⯥_5)inV>Q@gʝ#CQ&Cmfgݰ7\nE\\Ͻ@u43M3qd?|8x{5kMdt7\0yr.D^\\qI6n\\,GI\\/z..O%e.@ĤNvf4PXE#xͥ,\"	`h.RJ'l-Ȭ܌#4=Kz+֭ڊ~lMLN%tP%FxGH*`p«X:#	 \r\r+x)B<\n\n6JcO/dl:􈤔l8а==@A\\`~NG\nAIg%0hO\"xgAKcCGxCGf\$9tQpSB0x3|b\nLN<	>/J)aH1AEï`{1wI;q3Kõ1J#+6ю籔;NmpBŃ*CɯvEz\nQ1Ro\rnu'QfW/\$I1§r,#Fa#R3Ax%`e&6xB\r\0kΎɽ(GRm4E%0RB#`r:)2LOP^qt9A\rBQt2vpKfb^}r|:!ec'\\N_onͼD.,yRMA!/52c21ɰe>vm>N\$22F_4VS[896F6Snsp3'5S~\\V6wnۧ<\rUd@\\#sz_Iň6,p>[<PN:QPjUw7k{5-5n>prqB(4]:e'\nF5'zJ\nd膎@`\rH:%s?On\"5C337D7i7MQ8p7F4J8X#T]DF_DԌ(t=20LEGTNЄKqB3I4EI4N#.33s4oQ4s<E؏i\$<GMrlp\"N1W	Kڋt64ų9BQIΎ	ucI6co pY\$ ӕ>x@l\\s̗z2MUUV%;K0>Xu} \\Z4-2LRz4>[ɭWiyZ65SRX#%xu`ϐ}U0HTDD5#_C7S,6tsJVmJc_GLaU9pMUJն\rTbc5;-IL'AYmTtdhuSWE/^KKt	%#4(; 5Qn[)^tQ:\r_8Q`Vk	o_ak£qZYf@/hz\n(*?Vk*5IVEb\rH˷ʶHw @_/2>\"'mtio)ompkaak1rqBuqu\raq\n)_quqtx:uewWw6vt4y\"6vzwbwH4sw8|wvw~0{|~wXf[6_cʩ1kmW6uyWys0azzt˪D\"8LE*Mvjt5K#sxpUsne\0sA#h#'gS/Նnm\r1j&d戛JMi	փ_# /i\rW\n%MU8# \np	=[^:C{\\k'xk-'+WT6M7'/釖Kcc?90~O&8<J6r2hM'dafMOxϖ?y=djug\n.\0>W[F_a,9.J4s\0drX-pr+hr;aUi'Mx =5u5E5Գ ӃeL#΃I16ZOAmsbB4{!=G}7SZp\$-:nPȃLLGBGl?\$ڜau1nzlPGt,MwPfËߡg؎F8dV\$3Dp'VD~Z30㷝3>t{5kLJZ]1<P18";break;case"hu":$f="%k\rBs7SN2DC3MF6e7DjD!iMNlNFSK5!Je@n\r5Iz4B\0Pb2ar\n#FQis'jbRa<4&812k2N醺9`SijHjӡxH/Iɸ*,΢G7#Ildb{aDHedMänMi[.?+ْ͇\"s0؃.j/\\daࢤt䥺xP,@*X7sT9CxC6賅8Bc,2%P:ʳOFAJ|cJ94:(I6)Jb*@S\rP\"4DͳF\r\$-f=9\0P2x.81 ʂơ2_0`P>N@l\0C@9I[X<D8Dz0c\"9c:GMCC8TmQC X НD49Ax^;فpK,3\0_qLVI|6ͻ3Bk4px!T*56\"P9Z8=/ ,9l;Їrzx\n&45\"r24\nB.(\$d\n.EPS&'4ks48@\"âm\0. 3#6ט2B[zA2:1\riX3c<+	\0Уf6IP]Ip0\rҰ)e'%,h,QXi6H+Oc%\n\"el9rL(Όtuͺt	8fbRs`8j퇠Hդ2lcM#Bx@8:襝c~)|Ⱥ(戩p\$(fk#'}R\"]QSsQG\"~-{o'h䄜#B<Js\rt`é;49\ncTٷ~yPSr]!̕hy@Q3&ٯn0f&e 5% o7+*(\nU\$3/ m0l2\nLaQl\r&9DeP~mKE]8Vʽ6a,ER9h\\֨nZ3ҷ\\		)٠8aH)\"{jsD#lU4X|XkcV|s!kBhQ\nR݁Op8	4 32Zd &!% 'N@A:\rؐrSO6ѐ\$IFHN4Č1\$\\a6,9F:f!S-=tV&sgA\0cL48Xf,dGD1E!3LiI\\TP@@PH\0POѳ\r?UL7fߜ>SzrJOT(nyѠbjI'TY	Ur&VX\$X\nіZxС F\$atP,p 	c^{`ß+%38SA+tSNhDiTctPa0lT7NËOd3!R%mH1Gq'˼ˤBXP	L*VA\0C`ٻ0B>\$evYAp6YUrZ\n[ W\$qWUa\0I-Mit`N&zl[{ew! Ҝ+/쀫M#:̑l4L=2M^2eFґBCX85mtRJx#(\0Əka ;Vj<;M\nnPY`nqty52d]J>Oy'!\0Zmtagy~ب&+vO8\n|+\\\r,	{ЊͱY<Đg\\ڄ{q%_	Yt7n`u9ѠH2y4Gtt>o(wa>SzBHn4:Fqxo'Z1YJ6@<SX\$BA1A5w)2:ik.o]/?7tmy_ӺAӐpjRioLR,#ӕ]Xwa*@@ \$04(mp#D_k9)sr;eɲ@^U!L.ȧ]U=BUq;ʚj0z2Ap	ڪqpIeāZݻ6oS;cy(Nǖ%TʹAYQc#˹?{8y?Ot#&F&䔍cluZʼQ<qZW(P6CݫjgB~X>\\KX݄̎`\0@¼|l&`㨓pa,[#;C GϠC*:\rlH06#L< ~FH2004ֆ\0X0iKCd|'i<\0\0,R@X 1E43'\\: kBF\ngƴ]&&1D\r,l\r0ހRCIs&M\"<--dM,VD\rRsj\\qKe	/] GI%kG|έ2Y90ͬ9\nNQB3DBR}Y'f}vZ1vuMqj:@\rF@g\$s(/\011=\"7.\n8,L19J\0ؤ1\"kq~<&ƞ\0@.z\rHAk0b-/\"#f\rev\$\$!\\y>2@b#UcizM2Td܄PbqU\0 zPf[!΀h-'u	qs**R#2ge\$#Z+105JR,ګ+'{*l=2,'pv	b&	\$(##@nlh5\0*D_+lRgg.33Ҽ r)<-G\\լ5F05c4#\n`zj\\;bE\nyzs9S>2BsE:qg59s8F`-`? '0`<+6Mu3fS=OJBE?h,>ʉ@S/k`(T3N83T*S3oC(:kB\n=/`D3<'Rभ/ԴLOD&DB`FiCpz>@4e?I\$nm8Gc<mN1nJgK\"d/&IKԯL44`	bA#\$\$\$cMm4cW4OF,HQOOuO^k\rK]%Vi6 \r ̊dt%@Ij\np%QǺD.U\\{cKZu`&P`\"\$\",\"G~rBD\$JR2@C\r`P..G++Z%_7KZ1%9ARYDw(Zثj\\%X\0]RC8gc`m,go`|||,6%֡B4=ab&\"P<.?oA%!|M\0*k#Y=a\\r`.	2q\0GxSU;F\nHɖR^bASxs-Ix\"4	C`v\riҪbccB|Ul%I lN݆a8)IьYfĪ.mf@@\r";break;case"id":$f="%(i2MbItL9(g0#)a9D#)rc1M'I>na&ȀJs!H\0Na2)b2ar\n%D2ÄL7ADt&[\nRa\rHΌ4cp\")Ũ@QNi8M𛍘'ȋ&a;Dxr4&)KFʝNHhY7_udA<7zZ&psvwQ p:HQKEYP8)udR s=qq;c\"DN@<.8#I0ƌXҍB|iR!(,:>%ڧ0I1#z%-&2:Ȏ@PA^2-ې4X)Z9\rz&jjX cJ&Îl4b 4C(C@:t\$'S܎Xa|\0C ^'I˪87x\$B64R&Wz	J|*躌cb{6tx+s\"7<,BX6GJ´M\")u\$H@'B%0b ;Ac#V@#\";*1q,Mގb(Q*:]cͺ2:Ц(P*NC؉Z,5:Þ.|3L\nMk|(b\$^	?R._fM!jh8`R~(Rжp\$(Xi9^3\r(и@j\"}%{<BE_=5_+Ƥ3m.	vN\"{+.,Mx~xΚt\\<(9[j݌@H\r6xiǦeV;.@ 3@}zPDԊRL%6OaUQ\"ȣ/yVA,Q,pX4OH@JA5bR\nH;GbSQպҫm.0h\ryzFyL:ԪMuB=VC3\rH08&l}\$pDavI&Jzh<,hA	E҂EBQX?B(YɂL|~\nd/U2d͙ʷt%4  BF|ʢL#SesqU!@p5& ΢IF~'Wa8aL)iRRf8.,4g~RP2:EKHPYA>a3&y DXCHk&tLa1[ɡ:YjT(q`HN}dD1DI'\0TdȞ>RIdcy%rj[# PQkrnVb~b'rr;	Z4\\0T-ͶD-GD!Ȱc^KľUxxNT(@(\n \"Pl\n	\$ef\$%Ԍ-Q*HM*:h0ђX;ix;\\\$v11ZU+NjA]Y=QcPSX<b;Wsx2)'d?JRSHD`ae6A遹#^sy:YH2\n`e\"a)6pծہ,p\rѬKWmBK,\\tAKm9*&Va\rXca\rB%7.RfɈ1k[]ˋYvDyklTGT}Vӎ\\0C	\03s>Lo>骻Z'r%0#0ߖ/ajѥ^!@=]FgyT\\s8'*Jn(9ܔ+Rf%%ilxb\";Sȉ%x8ȣ	#^bh/b\$J!,N2L\0~.9hhFV@Ec[ld`6pQQ.l^VN65X:H}B1KT4%)1'\rskY*\ncu1^qRc?!6겈pK?PTx!\\2:_ȉ\rvmW3cƒg;#\$YYAc\rT`mBΊjLwTeNiä1L:\nxnAOBo/Ojx}Arx7?U}gV^=IJ9z\\G`2]ޛ12e^ǞW򟷬Oq׳!ƑFCSm\rk5.{CB]WV,\"_,|eP27J6)o,:`Lx`̾/H,-΀/'Xz2.nbm\"&&mP`/@fp\"t\" ~	\$\nf̑jH;AFY0-nsBE\nsO0FlPZpzy(af@NFnL\rI2ږ:\\c<ʺu'a0k6_G\rkp!CS.j+pO1<_\"|SB@O\01J(9ml1`JhʣK_HD`˱#PQ\rl#lZVZpf,1Q+n\$xHU\"99MIfX{X\"0GkՉXEjk\"U`4ǎh{\$@(s\npt\"(\$ML1Xf=bD\"@Y%C\";£c.͂'ZMj7*Y'[BD	\"[NP*t:'HV!CPH}YJ3\r^DQ-oVX\$|c-я.X\r(Rf/XH6&\"܊i&bdcrd0d`w3b\$m<\nSAc	2\$,\"IlC.)5|#*6목ҥ2/b:G|@HƦؠEEdbEJ1VBX2";break;case"it":$f="%(a9Lfit7S`i6DyA	:fL0č0qL'9t%F#L5@Js!I1Xf7e3M&FC1l7AECI7!li((\n:Qg4tDa1E#2biiDi\"4ԣ42kxa 8c=z9F'ZUAv1ü6o\"ty:{Ljsrtp7lE6J;eN{)层qcQ&q{*8l8&c3ԔJ&M#~*2)aꆡ P0;0жOJ)h#zPʙ-p=+\\l(@82DC\0B\nԇ8Xh7R9&R(j? \0@IH1l#I!S&PR46#0z\r8a^\\0̳8.8^\r~+t/#2Jx!L+:NK=OHP֌4	J9-C߰;1RRҩ:\"G(S̰ @1*hrJ\rb:+j!Ib!(@17վ+,˲4ь[❹Vނ3-2\"ZسX!U6kh%`S!ȜѰ}۶J+o\\*hf0u0(PѲ/[gVt:\0Uho_ m1nVΚ(43\")\rT #th{\"\$俻k.܍!-#8~jB:P#\rFÒ<0op<MATw܋B'Ý֤##	\"SNcjwr[,\r)3ʦ- ,k\0K%l%PAyKÄ3_(C]0H+٢4=?{0.h+יּ^I~MR25X8*&\n|7\\%3\0RrPȗ8RD(R)䦈p/hBZ0hϊ-A@݈XrE}J\rBIA^\01d2E\\aʅP%ECL(x-hP7*F_Oպ:C\\50E/Rc)1Ʌ*NFWBmMqv׌ Hga^O;\"A\0B< <-yPSe6,+L^CÕid\r&BWȷH\n	67PFA?\$!Wt`8ABFK#P;i#%wr=`2@ү4WNk:e~*S:\$69v(b02BB	\n5@RFeѡy4PM2|:\rPf+hE&|A&}2 më%54Tm-#P\"B*eeڗ'XxKje~΀¥@װ@T}Ո9pu\\Ր\\!ZGv~#M&VIF\n;WDV˲L-S+IӊnO	*\0BEW@-2H[浮i(X̛OQ(`W1aR{\rx()iRkfM\"{ELxƥʓګ(qc`oN1\\0B,̈SOZ}xXztβ~2ҫNōs7.2P78PĊ eq`ԥ!.RDlPh\rĶ2ޒ6ɟPv	2!S8S}\$6s_ٿKr\r+i-yo,+2=MCEf[zd3L`o=h҉fPA'/!D}LE|#*W~L\n:܀BH\"Mmwsf9h\0\n]0]{}:˔(uy<%\rfIK=\$'?YXp=L1}iM,hDlI2ޥ*`Y|T z/ׅl&׉l\n+L,lzC'zɖSabYr`(+қkTIӭSaN69a%DqݻXdTee	ϭEew2Uy%Mf1K sΉ%_e%!?beަNL,tU-yay,n\$ˢHokP=/ayqw(θd+ZCh͸5xzB=+:~NN}⻮F_+rϽ}!}PrY8.EݝJ!ͮ3\$^-=mգb@7pРOYo`\r\"b<mZ[i`>\r)nK,`B0f#C/,ޕ\0K&Z/IsWi<#bnJ8M/2j<\rQL^wC~3NM¤8.7pEono\"06P0BzLjPz!kXm*\"|ܾCv/^qE\0\r7qk blmd.D⎦~\"\\&m,\$a%j.\"<5&67fn%s1\rqKPOq+aO\$,֐\"G\"B-\rѮ8q֑aqcmԃ>u\n\"f\\ʦҖ\$M #!\"=2J#5M\"\rm&5U֯-61q.*1\n0&D[\$ǖdk4\n%(U%f@&d^INlFQ[C]ppM(\\Ү2gn^E] \"#,,Dt+\"6,}[~3\rS.hG^]J@\rVcю:	;(bzR(4\"d5iw^Z\0%mK]5iLa\n&	Ɣ/\$\$,j\n=#U*<(K3Ycd\"\"3&FTN?-c:QO>.V7g#.mT_pF6ʕ\r j\0[x56ؕŪC?)M=3 ?:+͊p(M?@=X-̔8pcf:%\$ϯ\$Er?%fp`|`0\$g\0joBngLO&uGc~J9Sc\rsgjIE@\0gc\"\n\n,LBo)86%B8";break;case"ja":$f="%:\$\nqҮ4(b*JqTl}!Mn4N I*ADq\$]HU)̄ )dt'*0N*\$1)AJ堡`(`1ƃQp9 b:W&K<^\n2&(z?B(k\r-((b+_SANuқCKы*J\nfYz(2\nAǲلI̛Z9L1T*])fCW)s~][S9ɟRkQʊP{=B3]\$I锍P@Q<JpFHbA+DDE8(ard\\@@g)^_80n,-7\nBM!1Pjs,^g\$\"iG%BHFĺ-<*´@򘱜ĩ`y.R\\DP(K,U.))dDi\0d:AUSˌO1\\P\\A\\t0zE+X8') F1qrDQDTAňHe^XiMHHjմ h7eXEF15WUyP1RNq<LRT@x0@2D49Ax^;ptwh\\7C8^2x0cxDARY`|ٵa~Xb9\\2ztj&8㖋VAA%l	{t!V!l[ZםiLr\$PEteoS5.LGI\0Q)8Z@A'MsPyKSaȵ		^R	DeBd\\t\rM[u[UV4\\T\$0\$Y+/+9\ni0 P(aO!<}	Kp9H]?OiYf[\"m4^}:tāq\\G	-@}(X)RqtMp=erDA8NϺ{gBF)%4dz![cM\\Π\$HJqbPsgP|\nd)@\0X9*`I,XKBF\$'Nr5)4f`tM1QA\n8ØB2r!\\>\neօI@S&i06僀Qbr4D0gɔʙR%\\T+4\\t.!,T4vNP@1eL\$3At! ?W6*c}6J3*epa3 M81vE	&ɀ?Z'Fg.9Z9̈́҉_CYM2L)yԦ)5!Ȼ>Y18Ǚ\"dݓ2k/f!<F`1gq\n((,	*DAWc8' :\"I+%\\Ls^:͒\\RԞ+PRG0L3MK\$Ps\nUt՜>%4Ksx0TH\n	BCynƣs\rb)BwD47\$srtD48S}%h#X#G[+LlID/hm˘K.k)jH#>]q2zMĞ_RJ#jaQ9Dpn:\$gfgq!DS\nA[F-5&	\$f'xN'Ol?佗r0&D5'p_1D[iWM-tQEdܗNVS:\$ ^C&J_rh7AXDF#ɻ-pxS\n%UɅ	%cC8R'aDr\$E&֋j9fe\$c&e+M\nq8'LB`8N\";bU#j%rus &c]FKxi=*AcH\n	8PTz@.p%\nJ2gpw\"%auAZA~o~1-oNYh*e!5>`rw*JHmՒD#ki@q%k!qKV{00\"-:yS*lGQȡPcDE\"m[RY\\e)	ݤ`An^j5B\"	Ԇh9r\\\n\n	Atx9<xn]֕]Cwt{+jYg!0Hlm^vG{Lak%zCsΔk&Hc1g!e麟l<{snŠC	!W!DO.>k\"o? \r]Ҭ@0!6HϢ A60!zs!xw/iEzE8-\nHEGDxG#p=<I(^xp\0@@o6&\$ZK`0c\n#Ο	0Lqd}KxVHΰs	(C4O04C~t6+l\"͠dlP\nf.fʑ\\.\"C1Sڍ 	`*Wax)\$[rXn\r\ni>ǩx\0*aZvp2~%l@d,H4P.&G^#\nD,89Cpڏ\0GQn]fDB \"\n;j\\\noJ8Hx\"vn[G0sG8&Q1C1Ŋ2(\"L/Hŵ#es\"<g6A)v{\nwq%pizqm'hq.c. LXb\ntB!lNl]!бI*E!KB%(v+DMc&Qr.7OX0#-r..Rcf0!\"¶C*Fl\$*XRP	'(U!m41RsVMRwNLNU	7p:3+VSN_3Qc7o8G&Ϫc679Z\"N93S\rJP`bT{m3~PlBsnlҨB6-TD	PJNƱASa3t,e53\n[.Q-13*TGC^T:4IBFa\0!t5!d/C0W3)/T5EcI(8tAB)bbIpIAN,Eir=LKůDJm#!4Bx%)x/LP&OhCJN\0tCOOGPa47*OuUE*!%|ZE1̘/C5R);S.B/0(\"LDP~5T/UD/-SEVS*/IKI9XQ4V\"]YYuPuTCKY\0005I\"*M[M!\\i:\\ZQ]SeZ[\ngOET=%XKOWt^u`4Dn	i\02T+PHK,:Ca2kI0pP]GuY/ŕ/(\"#4鮍eTwdniD\rW\$OHl@\np)4<|\r3\"ۥMPc GgB4cG[qu5#v8K0Zhcd\$Bx̔!FT!B~hbCO-r.-\rL^&4p2 <z҆bG\nwQj\nazW[>|ȧuj`s5\\mjswwM?Brqvd9 (nUvX4l\$`0LŨx k6AP\n`i7v|wH#+|WV)З[OvG4x+va*bw-#`{DN@Nn/%\nEHA";break;case"ka":$f="%)RAt5BPt2'K¢:R>5-%A(:<PSsE,I5AdNi=	  2i?cXM\")v@\nFC1l7fT+U	]MJH^x894\${]&?O:o?LLzT]QmQ^dQ%M_ks`v[Hn+e3TӉ%v,V3ARyAi__Wr) QnK[\n֕k34iADo	(1\"AP83t=RdV&Np-N+6\\6K`?+\nl0<OiJn1N\"mi.i_* Y11lSFm,**L+3d-pk&OZN*OMBN%&KU#*BP*WHX4\n\\>˴OJ7#\$WP |4דI>PR~?VAUj\\X_OҊLt߿1Ұc; VKc6#p9Lz0'PUM!#.\"K\\\rJoU/C[!\090z\r8a^\\0w\rp^8#;# ^*a]x!mˁOTkN\"SVo7E)D0:hĢ&5cZs#/=vƄ\"+q#7eSF4ZM<Rtڼ\"/0̯)Ml+q\\8lJ',a2NVN#2;Bɽ<\\q[2)T~FUm8J/s;~\rI3t[SBL_%7x,Fxkf-R~UsfGU7kZ>e=1vITh&OЍwZi@2((uLju&<dM`պ:OQ'pO跧{U0>3EELà b@p 10 C?h\$50|xn3l6%2hb[Y\$*BVT-6ƆYsnEĻrA\r7dwz1ZX/VroIčd,[v ؟F%gL2\"7Z\"p,Xzsdd@Y*_Xt2S'fys}zbY18Ǚ\"dҁ2Tpd!:gViBkiLQr0C- i*ҼF\\FMB/,L&DWNJ\r~[%\$e\nͺ2ثc,mBd쥕X-t3D'AK\rPȉVSM4ئy*UWZQӍD{CEarZz wH蕤g+f\nԙB\r+5HU^xD3-WO2db.՜wG<)RR\\\$jg6NRQN		]meîAS&_4ju6wKUX\$4=d.w[Wj4;3OiuU׬ob2^[OCMt9US-	cZڂ1\0Bm?7D02\rŵA16\\Kx&O(yxS<6vKgYk!:\"%ɚeCZ TP[9(T͡+CS՗hSrKh/;W\$^jLMK1T!q&26d(-ˢ`m+/vW\ne9߶e'\rb/sGƺW!u^09lwrOj}\0\n׮l5Vy.X`%MMgDi<Vy;r yȓ'Z;cYBb|R[lÐᴜ%V/?^E:9{.&s*nUSm/uQ8:9K!<\\RGŢeSٸOJER]4onKzW,S\rVF&u\"HBotq']ܩ˧?NvD-OͭjԮU.\\H;H\n	V`uԂ0,h\rb<tO^vfI'\$~7id3 I{iVpztˆ=>ι%nNShA\0\rb\nf(\0\0|',RL&(lŢnϰO@@#?ln'\\羚<֩^&Mfώng#ZYp又V<ǈ4+~ \n`_-o-\09LÄ@=f~-m\nOm,B ^-p-\ni\n~ɪ#.Йo7BI|/PA\nо\$.efZp0쌨A纴vcrCNlḧ́,CZ\"}f0ƊhmԽˉ _L`\$׍i¶i1dqkJl(nqk>.<'r\\sOG-oi\r '+/.K*bNzobn6ɘ6>  ,5+# S\"HNct6VrB0>JIC_.v&n%Fb~烈Z#ZtuB&rHt'\"3\rd-D.3+*#*hVRr\nQƒx6&7M'S\"6fRv\re/\rb\r ZT2E@\0D&JQ_R2nZ&?2e.~:{242jl!!RZ2팳)43x-W3]t>M3,L㳂GA!8j0 P2U3k\"/xT~Ӷ2=#'3Fm&sPL0KHKP^_ܲ8+L\"ji܁#u\n)Dh1\")QZsLUNiA0/)_jx+cAEph\".<s<CA\$`nN@S4\0rW?jӅ>N6(ƨR=S6TLE44¾tl֋NZtFg6N+O;4PNOmO<t7CQ\rbtlh,YgR-ShO&Z2r@rUPprR-2\$CU:u@LDVb::(43W?u?o>nXUKDܴn0S,}X5I<lͧTZ\\LcRRZ1DDrFRmꘕ}RU)uH=|ƕ^OTXM[`t7a;M\\S`uG\\rN%S,'`LiM396/5uZi?YCV35;dued.\0\0\$f0FZ\0\\&6}h\0h@hi`ih)3j6c/kP%%\"GM%,\$5YeVfHSKaViU\\m6]V`gPM5/T52iÉK`6Ooo_b7-0W?rvTάa`ADV=\\H62ZHqL\"S5)#]4hz\nSofSs2n1Vs T+&ˋE+k,zmCG.52	\\(bCN~-\0\nhZ\"22T6]\$\rrty~DHUi{RQnkN\$x9qc	z9&-{{Ь=0WGcC*AwabV_ ӄQ`h7	3I8'}Ԙܔ7h=h3~-\$(x*7W2^N#XsgK6bh)F\$WbsG[SCQxNq%+r?t0RwxLq`X2Æ4XU4y>ZRZTXk\$Am-;g;Ր(Uh/*Ԃyҷnţ'bo1lH4hzW@@48nXXLٴ9@";break;case"ko":$f="%b\nv%Ю\nq֓NU)ЈT2;db4V:\0BapbZ;aا;O)Cf4(s2Cs;jGjYJӑiRAU\"K`H:kBuYs!al/\"`kێri؆&XQ]n:[##i.-(\\T\nRO)ifv!s;z}QK d`'cIϞV	ˊ[6KXvEJ7\rcp;9\rV\"#1+@@2\rxA\0:#;#\"Ljz9!\"YA@p*?+L%Ib͉^\\ gaUD⽽ u<H4\nY7a6'0JI`S7D!`u9RO+:e/T-M4\$!AL1r֝\0I/Qn͓d@EP'a8^\"sUU`2\r\rñAD0#Ʒo0+#(@;#7`Aq\\Z4C(C@:t6	B#8^2}sC ^'O7^0]=>BiNd\\Idv)HǶO)f@/YuY6VeQRb.RNӮ\0PJ2<fZ7uq/\0sQ%,dy2p:0Dd:J07/aDQP*ubK\$C8}0LS&\$	Y3.k#nb1#s()T/39nl>TRzzgiRe9hb>m?x\"0c:.Qii\0Pmc YMfJ>xѐhpdcNoX\0zI2eO\0mCuH5ڭ@ycLp3 \n30݂ڃE\$:0EiDQCP\\R@X*BjJUeH	o\reڇ@Cr#Y@37@@xg>t@g05x2}WeSĬed=-KS5&]\$@CZ4be\r @n-+1\0w/_A~/T`D`(\"hpJ`3b:N8Kɢr	Q.e]HzY[%a5c	A8ڋJ]x5_,Kd0Chpv!Hq\r`:F*؊(-,VU4&욄&mA\$lUpKt4-1\r!%[`0iܲ#厮<Gk0@@\r-(`sN)\0g: J`G3lv ʁ*iP*>Ů5\0Oᕬ,!\r2 )49Bu	_#%rxhC)Y\"\\hxHc\r3 AQvl2Ei-0 aL)b4!(7\"x]8\$gF@Aȑ'\$9HĘ:QdBlFԱ#S,䙰\nG[\"S 6UzRA+	\$<7+!-\\hCz3!\0)ö41Ǆ4)d(+|QJa\">Y8N&CkGPOM(/acބHEM[IF\nC&]y0^M0\"\$Lwr*({{H4ȸbp%Dc9i(0!ˉS`Eۂ&AIQpFWOSN{OyqX\":\n9E)h*J?wxnE{́Q'Ȕi?x\nM=ͳE{3j`T!m\\6ZM:*>\\Dd((>])Q_ք-[9az\";(\"בQܫ76&K0uNH-iy>s(&eyٮ؜æƹ\$<װSwV0C@>;x 7+(\${c\$\0D^>;\$-f'DZ'Eݯ^t1j^5y	kC(Ƿew /V\\r7qXP¡H@J=,xBT\n!AKHiCvᕐQ=.\"\\eK5`{˪4Vn;BAIvەꤦgi\"J;x.kN`| b!ϴuB?bhο0j.ʬ\0[(zIB\\erz)NLLLqIn\"(B\\.Ȱt@,F>@4f~(9t?gq\"=A;\noiPhM~.6F)(=b.FKm5h14\0MD2P05n#fFvp!J`48Q\0g%\$Q.2aNK̖1cHB\0Fc(G7)IQ6GAbM[nދfU@\rB%\r\0o ڎ-\\8[,vݭps\\I--tVokA70ʌ-٧T1L{&%\ro܂.D|Q[S?}ޒ63oW#CIn#G-#q##(%fɠ1 \"j\"\"lm!2%Æ'م\na:L\0*Jnȧtfi&J 2c'A)Bk(rA#EO.Y Nkn{C 2G -,p-W.w%\rѻn'PQ-0r%1%oGkK0:D\"i2\rB\"b#A66:'!Ro4N'}R1!3a6p-,81rR植7`\$_(Sz~G5r,/sM6ZI):\$R+;isL7~eL\0JNpS2=pNsQd%j/\nd2`7EFAFϕ@t\n%A,X(Aj@p\"M#7D6SD#E.mXT]8[Ft<	K1xd\nm9:?OhLs\rHS#/RX@C*zO68K<4'2jMx8S;D=b?b	2LJv MNNaNO3PR\nalZ \nZo%2`[Vʆ[H4k\npZ%u\"Qb\"#'/b6H,CLJv.\">rDx:\nS*'r#][jd!'1LA\02K^F;\n))\"2^Nqq&7dǌ6p^hQ/ae0!3,PgU\0HqX=I:\$h[T&A	X.AE*a/4*dqPUt\$i[iD\"\$=GAd?4.\"f?NXJ̽:>߁fjR(,Lx-;NF6&	Oxa\\v⁤Jg<G\$M`";break;case"lt":$f="%(e8NǓY@W̦á@f0Mp(a5&	scb!iDS\n:Fe)zQ: #!j6 t7\rLU+	4Y2?F9%A{0e7\"fte2L8)1T'):ubT7Qdu!FQpS, :07a^0N(a:6o݈\r'*2sX*FB'W䱑cY=y#pd݂^xnNG+Tt0t>\r+:H9c2#s7cD:\r*7/h)B|9\ncZ2bJ2?\rd*C\0 2C,&5Ǩ(2l\n2#h**\")ǣbz_\"rܮ`B4C	Ұ;\$t> j%|A1L942h'P&V49c0z\r8a^\\0Ѵx-C8^}\\9xDj-2Ԓ\"x|#5#\$I0tX/&W\"ò2=,:C\"0KD\"\n3\"84#82;¡\r \r0x%ʫ Ӊ#pCp2(`0\\;\n#OX>\r#+,9`+ ӂI\$عI:`Ôd	2-ʲi\"\rc`30&5d6T\0004#/p8ts;`^\"0.<:HՍ\0Ν!.uR=\r-ZS% 0[#l\"*Cȏ_خٕLܕ'@6mej9jq07G_s\rob+̔.0[\$ϸ2h\$nE3Xb\\Б(aBo!Đ7QS`[a\\ǔpnf0RGBR%ΈR!Ĉ%ƢGB>mBN[8 QD+\0VFeZurX!aRxJ\r\">L@`iZ(jĢ(P\"\r <}C彆<BK@pjѠGtXK:H䲖dH-G=PQ+EPM9\$\"G	Є[^vX1/SD!DL93NroFԬCf/GKD\$!S\nR gf#`ˑtUsAu'4*>J((\$NEpq<Bh9A2IHw\$%:xE0OyBhi?Kb-B`7nc!;7[IT+Sj'@!0-'KP˅DU\$%T#\"tV8f(WH!&%&lS-e%:ԄL%\"%TNty2 u*^&%,8SJC1\rC)\n~TאGB0&R,r/6a|M/ bw;j:U6\0b-ősF Rs\"(%mQjId(yyIXKyy:F)|C*[LXK4?b\$tcy :NnH9(d]Dx2lDMp<a詅꼵[w:0ÜA	-툼tN\"˪ȻpkvBdoSV (KK-G\$x=0CPޔe\"{ɣǪPduF\\M1q	<zM/y`3h׭7J4\rn 嗀͊{7;HGHd16ʣ0\$ats-p\r]s1ϑb		'CPTFK!J,6LGPAexd\0gG#<Ű#bq^-u{K#9DgJ08PwPڢNF=iX+G @BHhYoHp{,%cE\$^Rb!͑L{r2b8zIYzD\0@!3c={\"D	'gK;O6cYK\nfH4at:Ne>K{-}jv?{҅w↿QQ\"Kh(˟ޯnfxމC`G3? \nHZ,4Arn]+Ȳ. 礰kh.s, ƃΞC1:/P9J},DޢإXB`_.U1;e͈.pLǭ ,b ,vvU6ئv-b8c^\$;dHFH3ȤH\rp,H!0v\"h\rpe,Dڦ\$ڄ0\$P0\"^pά.eXcѱ3)/@wDϠvNEJ\ng\$f1fUp{a0tor\"y+W~/If\"``^&N765<\"ELLp\n1qwNĘn\"%%hLt5읉\"N!\"*@¾\roҴ\n\"&\$BN3.(Є=\0b~(&51]\"_%\$P0#Lt\"\rݍP)nҚa\npD-`<!*\r7!\\zRr,J1+-lOE~@F@e+\ns#>1»1)QK0s*Ϡt2\"i<\$eЪ:29(>,]3%1S>@3M&eHJ7,<Ke0sR#3(d4Ҳë:\"Aj\$«3e-0![8+@@3*Bz?\0fTBo;SS\"(s sΟbNL/SjSni+n[̫4L3t{@jn}/r+*ΤL>,kDCgY7P44LA1\0ҹ#.3,Ǽ͓6Ŧ\"^gc#A5#n7l=G&ĈH4uT1/\nGS\"#hGn3J@	oJ4o'OL9KѝLXb:e\rV >Tz}E|;n9\n\np#\",(L0\"϶u,\$\"  Ud\0iB-'pp O``#9el-B0%9N*8#	Bv3\$@>W9ŬM0ڌZÖT\$ZUO\"NM\$AĂ+hD{}<<l]0{pBL1^M\n\$@4H?\0MFݵ:\r)xkABkTإH\"J+Is# ]PCon a\\rb`-cg\0TB`r^FP^0LO6SF_a>.|?@f5,KN10C=";break;case"lv":$f="%(e4SsLq:I :SHaa@m0fl:ZiBf3AĀJ2WYCf4(:T|i8AEh2q1M~\n7,Em\"NS8'ab:ǥ%#)DeɈ0F!Se6u6YB*ߕuϹq8܄dnʝNV7Uy\\|AЉўm7HDǤz+ad0׼pc)@\0b)V%,KƐ#ȌP0\\8#޻\"H/Cx԰@H>77`\r%j\r*yxACb	d#֥ Pbc\\*7(6\"\"H0H*/,HpԂ7(0dѡ HТH`7-B6I\$!	B(@1?6.!`@%@2D49Ax^;ՁpC#\\x79J|;#5#p\n\"\r:xCI?\\2C:@H&V<̂<X%.zrK!X<]!-A(IbӉ,`28 \\[i:6HOˣv'\r9(pAmJyW	ݺ)S53:e=P1\rnlKp%ЮPJ\n,̄C,nv\$^͸@)\"e2o*6+4C}yS-PAy\\D:9Ĝ:ˊ	̸*Bs5?nZL>D4ch*e(,<\r##wzOxuP\nh9aSX=6c|!P3C/FVLdISo\0{߀|2ɛFg)0R@3rckd\0ꗈ@kj9Asih`H4re	܁z30T(Ol,%SaCܻ3]?K̋6)Bd,BVC☓Y!E#80	8|#AFLJBTf9QWziE\"	N!)K,((hI\r,܋ ZS}P5JJUS%h2E\0|\"씅2VE#Ȉu(f@sSF%%৺bJW\$-3\"jH[	mN<TʡU*JZumilDiyg&XO\">oQLy\"NXL͙IF6#QQ ̰mA-&8Bp'ލMF8ND9AEHGDAn\"@\$\"oj9^aQmVF\00S;꒐6Ĕu\".gZ̑1HbRAF\\CDr1]Tqϙ,tJ<Qc?Lܤ]<`DS\nAV0q!,ebfH7>BCL6(\"bLi77v;#@IzeW@A&b#%DE]1:ԁWzc_TG\$6 c̑C{<)J-JQ\$0R\\rnך\$&<@P\n\"1f~YgMyZ1TԊ,F#:G	#\$\"fMd^A\0Utݣ2,j!=(\$]c|&TU(Gm1ḆBb	\$L3@3\$LR(ykAn!BM׺DAfwSj\n̸,dH*0<C,\$&fj^7_gDKlm2٧/%#K^r\"C6\"\r>[t#Dz3̏G\nk]81F	\nBD73\nkM~BHn\rd4MFͯBɓ3Oaرk18_uyJu\"G)Sw@cH\rOkJF3߮]V^DG(CjG\"rRp,=\"3tOaP*'axDW:-m c{q\rkLP&(j5\\|q*Z5(u5b	\r\"ue_`	ZH)Ԑ'u\ripR1rF鈕<a.'|y]H|KIK(APSiH_(D9'g\$U_H&fM(*p#,|^f\"@oFC`k@\\(xBh\"JSgF4C83nD4tB./<On\"0w:\r'Jjno,ИQ\n2\rZЧ	p),̺M2@df0jgFx>FB8\"(Lg\$Vwly\r*zy4)^rbCqT\r#ګ@m΋u~Xb=,NP0\ngPĿ,	VA[\nǡ\r:QiФ		%̶\n`0sܦ:4Mf\rhv# l\"U>ևjl!1Q,qq18̚\"fhz%Q0̡Bʑ2r{q	kԵ2\"*F4S3*\$BfZ]Fm\"PY.AEF lO!]N|\$.nκwrs&r}(.1n䥳)%_@x(2r~\\	2!]/NsxH쒻,2#XOHʮt~qøA#\nq*Ʈ]2!RtA1p3t,\rƉ10g@O\"@^w)QBҗ0ˇ4%3LwR_c4Y)ZIbcO50w7s\nq\rs)8Hn)oE(VC@:%.pu9!:'ЃI:;9::% <n@D8'>gSbS?>I6C>s!+@8W,Ա(RMnB3ft,M1@38]ge21POb2g2Wo?EւgF+;24vkc/b0k`+83FrsQtN\")W#v\0\\7K\0V.b&uDz\0_\"h\nZP`<:xǐ4\"\\J0oQPQ6Ls3\nS`4SsmwLIV(BOT:\"eIZPkVlJ2\"C\04kGzWc#00\"Q\rM-R5?BQSZж,>5Z\" w-@iBo20&MD1f\$2R#tda+ d?/5L&,Ԋ\"B`2B\\Ô7-4d0@@/51cJ?u;Q^}o:\\Df{\$Ik@\"";break;case"ms":$f="%(u0	 3CM9*lpB\$ 6Mg3ImL&8i1a#\\@a2M@Js!FHs;MGS\$dX\nFC1l7AD 8Ls0A7Nl~\n\r pa(bAS\\tZ*fjSi*4\rfZe;fS',[\rfvfd5NJpƶiɺa6Ӯ\0Ѻ&\r2#*L;9Bm(eMƳq霍(a̲yNh8>hSp9c榷I(7z9#~i~#J	{5@#C<-dLIXΚ82N-(TÉ𰥋\"%v6!lmr:<`ޖ /L86!c|:p*n1oH&sc:\rxIkd\0x\r3:xO7:as3_cI|6oX3>i\n7^0Ƞ4QK!-h-ҎK󌼯iդ-vSr\$IC:BL֥(J27=uP7ʏ֠>Éi48	\")'Hlb\r.8ᤒċRHÈqh`ZW0Bqyܽ%\$/#}&^,\nb8I9,:leѾ-X|&ͤ/\n\0(idKc:\r)Pb̈-KBg :B*Goej6!#Z8a:~:UYRV|D_X&9x3\r+%%uO\rAiǌä7\$6E:Ҽ?MZ72R#3#5\"p\0K1T/nj#/Fwa;2iC]_AJt2J140֛C,-쒽o!QH5*ʛS|;.U!ExBCJV\n̙CH]C\$!\$;`ϝ2KJ	q@8@ dE[	P@\\RYL)8\n9*T]ra@ hBCg`>jZ\"D86	qvY3haj( DɋJ9C1D:\r}(%	\$?aICQI1&ba(JQ \"\$TD(υńvƑo\\'gl43hbL5@%Κ+0'do\"\rt\0w\r1Լ0PdA2) =|V%Xb>sD%2N߱pIfqfdVv!L'<xXRBQ[	9lJ̄ېK	\\&?@azn~5CHHY6(E@Tp=k祺HjA\$˝k1K2BXMLPŪ`3QNm*\\R,웧'rpP*[km E	ްDf'07b)_HMT+bsTu_:o͓tAQBL;%,dg<XI]jNHi/F4O[R&ڣe\no#XαER\nC'@fPʜs6g\r!\0Im` 8Wmj4GihEŋ0&/'tK5\n{o:5d;\nVDp\$0c_gX|ɹjȕjFL6hԑ	zT5Lɥ kF ݨNxMAE޲MY\"@PFW\$&,wN<D:0Q:dkȒXFQ-e8P@RlWV\"^N+\$DFWPjaY* Gt!Hjv ڻ-˿	aVFd CtdX*Bg\"6Ljh}Q;NR9B>b#ɉ~kp hV3\"cCטL4+߈XjBfP7\\1/76e:%t9ZFzmqk\0a8\rܤ#=\"pII01beC\$|	RÙo;rNA2G)\"㬢m);fAN7{+?zR9PadOLFWDZTYѲ_|^K)5d0߿~7b&\ro|߱Ozq9g>w}p#6ʑݼIW>bصMN+\\Ξ Z5Z%M%o^K%VED(&v{,3*2E,%R%5)0lb%7@OϾ,)CL0d`uH0m./E	p,\r\n\0Q,bF(mXn\rpfn~Ipn v&\0ק2gb-f9\$rOuNj\r!2)`\\.ʆO\" b\"`Z%+@\nCdn//:sc\n %&юbqt/L<Bq!PP\r(,&*4@l#1M,r琟\$\"h\nLD1ޕj:֭Qo\r/ k OQ;I-M\" E֨(Q+r\n\$!ICeLʑ\$m~<Dޞp	f0?HhG?D:d(բP\0	d\\\rVbl!oI~4I\0C&3OI\$T\nZ2&DoiM7\n\"k!\nܦyn 8208k+O2eF-CZJԀpJLfKq\0#r\$JZ+('(s	@jN.yos_(zsh2;5\r3NEF\\yrc*8h\0eܾk\n#\"W:Zf\0R@<.&@@@,S8C\";)'B!=3V&\nXsd99C+Î#g@æ<3PYo?Co";break;case"nl":$f="%(n6Sak3do0p(a<MSlde1tF'#yNb)̅%!MуqtBK%FC1l7ADs)u4̧)іDf4Xj\\2y8DEs->8 4_F[Q~\n7&{cb#a\nfQR_SH1(՗*͍\nmm0L\\`-`&.O8Qh7'5hj7sy[֦le]gxt*oK59v.cy蒈x#j܊V/ûbَ) !\0b(jp(\"(ߪz2*@#X423\"(.#-7 r3#nC(n0<(\nk[9B:ҵcs/x21@P\rbDHhԁ|;k94ЍAJ:,3ʀN@=QTDM=0z6cxY\r7-as3^Ḱ&J(}<96\r|F̰ƍ=< m;\";ȵ	px\r(߭*01(\"8*%*/-];?x@7%7qK0@PB4mlI{Lc)6D *#Z(25;f\\ʷc,n`(H2SsC{J	xכ)RN\rCn`6絎{`\nC-@\n	Ʒ\\8X肉#hឭm<sc}o7fپ Pז(3I#͡i\$bcr3})#\n6yBGDQ\$M\rbb;#e5(,jKO#d ]3)ΗNٌdRxDf5܈p·\\CcY?P\0X7P80\$MunL9|\$Q^ó`\0 UTDRpЪUZUYukrWA^+U	i*Em\$Ux%JF-mC`^k'A\ny7''t\$5TUT	SVJ[(xCrDk^1IKČO!4maPh	\"`\"qiY6C`.B e7S)tGR%a'7sNNA\0Me\\D03b)mZ1jy&aN4dԘFH\n4\\lJtdPRIOPrd^T@\\\r!4c_PBDР3[-J\"ĔY94!sUɚ<4,AB\nR ⠡-\0004ć~D\n\$oł\0F%`\nE*0%Ae	Ä{\$Zwr~Ɛk)0PìmET8U<EVP%[&/􍛓`RHeO\naPr+Gc;',\\g381g;JJ^1\\ф2ư@D5H/Et`\0F\nUݯJʦ%rLHe1dԵ%La*'\0 A\n\0B`Elz%2	gi!gPQ~m\r-Ж{%OS)zL(iT\0ڎ1!ℲF;.\$74³%QTtA]cUu'oE)I7oL&'zVqtrxOyI=ܲ-iF=t@Hd%ht .{)Gރ\rc&eF(ew#(Hn0&)x\"P#H\"3B^cӻm&#^o(yt3V=,7gLPg!edپk0\\lؾMd֫1cd}9f*ѓjJ>JlQ\\SMr )A`\$ xHFie8St0ӻd4&H2#멵Ȝ6i@]KmĹ>әIhܤܢ1s3\raz/#dw:='\0\$^/mLh>^MdM\n9y9=\"PPAF%\rHF-Bd\$Ѹߜ_N	#җCřgMD;|e=\$-Cf&5F=]\"]ѯmvJm0o4&Qֵ:`^S1+4%K`\ni)+ׯP7ʽm&A䗆ޔpʣ`^,bBum/XFnOi\0`Bobn\ngqGIv%F(HI&\0ǇxL4\nBƼ@μsrP0v\rt\$BՀZGj\rk\r*o^:&0`؜@O#i\rH:|*	./\"*8̵\"\n\nI\rc\rø߭mJ^2b=\")l迆<c4EP\"]|=Ε\0Po1,G<rr.6*Nì#1cP8K׀\"D`sA˴MD8a&\r`\r\\IKC\0(qq5leζrQֆ_zfIH\\\$b)tN#qr11m\$#p.!32n!1!ip3#/Zb 	\"3#7\"m|p {O(\$F\08ls%K&&O\$[8\n\".O2ҔprQ[Ҧ%DcVQC2Qa,m*A#b\$H\0x3\$o%0naHrd\"̂to0\$\0qb\nnpgl&1ͨ2,e\rV3))^7	Ə*3c.	D[\r(*\0\nq\n=ȇ!c<\"J0!atL䳐\09sZ bjL([q&p3ZiC\"ۢ \r`NQ3T7SPB7#ӈ\$1>.\"d~bq HF=&2\n4&ܯpi0,&Pt-c-b=AD,3̅6!\r\n)BICüCc)BӀ!s%Ft(SL\$ k.\n,a+f@iiJi\nLp`\\t!1\\FM@K6\rl<D\"f70J9g.WCd4ėG2Ú##Ep\$`";break;case"no":$f="%(u7I6NgHYp&p(a5&ө@tNHn&\\FSae92t2Y	'8C!X0cAn8G#<t<'\0,uCkQi3M`(n3d8Ke!7ka2`DKAxfrAcsۄ5-d20Y~I<LLbo񎘪*L@W8sU7\nprGH%2̺_L:s8\"C謠b얯zh!I(\n4CP:\r##Ҩ.be3|'1<8ѱ{<kGڶ7B2oJp!Cs6: j䤿/@\0BK*KOlH4\r㫦0 A`@QBf3ЕtD2r9p!}HC ^'aڷ!k̷2@7xAI2K@P *:؊׶/ZX4L<,+#ܹ(J2B#(wj(c|B2S3\\E\r֙&26:c:ߐX3B2U0:\\ø<@4Ck<B|4`|23 PˌvM\rb!h1&]\rSX8!@R\"\r@˖Ă\rcPBz.ͿN0/9[`kⱊTT\\~7&֗;bH;VǺ]\"YնYwSPBj*/\nC`hL9~>J2Ri\\C(qM7pf`Z4&|,=b*32.|lp!>xA4.<E\$iW%߯L((`PG\$<GBhgF]NlTI7JJ\nY)6T*R5RZ?%_f]10Κ\r80Z:\rA/Errx8ZAC>&Au&T.SyP* l6UJ<HV88NE(ȜG}MYᨘ\"(1n#D	+!adrl[\\80g=P)]38{iO(UI@sd,1&K%.(dIe#C&Ě@\$\0[3DCČj18lm(OȱF^e\"51:D\r6D Oĉ1)A5\n09D:\rE(\nՊ\r1@:b0m@%8a) {6<Úa12EQI!&2٤hB\r6P:<Bb_)].	qb@3M,(A4(:j\$c&m@W-\\gq*#Sf99i;jܸ-!3ų([\"%t)_ISj`40T\n/g#m0P2%ned'\"[0O	*\0BEmL\"Pn^閨U0bRJ21R/c	F2\"խdRAVRc/n\$BʄPqgxE,!6mO6Q8e2\nfh:(NNۂ	7Pd!x#΢,+iF<QKB6\$*|]2\rFH+O&e9)谍̎]2d[kue-ż2u.x3[a\$.IlH1h!4VsC-{ܖPC˨C3LϤy,Ґof#mN6dA*ʙ;0GJ;\r	%vAa Vp\ns\r;34C)!RbM9xȼf,a.i	-In!fr!\\J {x2s)E/dvi&ZI9 jx8t}]-Frb\r#	\$j\nOAsɌyO]Z)>l#	qWĤiKڣ<`f%С؈BzŹn/`IsV\$c=	\rEo|gRhR{욋z!P[7Jܕf(dIf<[_(8eIF1co{7Z[5\rh:R|bIN3ׯj&C'8C)^(_}Q>XgǓ7'6C΋o8B;\0o[(p)MXK0(M8`M:\r.ӣAp)o-\0N鋑>&,me:	m\$E8j)0dR,E\$N>&.M	7	RD^ea&cPpg)}\"ҐZƒl-0M	~k['0xAL\"	\0qd,[qp,,*#6pwA9pnql6sXef,;Ỉt\rF/\$;pBLqF#pQ)1QT#&6D\\#|ErC[\rlcZ0_\n{1;pPo&s1{%_q,ON11VP/62\$I\"Z )\rR8\rr=\"(\$\"rJ_-Z9&k&k'1!H!h÷!(dl\nbhO0CeI+*C)&ͣq_\r)괉rd(L{gelD`eQ-)\$-.QR	eEEa@.1jaM#N&N4`ABrđp/Pt`\n#\rd#Fr\ns6k'V^bjqUV9N*M9~85<6chvBR,œ;'\nhP)ŒCBƬr/4=\":gҋO>b>ʵ,s7\r?=æ\"P2I6>L <poL3OD+[\"p.,t\r \nf!.k@M`>&\"\r2^,ʦ'\0Х)@Ȣ\"L#.)4Fd!@";break;case"pl":$f="%(g9MƓ(l4΢劂7!fSi̢Q4k9Ma ;\rmD\"BdJs!I\n0@i9#f(@\nFC1l7AEC :'Ik0ge =M0Q\nkn!c:DCyÊI#,daL\0p١T 2fLj2BфHof+k9Cqn:Dέm}670y\rGy;¡\\b@t0.E\"D)80I{cB拎;.0Cě\n`7:2ӂ2C+H	\rK	x*Z'lP+0{Z1((ʩ#zD)pBB87C佁B\0\0ފqBD9<%,P	#!Nh荃|cK+ӟ σ(5OȽDA0YLNLm4ACXxD49Ax^;pEɱ@\\7C8^n; ^'bmz7VՍ!^0޴#)C:Kb2\r4?W{HCʸü'IJ(P(ʅ!(N\rCb6'X2;BX6G)r @P:[\"?-)(09'*l4j,MHo(#p\n:d=\\x3\r+(C{1P4CDY8:IBԶ\rrk*\nP3/DHtR9Æ]wk~Hh(P:S\0Ѵs *9 <4}V](R8\\]0-EƲ(BֈthͤjdʤCvN	#n1 P{[̖o?B'h4u{ve'\0:ϵ@³CwFd1pc9inERB#-d\rF~*D@\"a!%Di?K[QH8(6%ҡ:R3AyOd?ji#aҪ@fa4BIGSH,hn(^c,9wGQ}ExTňF@(#4I@F/q7GxCc`I E'FZ>gD@֎y)/<AQ*S¸UJUX+%hWr9+`/4:H'8LHT9/*UNbOf-:͈znDR!0@ȻpfiT&WfUj^(xn>um<2x.wBa7IdC\$S\"\n'0DEk}%n\0Sp%C8@P\$&v^AL&?%/IcDٕ,P\nvw*08_̘oDVG1EڻD:ʼ8\nB^D!MVb6ltTZ&`POJKCP-6X`\$ŲVZ4ǄnC1]%YbCj{ʍHS:6\\]\$Y/T9TR!?[RmYdo@R)a4*Zn]B5+%\rh3&&IAwE݅4B'ĵ\nwS*Y'C桐z/VFqxFl,^,&Y?:hpIx]A((Zy\rTTB\099\"&ɄGf5 0Mg!p+aCi\$	l\" Ĵ@SߝR.rN񂻆-]tH6+Ɠ`)i	\0M.1zn,cRp޼ywi?yd\\kum,.:\"SwܤQG1Pt`\r|ۺHvk\rD9g>A]+crgqb~#+o\nXk(,\".\ro*%؏M<1_󣟒%ק]mxz\ra]!AZCv-ev/F\\-;Zdk!7\"H7{ޣ~숹e5ׁ:5BCc6]K77{b3Oѩk\\fRvq_Ǵ)`\r]`FZΰ\"ZuѓÛŠ9BT!\$J,Fú>6B\r<bLʬɗ[pQ|-Idnk=O?їT\"Q#ůri|̄C]eG?6Lԯn0f<c+Ϭ\$`௸/BPp h\n1FmY-\0ˈ!\"h<!(Lc4CpJh ̕(vE#Ȃ\nK\n0PHoMvC'Fc&b3\nA9MdXog0&\"n ֨-,\rK\r\"\\%d\$`P4J\$]^يNB^ͤ(+n1ϳ3Bs\\(%]Hq&4fp&\n:Ji#C~.`f^r'CzM4ҭg䀯Ql䀒oe@D@,`d@\r\$oa>WkNj@ '%1R\$萲XY Q = v\"aPo}!qK!Q#.m#Q >\n\rx5,!q'%،;\"Hy\r&#Rn/OO2fyrr(u)Q'cl`2E#(3rVؒ+-0#r0\$C2*5NZ\$ҭ/KFɫB#*GG\n82T&\"6\rh)D'I\nK/صcB(ŀ@0,B6C!XE,)ʄR:n4/3Ң\n\r+(\"_.~_E.1#,(S9m\$r u_{++!b3,Mw!dG\"=,=! Js<s}?=OHnbc8mZ!<<3qJ0EY(&<ӣ&R*S 9(TKS/>@y攙v4ADeO۔dz4u;GF:EFNxd\rg5tV@H)z^ӫ.sI8'Nlu\niIGvzndq%T#,1M>?FNt!D4\"cE!Fs-TވRUK=/RrQCyL*\".H%L-c=GMG\"2OV'McD03\"[VO7\$QcT`qd}E4H<S2de3CYF(_@~E5\0,g*\n[\\0d3c3t|5 r<u&4\"8^G Ҵ`'_2f	+K@n\",B&j:\":Ø'&140-!\nZI`\$L{He/.\" ͱkYf2r4Dvsfv!ֵ!3T^zV*|5pHHIv9b,2C#ƃ<:Z#`@J,.dP2>\n\rB\r!b̈6G=r+#j3qVn h6)rQJ71r7\087/q:9S78&o\rvTj\$1ccdBfwn%>e\rGbGH/c-	B|+4+VFT%t|-&-Kpx2dtSdDS6gFJ6%sf:oLw+zH<b6";break;case"pt":$f="%(Q5Ho9jӱ 2Ɠ	A\n3Lf)oihXj\n2H\$RI4* R4K',t2D\0d3\rFqTiC,i؎hQi6OFTe6\"PFi7Mj\\bP&()&̆	:\n\$w624OJK&aaG,lٮ2؎ӁP\rNO)#ckG_\rysl5=,9u;8=:IE= \n\"M'67P95x7#N9%\"#ɲ*7-̰;\"R(0\0E#Fj1ʃDaʂ(@5&mCTڿ\"\0T\$;)0Bx)<C+2+Lˆ,\0\npk6-:\nhnMq|7\"+'j.Nѥ2?cr0L69ð60k\"/Q\$1M>(DHX֌D49Ax^;؁rJs3_W5J|30j퇁x%3~1.۱B ʟD#z:+4\$NÂw2ͳ6p;!R^B::\n\0<\0N)c7KK@7mnN\n\0&kx-(:2R#dO\$qRcNN1ތ\r.6\r'(>e\nKbmUZZR<aZ@؋\r2\\&L{`=@r\$<8:!J/GSO);݀V4c\$Zě#.>U#(H6<y+@#;+%ONJ\rn\$!\0Cu֎/Pp<7Sa<k[PRsE-17GMFt\"Rژ!gٛR:xfK_4dD@LIpyF:3<\rpÚ%f|aPa?6KpeX^cJr'8(%F%GrRk 9+6nhBV\\+xXc)CVZ\r>?	\r9MfR,sʛfID+EkQ2Vѕ]~VXG;kQk<po{Oy1*	hkBʬB\\IHA,P5EKQŽxw\nd,ZÔWHT0i%1\"*rI!%YCGd 4\$PNOĽb=*\n (!Ǔ?\0(( xDfÙ,T6c;䛳z\\S)Q%'ܹQ̸h<IQ꼾rnI9*Y#{^Mi;٣] FPRP1;n:dtm()ޛб2&~D%JUefH.\"x38\$0mhCDsXkZ)訓)*zmq9Qu<)EM]Ilr3Y,\\ԹɁ%*S6u;AZ`@T/CpR\0AX\0F\n%fP9T M뼗ZAY{lP*[ E	T!dlGFH-6\\L/pi0ʹSGdԛk܈Ry|KbHxKIp\0djJ\\b%?2灧a䴒@r\$oI!Z2*j^' (+\$i:g'1St&6RT;pܛ,_)Q9R	Y\rX\$DAN+DL\rN2jACe\$:=gIV)9&xif*F(w͆hTdޙ\n+Y0m\$Ly̰<DRԆԔBZٮH4LvB_eZ k 2yIk%[Rԇ\"ޅ=:tRr}o+t㳌]XO*5:`@BH\rh¡/d0tTBMS(1^T5'\r1^dl7Yi0B!U15̅Mp	<!6|n`H4/:;Zn/H=2 ʏ5LL>ct,L߷.Cy.ͨN,g`Γh[*lGf+|iGL\nHQNfҐ=|#2'~<k-aujQN.\r\$\$s<TaY&>ɭ/`?YtG{\r'&Wļ{&DSoiQg͆(!xKdN0Olf!I&<`f5\n\rC/֥ΰ\n',JK\rQd 4@>KOc픎~PLʰv2L/?)]t/fɐ:ot^\"Ϩ\r\\u0\nP/\n%>n~8΂O%P\r5wNbpkb\"<0{7-Ⱦ<			/&DFQRA*)V=.&%f,1LF#	/Nd.Q:;nfp/2]gMܱ&uA' F\nfO_/Ḭ#2Cxa\n&1xgr!QʊMsj. zV\"fX]Q@	^vwR\$v_P23r7Pcic'#q%^#RN{P0\$wR-x|x	O((\$<4r)RfB'o2DҩKKM#lF(#\"\0D2,R|{-`..\"䍻/b<\$mc޲M#ң=1RT#1İ33߈> @drSJ.(E3#\nVOG/0@2K`;߉\\vcrX\rӉ&8S\"fcd\$1ol36m\rF4P\r> kF\r&D2 [\"'dRG{62|\0Zdf6b\"ROoNBD1~,((Q/oq&b56-,9/X1H#f*[-MD.ufatglc!~aFFe43 ,T%Nc,\0,M0+D\rT+KĞ2Lo7#->K-(\n:M)\$iKL<nX\$z^<m@5jb0ۣ6BK.2dG6ƃ-c	Z3,|~`D/0۱6AmK\0001q0RI";break;case"pt-br":$f="%(Q5Ho9jӱ 2Ɠ	A\nN\\\n*MqmaOl( 9Hm4\r3x\\4Js!I3@nB3'h5\rAscIEGSbr4EcyUz0Fa6A1a1E'99A&rBrr2㪧(o:\r>yx6&[Ap2jF.bIylǌCyn:cn\ncn6\n\"E]A'>7`P9\"5x7#h9\$#3nn7â:x\r;\"N(1\0E+:kK6*!Z\n:'a\0ԘmjNCj|?֗C>()P#IXL)6PЦ`P\n0+&`A~#* \0ܟ-#|1K:CC¢/@0O(:\n\\:ҨtEC XD49Ax^;ׁtE's3_5@J8|`31Zx:OƼ<Bj <N#Rm6*0ݗpx'6!(0ާK\r\n7(J28^P7²JF135\$\0Cc:[B#cFO@ӟh(wkB2	6/'(Bd#\nfbhJVڬ<8>~b/O8H Ɩc)\"`=T47Nm,\\zt!g'hSPAӵɣH؆1@7p/uN#l<B(۴<8S!w<1g.Bj\rUs`:]bYMli?9ؽ4hL3΃bw׊^ۛ:vxfsi@o%<4]Ta>PT0pcQJ2\nNa\"g%6aL\$PݠrеtSJ!`%Vˍ!CQ+dWJ;PXuµ\"xgзH*aӧpª*EzpZIdX6U2DR6LtNVj[vUXXAb,gF_Y9ڇCy0ÌCk;e5wRmNXҎAj77aZ8n \$fC4\nb\r>t\r0Da\$2#sT't'`Q\"R\0ۼ9%pRâ@3̇(E;QsMJppaܴ r\nK\$N\"Y\n-ؘtJ&\"9U7pT0sC(ZLvۚ.aU FZTPbL<D*f&Bo҅D↝0&DTYi@(ICg')EdaVm aH!4UQQ0q,MڃG9xxS\nvPgI@ u1|˶2\\G5wkn=2IYN|6אL#CA;I~x	B80T;e({fV9T ō-hAYsn'@BD!P\";(LMizXN	yÅ:0F`d\\ÃD\nϭGxd̚UdyMX&y9'G4˅#|9\\狂\r*np#q\n&7q	\"\0WCIX1BEMc<+B8:G)&AS.T2s|p1De1fi1d)39 ػ `ȡ}\r@ߚ̘%:9F<vF(w/f)(0\0#m iS'uT|.^R|xNە] 2CkQIIAȂ,xgfmPP'͍BϤ3Ij_h6ۿՐpC	\01vmܠmu^	9č6Erm29Y8I_ 6<chp	|\\4]{ٗ	C9bxGy?#DxA'WeRz>둸2y{	\\>4m|ȝvpwo\\~'r1!CFc:<)yr<(b}繟@R%=@t6Pi\\6>r(A!1˳y4NQ\"?D`h7p&j'UO10h1=ſ#51k놓A1\$#8x,Bj8Pʆ6D F?h1Lm1bF*잢;-\0/P1*	C%O_.c`*fT@c2\rHN<(Plp^,z	*#`A\$Ѝ	pPаpc \$r<0pprb\$xϤ5Nu#(C.6Ϣ01q@@Ί-'7I	2/hڈ	eIpkqB.c>12=b*N*0cbj0\"\rVC*d`!a[\"0Oii2\\1q*KYOV|#'^(H\"YbYq>­;I\nX5P0?\r '0<_m[d	\"E\n Pv22P%t<R<d,r*\"o\0\"l,@&,!LnLQ+!g' 0Ʊ#8*Bׇ!ƐK\"i#2RR2<L/@'fRsG1uTu˟(,(r.uAr.9(]r2u#K08r!2.)o-3:\rctFc3p\r:83>-BzS4Ϳ3w5@fdM*B<3;1Q\r\n{)##8Grs+0sB|p*%\\cNm/MJ7;/1P#<9p	6\r'6|Hq:);*PbRO^%>\"#1^f@bD0'PjP&yfl\rQ?\$lH0q*\n>@k \r& E!R<c@\$bn'2\nq\\3\nE)Bԇt5^!\"\$.4%9\r \$3P4 w\0(O\r@\\\$Sk\$qEbNOˊZ<t>&%\0IE&R8ʴvϠCcF4ni)U\"	Icj}8Bk6H\r.)'?u2I3{5b>(\rLu82Ռ&BNp)gRL=\0`՛Mtf*D&|!FaL/ i\$`juvCBˢP%	MQ8U.4%Ĕ޶;G:&.PIu@\$@oIK@ ";break;case"ro":$f="%(uM0r1DcK!2i2a	!;HE4v?!\ra2M'1\0@%9dtˤ!eұ`(`1ƃQp9\r0ӑ@dC&It7AE3ed&3IrE#Ui7M8 1my1&A.e6edS!&㜄˨A<F&s1d&Yd4e4|2vLa@u8eDxNמob3.:r͝l؍oüp99`P2 P\"5xǤ#╈{<08BCh88DX7z˪4ұڋ.Є\n\r+2)IH'cƴ\rC\nV:&k)0p8ʰl!BM\"87(.r6iBBOBԶ-ˀ\nh0B%TMH7L8\$)2H	E\r3JDآk#0d[C XD49Ax^;ہrpT\\}Pŕ͐2\rLˊg0=^0@2ͯ\rU5OM(&*8>6\$`V\r8@T=7*[0ߵ\"71:\n\0߀Na`1!ƃx75+ϙ4MO{R\"66):21L3ᝢuD¬й[z>\rĀIM.:l׹2F:\$pؒbR#qb:<[cbN,^c/p4Pt>	mH&l\$2[7;lNf3ʍ{*SFWiHܼvMHZ` iX\"4؄ZP	u(00CÑg\$9&+Y8_8	\$\0S\$\$)#*z+Ae7oBfA3NJIx#*󊩃515pFeUp\n)(hRC)	V	\n< Ś{UZKQk-Uqxd=4L\n\rFLMi|.%^\0KzCA0x\0003@Jj @u#)@-	V[kuoĹ\$z	>h5	~Xl0ּZgJ&XeN 3Gqe6BdX.<*2C1!]HQ|QTy`@u'\n\$\0bH_BAH18T|1f8\$OSX( 14@ܩ9t4 {Hb*_)0(	]Eh6RIDB4LCIhSEn!cu\\2/Rфi+aL)c9L(40ӲoN%eE\$&dԅ\$\rg4XӒaː\\CdIf~YK17NCO\$m\r3hc\\(5TgMBf|&T,BfYj8TYc%[IǸ.ķHaGmP+))	R5\$Ȕ&v4-)q\$\n#KŌ&L\$'-BNig%|b&8!zq8PxbĹY4ABnTLZ\nP:	Rbl17eI%#+;uJeֻw垔o1מVhx6B!i,.(\"Ptd1	-kCU ?&(MQ#pȁ63M\0SxaGn<˃.YLQm 2tn.ͿZ157Y4qli1wL;Ctتϳ\$fk 8;]{fҝW@s|do'R%Lpuq![ښEDT!\$94H+MgjUɯ\rl'6و/`ZL͙o-5J\0me~Mq2u=0\\{1!O		;3?).nILiĭnKwѱw=d 518yRrYf1q!Z[?ۈ\\7IbM3R|u{璞)B+]u&QB}@6`Q3/XHip̍Y6΂dt(*o1`D#o֢c\0@BܣA o\n'M#n #F%DhmF:/Cjd480RgZ{eVppZ&eHK\$M*H&22<LJސbA0,Pxb5bpe(,@b|=R.M\"DbVm00cj;ogpwiа>͞vSŰ(AH4#12.4(aN.1\$pڠOdcv13p爫ɦ\$&>LAqIqgO\n)/c?@A,o<=:pue7`F<g.*ı4\0q!.\n608Cp\rL\0Pmm&1sNTrY1`cVp/ccq&D|P|\$\$4g̛D')A\"'T0Tgb>*~,+#1b@`;cfeDmgFjz*]0Qc01ǫMх/~#`z(30w-\r2ƃHblǵ	g/ |S)PR`VsZqI1W6gUY5ZO17j\"3sU779,SE54Gp\$Bo2m99F#; l)\0D\n\nUHF1<Â'?=CM<<k*Av,\"d:@ƒKAt'l̗D4\nƓ92P}r,@@|Q4DDE1K8PUEE1%`DhR\nJ6&2M}\$\\\rJf>(,ITHFf4FN;F:\$`,4UQA#EA]Jcxgd\rVf3?/8gT8'uHڀB3\0\npGbK>f+V27So=S4JD!B! idGnd^1msC4\0,#cI`+F j`@{Q':dR>'ZRN`\$d&bV1U-+#\na5\\ЭMuM]M]\"*?]k\\M%^hD'8s1A[=K	&&\n.@irbsb#TF~L4M\r`.dXqodq.M0@c㼂F\\#Q]&b	ꊜ'RJlM}x\r:um,ޓH#, 	\0t	@\n`";break;case"ru":$f="%)h-D\rAhX4mEFxAf@C#mE#i{a2fAZH^GWqh.ahhh)-IhyL%0q )̅9h(HRDLD)Cf4Ըh/	4&Y9ڡLQc4.CZJ4B~_wȎ'%CZ|F{|3Se1gb3i,pq<(]HMv;f_r7:)NѠ\$\n(߾/ӬR*B{\$ݳHm@|\rBPbz4\\=nˈfDqd\nERc:ӦnWjt) 4Ѳ*D't-\n\">#z(طrD>E/*lL'̬:)is#h[M/0:,,,AHhZ/Ld\$AOKJ3\$g\nG<71[6\$:@.#/I҃b-hhUR|\"m:LVR\"Pcؾ4\nO͍3<h_A1=-;uj0ŒcTH܊ h7oHz9'F~Msw7ż<\\xX@4C(C@:tt8.x3(9K(}Ob2TC'x!2h]8Bmv\\#o,_'!r.#SEXZb<?ՠJ2cKL\ntA/\r?3r~_ؠnh(1 ʂe1M%fkhW\$J_F)(@{UR\$Iz{2ɡߣf}\r*\r\"F(Ֆ*kuH)&A;㥳g{\"\n(84%F\n&WϹX@MpL\",A|'EB|Ъ Xq)(g!q\nX{%dx:3v*漑t8E«*)A,A2\\<hE[#nMQ*l (a\n؂I̋O\rrCh%(zz()b+d	2AIBFsQ++A^eYXZpY%M\n2px\$)9ͩ^G\035KBOG=D@]e?8ɼwKjE+9'Gǔ+rJ-Q`DԜ/r	\">8]?ҷ\n_x=6T+蜛ђ屌4,q~,*cY.sy\$DJِ'XAZ`R#Dբɱ\n4*5z34RPB\\=/uPHL\$MU9*ܐcaQRMuBU2eUI,%`'wD0(xN*_Qr+*k<jD?Y\\{0Q2{GY.If)C>hRk/f,͚vrh\r	4`^xn!4݂Yb#	4uADb2x6*U'6Wyi9Кr\0XNzG\$;/w62`̙6g;}gCh2уhFf\rh!!?P7:z_͌մIe23%*#9W%P\$h\n[dP5EVAԵ\riI(F^-'O2aKf,Tu,޹{b&0^+!w+|6pJ3&A=H8u&b#od,MY{GxD&v9l':U  CjV#8^J4OpVrE~q3ԑ|/JMsП[\rcW4u9\r2q:bFuv-\$x]YgbxhֲYf\rJaL)`[RkOkZɦa#EA	&{XOzs;9ړ7T6ՍʚxzFe[_vy\r*OarpbbnKi5f;	NJ:[rcV*vƚW@\n)O\naR\\Z`v(f\n%ENum#ڏD_c> V*䭢ڤ9{t2b\0<lTG<[)5*F|/l,'8\nsPEўGIsSt=	mHG/3Hs%Tϣ#AF,+ܮ5h_qxG/I^?ÿ4g\"N)AoDڨ,b\nL\0H\$AJIlpP,cL#Q\nP\0AI&Jƥč/pmH\$ZL^z4KI=	\0lH,WfD9i@r .h@O-C\$p+GP#f/(Pz\":}DS¾\"'ަH\\`e \r\04\rhGzk7dtU22JCCq0φV'0EN\$vPf\0	 \r\r @\r%8(\\b;0\\&ZLڈo-XmXEN,P[	IN_DtO)Z-'v-wVG	RV-LQP@@\"+g \"p,0'RxI<*T--ϘD \n`nhtdah؛N	fAj GJtm`u\"m&g\r#A*zQ.j`\0nzR~҂()HcR2r#>\$m'D%*(̠roN)-bjvchc8:'2*iɒRE4Ojm/&C蟳-[1m%R\\S䄍s\nƮ>ɩtp<;nb\r*B<#b%,h1F\r5p5G%d)\":c_P+,5A)d9Sn[D/6e2(F@JK:j[8~ʨ\"U;q0JHL)ʀ\"jKLLOOy^	HD!0Tb.3..#,3Ap>C\r8L%)F4qH#Y,B4GDC5--d@8.P!gDOK&Qf1\"\\ovzN K\\A\r1FB5,+LQgH/d!eʖedI);e1#tg)EFfQ42`\rhQP\r\\`\r\r vFϓHdQ\0PB]GtS\0/DU8McG\$p<TSU*G1 gT)(ECʥtUBk6_뤌&-tsCRf]qHTPFN\"O1T&W3u#]3[-,quR<oTX2]Q1^S^'^-O8X3^L3\"S42v.ǩc'+Cb^V9U4{m,dTC~QGF\\R Ud7_ʲ\$C/<Gԭf(NJdH2Pk//<\\p5BSAEe3eK]iN:\"G3Q	-'C*5i_/Appq4Wb/pr/q6f]|ƋP3r)sOBHrv?B>͹sw'N)qv/]sV-on5mwu|7M)2jbמ\"'7!nG,scCTY|\$|fGUvZ	\\5>7̥umGՓ{ȡoG|V5Օ規|\$xD۸\r\\X6/mn XXi\nװNdW)Ya5B!\$'8BmGY%3~CD8fkm2!*%2nsehxWr7Awz.>bXGi&x~q8sTE}CIQk%DW}d1SCAe[-4mђ6e)әGw:7׉HA2&[9M!jvHm}-ϒX(vVqMe5׹vewx^-K0\nWr|V5H`i,n*2-a,y\"lW-`]շUPH:bvAѣBڢG?Ar\ryֲ_R)[lo7+(</EZ;A:|4pi\rVSE}(霆*\$tlJH4,jxu/v{3\0\n֓d[doQ39,JnO?iP'JXÝSp%QAyN{eyzIͯzyt+ȢNlvFGr.Z+pCst\r_*udzYuǺ9	gt6Ega\$T4V,7ic oDw?q=G_P+waOTʞ؞˹[ԙ|ӗŻE\n2E`(øwIr.<;iE8GE|.*QT	N:*sVdG˚y,>k5X0>!y؂4gwE\rQ?Mp%?\0Q]n0nsZSup%Yhbmgl`Xۦ:*<\rKjzm#M Y@";break;case"sk":$f="%(](!@n2\rC	l7&P\rl25q\$\"r:\rFQ\0B0y%990cAn8U\rZv0&㙭'(a7&*i3fRSzi0\"	75d%Stiы&aKqqlNFBN26+(;D\rƚ\$@a5Ԍ&IPc4mFd2V,=7gy:Fð0掇IKss\"?vP٬Ff&fs0F\r2%?#:̵)BC\"\$(a\02hB(I6(95Ar7nh5)xҨc*Bb4BB!C*>c(!0I@ ͣ2#x2\"<+xڃEi\nx,BԛBD@P1BH4bP9o*KE2%Pih# Ep'\r!^Vd\",C,c`@!3:xaM6Ar3h^8IxD̸1̅N|˜<\$C|o:(BLmy?#X~R\$4&J&h5\"*-\0ĽN1c=n#!t8B\\Ę0:\0MNi8g\"\\0p&7\r<8]lȌ:[+#>z3D	M\rc ʜx̭IҤ8KbL4TbƥDhЉ*`51s bQK6 =/â\\3#̿x-\nP#DVtx9%Hہ}T½'cKPQ,wC*¢4BH\r(@o0\"H7lUIfc\rRn76:<ܗ2CZ[1r_F\$!hkI)QMb%G3fQ 0(VKlL\$!<2(Us!f75AI(u,Um!D3cP\\aȭb+\"R0JDx[L.\$f'CgJ,9f\"5J0E\"%Ȝ#tRc+Hg\rT6B	U\nFN1.nr\"I̲v+\$EaY+D<UºW`,%Yk45HiX) eh1zKQID\n!*|\raVQH0EA;<!R{!ϖklV]~VwXj\\s@ܵ~)2+#U\"dUsQ~TAAAf[Ao:oTfHKe\" /TD4NN\"M\r&y)p\$TΚ\"Pb^Xd&%\nQ\"Eu\"eɀgs:,*%NDg=.=5:VRBQcͤdq\\\\\$в*hy0I2]#Xk& !04:\$E!\"_%^HIA*H&H*vaŚ|/WD2BDA7 F#s.G@o\" 2!i*6Ũf]'\0¢]~YPP=^ьSI((\0xo+ml|zA	k-uƸIv_&CjF=LA\$QH\"m![W\$Y7!W#bl%:VPf܇SvoZnSB*,83BZv.\0E	\r\"B2L9 I{K\"{SCP(KY;4KdS	tN<(0g;4шG TbFYU\n\r΁n`,2Yq{\\2 ,̄ygvP>yfS+g5SQoFv5NRFZ!mgAV/dJbк dD3h:,8\"`<oVi,3Iyuu\\>0U7WsY'nEgrDܙʔe{=DZa}i(@BH!L9*,5h<L|f>i%kdu2Mg	}.NJ*=<4[LLwS7Ίv}얺d?V>>.)Bx=N\nBQ_4V3`m;UxИ 6`AdZc~8%j]\0R\0@fkS`Jd#'_fvfzI46\rxx6*l\$E)L}#l&PR\n`cI2\"^%\"x\r/LA\n.Gjd]+ty22,=`>'\$%o/О`?0dGM\"Tάl0a=+qB^!tLyB\nOQ2 >R{Q,.;9@!-Ӧ\\plb.Nᎌ(\nBlHv@a.mg.cZh.)@i``\r@Mg\0\0- L&mp֤/1&JOs\"bqM0= Eoje |q6|%\"!q<kHʎ&_R /R>0ed8׫ٯ#<1#%%k*Ȣe\$k\$Q%0'J'L\"1(᫹)W*,뒩%R8Ҵe+*,r?N\ra!Ʀ&mJ^+'%l&d%f3.a|a\rem'֯f'Ā)˺0N=\0?.2D|*,\$*,鮟1#ċRb,e\\&d,!{ne*8S{-\r-Sg\\Nd,G*{7s!Q#;\"Q=\rC=l<C2sy81@fd\\	b<ܮN/PFnA(nBxr:%\$g\$#&r!-3<'j`t:x=DDDE&f\0#My#\"+<\ng&4w</G4R7B%H'ERJ&^TUGY\0/80If{bfy:DEIq;<CH=CN'NN88Qu\0S;NQ9DndW9m5MI>C>N/ATTB*uBNW%T-h\r<3>h_\$hctF3@>dG@*_@⍞p!(\r@yYM)b#.3&>J'\$\n9lo##`w\rLc\r 6cX6'%d7\"ÄJYLSQ2*2c;i~劔\nZ%%\rp[dE'T6FEK)R{e3j`BS(\"Ҟ3F3H66.<S{%cL.H*O3ci#\\;]=6)'4&.\ns6\$ΚpZ:?T.kbOy62<\rq<qrsƘ?3KQKq'#]	W+o\"=7.elԞg`#J'mWf'33Q3M&6D@St4\rO;c>\"V\rWk>]'{plp-J&MNjnԍL3&erjkrc3 R`ܴBbD >";break;case"sl":$f="%(eM#)@n0\rUi'Cyk2QF\"	1k7Αv?5B25fA2dB\0Pb2ar\n*!fPsSYPaPI6Au)DU,jANS#IDY7Do8cae9#5i:\r:s;\")W6g^]Ѱu5ZHd96[MɺYV|\n\$Ye=KU78r9BѺ2yJ&c9Xȑ\n4cH+2:V70@hjT< R~:stCK9+P\"2h:IDz)hH5jں,2RG#JT ٍH332h2\r\r?o[i1m7VӾ@;C#?-P\n9pxC(C@:tL79X|90^'a926cH7x\$N\nNBޡ\"3c 7Z\n/v\\)3pȃ\r:HP\"\n#H:7A}\rMm|cNwjΎ\r1B8B\\\n5,+I2P2˂sSC6&y(:˖Uë12CP\ri%<4̀T\rC~F	b-xj\n8>j6\r\\c(N(ȶC%ܷ=[\"s#n\nJ G!]=KK@)88,K:>\rܦ3Ȫ;\rF(+\"\\e\r.f#dRG3c͋c]v̺gCuE^XA\n{}ǽ<7Av<e Gj(3%\"D'?yX<GT̬\"rHUPu#9f9+wL8D4*9ES=81aj2d1M>UT;*\\p/?\$@5nZPM@NKQ6\raLP`oAhc֚S{#Ĉ&b=UR|<S☇qO*D0wU	\"Ջ|\$Chp3:=7J4P0rO|c!!JϼXWn8#E(`Nrl02!7HUl8(Rhs)3I}h3PN(QZȸhCS&8 0!\r-δMpY̟^OJH9-L̹2C-y5j %sf\r\r)hw5Au'PΧ!H_S<#04xZE! A0Z;	f(\$dDVH\$NoĽ!܊!ITakNI aȑnHnC&f>\$:ZBsQUР#?.&fvJxTj[Xeg!Cml-~tR\$o(P&TzB1+Rx2\r4\"L#lߴ0vc&K,46&9qm08655BiJNX5n8y27:nA.4^_267Rar&3Y_vו18GÏoi2S~[ẢeZ.\n\nǼbv޲s}'Z0L@'`('2L@PZ<ݓBgK;K6H#ˬ-P`o72A[IB؎l*eSsX#ɆʮYE\$784!];Vn\rg:F4j[p_[\r7!jt߯XJw\rZlJzoK!%V.btvTr֚hەYJr\nP 0+?oּ(y#@EEjIf_/cS]p/We\"#-v՘\r7E\riJ+KQXat\$1\n;5DpXo]Eqᇐ'>_GPnmȱ9\\ FmϲE!77](R#Gta{p8s>N?CwauY%ދ3UNtjDv	4DD}niIOp1q`?U(*XHiHGIݐDҙy`L;yM̴ L\rΝ0Aʴ3)O͓%i1]A/f\n0w\nNV<L@-\"/m|OrwGVGj+lĻi`Xl3g -#KE.E6`c\\'+p\"Lz+pn/|K0#(D\\r&9N@%9'e}\0\$cjXoX@P.>5\rOr[Ķ :ܰB\$Pȱ	)ge\rp#c`qE0>Q6'1\02\\%9Ȱ<\0'.#.USB.oO\021Ya^b1J{\no %|\rd%s#|a3np\nԢ#p&Fa!\"7)0#)7ȏ\0D\"6p:Cv\r)g	7B)U Vj @2\\6ֱ%cZMVm!]QQZMC0 @sGTu'+\"?ry}E&)\rr(6\r>Ҝ#(*l&F(&*XfP\"é;\"P\rc\$\r-'p*+}*&/(2G\0l\rfpj2[0yҺf2+,O3 &s@s)Rl4\$(*LssR#s\\s-(5lb0/%)ySW+#E32B֭|2c엉gza9*(4%\"ӯ9Ӵ:emJorC\$QB_/8>8q0d<SqE=>ҎC+-?(>D>B.1&3Bt8/L&6ZS2J\"rb=.ɐh-o\n>))HAwH@]E冻-T\nr@C_F3/H@Q\$WG5HmLL%ޓ֤\rVsr,z&<BD~w'vYj@\nZ6Pt'L1mNSTFD('SѣSQ!;eG0\r \0g3PJʨl0\$<!		YD1D+pWc>U*:mlE/6LM0*3\rdسC]uP\\6/&u]Oc:4#(2Ӷ9z\"r^J@],hO|95lѰPk%PKK\$Fc_PMB:D\$\$:)`OF,v,/pi-c,\$>LXߦx@otR,J@0\rC4hpn\$";break;case"sr":$f="%)h.i4	|Ez\\4S֊\rh/PHPnv0G h\r\n)EȄ:%9>/M}H`(`1ƃQp9C\nD?!G: 'a%e|׺ZΗB1,h,ep܎x 6k贘Ks=&a;Dxr4&)s9St\rbV<LAtt}?7\$!ū=ޑ?\$7	\$ɢm\nn@73\\ԲA0򯯉\npp@2C9%##2\r7#8GrH cv2+d.68E+\"BAzE<EC썦¶-ƨ\"#zҐ+dBj{^AB61DL0B19ChuQ\nB<6;nNW.\$6jɲu,hJh4mBxW1?Q*U6hQNeHB6qA\"Hd9rh@0c9c=oKI#(JC4C(C@:t\$6ݻGc8^2|92^+P7^0jv)[;*UE90˽mC\0\$0TziQh3S|\$H0Cuڂ\"\">ɹ[J}n#.6bS\"`6I#6,=Dr?FBG 技@Pz0b\"\"}?&ͬF|2н9iVF[_u5H4߭YEKuUB*-JcWꋀ\0R=Ԙ\$2t(ڵaH\r!}B`AAxՅAP%+\\(A3hOB\$+ǔUSWX\rCw\$3BZhDD\rs:6E`Kd:VҹѳhA<&hKs\r`0eE7C=<H\0@Ѹn*.HC\r˱Hr_K\0\nsEd8fn<Dj\nA\0uat\0l\r\r6\0!0n0RV(%F{*O.\nVCmLp\r!o0#X;	al5&g3Li\"/cO\\#[茡ndiuG(,E`\$'	*&8!_<\0R`s0ØQpcBIIJBHmP65M^EJNG%W\"JTbBE!2\"Td>m(06@PpG~:J[u/<Gf@SA\0c84,\rƁd,lLLJJ!(SdN`R&'-3zKn:sΉ:\$H澆u\n0(ɭMt/n.k2O]@?&R_l~xh݅WeCHW^D,S\nA&P\\DVY|O(QcVrH[	0Ra05(-+faݱ\")X %ny7\0@̞F9U`\0@mo_dlBi'lN\n*X0V'0kaCC\"-#\"}xz3.Fԛ7,ʔQT\rHeuFQK(\03QܗLUw(H%!_9X9x|ƯLbx z@c0O	*\0BEhehK1(`\n@V\"wJܥ-DAFC!{x,,,n,-DcTHŽf;i@ۘ8ZQ%V֦3ţ5^6i\nQvYY:L\rBkKvd'fp͖9x-\nD.~B	W9YW\r>:G&ҥkCMiI& *.nBh:l79_Q\"AF(k8ǒLz+O+DK{(J\0PS\r!GJ2SR]H	C,vh2DT&4ΎB}YIqeV<8-jl\$t.\rё#Xi~w\r>qc@S3Ao4wze٢Lj` `0\ro(MyM>0O\0%FXd<V.\$P~rT-6hd\n`m\\D<zd#fA\nx&\$f%~6ªBʚV(&\0nZD( \\(lZ2ɤ&PP\0p܏k*,kp@lz*;PRQqOB߫ê,H8])ɧqq+0\rQycU1]qJDc	|\$t!K+,%Jx^mI\">xz#bV%Nc{D%ZY*MB#Ab%XE~}\r1vb(Kux-'Ph/ho LC	v0`T*򂒓\nlVD&(?f𯌋S~g{'\$ @=R6Nh~2Zj)+/<J/()+rƉ'#H5(ͬ!(5y\\R\\0Ңt	\0003O϶\"/0A\$clv\$\"0O,6\"pclE\rGe\rȎ@\r& AG?GFQ+j\rtŉu(RfӔ賛)>Sc*3κӜ}NX3N,o-+hSr;>(F+3;M5o*0p?\r;q\$?Q;Xŋ 0!\$gt+rCYAT\0007d{1D=CD1)*Gy/v͝>o`BG?0G=SHtw\0B-&,bJV8n1x\nk5`\$4,G磻n<?/6* YAg+\\&yB<\"2*0OTG MRY?'nlg榭\"4}=ԃ0J7}:4T}LRDBV(?9(l|cTU5{X>J+?#~\$PhOXa&n\"Mc\"pk_W1\01&jcA/U@^=Au/45A<i?cT|N7&!T܂0u|.33GaXu2D66V(Pi#2#,ƴ<p\nXwIcNZffT5VZ\n-5SfsU6_VrV1p6.zLS\08Ă8[P\0;l>l\rvl%s605UMP7YT)w	Z6JV\$3quVp'Wr3Q5[\noǐ\"#w\nU/Pqu-gqo(ajSrAV҆[8ŮD3E(r1Fd,\$ng+H0yh4FAנzmbEcLG_\n#\\Ɠ|0mg|PEqEFO8D{P~1FǢ[\0\rVL4\"V1ҡ%ֈ\0l\nZ	,CgMd/p4?FXXFkDQE0\"	`A&C& *\\(.3\rZ+*r0%k(q/4W\"}e~%+Rk׮S-Q\r,MȊɨ&cOIW6\nE-RB+i93S\"v&o-gPuju^G{x%.5/ŞJo/kbtS|^ǰ]5Hpr1dYA1@]\0Ɋ'#2\$4Z|#@sc)zxQ\\=tI99E6<J0\rtUMgo*i";break;case"sv":$f="%(e:5)@i7	 6ELp&)\\\n\$0s8t!CtrZo9I\rb%9iC7,X\nFC1l7ADqzn\na!CzkSI a6&<b2\$)9Hdٌ7q}_D(ND0Hr4k4U0!1n%(Ɖ:]Id3o\r3Dpt9uQNY!)g*G\\~~kk@Q<_9}MsKeFCV #	S7'\"N++c7\"QH\n0;(\r䚄\nܤl8Bp62n&`:JHj:E.P=87ű)h6K4.ͦh	K.1 \n0J 6Ls:j Ҧf)bc`F#5ϲA	mp@#C3tD\"'8^9(^(>1Ô֘\rpx!SbB95δ\rn6R<+K6<@M]h\n%\n zEm rCSemdrR\rs%62JÓed؃P#u4ױp3r^KbT%R6Hb\\OC.BxP|/aBZ|chN&\\5zK#-%Q#1;8{`ѷL4PsC@\$\")Ps)\\/ 	#hᗺ\"(ǬY/\"N-Х\r[I5hpj(92`j!שi}Hݎ)\n(r9%#8!S-7R:'\0VX	|4SdʎPxN\rbNx<z{dtfabvmC]S(0\\B3~\"_\"i8`\0C1 đnPfXj!Qg/`9ebiB\nupP JHXɲ6ҚaM)<wT	SERp/f].݆U^a![V\"\"	3 I@u2GE ĈDQ3j:;C%%\"TSaNB+}V3\$RcV48DZSzE\$/`~!FHʮa7fÒ	p4M'\0p^\$\rSdQXBz#d:_\\(AgC.גrڈK'ȑ&lHP	@!H`s[B\n\n\0)|Fؘb	'+A\nҌ4a?(Kt/?Ny\nR\$	8O.̰P#vi!!((2z<LbF\\KOA\"rH٥DT\0F`@K#ҡgVC,%DBBEɕ&CR2OSiƂ)\$1%K)\ru\rMȥ/ȠȂ)~yF6O\naP{ ӥ	[khi9m!҈[gi\"ϰ͢nCS6Tb8PFGY9rHlIMf9!0\$djz2s\n\$\"\0D!P\" :ɾ!A:轑a^;	 ɒ!.^\n.b\\emEǅxJK*e>1!9Yv9Ա,:걱rᅸp\n;\$͆`b0 &G\0t,'Sbbc#ݠA/pFH_kԌ@EܜX;	1k6hxd2^RRR@Sw9Ĕ9ސ1U!-ݹNMM/.ey[1d3{6Aᰶ2# (&Ųًؖĵ^{zn&6H(C9ڄ6Vò89.O=ڬ[pDRM2S@Ubp۩sV@Aa\"{ C98G`j\r6Mtp^8\"HW&n \0W1)!|rnQL<g3W:#x机dS汸Oٳ)\$saGnm1iUBWt'hG%4x5xX\$n>Ee,p|({eŘnAОZQ9h	;vN@Cg5rꦕп1}YKaKØ\"\\&8X<,_()~}!Д \0003(`*d\\ǅ6i*Lm!/|FƸ>\0ǘ},{/Z\ng?\06Ps:Ro7p>fO p(fNTdpabR.Vx-\0000DЖ\"m.!8P~\r|7\$\0003IMe%Mng\rJ\rEhCD9TQ1\0pf/	gP/-{%0Mj-iQ^Ps%\\\nL\nO,7m[*qpA\0QXqDZ\$p|ɑL[C`QB1\neHC0i+4B.O0xPCQ][Jc&6\0pmdn#?E-JC֦0J'ґqp\nD~}!G)Q-6!lr/\"%,20\$C!#A!(f mp3O:[`#\$_&#^hA5r٭Rz0(ji-M\"qS\$og\$F9u%*rr*m%+_\0=zH߲\0ACD!/=\0'../*4!/)0rj	3C\nb&dRp]iR^4ekǸ%]-S;/1/>#O07!u0s0٤p\rV\rdP\"kb66\nB&ʾ@pm5\"O.\0һ+L별sңȒdt s+vKqCm&a0!@c}:ʘɜ!Z-epr1i%Q?J&X\$T!	/gj2k\r1MD2nwFc\$Fa&aBkFKfO,	|>Jĸ9rY\0&'6==&`v+I`0ý@ETXPBL\"Q\$LtFtmJz YB.(jEN\r@";break;case"ta":$f="%)J::u>8@#\"\0p6&ALQ\\!_ FKh3Xҽ.B!Pt9_`\$RTmq?5MN%urι@WDS\n4;(pP0cAn8UUɼ_ArªZ.(qg+S\\+5IXrO8ꇥՕz*\n@{Mbkeu\n_Q*Adu'c(oFe3NbNd0<CA:#4R_0*F)H\"0a\\XNB\\8S[(\"pl2ܲȲqJ*{(r	*zEDP0lbB4;Bb\")1T2Z(*I[B57J@#{\rd8NC6d&:җ4yB9\$Z~:7bJ29#xܖں&	.2\"{ULJG JJ.\\W+KiVTjEzw2	 P)\\J26c4D3JvS0+L)Mm87-<:a		IDZ(<oۄh)g\\sK9c1S%vGA@9Ma6*\r\$2GgD_W\\1]\r\n4	[E ε=iM[6ɓHA:<9ϓ@0cRI^8S;/=/MAC X90z\r8a^\\tM8^2}\09T ^-6<`6\rJ7xPtٻ[zf˳Wi_\rƋPCWv2Վk۪3DX[-]ZK|>*8+	_)y4xaA&r\n	C\"B]B\0^\nџ%TqV#H\"\nLCP+B:H =+KExĆv!:WɩhxJ4\0Cpc̂s`B p;T`4RV c9R!4+2zƄ7Qs* MJqʩJK,2Ei`l>@CrI\n!0G%KJϸFH\rQh9Ek䌯	¡\\YS̐e\r'e7/!4Q>B\"6j޲R<B\"TBGj]!\"fL\n㰩YT\$F!JS\$qJeHR#a@ǣMES\nD\nIg%N%\"RU JCj}AьBjLYx=v&SS\r%4PDFnLg8!m))gM\rՊ@\\@t\rxyvܤ8WR0f\r!ZYI7(yTlMAZTJS3dÀG7`	-\n8ϿZBo=7ACmmR`splŚX{0Sb}}6? Vu9m?;PCĘϛV]p@לipa؜)q)8 䜣s\r6>SljӃm_@[rށCPf+R},%?s҂s-JU)59+M8j5q.-Ƹ\"ܨwr~9T.:P%WsoP\$bjM6QK#u2ܗ(S'l\r+\$g \n6ϸ#n(h<v\$A\0b<4ܦCf:K9\$cofX( x&w]\n_1NcC+0!ꢈ\n鯧\n\n (eY>_uM\$9IKf/\0J{e4h:V#ٛ\\\ra Eo\\1jf[Xǵ~\\dO}j\nhn:GCa#UOކ2F%ܦMUq%hh(WȌ^s<G*k)Xm^M&e~\$''1\\˸c=<\\rX礈UD.BT;bijS܍D\\9xz˛|Uj_5zH	\$<ugt7aEɬ6X^Lጔ=\n8Hhԣ'!@'0';]+S׾ozD=1IHK(E.z!N\"`W*m#]M9!wItII+nA\0&Z`d	\r4e7#\"szG2umU@g^ŝe?^8O	*\0BE_@/IB\rzEgrGe,^ChR\0M`ӂ\0\0efv⾯eZ)jh|A\"yǰE\\uI.)i0h],xO),VwP؜\0RY'r0C	0\\,/+:p]bC\nGNywxГhP.#)6<o\"Alì#JFZ\n>F0窡\"k0bD\0K\\N!J?ލFԭ*Tgf#*]%h:RP\nGq\0\r0~'oJ{n*Pi@\r ʰ+VމMiĐ	T톇@T`mh\rPCQH\0\rt\nmǀµ,=~UάKX\$RCد`i\r:?Ȣܺ%ZIR7&@邤!^BzjJ/*FQfx[q\nXtE`@\rb\ng?#!#̰CiR-p<W\0(+V^L\rPo- ihh2}-+*bd\"5pZFP`?(	O;QvU쌰W.Q(\n`M N\$\r٭\"Gu&2RE\"\r䐁42w&\$Ӟ19~::;-y126ΐph:\0Or=)@}5s8#.<N^pǕ?=Sޝ-'̘Q@n0Q{\n<#FȖHi鰓S=Q,k*Z/(=?CBM	S@>9FR;.#@Gs4OHCA><t@oM`4橽+U*\"J'쬆dK+Rd22\"\$QMVsGLVelCTo\0ӳT(lQi q=.WQq摎rǂBF%<pL\":ƱNJ0L-PtXьVcހF0,rk4y'2DPU1Tp>&5kJKUNbYoYhSXPG/E?5̥9=d\0bcҴ^\$sP`C`V|3BeG^?`tka5^V]yb;\$S|)\0p!<s^ܝJ̆pD:YWDj\$\n5nD4Us\n]zH/^3l'6?A[!2m+Od'c	^4lmC7&l\0,]\0\rM\r\0އUQH@6qjo'g0?rVyr0eV\rPԞ2*˅md6Mau-uW?u&		+cv]@V[vSacVP1jnjsaS#tht%tV\n?6DږIxWP׾XWw{ynWx,)%*RڑhɷW7~\"QfT2;	eY6/yRtIyn?JyǺf	aA:Cxq9*UB2>cnk8/YxSQp(.tXIvM^X3Zwx=^wx{*~Rj]V7\\TK{H2/8dti'mhC(Պ4t3\rOJK@0/6\r8lV_jL.k-adH1@X}t-;ZxY:7c/;c\"U:p\0\n\0Ӎ3Oͧ8rXZ`?!b41eg{)}+r(xxYYZTu.#B}+gvɉ0Rw7AˉIw5KxOZVFmO,Sf@9Yx4Jal ɲYӟ}3xzCSR׃\rM)fp+xz^:Sz9#VCZg[0NDf9ҍPQx&0\"*Z\\ᄇsx7cX=Vy㢶O\nYi?׷\r}܈Q#vj>T ړhZ9;EM7Cr*+=wҎLWs3if]P7Z~/?wȗOO[:Hͯ㋻KE,[c[MeUF\$p@ˢvٱZo}w\r8K{6I[ɤv-uϋyN\rcNMti,P#\\l-7ҿ\\<\\+,\nr\rr\$ۊվx.{;-.|UYѦؿcOƜW!*<SUɘХ[S[ii\$r\r{Ux^K5sOzHw4fO4<s}NL;Qhvg˓QHdwuxi-W9XSЙԔm#8GJcZ?YMC5h֙qF[tBY[t[н}E=80xve\rV{:ox,o\"̀ʈOL\nZ\nֺIcATi.6Ӕ&	۵>D㎟kJTVY0Hʀ4f_ԯ1\"}sd=ʈX1ȋEF \r/l	G]e<apuU>xP;|Iw6BZdugndKڀAk~FX>EkXmnpwy|ʉ	/r%cf%[vezڞrcC&>(q`:7g{\n>c<Ll1`VWꍳ,4!sRoH=JBZf\\Õ@I3H[Tt@M\0\0q}\0\"``uB״dA%{ђ@)?ح'j8:J@ꂟe|O'%cZw!\$?JjjG;@408Bd`wIKU~ɳ5:S/D^e:i^iu(4	:";break;case"th":$f="%OZAS0U/Z\$CDAUPȴqp*\n*\nW	lM1\"T!R4\\K3umpPUq\\-c8UR\n%bh9\\EY*uq2[S\ny8\\E1BH#'\0Pb2as=G\nASZg\\Zsf{2q4\rvuTq,..+lţAsԖ\nQ{[w44=eH.N[y3+/YH`iЏH:]PQdu'c(74H2(\08@#)l')pD\nF\\;-\\\\2X;h*T=:7*!e9S\\qp;䡔R[\$RB`P#pΞC.(c4+Rء¨57I	CC|\r@9G0;\$:پMKV3Dncm s䄯q,\\@kSsV<٫	379(pέ9LlZ,d8e<:{\\? ̝z&}tPͨvK_==~_,_~TXJ)8J5\\)i</s7lU+,3uNlvR<3%#EhH)g-(x㽝:Yß3*e0# 2ϡEu 8RC0c9̣8@0 C?\n<KS4C(C@:t\$:ֹ@8^2}*9^.@?(@\r7^0ε+|G,Zjv)d-R__h/Гݫc%'yok͟]הVgT9S\n7m#!\nLr/E <[`'\$+n_I*e^8-	A<@0aG`e_ݞOJB(-d1_\r3cHaBiQA7ȞRK)_ˬ^|huDAf ScE󭂆{lz2z;D\n4+\r1\r un~TA\0S\n!1bW9zcI|3[%&J(2zԖr0 -j=Se[8Wʰ	;+X0anmOu&ǖNN%._#׈G@	uIXmG8'JCu~m= C˲v0|݀f\r!Z\$` L1A!y\nK P	7RzCJHeL76`_BXi#}{A3ƸOt6 	-5Lro@7@ium-3B@xgL@Ug4@puB`9;*YSBأfxwAn9UvؙY	:nC#]pG¸wkr.M70Ӝ&G^A>3Qy5W02t.\n6\nlzi\rʜsi#7q9<		>[|4U4\\q)8 䃻r>22:PC\rp:QCA0RT}Hd`ITo:Ik<m;\0@݃dG8'auGթ샬=d*1s8;́L/T)|WIh\n*j*2(At*i8l\"QI\nbFڃ@WCB12僘Qٳ7XP[pjUR\$]HnɽCA2hnXq}403<L%7UQ|M[=%c3^danW&u)\nR{	,HߧXv񳏗y9Yw1X@@Hyh0RAnl m7ͮ-J%v<ͧ3iTV\$xb(\n\\u}!IFg`ZwAn(mXV\")`C.'`\nĞc\"Uz7\$d R\03<!\0):EG@ȸ\na2g1R{ш'@p \n@\"|&_/`\nJ6\nJS%CtOstς^\\KER!.!.\\4AߢRakM/w*yIJz];DQ.ݚJL[_#zS3V+{\"\n)PfC|	mrbdLo]thWĺ`rS t!pe(.Zb~^̌Y|PxJU9\"~7\rڞcB^/X*\$\r J0\nI@H϶b\r*x~s\rPmcԕm4k*	'@z6X%	 ܖ.(C>(\"\"Ǽzx--xT\roʙL.UDx{\0zoz&T&NZoFddih`~p\$Qf\rh䖏Cf)P/\$@`A*}\0n@\neX-*)pҍ*	)5NZe\\GbPFJ'0Z'|d\$XP 	\0@Qg?ƦRm\"nI^0IQj6^dd^&R\n\\W%.g\r-2*́h,=G#/&22,cR2%y\"2bW<-%((i\$Cp.]4@UQn\rмn\r)r&Eq(qJƈ4DC;#b^(cPk֥+0Nb/2Ig52ÌOR\$*7(ǆ]ce30;2	bcl_d\0SB;#>FC ͼi.P.C˄IҘh\"-8,8'3W2/R[ЦjNVSnFd'\0>Ӧ8zl9cc;:c7dbpҙ(eUn{4)U|5~hӣBuC\"B&\n;-/DQXIZ/C¬EFS@-4q`\rP\r\0@ކ\0ڦU)?7I@JTѴw0\$Ĵ3)tb-Dq\0TUԿLs>		SCj?I`|GKp1@+Nny;S]7G`Q	LtRRR]Fc5P.fGКJ(35UIMT:2HCg\"u5(GA%OW\$yQ<rE6q`ε[SeL?POSWX&IXoX\rTRIFPq&swHODaO@OF)TE\nH84YW;ƉgʌpUDHGEbu]9\\tL|\0]5ouDCUX\rՠI;\\Z;S5cMg5sqCZtcV\\rOX=~cRRTQg2_pI7#W-LTvrl\"ZtkZIik,}lU<hU;ZT(n>VslkӅp>T)Ĩ8pH{q&<ʒ-rn-N@o&QUiEujufS[7cuu֛jjmG	TLFd@@m@ȣNwvcOz^(3w^^#Ξvxb⩴?lLޛ-KXׁo<sivևwFEwhכhhjLIU'/1nB\r5]w+ƺ.&|i5jx5j6sp/);C{pO4dc;75c7Q@Poť4Qwg8mXX?X'ƕ\nXIvhsw7wo	o߀!ђOl>`AQ_0M7Mq֝I	OxXxhهi1N6q9%Mibx	\rS&Gt(f!:EXG'ˋ5}hڧV7h1/g\$vI4ۧȷәfi'ӟ;.(uلfY`n@\r8j?7(BxQp`\np,'JFUq%4ڹ6%d\$Ywajqv\\t@\rѢ<<✃_B\nFX^;dߒcNms=.CB8pQA׊pGFL\ntB\$3*PeDe2Ј4w6u_B=Ьױ*sXa\\	3ԃכK*IKosNAc?`\\kpy5uJqrT\$(:>txNNZL:H#\0eJ[JV6α#?Bgp8}%٫\nI6r[F'tv-|\$fh6K:F&#/;\nb(ГW+ϕuPIN*URZށ:@(dKH072qˢUu}6|-	\0@	t\n`";break;case"tr":$f="%(o9L\";\rln2NFai<BS`z4hP\"2B!Bu:`Ehr2r	LcAb'\0(`1ƃQp9Φal1N5+b(Bi=QIBa6 CԞ+i5f7D)~,2C2\rvC%<NfFe0\"v0DS#iLdF#]HZWESqo;ȢG(Ö1N{y gS4ǎ;C\"8&\"\r(\rjںTcN(J\"`:icC\n&49XX4B\n(ޡ@4qpꢫ0Ҽ,%(Ez\n(@*\n&)>ɤ؂2-h?Ó0l\r8@OH4\r2\0 2\0x3:xSAr438_H@p(^'aڍ7	̍Fcx#&(,#i3EE\\)\nTaR93k ڲ(*24cPXc:7<b\\/K%,C'4BˑpyEpl\nviNPַ##tX%AP*Rn{`P4혚Դ̊kۄ/,Fch\n\"d1!0[N\r'6w-]7]\n[nKC:;.JeA3m\$5RnY8'X45h2i3E7\" ј@:4\\IBqs<ض:9K\"3\r#>2!t}\$28cw2ܷ9C9\"FchϓHܚ\r!̈ =R4t@[AXB!b,9ԍ	{FXGc|'!-Rq7O	&\$?FiM:\"p5cDHRL:\nT;WگV!RC3Z&e/sͅ 6})\r:PYfDh5\"#9\nZD=R29;XuņĨNRU',ĸTJS*U\rprV\n>'sjJHr9£DV8fM i-,)SW@GfI7Oc<ƁB	-% FS*ș3q\nr\rpFiE`q\"\n (9!S2Yh!yBgNc Ct,(n5i\$\"fi\$2q5amI8I\n+	4dE\n2RK;ƌgSUPAIe#zES\nARr d!	\n#\"Z`J14킠&H	HC,ĕ&I!Lj'd4Ăv91&.`lHZ\0Cd%\0¡\"eJӒ0t !xDc,!IC\$IiЃчp#JFCe^\\1y7Sk)̠Xtfd;⊄075ó[>~\r)\\r,eow\\p \n@\"hH:nB`c\0D]KyvDwP()rx\"Pq>)a0c:;90\" WM(<?m\rgQyBpt吼î,A\rA[m).[sa&\$z`vJ;err~	Ӯ4Qk\n܄k7nc\0%W \rTBn_) m<}!4S|Ș\$-0)aE|gNX6S	m3L\r\rfuMp\rl\"UG8Oy%/ju^ڄ7.e_PI\r0C\$RI\"9\"=n8wQ_7@a{3:\njkt~?£D:K#EQ[T1i'(%&wI-s'eu*@AɖEns.tu;=QWT%{:_Ċچ?0W-Zp]_=x>=˴.?m&<!R_ y@Y9GuAnm+ޣ3ߙ~3`Dٰl@QH💻YہC<P]PR^<H ;PŁ~)d>=S#'(<U]p.L\"0\\7!x08`*\$^c4:3.#\"M/mlm+hC./Tjvab0Cn\"G\$'.L*d!CP\\%mc\$BE\"\$mI\";\nK,zQdx\rALkC;\rĸK -p&Fb/plށ	3p1Ʃ쁐AGZ!mPZu!O0}v~zq\$8N).&\$򉘡ÂRV/O0(F\r0±%1pPuXC㐩\$klA),6\"/FnpRSq\$\\q\"X+drU𣂌q.6-\n*\\,9J:mޅmmގ'1r##2@\\'(152N2)1%qQ*m,gLrbwC&͊TgNT{d<FqÂ!o?iDJh%\"\$fdD!%IҨY0+B<I!K,IRvYh!Q#\$S :r2orM+-X*\n,+3223NN@D`=:80FJ@-4cDMs33bDm5@}dY\0.]/3Rtb/Z\r)8E- )0%nCn70s9:.15Efdj]=Vb]93ȇM.>M\$̈dނ\r!Da-<_1xM̏\0fk50\r0\\4IH\$CtBpd\rVCcB\nZ)J/F`E@/\\cm9Hs\$^ub<Gd7n(KӱD(~4QJqFb~rBh\n!l+\\\$Rg^`Y͉Zt=,sŵ?@I_RBF*!;5%PNļ	Yld\" @\rp2E9K`\"\n\06ld0!	igZu'V\rj!uZͦRĶ\rr[ɴGʰF\\c\0";break;case"uk":$f="%)h-ZƂh. h-mhĆ& h#˘.(.<h#v_Ps94R\\h%p	NmcL4PҒ\0(`1ƃQp9(;Au\r*u`Cd-|EX/5AbQ\",b8\$4漠c<,[\"\\c0qEҚ(-cW;,-c\\Qe-Z)xb}8G!L)5_ODsUڥ¶7J*(r|\0#'iz0)28޷4\")?({bBLbj#|h&)`Ыۢm\"@sZX+Ċ<4bvcH	(F)!ZK\nZ'(\$æ8Y\rݳ)rM')JaD0QJ@F+#*RSI΃QsBP8n,zhR.3),J!b!@PPѮIk\",\rZ?L伈(4I=^\$*QFj8^=&:P2\rH2R̕zj-V5y#\rU}%|!\090z\r8a^(\\0\rp^8#; ^+At\$	S4퇁x9)cRs+f':3IC8¦XAslD0*վfh;6gʤDH:Ai š(Ɇ*q={_8啈O+7VEw=aQJtJCr5	΅8píɲbm80{m%\\jj_\\*șid\r6Nu\r!EcJ6ܨ#LYG][wԂ~E!;4ؙ5ȧ#D5҄mGLoq*o\\R0D0Mу[M¢JP8Yb,[][0iۑ#G-C%;hzK(ئBu\\'C'\rM_`&R`WcDcJ!GuAGO80RgZI4:5\$F&q3lQd>P\$QJGQ/( -%OǠSREs냩Y%&B^܆/ԓ\"R#%%h0?|`7!L9D9|H.0mƷY7v3\"PM'(N;TYoX̉JAsk@\n[8(=\"ӒNz7:kO\$\$:2Ia&ZhGBRsO<(\09^:ƈ'cdtJ\"]y\$%)ΞN(Řcy2&HəElel^xn!4ؖvό&8]J\n!Pw`E=i&c93`\n~5	zz\$FE\nnBFJa<[)Ŕ]:#dݓs0fA<Fbk2ghLTAtZʛ~P5Q\$E:#%9Ш׭b!v^[\"YGE\r\$54XJł3\"\r}ߔed*	_q|m5^RFO|:dQG	<h(-?cx\n (܄&P\0O0K<9[ӹ̾2'':|~5eoFXbGu68xNNb;2GN3J\$_\r!hجp0/Գ\0#\nL}D`\"RǾ\"1(kBr̩'XZ#5h!ӈ亓P}}ŝLܳĲ\nJ510\$Se4fvɖd_lzy\n\n\$ZUnq3ۨ|k;ۊVmP64\0T@'02\rD#nwj#ڇ.Z\$)\"O-pnfF=Y_os	PiN\n.TgGa)}'(E\nHBYbD5Txy`X6`a@CC\r&lhGbM6%҂kU'#lAT#?=RAU.Q~WKU\$P[j{p\n%zNBJ=ټ;yv/#(-Z*'{i8qu5\r-Xf4\\?2=\"IVɬOVT+I6OS!u\0rHO7mΏd=e.)j*\0&ojOLjb\"h(PxmHgL67 f0\rGD0-(9¼&y\0#DlǍ<F<oht0H&	 \r\r `@\r ,|犬llAN(C܆\$Z.E': LFe\"\\oPSZYoAe<0.*b:pHo▫X'/dm%nJP\r\rq`(ލw0j[-\"¾\$vuoЉȶEw@ \n`}\r,JK,ؗ8Ďߨ,r\0^-VH!trg>k\0G%DhCRcȨBR߲'!\",\$-\"SL|r6r:sbC !JRO%2'%ohnn?&%!r](&,C\$LF)2N(@(r&ҕ('3%Y+2ĂFo/'B\rnA&*ql\rЌj>t=d\$(L5L\">bJU	/0\nGE0.rJ(/?\noV\03,zZLjZAG0Zt5%(N<3lYIC3#VPl0H8Qs\$ҥ9;NmB-đJi:Ђ'+G=0;(7oΘn ri=NVEwE0x!,!o*@B2\rV&30N!5D#&@şDЀwl0}1B#?[\"c';D/b'q\0L [\r\r\r#\0TdoIܼ%IkjttGŦ/nc3hRMS&N@4NTЉ0>>{\n-'Ms5󑨘mȉLf;ZU\00m>o*tGd*;;sN*L;SH5TȽU-+R1Һ+>ICVϙWTU'+*ϕR_<i2,1-=өGù[!55Gh\$u7][@QiS\\\r9l'Qꢊ([*=spN=sw_||(UHeN\r,Q?9gl\"P6q0U7Q?VHS`]15P'uS9PUL3iLui1MW=u\\	GPlaiuRsd6^t^]V5TnP]vx'	h*>ϳ:VwELFlЋutSjrs(suf'Gtr4k,Z{5(mfm\rF@WtoV4wnzmov+wD~\"~,?~5vEu1ۤ2VX_nvGǾL\\{9Uno{W{xQIb}کzt7[l|/XnH}vwk`Ѫ\"<PR8>3]C@e8!OU	VPTVZ*8:xjEKm뇘|Xk!vV6؆*8,XepVRleepހpsQT}\n}>ZZR}WcmJ?N1ut#DGDE7!bx~e:.qn{b&jUr9)9B'J\$\"-y\ns\"X:Q3GCySKGvU:Yo~W5cxMUji\rV{g3	GqaBnՕ2e+EmBQ2  \nq)\nKR0UMhr+u ~irҥ y.Þ:	jBT~tu)\"85'\n6v\\SvN+֨Fh=J=FG{(>yohQ!q0XbvHr|\0vTU3P\\Re]zgU]%B+v?s嬴։?ZSpv\nnP>)bSaPlcav[%.K40X.5O+cH27N_(.0b#07&YR~SxgIN\\Ц-T6q7o~FhC4=v{k xf3EgCSb=M5R\0";break;case"uz":$f="%(a<\rƑk6LBNl6Lp(a51`u<'Ai6&%4MF`B\"u2Kc'80cAn8!\"n:far Io7X&9 5瑃Ha9DڽiŎ1ҡj`\r\0Y/2~DD#ՅB;F :γI 4N;A)N:aLvCRӤՙq9&sȵF1WͦtOܺ2µ\\L9uh@<3`5\0@0L8#ޅ!,6\"#Zݎ40*8\r{9\$*'ɪ\n#- S7;S8V7I\"H@XƎOX*-C-2Cǉ¹r/)Ac|FD<Ȉ7cHP2'tB3BeF>mT4ð\"1*72D4:x]#6p_\ncΌxDN8BÍ26@3x!b9%-`,9%O;C,=&Cv2zv5W}\"X`6ز3BbP0x:89\"\r@X à޼\"У\\4R3(32#6i\r9Lҍ`Rr6-4w3#̍q\"v\"2x)ˮVKpk4#z\$ȻN3X޹3)SWSB<ao^yr67@H'8bHڗԒ(BX2,#(#!h֗K2H7iT6\">myJL߂h# UbAV\nZD;g+v\r6ݺPG:ҹ6 clkr~lB]I@r{FPr]+b@\"N˲D<mHfn%D,!3fr\\!,ZǊ9\$hB-\";M0F&KL]!ģa qV<؎~g9f-HLiu&Ț5bi\nYUnUwW@0d.`,|3CgIf\0sVL\r IYNbG̭(,Բ˂4G\0U:\n (ry7\$PP1UE%hWJ_IPCX<EHmx}336Q2PT	\0H~:B(e0Z,68A<~R\"FKX	|hL\"Jg3xP	ASDbXjH)Ҙ[ѽ'?8nS䜔(	tN*SER_?IB܊s^aH1RTȝ}b~\"05g&'h2rD!ԊԊJԡ|Ig-0L\0IE\$_ClihUDiXڍTvZZb[Ho\nApi&ƨ	!y+!@'0FސxFV`0iV	yrc)xSpDԛ@D37 Di7(H죱q̻;\\ag%d^C#!'p1GƁ N@I\nXx\$N'N\$PV}dS#],\"͂;~y>K<5>Y	zm29'VQ=rw/iu0O(,>:!WfL#Z7ּA	',E!rVLB@*Q Fv{,(Zw\0|6`|->P	6~xb|?<}LY!VkPsm\"{k~{uu6֔3;=0`nl]d-BL&mp.h*3[[]@ıQCwdS(׮j6\$S~a㥐y )CNNA9ru>I!c3_*@.2*JwBinUH)mx=prc'ԓn;ґCރ9j\r뷙>։#'u\"~!01!}b:ו¸cyq)cԣwHTùb=w}\r=3}Ǆυ@σ0`.G圌@+įMeʇ3؄RMRSg\rnP~%B'fBE9,|\0aF\rX#af5m&mp|Dog>o<zD#Ǭ'Bz̦-f	0@f2`gdG(>D\$Bx/n^aRd I0@&j|dfD\$)n-FV&,@B\r\nmʐ΄\r\"j8ЍoN\rb0Xpuu'K1 {&pRlȬj'pO6w?0}.s9'ulsqR=+BCPR,[Aq3nO.AH.\"#C`df}j)%>J\$xgE3H-#n.nȶj&\rq\rL1	<Y>(c0̢z CL^>Z_6nަJލ\r8=6_\$m,^Gy1'%cq`%Q&&(	\"#3&m%%3 TЃ,A\$^ȊqFw?2wr#M+1e&h\0hD'q32w,Dj2,~Rw20G>qwxG@#g2A\$RĳR3x3@&23	2q.,R3DC2541(K/P!H\$.C#ҹ4VlF1j,Nc3I7'6c8SE(JVMLӍ5#&Dr%D?\"m%NNS1-3N3Nn@+).kCF2F3D_<\".\"O?m,cC@Jb\rH'&\nA3q1J\n&tJsw1鲐@l\rV\"ĕ(`\npfb2J q~MV?0kHFotECb2#n)D&	f%\n\0002cIFw9R(95ƞ-Zؽo-&d=Â,l@,nCHD%P'4I1d	u,=;;Q6T0\$TK9M\$DUL<;DiF7\rv.r'b	pd-BP\\TGTU6,1\$('4uN&SލiSeΉ)vXm;d=R";break;case"vi":$f="%(ha\rq]Ҍ]c\rTnAjhc,\"	b5H؉q	Nd)	R!/5!PäA&n&0cAn810Lthb*L QCH1b	,Q^c:A A0Az\rs|VʐQ\rB\\nfFd+㕸{-ԊNsMqf!&JN\n¼vkknRw N!o*)'cL,X7 q |9*fyސ2C9\$\" :#92o: 8@pc2\$\"(Sr\r3\n2%4FE>Qs9#ti~fF®qvIvHq@<;HNB:	P@6CՌP7	#BB~4PvS򐅥(;q\\&l(K!\nGoD64;b!Dh#DU%1|]0P2\r,B(9\n#o*<҇\r㭐Cc;\0x3:xy\ry_@p_nI|6pk3@cl4px!B,4ѧNJF&t1tK\"(#Ha&B9\rr\n8:@˱pN\nT/d:Fj,vL% 02h!Rڴ܈&QhnY~1,(1LaN]FCHM:.\r!3.;U>Y:,Ma1P)ַ13h+b\nbHM@,kD.!b'}Yw .2-4{zIuL6mk^\nV_ \$,:rRX=t:`|m,nB</i<FN8uhQqe<\nة!6\"Hg!*D@  ؃`oe\r7,\"@RuAC\n+f2\r(ZYm)EaRHt&\\l]z,yޣuBX!4W!\nBI\nL`!@C<eW \n^0CO\r!_0@W:]kwת}/b,L\0\\5\$!AΨ\"l('\$N/äiɫGrQQG3N<;QĹ2]Kw/@9/\"Z&}\$<6WD4N)b\n7E싘ʃ\$%A\rà\$m0f'\"Y:HZ8ԁL敁H`Lb&u0a1&:t-РP	@D\"	,tXcoGi<35P<XPfOc8FT\05hmeÂCPnin!<Kj3[QKAA2DN1&@)hfԁʾpH`i\nVB:V\$*Yyv̨.\0I\$EأBEJV_-Կ\"h+'9b-\\+ȶPRHBI1p2JsA!	s\$ 2;|TROeeB(nSB\r)I\"؏Tp7;DrDU52LC,%n3AnKCݹ3RL\n)%-\"_z[ꔃ\"8j8|8RQRw9{Jtt}pc\\HBiK/,\$.Ee,5r/%R#ɭǔw_\nT4ܘsO5Kbߕ:^6epHdD\$L1Lg<m%\ntav\"x(V^)hB{~̈́k(#5L3DHp`V*emc}u\rP[ls\\vQUhKğ+K+\"0vpl0ƹfiaN\nS[T[wf t\0zǐ2s.̍=W1\0Yxt+}U(7-rrtR(HbuYY3斞K6@Teķ<T㻏)\\WCj	?=ן!/\"4*(:ph{+ET\n!;AaT3aQsiɃ\nq(2\$\0MUY[HΝbQD,G0HBBh̹YC/d\0Ȓ8\$WB&.%2\0B;Xy/pʵ!-mgk6Uyɡ>sDno|M/OnaV0n^dJLC,j:aZ߬ej(~B*I\"ط最)&ޫCx\"(\$.HA#'ybfF\0˅,.#F#U,I\n^LnH#bt!D.:eat#̙)j)FoLDڕjRаnZ :-[2#bW@讼\r,\rDvBLpW(\\%Dm0Qė\rmMN`O.{WpĎ|Q\\{v{q|yG/1zU\rLoI\n@EW!hn.:.ma0:Cr\$1cRDLK\"%dI\"H\$lE\nQF`\0\\1of\0F/-D)6L3\$I.1،ܜ0i|zάR ffFU\$.@h)Qrr\\2s&1䌁&'1pLAqzkw|C)Ҭ%*^F(ҳ*RA_\"\$檃탘F	/p0`ddY)q\n茑qS*Dx~}*0y2{2PzǰP9p'220P\n*;j)'8GP8ZR/505/:{tĨ58+ȸ2*{9e&\0֕>@s:gB ln;<.B&WӢ6Ng>)S?ӕ?=s5@@VW+R>NOI6qB\nQS\rB2L\$C)Q˲&D#cd}lM`W)~rrpzIcB<LEN'PH>h10(J DJ)\0F*X-KPI`kB%6d\0002\"H15R\"\nZe\nLL0SB5f\"Gr\"=+HmSg51ikLg7/KK&~mbSsTp7Td<4vgjЎ-5b;DPt͒&hHg`\rR%5qKVXC& @8U~w#9&c%lor9	T:fK\n\nC4A^\$TRScءu%bZO\0տ\r@MR/nMmlaro+Z#+B -pPj@^-`ʱ.CGTb03_25VC'Bb< X@\0lHPVtV:mf";break;case"zh":$f="%:\$\nr.r/dȻ[8 S8rNT*Ю\\9HHZ1!SVJ@%9Ql]m	FU*qQ;Cf4)ΔT9w:vO\"%CBrix9Q*Y(cȗB/΅F:IIԼM*s#Uԇ5zN\"\\2s&֑E~~&!rskk=͈BQpgLBUB<:B^qTO])Di_m̔W*s\n#pVID')bJp\"[M\n.>sKZKaLHAtF4DʱzH\$C1*re^Jf]+<E	L[,*ʾ^{@T6# 4(tdNR>ޓY\\˯o\0Idkq!\090z\r8a^(\\0\rp^8#;գ ^'S\nt3Nt^0A@3DYRsQ0_!tܒg1<B6t9(\\wr4_#B]V ;%iLr\$PDtHweE}9TrEAQAO\\RyZ5!0MDZIvszF\\Iu~쑄XsZt{4\r\\U(]y&rL\\D^buxn/ϡSGAM1l?9PEZ10W0rөW/H#Ѡd9p\r:{L7p0C<X|]cx3\r#?l26bn9ǧ;\n-.W{|#	6Ʋҁt_N*;4r9H,G@DL!RHv!H.@G,+ĩ\rDE	є|tDXN<(+Ÿt	\"MJ7bJ)e0T\nR*eQZUGCiyJ@+nEZ:E\"tQVi\"\"h94/XARI_L(\r(';]L:\nTSZrVA<Eb⒲W>d\$%cCYRNEp\\Ar!G(Ϥ_XWă+6s~̠I֬LQF+PpO9ظK1FZ|G<Se{L3/z@\$\$TEq\n\$a<9pGbsg8QCD>FPF!E,Տb.8^\"^@O<ydbxE\"LMR1 00 \"⒂6#BEgb9Dl0[,1~! \$S쓒V0ɋME'6 ̑q\nPru6N Es^aF\n@P	L*=HXx9L{X1JHgT:(ħ=B6Up\"\"a=%޻%6 s4aA,z	XWp \n@\"n}&[au/!#3f@\"c9G2osF@D]ߑ\ng\\SF_JGgXL;}sZx=70m9%,X !!Y/eB@bv	%^Nihu#,Cd\$sGVx:GS@e_6PΞ1sjbK򕾺w<%]I\$쮕vK\n	!4'fA6f`i\\B嗊-GEА*mC+*\\k}a51( z5U#ĊW<Yx,M_RzϙK/KEM&/Ѓ!;֋l%#gAP 09IFSpOX_k\r&ܢnM#4RKx\n<K#b0\"m+dF3eyٖ?So0gڕ1봗  DcTn5bea%]de\\2F1ɦף={@\nb.+L[kt#PF\\Kl`LkA<uNLqcDi;\"+uT/C!x8jN9'X:LE#^zX|.(sî=ƇU0:BCv?\r3@\\RL&}_ʸx,د'}i/_^k<f^.Z?`@bA7\\3ԬofNʢB(\\t#(&\$(Hʖn\$3)A Vtoj,%\$(m,`bl&fp9@f8RA<5m*8r]p\n:I0\"P-j華Ptr2\\g\rP^'\rsg.pjf.[6JA^o!\\6K\"5qr/q&-(r6PsJp:sLh#M6V,Q!\0&8r&!/1T^xkM&,MBFRj\0b\0`x1}m@ՑzwT\0xnMY1\"lme -a oGBo![\rg!R\"Ed[qʬxэ+q\$2<0\0VX3A>5\$rîf7,Xˊ(\$x.!\n\\(*w'd&@\0p\0?Lg\rf 5/0G)0h+\0\np7,LN\"\\1I!b&D#L\n\\/A8\"7\n͐0cӁJ4Htb3S8kd1#<j8\nDϣ3aXmI'm7oBx(8j3(VZѳ@A&F+ֽg;KJDEdjOZh ȴ\n`ڌ8b:sX=/<[\$BBKe6=7)\nIRCrP7òss\"XL";break;case"zh-tw":$f="%:\$\ns.eUȸE9PK72(Ph)ʅ@:i	aJe R)ܫ{	Nd(vQDCѮUjaʜTOABPb2ar\nr/WtЀBT)*yX^%ӕ\\r~<OTw2\$N\"]4;,t(i1B޼W*=`0XL6!B9J\"XQ2M2neʀE|N.:B,S9+::2^ʧzέCV:[D*@ST -I8sԮbR)M:rEZsaZy	V+JP휤A.yZYI)\ns	ZТ[2ВKDJ12A\$&Y+shY+\$j[GAnȜ|k8YYqYb\0%B<\\gA2AyD^Kmv`\\\ns\0 h7P	>\\DZ\$EQJ+5:	)	L*F@4C(C@:t|4mHx3(90I|t(B11B|\$	qA2,EyRQY s/o]7s{}_EnRt96W=iLr\$P\0<(P9,XBJ7ƲvtCY+tJRͼtd^6Cfvs|saGP&d1T\\xZP2@tS#rN#*/!A~)\"`Aks\$\0J_{{_wzw_7t/v΄^D|3Ӹ]E]#M>tEGQx]Wf&9h9mX70C<ܗ0\\zØ|!p4pAG9S09@S}A\0D}V!\nS_:#\$hHG@M;QRBw]L\\֐rDq0Jt!2rPȆ\"@:D8[Ј^\"\"wB	+Y>F( \0Bl@6EVbժW*^\"Y(GCi}Pa`. tR%8JL@A\nPS>==f,@+~ 8B\nQO9Iy2'=Y+ElҼW`,(V:Ym%Vֆ*\$0J\\\$sPjB-\$d}_A!hXЊHkw&bH9bDRBÜM s0EC	,>|[@cIh\"Xf\r0i.)-0 \n (@zhpdGJ0G	#6T2,8f@BPTHZ\"M	:HBUL3HqR\0Uk/G0GbQ7ME8\0F7Of@S\"Z	xm		XW lXD1\$+*\0ϑ8 	2DL3<.\"Aa<'\rQ'J\"B0Rltq8DH0tDRO\naP:aH=lbl\n2ց*fj[ٵAU\0&F\n@!gfY#	ZȚSXMrP`% B4Z!@(IR	8PT+\0B`ELy҆\$h\$dxGrq#n\r]7FpL|;'lJ(+E)(=&,PGHk:xshH Z֠=ף\"\0S`atPaFDI	rɝ!6)ίMhBJeԇFN=07ClG0YA4B+UlTыU^\03Yq,dS1<CphR!:=\0xm!Q39rjmb0!߶6й&RLNAe0ש=h&c읖XPJCR{E:z\$^3BN2h\n!~1RhW?¨1@@bPJ\r9 	-Ujؽ#OBfmpq\"RUZALFMwь7p\ndo@^n*\"ʳ:|'%Pr99/;WN&\"75y^3_ČuΒV\"<׊#^ LÐimt4ܶ<\n_#z6ʾ0ao4`{0EEɧ5`_F_7b\$ϵfjTT\nl#E~=vdb\0\0\0P<b<-_ڡx@۰2,B \rX͘\r\r}D\r|^nb<F}U,8OЌdLPoOG)~ɐvu:0s/yP.:G\\v/鮆3ꎬK,)mB\rvaCܡP64Ra#n3I]<dVf08!V!(\$M(ڂ-7-^6-;#Zä`F7	q-7B\rĒjvm&qѼw	CsgsE\\_'8^h)-^C('M5F(! GcE !g<s&%!u\$h3\"#\n,'К5!D'%/ R1%3&LRH1Rs!'2;ހ^Y,\0\0\r>|()\0)G#*-z)n`|Bc ߭e%RMT72&Q-Х/.\n2DHn=i+.S+.1	@uh&\\x!D=naMi	&+\$VZ@!H]F|bDB!k6\\B6)\r4!Az:;^7lI\r\na1]1\np:NwjJ!p]Ю^|p#23=m1PNA@	>0ûA#sOPz,sC:y/6a6A`]hpaS`bFqai&#20n,W.ԖŴNp2A*` \rBnD\n/{CDD\n^CcD,|U6&/B<)-S0^";break;}$ij=array();foreach(explode("\n",lzw_decompress($f))as$X)$ij[]=(strpos($X,"\t")?explode("\t",$X):$X);return$ij;}abstract
class
SqlDb{static$instance;var$extension;var$flavor='';var$server_info;var$affected_rows=0;var$info='';var$errno=0;var$error='';protected$multi;abstract
function
attach($N,$V,$F);abstract
function
quote($Q);abstract
function
select_db($Pb);abstract
function
query($H,$sj=false);function
multi_query($H){return$this->multi=$this->query($H);}function
store_result(){return$this->multi;}function
next_result(){return
false;}}if(extension_loaded('pdo')){abstract
class
PdoDb
extends
SqlDb{protected$pdo;function
dsn($pc,$V,$F,array$fg=array()){$fg[\PDO::ATTR_ERRMODE]=\PDO::ERRMODE_SILENT;$fg[\PDO::ATTR_STATEMENT_CLASS]=array('Adminer\PdoResult');try{$this->pdo=new
\PDO($pc,$V,$F,$fg);}catch(\Exception$Jc){return$Jc->getMessage();}$this->server_info=@$this->pdo->getAttribute(\PDO::ATTR_SERVER_VERSION);return'';}function
quote($Q){return$this->pdo->quote($Q);}function
query($H,$sj=false){$I=$this->pdo->query($H);$this->error="";if(!$I){list(,$this->errno,$this->error)=$this->pdo->errorInfo();if(!$this->error)$this->error=lang(21);return
false;}$this->store_result($I);return$I;}function
store_result($I=null){if(!$I){$I=$this->multi;if(!$I)return
false;}if($I->columnCount()){$I->num_rows=$I->rowCount();return$I;}$this->affected_rows=$I->rowCount();return
true;}function
next_result(){$I=$this->multi;if(!is_object($I))return
false;$I->_offset=0;return@$I->nextRowset();}}class
PdoResult
extends
\PDOStatement{var$_offset=0,$num_rows;function
fetch_assoc(){return$this->fetch_array(\PDO::FETCH_ASSOC);}function
fetch_row(){return$this->fetch_array(\PDO::FETCH_NUM);}private
function
fetch_array($xf){$J=$this->fetch($xf);return($J?array_map(array($this,'unresource'),$J):$J);}private
function
unresource($X){return(is_resource($X)?stream_get_contents($X):$X);}function
fetch_field(){$K=(object)$this->getColumnMeta($this->_offset++);$U=$K->pdo_type;$K->type=($U==\PDO::PARAM_INT?0:15);$K->charsetnr=($U==\PDO::PARAM_LOB||(isset($K->flags)&&in_array("blob",(array)$K->flags))?63:0);return$K;}function
seek($C){for($t=0;$t<$C;$t++)$this->fetch();}}}function
add_driver($u,$B){SqlDriver::$drivers[$u]=$B;}function
get_driver($u){return
SqlDriver::$drivers[$u];}abstract
class
SqlDriver{static$instance;static$drivers=array();static$extensions=array();static$jush;protected$conn;protected$types=array();var$insertFunctions=array();var$editFunctions=array();var$unsigned=array();var$operators=array();var$functions=array();var$grouping=array();var$onActions="RESTRICT|NO ACTION|CASCADE|SET NULL|SET DEFAULT";var$partitionBy=array();var$inout="IN|OUT|INOUT";var$enumLength="'(?:''|[^'\\\\]|\\\\.)*'";var$generated=array();static
function
connect($N,$V,$F){$g=new
Db;return($g->attach($N,$V,$F)?:$g);}function
__construct(Db$g){$this->conn=$g;}function
types(){return
call_user_func_array('array_merge',array_values($this->types));}function
structuredTypes(){return
array_map('array_keys',$this->types);}function
enumLength(array$n){}function
unconvertFunction(array$n){}function
select($R,array$M,array$Z,array$yd,array$hg=array(),$z=1,$D=0,$ah=false){$we=(count($yd)<count($M));$H=adminer()->selectQueryBuild($M,$Z,$yd,$hg,$z,$D);if(!$H)$H="SELECT".limit(($_GET["page"]!="last"&&$z&&$yd&&$we&&JUSH=="sql"?"SQL_CALC_FOUND_ROWS ":"").implode(", ",$M)."\nFROM ".table($R),($Z?"\nWHERE ".implode(" AND ",$Z):"").($yd&&$we?"\nGROUP BY ".implode(", ",$yd):"").($hg?"\nORDER BY ".implode(", ",$hg):""),$z,($D?$z*$D:0),"\n");$si=microtime(true);$J=$this->conn->query($H);if($ah)echo
adminer()->selectQuery($H,$si,!$J);return$J;}function
delete($R,$jh,$z=0){$H="FROM ".table($R);return
queries("DELETE".($z?limit1($R,$H,$jh):" $H$jh"));}function
update($R,array$O,$jh,$z=0,$Vh="\n"){$Kj=array();foreach($O
as$y=>$X)$Kj[]="$y = $X";$H=table($R)." SET$Vh".implode(",$Vh",$Kj);return
queries("UPDATE".($z?limit1($R,$H,$jh,$Vh):" $H$jh"));}function
insert($R,array$O){return
queries("INSERT INTO ".table($R).($O?" (".implode(", ",array_keys($O)).")\nVALUES (".implode(", ",$O).")":" DEFAULT VALUES").$this->insertReturning($R));}function
insertReturning($R){return"";}function
insertUpdate($R,array$L,array$G){return
false;}function
begin(){return
queries("BEGIN");}function
commit(){return
queries("COMMIT");}function
rollback(){return
queries("ROLLBACK");}function
slowQuery($H,$Ui){}function
convertSearch($v,array$X,array$n){return$v;}function
value($X,array$n){return(method_exists($this->conn,'value')?$this->conn->value($X,$n):$X);}function
quoteBinary($Hh){return
q($Hh);}function
warnings(){}function
tableHelp($B,$_e=false){}function
inheritsFrom($R){return
array();}function
inheritedTables($R){return
array();}function
partitionsInfo($R){return
array();}function
hasCStyleEscapes(){return
false;}function
engines(){return
array();}function
supportsIndex(array$S){return!is_view($S);}function
indexAlgorithms(array$Bi){return
array();}function
checkConstraints($R){return
get_key_vals("SELECT c.CONSTRAINT_NAME, CHECK_CLAUSE
FROM INFORMATION_SCHEMA.CHECK_CONSTRAINTS c
JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS t ON c.CONSTRAINT_SCHEMA = t.CONSTRAINT_SCHEMA AND c.CONSTRAINT_NAME = t.CONSTRAINT_NAME
WHERE c.CONSTRAINT_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
AND t.TABLE_NAME = ".q($R)."
AND CHECK_CLAUSE NOT LIKE '% IS NOT NULL'",$this->conn);}function
allFields(){$J=array();if(DB!=""){foreach(get_rows("SELECT TABLE_NAME AS tab, COLUMN_NAME AS field, IS_NULLABLE AS nullable, DATA_TYPE AS type, CHARACTER_MAXIMUM_LENGTH AS length".(JUSH=='sql'?", COLUMN_KEY = 'PRI' AS `primary`":"")."
FROM INFORMATION_SCHEMA.COLUMNS
WHERE TABLE_SCHEMA = ".q($_GET["ns"]!=""?$_GET["ns"]:DB)."
ORDER BY TABLE_NAME, ORDINAL_POSITION",$this->conn)as$K){$K["null"]=($K["nullable"]=="YES");$J[$K["tab"]][]=$K;}}return$J;}}add_driver("sqlite","SQLite");if(isset($_GET["sqlite"])){define('Adminer\DRIVER',"sqlite");if(class_exists("SQLite3")&&$_GET["ext"]!="pdo"){abstract
class
SqliteDb
extends
SqlDb{var$extension="SQLite3";private$link;function
attach($p,$V,$F){$this->link=new
\SQLite3($p);$Nj=$this->link->version();$this->server_info=$Nj["versionString"];return'';}function
query($H,$sj=false){$I=@$this->link->query($H);$this->error="";if(!$I){$this->errno=$this->link->lastErrorCode();$this->error=$this->link->lastErrorMsg();return
false;}elseif($I->numColumns())return
new
Result($I);$this->affected_rows=$this->link->changes();return
true;}function
quote($Q){return(is_utf8($Q)?"'".$this->link->escapeString($Q)."'":"x'".first(unpack('H*',$Q))."'");}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;}function
fetch_assoc(){return$this->result->fetchArray(SQLITE3_ASSOC);}function
fetch_row(){return$this->result->fetchArray(SQLITE3_NUM);}function
fetch_field(){$d=$this->offset++;$U=$this->result->columnType($d);return(object)array("name"=>$this->result->columnName($d),"type"=>($U==SQLITE3_TEXT?15:0),"charsetnr"=>($U==SQLITE3_BLOB?63:0),);}function
__destruct(){$this->result->finalize();}}}elseif(extension_loaded("pdo_sqlite")){abstract
class
SqliteDb
extends
PdoDb{var$extension="PDO_SQLite";function
attach($p,$V,$F){return$this->dsn(DRIVER.":$p","","");}}}if(class_exists('Adminer\SqliteDb')){class
Db
extends
SqliteDb{function
attach($p,$V,$F){parent::attach($p,$V,$F);$this->query("PRAGMA foreign_keys = 1");$this->query("PRAGMA busy_timeout = 500");return'';}function
select_db($p){if(is_readable($p)&&$this->query("ATTACH ".$this->quote(preg_match("~(^[/\\\\]|:)~",$p)?$p:dirname($_SERVER["SCRIPT_FILENAME"])."/$p")." AS a"))return!self::attach($p,'','');return
false;}}}class
Driver
extends
SqlDriver{static$extensions=array("SQLite3","PDO_SQLite");static$jush="sqlite";protected$types=array(array("integer"=>0,"real"=>0,"numeric"=>0,"text"=>0,"blob"=>0));var$insertFunctions=array();var$editFunctions=array("integer|real|numeric"=>"+/-","text"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("hex","length","lower","round","unixepoch","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){if($F!="")return
lang(22);return
parent::connect(":memory:","","");}function
__construct(Db$g){parent::__construct($g);if(min_version(3.31,0,$g))$this->generated=array("STORED","VIRTUAL");}function
structuredTypes(){return
array_keys($this->types[0]);}function
insertUpdate($R,array$L,array$G){$Kj=array();foreach($L
as$O)$Kj[]="(".implode(", ",$O).")";return
queries("REPLACE INTO ".table($R)." (".implode(", ",array_keys(reset($L))).") VALUES\n".implode(",\n",$Kj));}function
tableHelp($B,$_e=false){if($B=="sqlite_sequence")return"fileformat2.html#seqtab";if($B=="sqlite_master")return"fileformat2.html#$B";}function
checkConstraints($R){preg_match_all('~ CHECK *(\( *(((?>[^()]*[^() ])|(?1))*) *\))~',get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$this->conn),$df);return
array_combine($df[2],$df[2]);}function
allFields(){$J=array();foreach(tables_list()as$R=>$U){foreach(fields($R)as$n)$J[$R][]=$n;}return$J;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
array();}function
limit($H,$Z,$z,$C=0,$Vh=" "){return" $H$Z".($z?$Vh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Vh="\n"){return(preg_match('~^INTO~',$H)||get_val("SELECT sqlite_compileoption_used('ENABLE_UPDATE_DELETE_LIMIT')")?limit($H,$Z,1,0,$Vh):" $H WHERE rowid = (SELECT rowid FROM ".table($R).$Z.$Vh."LIMIT 1)");}function
db_collation($k,$lb){return
get_val("PRAGMA encoding");}function
logged_user(){return
get_current_user();}function
tables_list(){return
get_key_vals("SELECT name, type FROM sqlite_master WHERE type IN ('table', 'view') ORDER BY (name = 'sqlite_sequence'), name");}function
count_tables($j){return
array();}function
table_status($B=""){$J=array();foreach(get_rows("SELECT name AS Name, type AS Engine, 'rowid' AS Oid, '' AS Auto_increment FROM sqlite_master WHERE type IN ('table', 'view') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$K){$K["Rows"]=get_val("SELECT COUNT(*) FROM ".idf_escape($K["Name"]));$J[$K["Name"]]=$K;}foreach(get_rows("SELECT * FROM sqlite_sequence".($B!=""?" WHERE name = ".q($B):""),null,"")as$K)$J[$K["name"]]["Auto_increment"]=$K["seq"];return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return!get_val("SELECT sqlite_compileoption_used('OMIT_FOREIGN_KEY')");}function
fields($R){$J=array();$G="";foreach(get_rows("PRAGMA table_".(min_version(3.31)?"x":"")."info(".table($R).")")as$K){$B=$K["name"];$U=strtolower($K["type"]);$l=$K["dflt_value"];$J[$B]=array("field"=>$B,"type"=>(preg_match('~int~i',$U)?"integer":(preg_match('~char|clob|text~i',$U)?"text":(preg_match('~blob~i',$U)?"blob":(preg_match('~real|floa|doub~i',$U)?"real":"numeric")))),"full_type"=>$U,"default"=>(preg_match("~^'(.*)'$~",$l,$A)?str_replace("''","'",$A[1]):($l=="NULL"?null:$l)),"null"=>!$K["notnull"],"privileges"=>array("select"=>1,"insert"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["pk"],);if($K["pk"]){if($G!="")$J[$G]["auto_increment"]=false;elseif(preg_match('~^integer$~i',$U))$J[$B]["auto_increment"]=true;$G=$B;}}$mi=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R));$v='(("[^"]*+")+|[a-z0-9_]+)';preg_match_all('~'.$v.'\s+text\s+COLLATE\s+(\'[^\']+\'|\S+)~i',$mi,$df,PREG_SET_ORDER);foreach($df
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));if($J[$B])$J[$B]["collation"]=trim($A[3],"'");}preg_match_all('~'.$v.'\s.*GENERATED ALWAYS AS \((.+)\) (STORED|VIRTUAL)~i',$mi,$df,PREG_SET_ORDER);foreach($df
as$A){$B=str_replace('""','"',preg_replace('~^"|"$~','',$A[1]));$J[$B]["default"]=$A[3];$J[$B]["generated"]=strtoupper($A[4]);}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$mi=get_val("SELECT sql FROM sqlite_master WHERE type = 'table' AND name = ".q($R),0,$h);if(preg_match('~\bPRIMARY\s+KEY\s*\((([^)"]+|"[^"]*"|`[^`]*`)++)~i',$mi,$A)){$J[""]=array("type"=>"PRIMARY","columns"=>array(),"lengths"=>array(),"descs"=>array());preg_match_all('~((("[^"]*+")+|(?:`[^`]*+`)+)|(\S+))(\s+(ASC|DESC))?(,\s*|$)~i',$A[1],$df,PREG_SET_ORDER);foreach($df
as$A){$J[""]["columns"][]=idf_unescape($A[2]).$A[4];$J[""]["descs"][]=(preg_match('~DESC~i',$A[5])?'1':null);}}if(!$J){foreach(fields($R)as$B=>$n){if($n["primary"])$J[""]=array("type"=>"PRIMARY","columns"=>array($B),"lengths"=>array(),"descs"=>array(null));}}$qi=get_key_vals("SELECT name, sql FROM sqlite_master WHERE type = 'index' AND tbl_name = ".q($R),$h);foreach(get_rows("PRAGMA index_list(".table($R).")",$h)as$K){$B=$K["name"];$w=array("type"=>($K["unique"]?"UNIQUE":"INDEX"));$w["lengths"]=array();$w["descs"]=array();foreach(get_rows("PRAGMA index_info(".idf_escape($B).")",$h)as$Gh){$w["columns"][]=$Gh["name"];$w["descs"][]=null;}if(preg_match('~^CREATE( UNIQUE)? INDEX '.preg_quote(idf_escape($B).' ON '.idf_escape($R),'~').' \((.*)\)$~i',$qi[$B],$uh)){preg_match_all('/("[^"]*+")+( DESC)?/',$uh[2],$df);foreach($df[2]as$y=>$X){if($X)$w["descs"][$y]='1';}}if(!$J[""]||$w["type"]!="UNIQUE"||$w["columns"]!=$J[""]["columns"]||$w["descs"]!=$J[""]["descs"]||!preg_match("~^sqlite_~",$B))$J[$B]=$w;}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("PRAGMA foreign_key_list(".table($R).")")as$K){$q=&$J[$K["id"]];if(!$q)$q=$K;$q["source"][]=$K["from"];$q["target"][]=$K["to"];}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^`"[]+|`[^`]*`|"[^"]*")* AS\s+~iU','',get_val("SELECT sql FROM sqlite_master WHERE type = 'view' AND name = ".q($B))));}function
collations(){return(isset($_GET["create"])?get_vals("PRAGMA collation_list",1):array());}function
information_schema($k){return
false;}function
error(){return
h(connection()->error);}function
check_sqlite_name($B){$Rc="db|sdb|sqlite";if(!preg_match("~^[^\\0]*\\.($Rc)\$~",$B)){connection()->error=lang(23,str_replace("|",", ",$Rc));return
false;}return
true;}function
create_database($k,$c){if(file_exists($k)){connection()->error=lang(24);return
false;}if(!check_sqlite_name($k))return
false;try{$_=new
Db();$_->attach($k,'','');}catch(\Exception$Jc){connection()->error=$Jc->getMessage();return
false;}$_->query('PRAGMA encoding = "UTF-8"');$_->query('CREATE TABLE adminer (i)');$_->query('DROP TABLE adminer');return
true;}function
drop_databases($j){connection()->attach(":memory:",'','');foreach($j
as$k){if(!@unlink($k)){connection()->error=lang(24);return
false;}}return
true;}function
rename_database($B,$c){if(!check_sqlite_name($B))return
false;connection()->attach(":memory:",'','');connection()->error=lang(24);return@rename(DB,$B);}function
auto_increment(){return" PRIMARY KEY AUTOINCREMENT";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$Dj=($R==""||$ld);foreach($o
as$n){if($n[0]!=""||!$n[1]||$n[2]){$Dj=true;break;}}$b=array();$sg=array();foreach($o
as$n){if($n[1]){$b[]=($Dj?$n[1]:"ADD ".implode($n[1]));if($n[0]!="")$sg[$n[0]]=$n[1][0];}}if(!$Dj){foreach($b
as$X){if(!queries("ALTER TABLE ".table($R)." $X"))return
false;}if($R!=$B&&!queries("ALTER TABLE ".table($R)." RENAME TO ".table($B)))return
false;}elseif(!recreate_table($R,$B,$b,$sg,$ld,$Ba))return
false;if($Ba){queries("BEGIN");queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($B));if(!connection()->affected_rows)queries("INSERT INTO sqlite_sequence (name, seq) VALUES (".q($B).", $Ba)");queries("COMMIT");}return
true;}function
recreate_table($R,$B,array$o,array$sg,array$ld,$Ba="",$x=array(),$lc="",$la=""){if($R!=""){if(!$o){foreach(fields($R)as$y=>$n){if($x)$n["auto_increment"]=0;$o[]=process_field($n,$n);$sg[$y]=idf_escape($y);}}$Zg=false;foreach($o
as$n){if($n[6])$Zg=true;}$nc=array();foreach($x
as$y=>$X){if($X[2]=="DROP"){$nc[$X[1]]=true;unset($x[$y]);}}foreach(indexes($R)as$De=>$w){$e=array();foreach($w["columns"]as$y=>$d){if(!$sg[$d])continue
2;$e[]=$sg[$d].($w["descs"][$y]?" DESC":"");}if(!$nc[$De]){if($w["type"]!="PRIMARY"||!$Zg)$x[]=array($w["type"],$De,$e);}}foreach($x
as$y=>$X){if($X[0]=="PRIMARY"){unset($x[$y]);$ld[]="  PRIMARY KEY (".implode(", ",$X[2]).")";}}foreach(foreign_keys($R)as$De=>$q){foreach($q["source"]as$y=>$d){if(!$sg[$d])continue
2;$q["source"][$y]=idf_unescape($sg[$d]);}if(!isset($ld[" $De"]))$ld[]=" ".format_foreign_key($q);}queries("BEGIN");}$Wa=array();foreach($o
as$n){if(preg_match('~GENERATED~',$n[3]))unset($sg[array_search($n[0],$sg)]);$Wa[]="  ".implode($n);}$Wa=array_merge($Wa,array_filter($ld));foreach(driver()->checkConstraints($R)as$Ya){if($Ya!=$lc)$Wa[]="  CHECK ($Ya)";}if($la)$Wa[]="  CHECK ($la)";$Oi=($R==$B?"adminer_$B":$B);if(!queries("CREATE TABLE ".table($Oi)." (\n".implode(",\n",$Wa)."\n)"))return
false;if($R!=""){if($sg&&!queries("INSERT INTO ".table($Oi)." (".implode(", ",$sg).") SELECT ".implode(", ",array_map('Adminer\idf_escape',array_keys($sg)))." FROM ".table($R)))return
false;$oj=array();foreach(triggers($R)as$mj=>$Vi){$lj=trigger($mj,$R);$oj[]="CREATE TRIGGER ".idf_escape($mj)." ".implode(" ",$Vi)." ON ".table($B)."\n$lj[Statement]";}$Ba=$Ba?"":get_val("SELECT seq FROM sqlite_sequence WHERE name = ".q($R));if(!queries("DROP TABLE ".table($R))||($R==$B&&!queries("ALTER TABLE ".table($Oi)." RENAME TO ".table($B)))||!alter_indexes($B,$x))return
false;if($Ba)queries("UPDATE sqlite_sequence SET seq = $Ba WHERE name = ".q($B));foreach($oj
as$lj){if(!queries($lj))return
false;}queries("COMMIT");}return
true;}function
index_sql($R,$U,$B,$e){return"CREATE $U ".($U!="INDEX"?"INDEX ":"").idf_escape($B!=""?$B:uniqid($R."_"))." ON ".table($R)." $e";}function
alter_indexes($R,$b){foreach($b
as$G){if($G[0]=="PRIMARY")return
recreate_table($R,$R,array(),array(),array(),"",$b);}foreach(array_reverse($b)as$X){if(!queries($X[2]=="DROP"?"DROP INDEX ".idf_escape($X[1]):index_sql($R,$X[0],$X[1],"(".implode(", ",$X[2]).")")))return
false;}return
true;}function
truncate_tables($T){return
apply_queries("DELETE FROM",$T);}function
drop_views($Pj){return
apply_queries("DROP VIEW",$Pj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
move_tables($T,$Pj,$Mi){return
false;}function
trigger($B,$R){if($B=="")return
array("Statement"=>"BEGIN\n\t;\nEND");$v='(?:[^`"\s]+|`[^`]*`|"[^"]*")+';$nj=trigger_options();preg_match("~^CREATE\\s+TRIGGER\\s*$v\\s*(".implode("|",$nj["Timing"]).")\\s+([a-z]+)(?:\\s+OF\\s+($v))?\\s+ON\\s*$v\\s*(?:FOR\\s+EACH\\s+ROW\\s)?(.*)~is",get_val("SELECT sql FROM sqlite_master WHERE type = 'trigger' AND name = ".q($B)),$A);$Pf=$A[3];return
array("Timing"=>strtoupper($A[1]),"Event"=>strtoupper($A[2]).($Pf?" OF":""),"Of"=>idf_unescape($Pf),"Trigger"=>$B,"Statement"=>$A[4],);}function
triggers($R){$J=array();$nj=trigger_options();foreach(get_rows("SELECT * FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R))as$K){preg_match('~^CREATE\s+TRIGGER\s*(?:[^`"\s]+|`[^`]*`|"[^"]*")+\s*('.implode("|",$nj["Timing"]).')\s*(.*?)\s+ON\b~i',$K["sql"],$A);$J[$K["name"]]=array($A[1],$A[2]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
begin(){return
queries("BEGIN");}function
last_id($I){return
get_val("SELECT LAST_INSERT_ROWID()");}function
explain($g,$H){return$g->query("EXPLAIN QUERY PLAN $H");}function
found_rows($S,$Z){}function
types(){return
array();}function
create_sql($R,$Ba,$wi){$J=get_val("SELECT sql FROM sqlite_master WHERE type IN ('table', 'view') AND name = ".q($R));foreach(indexes($R)as$B=>$w){if($B=='')continue;$J
.=";\n\n".index_sql($R,$w['type'],$B,"(".implode(", ",array_map('Adminer\idf_escape',$w['columns'])).")");}return$J;}function
truncate_sql($R){return"DELETE FROM ".table($R);}function
use_sql($Pb,$wi=""){}function
trigger_sql($R){return
implode(get_vals("SELECT sql || ';;\n' FROM sqlite_master WHERE type = 'trigger' AND tbl_name = ".q($R)));}function
show_variables(){$J=array();foreach(get_rows("PRAGMA pragma_list")as$K){$B=$K["name"];if($B!="pragma_list"&&$B!="compile_options"){$J[$B]=array($B,'');foreach(get_rows("PRAGMA $B")as$K)$J[$B][1].=implode(", ",$K)."\n";}}return$J;}function
show_status(){$J=array();foreach(get_vals("PRAGMA compile_options")as$eg)$J[]=explode("=",$eg,2)+array('','');return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(check|columns|database|drop_col|dump|indexes|descidx|move_col|sql|status|table|trigger|variables|view|view_trigger)$~',$Wc);}}add_driver("pgsql","PostgreSQL");if(isset($_GET["pgsql"])){define('Adminer\DRIVER',"pgsql");if(extension_loaded("pgsql")&&$_GET["ext"]!="pdo"){class
PgsqlDb
extends
SqlDb{var$extension="PgSQL";var$timeout=0;private$link,$string,$database=true;function
_error($Ec,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$k=adminer()->database();set_error_handler(array($this,'_error'));list($Od,$Qg)=host_port(addcslashes($N,"'\\"));$this->string="host='$Od'".($Qg?" port='$Qg'":"")." user='".addcslashes($V,"'\\")."' password='".addcslashes($F,"'\\")."'";$ri=adminer()->connectSsl();if(isset($ri["mode"]))$this->string
.=" sslmode='".$ri["mode"]."'";$this->link=@pg_connect("$this->string dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'",PGSQL_CONNECT_FORCE_NEW);if(!$this->link&&$k!=""){$this->database=false;$this->link=@pg_connect("$this->string dbname='postgres'",PGSQL_CONNECT_FORCE_NEW);}restore_error_handler();if($this->link)pg_set_client_encoding($this->link,"UTF8");return($this->link?'':$this->error);}function
quote($Q){return(function_exists('pg_escape_literal')?pg_escape_literal($this->link,$Q):"'".pg_escape_string($this->link,$Q)."'");}function
value($X,array$n){return($n["type"]=="bytea"&&$X!==null?pg_unescape_bytea($X):$X);}function
select_db($Pb){if($Pb==adminer()->database())return$this->database;$J=@pg_connect("$this->string dbname='".addcslashes($Pb,"'\\")."'",PGSQL_CONNECT_FORCE_NEW);if($J)$this->link=$J;return$J;}function
close(){$this->link=@pg_connect("$this->string dbname='postgres'");}function
query($H,$sj=false){$I=@pg_query($this->link,$H);$this->error="";if(!$I){$this->error=pg_last_error($this->link);$J=false;}elseif(!pg_num_fields($I)){$this->affected_rows=pg_affected_rows($I);$J=true;}else$J=new
Result($I);if($this->timeout){$this->timeout=0;$this->query("RESET statement_timeout");}return$J;}function
warnings(){return
h(pg_last_notice($this->link));}function
copyFrom($R,array$L){$this->error='';set_error_handler(function($Ec,$m){$this->error=(ini_bool('html_errors')?html_entity_decode($m):$m);return
true;});$J=pg_copy_from($this->link,$R,$L);restore_error_handler();return$J;}}class
Result{var$num_rows;private$result,$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=pg_num_rows($I);}function
fetch_assoc(){return
pg_fetch_assoc($this->result);}function
fetch_row(){return
pg_fetch_row($this->result);}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->orgtable=pg_field_table($this->result,$d);$J->name=pg_field_name($this->result,$d);$U=pg_field_type($this->result,$d);$J->type=(preg_match(number_type(),$U)?0:15);$J->charsetnr=($U=="bytea"?63:0);return$J;}function
__destruct(){pg_free_result($this->result);}}}elseif(extension_loaded("pdo_pgsql")){class
PgsqlDb
extends
PdoDb{var$extension="PDO_PgSQL";var$timeout=0;function
attach($N,$V,$F){$k=adminer()->database();list($Od,$Qg)=host_port(addcslashes($N,"'\\"));$pc="pgsql:host='$Od'".($Qg?" port='$Qg'":"")." client_encoding=utf8 dbname='".($k!=""?addcslashes($k,"'\\"):"postgres")."'";$ri=adminer()->connectSsl();if(isset($ri["mode"]))$pc
.=" sslmode='".$ri["mode"]."'";return$this->dsn($pc,$V,$F);}function
select_db($Pb){return(adminer()->database()==$Pb);}function
query($H,$sj=false){$J=parent::query($H,$sj);if($this->timeout){$this->timeout=0;parent::query("RESET statement_timeout");}return$J;}function
warnings(){}function
copyFrom($R,array$L){$J=$this->pdo->pgsqlCopyFromArray($R,$L);$this->error=idx($this->pdo->errorInfo(),2)?:'';return$J;}function
close(){}}}if(class_exists('Adminer\PgsqlDb')){class
Db
extends
PgsqlDb{function
multi_query($H){if(preg_match('~\bCOPY\s+(.+?)\s+FROM\s+stdin;\n?(.*)\n\\\\\.$~is',str_replace("\r\n","\n",$H),$A)){$L=explode("\n",$A[2]);$this->affected_rows=count($L);return$this->copyFrom($A[1],$L);}return
parent::multi_query($H);}}}class
Driver
extends
SqlDriver{static$extensions=array("PgSQL","PDO_PgSQL");static$jush="pgsql";var$operators=array("=","<",">","<=",">=","!=","~","!~","LIKE","LIKE %%","ILIKE","ILIKE %%","IN","IS NULL","NOT LIKE","NOT ILIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","lower","round","to_hex","to_timestamp","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$nsOid="(SELECT oid FROM pg_namespace WHERE nspname = current_schema())";static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g))return$g;$Nj=get_val("SELECT version()",0,$g);$g->flavor=(preg_match('~CockroachDB~',$Nj)?'cockroach':'');$g->server_info=preg_replace('~^\D*([\d.]+[-\w]*).*~','\1',$Nj);if(min_version(9,0,$g))$g->query("SET application_name = 'Adminer'");if($g->flavor=='cockroach')add_driver(DRIVER,"CockroachDB");return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("smallint"=>5,"integer"=>10,"bigint"=>19,"boolean"=>1,"numeric"=>0,"real"=>7,"double precision"=>16,"money"=>20),lang(26)=>array("date"=>13,"time"=>17,"timestamp"=>20,"timestamptz"=>21,"interval"=>0),lang(27)=>array("character"=>0,"character varying"=>0,"text"=>0,"tsquery"=>0,"tsvector"=>0,"uuid"=>0,"xml"=>0),lang(28)=>array("bit"=>0,"bit varying"=>0,"bytea"=>0),lang(29)=>array("cidr"=>43,"inet"=>43,"macaddr"=>17,"macaddr8"=>23,"txid_snapshot"=>0),lang(30)=>array("box"=>0,"circle"=>0,"line"=>0,"lseg"=>0,"path"=>0,"point"=>0,"polygon"=>0),);if(min_version(9.2,0,$g)){$this->types[lang(27)]["json"]=4294967295;if(min_version(9.4,0,$g))$this->types[lang(27)]["jsonb"]=4294967295;}$this->insertFunctions=array("char"=>"md5","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date|time"=>"+ interval/- interval","char|text"=>"||",);if(min_version(12,0,$g))$this->generated=array("STORED");$this->partitionBy=array("RANGE","LIST");if(!$g->flavor)$this->partitionBy[]="HASH";}function
enumLength(array$n){$Ac=$this->types[lang(6)][$n["type"]];return($Ac?type_values($Ac):"");}function
setUserTypes($rj){$this->types[lang(6)]=array_flip($rj);}function
insertReturning($R){$Ba=array_filter(fields($R),function($n){return$n['auto_increment'];});return(count($Ba)==1?" RETURNING ".idf_escape(key($Ba)):"");}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$_j=array();$Z=array();foreach($O
as$y=>$X){$_j[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$_j)." WHERE ".implode(" AND ",$Z))&&$this->conn->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
slowQuery($H,$Ui){$this->conn->query("SET statement_timeout = ".(1000*$Ui));$this->conn->timeout=1000*$Ui;return$H;}function
convertSearch($v,array$X,array$n){$Ri="char|text";if(strpos($X["op"],"LIKE")===false)$Ri
.="|date|time(stamp)?|boolean|uuid|inet|cidr|macaddr|".number_type();return(preg_match("~$Ri~",$n["type"])?$v:"CAST($v AS text)");}function
quoteBinary($Hh){return"'\\x".bin2hex($Hh)."'";}function
warnings(){return$this->conn->warnings();}function
tableHelp($B,$_e=false){$Ve=array("information_schema"=>"infoschema","pg_catalog"=>($_e?"view":"catalog"),);$_=$Ve[$_GET["ns"]];if($_)return"$_-".str_replace("_","-",$B).".html";}function
inheritsFrom($R){return
get_vals("SELECT relname FROM pg_class JOIN pg_inherits ON inhparent = oid WHERE inhrelid = ".$this->tableOid($R)." ORDER BY 1");}function
inheritedTables($R){return
get_vals("SELECT relname FROM pg_inherits JOIN pg_class ON inhrelid = oid WHERE inhparent = ".$this->tableOid($R)." ORDER BY 1");}function
partitionsInfo($R){$K=(min_version(10)?$this->conn->query("SELECT * FROM pg_partitioned_table WHERE partrelid = ".$this->tableOid($R))->fetch_assoc():null);if($K){$_a=get_vals("SELECT attname FROM pg_attribute WHERE attrelid = $K[partrelid] AND attnum IN (".str_replace(" ",", ",$K["partattrs"]).")");$Qa=array('h'=>'HASH','l'=>'LIST','r'=>'RANGE');return
array("partition_by"=>$Qa[$K["partstrat"]],"partition"=>implode(", ",array_map('Adminer\idf_escape',$_a)),);}return
array();}function
tableOid($R){return"(SELECT oid FROM pg_class WHERE relnamespace = $this->nsOid AND relname = ".q($R)." AND relkind IN ('r', 'm', 'v', 'f', 'p'))";}function
indexAlgorithms(array$Bi){static$J=array();if(!$J)$J=get_vals("SELECT amname FROM pg_am".(min_version(9.6)?" WHERE amtype = 'i'":"")." ORDER BY amname = '".($this->conn->flavor=='cockroach'?"prefix":"btree")."' DESC, amname");return$J;}function
supportsIndex(array$S){return$S["Engine"]!="view";}function
hasCStyleEscapes(){static$Sa;if($Sa===null)$Sa=(get_val("SHOW standard_conforming_strings",0,$this->conn)=="off");return$Sa;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT datname FROM pg_database
WHERE datallowconn = TRUE AND has_database_privilege(datname, 'CONNECT')
ORDER BY datname");}function
limit($H,$Z,$z,$C=0,$Vh=" "){return" $H$Z".($z?$Vh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Vh="\n"){return(preg_match('~^INTO~',$H)?limit($H,$Z,1,0,$Vh):" $H".(is_view(table_status1($R))?$Z:$Vh."WHERE ctid = (SELECT ctid FROM ".table($R).$Z.$Vh."LIMIT 1)"));}function
db_collation($k,$lb){return
get_val("SELECT datcollate FROM pg_database WHERE datname = ".q($k));}function
logged_user(){return
get_val("SELECT user");}function
tables_list(){$H="SELECT table_name, table_type FROM information_schema.tables WHERE table_schema = current_schema()";if(support("materializedview"))$H
.="
UNION ALL
SELECT matviewname, 'MATERIALIZED VIEW'
FROM pg_matviews
WHERE schemaname = current_schema()";$H
.="
ORDER BY 1";return
get_key_vals($H);}function
count_tables($j){$J=array();foreach($j
as$k){if(connection()->select_db($k))$J[$k]=count(tables_list());}return$J;}function
table_status($B=""){static$Hd;if($Hd===null)$Hd=get_val("SELECT 'pg_table_size'::regproc");$J=array();foreach(get_rows("SELECT
	relname AS \"Name\",
	CASE relkind WHEN 'v' THEN 'view' WHEN 'm' THEN 'materialized view' ELSE 'table' END AS \"Engine\"".($Hd?",
	pg_table_size(c.oid) AS \"Data_length\",
	pg_indexes_size(c.oid) AS \"Index_length\"":"").",
	obj_description(c.oid, 'pg_class') AS \"Comment\",
	".(min_version(12)?"''":"CASE WHEN relhasoids THEN 'oid' ELSE '' END")." AS \"Oid\",
	reltuples AS \"Rows\",
	".(min_version(10)?"relispartition::int AS partition,":"")."
	current_schema() AS nspname
FROM pg_class c
WHERE relkind IN ('r', 'm', 'v', 'f', 'p')
AND relnamespace = ".driver()->nsOid."
".($B!=""?"AND relname = ".q($B):"ORDER BY relname"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return
in_array($S["Engine"],array("view","materialized view"));}function
fk_support($S){return
true;}function
fields($R){$J=array();$ta=array('timestamp without time zone'=>'timestamp','timestamp with time zone'=>'timestamptz',);foreach(get_rows("SELECT
	a.attname AS field,
	format_type(a.atttypid, a.atttypmod) AS full_type,
	pg_get_expr(d.adbin, d.adrelid) AS default,
	a.attnotnull::int,
	col_description(a.attrelid, a.attnum) AS comment".(min_version(10)?",
	a.attidentity".(min_version(12)?",
	a.attgenerated":""):"")."
FROM pg_attribute a
LEFT JOIN pg_attrdef d ON a.attrelid = d.adrelid AND a.attnum = d.adnum
WHERE a.attrelid = ".driver()->tableOid($R)."
AND NOT a.attisdropped
AND a.attnum > 0
ORDER BY a.attnum")as$K){preg_match('~([^([]+)(\((.*)\))?([a-z ]+)?((\[[0-9]*])*)$~',$K["full_type"],$A);list(,$U,$Re,$K["length"],$ma,$xa)=$A;$K["length"].=$xa;$ab=$U.$ma;if(isset($ta[$ab])){$K["type"]=$ta[$ab];$K["full_type"]=$K["type"].$Re.$xa;}else{$K["type"]=$U;$K["full_type"]=$K["type"].$Re.$ma.$xa;}if(in_array($K['attidentity'],array('a','d')))$K['default']='GENERATED '.($K['attidentity']=='d'?'BY DEFAULT':'ALWAYS').' AS IDENTITY';$K["generated"]=($K["attgenerated"]=="s"?"STORED":"");$K["null"]=!$K["attnotnull"];$K["auto_increment"]=$K['attidentity']||preg_match('~^nextval\(~i',$K["default"])||preg_match('~^unique_rowid\(~',$K["default"]);$K["privileges"]=array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1);if(preg_match('~(.+)::[^,)]+(.*)~',$K["default"],$A))$K["default"]=($A[1]=="NULL"?null:idf_unescape($A[1]).$A[2]);$J[$K["field"]]=$K;}return$J;}function
indexes($R,$h=null){$h=connection($h);$J=array();$Ei=driver()->tableOid($R);$e=get_key_vals("SELECT attnum, attname FROM pg_attribute WHERE attrelid = $Ei AND attnum > 0",$h);foreach(get_rows("SELECT relname, indisunique::int, indisprimary::int, indkey, indoption, amname, pg_get_expr(indpred, indrelid, true) AS partial, pg_get_expr(indexprs, indrelid) AS indexpr
FROM pg_index
JOIN pg_class ON indexrelid = oid
JOIN pg_am ON pg_am.oid = pg_class.relam
WHERE indrelid = $Ei
ORDER BY indisprimary DESC, indisunique DESC",$h)as$K){$vh=$K["relname"];$J[$vh]["type"]=($K["partial"]?"INDEX":($K["indisprimary"]?"PRIMARY":($K["indisunique"]?"UNIQUE":"INDEX")));$J[$vh]["columns"]=array();$J[$vh]["descs"]=array();$J[$vh]["algorithm"]=$K["amname"];$J[$vh]["partial"]=$K["partial"];$ge=preg_split('~(?<=\)), (?=\()~',$K["indexpr"]);foreach(explode(" ",$K["indkey"])as$he)$J[$vh]["columns"][]=($he?$e[$he]:array_shift($ge));foreach(explode(" ",$K["indoption"])as$ie)$J[$vh]["descs"][]=(intval($ie)&1?'1':null);$J[$vh]["lengths"]=array();}return$J;}function
foreign_keys($R){$J=array();foreach(get_rows("SELECT conname, condeferrable::int AS deferrable, pg_get_constraintdef(oid) AS definition
FROM pg_constraint
WHERE conrelid = ".driver()->tableOid($R)."
AND contype = 'f'::char
ORDER BY conkey, conname")as$K){if(preg_match('~FOREIGN KEY\s*\((.+)\)\s*REFERENCES (.+)\((.+)\)(.*)$~iA',$K['definition'],$A)){$K['source']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$A[1])));if(preg_match('~^(("([^"]|"")+"|[^"]+)\.)?"?("([^"]|"")+"|[^"]+)$~',$A[2],$bf)){$K['ns']=idf_unescape($bf[2]);$K['table']=idf_unescape($bf[4]);}$K['target']=array_map('Adminer\idf_unescape',array_map('trim',explode(',',$A[3])));$K['on_delete']=(preg_match("~ON DELETE (".driver()->onActions.")~",$A[4],$bf)?$bf[1]:'NO ACTION');$K['on_update']=(preg_match("~ON UPDATE (".driver()->onActions.")~",$A[4],$bf)?$bf[1]:'NO ACTION');$J[$K['conname']]=$K;}}return$J;}function
view($B){return
array("select"=>trim(get_val("SELECT pg_get_viewdef(".driver()->tableOid($B).")")));}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="information_schema";}function
error(){$J=h(connection()->error);if(preg_match('~^(.*\n)?([^\n]*)\n( *)\^(\n.*)?$~s',$J,$A))$J=$A[1].preg_replace('~((?:[^&]|&[^;]*;){'.strlen($A[3]).'})(.*)~','\1<b>\2</b>',$A[2]).$A[4];return
nl_br($J);}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" ENCODING ".idf_escape($c):""));}function
drop_databases($j){connection()->close();return
apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');}function
rename_database($B,$c){connection()->close();return
queries("ALTER DATABASE ".idf_escape(DB)." RENAME TO ".idf_escape($B));}function
auto_increment(){return"";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$b=array();$ih=array();if($R!=""&&$R!=$B)$ih[]="ALTER TABLE ".table($R)." RENAME TO ".table($B);$Wh="";foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b[]="DROP $d";else{$Jj=$X[5];unset($X[5]);if($n[0]==""){if(isset($X[6]))$X[1]=($X[1]==" bigint"?" big":($X[1]==" smallint"?" small":" "))."serial";$b[]=($R!=""?"ADD ":"  ").implode($X);if(isset($X[6]))$b[]=($R!=""?"ADD":" ")." PRIMARY KEY ($X[0])";}else{if($d!=$X[0])$ih[]="ALTER TABLE ".table($B)." RENAME $d TO $X[0]";$b[]="ALTER $d TYPE$X[1]";$Xh=$R."_".idf_unescape($X[0])."_seq";$b[]="ALTER $d ".($X[3]?"SET".preg_replace('~GENERATED ALWAYS(.*) STORED~','EXPRESSION\1',$X[3]):(isset($X[6])?"SET DEFAULT nextval(".q($Xh).")":"DROP DEFAULT"));if(isset($X[6]))$Wh="CREATE SEQUENCE IF NOT EXISTS ".idf_escape($Xh)." OWNED BY ".idf_escape($R).".$X[0]";$b[]="ALTER $d ".($X[2]==" NULL"?"DROP NOT":"SET").$X[2];}if($n[0]!=""||$Jj!="")$ih[]="COMMENT ON COLUMN ".table($B).".$X[0] IS ".($Jj!=""?substr($Jj,9):"''");}}$b=array_merge($b,$ld);if($R==""){$P="";if($E){$gb=(connection()->flavor=='cockroach');$P=" PARTITION BY $E[partition_by]($E[partition])";if($E["partition_by"]=='HASH'){$Gg=+$E["partitions"];for($t=0;$t<$Gg;$t++)$ih[]="CREATE TABLE ".idf_escape($B."_$t")." PARTITION OF ".idf_escape($B)." FOR VALUES WITH (MODULUS $Gg, REMAINDER $t)";}else{$Yg="MINVALUE";foreach($E["partition_names"]as$t=>$X){$Y=$E["partition_values"][$t];$Cg=" VALUES ".($E["partition_by"]=='LIST'?"IN ($Y)":"FROM ($Yg) TO ($Y)");if($gb)$P
.=($t?",":" (")."\n  PARTITION ".(preg_match('~^DEFAULT$~i',$X)?$X:idf_escape($X))."$Cg";else$ih[]="CREATE TABLE ".idf_escape($B."_$X")." PARTITION OF ".idf_escape($B)." FOR$Cg";$Yg=$Y;}$P
.=($gb?"\n)":"");}}array_unshift($ih,"CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)$P");}elseif($b)array_unshift($ih,"ALTER TABLE ".table($R)."\n".implode(",\n",$b));if($Wh)array_unshift($ih,$Wh);if($qb!==null)$ih[]="COMMENT ON TABLE ".table($B)." IS ".q($qb);foreach($ih
as$H){if(!queries($H))return
false;}return
true;}function
alter_indexes($R,$b){$i=array();$kc=array();$ih=array();foreach($b
as$X){if($X[0]!="INDEX")$i[]=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");elseif($X[2]=="DROP")$kc[]=idf_escape($X[1]);else$ih[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R).($X[3]?" USING $X[3]":"")." (".implode(", ",$X[2]).")".($X[4]?" WHERE $X[4]":"");}if($i)array_unshift($ih,"ALTER TABLE ".table($R).implode(",",$i));if($kc)array_unshift($ih,"DROP INDEX ".implode(", ",$kc));foreach($ih
as$H){if(!queries($H))return
false;}return
true;}function
truncate_tables($T){return
queries("TRUNCATE ".implode(", ",array_map('Adminer\table',$T)));}function
drop_views($Pj){return
drop_tables($Pj);}function
drop_tables($T){foreach($T
as$R){$P=table_status1($R);if(!queries("DROP ".strtoupper($P["Engine"])." ".table($R)))return
false;}return
true;}function
move_tables($T,$Pj,$Mi){foreach(array_merge($T,$Pj)as$R){$P=table_status1($R);if(!queries("ALTER ".strtoupper($P["Engine"])." ".table($R)." SET SCHEMA ".idf_escape($Mi)))return
false;}return
true;}function
trigger($B,$R){if($B=="")return
array("Statement"=>"EXECUTE PROCEDURE ()");$e=array();$Z="WHERE trigger_schema = current_schema() AND event_object_table = ".q($R)." AND trigger_name = ".q($B);foreach(get_rows("SELECT * FROM information_schema.triggered_update_columns $Z")as$K)$e[]=$K["event_object_column"];$J=array();foreach(get_rows('SELECT trigger_name AS "Trigger", action_timing AS "Timing", event_manipulation AS "Event", \'FOR EACH \' || action_orientation AS "Type", action_statement AS "Statement"
FROM information_schema.triggers'."
$Z
ORDER BY event_manipulation DESC")as$K){if($e&&$K["Event"]=="UPDATE")$K["Event"].=" OF";$K["Of"]=implode(", ",$e);if($J)$K["Event"].=" OR $J[Event]";$J=$K;}return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT * FROM information_schema.triggers WHERE trigger_schema = current_schema() AND event_object_table = ".q($R))as$K){$lj=trigger($K["trigger_name"],$R);$J[$lj["Trigger"]]=array($lj["Timing"],$lj["Event"]);}return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","UPDATE OF","DELETE","INSERT OR UPDATE","INSERT OR UPDATE OF","DELETE OR INSERT","DELETE OR UPDATE","DELETE OR UPDATE OF","DELETE OR INSERT OR UPDATE","DELETE OR INSERT OR UPDATE OF"),"Type"=>array("FOR EACH ROW","FOR EACH STATEMENT"),);}function
routine($B,$U){$L=get_rows('SELECT routine_definition AS definition, LOWER(external_language) AS language, *
FROM information_schema.routines
WHERE routine_schema = current_schema() AND specific_name = '.q($B));$J=idx($L,0,array());$J["returns"]=array("type"=>$J["type_udt_name"]);$J["fields"]=get_rows('SELECT COALESCE(parameter_name, ordinal_position::text) AS field, data_type AS type, character_maximum_length AS length, parameter_mode AS inout
FROM information_schema.parameters
WHERE specific_schema = current_schema() AND specific_name = '.q($B).'
ORDER BY ordinal_position');return$J;}function
routines(){return
get_rows('SELECT specific_name AS "SPECIFIC_NAME", routine_type AS "ROUTINE_TYPE", routine_name AS "ROUTINE_NAME", type_udt_name AS "DTD_IDENTIFIER"
FROM information_schema.routines
WHERE routine_schema = current_schema()
ORDER BY SPECIFIC_NAME');}function
routine_languages(){return
get_vals("SELECT LOWER(lanname) FROM pg_catalog.pg_language");}function
routine_id($B,$K){$J=array();foreach($K["fields"]as$n){$Re=$n["length"];$J[]=$n["type"].($Re?"($Re)":"");}return
idf_escape($B)."(".implode(", ",$J).")";}function
last_id($I){$K=(is_object($I)?$I->fetch_row():array());return($K?$K[0]:0);}function
explain($g,$H){return$g->query("EXPLAIN $H");}function
found_rows($S,$Z){if(preg_match("~ rows=([0-9]+)~",get_val("EXPLAIN SELECT * FROM ".idf_escape($S["Name"]).($Z?" WHERE ".implode(" AND ",$Z):"")),$uh))return$uh[1];}function
types(){return
get_key_vals("SELECT oid, typname
FROM pg_type
WHERE typnamespace = ".driver()->nsOid."
AND typtype IN ('b','d','e')
AND typelem = 0");}function
type_values($u){$Dc=get_vals("SELECT enumlabel FROM pg_enum WHERE enumtypid = $u ORDER BY enumsortorder");return($Dc?"'".implode("', '",array_map('addslashes',$Dc))."'":"");}function
schemas(){return
get_vals("SELECT nspname FROM pg_namespace ORDER BY nspname");}function
get_schema(){return
get_val("SELECT current_schema()");}function
set_schema($Jh,$h=null){if(!$h)$h=connection();$J=$h->query("SET search_path TO ".idf_escape($Jh));driver()->setUserTypes(types());return$J;}function
foreign_keys_sql($R){$J="";$P=table_status1($R);$hd=foreign_keys($R);ksort($hd);foreach($hd
as$gd=>$fd)$J
.="ALTER TABLE ONLY ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." ADD CONSTRAINT ".idf_escape($gd)." $fd[definition] ".($fd['deferrable']?'DEFERRABLE':'NOT DEFERRABLE').";\n";return($J?"$J\n":$J);}function
create_sql($R,$Ba,$wi){$_h=array();$Yh=array();$P=table_status1($R);if(is_view($P)){$Oj=view($R);return
rtrim("CREATE VIEW ".idf_escape($R)." AS $Oj[select]",";");}$o=fields($R);if(count($P)<2||empty($o))return
false;$J="CREATE TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." (\n    ";foreach($o
as$n){$Ag=idf_escape($n['field']).' '.$n['full_type'].default_value($n).($n['null']?"":" NOT NULL");$_h[]=$Ag;if(preg_match('~nextval\(\'([^\']+)\'\)~',$n['default'],$df)){$Xh=$df[1];$li=first(get_rows((min_version(10)?"SELECT *, cache_size AS cache_value FROM pg_sequences WHERE schemaname = current_schema() AND sequencename = ".q(idf_unescape($Xh)):"SELECT * FROM $Xh"),null,"-- "));$Yh[]=($wi=="DROP+CREATE"?"DROP SEQUENCE IF EXISTS $Xh;\n":"")."CREATE SEQUENCE $Xh INCREMENT $li[increment_by] MINVALUE $li[min_value] MAXVALUE $li[max_value]".($Ba&&$li['last_value']?" START ".($li["last_value"]+1):"")." CACHE $li[cache_value];";}}if(!empty($Yh))$J=implode("\n\n",$Yh)."\n\n$J";$G="";foreach(indexes($R)as$ee=>$w){if($w['type']=='PRIMARY'){$G=$ee;$_h[]="CONSTRAINT ".idf_escape($ee)." PRIMARY KEY (".implode(', ',array_map('Adminer\idf_escape',$w['columns'])).")";}}foreach(driver()->checkConstraints($R)as$wb=>$yb)$_h[]="CONSTRAINT ".idf_escape($wb)." CHECK $yb";$J
.=implode(",\n    ",$_h)."\n)";$Cg=driver()->partitionsInfo($P['Name']);if($Cg)$J
.="\nPARTITION BY $Cg[partition_by]($Cg[partition])";$J
.="\nWITH (oids = ".($P['Oid']?'true':'false').");";if($P['Comment'])$J
.="\n\nCOMMENT ON TABLE ".idf_escape($P['nspname']).".".idf_escape($P['Name'])." IS ".q($P['Comment']).";";foreach($o
as$Yc=>$n){if($n['comment'])$J
.="\n\nCOMMENT ON COLUMN ".idf_escape($P['nspname']).".".idf_escape($P['Name']).".".idf_escape($Yc)." IS ".q($n['comment']).";";}foreach(get_rows("SELECT indexdef FROM pg_catalog.pg_indexes WHERE schemaname = current_schema() AND tablename = ".q($R).($G?" AND indexname != ".q($G):""),null,"-- ")as$K)$J
.="\n\n$K[indexdef];";return
rtrim($J,';');}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
trigger_sql($R){$P=table_status1($R);$J="";foreach(triggers($R)as$kj=>$jj){$lj=trigger($kj,$P['Name']);$J
.="\nCREATE TRIGGER ".idf_escape($lj['Trigger'])." $lj[Timing] $lj[Event] ON ".idf_escape($P["nspname"]).".".idf_escape($P['Name'])." $lj[Type] $lj[Statement];;\n";}return$J;}function
use_sql($Pb,$wi=""){$B=idf_escape($Pb);$J="";if(preg_match('~CREATE~',$wi)){if($wi=="DROP+CREATE")$J="DROP DATABASE IF EXISTS $B;\n";$J
.="CREATE DATABASE $B;\n";}return"$J\\connect $B";}function
show_variables(){return
get_rows("SHOW ALL");}function
process_list(){return
get_rows("SELECT * FROM pg_stat_activity ORDER BY ".(min_version(9.2)?"pid":"procpid"));}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(check|columns|comment|database|drop_col|dump|descidx|indexes|kill|partial_indexes|routine|scheme|sequence|sql|table|trigger|type|variables|view'.(min_version(9.3)?'|materializedview':'').(min_version(11)?'|procedure':'').(connection()->flavor=='cockroach'?'':'|processlist').')$~',$Wc);}function
kill_process($X){return
queries("SELECT pg_terminate_backend(".number($X).")");}function
connection_id(){return"SELECT pg_backend_pid()";}function
max_connections(){return
get_val("SHOW max_connections");}}add_driver("oracle","Oracle (beta)");if(isset($_GET["oracle"])){define('Adminer\DRIVER',"oracle");if(extension_loaded("oci8")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="oci8";var$_current_db;private$link;function
_error($Ec,$m){if(ini_bool("html_errors"))$m=html_entity_decode(strip_tags($m));$m=preg_replace('~^[^:]*: ~','',$m);$this->error=$m;}function
attach($N,$V,$F){$this->link=@oci_new_connect($V,$F,$N,"AL32UTF8");if($this->link){$this->server_info=oci_server_version($this->link);return'';}$m=oci_error();return$m["message"];}function
quote($Q){return"'".str_replace("'","''",$Q)."'";}function
select_db($Pb){$this->_current_db=$Pb;return
true;}function
query($H,$sj=false){$I=oci_parse($this->link,$H);$this->error="";if(!$I){$m=oci_error($this->link);$this->errno=$m["code"];$this->error=$m["message"];return
false;}set_error_handler(array($this,'_error'));$J=@oci_execute($I);restore_error_handler();if($J){if(oci_num_fields($I))return
new
Result($I);$this->affected_rows=oci_num_rows($I);oci_free_statement($I);}return$J;}function
timeout($yf){return
oci_set_call_timeout($this->link,$yf);}}class
Result{var$num_rows;private$result,$offset=1;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'OCILob')||is_a($X,'OCI-Lob'))$K[$y]=$X->load();}return$K;}function
fetch_assoc(){return$this->convert(oci_fetch_assoc($this->result));}function
fetch_row(){return$this->convert(oci_fetch_row($this->result));}function
fetch_field(){$d=$this->offset++;$J=new
\stdClass;$J->name=oci_field_name($this->result,$d);$J->type=oci_field_type($this->result,$d);$J->charsetnr=(preg_match("~raw|blob|bfile~",$J->type)?63:0);return$J;}function
__destruct(){oci_free_statement($this->result);}}}elseif(extension_loaded("pdo_oci")){class
Db
extends
PdoDb{var$extension="PDO_OCI";var$_current_db;function
attach($N,$V,$F){return$this->dsn("oci:dbname=//$N;charset=AL32UTF8",$V,$F);}function
select_db($Pb){$this->_current_db=$Pb;return
true;}}}class
Driver
extends
SqlDriver{static$extensions=array("OCI8","PDO_OCI");static$jush="oracle";var$insertFunctions=array("date"=>"current_date","timestamp"=>"current_timestamp",);var$editFunctions=array("number|float|double"=>"+/-","date|timestamp"=>"+ interval/- interval","char|clob"=>"||",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL","SQL");var$functions=array("length","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("number"=>38,"binary_float"=>12,"binary_double"=>21),lang(26)=>array("date"=>10,"timestamp"=>29,"interval year"=>12,"interval day"=>28),lang(27)=>array("char"=>2000,"varchar2"=>4000,"nchar"=>2000,"nvarchar2"=>4000,"clob"=>4294967295,"nclob"=>4294967295),lang(28)=>array("raw"=>2000,"long raw"=>2147483648,"blob"=>4294967295,"bfile"=>4294967296),);}function
begin(){return
true;}function
insertUpdate($R,array$L,array$G){foreach($L
as$O){$_j=array();$Z=array();foreach($O
as$y=>$X){$_j[]="$y = $X";if(isset($G[idf_unescape($y)]))$Z[]="$y = $X";}if(!(($Z&&queries("UPDATE ".table($R)." SET ".implode(", ",$_j)." WHERE ".implode(" AND ",$Z))&&$this->conn->affected_rows)||queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES (".implode(", ",$O).")")))return
false;}return
true;}function
hasCStyleEscapes(){return
true;}}function
idf_escape($v){return'"'.str_replace('"','""',$v).'"';}function
table($v){return
idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT DISTINCT tablespace_name FROM (
SELECT tablespace_name FROM user_tablespaces
UNION SELECT tablespace_name FROM all_tables WHERE tablespace_name IS NOT NULL
)
ORDER BY 1");}function
limit($H,$Z,$z,$C=0,$Vh=" "){return($C?" * FROM (SELECT t.*, rownum AS rnum FROM (SELECT $H$Z) t WHERE rownum <= ".($z+$C).") WHERE rnum > $C":($z?" * FROM (SELECT $H$Z) WHERE rownum <= ".($z+$C):" $H$Z"));}function
limit1($R,$H,$Z,$Vh="\n"){return" $H$Z";}function
db_collation($k,$lb){return
get_val("SELECT value FROM nls_database_parameters WHERE parameter = 'NLS_CHARACTERSET'");}function
logged_user(){return
get_val("SELECT USER FROM DUAL");}function
get_current_db(){$k=connection()->_current_db?:DB;unset(connection()->_current_db);return$k;}function
where_owner($Wg,$vg="owner"){if(!$_GET["ns"])return'';return"$Wg$vg = sys_context('USERENV', 'CURRENT_SCHEMA')";}function
views_table($e){$vg=where_owner('');return"(SELECT $e FROM all_views WHERE ".($vg?:"rownum < 0").")";}function
tables_list(){$Oj=views_table("view_name");$vg=where_owner(" AND ");return
get_key_vals("SELECT table_name, 'table' FROM all_tables WHERE tablespace_name = ".q(DB)."$vg
UNION SELECT view_name, 'view' FROM $Oj
ORDER BY 1");}function
count_tables($j){$J=array();foreach($j
as$k)$J[$k]=get_val("SELECT COUNT(*) FROM all_tables WHERE tablespace_name = ".q($k));return$J;}function
table_status($B=""){$J=array();$Oh=q($B);$k=get_current_db();$Oj=views_table("view_name");$vg=where_owner(" AND ");foreach(get_rows('SELECT table_name "Name", \'table\' "Engine", avg_row_len * num_rows "Data_length", num_rows "Rows" FROM all_tables WHERE tablespace_name = '.q($k).$vg.($B!=""?" AND table_name = $Oh":"")."
UNION SELECT view_name, 'view', 0, 0 FROM $Oj".($B!=""?" WHERE view_name = $Oh":"")."
ORDER BY 1")as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="view";}function
fk_support($S){return
true;}function
fields($R){$J=array();$vg=where_owner(" AND ");foreach(get_rows("SELECT * FROM all_tab_columns WHERE table_name = ".q($R)."$vg ORDER BY column_id")as$K){$U=$K["DATA_TYPE"];$Re="$K[DATA_PRECISION],$K[DATA_SCALE]";if($Re==",")$Re=$K["CHAR_COL_DECL_LENGTH"];$J[$K["COLUMN_NAME"]]=array("field"=>$K["COLUMN_NAME"],"full_type"=>$U.($Re?"($Re)":""),"type"=>strtolower($U),"length"=>$Re,"default"=>$K["DATA_DEFAULT"],"null"=>($K["NULLABLE"]=="Y"),"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),);}return$J;}function
indexes($R,$h=null){$J=array();$vg=where_owner(" AND ","aic.table_owner");foreach(get_rows("SELECT aic.*, ac.constraint_type, atc.data_default
FROM all_ind_columns aic
LEFT JOIN all_constraints ac ON aic.index_name = ac.constraint_name AND aic.table_name = ac.table_name AND aic.index_owner = ac.owner
LEFT JOIN all_tab_cols atc ON aic.column_name = atc.column_name AND aic.table_name = atc.table_name AND aic.index_owner = atc.owner
WHERE aic.table_name = ".q($R)."$vg
ORDER BY ac.constraint_type, aic.column_position",$h)as$K){$ee=$K["INDEX_NAME"];$nb=$K["DATA_DEFAULT"];$nb=($nb?trim($nb,'"'):$K["COLUMN_NAME"]);$J[$ee]["type"]=($K["CONSTRAINT_TYPE"]=="P"?"PRIMARY":($K["CONSTRAINT_TYPE"]=="U"?"UNIQUE":"INDEX"));$J[$ee]["columns"][]=$nb;$J[$ee]["lengths"][]=($K["CHAR_LENGTH"]&&$K["CHAR_LENGTH"]!=$K["COLUMN_LENGTH"]?$K["CHAR_LENGTH"]:null);$J[$ee]["descs"][]=($K["DESCEND"]&&$K["DESCEND"]=="DESC"?'1':null);}return$J;}function
view($B){$Oj=views_table("view_name, text");$L=get_rows('SELECT text "select" FROM '.$Oj.' WHERE view_name = '.q($B));return
reset($L);}function
collations(){return
array();}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
h(connection()->error);}function
explain($g,$H){$g->query("EXPLAIN PLAN FOR $H");return$g->query("SELECT * FROM plan_table");}function
found_rows($S,$Z){}function
auto_increment(){return"";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$b=$kc=array();$og=($R?fields($R):array());foreach($o
as$n){$X=$n[1];if($X&&$n[0]!=""&&idf_escape($n[0])!=$X[0])queries("ALTER TABLE ".table($R)." RENAME COLUMN ".idf_escape($n[0])." TO $X[0]");$ng=$og[$n[0]];if($X&&$ng){$Rf=process_field($ng,$ng);if($X[2]==$Rf[2])$X[2]="";}if($X)$b[]=($R!=""?($n[0]!=""?"MODIFY (":"ADD ("):"  ").implode($X).($R!=""?")":"");else$kc[]=idf_escape($n[0]);}if($R=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)");return(!$b||queries("ALTER TABLE ".table($R)."\n".implode("\n",$b)))&&(!$kc||queries("ALTER TABLE ".table($R)." DROP (".implode(", ",$kc).")"))&&($R==$B||queries("ALTER TABLE ".table($R)." RENAME TO ".table($B)));}function
alter_indexes($R,$b){$kc=array();$ih=array();foreach($b
as$X){if($X[0]!="INDEX"){$X[2]=preg_replace('~ DESC$~','',$X[2]);$i=($X[2]=="DROP"?"\nDROP CONSTRAINT ".idf_escape($X[1]):"\nADD".($X[1]!=""?" CONSTRAINT ".idf_escape($X[1]):"")." $X[0] ".($X[0]=="PRIMARY"?"KEY ":"")."(".implode(", ",$X[2]).")");array_unshift($ih,"ALTER TABLE ".table($R).$i);}elseif($X[2]=="DROP")$kc[]=idf_escape($X[1]);else$ih[]="CREATE INDEX ".idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R)." (".implode(", ",$X[2]).")";}if($kc)array_unshift($ih,"DROP INDEX ".implode(", ",$kc));foreach($ih
as$H){if(!queries($H))return
false;}return
true;}function
foreign_keys($R){$J=array();$H="SELECT c_list.CONSTRAINT_NAME as NAME,
c_src.COLUMN_NAME as SRC_COLUMN,
c_dest.OWNER as DEST_DB,
c_dest.TABLE_NAME as DEST_TABLE,
c_dest.COLUMN_NAME as DEST_COLUMN,
c_list.DELETE_RULE as ON_DELETE
FROM ALL_CONSTRAINTS c_list, ALL_CONS_COLUMNS c_src, ALL_CONS_COLUMNS c_dest
WHERE c_list.CONSTRAINT_NAME = c_src.CONSTRAINT_NAME
AND c_list.R_CONSTRAINT_NAME = c_dest.CONSTRAINT_NAME
AND c_list.CONSTRAINT_TYPE = 'R'
AND c_src.TABLE_NAME = ".q($R);foreach(get_rows($H)as$K)$J[$K['NAME']]=array("db"=>$K['DEST_DB'],"table"=>$K['DEST_TABLE'],"source"=>array($K['SRC_COLUMN']),"target"=>array($K['DEST_COLUMN']),"on_delete"=>$K['ON_DELETE'],"on_update"=>null,);return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Pj){return
apply_queries("DROP VIEW",$Pj);}function
drop_tables($T){return
apply_queries("DROP TABLE",$T);}function
last_id($I){return
0;}function
schemas(){$J=get_vals("SELECT DISTINCT owner FROM dba_segments WHERE owner IN (SELECT username FROM dba_users WHERE default_tablespace NOT IN ('SYSTEM','SYSAUX')) ORDER BY 1");return($J?:get_vals("SELECT DISTINCT owner FROM all_tables WHERE tablespace_name = ".q(DB)." ORDER BY 1"));}function
get_schema(){return
get_val("SELECT sys_context('USERENV', 'SESSION_USER') FROM dual");}function
set_schema($Lh,$h=null){if(!$h)$h=connection();return$h->query("ALTER SESSION SET CURRENT_SCHEMA = ".idf_escape($Lh));}function
show_variables(){return
get_rows('SELECT name, display_value FROM v$parameter');}function
show_status(){$J=array();$L=get_rows('SELECT * FROM v$instance');foreach(reset($L)as$y=>$X)$J[]=array($y,$X);return$J;}function
process_list(){return
get_rows('SELECT
	sess.process AS "process",
	sess.username AS "user",
	sess.schemaname AS "schema",
	sess.status AS "status",
	sess.wait_class AS "wait_class",
	sess.seconds_in_wait AS "seconds_in_wait",
	sql.sql_text AS "sql_text",
	sess.machine AS "machine",
	sess.port AS "port"
FROM v$session sess LEFT OUTER JOIN v$sql sql
ON sql.sql_id = sess.sql_id
WHERE sess.type = \'USER\'
ORDER BY PROCESS
');}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(columns|database|drop_col|indexes|descidx|processlist|scheme|sql|status|table|variables|view)$~',$Wc);}}add_driver("mssql","MS SQL");if(isset($_GET["mssql"])){define('Adminer\DRIVER',"mssql");if(extension_loaded("sqlsrv")&&$_GET["ext"]!="pdo"){class
Db
extends
SqlDb{var$extension="sqlsrv";private$link,$result;private
function
get_error(){$this->error="";foreach(sqlsrv_errors()as$m){$this->errno=$m["code"];$this->error
.="$m[message]\n";}$this->error=rtrim($this->error);}function
attach($N,$V,$F){$xb=array("UID"=>$V,"PWD"=>$F,"CharacterSet"=>"UTF-8");$ri=adminer()->connectSsl();if(isset($ri["Encrypt"]))$xb["Encrypt"]=$ri["Encrypt"];if(isset($ri["TrustServerCertificate"]))$xb["TrustServerCertificate"]=$ri["TrustServerCertificate"];$k=adminer()->database();if($k!="")$xb["Database"]=$k;list($Od,$Qg)=host_port($N);$this->link=@sqlsrv_connect($Od.($Qg?",$Qg":""),$xb);if($this->link){$je=sqlsrv_server_info($this->link);$this->server_info=$je['SQLServerVersion'];}else$this->get_error();return($this->link?'':$this->error);}function
quote($Q){$tj=strlen($Q)!=strlen(utf8_decode($Q));return($tj?"N":"")."'".str_replace("'","''",$Q)."'";}function
select_db($Pb){return$this->query(use_sql($Pb));}function
query($H,$sj=false){$I=sqlsrv_query($this->link,$H);$this->error="";if(!$I){$this->get_error();return
false;}return$this->store_result($I);}function
multi_query($H){$this->result=sqlsrv_query($this->link,$H);$this->error="";if(!$this->result){$this->get_error();return
false;}return
true;}function
store_result($I=null){if(!$I)$I=$this->result;if(!$I)return
false;if(sqlsrv_field_metadata($I))return
new
Result($I);$this->affected_rows=sqlsrv_rows_affected($I);return
true;}function
next_result(){return$this->result?!!sqlsrv_next_result($this->result):false;}}class
Result{var$num_rows;private$result,$offset=0,$fields;function
__construct($I){$this->result=$I;}private
function
convert($K){foreach((array)$K
as$y=>$X){if(is_a($X,'DateTime'))$K[$y]=$X->format("Y-m-d H:i:s");}return$K;}function
fetch_assoc(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_ASSOC));}function
fetch_row(){return$this->convert(sqlsrv_fetch_array($this->result,SQLSRV_FETCH_NUMERIC));}function
fetch_field(){if(!$this->fields)$this->fields=sqlsrv_field_metadata($this->result);$n=$this->fields[$this->offset++];$J=new
\stdClass;$J->name=$n["Name"];$J->type=($n["Type"]==1?254:15);$J->charsetnr=0;return$J;}function
seek($C){for($t=0;$t<$C;$t++)sqlsrv_fetch($this->result);}function
__destruct(){sqlsrv_free_stmt($this->result);}}function
last_id($I){return
get_val("SELECT SCOPE_IDENTITY()");}function
explain($g,$H){$g->query("SET SHOWPLAN_ALL ON");$J=$g->query($H);$g->query("SET SHOWPLAN_ALL OFF");return$J;}}else{abstract
class
MssqlDb
extends
PdoDb{function
select_db($Pb){return$this->query(use_sql($Pb));}function
lastInsertId(){return$this->pdo->lastInsertId();}}function
last_id($I){return
connection()->lastInsertId();}function
explain($g,$H){}if(extension_loaded("pdo_sqlsrv")){class
Db
extends
MssqlDb{var$extension="PDO_SQLSRV";function
attach($N,$V,$F){list($Od,$Qg)=host_port($N);return$this->dsn("sqlsrv:Server=$Od".($Qg?",$Qg":""),$V,$F);}}}elseif(extension_loaded("pdo_dblib")){class
Db
extends
MssqlDb{var$extension="PDO_DBLIB";function
attach($N,$V,$F){list($Od,$Qg)=host_port($N);return$this->dsn("dblib:charset=utf8;host=$Od".($Qg?(is_numeric($Qg)?";port=":";unix_socket=").$Qg:""),$V,$F);}}}}class
Driver
extends
SqlDriver{static$extensions=array("SQLSRV","PDO_SQLSRV","PDO_DBLIB");static$jush="mssql";var$insertFunctions=array("date|time"=>"getdate");var$editFunctions=array("int|decimal|real|float|money|datetime"=>"+/-","char|text"=>"+",);var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","IN","IS NULL","NOT LIKE","NOT IN","IS NOT NULL");var$functions=array("len","lower","round","upper");var$grouping=array("avg","count","count distinct","max","min","sum");var$generated=array("PERSISTED","VIRTUAL");var$onActions="NO ACTION|CASCADE|SET NULL|SET DEFAULT";static
function
connect($N,$V,$F){if($N=="")$N="localhost:1433";return
parent::connect($N,$V,$F);}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"int"=>10,"bigint"=>20,"bit"=>1,"decimal"=>0,"real"=>12,"float"=>53,"smallmoney"=>10,"money"=>20),lang(26)=>array("date"=>10,"smalldatetime"=>19,"datetime"=>19,"datetime2"=>19,"time"=>8,"datetimeoffset"=>10),lang(27)=>array("char"=>8000,"varchar"=>8000,"text"=>2147483647,"nchar"=>4000,"nvarchar"=>4000,"ntext"=>1073741823),lang(28)=>array("binary"=>8000,"varbinary"=>8000,"image"=>2147483647),);}function
insertUpdate($R,array$L,array$G){$o=fields($R);$_j=array();$Z=array();$O=reset($L);$e="c".implode(", c",range(1,count($O)));$Ra=0;$pe=array();foreach($O
as$y=>$X){$Ra++;$B=idf_unescape($y);if(!$o[$B]["auto_increment"])$pe[$y]="c$Ra";if(isset($G[$B]))$Z[]="$y = c$Ra";else$_j[]="$y = c$Ra";}$Kj=array();foreach($L
as$O)$Kj[]="(".implode(", ",$O).")";if($Z){$Td=queries("SET IDENTITY_INSERT ".table($R)." ON");$J=queries("MERGE ".table($R)." USING (VALUES\n\t".implode(",\n\t",$Kj)."\n) AS source ($e) ON ".implode(" AND ",$Z).($_j?"\nWHEN MATCHED THEN UPDATE SET ".implode(", ",$_j):"")."\nWHEN NOT MATCHED THEN INSERT (".implode(", ",array_keys($Td?$O:$pe)).") VALUES (".($Td?$e:implode(", ",$pe)).");");if($Td)queries("SET IDENTITY_INSERT ".table($R)." OFF");}else$J=queries("INSERT INTO ".table($R)." (".implode(", ",array_keys($O)).") VALUES\n".implode(",\n",$Kj));return$J;}function
begin(){return
queries("BEGIN TRANSACTION");}function
tableHelp($B,$_e=false){$Ve=array("sys"=>"catalog-views/sys-","INFORMATION_SCHEMA"=>"information-schema-views/",);$_=$Ve[get_schema()];if($_)return"relational-databases/system-$_".preg_replace('~_~','-',strtolower($B))."-transact-sql";}}function
idf_escape($v){return"[".str_replace("]","]]",$v)."]";}function
table($v){return($_GET["ns"]!=""?idf_escape($_GET["ns"]).".":"").idf_escape($v);}function
get_databases($jd){return
get_vals("SELECT name FROM sys.databases WHERE name NOT IN ('master', 'tempdb', 'model', 'msdb')");}function
limit($H,$Z,$z,$C=0,$Vh=" "){return($z?" TOP (".($z+$C).")":"")." $H$Z";}function
limit1($R,$H,$Z,$Vh="\n"){return
limit($H,$Z,1,0,$Vh);}function
db_collation($k,$lb){return
get_val("SELECT collation_name FROM sys.databases WHERE name = ".q($k));}function
logged_user(){return
get_val("SELECT SUSER_NAME()");}function
tables_list(){return
get_key_vals("SELECT name, type_desc FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ORDER BY name");}function
count_tables($j){$J=array();foreach($j
as$k){connection()->select_db($k);$J[$k]=get_val("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES");}return$J;}function
table_status($B=""){$J=array();foreach(get_rows("SELECT ao.name AS Name, ao.type_desc AS Engine, (SELECT value FROM fn_listextendedproperty(default, 'SCHEMA', schema_name(schema_id), 'TABLE', ao.name, null, null)) AS Comment
FROM sys.all_objects AS ao
WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') ".($B!=""?"AND name = ".q($B):"ORDER BY name"))as$K)$J[$K["Name"]]=$K;return$J;}function
is_view($S){return$S["Engine"]=="VIEW";}function
fk_support($S){return
true;}function
fields($R){$sb=get_key_vals("SELECT objname, cast(value as varchar(max)) FROM fn_listextendedproperty('MS_DESCRIPTION', 'schema', ".q(get_schema()).", 'table', ".q($R).", 'column', NULL)");$J=array();$Ci=get_val("SELECT object_id FROM sys.all_objects WHERE schema_id = SCHEMA_ID(".q(get_schema()).") AND type IN ('S', 'U', 'V') AND name = ".q($R));foreach(get_rows("SELECT c.max_length, c.precision, c.scale, c.name, c.is_nullable, c.is_identity, c.collation_name, t.name type, d.definition [default], d.name default_constraint, i.is_primary_key
FROM sys.all_columns c
JOIN sys.types t ON c.user_type_id = t.user_type_id
LEFT JOIN sys.default_constraints d ON c.default_object_id = d.object_id
LEFT JOIN sys.index_columns ic ON c.object_id = ic.object_id AND c.column_id = ic.column_id
LEFT JOIN sys.indexes i ON ic.object_id = i.object_id AND ic.index_id = i.index_id
WHERE c.object_id = ".q($Ci))as$K){$U=$K["type"];$Re=(preg_match("~char|binary~",$U)?intval($K["max_length"])/($U[0]=='n'?2:1):($U=="decimal"?"$K[precision],$K[scale]":""));$J[$K["name"]]=array("field"=>$K["name"],"full_type"=>$U.($Re?"($Re)":""),"type"=>$U,"length"=>$Re,"default"=>(preg_match("~^\('(.*)'\)$~",$K["default"],$A)?str_replace("''","'",$A[1]):$K["default"]),"default_constraint"=>$K["default_constraint"],"null"=>$K["is_nullable"],"auto_increment"=>$K["is_identity"],"collation"=>$K["collation_name"],"privileges"=>array("insert"=>1,"select"=>1,"update"=>1,"where"=>1,"order"=>1),"primary"=>$K["is_primary_key"],"comment"=>$sb[$K["name"]],);}foreach(get_rows("SELECT * FROM sys.computed_columns WHERE object_id = ".q($Ci))as$K){$J[$K["name"]]["generated"]=($K["is_persisted"]?"PERSISTED":"VIRTUAL");$J[$K["name"]]["default"]=$K["definition"];}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SELECT i.name, key_ordinal, is_unique, is_primary_key, c.name AS column_name, is_descending_key
FROM sys.indexes i
INNER JOIN sys.index_columns ic ON i.object_id = ic.object_id AND i.index_id = ic.index_id
INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
WHERE OBJECT_NAME(i.object_id) = ".q($R),$h)as$K){$B=$K["name"];$J[$B]["type"]=($K["is_primary_key"]?"PRIMARY":($K["is_unique"]?"UNIQUE":"INDEX"));$J[$B]["lengths"]=array();$J[$B]["columns"][$K["key_ordinal"]]=$K["column_name"];$J[$B]["descs"][$K["key_ordinal"]]=($K["is_descending_key"]?'1':null);}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^[]|\[[^]]*])*\s+AS\s+~isU','',get_val("SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA = SCHEMA_NAME() AND TABLE_NAME = ".q($B))));}function
collations(){$J=array();foreach(get_vals("SELECT name FROM fn_helpcollations()")as$c)$J[preg_replace('~_.*~','',$c)][]=$c;return$J;}function
information_schema($k){return
get_schema()=="INFORMATION_SCHEMA";}function
error(){return
nl_br(h(preg_replace('~^(\[[^]]*])+~m','',connection()->error)));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).(preg_match('~^[a-z0-9_]+$~i',$c)?" COLLATE $c":""));}function
drop_databases($j){return
queries("DROP DATABASE ".implode(", ",array_map('Adminer\idf_escape',$j)));}function
rename_database($B,$c){if(preg_match('~^[a-z0-9_]+$~i',$c))queries("ALTER DATABASE ".idf_escape(DB)." COLLATE $c");queries("ALTER DATABASE ".idf_escape(DB)." MODIFY NAME = ".idf_escape($B));return
true;}function
auto_increment(){return" IDENTITY".($_POST["Auto_increment"]!=""?"(".number($_POST["Auto_increment"]).",1)":"")." PRIMARY KEY";}function
alter_table($R,$B,$o,$ld,$qb,$zc,$c,$Ba,$E){$b=array();$sb=array();$og=fields($R);foreach($o
as$n){$d=idf_escape($n[0]);$X=$n[1];if(!$X)$b["DROP"][]=" COLUMN $d";else{$X[1]=preg_replace("~( COLLATE )'(\\w+)'~",'\1\2',$X[1]);$sb[$n[0]]=$X[5];unset($X[5]);if(preg_match('~ AS ~',$X[3]))unset($X[1],$X[2]);if($n[0]=="")$b["ADD"][]="\n  ".implode("",$X).($R==""?substr($ld[$X[0]],16+strlen($X[0])):"");else{$l=$X[3];unset($X[3]);unset($X[6]);if($d!=$X[0])queries("EXEC sp_rename ".q(table($R).".$d").", ".q(idf_unescape($X[0])).", 'COLUMN'");$b["ALTER COLUMN ".implode("",$X)][]="";$ng=$og[$n[0]];if(default_value($ng)!=$l){if($ng["default"]!==null)$b["DROP"][]=" ".idf_escape($ng["default_constraint"]);if($l)$b["ADD"][]="\n $l FOR $d";}}}}if($R=="")return
queries("CREATE TABLE ".table($B)." (".implode(",",(array)$b["ADD"])."\n)");if($R!=$B)queries("EXEC sp_rename ".q(table($R)).", ".q($B));if($ld)$b[""]=$ld;foreach($b
as$y=>$X){if(!queries("ALTER TABLE ".table($B)." $y".implode(",",$X)))return
false;}foreach($sb
as$y=>$X){$qb=substr($X,9);queries("EXEC sp_dropextendedproperty @name = N'MS_Description', @level0type = N'Schema', @level0name = ".q(get_schema()).", @level1type = N'Table', @level1name = ".q($B).", @level2type = N'Column', @level2name = ".q($y));queries("EXEC sp_addextendedproperty
@name = N'MS_Description',
@value = $qb,
@level0type = N'Schema',
@level0name = ".q(get_schema()).",
@level1type = N'Table',
@level1name = ".q($B).",
@level2type = N'Column',
@level2name = ".q($y));}return
true;}function
alter_indexes($R,$b){$w=array();$kc=array();foreach($b
as$X){if($X[2]=="DROP"){if($X[0]=="PRIMARY")$kc[]=idf_escape($X[1]);else$w[]=idf_escape($X[1])." ON ".table($R);}elseif(!queries(($X[0]!="PRIMARY"?"CREATE $X[0] ".($X[0]!="INDEX"?"INDEX ":"").idf_escape($X[1]!=""?$X[1]:uniqid($R."_"))." ON ".table($R):"ALTER TABLE ".table($R)." ADD PRIMARY KEY")." (".implode(", ",$X[2]).")"))return
false;}return(!$w||queries("DROP INDEX ".implode(", ",$w)))&&(!$kc||queries("ALTER TABLE ".table($R)." DROP ".implode(", ",$kc)));}function
found_rows($S,$Z){}function
foreign_keys($R){$J=array();$Yf=array("CASCADE","NO ACTION","SET NULL","SET DEFAULT");foreach(get_rows("EXEC sp_fkeys @fktable_name = ".q($R).", @fktable_owner = ".q(get_schema()))as$K){$q=&$J[$K["FK_NAME"]];$q["db"]=$K["PKTABLE_QUALIFIER"];$q["ns"]=$K["PKTABLE_OWNER"];$q["table"]=$K["PKTABLE_NAME"];$q["on_update"]=$Yf[$K["UPDATE_RULE"]];$q["on_delete"]=$Yf[$K["DELETE_RULE"]];$q["source"][]=$K["FKCOLUMN_NAME"];$q["target"][]=$K["PKCOLUMN_NAME"];}return$J;}function
truncate_tables($T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views($Pj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Pj)));}function
drop_tables($T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables($T,$Pj,$Mi){return
apply_queries("ALTER SCHEMA ".idf_escape($Mi)." TRANSFER",array_merge($T,$Pj));}function
trigger($B,$R){if($B=="")return
array();$L=get_rows("SELECT s.name [Trigger],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(s.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(s.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(s.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing],
c.text
FROM sysobjects s
JOIN syscomments c ON s.id = c.id
WHERE s.xtype = 'TR' AND s.name = ".q($B));$J=reset($L);if($J)$J["Statement"]=preg_replace('~^.+\s+AS\s+~isU','',$J["text"]);return$J;}function
triggers($R){$J=array();foreach(get_rows("SELECT sys1.name,
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsertTrigger') = 1 THEN 'INSERT' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsUpdateTrigger') = 1 THEN 'UPDATE' WHEN OBJECTPROPERTY(sys1.id, 'ExecIsDeleteTrigger') = 1 THEN 'DELETE' END [Event],
CASE WHEN OBJECTPROPERTY(sys1.id, 'ExecIsInsteadOfTrigger') = 1 THEN 'INSTEAD OF' ELSE 'AFTER' END [Timing]
FROM sysobjects sys1
JOIN sysobjects sys2 ON sys1.parent_obj = sys2.id
WHERE sys1.xtype = 'TR' AND sys2.name = ".q($R))as$K)$J[$K["name"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("AFTER","INSTEAD OF"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("AS"),);}function
schemas(){return
get_vals("SELECT name FROM sys.schemas");}function
get_schema(){if($_GET["ns"]!="")return$_GET["ns"];return
get_val("SELECT SCHEMA_NAME()");}function
set_schema($Jh){$_GET["ns"]=$Jh;return
true;}function
create_sql($R,$Ba,$wi){if(is_view(table_status1($R))){$Oj=view($R);return"CREATE VIEW ".table($R)." AS $Oj[select]";}$o=array();$G=false;foreach(fields($R)as$B=>$n){$X=process_field($n,$n);if($X[6])$G=true;$o[]=implode("",$X);}foreach(indexes($R)as$B=>$w){if(!$G||$w["type"]!="PRIMARY"){$e=array();foreach($w["columns"]as$y=>$X)$e[]=idf_escape($X).($w["descs"][$y]?" DESC":"");$B=idf_escape($B);$o[]=($w["type"]=="INDEX"?"INDEX $B":"CONSTRAINT $B ".($w["type"]=="UNIQUE"?"UNIQUE":"PRIMARY KEY"))." (".implode(", ",$e).")";}}foreach(driver()->checkConstraints($R)as$B=>$Ya)$o[]="CONSTRAINT ".idf_escape($B)." CHECK ($Ya)";return"CREATE TABLE ".table($R)." (\n\t".implode(",\n\t",$o)."\n)";}function
foreign_keys_sql($R){$o=array();foreach(foreign_keys($R)as$ld)$o[]=ltrim(format_foreign_key($ld));return($o?"ALTER TABLE ".table($R)." ADD\n\t".implode(",\n\t",$o).";\n\n":"");}function
truncate_sql($R){return"TRUNCATE TABLE ".table($R);}function
use_sql($Pb,$wi=""){return"USE ".idf_escape($Pb);}function
trigger_sql($R){$J="";foreach(triggers($R)as$B=>$lj)$J
.=create_trigger(" ON ".table($R),trigger($B,$R)).";";return$J;}function
convert_field($n){}function
unconvert_field($n,$J){return$J;}function
support($Wc){return
preg_match('~^(check|comment|columns|database|drop_col|dump|indexes|descidx|scheme|sql|table|trigger|view|view_trigger)$~',$Wc);}}class
Adminer{static$instance;var$error='';function
name(){return"<a href='https://www.adminer.org/'".target_blank()." id='h1'><img src='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.4.0")."' width='24' height='24' alt='' id='logo'>Adminer</a>";}function
credentials(){return
array(SERVER,$_GET["username"],get_password());}function
connectSsl(){}function
permanentLogin($i=false){return
password_file($i);}function
bruteForceKey(){return$_SERVER["REMOTE_ADDR"];}function
serverName($N){return
h($N);}function
database(){return
DB;}function
databases($jd=true){return
get_databases($jd);}function
pluginsLinks(){}function
operators(){return
driver()->operators;}function
schemas(){return
schemas();}function
queryTimeout(){return
2;}function
afterConnect(){}function
headers(){}function
csp(array$Ib){return$Ib;}function
head($Mb=null){return
true;}function
bodyClass(){echo" adminer";}function
css(){$J=array();foreach(array("","-dark")as$xf){$p="adminer$xf.css";if(file_exists($p)){$bd=file_get_contents($p);$J["$p?v=".crc32($bd)]=($xf?"dark":(preg_match('~prefers-color-scheme:\s*dark~',$bd)?'':'light'));}}return$J;}function
loginForm(){echo"<table class='layout'>\n",adminer()->loginFormField('driver','<tr><th>'.lang(31).'<td>',html_select("auth[driver]",SqlDriver::$drivers,DRIVER,"loginDriver(this);")),adminer()->loginFormField('server','<tr><th>'.lang(32).'<td>','<input name="auth[server]" value="'.h(SERVER).'" title="hostname[:port]" placeholder="localhost" autocapitalize="off">'),adminer()->loginFormField('username','<tr><th>'.lang(33).'<td>','<input name="auth[username]" id="username" autofocus value="'.h($_GET["username"]).'" autocomplete="username" autocapitalize="off">'.script("const authDriver = qs('#username').form['auth[driver]']; authDriver && authDriver.onchange();")),adminer()->loginFormField('password','<tr><th>'.lang(34).'<td>','<input type="password" name="auth[password]" autocomplete="current-password">'),adminer()->loginFormField('db','<tr><th>'.lang(35).'<td>','<input name="auth[db]" value="'.h($_GET["db"]).'" autocapitalize="off">'),"</table>\n","<p><input type='submit' value='".lang(36)."'>\n",checkbox("auth[permanent]",1,$_COOKIE["adminer_permanent"],lang(37))."\n";}function
loginFormField($B,$Jd,$Y){return$Jd.$Y."\n";}function
login($Xe,$F){if($F=="")return
lang(38,target_blank());return
true;}function
tableName(array$Bi){return
h($Bi["Name"]);}function
fieldName(array$n,$hg=0){$U=$n["full_type"];$qb=$n["comment"];return'<span title="'.h($U.($qb!=""?($U?": ":"").$qb:'')).'">'.h($n["field"]).'</span>';}function
selectLinks(array$Bi,$O=""){$B=$Bi["Name"];echo'<p class="links">';$Ve=array("select"=>lang(39));if(support("table")||support("indexes"))$Ve["table"]=lang(40);$_e=false;if(support("table")){$_e=is_view($Bi);if(!$_e)$Ve["create"]=lang(41);elseif(support("view"))$Ve["view"]=lang(42);}if($O!==null)$Ve["edit"]=lang(43);foreach($Ve
as$y=>$X)echo" <a href='".h(ME)."$y=".urlencode($B).($y=="edit"?$O:"")."'".bold(isset($_GET[$y])).">$X</a>";echo
doc_link(array(JUSH=>driver()->tableHelp($B,$_e)),"?"),"\n";}function
foreignKeys($R){return
foreign_keys($R);}function
backwardKeys($R,$Ai){return
array();}function
backwardKeysPrint(array$Fa,array$K){}function
selectQuery($H,$si,$Uc=false){$J="</p>\n";if(!$Uc&&($Sj=driver()->warnings())){$u="warnings";$J=", <a href='#$u'>".lang(44)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."$J<div id='$u' class='hidden'>\n$Sj</div>\n";}return"<p><code class='jush-".JUSH."'>".h(str_replace("\n"," ",$H))."</code> <span class='time'>(".format_time($si).")</span>".(support("sql")?" <a href='".h(ME)."sql=".urlencode($H)."'>".lang(10)."</a>":"").$J;}function
sqlCommandQuery($H){return
shorten_utf8(trim($H),1000);}function
sqlPrintAfter(){}function
rowDescription($R){return"";}function
rowDescriptions(array$L,array$md){return$L;}function
selectLink($X,array$n){}function
selectVal($X,$_,array$n,$rg){$J=($X===null?"<i>NULL</i>":(preg_match("~char|binary|boolean~",$n["type"])&&!preg_match("~var~",$n["type"])?"<code>$X</code>":(preg_match('~json~',$n["type"])?"<code class='jush-js'>$X</code>":$X)));if(is_blob($n)&&!is_utf8($X))$J="<i>".lang(45,strlen($rg))."</i>";return($_?"<a href='".h($_)."'".(is_url($_)?target_blank():"").">$J</a>":$J);}function
editVal($X,array$n){return$X;}function
config(){return
array();}function
tableStructurePrint(array$o,$Bi=null){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr><th>".lang(46)."<td>".lang(47).(support("comment")?"<td>".lang(48):"")."</thead>\n";$vi=driver()->structuredTypes();foreach($o
as$n){echo"<tr><th>".h($n["field"]);$U=h($n["full_type"]);$c=h($n["collation"]);echo"<td><span title='$c'>".(in_array($U,(array)$vi[lang(6)])?"<a href='".h(ME.'type='.urlencode($U))."'>$U</a>":$U.($c&&isset($Bi["Collation"])&&$c!=$Bi["Collation"]?" $c":""))."</span>",($n["null"]?" <i>NULL</i>":""),($n["auto_increment"]?" <i>".lang(49)."</i>":"");$l=h($n["default"]);echo(isset($n["default"])?" <span title='".lang(50)."'>[<b>".($n["generated"]?"<code class='jush-".JUSH."'>$l</code>":$l)."</b>]</span>":""),(support("comment")?"<td>".h($n["comment"]):""),"\n";}echo"</table>\n","</div>\n";}function
tableIndexesPrint(array$x,array$Bi){$Bg=false;foreach($x
as$B=>$w)$Bg|=!!$w["partial"];echo"<table>\n";$Ub=first(driver()->indexAlgorithms($Bi));foreach($x
as$B=>$w){ksort($w["columns"]);$ah=array();foreach($w["columns"]as$y=>$X)$ah[]="<i>".h($X)."</i>".($w["lengths"][$y]?"(".$w["lengths"][$y].")":"").($w["descs"][$y]?" DESC":"");echo"<tr title='".h($B)."'>","<th>$w[type]".($Ub&&$w['algorithm']!=$Ub?" ($w[algorithm])":""),"<td>".implode(", ",$ah);if($Bg)echo"<td>".($w['partial']?"<code class='jush-".JUSH."'>WHERE ".h($w['partial']):"");echo"\n";}echo"</table>\n";}function
selectColumnsPrint(array$M,array$e){print_fieldset("select",lang(51),$M);$t=0;$M[""]=array();foreach($M
as$y=>$X){$X=idx($_GET["columns"],$y,array());$d=select_input(" name='columns[$t][col]'",$e,$X["col"],($y!==""?"selectFieldChange":"selectAddRow"));echo"<div>".(driver()->functions||driver()->grouping?html_select("columns[$t][fun]",array(-1=>"")+array_filter(array(lang(52)=>driver()->functions,lang(53)=>driver()->grouping)),$X["fun"]).on_help("event.target.value && event.target.value.replace(/ |\$/, '(') + ')'",1).script("qsl('select').onchange = function () { helpClose();".($y!==""?"":" qsl('select, input', this.parentNode).onchange();")." };","")."($d)":$d)."</div>\n";$t++;}echo"</div></fieldset>\n";}function
selectSearchPrint(array$Z,array$e,array$x){print_fieldset("search",lang(54),$Z);foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT")echo"<div>(<i>".implode("</i>, <i>",array_map('Adminer\h',$w["columns"]))."</i>) AGAINST"," <input type='search' name='fulltext[$t]' value='".h(idx($_GET["fulltext"],$t))."'>",script("qsl('input').oninput = selectFieldChange;",""),checkbox("boolean[$t]",1,isset($_GET["boolean"][$t]),"BOOL"),"</div>\n";}$Va="this.parentNode.firstChild.onchange();";foreach(array_merge((array)$_GET["where"],array(array()))as$t=>$X){if(!$X||("$X[col]$X[val]"!=""&&in_array($X["op"],adminer()->operators())))echo"<div>".select_input(" name='where[$t][col]'",$e,$X["col"],($X?"selectFieldChange":"selectAddRow"),"(".lang(55).")"),html_select("where[$t][op]",adminer()->operators(),$X["op"],$Va),"<input type='search' name='where[$t][val]' value='".h($X["val"])."'>",script("mixin(qsl('input'), {oninput: function () { $Va }, onkeydown: selectSearchKeydown, onsearch: selectSearchSearch});",""),"</div>\n";}echo"</div></fieldset>\n";}function
selectOrderPrint(array$hg,array$e,array$x){print_fieldset("sort",lang(56),$hg);$t=0;foreach((array)$_GET["order"]as$y=>$X){if($X!=""){echo"<div>".select_input(" name='order[$t]'",$e,$X,"selectFieldChange"),checkbox("desc[$t]",1,isset($_GET["desc"][$y]),lang(57))."</div>\n";$t++;}}echo"<div>".select_input(" name='order[$t]'",$e,"","selectAddRow"),checkbox("desc[$t]",1,false,lang(57))."</div>\n","</div></fieldset>\n";}function
selectLimitPrint($z){echo"<fieldset><legend>".lang(58)."</legend><div>","<input type='number' name='limit' class='size' value='".intval($z)."'>",script("qsl('input').oninput = selectFieldChange;",""),"</div></fieldset>\n";}function
selectLengthPrint($Si){if($Si!==null)echo"<fieldset><legend>".lang(59)."</legend><div>","<input type='number' name='text_length' class='size' value='".h($Si)."'>","</div></fieldset>\n";}function
selectActionPrint(array$x){echo"<fieldset><legend>".lang(60)."</legend><div>","<input type='submit' value='".lang(51)."'>"," <span id='noindex' title='".lang(61)."'></span>","<script".nonce().">\n","const indexColumns = ";$e=array();foreach($x
as$w){$Lb=reset($w["columns"]);if($w["type"]!="FULLTEXT"&&$Lb)$e[$Lb]=1;}$e[""]=1;foreach($e
as$y=>$X)json_row($y);echo";\n","selectFieldChange.call(qs('#form')['select']);\n","</script>\n","</div></fieldset>\n";}function
selectCommandPrint(){return!information_schema(DB);}function
selectImportPrint(){return!information_schema(DB);}function
selectEmailPrint(array$wc,array$e){}function
selectColumnsProcess(array$e,array$x){$M=array();$yd=array();foreach((array)$_GET["columns"]as$y=>$X){if($X["fun"]=="count"||($X["col"]!=""&&(!$X["fun"]||in_array($X["fun"],driver()->functions)||in_array($X["fun"],driver()->grouping)))){$M[$y]=apply_sql_function($X["fun"],($X["col"]!=""?idf_escape($X["col"]):"*"));if(!in_array($X["fun"],driver()->grouping))$yd[]=$M[$y];}}return
array($M,$yd);}function
selectSearchProcess(array$o,array$x){$J=array();foreach($x
as$t=>$w){if($w["type"]=="FULLTEXT"&&idx($_GET["fulltext"],$t)!="")$J[]="MATCH (".implode(", ",array_map('Adminer\idf_escape',$w["columns"])).") AGAINST (".q($_GET["fulltext"][$t]).(isset($_GET["boolean"][$t])?" IN BOOLEAN MODE":"").")";}foreach((array)$_GET["where"]as$y=>$X){$jb=$X["col"];if("$jb$X[val]"!=""&&in_array($X["op"],adminer()->operators())){$ub=array();foreach(($jb!=""?array($jb=>$o[$jb]):$o)as$B=>$n){$Wg="";$tb=" $X[op]";if(preg_match('~IN$~',$X["op"])){$Yd=process_length($X["val"]);$tb
.=" ".($Yd!=""?$Yd:"(NULL)");}elseif($X["op"]=="SQL")$tb=" $X[val]";elseif(preg_match('~^(I?LIKE) %%$~',$X["op"],$A))$tb=" $A[1] ".adminer()->processInput($n,"%$X[val]%");elseif($X["op"]=="FIND_IN_SET"){$Wg="$X[op](".q($X["val"]).", ";$tb=")";}elseif(!preg_match('~NULL$~',$X["op"]))$tb
.=" ".adminer()->processInput($n,$X["val"]);if($jb!=""||(isset($n["privileges"]["where"])&&(preg_match('~^[-\d.'.(preg_match('~IN$~',$X["op"])?',':'').']+$~',$X["val"])||!preg_match('~'.number_type().'|bit~',$n["type"]))&&(!preg_match("~[\x80-\xFF]~",$X["val"])||preg_match('~char|text|enum|set~',$n["type"]))&&(!preg_match('~date|timestamp~',$n["type"])||preg_match('~^\d+-\d+-\d+~',$X["val"]))))$ub[]=$Wg.driver()->convertSearch(idf_escape($B),$X,$n).$tb;}$J[]=(count($ub)==1?$ub[0]:($ub?"(".implode(" OR ",$ub).")":"1 = 0"));}}return$J;}function
selectOrderProcess(array$o,array$x){$J=array();foreach((array)$_GET["order"]as$y=>$X){if($X!="")$J[]=(preg_match('~^((COUNT\(DISTINCT |[A-Z0-9_]+\()(`(?:[^`]|``)+`|"(?:[^"]|"")+")\)|COUNT\(\*\))$~',$X)?$X:idf_escape($X)).(isset($_GET["desc"][$y])?" DESC":"");}return$J;}function
selectLimitProcess(){return(isset($_GET["limit"])?intval($_GET["limit"]):50);}function
selectLengthProcess(){return(isset($_GET["text_length"])?"$_GET[text_length]":"100");}function
selectEmailProcess(array$Z,array$md){return
false;}function
selectQueryBuild(array$M,array$Z,array$yd,array$hg,$z,$D){return"";}function
messageQuery($H,$Ti,$Uc=false){restart_session();$Ld=&get_session("queries");if(!idx($Ld,$_GET["db"]))$Ld[$_GET["db"]]=array();if(strlen($H)>1e6)$H=preg_replace('~[\x80-\xFF]+$~','',substr($H,0,1e6))."\n…";$Ld[$_GET["db"]][]=array($H,time(),$Ti);$oi="sql-".count($Ld[$_GET["db"]]);$J="<a href='#$oi' class='toggle'>".lang(62)."</a> <a href='' class='jsonly copy'>🗐</a>\n";if(!$Uc&&($Sj=driver()->warnings())){$u="warnings-".count($Ld[$_GET["db"]]);$J="<a href='#$u' class='toggle'>".lang(44)."</a>, $J<div id='$u' class='hidden'>\n$Sj</div>\n";}return" <span class='time'>".@date("H:i:s")."</span>"." $J<div id='$oi' class='hidden'><pre><code class='jush-".JUSH."'>".shorten_utf8($H,1000)."</code></pre>".($Ti?" <span class='time'>($Ti)</span>":'').(support("sql")?'<p><a href="'.h(str_replace("db=".urlencode(DB),"db=".urlencode($_GET["db"]),ME).'sql=&history='.(count($Ld[$_GET["db"]])-1)).'">'.lang(10).'</a>':'').'</div>';}function
editRowPrint($R,array$o,$K,$_j){}function
editFunctions(array$n){$J=($n["null"]?"NULL/":"");$_j=isset($_GET["select"])||where($_GET);foreach(array(driver()->insertFunctions,driver()->editFunctions)as$y=>$td){if(!$y||(!isset($_GET["call"])&&$_j)){foreach($td
as$Kg=>$X){if(!$Kg||preg_match("~$Kg~",$n["type"]))$J
.="/$X";}}if($y&&$td&&!preg_match('~set|bool~',$n["type"])&&!is_blob($n))$J
.="/SQL";}if($n["auto_increment"]&&!$_j)$J=lang(49);return
explode("/",$J);}function
editInput($R,array$n,$_a,$Y){if($n["type"]=="enum")return(isset($_GET["select"])?"<label><input type='radio'$_a value='orig' checked><i>".lang(8)."</i></label> ":"").enum_input("radio",$_a,$n,$Y,"NULL");return"";}function
editHint($R,array$n,$Y){return"";}function
processInput(array$n,$Y,$s=""){if($s=="SQL")return$Y;$B=$n["field"];$J=q($Y);if(preg_match('~^(now|getdate|uuid)$~',$s))$J="$s()";elseif(preg_match('~^current_(date|timestamp)$~',$s))$J=$s;elseif(preg_match('~^([+-]|\|\|)$~',$s))$J=idf_escape($B)." $s $J";elseif(preg_match('~^[+-] interval$~',$s))$J=idf_escape($B)." $s ".(preg_match("~^(\\d+|'[0-9.: -]') [A-Z_]+\$~i",$Y)&&JUSH!="pgsql"?$Y:$J);elseif(preg_match('~^(addtime|subtime|concat)$~',$s))$J="$s(".idf_escape($B).", $J)";elseif(preg_match('~^(md5|sha1|password|encrypt)$~',$s))$J="$s($J)";return
unconvert_field($n,$J);}function
dumpOutput(){$J=array('text'=>lang(63),'file'=>lang(64));if(function_exists('gzencode'))$J['gz']='gzip';return$J;}function
dumpFormat(){return(support("dump")?array('sql'=>'SQL'):array())+array('csv'=>'CSV,','csv;'=>'CSV;','tsv'=>'TSV');}function
dumpDatabase($k){}function
dumpTable($R,$wi,$_e=0){if($_POST["format"]!="sql"){echo"\xef\xbb\xbf";if($wi)dump_csv(array_keys(fields($R)));}else{if($_e==2){$o=array();foreach(fields($R)as$B=>$n)$o[]=idf_escape($B)." $n[full_type]";$i="CREATE TABLE ".table($R)." (".implode(", ",$o).")";}else$i=create_sql($R,$_POST["auto_increment"],$wi);set_utf8mb4($i);if($wi&&$i){if($wi=="DROP+CREATE"||$_e==1)echo"DROP ".($_e==2?"VIEW":"TABLE")." IF EXISTS ".table($R).";\n";if($_e==1)$i=remove_definer($i);echo"$i;\n\n";}}}function
dumpData($R,$wi,$H){if($wi){$hf=(JUSH=="sqlite"?0:1048576);$o=array();$Ud=false;if($_POST["format"]=="sql"){if($wi=="TRUNCATE+INSERT")echo
truncate_sql($R).";\n";$o=fields($R);if(JUSH=="mssql"){foreach($o
as$n){if($n["auto_increment"]){echo"SET IDENTITY_INSERT ".table($R)." ON;\n";$Ud=true;break;}}}}$I=connection()->query($H,1);if($I){$pe="";$Pa="";$Ee=array();$ud=array();$yi="";$Xc=($R!=''?'fetch_assoc':'fetch_row');$Eb=0;while($K=$I->$Xc()){if(!$Ee){$Kj=array();foreach($K
as$X){$n=$I->fetch_field();if(idx($o[$n->name],'generated')){$ud[$n->name]=true;continue;}$Ee[]=$n->name;$y=idf_escape($n->name);$Kj[]="$y = VALUES($y)";}$yi=($wi=="INSERT+UPDATE"?"\nON DUPLICATE KEY UPDATE ".implode(", ",$Kj):"").";\n";}if($_POST["format"]!="sql"){if($wi=="table"){dump_csv($Ee);$wi="INSERT";}dump_csv($K);}else{if(!$pe)$pe="INSERT INTO ".table($R)." (".implode(", ",array_map('Adminer\idf_escape',$Ee)).") VALUES";foreach($K
as$y=>$X){if($ud[$y]){unset($K[$y]);continue;}$n=$o[$y];$K[$y]=($X!==null?unconvert_field($n,preg_match(number_type(),$n["type"])&&!preg_match('~\[~',$n["full_type"])&&is_numeric($X)?$X:q(($X===false?0:$X))):"NULL");}$Hh=($hf?"\n":" ")."(".implode(",\t",$K).")";if(!$Pa)$Pa=$pe.$Hh;elseif(JUSH=='mssql'?$Eb%1000!=0:strlen($Pa)+4+strlen($Hh)+strlen($yi)<$hf)$Pa
.=",$Hh";else{echo$Pa.$yi;$Pa=$pe.$Hh;}}$Eb++;}if($Pa)echo$Pa.$yi;}elseif($_POST["format"]=="sql")echo"-- ".str_replace("\n"," ",connection()->error)."\n";if($Ud)echo"SET IDENTITY_INSERT ".table($R)." OFF;\n";}}function
dumpFilename($Sd){return
friendly_url($Sd!=""?$Sd:(SERVER?:"localhost"));}function
dumpHeaders($Sd,$_f=false){$ug=$_POST["output"];$Pc=(preg_match('~sql~',$_POST["format"])?"sql":($_f?"tar":"csv"));header("Content-Type: ".($ug=="gz"?"application/x-gzip":($Pc=="tar"?"application/x-tar":($Pc=="sql"||$ug!="file"?"text/plain":"text/csv")."; charset=utf-8")));if($ug=="gz"){ob_start(function($Q){return
gzencode($Q);},1e6);}return$Pc;}function
dumpFooter(){if($_POST["format"]=="sql")echo"-- ".gmdate("Y-m-d H:i:s e")."\n";}function
importServerPath(){return"adminer.sql";}function
homepage(){echo'<p class="links">'.($_GET["ns"]==""&&support("database")?'<a href="'.h(ME).'database=">'.lang(65)."</a>\n":""),(support("scheme")?"<a href='".h(ME)."scheme='>".($_GET["ns"]!=""?lang(66):lang(67))."</a>\n":""),($_GET["ns"]!==""?'<a href="'.h(ME).'schema=">'.lang(68)."</a>\n":""),(support("privileges")?"<a href='".h(ME)."privileges='>".lang(69)."</a>\n":"");if($_GET["ns"]!=="")echo(support("routine")?"<a href='#routines'>".lang(70)."</a>\n":""),(support("sequence")?"<a href='#sequences'>".lang(71)."</a>\n":""),(support("type")?"<a href='#user-types'>".lang(6)."</a>\n":""),(support("event")?"<a href='#events'>".lang(72)."</a>\n":"");return
true;}function
navigation($wf){echo"<h1>".adminer()->name()." <span class='version'>".VERSION;$Hf=$_COOKIE["adminer_version"];echo" <a href='https://www.adminer.org/#download'".target_blank()." id='version'>".(version_compare(VERSION,$Hf)<0?h($Hf):"")."</a>","</span></h1>\n";switch_lang();if($wf=="auth"){$ug="";foreach((array)$_SESSION["pwds"]as$Mj=>$ai){foreach($ai
as$N=>$Hj){$B=h(get_setting("vendor-$Mj-$N")?:get_driver($Mj));foreach($Hj
as$V=>$F){if($F!==null){$Sb=$_SESSION["db"][$Mj][$N][$V];foreach(($Sb?array_keys($Sb):array(""))as$k)$ug
.="<li><a href='".h(auth_url($Mj,$N,$V,$k))."'>($B) ".h("$V@".($N!=""?adminer()->serverName($N):"").($k!=""?" - $k":""))."</a>\n";}}}}if($ug)echo"<ul id='logins'>\n$ug</ul>\n".script("mixin(qs('#logins'), {onmouseover: menuOver, onmouseout: menuOut});");}else{$T=array();if($_GET["ns"]!==""&&!$wf&&DB!=""){connection()->select_db(DB);$T=table_status('',true);}adminer()->syntaxHighlighting($T);adminer()->databasesPrint($wf);$ka=array();if(DB==""||!$wf){if(support("sql")){$ka[]="<a href='".h(ME)."sql='".bold(isset($_GET["sql"])&&!isset($_GET["import"])).">".lang(62)."</a>";$ka[]="<a href='".h(ME)."import='".bold(isset($_GET["import"])).">".lang(73)."</a>";}$ka[]="<a href='".h(ME)."dump=".urlencode(isset($_GET["table"])?$_GET["table"]:$_GET["select"])."' id='dump'".bold(isset($_GET["dump"])).">".lang(74)."</a>";}$Zd=$_GET["ns"]!==""&&!$wf&&DB!="";if($Zd)$ka[]='<a href="'.h(ME).'create="'.bold($_GET["create"]==="").">".lang(75)."</a>";echo($ka?"<p class='links'>\n".implode("\n",$ka)."\n":"");if($Zd){if($T)adminer()->tablesPrint($T);else
echo"<p class='message'>".lang(9)."</p>\n";}}}function
syntaxHighlighting(array$T){echo
script_src(preg_replace("~\\?.*~","",ME)."?file=jush.js&version=5.4.0",true);if(support("sql")){echo"<script".nonce().">\n";if($T){$Ve=array();foreach($T
as$R=>$U)$Ve[]=preg_quote($R,'/');echo"var jushLinks = { ".JUSH.":";json_row(js_escape(ME).(support("table")?"table":"select").'=$&','/\b('.implode('|',$Ve).')\b/g',false);if(support('routine')){foreach(routines()as$K)json_row(js_escape(ME).'function='.urlencode($K["SPECIFIC_NAME"]).'&name=$&','/\b'.preg_quote($K["ROUTINE_NAME"],'/').'(?=["`]?\()/g',false);}json_row('');echo"};\n";foreach(array("bac","bra","sqlite_quo","mssql_bra")as$X)echo"jushLinks.$X = jushLinks.".JUSH.";\n";if(isset($_GET["sql"])||isset($_GET["trigger"])||isset($_GET["check"])){$Ii=array_fill_keys(array_keys($T),array());foreach(driver()->allFields()as$R=>$o){foreach($o
as$n)$Ii[$R][]=$n["field"];}echo"addEventListener('DOMContentLoaded', () => { autocompleter = jush.autocompleteSql('".idf_escape("")."', ".json_encode($Ii)."); });\n";}}echo"</script>\n";}echo
script("syntaxHighlighting('".preg_replace('~^(\d\.?\d).*~s','\1',connection()->server_info)."', '".connection()->flavor."');");}function
databasesPrint($wf){$j=adminer()->databases();if(DB&&$j&&!in_array(DB,$j))array_unshift($j,DB);echo"<form action=''>\n<p id='dbs'>\n";hidden_fields_get();$Qb=script("mixin(qsl('select'), {onmousedown: dbMouseDown, onchange: dbChange});");echo"<label title='".lang(35)."'>".lang(76).": ".($j?html_select("db",array(""=>"")+$j,DB).$Qb:"<input name='db' value='".h(DB)."' autocapitalize='off' size='19'>\n")."</label>","<input type='submit' value='".lang(20)."'".($j?" class='hidden'":"").">\n";if(support("scheme")){if($wf!="db"&&DB!=""&&connection()->select_db(DB)){echo"<br><label>".lang(77).": ".html_select("ns",array(""=>"")+adminer()->schemas(),$_GET["ns"])."$Qb</label>";if($_GET["ns"]!="")set_schema($_GET["ns"]);}}foreach(array("import","sql","schema","dump","privileges")as$X){if(isset($_GET[$X])){echo
input_hidden($X);break;}}echo"</p></form>\n";}function
tablesPrint(array$T){echo"<ul id='tables'>".script("mixin(qs('#tables'), {onmouseover: menuOver, onmouseout: menuOut});");foreach($T
as$R=>$P){$R="$R";$B=adminer()->tableName($P);if($B!=""&&!$P["partition"])echo'<li><a href="'.h(ME).'select='.urlencode($R).'"'.bold($_GET["select"]==$R||$_GET["edit"]==$R,"select")." title='".lang(39)."'>".lang(78)."</a> ",(support("table")||support("indexes")?'<a href="'.h(ME).'table='.urlencode($R).'"'.bold(in_array($R,array($_GET["table"],$_GET["create"],$_GET["indexes"],$_GET["foreign"],$_GET["trigger"],$_GET["check"],$_GET["view"])),(is_view($P)?"view":"structure"))." title='".lang(40)."'>$B</a>":"<span>$B</span>")."\n";}echo"</ul>\n";}function
processList(){return
process_list();}function
killProcess($u){return
kill_process($u);}}class
Plugins{private
static$append=array('dumpFormat'=>true,'dumpOutput'=>true,'editRowPrint'=>true,'editFunctions'=>true,'config'=>true);var$plugins;var$error='';private$hooks=array();function
__construct($Pg){if($Pg===null){$Pg=array();$Ja="adminer-plugins";if(is_dir($Ja)){foreach(glob("$Ja/*.php")as$p)$ae=include_once"./$p";}$Kd=" href='https://www.adminer.org/plugins/#use'".target_blank();if(file_exists("$Ja.php")){$ae=include_once"./$Ja.php";if(is_array($ae)){foreach($ae
as$Og)$Pg[get_class($Og)]=$Og;}else$this->error
.=lang(79,"<b>$Ja.php</b>",$Kd)."<br>";}foreach(get_declared_classes()as$fb){if(!$Pg[$fb]&&preg_match('~^Adminer\w~i',$fb)){$sh=new
\ReflectionClass($fb);$zb=$sh->getConstructor();if($zb&&$zb->getNumberOfRequiredParameters())$this->error
.=lang(80,$Kd,"<b>$fb</b>","<b>$Ja.php</b>")."<br>";else$Pg[$fb]=new$fb;}}}$this->plugins=$Pg;$na=new
Adminer;$Pg[]=$na;$sh=new
\ReflectionObject($na);foreach($sh->getMethods()as$uf){foreach($Pg
as$Og){$B=$uf->getName();if(method_exists($Og,$B))$this->hooks[$B][]=$Og;}}}function
__call($B,array$zg){$wa=array();foreach($zg
as$y=>$X)$wa[]=&$zg[$y];$J=null;foreach($this->hooks[$B]as$Og){$Y=call_user_func_array(array($Og,$B),$wa);if($Y!==null){if(!self::$append[$B])return$Y;$J=$Y+(array)$J;}}return$J;}}abstract
class
Plugin{protected$translations=array();function
description(){return$this->lang('');}function
screenshot(){return"";}protected
function
lang($v,$Nf=null){$wa=func_get_args();$wa[0]=idx($this->translations[LANG],$v)?:$v;return
call_user_func_array('Adminer\lang_format',$wa);}}Adminer::$instance=(function_exists('adminer_object')?adminer_object():(is_dir("adminer-plugins")||file_exists("adminer-plugins.php")?new
Plugins(null):new
Adminer));SqlDriver::$drivers=array("server"=>"MySQL / MariaDB")+SqlDriver::$drivers;if(!defined('Adminer\DRIVER')){define('Adminer\DRIVER',"server");if(extension_loaded("mysqli")&&$_GET["ext"]!="pdo"){class
Db
extends
\MySQLi{static$instance;var$extension="MySQLi",$flavor='';function
__construct(){parent::init();}function
attach($N,$V,$F){mysqli_report(MYSQLI_REPORT_OFF);list($Od,$Qg)=host_port($N);$ri=adminer()->connectSsl();if($ri)$this->ssl_set($ri['key'],$ri['cert'],$ri['ca'],'','');$J=@$this->real_connect(($N!=""?$Od:ini_get("mysqli.default_host")),($N.$V!=""?$V:ini_get("mysqli.default_user")),($N.$V.$F!=""?$F:ini_get("mysqli.default_pw")),null,(is_numeric($Qg)?intval($Qg):ini_get("mysqli.default_port")),(is_numeric($Qg)?null:$Qg),($ri?($ri['verify']!==false?2048:64):0));$this->options(MYSQLI_OPT_LOCAL_INFILE,0);return($J?'':$this->error);}function
set_charset($Xa){if(parent::set_charset($Xa))return
true;parent::set_charset('utf8');return$this->query("SET NAMES $Xa");}function
next_result(){return
self::more_results()&&parent::next_result();}function
quote($Q){return"'".$this->escape_string($Q)."'";}}}elseif(extension_loaded("mysql")&&!((ini_bool("sql.safe_mode")||ini_bool("mysql.allow_local_infile"))&&extension_loaded("pdo_mysql"))){class
Db
extends
SqlDb{private$link;function
attach($N,$V,$F){if(ini_bool("mysql.allow_local_infile"))return
lang(81,"'mysql.allow_local_infile'","MySQLi","PDO_MySQL");$this->link=@mysql_connect(($N!=""?$N:ini_get("mysql.default_host")),($N.$V!=""?$V:ini_get("mysql.default_user")),($N.$V.$F!=""?$F:ini_get("mysql.default_password")),true,131072);if(!$this->link)return
mysql_error();$this->server_info=mysql_get_server_info($this->link);return'';}function
set_charset($Xa){if(function_exists('mysql_set_charset')){if(mysql_set_charset($Xa,$this->link))return
true;mysql_set_charset('utf8',$this->link);}return$this->query("SET NAMES $Xa");}function
quote($Q){return"'".mysql_real_escape_string($Q,$this->link)."'";}function
select_db($Pb){return
mysql_select_db($Pb,$this->link);}function
query($H,$sj=false){$I=@($sj?mysql_unbuffered_query($H,$this->link):mysql_query($H,$this->link));$this->error="";if(!$I){$this->errno=mysql_errno($this->link);$this->error=mysql_error($this->link);return
false;}if($I===true){$this->affected_rows=mysql_affected_rows($this->link);$this->info=mysql_info($this->link);return
true;}return
new
Result($I);}}class
Result{var$num_rows;private$result;private$offset=0;function
__construct($I){$this->result=$I;$this->num_rows=mysql_num_rows($I);}function
fetch_assoc(){return
mysql_fetch_assoc($this->result);}function
fetch_row(){return
mysql_fetch_row($this->result);}function
fetch_field(){$J=mysql_fetch_field($this->result,$this->offset++);$J->orgtable=$J->table;$J->charsetnr=($J->blob?63:0);return$J;}function
__destruct(){mysql_free_result($this->result);}}}elseif(extension_loaded("pdo_mysql")){class
Db
extends
PdoDb{var$extension="PDO_MySQL";function
attach($N,$V,$F){$fg=array(\PDO::MYSQL_ATTR_LOCAL_INFILE=>false);$ri=adminer()->connectSsl();if($ri){if($ri['key'])$fg[\PDO::MYSQL_ATTR_SSL_KEY]=$ri['key'];if($ri['cert'])$fg[\PDO::MYSQL_ATTR_SSL_CERT]=$ri['cert'];if($ri['ca'])$fg[\PDO::MYSQL_ATTR_SSL_CA]=$ri['ca'];if(isset($ri['verify']))$fg[\PDO::MYSQL_ATTR_SSL_VERIFY_SERVER_CERT]=$ri['verify'];}list($Od,$Qg)=host_port($N);return$this->dsn("mysql:charset=utf8;host=$Od".($Qg?(is_numeric($Qg)?";port=":";unix_socket=").$Qg:""),$V,$F,$fg);}function
set_charset($Xa){return$this->query("SET NAMES $Xa");}function
select_db($Pb){return$this->query("USE ".idf_escape($Pb));}function
query($H,$sj=false){$this->pdo->setAttribute(\PDO::MYSQL_ATTR_USE_BUFFERED_QUERY,!$sj);return
parent::query($H,$sj);}}}class
Driver
extends
SqlDriver{static$extensions=array("MySQLi","MySQL","PDO_MySQL");static$jush="sql";var$unsigned=array("unsigned","zerofill","unsigned zerofill");var$operators=array("=","<",">","<=",">=","!=","LIKE","LIKE %%","REGEXP","IN","FIND_IN_SET","IS NULL","NOT LIKE","NOT REGEXP","NOT IN","IS NOT NULL","SQL");var$functions=array("char_length","date","from_unixtime","lower","round","floor","ceil","sec_to_time","time_to_sec","upper");var$grouping=array("avg","count","count distinct","group_concat","max","min","sum");static
function
connect($N,$V,$F){$g=parent::connect($N,$V,$F);if(is_string($g)){if(function_exists('iconv')&&!is_utf8($g)&&strlen($Hh=iconv("windows-1250","utf-8",$g))>strlen($g))$g=$Hh;return$g;}$g->set_charset(charset($g));$g->query("SET sql_quote_show_create = 1, autocommit = 1");$g->flavor=(preg_match('~MariaDB~',$g->server_info)?'maria':'mysql');add_driver(DRIVER,($g->flavor=='maria'?"MariaDB":"MySQL"));return$g;}function
__construct(Db$g){parent::__construct($g);$this->types=array(lang(25)=>array("tinyint"=>3,"smallint"=>5,"mediumint"=>8,"int"=>10,"bigint"=>20,"decimal"=>66,"float"=>12,"double"=>21),lang(26)=>array("date"=>10,"datetime"=>19,"timestamp"=>19,"time"=>10,"year"=>4),lang(27)=>array("char"=>255,"varchar"=>65535,"tinytext"=>255,"text"=>65535,"mediumtext"=>16777215,"longtext"=>4294967295),lang(82)=>array("enum"=>65535,"set"=>64),lang(28)=>array("bit"=>20,"binary"=>255,"varbinary"=>65535,"tinyblob"=>255,"blob"=>65535,"mediumblob"=>16777215,"longblob"=>4294967295),lang(30)=>array("geometry"=>0,"point"=>0,"linestring"=>0,"polygon"=>0,"multipoint"=>0,"multilinestring"=>0,"multipolygon"=>0,"geometrycollection"=>0),);$this->insertFunctions=array("char"=>"md5/sha1/password/encrypt/uuid","binary"=>"md5/sha1","date|time"=>"now",);$this->editFunctions=array(number_type()=>"+/-","date"=>"+ interval/- interval","time"=>"addtime/subtime","char|text"=>"concat",);if(min_version('5.7.8',10.2,$g))$this->types[lang(27)]["json"]=4294967295;if(min_version('',10.7,$g)){$this->types[lang(27)]["uuid"]=128;$this->insertFunctions['uuid']='uuid';}if(min_version(9,'',$g)){$this->types[lang(25)]["vector"]=16383;$this->insertFunctions['vector']='string_to_vector';}if(min_version(5.1,'',$g))$this->partitionBy=array("HASH","LINEAR HASH","KEY","LINEAR KEY","RANGE","LIST");if(min_version(5.7,10.2,$g))$this->generated=array("STORED","VIRTUAL");}function
unconvertFunction(array$n){return(preg_match("~binary~",$n["type"])?"<code class='jush-sql'>UNHEX</code>":($n["type"]=="bit"?doc_link(array('sql'=>'bit-value-literals.html'),"<code>b''</code>"):(preg_match("~geometry|point|linestring|polygon~",$n["type"])?"<code class='jush-sql'>GeomFromText</code>":"")));}function
insert($R,array$O){return($O?parent::insert($R,$O):queries("INSERT INTO ".table($R)." ()\nVALUES ()"));}function
insertUpdate($R,array$L,array$G){$e=array_keys(reset($L));$Wg="INSERT INTO ".table($R)." (".implode(", ",$e).") VALUES\n";$Kj=array();foreach($e
as$y)$Kj[$y]="$y = VALUES($y)";$yi="\nON DUPLICATE KEY UPDATE ".implode(", ",$Kj);$Kj=array();$Re=0;foreach($L
as$O){$Y="(".implode(", ",$O).")";if($Kj&&(strlen($Wg)+$Re+strlen($Y)+strlen($yi)>1e6)){if(!queries($Wg.implode(",\n",$Kj).$yi))return
false;$Kj=array();$Re=0;}$Kj[]=$Y;$Re+=strlen($Y)+2;}return
queries($Wg.implode(",\n",$Kj).$yi);}function
slowQuery($H,$Ui){if(min_version('5.7.8','10.1.2')){if($this->conn->flavor=='maria')return"SET STATEMENT max_statement_time=$Ui FOR $H";elseif(preg_match('~^(SELECT\b)(.+)~is',$H,$A))return"$A[1] /*+ MAX_EXECUTION_TIME(".($Ui*1000).") */ $A[2]";}}function
convertSearch($v,array$X,array$n){return(preg_match('~char|text|enum|set~',$n["type"])&&!preg_match("~^utf8~",$n["collation"])&&preg_match('~[\x80-\xFF]~',$X['val'])?"CONVERT($v USING ".charset($this->conn).")":$v);}function
warnings(){$I=$this->conn->query("SHOW WARNINGS");if($I&&$I->num_rows){ob_start();print_select_result($I);return
ob_get_clean();}}function
tableHelp($B,$_e=false){$Ze=($this->conn->flavor=='maria');if(information_schema(DB))return
strtolower("information-schema-".($Ze?"$B-table/":str_replace("_","-",$B)."-table.html"));if(DB=="mysql")return($Ze?"mysql$B-table/":"system-schema.html");}function
partitionsInfo($R){$rd="FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA = ".q(DB)." AND TABLE_NAME = ".q($R);$I=$this->conn->query("SELECT PARTITION_METHOD, PARTITION_EXPRESSION, PARTITION_ORDINAL_POSITION $rd ORDER BY PARTITION_ORDINAL_POSITION DESC LIMIT 1");$J=array();list($J["partition_by"],$J["partition"],$J["partitions"])=$I->fetch_row();$Gg=get_key_vals("SELECT PARTITION_NAME, PARTITION_DESCRIPTION $rd AND PARTITION_NAME != '' ORDER BY PARTITION_ORDINAL_POSITION");$J["partition_names"]=array_keys($Gg);$J["partition_values"]=array_values($Gg);return$J;}function
hasCStyleEscapes(){static$Sa;if($Sa===null){$pi=get_val("SHOW VARIABLES LIKE 'sql_mode'",1,$this->conn);$Sa=(strpos($pi,'NO_BACKSLASH_ESCAPES')===false);}return$Sa;}function
engines(){$J=array();foreach(get_rows("SHOW ENGINES")as$K){if(preg_match("~YES|DEFAULT~",$K["Support"]))$J[]=$K["Engine"];}return$J;}function
indexAlgorithms(array$Bi){return(preg_match('~^(MEMORY|NDB)$~',$Bi["Engine"])?array("HASH","BTREE"):array());}}function
idf_escape($v){return"`".str_replace("`","``",$v)."`";}function
table($v){return
idf_escape($v);}function
get_databases($jd){$J=get_session("dbs");if($J===null){$H="SELECT SCHEMA_NAME FROM information_schema.SCHEMATA ORDER BY SCHEMA_NAME";$J=($jd?slow_query($H):get_vals($H));restart_session();set_session("dbs",$J);stop_session();}return$J;}function
limit($H,$Z,$z,$C=0,$Vh=" "){return" $H$Z".($z?$Vh."LIMIT $z".($C?" OFFSET $C":""):"");}function
limit1($R,$H,$Z,$Vh="\n"){return
limit($H,$Z,1,0,$Vh);}function
db_collation($k,array$lb){$J=null;$i=get_val("SHOW CREATE DATABASE ".idf_escape($k),1);if(preg_match('~ COLLATE ([^ ]+)~',$i,$A))$J=$A[1];elseif(preg_match('~ CHARACTER SET ([^ ]+)~',$i,$A))$J=$lb[$A[1]][-1];return$J;}function
logged_user(){return
get_val("SELECT USER()");}function
tables_list(){return
get_key_vals("SELECT TABLE_NAME, TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ORDER BY TABLE_NAME");}function
count_tables(array$j){$J=array();foreach($j
as$k)$J[$k]=count(get_vals("SHOW TABLES IN ".idf_escape($k)));return$J;}function
table_status($B="",$Vc=false){$J=array();foreach(get_rows($Vc?"SELECT TABLE_NAME AS Name, ENGINE AS Engine, TABLE_COMMENT AS Comment FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE() ".($B!=""?"AND TABLE_NAME = ".q($B):"ORDER BY Name"):"SHOW TABLE STATUS".($B!=""?" LIKE ".q(addcslashes($B,"%_\\")):""))as$K){if($K["Engine"]=="InnoDB")$K["Comment"]=preg_replace('~(?:(.+); )?InnoDB free: .*~','\1',$K["Comment"]);if(!isset($K["Engine"]))$K["Comment"]="";if($B!="")$K["Name"]=$B;$J[$K["Name"]]=$K;}return$J;}function
is_view(array$S){return$S["Engine"]===null;}function
fk_support(array$S){return
preg_match('~InnoDB|IBMDB2I'.(min_version(5.6)?'|NDB':'').'~i',$S["Engine"]);}function
fields($R){$Ze=(connection()->flavor=='maria');$J=array();foreach(get_rows("SELECT * FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ".q($R)." ORDER BY ORDINAL_POSITION")as$K){$n=$K["COLUMN_NAME"];$U=$K["COLUMN_TYPE"];$vd=$K["GENERATION_EXPRESSION"];$Sc=$K["EXTRA"];preg_match('~^(VIRTUAL|PERSISTENT|STORED)~',$Sc,$ud);preg_match('~^([^( ]+)(?:\((.+)\))?( unsigned)?( zerofill)?$~',$U,$cf);$l=$K["COLUMN_DEFAULT"];if($l!=""){$ze=preg_match('~text|json~',$cf[1]);if(!$Ze&&$ze)$l=preg_replace("~^(_\w+)?('.*')$~",'\2',stripslashes($l));if($Ze||$ze){$l=($l=="NULL"?null:preg_replace_callback("~^'(.*)'$~",function($A){return
stripslashes(str_replace("''","'",$A[1]));},$l));}if(!$Ze&&preg_match('~binary~',$cf[1])&&preg_match('~^0x(\w*)$~',$l,$A))$l=pack("H*",$A[1]);}$J[$n]=array("field"=>$n,"full_type"=>$U,"type"=>$cf[1],"length"=>$cf[2],"unsigned"=>ltrim($cf[3].$cf[4]),"default"=>($ud?($Ze?$vd:stripslashes($vd)):$l),"null"=>($K["IS_NULLABLE"]=="YES"),"auto_increment"=>($Sc=="auto_increment"),"on_update"=>(preg_match('~\bon update (\w+)~i',$Sc,$A)?$A[1]:""),"collation"=>$K["COLLATION_NAME"],"privileges"=>array_flip(explode(",","$K[PRIVILEGES],where,order")),"comment"=>$K["COLUMN_COMMENT"],"primary"=>($K["COLUMN_KEY"]=="PRI"),"generated"=>($ud[1]=="PERSISTENT"?"STORED":$ud[1]),);}return$J;}function
indexes($R,$h=null){$J=array();foreach(get_rows("SHOW INDEX FROM ".table($R),$h)as$K){$B=$K["Key_name"];$J[$B]["type"]=($B=="PRIMARY"?"PRIMARY":($K["Index_type"]=="FULLTEXT"?"FULLTEXT":($K["Non_unique"]?($K["Index_type"]=="SPATIAL"?"SPATIAL":"INDEX"):"UNIQUE")));$J[$B]["columns"][]=$K["Column_name"];$J[$B]["lengths"][]=($K["Index_type"]=="SPATIAL"?null:$K["Sub_part"]);$J[$B]["descs"][]=null;$J[$B]["algorithm"]=$K["Index_type"];}return$J;}function
foreign_keys($R){static$Kg='(?:`(?:[^`]|``)+`|"(?:[^"]|"")+")';$J=array();$Fb=get_val("SHOW CREATE TABLE ".table($R),1);if($Fb){preg_match_all("~CONSTRAINT ($Kg) FOREIGN KEY ?\\(((?:$Kg,? ?)+)\\) REFERENCES ($Kg)(?:\\.($Kg))? \\(((?:$Kg,? ?)+)\\)(?: ON DELETE (".driver()->onActions."))?(?: ON UPDATE (".driver()->onActions."))?~",$Fb,$df,PREG_SET_ORDER);foreach($df
as$A){preg_match_all("~$Kg~",$A[2],$ji);preg_match_all("~$Kg~",$A[5],$Mi);$J[idf_unescape($A[1])]=array("db"=>idf_unescape($A[4]!=""?$A[3]:$A[4]),"table"=>idf_unescape($A[4]!=""?$A[4]:$A[3]),"source"=>array_map('Adminer\idf_unescape',$ji[0]),"target"=>array_map('Adminer\idf_unescape',$Mi[0]),"on_delete"=>($A[6]?:"RESTRICT"),"on_update"=>($A[7]?:"RESTRICT"),);}}return$J;}function
view($B){return
array("select"=>preg_replace('~^(?:[^`]|`[^`]*`)*\s+AS\s+~isU','',get_val("SHOW CREATE VIEW ".table($B),1)));}function
collations(){$J=array();foreach(get_rows("SHOW COLLATION")as$K){if($K["Default"])$J[$K["Charset"]][-1]=$K["Collation"];else$J[$K["Charset"]][]=$K["Collation"];}ksort($J);foreach($J
as$y=>$X)sort($J[$y]);return$J;}function
information_schema($k){return($k=="information_schema")||(min_version(5.5)&&$k=="performance_schema");}function
error(){return
h(preg_replace('~^You have an error.*syntax to use~U',"Syntax error",connection()->error));}function
create_database($k,$c){return
queries("CREATE DATABASE ".idf_escape($k).($c?" COLLATE ".q($c):""));}function
drop_databases(array$j){$J=apply_queries("DROP DATABASE",$j,'Adminer\idf_escape');restart_session();set_session("dbs",null);return$J;}function
rename_database($B,$c){$J=false;if(create_database($B,$c)){$T=array();$Pj=array();foreach(tables_list()as$R=>$U){if($U=='VIEW')$Pj[]=$R;else$T[]=$R;}$J=(!$T&&!$Pj)||move_tables($T,$Pj,$B);drop_databases($J?array(DB):array());}return$J;}function
auto_increment(){$Ca=" PRIMARY KEY";if($_GET["create"]!=""&&$_POST["auto_increment_col"]){foreach(indexes($_GET["create"])as$w){if(in_array($_POST["fields"][$_POST["auto_increment_col"]]["orig"],$w["columns"],true)){$Ca="";break;}if($w["type"]=="PRIMARY")$Ca=" UNIQUE";}}return" AUTO_INCREMENT$Ca";}function
alter_table($R,$B,array$o,array$ld,$qb,$zc,$c,$Ba,$E){$b=array();foreach($o
as$n){if($n[1]){$l=$n[1][3];if(preg_match('~ GENERATED~',$l)){$n[1][3]=(connection()->flavor=='maria'?"":$n[1][2]);$n[1][2]=$l;}$b[]=($R!=""?($n[0]!=""?"CHANGE ".idf_escape($n[0]):"ADD"):" ")." ".implode($n[1]).($R!=""?$n[2]:"");}else$b[]="DROP ".idf_escape($n[0]);}$b=array_merge($b,$ld);$P=($qb!==null?" COMMENT=".q($qb):"").($zc?" ENGINE=".q($zc):"").($c?" COLLATE ".q($c):"").($Ba!=""?" AUTO_INCREMENT=$Ba":"");if($E){$Gg=array();if($E["partition_by"]=='RANGE'||$E["partition_by"]=='LIST'){foreach($E["partition_names"]as$y=>$X){$Y=$E["partition_values"][$y];$Gg[]="\n  PARTITION ".idf_escape($X)." VALUES ".($E["partition_by"]=='RANGE'?"LESS THAN":"IN").($Y!=""?" ($Y)":" MAXVALUE");}}$P
.="\nPARTITION BY $E[partition_by]($E[partition])";if($Gg)$P
.=" (".implode(",",$Gg)."\n)";elseif($E["partitions"])$P
.=" PARTITIONS ".(+$E["partitions"]);}elseif($E===null)$P
.="\nREMOVE PARTITIONING";if($R=="")return
queries("CREATE TABLE ".table($B)." (\n".implode(",\n",$b)."\n)$P");if($R!=$B)$b[]="RENAME TO ".table($B);if($P)$b[]=ltrim($P);return($b?queries("ALTER TABLE ".table($R)."\n".implode(",\n",$b)):true);}function
alter_indexes($R,$b){$Wa=array();foreach($b
as$X)$Wa[]=($X[2]=="DROP"?"\nDROP INDEX ".idf_escape($X[1]):"\nADD $X[0] ".($X[0]=="PRIMARY"?"KEY ":"").($X[1]!=""?idf_escape($X[1])." ":"")."(".implode(", ",$X[2]).")");return
queries("ALTER TABLE ".table($R).implode(",",$Wa));}function
truncate_tables(array$T){return
apply_queries("TRUNCATE TABLE",$T);}function
drop_views(array$Pj){return
queries("DROP VIEW ".implode(", ",array_map('Adminer\table',$Pj)));}function
drop_tables(array$T){return
queries("DROP TABLE ".implode(", ",array_map('Adminer\table',$T)));}function
move_tables(array$T,array$Pj,$Mi){$wh=array();foreach($T
as$R)$wh[]=table($R)." TO ".idf_escape($Mi).".".table($R);if(!$wh||queries("RENAME TABLE ".implode(", ",$wh))){$Yb=array();foreach($Pj
as$R)$Yb[table($R)]=view($R);connection()->select_db($Mi);$k=idf_escape(DB);foreach($Yb
as$B=>$Oj){if(!queries("CREATE VIEW $B AS ".str_replace(" $k."," ",$Oj["select"]))||!queries("DROP VIEW $k.$B"))return
false;}return
true;}return
false;}function
copy_tables(array$T,array$Pj,$Mi){queries("SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO'");foreach($T
as$R){$B=($Mi==DB?table("copy_$R"):idf_escape($Mi).".".table($R));if(($_POST["overwrite"]&&!queries("\nDROP TABLE IF EXISTS $B"))||!queries("CREATE TABLE $B LIKE ".table($R))||!queries("INSERT INTO $B SELECT * FROM ".table($R)))return
false;foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K){$lj=$K["Trigger"];if(!queries("CREATE TRIGGER ".($Mi==DB?idf_escape("copy_$lj"):idf_escape($Mi).".".idf_escape($lj))." $K[Timing] $K[Event] ON $B FOR EACH ROW\n$K[Statement];"))return
false;}}foreach($Pj
as$R){$B=($Mi==DB?table("copy_$R"):idf_escape($Mi).".".table($R));$Oj=view($R);if(($_POST["overwrite"]&&!queries("DROP VIEW IF EXISTS $B"))||!queries("CREATE VIEW $B AS $Oj[select]"))return
false;}return
true;}function
trigger($B,$R){if($B=="")return
array();$L=get_rows("SHOW TRIGGERS WHERE `Trigger` = ".q($B));return
reset($L);}function
triggers($R){$J=array();foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")))as$K)$J[$K["Trigger"]]=array($K["Timing"],$K["Event"]);return$J;}function
trigger_options(){return
array("Timing"=>array("BEFORE","AFTER"),"Event"=>array("INSERT","UPDATE","DELETE"),"Type"=>array("FOR EACH ROW"),);}function
routine($B,$U){$ta=array("bool","boolean","integer","double precision","real","dec","numeric","fixed","national char","national varchar");$ki="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|-- )[^\n]*\n?|--\r?\n)";$Ac=driver()->enumLength;$qj="((".implode("|",array_merge(array_keys(driver()->types()),$ta)).")\\b(?:\\s*\\(((?:[^'\")]|$Ac)++)\\))?"."\\s*(zerofill\\s*)?(unsigned(?:\\s+zerofill)?)?)(?:\\s*(?:CHARSET|CHARACTER\\s+SET)\\s*['\"]?([^'\"\\s,]+)['\"]?)?(?:\\s*COLLATE\\s*['\"]?([^'\"\\s,]+)['\"]?)?";$Kg="$ki*(".($U=="FUNCTION"?"":driver()->inout).")?\\s*(?:`((?:[^`]|``)*)`\\s*|\\b(\\S+)\\s+)$qj";$i=get_val("SHOW CREATE $U ".idf_escape($B),2);preg_match("~\\(((?:$Kg\\s*,?)*)\\)\\s*".($U=="FUNCTION"?"RETURNS\\s+$qj\\s+":"")."(.*)~is",$i,$A);$o=array();preg_match_all("~$Kg\\s*,?~is",$A[1],$df,PREG_SET_ORDER);foreach($df
as$yg)$o[]=array("field"=>str_replace("``","`",$yg[2]).$yg[3],"type"=>strtolower($yg[5]),"length"=>preg_replace_callback("~$Ac~s",'Adminer\normalize_enum',$yg[6]),"unsigned"=>strtolower(preg_replace('~\s+~',' ',trim("$yg[8] $yg[7]"))),"null"=>true,"full_type"=>$yg[4],"inout"=>strtoupper($yg[1]),"collation"=>strtolower($yg[9]),);return
array("fields"=>$o,"comment"=>get_val("SELECT ROUTINE_COMMENT FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = ".q($B)),)+($U!="FUNCTION"?array("definition"=>$A[11]):array("returns"=>array("type"=>$A[12],"length"=>$A[13],"unsigned"=>$A[15],"collation"=>$A[16]),"definition"=>$A[17],"language"=>"SQL",));}function
routines(){return
get_rows("SELECT SPECIFIC_NAME, ROUTINE_NAME, ROUTINE_TYPE, DTD_IDENTIFIER FROM information_schema.ROUTINES WHERE ROUTINE_SCHEMA = DATABASE()");}function
routine_languages(){return
array();}function
routine_id($B,array$K){return
idf_escape($B);}function
last_id($I){return
get_val("SELECT LAST_INSERT_ID()");}function
explain(Db$g,$H){return$g->query("EXPLAIN ".(min_version(5.1)&&!min_version(5.7)?"PARTITIONS ":"").$H);}function
found_rows(array$S,array$Z){return($Z||$S["Engine"]!="InnoDB"?null:$S["Rows"]);}function
create_sql($R,$Ba,$wi){$J=get_val("SHOW CREATE TABLE ".table($R),1);if(!$Ba)$J=preg_replace('~ AUTO_INCREMENT=\d+~','',$J);return$J;}function
truncate_sql($R){return"TRUNCATE ".table($R);}function
use_sql($Pb,$wi=""){$B=idf_escape($Pb);$J="";if(preg_match('~CREATE~',$wi)&&($i=get_val("SHOW CREATE DATABASE $B",1))){set_utf8mb4($i);if($wi=="DROP+CREATE")$J="DROP DATABASE IF EXISTS $B;\n";$J
.="$i;\n";}return$J."USE $B";}function
trigger_sql($R){$J="";foreach(get_rows("SHOW TRIGGERS LIKE ".q(addcslashes($R,"%_\\")),null,"-- ")as$K)$J
.="\nCREATE TRIGGER ".idf_escape($K["Trigger"])." $K[Timing] $K[Event] ON ".table($K["Table"])." FOR EACH ROW\n$K[Statement];;\n";return$J;}function
show_variables(){return
get_rows("SHOW VARIABLES");}function
show_status(){return
get_rows("SHOW STATUS");}function
process_list(){return
get_rows("SHOW FULL PROCESSLIST");}function
convert_field(array$n){if(preg_match("~binary~",$n["type"]))return"HEX(".idf_escape($n["field"]).")";if($n["type"]=="bit")return"BIN(".idf_escape($n["field"])." + 0)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"]))return(min_version(8)?"ST_":"")."AsWKT(".idf_escape($n["field"]).")";}function
unconvert_field(array$n,$J){if(preg_match("~binary~",$n["type"]))$J="UNHEX($J)";if($n["type"]=="bit")$J="CONVERT(b$J, UNSIGNED)";if(preg_match("~geometry|point|linestring|polygon~",$n["type"])){$Wg=(min_version(8)?"ST_":"");$J=$Wg."GeomFromText($J, $Wg"."SRID($n[field]))";}return$J;}function
support($Wc){return
preg_match('~^(comment|columns|copy|database|drop_col|dump|indexes|kill|privileges|move_col|procedure|processlist|routine|sql|status|table|trigger|variables|view'.(min_version(5.1)?'|event':'').(min_version(8)?'|descidx':'').(min_version('8.0.16','10.2.1')?'|check':'').')$~',$Wc);}function
kill_process($u){return
queries("KILL ".number($u));}function
connection_id(){return"SELECT CONNECTION_ID()";}function
max_connections(){return
get_val("SELECT @@max_connections");}function
types(){return
array();}function
type_values($u){return"";}function
schemas(){return
array();}function
get_schema(){return"";}function
set_schema($Jh,$h=null){return
true;}}define('Adminer\JUSH',Driver::$jush);define('Adminer\SERVER',"".$_GET[DRIVER]);define('Adminer\DB',"$_GET[db]");define('Adminer\ME',preg_replace('~\?.*~','',relative_uri()).'?'.(sid()?SID.'&':'').(SERVER!==null?DRIVER."=".urlencode(SERVER).'&':'').($_GET["ext"]?"ext=".urlencode($_GET["ext"]).'&':'').(isset($_GET["username"])?"username=".urlencode($_GET["username"]).'&':'').(DB!=""?'db='.urlencode(DB).'&'.(isset($_GET["ns"])?"ns=".urlencode($_GET["ns"])."&":""):''));function
page_header($Wi,$m="",$Oa=array(),$Xi=""){page_headers();if(is_ajax()&&$m){page_messages($m);exit;}if(!ob_get_level())ob_start('ob_gzhandler',4096);$Yi=$Wi.($Xi!=""?": $Xi":"");$Zi=strip_tags($Yi.(SERVER!=""&&SERVER!="localhost"?h(" - ".SERVER):"")." - ".adminer()->name());echo'<!DOCTYPE html>
<html lang="',LANG,'" dir="',lang(83),'">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="robots" content="noindex">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>',$Zi,'</title>
<link rel="stylesheet" href="',h(preg_replace("~\\?.*~","",ME)."?file=default.css&version=5.4.0"),'">
';$Jb=adminer()->css();if(is_int(key($Jb)))$Jb=array_fill_keys($Jb,'light');$Gd=in_array('light',$Jb)||in_array('',$Jb);$Ed=in_array('dark',$Jb)||in_array('',$Jb);$Mb=($Gd?($Ed?null:false):($Ed?:null));$nf=" media='(prefers-color-scheme: dark)'";if($Mb!==false)echo"<link rel='stylesheet'".($Mb?"":$nf)." href='".h(preg_replace("~\\?.*~","",ME)."?file=dark.css&version=5.4.0")."'>\n";echo"<meta name='color-scheme' content='".($Mb===null?"light dark":($Mb?"dark":"light"))."'>\n",script_src(preg_replace("~\\?.*~","",ME)."?file=functions.js&version=5.4.0");if(adminer()->head($Mb))echo"<link rel='icon' href='data:image/gif;base64,R0lGODlhEAAQAJEAAAQCBPz+/PwCBAROZCH5BAEAAAAALAAAAAAQABAAAAI2hI+pGO1rmghihiUdvUBnZ3XBQA7f05mOak1RWXrNq5nQWHMKvuoJ37BhVEEfYxQzHjWQ5qIAADs='>\n","<link rel='apple-touch-icon' href='".h(preg_replace("~\\?.*~","",ME)."?file=logo.png&version=5.4.0")."'>\n";foreach($Jb
as$Bj=>$xf){$_a=($xf=='dark'&&!$Mb?$nf:($xf=='light'&&$Ed?" media='(prefers-color-scheme: light)'":""));echo"<link rel='stylesheet'$_a href='".h($Bj)."'>\n";}echo"\n<body class='".lang(83)." nojs";adminer()->bodyClass();echo"'>\n";$p=get_temp_dir()."/adminer.version";if(!$_COOKIE["adminer_version"]&&function_exists('openssl_verify')&&file_exists($p)&&filemtime($p)+86400>time()){$Nj=unserialize(file_get_contents($p));$gh="-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwqWOVuF5uw7/+Z70djoK
RlHIZFZPO0uYRezq90+7Amk+FDNd7KkL5eDve+vHRJBLAszF/7XKXe11xwliIsFs
DFWQlsABVZB3oisKCBEuI71J4kPH8dKGEWR9jDHFw3cWmoH3PmqImX6FISWbG3B8
h7FIx3jEaw5ckVPVTeo5JRm/1DZzJxjyDenXvBQ/6o9DgZKeNDgxwKzH+sw9/YCO
jHnq1cFpOIISzARlrHMa/43YfeNRAm/tsBXjSxembBPo7aQZLAWHmaj5+K19H10B
nCpz9Y++cipkVEiKRGih4ZEvjoFysEOdRLj6WiD/uUNky4xGeA6LaJqh5XpkFkcQ
fQIDAQAB
-----END PUBLIC KEY-----
";if(openssl_verify($Nj["version"],base64_decode($Nj["signature"]),$gh)==1)$_COOKIE["adminer_version"]=$Nj["version"];}echo
script("mixin(document.body, {onkeydown: bodyKeydown, onclick: bodyClick".(isset($_COOKIE["adminer_version"])?"":", onload: partial(verifyVersion, '".VERSION."', '".js_escape(ME)."', '".get_token()."')")."});
document.body.classList.replace('nojs', 'js');
const offlineMessage = '".js_escape(lang(84))."';
const thousandsSeparator = '".js_escape(lang(4))."';"),"<div id='help' class='jush-".JUSH." jsonly hidden'></div>\n",script("mixin(qs('#help'), {onmouseover: () => { helpOpen = 1; }, onmouseout: helpMouseout});"),"<div id='content'>\n","<span id='menuopen' class='jsonly'>".icon("move","","menu","")."</span>".script("qs('#menuopen').onclick = event => { qs('#foot').classList.toggle('foot'); event.stopPropagation(); }");if($Oa!==null){$_=substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1);echo'<p id="breadcrumb"><a href="'.h($_?:".").'">'.get_driver(DRIVER).'</a> » ';$_=substr(preg_replace('~\b(db|ns)=[^&]*&~','',ME),0,-1);$N=adminer()->serverName(SERVER);$N=($N!=""?$N:lang(32));if($Oa===false)echo"$N\n";else{echo"<a href='".h($_)."' accesskey='1' title='Alt+Shift+1'>$N</a> » ";if($_GET["ns"]!=""||(DB!=""&&is_array($Oa)))echo'<a href="'.h($_."&db=".urlencode(DB).(support("scheme")?"&ns=":"")).'">'.h(DB).'</a> » ';if(is_array($Oa)){if($_GET["ns"]!="")echo'<a href="'.h(substr(ME,0,-1)).'">'.h($_GET["ns"]).'</a> » ';foreach($Oa
as$y=>$X){$ac=(is_array($X)?$X[1]:h($X));if($ac!="")echo"<a href='".h(ME."$y=").urlencode(is_array($X)?$X[0]:$X)."'>$ac</a> » ";}}echo"$Wi\n";}}echo"<h2>$Yi</h2>\n","<div id='ajaxstatus' class='jsonly hidden'></div>\n";restart_session();page_messages($m);$j=&get_session("dbs");if(DB!=""&&$j&&!in_array(DB,$j,true))$j=null;stop_session();define('Adminer\PAGE_HEADER',1);}function
page_headers(){header("Content-Type: text/html; charset=utf-8");header("Cache-Control: no-cache");header("X-Frame-Options: deny");header("X-XSS-Protection: 0");header("X-Content-Type-Options: nosniff");header("Referrer-Policy: origin-when-cross-origin");foreach(adminer()->csp(csp())as$Ib){$Id=array();foreach($Ib
as$y=>$X)$Id[]="$y $X";header("Content-Security-Policy: ".implode("; ",$Id));}adminer()->headers();}function
csp(){return
array(array("script-src"=>"'self' 'unsafe-inline' 'nonce-".get_nonce()."' 'strict-dynamic'","connect-src"=>"'self'","frame-src"=>"https://www.adminer.org","object-src"=>"'none'","base-uri"=>"'none'","form-action"=>"'self'",),);}function
get_nonce(){static$Jf;if(!$Jf)$Jf=base64_encode(rand_string());return$Jf;}function
page_messages($m){$Aj=preg_replace('~^[^?]*~','',$_SERVER["REQUEST_URI"]);$tf=idx($_SESSION["messages"],$Aj);if($tf){echo"<div class='message'>".implode("</div>\n<div class='message'>",$tf)."</div>".script("messagesPrint();");unset($_SESSION["messages"][$Aj]);}if($m)echo"<div class='error'>$m</div>\n";if(adminer()->error)echo"<div class='error'>".adminer()->error."</div>\n";}function
page_footer($wf=""){echo"</div>\n\n<div id='foot' class='foot'>\n<div id='menu'>\n";adminer()->navigation($wf);echo"</div>\n";if($wf!="auth")echo'<form action="" method="post">
<p class="logout">
<span>',h($_GET["username"])."\n",'</span>
<input type="submit" name="logout" value="',lang(85),'" id="logout">
',input_token(),'</form>
';echo"</div>\n\n",script("setupSubmitHighlight(document);");}function
int32($Bf){while($Bf>=2147483648)$Bf-=4294967296;while($Bf<=-2147483649)$Bf+=4294967296;return(int)$Bf;}function
long2str(array$W,$Rj){$Hh='';foreach($W
as$X)$Hh
.=pack('V',$X);if($Rj)return
substr($Hh,0,end($W));return$Hh;}function
str2long($Hh,$Rj){$W=array_values(unpack('V*',str_pad($Hh,4*ceil(strlen($Hh)/4),"\0")));if($Rj)$W[]=strlen($Hh);return$W;}function
xxtea_mx($Yj,$Xj,$zi,$Ce){return
int32((($Yj>>5&0x7FFFFFF)^$Xj<<2)+(($Xj>>3&0x1FFFFFFF)^$Yj<<4))^int32(($zi^$Xj)+($Ce^$Yj));}function
encrypt_string($ui,$y){if($ui=="")return"";$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($ui,true);$Bf=count($W)-1;$Yj=$W[$Bf];$Xj=$W[0];$hh=floor(6+52/($Bf+1));$zi=0;while($hh-->0){$zi=int32($zi+0x9E3779B9);$qc=$zi>>2&3;for($wg=0;$wg<$Bf;$wg++){$Xj=$W[$wg+1];$Af=xxtea_mx($Yj,$Xj,$zi,$y[$wg&3^$qc]);$Yj=int32($W[$wg]+$Af);$W[$wg]=$Yj;}$Xj=$W[0];$Af=xxtea_mx($Yj,$Xj,$zi,$y[$wg&3^$qc]);$Yj=int32($W[$Bf]+$Af);$W[$Bf]=$Yj;}return
long2str($W,false);}function
decrypt_string($ui,$y){if($ui=="")return"";if(!$y)return
false;$y=array_values(unpack("V*",pack("H*",md5($y))));$W=str2long($ui,false);$Bf=count($W)-1;$Yj=$W[$Bf];$Xj=$W[0];$hh=floor(6+52/($Bf+1));$zi=int32($hh*0x9E3779B9);while($zi){$qc=$zi>>2&3;for($wg=$Bf;$wg>0;$wg--){$Yj=$W[$wg-1];$Af=xxtea_mx($Yj,$Xj,$zi,$y[$wg&3^$qc]);$Xj=int32($W[$wg]-$Af);$W[$wg]=$Xj;}$Yj=$W[$Bf];$Af=xxtea_mx($Yj,$Xj,$zi,$y[$wg&3^$qc]);$Xj=int32($W[0]-$Af);$W[0]=$Xj;$zi=int32($zi-0x9E3779B9);}return
long2str($W,true);}$Mg=array();if($_COOKIE["adminer_permanent"]){foreach(explode(" ",$_COOKIE["adminer_permanent"])as$X){list($y)=explode(":",$X);$Mg[$y]=$X;}}function
add_invalid_login(){$Ha=get_temp_dir()."/adminer.invalid";foreach(glob("$Ha*")?:array($Ha)as$p){$r=file_open_lock($p);if($r)break;}if(!$r)$r=file_open_lock("$Ha-".rand_string());if(!$r)return;$ue=unserialize(stream_get_contents($r));$Ti=time();if($ue){foreach($ue
as$ve=>$X){if($X[0]<$Ti)unset($ue[$ve]);}}$te=&$ue[adminer()->bruteForceKey()];if(!$te)$te=array($Ti+30*60,0);$te[1]++;file_write_unlock($r,serialize($ue));}function
check_invalid_login(array&$Mg){$ue=array();foreach(glob(get_temp_dir()."/adminer.invalid*")as$p){$r=file_open_lock($p);if($r){$ue=unserialize(stream_get_contents($r));file_unlock($r);break;}}$te=idx($ue,adminer()->bruteForceKey(),array());$If=($te[1]>29?$te[0]-time():0);if($If>0)auth_error(lang(86,ceil($If/60)),$Mg);}$Aa=$_POST["auth"];if($Aa){session_regenerate_id();$Mj=$Aa["driver"];$N=$Aa["server"];$V=$Aa["username"];$F=(string)$Aa["password"];$k=$Aa["db"];set_password($Mj,$N,$V,$F);$_SESSION["db"][$Mj][$N][$V][$k]=true;if($Aa["permanent"]){$y=implode("-",array_map('base64_encode',array($Mj,$N,$V,$k)));$bh=adminer()->permanentLogin(true);$Mg[$y]="$y:".base64_encode($bh?encrypt_string($F,$bh):"");cookie("adminer_permanent",implode(" ",$Mg));}if(count($_POST)==1||DRIVER!=$Mj||SERVER!=$N||$_GET["username"]!==$V||DB!=$k)redirect(auth_url($Mj,$N,$V,$k));}elseif($_POST["logout"]&&(!$_SESSION["token"]||verify_token())){foreach(array("pwds","db","dbs","queries")as$y)set_session($y,null);unset_permanent($Mg);redirect(substr(preg_replace('~\b(username|db|ns)=[^&]*&~','',ME),0,-1),lang(87).' '.lang(88));}elseif($Mg&&!$_SESSION["pwds"]){session_regenerate_id();$bh=adminer()->permanentLogin();foreach($Mg
as$y=>$X){list(,$eb)=explode(":",$X);list($Mj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));set_password($Mj,$N,$V,decrypt_string(base64_decode($eb),$bh));$_SESSION["db"][$Mj][$N][$V][$k]=true;}}function
unset_permanent(array&$Mg){foreach($Mg
as$y=>$X){list($Mj,$N,$V,$k)=array_map('base64_decode',explode("-",$y));if($Mj==DRIVER&&$N==SERVER&&$V==$_GET["username"]&&$k==DB)unset($Mg[$y]);}cookie("adminer_permanent",implode(" ",$Mg));}function
auth_error($m,array&$Mg){$bi=session_name();if(isset($_GET["username"])){header("HTTP/1.1 403 Forbidden");if(($_COOKIE[$bi]||$_GET[$bi])&&!$_SESSION["token"])$m=lang(89);else{restart_session();add_invalid_login();$F=get_password();if($F!==null){if($F===false)$m
.=($m?'<br>':'').lang(90,target_blank(),'<code>permanentLogin()</code>');set_password(DRIVER,SERVER,$_GET["username"],null);}unset_permanent($Mg);}}if(!$_COOKIE[$bi]&&$_GET[$bi]&&ini_bool("session.use_only_cookies"))$m=lang(91);$zg=session_get_cookie_params();cookie("adminer_key",($_COOKIE["adminer_key"]?:rand_string()),$zg["lifetime"]);if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);page_header(lang(36),$m,null);echo"<form action='' method='post'>\n","<div>";if(hidden_fields($_POST,array("auth")))echo"<p class='message'>".lang(92)."\n";echo"</div>\n";adminer()->loginForm();echo"</form>\n";page_footer("auth");exit;}if(isset($_GET["username"])&&!class_exists('Adminer\Db')){unset($_SESSION["pwds"][DRIVER]);unset_permanent($Mg);page_header(lang(93),lang(94,implode(", ",Driver::$extensions)),false);page_footer("auth");exit;}$g='';if(isset($_GET["username"])&&is_string(get_password())){list(,$Qg)=host_port(SERVER);if(preg_match('~^\s*([-+]?\d+)~',$Qg,$A)&&($A[1]<1024||$A[1]>65535))auth_error(lang(95),$Mg);check_invalid_login($Mg);$Hb=adminer()->credentials();$g=Driver::connect($Hb[0],$Hb[1],$Hb[2]);if(is_object($g)){Db::$instance=$g;Driver::$instance=new
Driver($g);if($g->flavor)save_settings(array("vendor-".DRIVER."-".SERVER=>get_driver(DRIVER)));}}$Xe=null;if(!is_object($g)||($Xe=adminer()->login($_GET["username"],get_password()))!==true){$m=(is_string($g)?nl_br(h($g)):(is_string($Xe)?$Xe:lang(96))).(preg_match('~^ | $~',get_password())?'<br>'.lang(97):'');auth_error($m,$Mg);}if($_POST["logout"]&&$_SESSION["token"]&&!verify_token()){page_header(lang(85),lang(98));page_footer("db");exit;}if(!$_SESSION["token"])$_SESSION["token"]=rand(1,1e6);stop_session(true);if($Aa&&$_POST["token"])$_POST["token"]=get_token();$m='';if($_POST){if(!verify_token()){$me="max_input_vars";$lf=ini_get($me);if(extension_loaded("suhosin")){foreach(array("suhosin.request.max_vars","suhosin.post.max_vars")as$y){$X=ini_get($y);if($X&&(!$lf||$X<$lf)){$me=$y;$lf=$X;}}}$m=(!$_POST["token"]&&$lf?lang(99,"'$me'"):lang(98).' '.lang(100));}}elseif($_SERVER["REQUEST_METHOD"]=="POST"){$m=lang(101,"'post_max_size'");if(isset($_GET["sql"]))$m
.=' '.lang(102);}function
print_select_result($I,$h=null,array$lg=array(),$z=0){$Ve=array();$x=array();$e=array();$Ma=array();$rj=array();$J=array();for($t=0;(!$z||$t<$z)&&($K=$I->fetch_row());$t++){if(!$t){echo"<div class='scrollable'>\n","<table class='nowrap odds'>\n","<thead><tr>";for($Ae=0;$Ae<count($K);$Ae++){$n=$I->fetch_field();$B=$n->name;$kg=(isset($n->orgtable)?$n->orgtable:"");$jg=(isset($n->orgname)?$n->orgname:$B);if($lg&&JUSH=="sql")$Ve[$Ae]=($B=="table"?"table=":($B=="possible_keys"?"indexes=":null));elseif($kg!=""){if(isset($n->table))$J[$n->table]=$kg;if(!isset($x[$kg])){$x[$kg]=array();foreach(indexes($kg,$h)as$w){if($w["type"]=="PRIMARY"){$x[$kg]=array_flip($w["columns"]);break;}}$e[$kg]=$x[$kg];}if(isset($e[$kg][$jg])){unset($e[$kg][$jg]);$x[$kg][$jg]=$Ae;$Ve[$Ae]=$kg;}}if($n->charsetnr==63)$Ma[$Ae]=true;$rj[$Ae]=$n->type;echo"<th".($kg!=""||$n->name!=$jg?" title='".h(($kg!=""?"$kg.":"").$jg)."'":"").">".h($B).($lg?doc_link(array('sql'=>"explain-output.html#explain_".strtolower($B),'mariadb'=>"explain/#the-columns-in-explain-select",)):"");}echo"</thead>\n";}echo"<tr>";foreach($K
as$y=>$X){$_="";if(isset($Ve[$y])&&!$e[$Ve[$y]]){if($lg&&JUSH=="sql"){$R=$K[array_search("table=",$Ve)];$_=ME.$Ve[$y].urlencode($lg[$R]!=""?$lg[$R]:$R);}else{$_=ME."edit=".urlencode($Ve[$y]);foreach($x[$Ve[$y]]as$jb=>$Ae)$_
.="&where".urlencode("[".bracket_escape($jb)."]")."=".urlencode($K[$Ae]);}}elseif(is_url($X))$_=$X;if($X===null)$X="<i>NULL</i>";elseif($Ma[$y]&&!is_utf8($X))$X="<i>".lang(45,strlen($X))."</i>";else{$X=h($X);if($rj[$y]==254)$X="<code>$X</code>";}if($_)$X="<a href='".h($_)."'".(is_url($_)?target_blank():'').">$X</a>";echo"<td".($rj[$y]<=9||$rj[$y]==246?" class='number'":"").">$X";}}echo($t?"</table>\n</div>":"<p class='message'>".lang(12))."\n";return$J;}function
referencable_primary($Th){$J=array();foreach(table_status('',true)as$Di=>$R){if($Di!=$Th&&fk_support($R)){foreach(fields($Di)as$n){if($n["primary"]){if($J[$Di]){unset($J[$Di]);break;}$J[$Di]=$n;}}}}return$J;}function
textarea($B,$Y,$L=10,$mb=80){echo"<textarea name='".h($B)."' rows='$L' cols='$mb' class='sqlarea jush-".JUSH."' spellcheck='false' wrap='off'>";if(is_array($Y)){foreach($Y
as$X)echo
h($X[0])."\n\n\n";}else
echo
h($Y);echo"</textarea>";}function
select_input($_a,array$fg,$Y="",$Zf="",$Ng=""){$Li=($fg?"select":"input");return"<$Li$_a".($fg?"><option value=''>$Ng".optionlist($fg,$Y,true)."</select>":" size='10' value='".h($Y)."' placeholder='$Ng'>").($Zf?script("qsl('$Li').onchange = $Zf;",""):"");}function
json_row($y,$X=null,$Hc=true){static$dd=true;if($dd)echo"{";if($y!=""){echo($dd?"":",")."\n\t\"".addcslashes($y,"\r\n\t\"\\/").'": '.($X!==null?($Hc?'"'.addcslashes($X,"\r\n\"\\/").'"':$X):'null');$dd=false;}else{echo"\n}\n";$dd=true;}}function
edit_type($y,array$n,array$lb,array$nd=array(),array$Tc=array()){$U=$n["type"];echo"<td><select name='".h($y)."[type]' class='type' aria-labelledby='label-type'>";if($U&&!array_key_exists($U,driver()->types())&&!isset($nd[$U])&&!in_array($U,$Tc))$Tc[]=$U;$vi=driver()->structuredTypes();if($nd)$vi[lang(103)]=$nd;echo
optionlist(array_merge($Tc,$vi),$U),"</select><td>","<input name='".h($y)."[length]' value='".h($n["length"])."' size='3'".(!$n["length"]&&preg_match('~var(char|binary)$~',$U)?" class='required'":"")." aria-labelledby='label-length'>","<td class='options'>",($lb?"<input list='collations' name='".h($y)."[collation]'".(preg_match('~(char|text|enum|set)$~',$U)?"":" class='hidden'")." value='".h($n["collation"])."' placeholder='(".lang(104).")'>":''),(driver()->unsigned?"<select name='".h($y)."[unsigned]'".(!$U||preg_match(number_type(),$U)?"":" class='hidden'").'><option>'.optionlist(driver()->unsigned,$n["unsigned"]).'</select>':''),(isset($n['on_update'])?"<select name='".h($y)."[on_update]'".(preg_match('~timestamp|datetime~',$U)?"":" class='hidden'").'>'.optionlist(array(""=>"(".lang(105).")","CURRENT_TIMESTAMP"),(preg_match('~^CURRENT_TIMESTAMP~i',$n["on_update"])?"CURRENT_TIMESTAMP":$n["on_update"])).'</select>':''),($nd?"<select name='".h($y)."[on_delete]'".(preg_match("~`~",$U)?"":" class='hidden'")."><option value=''>(".lang(106).")".optionlist(explode("|",driver()->onActions),$n["on_delete"])."</select> ":" ");}function
process_length($Re){$Cc=driver()->enumLength;return(preg_match("~^\\s*\\(?\\s*$Cc(?:\\s*,\\s*$Cc)*+\\s*\\)?\\s*\$~",$Re)&&preg_match_all("~$Cc~",$Re,$df)?"(".implode(",",$df[0]).")":preg_replace('~^[0-9].*~','(\0)',preg_replace('~[^-0-9,+()[\]]~','',$Re)));}function
process_type(array$n,$kb="COLLATE"){return" $n[type]".process_length($n["length"]).(preg_match(number_type(),$n["type"])&&in_array($n["unsigned"],driver()->unsigned)?" $n[unsigned]":"").(preg_match('~char|text|enum|set~',$n["type"])&&$n["collation"]?" $kb ".(JUSH=="mssql"?$n["collation"]:q($n["collation"])):"");}function
process_field(array$n,array$pj){if($n["on_update"])$n["on_update"]=str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",$n["on_update"]);return
array(idf_escape(trim($n["field"])),process_type($pj),($n["null"]?" NULL":" NOT NULL"),default_value($n),(preg_match('~timestamp|datetime~',$n["type"])&&$n["on_update"]?" ON UPDATE $n[on_update]":""),(support("comment")&&$n["comment"]!=""?" COMMENT ".q($n["comment"]):""),($n["auto_increment"]?auto_increment():null),);}function
default_value(array$n){$l=$n["default"];$ud=$n["generated"];return($l===null?"":(in_array($ud,driver()->generated)?(JUSH=="mssql"?" AS ($l)".($ud=="VIRTUAL"?"":" $ud")."":" GENERATED ALWAYS AS ($l) $ud"):" DEFAULT ".(!preg_match('~^GENERATED ~i',$l)&&(preg_match('~char|binary|text|json|enum|set~',$n["type"])||preg_match('~^(?![a-z])~i',$l))?(JUSH=="sql"&&preg_match('~text|json~',$n["type"])?"(".q($l).")":q($l)):str_ireplace("current_timestamp()","CURRENT_TIMESTAMP",(JUSH=="sqlite"?"($l)":$l)))));}function
type_class($U){foreach(array('char'=>'text','date'=>'time|year','binary'=>'blob','enum'=>'set',)as$y=>$X){if(preg_match("~$y|$X~",$U))return" class='$y'";}}function
edit_fields(array$o,array$lb,$U="TABLE",array$nd=array()){$o=array_values($o);$Vb=(($_POST?$_POST["defaults"]:get_setting("defaults"))?"":" class='hidden'");$rb=(($_POST?$_POST["comments"]:get_setting("comments"))?"":" class='hidden'");echo"<thead><tr>\n",($U=="PROCEDURE"?"<td>":""),"<th id='label-name'>".($U=="TABLE"?lang(107):lang(108)),"<td id='label-type'>".lang(47)."<textarea id='enum-edit' rows='4' cols='12' wrap='off' style='display: none;'></textarea>".script("qs('#enum-edit').onblur = editingLengthBlur;"),"<td id='label-length'>".lang(109),"<td>".lang(110);if($U=="TABLE")echo"<td id='label-null'>NULL\n","<td><input type='radio' name='auto_increment_col' value=''><abbr id='label-ai' title='".lang(49)."'>AI</abbr>",doc_link(array('sql'=>"example-auto-increment.html",'mariadb'=>"auto_increment/",'sqlite'=>"autoinc.html",'pgsql'=>"datatype-numeric.html#DATATYPE-SERIAL",'mssql'=>"t-sql/statements/create-table-transact-sql-identity-property",)),"<td id='label-default'$Vb>".lang(50),(support("comment")?"<td id='label-comment'$rb>".lang(48):"");echo"<td>".icon("plus","add[".(support("move_col")?0:count($o))."]","+",lang(111)),"</thead>\n<tbody>\n",script("mixin(qsl('tbody'), {onclick: editingClick, onkeydown: editingKeydown, oninput: editingInput});");foreach($o
as$t=>$n){$t++;$mg=$n[($_POST?"orig":"field")];$gc=(isset($_POST["add"][$t-1])||(isset($n["field"])&&!idx($_POST["drop_col"],$t)))&&(support("drop_col")||$mg=="");echo"<tr".($gc?"":" style='display: none;'").">\n",($U=="PROCEDURE"?"<td>".html_select("fields[$t][inout]",explode("|",driver()->inout),$n["inout"]):"")."<th>";if($gc)echo"<input name='fields[$t][field]' value='".h($n["field"])."' data-maxlength='64' autocapitalize='off' aria-labelledby='label-name'".(isset($_POST["add"][$t-1])?" autofocus":"").">";echo
input_hidden("fields[$t][orig]",$mg);edit_type("fields[$t]",$n,$lb,$nd);if($U=="TABLE")echo"<td>".checkbox("fields[$t][null]",1,$n["null"],"","","block","label-null"),"<td><label class='block'><input type='radio' name='auto_increment_col' value='$t'".($n["auto_increment"]?" checked":"")." aria-labelledby='label-ai'></label>","<td$Vb>".(driver()->generated?html_select("fields[$t][generated]",array_merge(array("","DEFAULT"),driver()->generated),$n["generated"])." ":checkbox("fields[$t][generated]",1,$n["generated"],"","","","label-default")),"<input name='fields[$t][default]' value='".h($n["default"])."' aria-labelledby='label-default'>",(support("comment")?"<td$rb><input name='fields[$t][comment]' value='".h($n["comment"])."' data-maxlength='".(min_version(5.5)?1024:255)."' aria-labelledby='label-comment'>":"");echo"<td>",(support("move_col")?icon("plus","add[$t]","+",lang(111))." ".icon("up","up[$t]","↑",lang(112))." ".icon("down","down[$t]","↓",lang(113))." ":""),($mg==""||support("drop_col")?icon("cross","drop_col[$t]","x",lang(114)):"");}}function
process_fields(array&$o){$C=0;if($_POST["up"]){$Le=0;foreach($o
as$y=>$n){if(key($_POST["up"])==$y){unset($o[$y]);array_splice($o,$Le,0,array($n));break;}if(isset($n["field"]))$Le=$C;$C++;}}elseif($_POST["down"]){$pd=false;foreach($o
as$y=>$n){if(isset($n["field"])&&$pd){unset($o[key($_POST["down"])]);array_splice($o,$C,0,array($pd));break;}if(key($_POST["down"])==$y)$pd=$n;$C++;}}elseif($_POST["add"]){$o=array_values($o);array_splice($o,key($_POST["add"]),0,array(array()));}elseif(!$_POST["drop_col"])return
false;return
true;}function
normalize_enum(array$A){$X=$A[0];return"'".str_replace("'","''",addcslashes(stripcslashes(str_replace($X[0].$X[0],$X[0],substr($X,1,-1))),'\\'))."'";}function
grant($wd,array$dh,$e,$Wf){if(!$dh)return
true;if($dh==array("ALL PRIVILEGES","GRANT OPTION"))return($wd=="GRANT"?queries("$wd ALL PRIVILEGES$Wf WITH GRANT OPTION"):queries("$wd ALL PRIVILEGES$Wf")&&queries("$wd GRANT OPTION$Wf"));return
queries("$wd ".preg_replace('~(GRANT OPTION)\([^)]*\)~','\1',implode("$e, ",$dh).$e).$Wf);}function
drop_create($kc,$i,$mc,$Pi,$oc,$We,$sf,$qf,$rf,$Tf,$Ff){if($_POST["drop"])query_redirect($kc,$We,$sf);elseif($Tf=="")query_redirect($i,$We,$rf);elseif($Tf!=$Ff){$Gb=queries($i);queries_redirect($We,$qf,$Gb&&queries($kc));if($Gb)queries($mc);}else
queries_redirect($We,$qf,queries($Pi)&&queries($oc)&&queries($kc)&&queries($i));}function
create_trigger($Wf,array$K){$Vi=" $K[Timing] $K[Event]".(preg_match('~ OF~',$K["Event"])?" $K[Of]":"");return"CREATE TRIGGER ".idf_escape($K["Trigger"]).(JUSH=="mssql"?$Wf.$Vi:$Vi.$Wf).rtrim(" $K[Type]\n$K[Statement]",";").";";}function
create_routine($Dh,array$K){$O=array();$o=(array)$K["fields"];ksort($o);foreach($o
as$n){if($n["field"]!="")$O[]=(preg_match("~^(".driver()->inout.")\$~",$n["inout"])?"$n[inout] ":"").idf_escape($n["field"]).process_type($n,"CHARACTER SET");}$Xb=rtrim($K["definition"],";");return"CREATE $Dh ".idf_escape(trim($K["name"]))." (".implode(", ",$O).")".($Dh=="FUNCTION"?" RETURNS".process_type($K["returns"],"CHARACTER SET"):"").($K["language"]?" LANGUAGE $K[language]":"").(JUSH=="pgsql"?" AS ".q($Xb):"\n$Xb;");}function
remove_definer($H){return
preg_replace('~^([A-Z =]+) DEFINER=`'.preg_replace('~@(.*)~','`@`(%|\1)',logged_user()).'`~','\1',$H);}function
format_foreign_key(array$q){$k=$q["db"];$Kf=$q["ns"];return" FOREIGN KEY (".implode(", ",array_map('Adminer\idf_escape',$q["source"])).") REFERENCES ".($k!=""&&$k!=$_GET["db"]?idf_escape($k).".":"").($Kf!=""&&$Kf!=$_GET["ns"]?idf_escape($Kf).".":"").idf_escape($q["table"])." (".implode(", ",array_map('Adminer\idf_escape',$q["target"])).")".(preg_match("~^(".driver()->onActions.")\$~",$q["on_delete"])?" ON DELETE $q[on_delete]":"").(preg_match("~^(".driver()->onActions.")\$~",$q["on_update"])?" ON UPDATE $q[on_update]":"");}function
tar_file($p,$aj){$J=pack("a100a8a8a8a12a12",$p,644,0,0,decoct($aj->size),decoct(time()));$db=8*32;for($t=0;$t<strlen($J);$t++)$db+=ord($J[$t]);$J
.=sprintf("%06o",$db)."\0 ";echo$J,str_repeat("\0",512-strlen($J));$aj->send();echo
str_repeat("\0",511-($aj->size+511)%512);}function
ini_bytes($me){$X=ini_get($me);switch(strtolower(substr($X,-1))){case'g':$X=(int)$X*1024;case'm':$X=(int)$X*1024;case'k':$X=(int)$X*1024;}return$X;}function
doc_link(array$Jg,$Qi="<sup>?</sup>"){$Zh=connection()->server_info;$Nj=preg_replace('~^(\d\.?\d).*~s','\1',$Zh);$Cj=array('sql'=>"https://dev.mysql.com/doc/refman/$Nj/en/",'sqlite'=>"https://www.sqlite.org/",'pgsql'=>"https://www.postgresql.org/docs/".(connection()->flavor=='cockroach'?"current":$Nj)."/",'mssql'=>"https://learn.microsoft.com/en-us/sql/",'oracle'=>"https://www.oracle.com/pls/topic/lookup?ctx=db".preg_replace('~^.* (\d+)\.(\d+)\.\d+\.\d+\.\d+.*~s','\1\2',$Zh)."&id=",);if(connection()->flavor=='maria'){$Cj['sql']="https://mariadb.com/kb/en/";$Jg['sql']=(isset($Jg['mariadb'])?$Jg['mariadb']:str_replace(".html","/",$Jg['sql']));}return($Jg[JUSH]?"<a href='".h($Cj[JUSH].$Jg[JUSH].(JUSH=='mssql'?"?view=sql-server-ver$Nj":""))."'".target_blank().">$Qi</a>":"");}function
db_size($k){if(!connection()->select_db($k))return"?";$J=0;foreach(table_status()as$S)$J+=$S["Data_length"]+$S["Index_length"];return
format_number($J);}function
set_utf8mb4($i){static$O=false;if(!$O&&preg_match('~\butf8mb4~i',$i)){$O=true;echo"SET NAMES ".charset(connection()).";\n\n";}}if(isset($_GET["status"]))$_GET["variables"]=$_GET["status"];if(isset($_GET["import"]))$_GET["sql"]=$_GET["import"];if(!(DB!=""?connection()->select_db(DB):isset($_GET["sql"])||isset($_GET["dump"])||isset($_GET["database"])||isset($_GET["processlist"])||isset($_GET["privileges"])||isset($_GET["user"])||isset($_GET["variables"])||$_GET["script"]=="connect"||$_GET["script"]=="kill")){if(DB!=""||$_GET["refresh"]){restart_session();set_session("dbs",null);}if(DB!=""){header("HTTP/1.1 404 Not Found");page_header(lang(35).": ".h(DB),lang(115),true);}else{if($_POST["db"]&&!$m)queries_redirect(substr(ME,0,-1),lang(116),drop_databases($_POST["db"]));page_header(lang(117),$m,false);echo"<p class='links'>\n";foreach(array('database'=>lang(118),'privileges'=>lang(69),'processlist'=>lang(119),'variables'=>lang(120),'status'=>lang(121),)as$y=>$X){if(support($y))echo"<a href='".h(ME)."$y='>$X</a>\n";}echo"<p>".lang(122,get_driver(DRIVER),"<b>".h(connection()->server_info)."</b>","<b>".connection()->extension."</b>")."\n","<p>".lang(123,"<b>".h(logged_user())."</b>")."\n";$j=adminer()->databases();if($j){$Lh=support("scheme");$lb=collations();echo"<form action='' method='post'>\n","<table class='checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),"<thead><tr>".(support("database")?"<td>":"")."<th>".lang(35).(get_session("dbs")!==null?" - <a href='".h(ME)."refresh=1'>".lang(124)."</a>":"")."<td>".lang(125)."<td>".lang(126)."<td>".lang(127)." - <a href='".h(ME)."dbsize=1'>".lang(128)."</a>".script("qsl('a').onclick = partial(ajaxSetHtml, '".js_escape(ME)."script=connect');","")."</thead>\n";$j=($_GET["dbsize"]?count_tables($j):array_flip($j));foreach($j
as$k=>$T){$Ch=h(ME)."db=".urlencode($k);$u=h("Db-".$k);echo"<tr>".(support("database")?"<td>".checkbox("db[]",$k,in_array($k,(array)$_POST["db"]),"","","",$u):""),"<th><a href='$Ch' id='$u'>".h($k)."</a>";$c=h(db_collation($k,$lb));echo"<td>".(support("database")?"<a href='$Ch".($Lh?"&amp;ns=":"")."&amp;database=' title='".lang(65)."'>$c</a>":$c),"<td align='right'><a href='$Ch&amp;schema=' id='tables-".h($k)."' title='".lang(68)."'>".($_GET["dbsize"]?$T:"?")."</a>","<td align='right' id='size-".h($k)."'>".($_GET["dbsize"]?db_size($k):"?"),"\n";}echo"</table>\n",(support("database")?"<div class='footer'><div>\n"."<fieldset><legend>".lang(129)." <span id='selected'></span></legend><div>\n".input_hidden("all").script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^db/)); };")."<input type='submit' name='drop' value='".lang(130)."'>".confirm()."\n"."</div></fieldset>\n"."</div></div>\n":""),input_token(),"</form>\n",script("tableCheck();");}if(!empty(adminer()->plugins)){echo"<div class='plugins'>\n","<h3>".lang(131)."</h3>\n<ul>\n";foreach(adminer()->plugins
as$Og){$bc=(method_exists($Og,'description')?$Og->description():"");if(!$bc){$sh=new
\ReflectionObject($Og);if(preg_match('~^/[\s*]+(.+)~',$sh->getDocComment(),$A))$bc=$A[1];}$Mh=(method_exists($Og,'screenshot')?$Og->screenshot():"");echo"<li><b>".get_class($Og)."</b>".h($bc?": $bc":"").($Mh?" (<a href='".h($Mh)."'".target_blank().">".lang(132)."</a>)":"")."\n";}echo"</ul>\n";adminer()->pluginsLinks();echo"</div>\n";}}page_footer("db");exit;}if(support("scheme")){if(DB!=""&&$_GET["ns"]!==""){if(!isset($_GET["ns"]))redirect(preg_replace('~ns=[^&]*&~','',ME)."ns=".get_schema());if(!set_schema($_GET["ns"])){header("HTTP/1.1 404 Not Found");page_header(lang(77).": ".h($_GET["ns"]),lang(133),true);page_footer("ns");exit;}}}adminer()->afterConnect();class
TmpFile{private$handler;var$size;function
__construct(){$this->handler=tmpfile();}function
write($Ab){$this->size+=strlen($Ab);fwrite($this->handler,$Ab);}function
send(){fseek($this->handler,0);fpassthru($this->handler);fclose($this->handler);}}if(isset($_GET["select"])&&($_POST["edit"]||$_POST["clone"])&&!$_POST["save"])$_GET["edit"]=$_GET["select"];if(isset($_GET["callf"]))$_GET["call"]=$_GET["callf"];if(isset($_GET["function"]))$_GET["procedure"]=$_GET["function"];if(isset($_GET["download"])){$a=$_GET["download"];$o=fields($a);header("Content-Type: application/octet-stream");header("Content-Disposition: attachment; filename=".friendly_url("$a-".implode("_",$_GET["where"])).".".friendly_url($_GET["field"]));$M=array(idf_escape($_GET["field"]));$I=driver()->select($a,$M,array(where($_GET,$o)),$M);$K=($I?$I->fetch_row():array());echo
driver()->value($K[0],$o[$_GET["field"]]);exit;}elseif(isset($_GET["table"])){$a=$_GET["table"];$o=fields($a);if(!$o)$m=error()?:lang(9);$S=table_status1($a);$B=adminer()->tableName($S);page_header(($o&&is_view($S)?$S['Engine']=='materialized view'?lang(134):lang(135):lang(136)).": ".($B!=""?$B:h($a)),$m);$Bh=array();foreach($o
as$y=>$n)$Bh+=$n["privileges"];adminer()->selectLinks($S,(isset($Bh["insert"])||!support("table")?"":null));$qb=$S["Comment"];if($qb!="")echo"<p class='nowrap'>".lang(48).": ".h($qb)."\n";if($o)adminer()->tableStructurePrint($o,$S);function
tables_links(array$T){echo"<ul>\n";foreach($T
as$R)echo"<li><a href='".h(ME."table=".urlencode($R))."'>".h($R)."</a>";echo"</ul>\n";}$le=driver()->inheritsFrom($a);if($le){echo"<h3>".lang(137)."</h3>\n";tables_links($le);}if(support("indexes")&&driver()->supportsIndex($S)){echo"<h3 id='indexes'>".lang(138)."</h3>\n";$x=indexes($a);if($x)adminer()->tableIndexesPrint($x,$S);echo'<p class="links"><a href="'.h(ME).'indexes='.urlencode($a).'">'.lang(139)."</a>\n";}if(!is_view($S)){if(fk_support($S)){echo"<h3 id='foreign-keys'>".lang(103)."</h3>\n";$nd=foreign_keys($a);if($nd){echo"<table>\n","<thead><tr><th>".lang(140)."<td>".lang(141)."<td>".lang(106)."<td>".lang(105)."<td></thead>\n";foreach($nd
as$B=>$q){echo"<tr title='".h($B)."'>","<th><i>".implode("</i>, <i>",array_map('Adminer\h',$q["source"]))."</i>";$_=($q["db"]!=""?preg_replace('~db=[^&]*~',"db=".urlencode($q["db"]),ME):($q["ns"]!=""?preg_replace('~ns=[^&]*~',"ns=".urlencode($q["ns"]),ME):ME));echo"<td><a href='".h($_."table=".urlencode($q["table"]))."'>".($q["db"]!=""&&$q["db"]!=DB?"<b>".h($q["db"])."</b>.":"").($q["ns"]!=""&&$q["ns"]!=$_GET["ns"]?"<b>".h($q["ns"])."</b>.":"").h($q["table"])."</a>","(<i>".implode("</i>, <i>",array_map('Adminer\h',$q["target"]))."</i>)","<td>".h($q["on_delete"]),"<td>".h($q["on_update"]),'<td><a href="'.h(ME.'foreign='.urlencode($a).'&name='.urlencode($B)).'">'.lang(142).'</a>',"\n";}echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'foreign='.urlencode($a).'">'.lang(143)."</a>\n";}if(support("check")){echo"<h3 id='checks'>".lang(144)."</h3>\n";$Za=driver()->checkConstraints($a);if($Za){echo"<table>\n";foreach($Za
as$y=>$X)echo"<tr title='".h($y)."'>","<td><code class='jush-".JUSH."'>".h($X),"<td><a href='".h(ME.'check='.urlencode($a).'&name='.urlencode($y))."'>".lang(142)."</a>","\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'check='.urlencode($a).'">'.lang(145)."</a>\n";}}if(support(is_view($S)?"view_trigger":"trigger")){echo"<h3 id='triggers'>".lang(146)."</h3>\n";$oj=triggers($a);if($oj){echo"<table>\n";foreach($oj
as$y=>$X)echo"<tr valign='top'><td>".h($X[0])."<td>".h($X[1])."<th>".h($y)."<td><a href='".h(ME.'trigger='.urlencode($a).'&name='.urlencode($y))."'>".lang(142)."</a>\n";echo"</table>\n";}echo'<p class="links"><a href="'.h(ME).'trigger='.urlencode($a).'">'.lang(147)."</a>\n";}$ke=driver()->inheritedTables($a);if($ke){echo"<h3 id='partitions'>".lang(148)."</h3>\n";$Cg=driver()->partitionsInfo($a);if($Cg)echo"<p><code class='jush-".JUSH."'>BY ".h("$Cg[partition_by]($Cg[partition])")."</code>\n";tables_links($ke);}}elseif(isset($_GET["schema"])){page_header(lang(68),"",array(),h(DB.($_GET["ns"]?".$_GET[ns]":"")));$Fi=array();$Gi=array();$da=($_GET["schema"]?:$_COOKIE["adminer_schema-".str_replace(".","_",DB)]);preg_match_all('~([^:]+):([-0-9.]+)x([-0-9.]+)(_|$)~',$da,$df,PREG_SET_ORDER);foreach($df
as$t=>$A){$Fi[$A[1]]=array($A[2],$A[3]);$Gi[]="\n\t'".js_escape($A[1])."': [ $A[2], $A[3] ]";}$dj=0;$Ia=-1;$Jh=array();$rh=array();$Pe=array();$ua=driver()->allFields();foreach(table_status('',true)as$R=>$S){if(is_view($S))continue;$Rg=0;$Jh[$R]["fields"]=array();foreach($ua[$R]as$n){$Rg+=1.25;$n["pos"]=$Rg;$Jh[$R]["fields"][$n["field"]]=$n;}$Jh[$R]["pos"]=($Fi[$R]?:array($dj,0));foreach(adminer()->foreignKeys($R)as$X){if(!$X["db"]){$Ne=$Ia;if(idx($Fi[$R],1)||idx($Fi[$X["table"]],1))$Ne=min(idx($Fi[$R],1,0),idx($Fi[$X["table"]],1,0))-1;else$Ia-=.1;while($Pe[(string)$Ne])$Ne-=.0001;$Jh[$R]["references"][$X["table"]][(string)$Ne]=array($X["source"],$X["target"]);$rh[$X["table"]][$R][(string)$Ne]=$X["target"];$Pe[(string)$Ne]=true;}}$dj=max($dj,$Jh[$R]["pos"][0]+2.5+$Rg);}echo'<div id="schema" style="height: ',$dj,'em;">
<script',nonce(),'>
qs(\'#schema\').onselectstart = () => false;
const tablePos = {',implode(",",$Gi)."\n",'};
const em = qs(\'#schema\').offsetHeight / ',$dj,';
document.onmousemove = schemaMousemove;
document.onmouseup = partialArg(schemaMouseup, \'',js_escape(DB),'\');
</script>
';foreach($Jh
as$B=>$R){echo"<div class='table' style='top: ".$R["pos"][0]."em; left: ".$R["pos"][1]."em;'>",'<a href="'.h(ME).'table='.urlencode($B).'"><b>'.h($B)."</b></a>",script("qsl('div').onmousedown = schemaMousedown;");foreach($R["fields"]as$n){$X='<span'.type_class($n["type"]).' title="'.h($n["type"].($n["length"]?"($n[length])":"").($n["null"]?" NULL":'')).'">'.h($n["field"]).'</span>';echo"<br>".($n["primary"]?"<i>$X</i>":$X);}foreach((array)$R["references"]as$Ni=>$th){foreach($th
as$Ne=>$oh){$Oe=$Ne-idx($Fi[$B],1);$t=0;foreach($oh[0]as$ji)echo"\n<div class='references' title='".h($Ni)."' id='refs$Ne-".($t++)."' style='left: $Oe"."em; top: ".$R["fields"][$ji]["pos"]."em; padding-top: .5em;'>"."<div style='border-top: 1px solid gray; width: ".(-$Oe)."em;'></div></div>";}}foreach((array)$rh[$B]as$Ni=>$th){foreach($th
as$Ne=>$e){$Oe=$Ne-idx($Fi[$B],1);$t=0;foreach($e
as$Mi)echo"\n<div class='references arrow' title='".h($Ni)."' id='refd$Ne-".($t++)."' style='left: $Oe"."em; top: ".$R["fields"][$Mi]["pos"]."em;'>"."<div style='height: .5em; border-bottom: 1px solid gray; width: ".(-$Oe)."em;'></div>"."</div>";}}echo"\n</div>\n";}foreach($Jh
as$B=>$R){foreach((array)$R["references"]as$Ni=>$th){foreach($th
as$Ne=>$oh){$vf=$dj;$jf=-10;foreach($oh[0]as$y=>$ji){$Sg=$R["pos"][0]+$R["fields"][$ji]["pos"];$Tg=$Jh[$Ni]["pos"][0]+$Jh[$Ni]["fields"][$oh[1][$y]]["pos"];$vf=min($vf,$Sg,$Tg);$jf=max($jf,$Sg,$Tg);}echo"<div class='references' id='refl$Ne' style='left: $Ne"."em; top: $vf"."em; padding: .5em 0;'><div style='border-right: 1px solid gray; margin-top: 1px; height: ".($jf-$vf)."em;'></div></div>\n";}}}echo'</div>
<p class="links"><a href="',h(ME."schema=".urlencode($da)),'" id="schema-link">',lang(149),'</a>
';}elseif(isset($_GET["dump"])){$a=$_GET["dump"];if($_POST&&!$m){save_settings(array_intersect_key($_POST,array_flip(array("output","format","db_style","types","routines","events","table_style","auto_increment","triggers","data_style"))),"adminer_export");$T=array_flip((array)$_POST["tables"])+array_flip((array)$_POST["data"]);$Pc=dump_headers((count($T)==1?key($T):DB),(DB==""||count($T)>1));$ye=preg_match('~sql~',$_POST["format"]);if($ye){echo"-- Adminer ".VERSION." ".get_driver(DRIVER)." ".str_replace("\n"," ",connection()->server_info)." dump\n\n";if(JUSH=="sql"){echo"SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
".($_POST["data_style"]?"SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
":"")."
";connection()->query("SET time_zone = '+00:00'");connection()->query("SET sql_mode = ''");}}$wi=$_POST["db_style"];$j=array(DB);if(DB==""){$j=$_POST["databases"];if(is_string($j))$j=explode("\n",rtrim(str_replace("\r","",$j),"\n"));}foreach((array)$j
as$k){adminer()->dumpDatabase($k);if(connection()->select_db($k)){if($ye){if($wi)echo
use_sql($k,$wi).";\n\n";$tg="";if($_POST["types"]){foreach(types()as$u=>$U){$Dc=type_values($u);if($Dc)$tg
.=($wi!='DROP+CREATE'?"DROP TYPE IF EXISTS ".idf_escape($U).";;\n":"")."CREATE TYPE ".idf_escape($U)." AS ENUM ($Dc);\n\n";else$tg
.="-- Could not export type $U\n\n";}}if($_POST["routines"]){foreach(routines()as$K){$B=$K["ROUTINE_NAME"];$Dh=$K["ROUTINE_TYPE"];$i=create_routine($Dh,array("name"=>$B)+routine($K["SPECIFIC_NAME"],$Dh));set_utf8mb4($i);$tg
.=($wi!='DROP+CREATE'?"DROP $Dh IF EXISTS ".idf_escape($B).";;\n":"")."$i;\n\n";}}if($_POST["events"]){foreach(get_rows("SHOW EVENTS",null,"-- ")as$K){$i=remove_definer(get_val("SHOW CREATE EVENT ".idf_escape($K["Name"]),3));set_utf8mb4($i);$tg
.=($wi!='DROP+CREATE'?"DROP EVENT IF EXISTS ".idf_escape($K["Name"]).";;\n":"")."$i;;\n\n";}}echo($tg&&JUSH=='sql'?"DELIMITER ;;\n\n$tg"."DELIMITER ;\n\n":$tg);}if($_POST["table_style"]||$_POST["data_style"]){$Pj=array();foreach(table_status('',true)as$B=>$S){$R=(DB==""||in_array($B,(array)$_POST["tables"]));$Nb=(DB==""||in_array($B,(array)$_POST["data"]));if($R||$Nb){$aj=null;if($Pc=="tar"){$aj=new
TmpFile;ob_start(array($aj,'write'),1e5);}adminer()->dumpTable($B,($R?$_POST["table_style"]:""),(is_view($S)?2:0));if(is_view($S))$Pj[]=$B;elseif($Nb){$o=fields($B);adminer()->dumpData($B,$_POST["data_style"],"SELECT *".convert_fields($o,$o)." FROM ".table($B));}if($ye&&$_POST["triggers"]&&$R&&($oj=trigger_sql($B)))echo"\nDELIMITER ;;\n$oj\nDELIMITER ;\n";if($Pc=="tar"){ob_end_flush();tar_file((DB!=""?"":"$k/")."$B.csv",$aj);}elseif($ye)echo"\n";}}if(function_exists('Adminer\foreign_keys_sql')){foreach(table_status('',true)as$B=>$S){$R=(DB==""||in_array($B,(array)$_POST["tables"]));if($R&&!is_view($S))echo
foreign_keys_sql($B);}}foreach($Pj
as$Oj)adminer()->dumpTable($Oj,$_POST["table_style"],1);if($Pc=="tar")echo
pack("x512");}}}adminer()->dumpFooter();exit;}page_header(lang(74),$m,($_GET["export"]!=""?array("table"=>$_GET["export"]):array()),h(DB));echo'
<form action="" method="post">
<table class="layout">
';$Rb=array('','USE','DROP+CREATE','CREATE');$Hi=array('','DROP+CREATE','CREATE');$Ob=array('','TRUNCATE+INSERT','INSERT');if(JUSH=="sql")$Ob[]='INSERT+UPDATE';$K=get_settings("adminer_export");if(!$K)$K=array("output"=>"text","format"=>"sql","db_style"=>(DB!=""?"":"CREATE"),"table_style"=>"DROP+CREATE","data_style"=>"INSERT");if(!isset($K["events"])){$K["routines"]=$K["events"]=($_GET["dump"]=="");$K["triggers"]=$K["table_style"];}echo"<tr><th>".lang(150)."<td>".html_radios("output",adminer()->dumpOutput(),$K["output"])."\n","<tr><th>".lang(151)."<td>".html_radios("format",adminer()->dumpFormat(),$K["format"])."\n",(JUSH=="sqlite"?"":"<tr><th>".lang(35)."<td>".html_select('db_style',$Rb,$K["db_style"]).(support("type")?checkbox("types",1,$K["types"],lang(6)):"").(support("routine")?checkbox("routines",1,$K["routines"],lang(70)):"").(support("event")?checkbox("events",1,$K["events"],lang(72)):"")),"<tr><th>".lang(126)."<td>".html_select('table_style',$Hi,$K["table_style"]).checkbox("auto_increment",1,$K["auto_increment"],lang(49)).(support("trigger")?checkbox("triggers",1,$K["triggers"],lang(146)):""),"<tr><th>".lang(152)."<td>".html_select('data_style',$Ob,$K["data_style"]),'</table>
<p><input type="submit" value="',lang(74),'">
',input_token(),'
<table>
',script("qsl('table').onclick = dumpClick;");$Xg=array();if(DB!=""){$bb=($a!=""?"":" checked");echo"<thead><tr>","<th style='text-align: left;'><label class='block'><input type='checkbox' id='check-tables'$bb>".lang(126)."</label>".script("qs('#check-tables').onclick = partial(formCheck, /^tables\\[/);",""),"<th style='text-align: right;'><label class='block'>".lang(152)."<input type='checkbox' id='check-data'$bb></label>".script("qs('#check-data').onclick = partial(formCheck, /^data\\[/);",""),"</thead>\n";$Pj="";$Ji=tables_list();foreach($Ji
as$B=>$U){$Wg=preg_replace('~_.*~','',$B);$bb=($a==""||$a==(substr($a,-1)=="%"?"$Wg%":$B));$ah="<tr><td>".checkbox("tables[]",$B,$bb,$B,"","block");if($U!==null&&!preg_match('~table~i',$U))$Pj
.="$ah\n";else
echo"$ah<td align='right'><label class='block'><span id='Rows-".h($B)."'></span>".checkbox("data[]",$B,$bb)."</label>\n";$Xg[$Wg]++;}echo$Pj;if($Ji)echo
script("ajaxSetHtml('".js_escape(ME)."script=db');");}else{echo"<thead><tr><th style='text-align: left;'>","<label class='block'><input type='checkbox' id='check-databases'".($a==""?" checked":"").">".lang(35)."</label>",script("qs('#check-databases').onclick = partial(formCheck, /^databases\\[/);",""),"</thead>\n";$j=adminer()->databases();if($j){foreach($j
as$k){if(!information_schema($k)){$Wg=preg_replace('~_.*~','',$k);echo"<tr><td>".checkbox("databases[]",$k,$a==""||$a=="$Wg%",$k,"","block")."\n";$Xg[$Wg]++;}}}else
echo"<tr><td><textarea name='databases' rows='10' cols='20'></textarea>";}echo'</table>
</form>
';$dd=true;foreach($Xg
as$y=>$X){if($y!=""&&$X>1){echo($dd?"<p>":" ")."<a href='".h(ME)."dump=".urlencode("$y%")."'>".h($y)."</a>";$dd=false;}}}elseif(isset($_GET["privileges"])){page_header(lang(69));echo'<p class="links"><a href="'.h(ME).'user=">'.lang(153)."</a>";$I=connection()->query("SELECT User, Host FROM mysql.".(DB==""?"user":"db WHERE ".q(DB)." LIKE Db")." ORDER BY Host, User");$wd=$I;if(!$I)$I=connection()->query("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', 1) AS User, SUBSTRING_INDEX(CURRENT_USER, '@', -1) AS Host");echo"<form action=''><p>\n";hidden_fields_get();echo
input_hidden("db",DB),($wd?"":input_hidden("grant")),"<table class='odds'>\n","<thead><tr><th>".lang(33)."<th>".lang(32)."<th></thead>\n";while($K=$I->fetch_assoc())echo'<tr><td>'.h($K["User"])."<td>".h($K["Host"]).'<td><a href="'.h(ME.'user='.urlencode($K["User"]).'&host='.urlencode($K["Host"])).'">'.lang(10)."</a>\n";if(!$wd||DB!="")echo"<tr><td><input name='user' autocapitalize='off'><td><input name='host' value='localhost' autocapitalize='off'><td><input type='submit' value='".lang(10)."'>\n";echo"</table>\n","</form>\n";}elseif(isset($_GET["sql"])){if(!$m&&$_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers("sql");if($_POST["format"]=="sql")echo"$_POST[query]\n";else{adminer()->dumpTable("","");adminer()->dumpData("","table",$_POST["query"]);adminer()->dumpFooter();}exit;}restart_session();$Md=&get_session("queries");$Ld=&$Md[DB];if(!$m&&$_POST["clear"]){$Ld=array();redirect(remove_from_uri("history"));}stop_session();page_header((isset($_GET["import"])?lang(73):lang(62)),$m);$Ue='--'.(JUSH=='sql'?' ':'');if(!$m&&$_POST){$r=false;if(!isset($_GET["import"]))$H=$_POST["query"];elseif($_POST["webfile"]){$ni=adminer()->importServerPath();$r=@fopen((file_exists($ni)?$ni:"compress.zlib://$ni.gz"),"rb");$H=($r?fread($r,1e6):false);}else$H=get_file("sql_file",true,";");if(is_string($H)){if(function_exists('memory_get_usage')&&($of=ini_bytes("memory_limit"))!="-1")@ini_set("memory_limit",max($of,strval(2*strlen($H)+memory_get_usage()+8e6)));if($H!=""&&strlen($H)<1e6){$hh=$H.(preg_match("~;[ \t\r\n]*\$~",$H)?"":";");if(!$Ld||first(end($Ld))!=$hh){restart_session();$Ld[]=array($hh,time());set_session("queries",$Md);stop_session();}}$ki="(?:\\s|/\\*[\s\S]*?\\*/|(?:#|$Ue)[^\n]*\n?|--\r?\n)";$Zb=";";$C=0;$yc=true;$h=connect();if($h&&DB!=""){$h->select_db(DB);if($_GET["ns"]!="")set_schema($_GET["ns"],$h);}$pb=0;$Fc=array();$_g='[\'"'.(JUSH=="sql"?'`#':(JUSH=="sqlite"?'`[':(JUSH=="mssql"?'[':''))).']|/\*|'.$Ue.'|$'.(JUSH=="pgsql"?'|\$([a-zA-Z]\w*)?\$':'');$ej=microtime(true);$oa=get_settings("adminer_import");while($H!=""){if(!$C&&preg_match("~^$ki*+DELIMITER\\s+(\\S+)~i",$H,$A)){$Zb=preg_quote($A[1]);$H=substr($H,strlen($A[0]));}elseif(!$C&&JUSH=='pgsql'&&preg_match("~^($ki*+COPY\\s+)[^;]+\\s+FROM\\s+stdin;~i",$H,$A)){$Zb="\n\\\\\\.\r?\n";$C=strlen($A[0]);}else{preg_match("($Zb\\s*|$_g)",$H,$A,PREG_OFFSET_CAPTURE,$C);list($pd,$Rg)=$A[0];if(!$pd&&$r&&!feof($r))$H
.=fread($r,1e5);else{if(!$pd&&rtrim($H)=="")break;$C=$Rg+strlen($pd);if($pd&&!preg_match("(^$Zb)",$pd)){$Ta=driver()->hasCStyleEscapes()||(JUSH=="pgsql"&&($Rg>0&&strtolower($H[$Rg-1])=="e"));$Kg=($pd=='/*'?'\*/':($pd=='['?']':(preg_match("~^$Ue|^#~",$pd)?"\n":preg_quote($pd).($Ta?'|\\\\.':''))));while(preg_match("($Kg|\$)s",$H,$A,PREG_OFFSET_CAPTURE,$C)){$Hh=$A[0][0];if(!$Hh&&$r&&!feof($r))$H
.=fread($r,1e5);else{$C=$A[0][1]+strlen($Hh);if(!$Hh||$Hh[0]!="\\")break;}}}else{$yc=false;$hh=substr($H,0,$Rg+($Zb[0]=="\n"?3:0));$pb++;$ah="<pre id='sql-$pb'><code class='jush-".JUSH."'>".adminer()->sqlCommandQuery($hh)."</code></pre>\n";if(JUSH=="sqlite"&&preg_match("~^$ki*+ATTACH\\b~i",$hh,$A)){echo$ah,"<p class='error'>".lang(154)."\n";$Fc[]=" <a href='#sql-$pb'>$pb</a>";if($_POST["error_stops"])break;}else{if(!$_POST["only_errors"]){echo$ah;ob_flush();flush();}$si=microtime(true);if(connection()->multi_query($hh)&&$h&&preg_match("~^$ki*+USE\\b~i",$hh))$h->query($hh);do{$I=connection()->store_result();if(connection()->error){echo($_POST["only_errors"]?$ah:""),"<p class='error'>".lang(155).(connection()->errno?" (".connection()->errno.")":"").": ".error()."\n";$Fc[]=" <a href='#sql-$pb'>$pb</a>";if($_POST["error_stops"])break
2;}else{$Ti=" <span class='time'>(".format_time($si).")</span>".(strlen($hh)<1000?" <a href='".h(ME)."sql=".urlencode(trim($hh))."'>".lang(10)."</a>":"");$qa=connection()->affected_rows;$Sj=($_POST["only_errors"]?"":driver()->warnings());$Tj="warnings-$pb";if($Sj)$Ti
.=", <a href='#$Tj'>".lang(44)."</a>".script("qsl('a').onclick = partial(toggle, '$Tj');","");$Nc=null;$lg=null;$Oc="explain-$pb";if(is_object($I)){$z=$_POST["limit"];$lg=print_select_result($I,$h,array(),$z);if(!$_POST["only_errors"]){echo"<form action='' method='post'>\n";$Mf=$I->num_rows;echo"<p class='sql-footer'>".($Mf?($z&&$Mf>$z?lang(156,$z):"").lang(157,$Mf):""),$Ti;if($h&&preg_match("~^($ki|\\()*+SELECT\\b~i",$hh)&&($Nc=explain($h,$hh)))echo", <a href='#$Oc'>Explain</a>".script("qsl('a').onclick = partial(toggle, '$Oc');","");$u="export-$pb";echo", <a href='#$u'>".lang(74)."</a>".script("qsl('a').onclick = partial(toggle, '$u');","")."<span id='$u' class='hidden'>: ".html_select("output",adminer()->dumpOutput(),$oa["output"])." ".html_select("format",adminer()->dumpFormat(),$oa["format"]).input_hidden("query",$hh)."<input type='submit' name='export' value='".lang(74)."'>".input_token()."</span>\n"."</form>\n";}}else{if(preg_match("~^$ki*+(CREATE|DROP|ALTER)$ki++(DATABASE|SCHEMA)\\b~i",$hh)){restart_session();set_session("dbs",null);stop_session();}if(!$_POST["only_errors"])echo"<p class='message' title='".h(connection()->info)."'>".lang(158,$qa)."$Ti\n";}echo($Sj?"<div id='$Tj' class='hidden'>\n$Sj</div>\n":"");if($Nc){echo"<div id='$Oc' class='hidden explain'>\n";print_select_result($Nc,$h,$lg);echo"</div>\n";}}$si=microtime(true);}while(connection()->next_result());}$H=substr($H,$C);$C=0;}}}}if($yc)echo"<p class='message'>".lang(159)."\n";elseif($_POST["only_errors"])echo"<p class='message'>".lang(160,$pb-count($Fc))," <span class='time'>(".format_time($ej).")</span>\n";elseif($Fc&&$pb>1)echo"<p class='error'>".lang(155).": ".implode("",$Fc)."\n";}else
echo"<p class='error'>".upload_error($H)."\n";}echo'
<form action="" method="post" enctype="multipart/form-data" id="form">
';$Lc="<input type='submit' value='".lang(161)."' title='Ctrl+Enter'>";if(!isset($_GET["import"])){$hh=$_GET["sql"];if($_POST)$hh=$_POST["query"];elseif($_GET["history"]=="all")$hh=$Ld;elseif($_GET["history"]!="")$hh=idx($Ld[$_GET["history"]],0);echo"<p>";textarea("query",$hh,20);echo
script(($_POST?"":"qs('textarea').focus();\n")."qs('#form').onsubmit = partial(sqlSubmit, qs('#form'), '".js_escape(remove_from_uri("sql|limit|error_stops|only_errors|history"))."');"),"<p>";adminer()->sqlPrintAfter();echo"$Lc\n",lang(162).": <input type='number' name='limit' class='size' value='".h($_POST?$_POST["limit"]:$_GET["limit"])."'>\n";}else{echo"<fieldset><legend>".lang(163)."</legend><div>";$Bd=(extension_loaded("zlib")?"[.gz]":"");$ff="max_file_uploads";$gf=ini_get($ff);echo(ini_bool("file_uploads")?"SQL$Bd (&lt; ".ini_get("upload_max_filesize")."B): <input type='file' name='sql_file[]' multiple>\n".script("qsl('input').onchange = partialArg(fileChange, $gf, '".lang(164,"$ff = $gf")."')").$Lc:lang(165)),"</div></fieldset>\n";$Xd=adminer()->importServerPath();if($Xd)echo"<fieldset><legend>".lang(166)."</legend><div>",lang(167,"<code>".h($Xd)."$Bd</code>"),' <input type="submit" name="webfile" value="'.lang(168).'">',"</div></fieldset>\n";echo"<p>";}echo
checkbox("error_stops",1,($_POST?$_POST["error_stops"]:isset($_GET["import"])||$_GET["error_stops"]),lang(169))."\n",checkbox("only_errors",1,($_POST?$_POST["only_errors"]:isset($_GET["import"])||$_GET["only_errors"]),lang(170))."\n",input_token();if(!isset($_GET["import"])&&$Ld){print_fieldset("history",lang(171),$_GET["history"]!="");for($X=end($Ld);$X;$X=prev($Ld)){$y=key($Ld);list($hh,$Ti,$tc)=$X;echo'<a href="'.h(ME."sql=&history=$y").'">'.lang(10)."</a>"." <span class='time' title='".@date('Y-m-d',$Ti)."'>".@date("H:i:s",$Ti)."</span>"." <code class='jush-".JUSH."'>".shorten_utf8(ltrim(str_replace("\n"," ",str_replace("\r","",preg_replace("~^(#|$Ue).*~m",'',$hh)))),80,"</code>").($tc?" <span class='time'>($tc)</span>":"")."<br>\n";}echo"<input type='submit' name='clear' value='".lang(172)."'>\n","<a href='".h(ME."sql=&history=all")."'>".lang(173)."</a>\n","</div></fieldset>\n";}echo'</form>
';}elseif(isset($_GET["edit"])){$a=$_GET["edit"];$o=fields($a);$Z=(isset($_GET["select"])?($_POST["check"]&&count($_POST["check"])==1?where_check($_POST["check"][0],$o):""):where($_GET,$o));$_j=(isset($_GET["select"])?$_POST["edit"]:$Z);foreach($o
as$B=>$n){if(!isset($n["privileges"][$_j?"update":"insert"])||adminer()->fieldName($n)==""||$n["generated"])unset($o[$B]);}if($_POST&&!$m&&!isset($_GET["select"])){$We=$_POST["referer"];if($_POST["insert"])$We=($_j?null:$_SERVER["REQUEST_URI"]);elseif(!preg_match('~^.+&select=.+$~',$We))$We=ME."select=".urlencode($a);$x=indexes($a);$vj=unique_array($_GET["where"],$x);$kh="\nWHERE $Z";if(isset($_POST["delete"]))queries_redirect($We,lang(174),driver()->delete($a,$kh,$vj?0:1));else{$O=array();foreach($o
as$B=>$n){$X=process_input($n);if($X!==false&&$X!==null)$O[idf_escape($B)]=$X;}if($_j){if(!$O)redirect($We);queries_redirect($We,lang(175),driver()->update($a,$O,$kh,$vj?0:1));if(is_ajax()){page_headers();page_messages($m);exit;}}else{$I=driver()->insert($a,$O);$Me=($I?last_id($I):0);queries_redirect($We,lang(176,($Me?" $Me":"")),$I);}}}$K=null;if($_POST["save"])$K=(array)$_POST["fields"];elseif($Z){$M=array();foreach($o
as$B=>$n){if(isset($n["privileges"]["select"])){$ya=($_POST["clone"]&&$n["auto_increment"]?"''":convert_field($n));$M[]=($ya?"$ya AS ":"").idf_escape($B);}}$K=array();if(!support("table"))$M=array("*");if($M){$I=driver()->select($a,$M,array($Z),$M,array(),(isset($_GET["select"])?2:1));if(!$I)$m=error();else{$K=$I->fetch_assoc();if(!$K)$K=false;}if(isset($_GET["select"])&&(!$K||$I->fetch_assoc()))$K=null;}}if(!support("table")&&!$o){if(!$Z){$I=driver()->select($a,array("*"),array(),array("*"));$K=($I?$I->fetch_assoc():false);if(!$K)$K=array(driver()->primary=>"");}if($K){foreach($K
as$y=>$X){if(!$Z)$K[$y]=null;$o[$y]=array("field"=>$y,"null"=>($y!=driver()->primary),"auto_increment"=>($y==driver()->primary));}}}edit_form($a,$o,$K,$_j,$m);}elseif(isset($_GET["create"])){$a=$_GET["create"];$Eg=driver()->partitionBy;$Hg=($Eg?driver()->partitionsInfo($a):array());$qh=referencable_primary($a);$nd=array();foreach($qh
as$Di=>$n)$nd[str_replace("`","``",$Di)."`".str_replace("`","``",$n["field"])]=$Di;$og=array();$S=array();if($a!=""){$og=fields($a);$S=table_status1($a);if(count($S)<2)$m=lang(9);}$K=$_POST;$K["fields"]=(array)$K["fields"];if($K["auto_increment_col"])$K["fields"][$K["auto_increment_col"]]["auto_increment"]=true;if($_POST)save_settings(array("comments"=>$_POST["comments"],"defaults"=>$_POST["defaults"]));if($_POST&&!process_fields($K["fields"])&&!$m){if($_POST["drop"])queries_redirect(substr(ME,0,-1),lang(177),drop_tables(array($a)));else{$o=array();$ua=array();$Dj=false;$ld=array();$ng=reset($og);$sa=" FIRST";foreach($K["fields"]as$y=>$n){$q=$nd[$n["type"]];$pj=($q!==null?$qh[$q]:$n);if($n["field"]!=""){if(!$n["generated"])$n["default"]=null;$fh=process_field($n,$pj);$ua[]=array($n["orig"],$fh,$sa);if(!$ng||$fh!==process_field($ng,$ng)){$o[]=array($n["orig"],$fh,$sa);if($n["orig"]!=""||$sa)$Dj=true;}if($q!==null)$ld[idf_escape($n["field"])]=($a!=""&&JUSH!="sqlite"?"ADD":" ").format_foreign_key(array('table'=>$nd[$n["type"]],'source'=>array($n["field"]),'target'=>array($pj["field"]),'on_delete'=>$n["on_delete"],));$sa=" AFTER ".idf_escape($n["field"]);}elseif($n["orig"]!=""){$Dj=true;$o[]=array($n["orig"]);}if($n["orig"]!=""){$ng=next($og);if(!$ng)$sa="";}}$E=array();if(in_array($K["partition_by"],$Eg)){foreach($K
as$y=>$X){if(preg_match('~^partition~',$y))$E[$y]=$X;}foreach($E["partition_names"]as$y=>$B){if($B==""){unset($E["partition_names"][$y]);unset($E["partition_values"][$y]);}}$E["partition_names"]=array_values($E["partition_names"]);$E["partition_values"]=array_values($E["partition_values"]);if($E==$Hg)$E=array();}elseif(preg_match("~partitioned~",$S["Create_options"]))$E=null;$pf=lang(178);if($a==""){cookie("adminer_engine",$K["Engine"]);$pf=lang(179);}$B=trim($K["name"]);queries_redirect(ME.(support("table")?"table=":"select=").urlencode($B),$pf,alter_table($a,$B,(JUSH=="sqlite"&&($Dj||$ld)?$ua:$o),$ld,($K["Comment"]!=$S["Comment"]?$K["Comment"]:null),($K["Engine"]&&$K["Engine"]!=$S["Engine"]?$K["Engine"]:""),($K["Collation"]&&$K["Collation"]!=$S["Collation"]?$K["Collation"]:""),($K["Auto_increment"]!=""?number($K["Auto_increment"]):""),$E));}}page_header(($a!=""?lang(41):lang(75)),$m,array("table"=>$a),h($a));if(!$_POST){$rj=driver()->types();$K=array("Engine"=>$_COOKIE["adminer_engine"],"fields"=>array(array("field"=>"","type"=>(isset($rj["int"])?"int":(isset($rj["integer"])?"integer":"")),"on_update"=>"")),"partition_names"=>array(""),);if($a!=""){$K=$S;$K["name"]=$a;$K["fields"]=array();if(!$_GET["auto_increment"])$K["Auto_increment"]="";foreach($og
as$n){$n["generated"]=$n["generated"]?:(isset($n["default"])?"DEFAULT":"");$K["fields"][]=$n;}if($Eg){$K+=$Hg;$K["partition_names"][]="";$K["partition_values"][]="";}}}$lb=collations();if(is_array(reset($lb)))$lb=call_user_func_array('array_merge',array_values($lb));$_c=driver()->engines();foreach($_c
as$zc){if(!strcasecmp($zc,$K["Engine"])){$K["Engine"]=$zc;break;}}echo'
<form action="" method="post" id="form">
<p>
';if(support("columns")||$a==""){echo
lang(180).": <input name='name'".($a==""&&!$_POST?" autofocus":"")." data-maxlength='64' value='".h($K["name"])."' autocapitalize='off'>\n",($_c?html_select("Engine",array(""=>"(".lang(181).")")+$_c,$K["Engine"]).on_help("event.target.value",1).script("qsl('select').onchange = helpClose;")."\n":"");if($lb)echo"<datalist id='collations'>".optionlist($lb)."</datalist>\n",(preg_match("~sqlite|mssql~",JUSH)?"":"<input list='collations' name='Collation' value='".h($K["Collation"])."' placeholder='(".lang(104).")'>\n");echo"<input type='submit' value='".lang(14)."'>\n";}if(support("columns")){echo"<div class='scrollable'>\n","<table id='edit-fields' class='nowrap'>\n";edit_fields($K["fields"],$lb,"TABLE",$nd);echo"</table>\n",script("editFields();"),"</div>\n<p>\n",lang(49).": <input type='number' name='Auto_increment' class='size' value='".h($K["Auto_increment"])."'>\n",checkbox("defaults",1,($_POST?$_POST["defaults"]:get_setting("defaults")),lang(182),"columnShow(this.checked, 5)","jsonly");$sb=($_POST?$_POST["comments"]:get_setting("comments"));echo(support("comment")?checkbox("comments",1,$sb,lang(48),"editingCommentsClick(this, true);","jsonly").' '.(preg_match('~\n~',$K["Comment"])?"<textarea name='Comment' rows='2' cols='20'".($sb?"":" class='hidden'").">".h($K["Comment"])."</textarea>":'<input name="Comment" value="'.h($K["Comment"]).'" data-maxlength="'.(min_version(5.5)?2048:60).'"'.($sb?"":" class='hidden'").'>'):''),'<p>
<input type="submit" value="',lang(14),'">
';}echo'
';if($a!="")echo'<input type="submit" name="drop" value="',lang(130),'">',confirm(lang(183,$a));if($Eg&&(JUSH=='sql'||$a=="")){$Fg=preg_match('~RANGE|LIST~',$K["partition_by"]);print_fieldset("partition",lang(184),$K["partition_by"]);echo"<p>".html_select("partition_by",array_merge(array(""),$Eg),$K["partition_by"]).on_help("event.target.value.replace(/./, 'PARTITION BY \$&')",1).script("qsl('select').onchange = partitionByChange;"),"(<input name='partition' value='".h($K["partition"])."'>)\n",lang(185).": <input type='number' name='partitions' class='size".($Fg||!$K["partition_by"]?" hidden":"")."' value='".h($K["partitions"])."'>\n","<table id='partition-table'".($Fg?"":" class='hidden'").">\n","<thead><tr><th>".lang(186)."<th>".lang(187)."</thead>\n";foreach($K["partition_names"]as$y=>$X)echo'<tr>','<td><input name="partition_names[]" value="'.h($X).'" autocapitalize="off">',($y==count($K["partition_names"])-1?script("qsl('input').oninput = partitionNameChange;"):''),'<td><input name="partition_values[]" value="'.h(idx($K["partition_values"],$y)).'">';echo"</table>\n</div></fieldset>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["indexes"])){$a=$_GET["indexes"];$fe=array("PRIMARY","UNIQUE","INDEX");$S=table_status1($a,true);$ce=driver()->indexAlgorithms($S);if(preg_match('~MyISAM|M?aria'.(min_version(5.6,'10.0.5')?'|InnoDB':'').'~i',$S["Engine"]))$fe[]="FULLTEXT";if(preg_match('~MyISAM|M?aria'.(min_version(5.7,'10.2.2')?'|InnoDB':'').'~i',$S["Engine"]))$fe[]="SPATIAL";$x=indexes($a);$o=fields($a);$G=array();if(JUSH=="mongo"){$G=$x["_id_"];unset($fe[0]);unset($x["_id_"]);}$K=$_POST;if($K)save_settings(array("index_options"=>$K["options"]));if($_POST&&!$m&&!$_POST["add"]&&!$_POST["drop_col"]){$b=array();foreach($K["indexes"]as$w){$B=$w["name"];if(in_array($w["type"],$fe)){$e=array();$Se=array();$cc=array();$de=(support("partial_indexes")?$w["partial"]:"");$be=(in_array($w["algorithm"],$ce)?$w["algorithm"]:"");$O=array();ksort($w["columns"]);foreach($w["columns"]as$y=>$d){if($d!=""){$Re=idx($w["lengths"],$y);$ac=idx($w["descs"],$y);$O[]=($o[$d]?idf_escape($d):$d).($Re?"(".(+$Re).")":"").($ac?" DESC":"");$e[]=$d;$Se[]=($Re?:null);$cc[]=$ac;}}$Mc=$x[$B];if($Mc){ksort($Mc["columns"]);ksort($Mc["lengths"]);ksort($Mc["descs"]);if($w["type"]==$Mc["type"]&&array_values($Mc["columns"])===$e&&(!$Mc["lengths"]||array_values($Mc["lengths"])===$Se)&&array_values($Mc["descs"])===$cc&&$Mc["partial"]==$de&&(!$ce||$Mc["algorithm"]==$be)){unset($x[$B]);continue;}}if($e)$b[]=array($w["type"],$B,$O,$be,$de);}}foreach($x
as$B=>$Mc)$b[]=array($Mc["type"],$B,"DROP");if(!$b)redirect(ME."table=".urlencode($a));queries_redirect(ME."table=".urlencode($a),lang(188),alter_indexes($a,$b));}page_header(lang(138),$m,array("table"=>$a),h($a));$ad=array_keys($o);if($_POST["add"]){foreach($K["indexes"]as$y=>$w){if($w["columns"][count($w["columns"])]!="")$K["indexes"][$y]["columns"][]="";}$w=end($K["indexes"]);if($w["type"]||array_filter($w["columns"],'strlen'))$K["indexes"][]=array("columns"=>array(1=>""));}if(!$K){foreach($x
as$y=>$w){$x[$y]["name"]=$y;$x[$y]["columns"][]="";}$x[]=array("columns"=>array(1=>""));$K["indexes"]=$x;}$Se=(JUSH=="sql"||JUSH=="mssql");$ei=($_POST?$_POST["options"]:get_setting("index_options"));echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap">
<thead><tr>
<th id="label-type">',lang(189);$Vd=" class='idxopts".($ei?"":" hidden")."'";if($ce)echo"<th id='label-algorithm'$Vd>".lang(190).doc_link(array('sql'=>'create-index.html#create-index-storage-engine-index-types','mariadb'=>'storage-engine-index-types/','pgsql'=>'indexes-types.html',));echo'<th><input type="submit" class="wayoff">',lang(191).($Se?"<span$Vd> (".lang(192).")</span>":"");if($Se||support("descidx"))echo
checkbox("options",1,$ei,lang(110),"indexOptionsShow(this.checked)","jsonly")."\n";echo'<th id="label-name">',lang(193);if(support("partial_indexes"))echo"<th id='label-condition'$Vd>".lang(194);echo'<th><noscript>',icon("plus","add[0]","+",lang(111)),'</noscript>
</thead>
';if($G){echo"<tr><td>PRIMARY<td>";foreach($G["columns"]as$y=>$d)echo
select_input(" disabled",$ad,$d),"<label><input disabled type='checkbox'>".lang(57)."</label> ";echo"<td><td>\n";}$Ae=1;foreach($K["indexes"]as$w){if(!$_POST["drop_col"]||$Ae!=key($_POST["drop_col"])){echo"<tr><td>".html_select("indexes[$Ae][type]",array(-1=>"")+$fe,$w["type"],($Ae==count($K["indexes"])?"indexesAddRow.call(this);":""),"label-type");if($ce)echo"<td$Vd>".html_select("indexes[$Ae][algorithm]",array_merge(array(""),$ce),$w['algorithm'],"label-algorithm");echo"<td>";ksort($w["columns"]);$t=1;foreach($w["columns"]as$y=>$d){echo"<span>".select_input(" name='indexes[$Ae][columns][$t]' title='".lang(46)."'",($o&&($d==""||$o[$d])?array_combine($ad,$ad):array()),$d,"partial(".($t==count($w["columns"])?"indexesAddColumn":"indexesChangeColumn").", '".js_escape(JUSH=="sql"?"":$_GET["indexes"]."_")."')"),"<span$Vd>",($Se?"<input type='number' name='indexes[$Ae][lengths][$t]' class='size' value='".h(idx($w["lengths"],$y))."' title='".lang(109)."'>":""),(support("descidx")?checkbox("indexes[$Ae][descs][$t]",1,idx($w["descs"],$y),lang(57)):""),"</span> </span>";$t++;}echo"<td><input name='indexes[$Ae][name]' value='".h($w["name"])."' autocapitalize='off' aria-labelledby='label-name'>\n";if(support("partial_indexes"))echo"<td$Vd><input name='indexes[$Ae][partial]' value='".h($w["partial"])."' autocapitalize='off' aria-labelledby='label-condition'>\n";echo"<td>".icon("cross","drop_col[$Ae]","x",lang(114)).script("qsl('button').onclick = partial(editingRemoveRow, 'indexes\$1[type]');");}$Ae++;}echo'</table>
</div>
<p>
<input type="submit" value="',lang(14),'">
',input_token(),'</form>
';}elseif(isset($_GET["database"])){$K=$_POST;if($_POST&&!$m&&!$_POST["add"]){$B=trim($K["name"]);if($_POST["drop"]){$_GET["db"]="";queries_redirect(remove_from_uri("db|database"),lang(195),drop_databases(array(DB)));}elseif(DB!==$B){if(DB!=""){$_GET["db"]=$B;queries_redirect(preg_replace('~\bdb=[^&]*&~','',ME)."db=".urlencode($B),lang(196),rename_database($B,$K["collation"]));}else{$j=explode("\n",str_replace("\r","",$B));$xi=true;$Le="";foreach($j
as$k){if(count($j)==1||$k!=""){if(!create_database($k,$K["collation"]))$xi=false;$Le=$k;}}restart_session();set_session("dbs",null);queries_redirect(ME."db=".urlencode($Le),lang(197),$xi);}}else{if(!$K["collation"])redirect(substr(ME,0,-1));query_redirect("ALTER DATABASE ".idf_escape($B).(preg_match('~^[a-z0-9_]+$~i',$K["collation"])?" COLLATE $K[collation]":""),substr(ME,0,-1),lang(198));}}page_header(DB!=""?lang(65):lang(118),$m,array(),h(DB));$lb=collations();$B=DB;if($_POST)$B=$K["name"];elseif(DB!="")$K["collation"]=db_collation(DB,$lb);elseif(JUSH=="sql"){foreach(get_vals("SHOW GRANTS")as$wd){if(preg_match('~ ON (`(([^\\\\`]|``|\\\\.)*)%`\.\*)?~',$wd,$A)&&$A[1]){$B=stripcslashes(idf_unescape("`$A[2]`"));break;}}}echo'
<form action="" method="post">
<p>
',($_POST["add"]||strpos($B,"\n")?'<textarea autofocus name="name" rows="10" cols="40">'.h($B).'</textarea><br>':'<input name="name" autofocus value="'.h($B).'" data-maxlength="64" autocapitalize="off">')."\n".($lb?html_select("collation",array(""=>"(".lang(104).")")+$lb,$K["collation"]).doc_link(array('sql'=>"charset-charsets.html",'mariadb'=>"supported-character-sets-and-collations/",'mssql'=>"relational-databases/system-functions/sys-fn-helpcollations-transact-sql",)):""),'<input type="submit" value="',lang(14),'">
';if(DB!="")echo"<input type='submit' name='drop' value='".lang(130)."'>".confirm(lang(183,DB))."\n";elseif(!$_POST["add"]&&$_GET["db"]=="")echo
icon("plus","add[0]","+",lang(111))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["scheme"])){$K=$_POST;if($_POST&&!$m){$_=preg_replace('~ns=[^&]*&~','',ME)."ns=";if($_POST["drop"])query_redirect("DROP SCHEMA ".idf_escape($_GET["ns"]),$_,lang(199));else{$B=trim($K["name"]);$_
.=urlencode($B);if($_GET["ns"]=="")query_redirect("CREATE SCHEMA ".idf_escape($B),$_,lang(200));elseif($_GET["ns"]!=$B)query_redirect("ALTER SCHEMA ".idf_escape($_GET["ns"])." RENAME TO ".idf_escape($B),$_,lang(201));else
redirect($_);}}page_header($_GET["ns"]!=""?lang(66):lang(67),$m);if(!$K)$K["name"]=$_GET["ns"];echo'
<form action="" method="post">
<p><input name="name" autofocus value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($_GET["ns"]!="")echo"<input type='submit' name='drop' value='".lang(130)."'>".confirm(lang(183,$_GET["ns"]))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["call"])){$ca=($_GET["name"]?:$_GET["call"]);page_header(lang(202).": ".h($ca),$m);$Dh=routine($_GET["call"],(isset($_GET["callf"])?"FUNCTION":"PROCEDURE"));$Yd=array();$tg=array();foreach($Dh["fields"]as$t=>$n){if(substr($n["inout"],-3)=="OUT"&&JUSH=='sql')$tg[$t]="@".idf_escape($n["field"])." AS ".idf_escape($n["field"]);if(!$n["inout"]||substr($n["inout"],0,2)=="IN")$Yd[]=$t;}if(!$m&&$_POST){$Ua=array();foreach($Dh["fields"]as$y=>$n){$X="";if(in_array($y,$Yd)){$X=process_input($n);if($X===false)$X="''";if(isset($tg[$y]))connection()->query("SET @".idf_escape($n["field"])." = $X");}if(isset($tg[$y]))$Ua[]="@".idf_escape($n["field"]);elseif(in_array($y,$Yd))$Ua[]=$X;}$H=(isset($_GET["callf"])?"SELECT ":"CALL ").($Dh["returns"]["type"]=="record"?"* FROM ":"").table($ca)."(".implode(", ",$Ua).")";$si=microtime(true);$I=connection()->multi_query($H);$qa=connection()->affected_rows;echo
adminer()->selectQuery($H,$si,!$I);if(!$I)echo"<p class='error'>".error()."\n";else{$h=connect();if($h)$h->select_db(DB);do{$I=connection()->store_result();if(is_object($I))print_select_result($I,$h);else
echo"<p class='message'>".lang(203,$qa)." <span class='time'>".@date("H:i:s")."</span>\n";}while(connection()->next_result());if($tg)print_select_result(connection()->query("SELECT ".implode(", ",$tg)));}}echo'
<form action="" method="post">
';if($Yd){echo"<table class='layout'>\n";foreach($Yd
as$y){$n=$Dh["fields"][$y];$B=$n["field"];echo"<tr><th>".adminer()->fieldName($n);$Y=idx($_POST["fields"],$B);if($Y!=""){if($n["type"]=="set")$Y=implode(",",$Y);}input($n,$Y,idx($_POST["function"],$B,""));echo"\n";}echo"</table>\n";}echo'<p>
<input type="submit" value="',lang(202),'">
',input_token(),'</form>

<pre>
';function
pre_tr($Hh){return
preg_replace('~^~m','<tr>',preg_replace('~\|~','<td>',preg_replace('~\|$~m',"",rtrim($Hh))));}$R='(\+--[-+]+\+\n)';$K='(\| .* \|\n)';echo
preg_replace_callback("~^$R?$K$R?($K*)$R?~m",function($A){$ed=pre_tr($A[2]);return"<table>\n".($A[1]?"<thead>$ed</thead>\n":$ed).pre_tr($A[4])."\n</table>";},preg_replace('~(\n(    -|mysql)&gt; )(.+)~',"\\1<code class='jush-sql'>\\3</code>",preg_replace('~(.+)\n---+\n~',"<b>\\1</b>\n",h($Dh['comment']))));echo'</pre>
';}elseif(isset($_GET["foreign"])){$a=$_GET["foreign"];$B=$_GET["name"];$K=$_POST;if($_POST&&!$m&&!$_POST["add"]&&!$_POST["change"]&&!$_POST["change-js"]){if(!$_POST["drop"]){$K["source"]=array_filter($K["source"],'strlen');ksort($K["source"]);$Mi=array();foreach($K["source"]as$y=>$X)$Mi[$y]=$K["target"][$y];$K["target"]=$Mi;}if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(" $B"=>($K["drop"]?"":" ".format_foreign_key($K))));else{$b="ALTER TABLE ".table($a);$I=($B==""||queries("$b DROP ".(JUSH=="sql"?"FOREIGN KEY ":"CONSTRAINT ").idf_escape($B)));if(!$K["drop"])$I=queries("$b ADD".format_foreign_key($K));}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(204):($B!=""?lang(205):lang(206))),$I);if(!$K["drop"])$m=lang(207);}page_header(lang(208),$m,array("table"=>$a),h($a));if($_POST){ksort($K["source"]);if($_POST["add"])$K["source"][]="";elseif($_POST["change"]||$_POST["change-js"])$K["target"]=array();}elseif($B!=""){$nd=foreign_keys($a);$K=$nd[$B];$K["source"][]="";}else{$K["table"]=$a;$K["source"]=array("");}echo'
<form action="" method="post">
';$ji=array_keys(fields($a));if($K["db"]!="")connection()->select_db($K["db"]);if($K["ns"]!=""){$pg=get_schema();set_schema($K["ns"]);}$ph=array_keys(array_filter(table_status('',true),'Adminer\fk_support'));$Mi=array_keys(fields(in_array($K["table"],$ph)?$K["table"]:reset($ph)));$Zf="this.form['change-js'].value = '1'; this.form.submit();";echo"<p><label>".lang(209).": ".html_select("table",$ph,$K["table"],$Zf)."</label>\n";if(support("scheme")){$Kh=array_filter(adminer()->schemas(),function($Jh){return!preg_match('~^information_schema$~i',$Jh);});echo"<label>".lang(77).": ".html_select("ns",$Kh,$K["ns"]!=""?$K["ns"]:$_GET["ns"],$Zf)."</label>";if($K["ns"]!="")set_schema($pg);}elseif(JUSH!="sqlite"){$Sb=array();foreach(adminer()->databases()as$k){if(!information_schema($k))$Sb[]=$k;}echo"<label>".lang(76).": ".html_select("db",$Sb,$K["db"]!=""?$K["db"]:$_GET["db"],$Zf)."</label>";}echo
input_hidden("change-js"),'<noscript><p><input type="submit" name="change" value="',lang(210),'"></noscript>
<table>
<thead><tr><th id="label-source">',lang(140),'<th id="label-target">',lang(141),'</thead>
';$Ae=0;foreach($K["source"]as$y=>$X){echo"<tr>","<td>".html_select("source[".(+$y)."]",array(-1=>"")+$ji,$X,($Ae==count($K["source"])-1?"foreignAddRow.call(this);":""),"label-source"),"<td>".html_select("target[".(+$y)."]",$Mi,idx($K["target"],$y),"","label-target");$Ae++;}echo'</table>
<p>
<label>',lang(106),': ',html_select("on_delete",array(-1=>"")+explode("|",driver()->onActions),$K["on_delete"]),'</label>
<label>',lang(105),': ',html_select("on_update",array(-1=>"")+explode("|",driver()->onActions),$K["on_update"]),'</label>
',doc_link(array('sql'=>"innodb-foreign-key-constraints.html",'mariadb'=>"foreign-keys/",'pgsql'=>"sql-createtable.html#SQL-CREATETABLE-REFERENCES",'mssql'=>"t-sql/statements/create-table-transact-sql",'oracle'=>"SQLRF01111",)),'<p>
<input type="submit" value="',lang(14),'">
<noscript><p><input type="submit" name="add" value="',lang(211),'"></noscript>
';if($B!="")echo'<input type="submit" name="drop" value="',lang(130),'">',confirm(lang(183,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["view"])){$a=$_GET["view"];$K=$_POST;$qg="VIEW";if(JUSH=="pgsql"&&$a!=""){$P=table_status1($a);$qg=strtoupper($P["Engine"]);}if($_POST&&!$m){$B=trim($K["name"]);$ya=" AS\n$K[select]";$We=ME."table=".urlencode($B);$pf=lang(212);$U=($_POST["materialized"]?"MATERIALIZED VIEW":"VIEW");if(!$_POST["drop"]&&$a==$B&&JUSH!="sqlite"&&$U=="VIEW"&&$qg=="VIEW")query_redirect((JUSH=="mssql"?"ALTER":"CREATE OR REPLACE")." VIEW ".table($B).$ya,$We,$pf);else{$Oi=$B."_adminer_".uniqid();drop_create("DROP $qg ".table($a),"CREATE $U ".table($B).$ya,"DROP $U ".table($B),"CREATE $U ".table($Oi).$ya,"DROP $U ".table($Oi),($_POST["drop"]?substr(ME,0,-1):$We),lang(213),$pf,lang(214),$a,$B);}}if(!$_POST&&$a!=""){$K=view($a);$K["name"]=$a;$K["materialized"]=($qg!="VIEW");if(!$m)$m=error();}page_header(($a!=""?lang(42):lang(215)),$m,array("table"=>$a),h($a));echo'
<form action="" method="post">
<p>',lang(193),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',(support("materializedview")?" ".checkbox("materialized",1,$K["materialized"],lang(134)):""),'<p>';textarea("select",$K["select"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($a!="")echo'<input type="submit" name="drop" value="',lang(130),'">',confirm(lang(183,$a));echo
input_token(),'</form>
';}elseif(isset($_GET["event"])){$aa=$_GET["event"];$se=array("YEAR","QUARTER","MONTH","DAY","HOUR","MINUTE","WEEK","SECOND","YEAR_MONTH","DAY_HOUR","DAY_MINUTE","DAY_SECOND","HOUR_MINUTE","HOUR_SECOND","MINUTE_SECOND");$ti=array("ENABLED"=>"ENABLE","DISABLED"=>"DISABLE","SLAVESIDE_DISABLED"=>"DISABLE ON SLAVE");$K=$_POST;if($_POST&&!$m){if($_POST["drop"])query_redirect("DROP EVENT ".idf_escape($aa),substr(ME,0,-1),lang(216));elseif(in_array($K["INTERVAL_FIELD"],$se)&&isset($ti[$K["STATUS"]])){$Ih="\nON SCHEDULE ".($K["INTERVAL_VALUE"]?"EVERY ".q($K["INTERVAL_VALUE"])." $K[INTERVAL_FIELD]".($K["STARTS"]?" STARTS ".q($K["STARTS"]):"").($K["ENDS"]?" ENDS ".q($K["ENDS"]):""):"AT ".q($K["STARTS"]))." ON COMPLETION".($K["ON_COMPLETION"]?"":" NOT")." PRESERVE";queries_redirect(substr(ME,0,-1),($aa!=""?lang(217):lang(218)),queries(($aa!=""?"ALTER EVENT ".idf_escape($aa).$Ih.($aa!=$K["EVENT_NAME"]?"\nRENAME TO ".idf_escape($K["EVENT_NAME"]):""):"CREATE EVENT ".idf_escape($K["EVENT_NAME"]).$Ih)."\n".$ti[$K["STATUS"]]." COMMENT ".q($K["EVENT_COMMENT"]).rtrim(" DO\n$K[EVENT_DEFINITION]",";").";"));}}page_header(($aa!=""?lang(219).": ".h($aa):lang(220)),$m);if(!$K&&$aa!=""){$L=get_rows("SELECT * FROM information_schema.EVENTS WHERE EVENT_SCHEMA = ".q(DB)." AND EVENT_NAME = ".q($aa));$K=reset($L);}echo'
<form action="" method="post">
<table class="layout">
<tr><th>',lang(193),'<td><input name="EVENT_NAME" value="',h($K["EVENT_NAME"]),'" data-maxlength="64" autocapitalize="off">
<tr><th title="datetime">',lang(221),'<td><input name="STARTS" value="',h("$K[EXECUTE_AT]$K[STARTS]"),'">
<tr><th title="datetime">',lang(222),'<td><input name="ENDS" value="',h($K["ENDS"]),'">
<tr><th>',lang(223),'<td><input type="number" name="INTERVAL_VALUE" value="',h($K["INTERVAL_VALUE"]),'" class="size"> ',html_select("INTERVAL_FIELD",$se,$K["INTERVAL_FIELD"]),'<tr><th>',lang(121),'<td>',html_select("STATUS",$ti,$K["STATUS"]),'<tr><th>',lang(48),'<td><input name="EVENT_COMMENT" value="',h($K["EVENT_COMMENT"]),'" data-maxlength="64">
<tr><th><td>',checkbox("ON_COMPLETION","PRESERVE",$K["ON_COMPLETION"]=="PRESERVE",lang(224)),'</table>
<p>';textarea("EVENT_DEFINITION",$K["EVENT_DEFINITION"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($aa!="")echo'<input type="submit" name="drop" value="',lang(130),'">',confirm(lang(183,$aa));echo
input_token(),'</form>
';}elseif(isset($_GET["procedure"])){$ca=($_GET["name"]?:$_GET["procedure"]);$Dh=(isset($_GET["function"])?"FUNCTION":"PROCEDURE");$K=$_POST;$K["fields"]=(array)$K["fields"];if($_POST&&!process_fields($K["fields"])&&!$m){$mg=routine($_GET["procedure"],$Dh);$Oi="$K[name]_adminer_".uniqid();foreach($K["fields"]as$y=>$n){if($n["field"]=="")unset($K["fields"][$y]);}drop_create("DROP $Dh ".routine_id($ca,$mg),create_routine($Dh,$K),"DROP $Dh ".routine_id($K["name"],$K),create_routine($Dh,array("name"=>$Oi)+$K),"DROP $Dh ".routine_id($Oi,$K),substr(ME,0,-1),lang(225),lang(226),lang(227),$ca,$K["name"]);}page_header(($ca!=""?(isset($_GET["function"])?lang(228):lang(229)).": ".h($ca):(isset($_GET["function"])?lang(230):lang(231))),$m);if(!$_POST){if($ca=="")$K["language"]="sql";else{$K=routine($_GET["procedure"],$Dh);$K["name"]=$ca;}}$lb=get_vals("SHOW CHARACTER SET");sort($lb);$Eh=routine_languages();echo($lb?"<datalist id='collations'>".optionlist($lb)."</datalist>":""),'
<form action="" method="post" id="form">
<p>',lang(193),': <input name="name" value="',h($K["name"]),'" data-maxlength="64" autocapitalize="off">
',($Eh?"<label>".lang(19).": ".html_select("language",$Eh,$K["language"])."</label>\n":""),'<input type="submit" value="',lang(14),'">
<div class="scrollable">
<table class="nowrap">
';edit_fields($K["fields"],$lb,$Dh);if(isset($_GET["function"])){echo"<tr><td>".lang(232);edit_type("returns",(array)$K["returns"],$lb,array(),(JUSH=="pgsql"?array("void","trigger"):array()));}echo'</table>
',script("editFields();"),'</div>
<p>';textarea("definition",$K["definition"],20);echo'<p>
<input type="submit" value="',lang(14),'">
';if($ca!="")echo'<input type="submit" name="drop" value="',lang(130),'">',confirm(lang(183,$ca));echo
input_token(),'</form>
';}elseif(isset($_GET["sequence"])){$ea=$_GET["sequence"];$K=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);$B=trim($K["name"]);if($_POST["drop"])query_redirect("DROP SEQUENCE ".idf_escape($ea),$_,lang(233));elseif($ea=="")query_redirect("CREATE SEQUENCE ".idf_escape($B),$_,lang(234));elseif($ea!=$B)query_redirect("ALTER SEQUENCE ".idf_escape($ea)." RENAME TO ".idf_escape($B),$_,lang(235));else
redirect($_);}page_header($ea!=""?lang(236).": ".h($ea):lang(237),$m);if(!$K)$K["name"]=$ea;echo'
<form action="" method="post">
<p><input name="name" value="',h($K["name"]),'" autocapitalize="off">
<input type="submit" value="',lang(14),'">
';if($ea!="")echo"<input type='submit' name='drop' value='".lang(130)."'>".confirm(lang(183,$ea))."\n";echo
input_token(),'</form>
';}elseif(isset($_GET["type"])){$fa=$_GET["type"];$K=$_POST;if($_POST&&!$m){$_=substr(ME,0,-1);if($_POST["drop"])query_redirect("DROP TYPE ".idf_escape($fa),$_,lang(238));else
query_redirect("CREATE TYPE ".idf_escape(trim($K["name"]))." $K[as]",$_,lang(239));}page_header($fa!=""?lang(240).": ".h($fa):lang(241),$m);if(!$K)$K["as"]="AS ";echo'
<form action="" method="post">
<p>
';if($fa!=""){$rj=driver()->types();$Dc=type_values($rj[$fa]);if($Dc)echo"<code class='jush-".JUSH."'>ENUM (".h($Dc).")</code>\n<p>";echo"<input type='submit' name='drop' value='".lang(130)."'>".confirm(lang(183,$fa))."\n";}else{echo
lang(193).": <input name='name' value='".h($K['name'])."' autocapitalize='off'>\n",doc_link(array('pgsql'=>"datatype-enum.html",),"?");textarea("as",$K["as"]);echo"<p><input type='submit' value='".lang(14)."'>\n";}echo
input_token(),'</form>
';}elseif(isset($_GET["check"])){$a=$_GET["check"];$B=$_GET["name"];$K=$_POST;if($K&&!$m){if(JUSH=="sqlite")$I=recreate_table($a,$a,array(),array(),array(),"",array(),"$B",($K["drop"]?"":$K["clause"]));else{$I=($B==""||queries("ALTER TABLE ".table($a)." DROP CONSTRAINT ".idf_escape($B)));if(!$K["drop"])$I=queries("ALTER TABLE ".table($a)." ADD".($K["name"]!=""?" CONSTRAINT ".idf_escape($K["name"]):"")." CHECK ($K[clause])");}queries_redirect(ME."table=".urlencode($a),($K["drop"]?lang(242):($B!=""?lang(243):lang(244))),$I);}page_header(($B!=""?lang(245).": ".h($B):lang(145)),$m,array("table"=>$a));if(!$K){$cb=driver()->checkConstraints($a);$K=array("name"=>$B,"clause"=>$cb[$B]);}echo'
<form action="" method="post">
<p>';if(JUSH!="sqlite")echo
lang(193).': <input name="name" value="'.h($K["name"]).'" data-maxlength="64" autocapitalize="off"> ';echo
doc_link(array('sql'=>"create-table-check-constraints.html",'mariadb'=>"constraint/",'pgsql'=>"ddl-constraints.html#DDL-CONSTRAINTS-CHECK-CONSTRAINTS",'mssql'=>"relational-databases/tables/create-check-constraints",'sqlite'=>"lang_createtable.html#check_constraints",),"?"),'<p>';textarea("clause",$K["clause"]);echo'<p><input type="submit" value="',lang(14),'">
';if($B!="")echo'<input type="submit" name="drop" value="',lang(130),'">',confirm(lang(183,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["trigger"])){$a=$_GET["trigger"];$B="$_GET[name]";$nj=trigger_options();$K=(array)trigger($B,$a)+array("Trigger"=>$a."_bi");if($_POST){if(!$m&&in_array($_POST["Timing"],$nj["Timing"])&&in_array($_POST["Event"],$nj["Event"])&&in_array($_POST["Type"],$nj["Type"])){$Wf=" ON ".table($a);$kc="DROP TRIGGER ".idf_escape($B).(JUSH=="pgsql"?$Wf:"");$We=ME."table=".urlencode($a);if($_POST["drop"])query_redirect($kc,$We,lang(246));else{if($B!="")queries($kc);queries_redirect($We,($B!=""?lang(247):lang(248)),queries(create_trigger($Wf,$_POST)));if($B!="")queries(create_trigger($Wf,$K+array("Type"=>reset($nj["Type"]))));}}$K=$_POST;}page_header(($B!=""?lang(249).": ".h($B):lang(250)),$m,array("table"=>$a));echo'
<form action="" method="post" id="form">
<table class="layout">
<tr><th>',lang(251),'<td>',html_select("Timing",$nj["Timing"],$K["Timing"],"triggerChange(/^".preg_quote($a,"/")."_[ba][iud]$/, '".js_escape($a)."', this.form);"),'<tr><th>',lang(252),'<td>',html_select("Event",$nj["Event"],$K["Event"],"this.form['Timing'].onchange();"),(in_array("UPDATE OF",$nj["Event"])?" <input name='Of' value='".h($K["Of"])."' class='hidden'>":""),'<tr><th>',lang(47),'<td>',html_select("Type",$nj["Type"],$K["Type"]),'</table>
<p>',lang(193),': <input name="Trigger" value="',h($K["Trigger"]),'" data-maxlength="64" autocapitalize="off">
',script("qs('#form')['Timing'].onchange();"),'<p>';textarea("Statement",$K["Statement"]);echo'<p>
<input type="submit" value="',lang(14),'">
';if($B!="")echo'<input type="submit" name="drop" value="',lang(130),'">',confirm(lang(183,$B));echo
input_token(),'</form>
';}elseif(isset($_GET["user"])){$ga=$_GET["user"];$dh=array(""=>array("All privileges"=>""));foreach(get_rows("SHOW PRIVILEGES")as$K){foreach(explode(",",($K["Privilege"]=="Grant option"?"":$K["Context"]))as$Bb)$dh[$Bb][$K["Privilege"]]=$K["Comment"];}$dh["Server Admin"]+=$dh["File access on server"];$dh["Databases"]["Create routine"]=$dh["Procedures"]["Create routine"];unset($dh["Procedures"]["Create routine"]);$dh["Columns"]=array();foreach(array("Select","Insert","Update","References")as$X)$dh["Columns"][$X]=$dh["Tables"][$X];unset($dh["Server Admin"]["Usage"]);foreach($dh["Tables"]as$y=>$X)unset($dh["Databases"][$y]);$Ef=array();if($_POST){foreach($_POST["objects"]as$y=>$X)$Ef[$X]=(array)$Ef[$X]+idx($_POST["grants"],$y,array());}$xd=array();$Uf="";if(isset($_GET["host"])&&($I=connection()->query("SHOW GRANTS FOR ".q($ga)."@".q($_GET["host"])))){while($K=$I->fetch_row()){if(preg_match('~GRANT (.*) ON (.*) TO ~',$K[0],$A)&&preg_match_all('~ *([^(,]*[^ ,(])( *\([^)]+\))?~',$A[1],$df,PREG_SET_ORDER)){foreach($df
as$X){if($X[1]!="USAGE")$xd["$A[2]$X[2]"][$X[1]]=true;if(preg_match('~ WITH GRANT OPTION~',$K[0]))$xd["$A[2]$X[2]"]["GRANT OPTION"]=true;}}if(preg_match("~ IDENTIFIED BY PASSWORD '([^']+)~",$K[0],$A))$Uf=$A[1];}}if($_POST&&!$m){$Vf=(isset($_GET["host"])?q($ga)."@".q($_GET["host"]):"''");if($_POST["drop"])query_redirect("DROP USER $Vf",ME."privileges=",lang(253));else{$Gf=q($_POST["user"])."@".q($_POST["host"]);$Ig=$_POST["pass"];if($Ig!=''&&!$_POST["hashed"]&&!min_version(8)){$Ig=get_val("SELECT PASSWORD(".q($Ig).")");$m=!$Ig;}$Gb=false;if(!$m){if($Vf!=$Gf){$Gb=queries((min_version(5)?"CREATE USER":"GRANT USAGE ON *.* TO")." $Gf IDENTIFIED BY ".(min_version(8)?"":"PASSWORD ").q($Ig));$m=!$Gb;}elseif($Ig!=$Uf)queries("SET PASSWORD FOR $Gf = ".q($Ig));}if(!$m){$Ah=array();foreach($Ef
as$Of=>$wd){if(isset($_GET["grant"]))$wd=array_filter($wd);$wd=array_keys($wd);if(isset($_GET["grant"]))$Ah=array_diff(array_keys(array_filter($Ef[$Of],'strlen')),$wd);elseif($Vf==$Gf){$Sf=array_keys((array)$xd[$Of]);$Ah=array_diff($Sf,$wd);$wd=array_diff($wd,$Sf);unset($xd[$Of]);}if(preg_match('~^(.+)\s*(\(.*\))?$~U',$Of,$A)&&(!grant("REVOKE",$Ah,$A[2]," ON $A[1] FROM $Gf")||!grant("GRANT",$wd,$A[2]," ON $A[1] TO $Gf"))){$m=true;break;}}}if(!$m&&isset($_GET["host"])){if($Vf!=$Gf)queries("DROP USER $Vf");elseif(!isset($_GET["grant"])){foreach($xd
as$Of=>$Ah){if(preg_match('~^(.+)(\(.*\))?$~U',$Of,$A))grant("REVOKE",array_keys($Ah),$A[2]," ON $A[1] FROM $Gf");}}}queries_redirect(ME."privileges=",(isset($_GET["host"])?lang(254):lang(255)),!$m);if($Gb)connection()->query("DROP USER $Gf");}}page_header((isset($_GET["host"])?lang(33).": ".h("$ga@$_GET[host]"):lang(153)),$m,array("privileges"=>array('',lang(69))));$K=$_POST;if($K)$xd=$Ef;else{$K=$_GET+array("host"=>get_val("SELECT SUBSTRING_INDEX(CURRENT_USER, '@', -1)"));$K["pass"]=$Uf;if($Uf!="")$K["hashed"]=true;$xd[(DB==""||$xd?"":idf_escape(addcslashes(DB,"%_\\"))).".*"]=array();}echo'<form action="" method="post">
<table class="layout">
<tr><th>',lang(32),'<td><input name="host" data-maxlength="60" value="',h($K["host"]),'" autocapitalize="off">
<tr><th>',lang(33),'<td><input name="user" data-maxlength="80" value="',h($K["user"]),'" autocapitalize="off">
<tr><th>',lang(34),'<td><input name="pass" id="pass" value="',h($K["pass"]),'" autocomplete="new-password">
',($K["hashed"]?"":script("typePassword(qs('#pass'));")),(min_version(8)?"":checkbox("hashed",1,$K["hashed"],lang(256),"typePassword(this.form['pass'], this.checked);")),'</table>

',"<table class='odds'>\n","<thead><tr><th colspan='2'>".lang(69).doc_link(array('sql'=>"grant.html#priv_level"));$t=0;foreach($xd
as$Of=>$wd){echo'<th>'.($Of!="*.*"?"<input name='objects[$t]' value='".h($Of)."' size='10' autocapitalize='off'>":input_hidden("objects[$t]","*.*")."*.*");$t++;}echo"</thead>\n";foreach(array(""=>"","Server Admin"=>lang(32),"Databases"=>lang(35),"Tables"=>lang(136),"Columns"=>lang(46),"Procedures"=>lang(257),)as$Bb=>$ac){foreach((array)$dh[$Bb]as$ch=>$qb){echo"<tr><td".($ac?">$ac<td":" colspan='2'").' lang="en" title="'.h($qb).'">'.h($ch);$t=0;foreach($xd
as$Of=>$wd){$B="'grants[$t][".h(strtoupper($ch))."]'";$Y=$wd[strtoupper($ch)];if($Bb=="Server Admin"&&$Of!=(isset($xd["*.*"])?"*.*":".*"))echo"<td>";elseif(isset($_GET["grant"]))echo"<td><select name=$B><option><option value='1'".($Y?" selected":"").">".lang(258)."<option value='0'".($Y=="0"?" selected":"").">".lang(259)."</select>";else
echo"<td align='center'><label class='block'>","<input type='checkbox' name=$B value='1'".($Y?" checked":"").($ch=="All privileges"?" id='grants-$t-all'>":">".($ch=="Grant option"?"":script("qsl('input').onclick = function () { if (this.checked) formUncheck('grants-$t-all'); };"))),"</label>";$t++;}}}echo"</table>\n",'<p>
<input type="submit" value="',lang(14),'">
';if(isset($_GET["host"]))echo'<input type="submit" name="drop" value="',lang(130),'">',confirm(lang(183,"$ga@$_GET[host]"));echo
input_token(),'</form>
';}elseif(isset($_GET["processlist"])){if(support("kill")){if($_POST&&!$m){$Ge=0;foreach((array)$_POST["kill"]as$X){if(adminer()->killProcess($X))$Ge++;}queries_redirect(ME."processlist=",lang(260,$Ge),$Ge||!$_POST["kill"]);}}page_header(lang(119),$m);echo'
<form action="" method="post">
<div class="scrollable">
<table class="nowrap checkable odds">
',script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});");$t=-1;foreach(adminer()->processList()as$t=>$K){if(!$t){echo"<thead><tr lang='en'>".(support("kill")?"<th>":"");foreach($K
as$y=>$X)echo"<th>$y".doc_link(array('sql'=>"show-processlist.html#processlist_".strtolower($y),'pgsql'=>"monitoring-stats.html#PG-STAT-ACTIVITY-VIEW",'oracle'=>"REFRN30223",));echo"</thead>\n";}echo"<tr>".(support("kill")?"<td>".checkbox("kill[]",$K[JUSH=="sql"?"Id":"pid"],0):"");foreach($K
as$y=>$X)echo"<td>".((JUSH=="sql"&&$y=="Info"&&preg_match("~Query|Killed~",$K["Command"])&&$X!="")||(JUSH=="pgsql"&&$y=="current_query"&&$X!="<IDLE>")||(JUSH=="oracle"&&$y=="sql_text"&&$X!="")?"<code class='jush-".JUSH."'>".shorten_utf8($X,100,"</code>").' <a href="'.h(ME.($K["db"]!=""?"db=".urlencode($K["db"])."&":"")."sql=".urlencode($X)).'">'.lang(261).'</a>':h($X));echo"\n";}echo'</table>
</div>
<p>
';if(support("kill"))echo($t+1)."/".lang(262,max_connections()),"<p><input type='submit' value='".lang(263)."'>\n";echo
input_token(),'</form>
',script("tableCheck();");}elseif(isset($_GET["select"])){$a=$_GET["select"];$S=table_status1($a);$x=indexes($a);$o=fields($a);$nd=column_foreign_keys($a);$Qf=$S["Oid"];$pa=get_settings("adminer_import");$Bh=array();$e=array();$Ph=array();$ig=array();$Si="";foreach($o
as$y=>$n){$B=adminer()->fieldName($n);$Cf=html_entity_decode(strip_tags($B),ENT_QUOTES);if(isset($n["privileges"]["select"])&&$B!=""){$e[$y]=$Cf;if(is_shortable($n))$Si=adminer()->selectLengthProcess();}if(isset($n["privileges"]["where"])&&$B!="")$Ph[$y]=$Cf;if(isset($n["privileges"]["order"])&&$B!="")$ig[$y]=$Cf;$Bh+=$n["privileges"];}list($M,$yd)=adminer()->selectColumnsProcess($e,$x);$M=array_unique($M);$yd=array_unique($yd);$we=count($yd)<count($M);$Z=adminer()->selectSearchProcess($o,$x);$hg=adminer()->selectOrderProcess($o,$x);$z=adminer()->selectLimitProcess();if($_GET["val"]&&is_ajax()){header("Content-Type: text/plain; charset=utf-8");foreach($_GET["val"]as$wj=>$K){$ya=convert_field($o[key($K)]);$M=array($ya?:idf_escape(key($K)));$Z[]=where_check($wj,$o);$J=driver()->select($a,$M,$Z,$M);if($J)echo
first($J->fetch_row());}exit;}$G=$yj=array();foreach($x
as$w){if($w["type"]=="PRIMARY"){$G=array_flip($w["columns"]);$yj=($M?$G:array());foreach($yj
as$y=>$X){if(in_array(idf_escape($y),$M))unset($yj[$y]);}break;}}if($Qf&&!$G){$G=$yj=array($Qf=>0);$x[]=array("type"=>"PRIMARY","columns"=>array($Qf));}if($_POST&&!$m){$Vj=$Z;if(!$_POST["all"]&&is_array($_POST["check"])){$cb=array();foreach($_POST["check"]as$Ya)$cb[]=where_check($Ya,$o);$Vj[]="((".implode(") OR (",$cb)."))";}$Vj=($Vj?"\nWHERE ".implode(" AND ",$Vj):"");if($_POST["export"]){save_settings(array("output"=>$_POST["output"],"format"=>$_POST["format"]),"adminer_import");dump_headers($a);adminer()->dumpTable($a,"");$rd=($M?implode(", ",$M):"*").convert_fields($e,$o,$M)."\nFROM ".table($a);$_d=($yd&&$we?"\nGROUP BY ".implode(", ",$yd):"").($hg?"\nORDER BY ".implode(", ",$hg):"");$H="SELECT $rd$Vj$_d";if(is_array($_POST["check"])&&!$G){$uj=array();foreach($_POST["check"]as$X)$uj[]="(SELECT".limit($rd,"\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o).$_d,1).")";$H=implode(" UNION ALL ",$uj);}adminer()->dumpData($a,"table",$H);adminer()->dumpFooter();exit;}if(!adminer()->selectEmailProcess($Z,$nd)){if($_POST["save"]||$_POST["delete"]){$I=true;$qa=0;$O=array();if(!$_POST["delete"]){foreach($_POST["fields"]as$B=>$X){$X=process_input($o[$B]);if($X!==null&&($_POST["clone"]||$X!==false))$O[idf_escape($B)]=($X!==false?$X:idf_escape($B));}}if($_POST["delete"]||$O){$H=($_POST["clone"]?"INTO ".table($a)." (".implode(", ",array_keys($O)).")\nSELECT ".implode(", ",$O)."\nFROM ".table($a):"");if($_POST["all"]||($G&&is_array($_POST["check"]))||$we){$I=($_POST["delete"]?driver()->delete($a,$Vj):($_POST["clone"]?queries("INSERT $H$Vj".driver()->insertReturning($a)):driver()->update($a,$O,$Vj)));$qa=connection()->affected_rows;if(is_object($I))$qa+=$I->num_rows;}else{foreach((array)$_POST["check"]as$X){$Uj="\nWHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($X,$o);$I=($_POST["delete"]?driver()->delete($a,$Uj,1):($_POST["clone"]?queries("INSERT".limit1($a,$H,$Uj)):driver()->update($a,$O,$Uj,1)));if(!$I)break;$qa+=connection()->affected_rows;}}}$pf=lang(264,$qa);if($_POST["clone"]&&$I&&$qa==1){$Me=last_id($I);if($Me)$pf=lang(176," $Me");}queries_redirect(remove_from_uri($_POST["all"]&&$_POST["delete"]?"page":""),$pf,$I);if(!$_POST["delete"]){$Ug=(array)$_POST["fields"];edit_form($a,array_intersect_key($o,$Ug),$Ug,!$_POST["clone"],$m);page_footer();exit;}}elseif(!$_POST["import"]){if(!$_POST["val"])$m=lang(265);else{$I=true;$qa=0;foreach($_POST["val"]as$wj=>$K){$O=array();foreach($K
as$y=>$X){$y=bracket_escape($y,true);$O[idf_escape($y)]=(preg_match('~char|text~',$o[$y]["type"])||$X!=""?adminer()->processInput($o[$y],$X):"NULL");}$I=driver()->update($a,$O," WHERE ".($Z?implode(" AND ",$Z)." AND ":"").where_check($wj,$o),($we||$G?0:1)," ");if(!$I)break;$qa+=connection()->affected_rows;}queries_redirect(remove_from_uri(),lang(264,$qa),$I);}}elseif(!is_string($bd=get_file("csv_file",true)))$m=upload_error($bd);elseif(!preg_match('~~u',$bd))$m=lang(266);else{save_settings(array("output"=>$pa["output"],"format"=>$_POST["separator"]),"adminer_import");$I=true;$mb=array_keys($o);preg_match_all('~(?>"[^"]*"|[^"\r\n]+)+~',$bd,$df);$qa=count($df[0]);driver()->begin();$Vh=($_POST["separator"]=="csv"?",":($_POST["separator"]=="tsv"?"\t":";"));$L=array();foreach($df[0]as$y=>$X){preg_match_all("~((?>\"[^\"]*\")+|[^$Vh]*)$Vh~",$X.$Vh,$ef);if(!$y&&!array_diff($ef[1],$mb)){$mb=$ef[1];$qa--;}else{$O=array();foreach($ef[1]as$t=>$jb)$O[idf_escape($mb[$t])]=($jb==""&&$o[$mb[$t]]["null"]?"NULL":q(preg_match('~^".*"$~s',$jb)?str_replace('""','"',substr($jb,1,-1)):$jb));$L[]=$O;}}$I=(!$L||driver()->insertUpdate($a,$L,$G));if($I)driver()->commit();queries_redirect(remove_from_uri("page"),lang(267,$qa),$I);driver()->rollback();}}}$Di=adminer()->tableName($S);if(is_ajax()){page_headers();ob_start();}else
page_header(lang(51).": $Di",$m);$O=null;if(isset($Bh["insert"])||!support("table")){$zg=array();foreach((array)$_GET["where"]as$X){if(isset($nd[$X["col"]])&&count($nd[$X["col"]])==1&&($X["op"]=="="||(!$X["op"]&&(is_array($X["val"])||!preg_match('~[_%]~',$X["val"])))))$zg["set"."[".bracket_escape($X["col"])."]"]=$X["val"];}$O=$zg?"&".http_build_query($zg):"";}adminer()->selectLinks($S,$O);if(!$e&&support("table"))echo"<p class='error'>".lang(268).($o?".":": ".error())."\n";else{echo"<form action='' id='form'>\n","<div style='display: none;'>";hidden_fields_get();echo(DB!=""?input_hidden("db",DB).(isset($_GET["ns"])?input_hidden("ns",$_GET["ns"]):""):""),input_hidden("select",$a),"</div>\n";adminer()->selectColumnsPrint($M,$e);adminer()->selectSearchPrint($Z,$Ph,$x);adminer()->selectOrderPrint($hg,$ig,$x);adminer()->selectLimitPrint($z);adminer()->selectLengthPrint($Si);adminer()->selectActionPrint($x);echo"</form>\n";$D=$_GET["page"];$qd=null;if($D=="last"){$qd=get_val(count_rows($a,$Z,$we,$yd));$D=floor(max(0,intval($qd)-1)/$z);}$Qh=$M;$zd=$yd;if(!$Qh){$Qh[]="*";$Cb=convert_fields($e,$o,$M);if($Cb)$Qh[]=substr($Cb,2);}foreach($M
as$y=>$X){$n=$o[idf_unescape($X)];if($n&&($ya=convert_field($n)))$Qh[$y]="$ya AS $X";}if(!$we&&$yj){foreach($yj
as$y=>$X){$Qh[]=idf_escape($y);if($zd)$zd[]=idf_escape($y);}}$I=driver()->select($a,$Qh,$Z,$zd,$hg,$z,$D,true);if(!$I)echo"<p class='error'>".error()."\n";else{if(JUSH=="mssql"&&$D)$I->seek($z*$D);$xc=array();echo"<form action='' method='post' enctype='multipart/form-data'>\n";$L=array();while($K=$I->fetch_assoc()){if($D&&JUSH=="oracle")unset($K["RNUM"]);$L[]=$K;}if($_GET["page"]!="last"&&$z&&$yd&&$we&&JUSH=="sql")$qd=get_val(" SELECT FOUND_ROWS()");if(!$L)echo"<p class='message'>".lang(12)."\n";else{$Ga=adminer()->backwardKeys($a,$Di);echo"<div class='scrollable'>","<table id='table' class='nowrap checkable odds'>",script("mixin(qs('#table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true), onkeydown: editingKeydown});"),"<thead><tr>".(!$yd&&$M?"":"<td><input type='checkbox' id='all-page' class='jsonly'>".script("qs('#all-page').onclick = partial(formCheck, /check/);","")." <a href='".h($_GET["modify"]?remove_from_uri("modify"):$_SERVER["REQUEST_URI"]."&modify=1")."'>".lang(269)."</a>");$Df=array();$td=array();reset($M);$mh=1;foreach($L[0]as$y=>$X){if(!isset($yj[$y])){$X=idx($_GET["columns"],key($M))?:array();$n=$o[$M?($X?$X["col"]:current($M)):$y];$B=($n?adminer()->fieldName($n,$mh):($X["fun"]?"*":h($y)));if($B!=""){$mh++;$Df[$y]=$B;$d=idf_escape($y);$Pd=remove_from_uri('(order|desc)[^=]*|page').'&order%5B0%5D='.urlencode($y);$ac="&desc%5B0%5D=1";echo"<th id='th[".h(bracket_escape($y))."]'>".script("mixin(qsl('th'), {onmouseover: partial(columnMouse), onmouseout: partial(columnMouse, ' hidden')});","");$sd=apply_sql_function($X["fun"],$B);$ii=isset($n["privileges"]["order"])||$sd;echo($ii?"<a href='".h($Pd.($hg[0]==$d||$hg[0]==$y?$ac:''))."'>$sd</a>":$sd),"<span class='column hidden'>";if($ii)echo"<a href='".h($Pd.$ac)."' title='".lang(57)."' class='text'> ↓</a>";if(!$X["fun"]&&isset($n["privileges"]["where"]))echo'<a href="#fieldset-search" title="'.lang(54).'" class="text jsonly"> =</a>',script("qsl('a').onclick = partial(selectSearch, '".js_escape($y)."');");echo"</span>";}$td[$y]=$X["fun"];next($M);}}$Se=array();if($_GET["modify"]){foreach($L
as$K){foreach($K
as$y=>$X)$Se[$y]=max($Se[$y],min(40,strlen(utf8_decode($X))));}}echo($Ga?"<th>".lang(270):"")."</thead>\n";if(is_ajax())ob_end_clean();foreach(adminer()->rowDescriptions($L,$nd)as$Bf=>$K){$vj=unique_array($L[$Bf],$x);if(!$vj){$vj=array();reset($M);foreach($L[$Bf]as$y=>$X){if(!preg_match('~^(COUNT|AVG|GROUP_CONCAT|MAX|MIN|SUM)\(~',current($M)))$vj[$y]=$X;next($M);}}$wj="";foreach($vj
as$y=>$X){$n=(array)$o[$y];if((JUSH=="sql"||JUSH=="pgsql")&&preg_match('~char|text|enum|set~',$n["type"])&&strlen($X)>64){$y=(strpos($y,'(')?$y:idf_escape($y));$y="MD5(".(JUSH!='sql'||preg_match("~^utf8~",$n["collation"])?$y:"CONVERT($y USING ".charset(connection()).")").")";$X=md5($X);}$wj
.="&".($X!==null?urlencode("where[".bracket_escape($y)."]")."=".urlencode($X===false?"f":$X):"null%5B%5D=".urlencode($y));}echo"<tr>".(!$yd&&$M?"":"<td>".checkbox("check[]",substr($wj,1),in_array(substr($wj,1),(array)$_POST["check"])).($we||information_schema(DB)?"":" <a href='".h(ME."edit=".urlencode($a).$wj)."' class='edit'>".lang(271)."</a>"));reset($M);foreach($K
as$y=>$X){if(isset($Df[$y])){$d=current($M);$n=(array)$o[$y];$X=driver()->value($X,$n);if($X!=""&&(!isset($xc[$y])||$xc[$y]!=""))$xc[$y]=(is_mail($X)?$Df[$y]:"");$_="";if(is_blob($n)&&$X!="")$_=ME.'download='.urlencode($a).'&field='.urlencode($y).$wj;if(!$_&&$X!==null){foreach((array)$nd[$y]as$q){if(count($nd[$y])==1||end($q["source"])==$y){$_="";foreach($q["source"]as$t=>$ji)$_
.=where_link($t,$q["target"][$t],$L[$Bf][$ji]);$_=($q["db"]!=""?preg_replace('~([?&]db=)[^&]+~','\1'.urlencode($q["db"]),ME):ME).'select='.urlencode($q["table"]).$_;if($q["ns"])$_=preg_replace('~([?&]ns=)[^&]+~','\1'.urlencode($q["ns"]),$_);if(count($q["source"])==1)break;}}}if($d=="COUNT(*)"){$_=ME."select=".urlencode($a);$t=0;foreach((array)$_GET["where"]as$W){if(!array_key_exists($W["col"],$vj))$_
.=where_link($t++,$W["col"],$W["val"],$W["op"]);}foreach($vj
as$Ce=>$W)$_
.=where_link($t++,$Ce,$W);}$Qd=select_value($X,$_,$n,$Si);$u=h("val[$wj][".bracket_escape($y)."]");$Vg=idx(idx($_POST["val"],$wj),bracket_escape($y));$sc=!is_array($K[$y])&&is_utf8($Qd)&&$L[$Bf][$y]==$K[$y]&&!$td[$y]&&!$n["generated"];$U=(preg_match('~^(AVG|MIN|MAX)\((.+)\)~',$d,$A)?$o[idf_unescape($A[2])]["type"]:$n["type"]);$Qi=preg_match('~text|json|lob~',$U);$xe=preg_match(number_type(),$U)||preg_match('~^(CHAR_LENGTH|ROUND|FLOOR|CEIL|TIME_TO_SEC|COUNT|SUM)\(~',$d);echo"<td id='$u'".($xe&&($X===null||is_numeric(strip_tags($Qd))||$U=="money")?" class='number'":"");if(($_GET["modify"]&&$sc&&$X!==null)||$Vg!==null){$Cd=h($Vg!==null?$Vg:$K[$y]);echo">".($Qi?"<textarea name='$u' cols='30' rows='".(substr_count($K[$y],"\n")+1)."'>$Cd</textarea>":"<input name='$u' value='$Cd' size='$Se[$y]'>");}else{$Ye=strpos($Qd,"<i>…</i>");echo" data-text='".($Ye?2:($Qi?1:0))."'".($sc?"":" data-warning='".h(lang(272))."'").">$Qd";}}next($M);}if($Ga)echo"<td>";adminer()->backwardKeysPrint($Ga,$L[$Bf]);echo"</tr>\n";}if(is_ajax())exit;echo"</table>\n","</div>\n";}if(!is_ajax()){if($L||$D){$Kc=true;if($_GET["page"]!="last"){if(!$z||(count($L)<$z&&($L||!$D)))$qd=($D?$D*$z:0)+count($L);elseif(JUSH!="sql"||!$we){$qd=($we?false:found_rows($S,$Z));if(intval($qd)<max(1e4,2*($D+1)*$z))$qd=first(slow_query(count_rows($a,$Z,$we,$yd)));else$Kc=false;}}$xg=($z&&($qd===false||$qd>$z||$D));if($xg)echo(($qd===false?count($L)+1:$qd-$D*$z)>$z?'<p><a href="'.h(remove_from_uri("page")."&page=".($D+1)).'" class="loadmore">'.lang(273).'</a>'.script("qsl('a').onclick = partial(selectLoadMore, $z, '".lang(274)."…');",""):''),"\n";echo"<div class='footer'><div>\n";if($xg){$if=($qd===false?$D+(count($L)>=$z?2:1):floor(($qd-1)/$z));echo"<fieldset>";if(JUSH!="simpledb"){echo"<legend><a href='".h(remove_from_uri("page"))."'>".lang(275)."</a></legend>",script("qsl('a').onclick = function () { pageClick(this.href, +prompt('".lang(275)."', '".($D+1)."')); return false; };"),pagination(0,$D).($D>5?" …":"");for($t=max(1,$D-4);$t<min($if,$D+5);$t++)echo
pagination($t,$D);if($if>0)echo($D+5<$if?" …":""),($Kc&&$qd!==false?pagination($if,$D):" <a href='".h(remove_from_uri("page")."&page=last")."' title='~$if'>".lang(276)."</a>");}else
echo"<legend>".lang(275)."</legend>",pagination(0,$D).($D>1?" …":""),($D?pagination($D,$D):""),($if>$D?pagination($D+1,$D).($if>$D+1?" …":""):"");echo"</fieldset>\n";}echo"<fieldset>","<legend>".lang(277)."</legend>";$hc=($Kc?"":"~ ").$qd;$ag="const checked = formChecked(this, /check/); selectCount('selected', this.checked ? '$hc' : checked); selectCount('selected2', this.checked || !checked ? '$hc' : checked);";echo
checkbox("all",1,0,($qd!==false?($Kc?"":"~ ").lang(157,$qd):""),$ag)."\n","</fieldset>\n";if(adminer()->selectCommandPrint())echo'<fieldset',($_GET["modify"]?'':' class="jsonly"'),'><legend>',lang(269),'</legend><div>
<input type="submit" value="',lang(14),'"',($_GET["modify"]?'':' title="'.lang(265).'"'),'>
</div></fieldset>
<fieldset><legend>',lang(129),' <span id="selected"></span></legend><div>
<input type="submit" name="edit" value="',lang(10),'">
<input type="submit" name="clone" value="',lang(261),'">
<input type="submit" name="delete" value="',lang(18),'">',confirm(),'</div></fieldset>
';$od=adminer()->dumpFormat();foreach((array)$_GET["columns"]as$d){if($d["fun"]){unset($od['sql']);break;}}if($od){print_fieldset("export",lang(74)." <span id='selected2'></span>");$ug=adminer()->dumpOutput();echo($ug?html_select("output",$ug,$pa["output"])." ":""),html_select("format",$od,$pa["format"])," <input type='submit' name='export' value='".lang(74)."'>\n","</div></fieldset>\n";}adminer()->selectEmailPrint(array_filter($xc,'strlen'),$e);echo"</div></div>\n";}if(adminer()->selectImportPrint())echo"<p>","<a href='#import'>".lang(73)."</a>",script("qsl('a').onclick = partial(toggle, 'import');",""),"<span id='import'".($_POST["import"]?"":" class='hidden'").">: ","<input type='file' name='csv_file'> ",html_select("separator",array("csv"=>"CSV,","csv;"=>"CSV;","tsv"=>"TSV"),$pa["format"])," <input type='submit' name='import' value='".lang(73)."'>","</span>";echo
input_token(),"</form>\n",(!$yd&&$M?"":script("tableCheck();"));}}}if(is_ajax()){ob_end_clean();exit;}}elseif(isset($_GET["variables"])){$P=isset($_GET["status"]);page_header($P?lang(121):lang(120));$Lj=($P?show_status():show_variables());if(!$Lj)echo"<p class='message'>".lang(12)."\n";else{echo"<table>\n";foreach($Lj
as$K){echo"<tr>";$y=array_shift($K);echo"<th><code class='jush-".JUSH.($P?"status":"set")."'>".h($y)."</code>";foreach($K
as$X)echo"<td>".nl_br(h($X));}echo"</table>\n";}}elseif(isset($_GET["script"])){header("Content-Type: text/javascript; charset=utf-8");if($_GET["script"]=="db"){$_i=array("Data_length"=>0,"Index_length"=>0,"Data_free"=>0);foreach(table_status()as$B=>$S){json_row("Comment-$B",h($S["Comment"]));if(!is_view($S)||preg_match('~materialized~i',$S["Engine"])){foreach(array("Engine","Collation")as$y)json_row("$y-$B",h($S[$y]));foreach($_i+array("Auto_increment"=>0,"Rows"=>0)as$y=>$X){if($S[$y]!=""){$X=format_number($S[$y]);if($X>=0)json_row("$y-$B",($y=="Rows"&&$X&&$S["Engine"]==(JUSH=="pgsql"?"table":"InnoDB")?"~ $X":$X));if(isset($_i[$y]))$_i[$y]+=($S["Engine"]!="InnoDB"||$y!="Data_free"?$S[$y]:0);}elseif(array_key_exists($y,$S))json_row("$y-$B","?");}}}foreach($_i
as$y=>$X)json_row("sum-$y",format_number($X));json_row("");}elseif($_GET["script"]=="kill")connection()->query("KILL ".number($_POST["kill"]));else{foreach(count_tables(adminer()->databases())as$k=>$X){json_row("tables-$k",$X);json_row("size-$k",db_size($k));}json_row("");}exit;}else{$Ki=array_merge((array)$_POST["tables"],(array)$_POST["views"]);if($Ki&&!$m&&!$_POST["search"]){$I=true;$pf="";if(JUSH=="sql"&&$_POST["tables"]&&count($_POST["tables"])>1&&($_POST["drop"]||$_POST["truncate"]||$_POST["copy"]))queries("SET foreign_key_checks = 0");if($_POST["truncate"]){if($_POST["tables"])$I=truncate_tables($_POST["tables"]);$pf=lang(278);}elseif($_POST["move"]){$I=move_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$pf=lang(279);}elseif($_POST["copy"]){$I=copy_tables((array)$_POST["tables"],(array)$_POST["views"],$_POST["target"]);$pf=lang(280);}elseif($_POST["drop"]){if($_POST["views"])$I=drop_views($_POST["views"]);if($I&&$_POST["tables"])$I=drop_tables($_POST["tables"]);$pf=lang(281);}elseif(JUSH=="sqlite"&&$_POST["check"]){foreach((array)$_POST["tables"]as$R){foreach(get_rows("PRAGMA integrity_check(".q($R).")")as$K)$pf
.="<b>".h($R)."</b>: ".h($K["integrity_check"])."<br>";}}elseif(JUSH!="sql"){$I=(JUSH=="sqlite"?queries("VACUUM"):apply_queries("VACUUM".($_POST["optimize"]?"":" ANALYZE"),$_POST["tables"]));$pf=lang(282);}elseif(!$_POST["tables"])$pf=lang(9);elseif($I=queries(($_POST["optimize"]?"OPTIMIZE":($_POST["check"]?"CHECK":($_POST["repair"]?"REPAIR":"ANALYZE")))." TABLE ".implode(", ",array_map('Adminer\idf_escape',$_POST["tables"])))){while($K=$I->fetch_assoc())$pf
.="<b>".h($K["Table"])."</b>: ".h($K["Msg_text"])."<br>";}queries_redirect(substr(ME,0,-1),$pf,$I);}page_header(($_GET["ns"]==""?lang(35).": ".h(DB):lang(77).": ".h($_GET["ns"])),$m,true);if(adminer()->homepage()){if($_GET["ns"]!==""){echo"<h3 id='tables-views'>".lang(283)."</h3>\n";$Ji=tables_list();if(!$Ji)echo"<p class='message'>".lang(9)."\n";else{echo"<form action='' method='post'>\n";if(support("table")){echo"<fieldset><legend>".lang(284)." <span id='selected2'></span></legend><div>",html_select("op",adminer()->operators(),idx($_POST,"op",JUSH=="elastic"?"should":"LIKE %%"))," <input type='search' name='query' value='".h($_POST["query"])."'>",script("qsl('input').onkeydown = partialArg(bodyKeydown, 'search');","")," <input type='submit' name='search' value='".lang(54)."'>\n","</div></fieldset>\n";if($_POST["search"]&&$_POST["query"]!=""){$_GET["where"][0]["op"]=$_POST["op"];search_tables();}}echo"<div class='scrollable'>\n","<table class='nowrap checkable odds'>\n",script("mixin(qsl('table'), {onclick: tableClick, ondblclick: partialArg(tableClick, true)});"),'<thead><tr class="wrap">','<td><input id="check-all" type="checkbox" class="jsonly">'.script("qs('#check-all').onclick = partial(formCheck, /^(tables|views)\[/);",""),'<th>'.lang(136),'<td>'.lang(285).doc_link(array('sql'=>'storage-engines.html')),'<td>'.lang(125).doc_link(array('sql'=>'charset-charsets.html','mariadb'=>'supported-character-sets-and-collations/')),'<td>'.lang(286).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT','oracle'=>'REFRN20286')),'<td>'.lang(287).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-admin.html#FUNCTIONS-ADMIN-DBOBJECT')),'<td>'.lang(288).doc_link(array('sql'=>'show-table-status.html')),'<td>'.lang(49).doc_link(array('sql'=>'example-auto-increment.html','mariadb'=>'auto_increment/')),'<td>'.lang(289).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'catalog-pg-class.html#CATALOG-PG-CLASS','oracle'=>'REFRN20286')),(support("comment")?'<td>'.lang(48).doc_link(array('sql'=>'show-table-status.html','pgsql'=>'functions-info.html#FUNCTIONS-INFO-COMMENT-TABLE')):''),"</thead>\n";$T=0;foreach($Ji
as$B=>$U){$Oj=($U!==null&&!preg_match('~table|sequence~i',$U));$u=h("Table-".$B);echo'<tr><td>'.checkbox(($Oj?"views[]":"tables[]"),$B,in_array("$B",$Ki,true),"","","",$u),'<th>'.(support("table")||support("indexes")?"<a href='".h(ME)."table=".urlencode($B)."' title='".lang(40)."' id='$u'>".h($B).'</a>':h($B));if($Oj&&!preg_match('~materialized~i',$U)){$Wi=lang(135);echo'<td colspan="6">'.(support("view")?"<a href='".h(ME)."view=".urlencode($B)."' title='".lang(42)."'>$Wi</a>":$Wi),'<td align="right"><a href="'.h(ME)."select=".urlencode($B).'" title="'.lang(39).'">?</a>';}else{foreach(array("Engine"=>array(),"Collation"=>array(),"Data_length"=>array("create",lang(41)),"Index_length"=>array("indexes",lang(139)),"Data_free"=>array("edit",lang(43)),"Auto_increment"=>array("auto_increment=1&create",lang(41)),"Rows"=>array("select",lang(39)),)as$y=>$_){$u=" id='$y-".h($B)."'";echo($_?"<td align='right'>".(support("table")||$y=="Rows"||(support("indexes")&&$y!="Data_length")?"<a href='".h(ME."$_[0]=").urlencode($B)."'$u title='$_[1]'>?</a>":"<span$u>?</span>"):"<td id='$y-".h($B)."'>");}$T++;}echo(support("comment")?"<td id='Comment-".h($B)."'>":""),"\n";}echo"<tr><td><th>".lang(262,count($Ji)),"<td>".h(JUSH=="sql"?get_val("SELECT @@default_storage_engine"):""),"<td>".h(db_collation(DB,collations()));foreach(array("Data_length","Index_length","Data_free")as$y)echo"<td align='right' id='sum-$y'>";echo"\n","</table>\n",script("ajaxSetHtml('".js_escape(ME)."script=db');"),"</div>\n";if(!information_schema(DB)){echo"<div class='footer'><div>\n";$Ij="<input type='submit' value='".lang(290)."'> ".on_help("'VACUUM'");$dg="<input type='submit' name='optimize' value='".lang(291)."'> ".on_help(JUSH=="sql"?"'OPTIMIZE TABLE'":"'VACUUM OPTIMIZE'");echo"<fieldset><legend>".lang(129)." <span id='selected'></span></legend><div>".(JUSH=="sqlite"?$Ij."<input type='submit' name='check' value='".lang(292)."'> ".on_help("'PRAGMA integrity_check'"):(JUSH=="pgsql"?$Ij.$dg:(JUSH=="sql"?"<input type='submit' value='".lang(293)."'> ".on_help("'ANALYZE TABLE'").$dg."<input type='submit' name='check' value='".lang(292)."'> ".on_help("'CHECK TABLE'")."<input type='submit' name='repair' value='".lang(294)."'> ".on_help("'REPAIR TABLE'"):"")))."<input type='submit' name='truncate' value='".lang(295)."'> ".on_help(JUSH=="sqlite"?"'DELETE'":"'TRUNCATE".(JUSH=="pgsql"?"'":" TABLE'")).confirm()."<input type='submit' name='drop' value='".lang(130)."'>".on_help("'DROP TABLE'").confirm()."\n";$j=(support("scheme")?adminer()->schemas():adminer()->databases());echo"</div></fieldset>\n";$Nh="";if(count($j)!=1&&JUSH!="sqlite"){echo"<fieldset><legend>".lang(296)." <span id='selected3'></span></legend><div>";$k=(isset($_POST["target"])?$_POST["target"]:(support("scheme")?$_GET["ns"]:DB));echo($j?html_select("target",$j,$k):'<input name="target" value="'.h($k).'" autocapitalize="off">'),"</label> <input type='submit' name='move' value='".lang(297)."'>",(support("copy")?" <input type='submit' name='copy' value='".lang(298)."'> ".checkbox("overwrite",1,$_POST["overwrite"],lang(299)):""),"</div></fieldset>\n";$Nh=" selectCount('selected3', formChecked(this, /^(tables|views)\[/));";}echo"<input type='hidden' name='all' value=''>",script("qsl('input').onclick = function () { selectCount('selected', formChecked(this, /^(tables|views)\[/));".(support("table")?" selectCount('selected2', formChecked(this, /^tables\[/) || $T);":"")."$Nh }"),input_token(),"</div></div>\n";}echo"</form>\n",script("tableCheck();");}echo"<p class='links'><a href='".h(ME)."create='>".lang(75)."</a>\n",(support("view")?"<a href='".h(ME)."view='>".lang(215)."</a>\n":"");if(support("routine")){echo"<h3 id='routines'>".lang(70)."</h3>\n";$Fh=routines();if($Fh){echo"<table class='odds'>\n",'<thead><tr><th>'.lang(193).'<td>'.lang(47).'<td>'.lang(232)."<td></thead>\n";foreach($Fh
as$K){$B=($K["SPECIFIC_NAME"]==$K["ROUTINE_NAME"]?"":"&name=".urlencode($K["ROUTINE_NAME"]));echo'<tr>','<th><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'callf=':'call=').urlencode($K["SPECIFIC_NAME"]).$B).'">'.h($K["ROUTINE_NAME"]).'</a>','<td>'.h($K["ROUTINE_TYPE"]),'<td>'.h($K["DTD_IDENTIFIER"]),'<td><a href="'.h(ME.($K["ROUTINE_TYPE"]!="PROCEDURE"?'function=':'procedure=').urlencode($K["SPECIFIC_NAME"]).$B).'">'.lang(142)."</a>";}echo"</table>\n";}echo'<p class="links">'.(support("procedure")?'<a href="'.h(ME).'procedure=">'.lang(231).'</a>':'').'<a href="'.h(ME).'function=">'.lang(230)."</a>\n";}if(support("sequence")){echo"<h3 id='sequences'>".lang(71)."</h3>\n";$Yh=get_vals("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema = current_schema() ORDER BY sequence_name");if($Yh){echo"<table class='odds'>\n","<thead><tr><th>".lang(193)."</thead>\n";foreach($Yh
as$X)echo"<tr><th><a href='".h(ME)."sequence=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."sequence='>".lang(237)."</a>\n";}if(support("type")){echo"<h3 id='user-types'>".lang(6)."</h3>\n";$Gj=types();if($Gj){echo"<table class='odds'>\n","<thead><tr><th>".lang(193)."</thead>\n";foreach($Gj
as$X)echo"<tr><th><a href='".h(ME)."type=".urlencode($X)."'>".h($X)."</a>\n";echo"</table>\n";}echo"<p class='links'><a href='".h(ME)."type='>".lang(241)."</a>\n";}if(support("event")){echo"<h3 id='events'>".lang(72)."</h3>\n";$L=get_rows("SHOW EVENTS");if($L){echo"<table>\n","<thead><tr><th>".lang(193)."<td>".lang(300)."<td>".lang(221)."<td>".lang(222)."<td></thead>\n";foreach($L
as$K)echo"<tr>","<th>".h($K["Name"]),"<td>".($K["Execute at"]?lang(301)."<td>".$K["Execute at"]:lang(223)." ".$K["Interval value"]." ".$K["Interval field"]."<td>$K[Starts]"),"<td>$K[Ends]",'<td><a href="'.h(ME).'event='.urlencode($K["Name"]).'">'.lang(142).'</a>';echo"</table>\n";$Ic=get_val("SELECT @@event_scheduler");if($Ic&&$Ic!="ON")echo"<p class='error'><code class='jush-sqlset'>event_scheduler</code>: ".h($Ic)."\n";}echo'<p class="links"><a href="'.h(ME).'event=">'.lang(220)."</a>\n";}}}}page_footer();